#ifndef LILIB_H
#define LILIB_H

#include <iostream>
#include <cstdint>

// CuŜŋp萔EϐE֐
namespace lilib{

  // double lǂݍݗp̋p
  typedef union{
    double d;
    uint64_t i;
  } binary64;

  extern const int LIMB_BITS;			// 1 limb ̃rbg
  extern const int LIMBS_MIN;			// limbs ̍ŏl
  extern const double DOUBLE_0x100000000;	// 0x100000000

  extern int limbs;				// { limbs AݒԂ 0

  uint32_t high32(uint64_t x);			// 64 rbg̏ 32 rbg
  uint32_t low32(uint64_t x);			// 64 rbg̉ 32 rbg
  int normalize64(uint64_t *x);			// 64 rbg̐K

  void setPrecision(int precision);		// {̐x̐ݒ
  int getPrecision();				// {̐x̎擾Aݒ̂Ƃ 0 Ԃ

  void setRound(int round);			// {xZ̊ۂߕ̐ݒ
  int getRound();				// {xZ̊ۂߕ̎擾
}

class Radius;			// ԔaNX
class LongFloat;		// {NX
class LongDecimal;		// {NX(10 i)
class LongInterval;		// {ԃNX
class LongMatrix;		// {sNX
class LongIntervalMatrix;	// {ԍsNX

////////////////////////////////////////////////////////////////////////////////

// ԔaNX
class Radius{
  private:
    uint32_t significand;				// 
    int exponent;					// w

    void div(const LongFloat &a, const LongFloat &b);	// *this = |a / b|

  public:
    Radius();						// RXgN^
    Radius(uint32_t significand, int exponent);		// RXgN^
    Radius(double x);					// RXgN^
    Radius(const Radius &x);				// Rs[RXgN^
    Radius(const LongFloat &x);				// RXgN^
    ~Radius();						// fXgN^

    double getDouble() const;				// double ւ̕ϊ
    std::string getString() const;			// ւ̕ϊ
    std::string getInternalData() const;		// f[^\̎擾

    Radius operator *(int x) const;			// Radius * int
    Radius operator /(int x) const;			// Radius / int
    Radius operator +(const Radius &x) const;		// Radius + Radius
    Radius operator *(const Radius &x) const;		// Radius * Radius

    bool operator ==(const Radius &x) const;		// Radius == Radius
    bool operator !=(const Radius &x) const;		// Radius != Radius

    Radius &operator *=(int x);				// Radius *= int
    Radius &operator /=(int x);				// Radius /= int
    Radius &operator =(const Radius &x);		// Radius = Radius
    Radius &operator +=(const Radius &x);		// Radius += Radius
    Radius &operator *=(const Radius &x);		// Radius *= Radius

  friend Radius operator *(int a, const Radius &b);	// int * Radius

  friend class LongFloat;				// {NX
  friend class LongInterval;				// {ԃNX

  friend LongInterval sqrt(const LongInterval &x);	// 
};

// std::ostream << Radius
std::ostream &operator <<(std::ostream &output, const Radius &x);

////////////////////////////////////////////////////////////////////////////////

// {NX
class LongFloat{
  private:
    int sign;							// 
    uint32_t *limb;						// ւ̃|C^
    int exponent;						// w

    void normalize();						// ̐K
    void increase();						// ŉʃrbg 1 
    void decrease();						// ŉʃrbg 1 

    void copy(const LongFloat &x, int size);			// limb ̈قȂ LongFloat 

    int compareAbs(const LongFloat &x) const;			// |*this|  |x| ̔r

    void addAbs(const LongFloat &a, const LongFloat &b);	// *this = |a| + |b|
    void subAbs(const LongFloat &a, const LongFloat &b);	// *this = |a| - |b|

    void mul(const Radius &a, const Radius &b);			// *this = a * b

    void inverse(const LongFloat &x);				// *this = 1 / x

    void mul(const LongFloat &a, int b);			// *this = a * b
    void div(const LongFloat &a, int b);			// *this = a / b

    void add(const LongFloat &a, const LongFloat &b);		// *this = a + b
    void sub(const LongFloat &a, const LongFloat &b);		// *this = a - b
    void mul(const LongFloat &a, const LongFloat &b);		// *this = a * b

    LongFloat sqrtInf() const;					// Łiւ̊ۂ߁j

  public:
    LongFloat();						// RXgN^
    LongFloat(int x);						// RXgN^
    LongFloat(double x);					// RXgN^
    LongFloat(const Radius &x);					// RXgN^
    LongFloat(const LongFloat &x);				// Rs[RXgN^
    ~LongFloat();						// fXgN^

    void setDouble(double x);					// double ̕ϊ

    double getDouble() const;					// double ւ̕ϊ
    double getDouble(int round) const;				// double ւ̕ϊiۂߕwj
    std::string getString() const;				// ւ̕ϊ
    std::string getLongString(int digits) const;		// ̕ւ̕ϊ
    std::string getInternalData() const;			// f[^\̎擾

    void random();						// l𗐐ɂ(eXgp)

    LongFloat operator +() const;				// +LongFloat
    LongFloat operator -() const;				// -LongFloat

    LongFloat operator +(int x) const;				// LongFloat + int
    LongFloat operator -(int x) const;				// LongFloat - int
    LongFloat operator *(int x) const;				// LongFloat * int
    LongFloat operator /(int x) const;				// LongFloat / int

    LongFloat operator *(const Radius &x) const;		// LongFloat * Radius

    LongFloat operator +(const LongFloat &x) const;		// LongFloat + LongFloat
    LongFloat operator -(const LongFloat &x) const;		// LongFloat - LongFloat
    LongFloat operator *(const LongFloat &x) const;		// LongFloat * LongFloat
    LongFloat operator /(const LongFloat &x) const;		// LongFloat / LongFloat

    LongInterval operator +(const LongInterval &x) const;	// LongFloat + LongInterval
    LongInterval operator -(const LongInterval &x) const;	// LongFloat - LongInterval
    LongInterval operator *(const LongInterval &x) const;	// LongFloat * LongInterval
    LongInterval operator /(const LongInterval &x) const;	// LongFloat / LongInterval

    LongMatrix operator +(const LongMatrix &x) const;		// LongFloat + LongMatrix
    LongMatrix operator -(const LongMatrix &x) const;		// LongFloat - LongMatrix
    LongMatrix operator *(const LongMatrix &x) const;		// LongFloat * LongMatrix
    LongMatrix operator /(const LongMatrix &x) const;		// LongFloat / LongMatrix

    LongIntervalMatrix operator +(const LongIntervalMatrix &x) const;	// LongFloat + LongIntervalMatrix
    LongIntervalMatrix operator -(const LongIntervalMatrix &x) const;	// LongFloat - LongIntervalMatrix
    LongIntervalMatrix operator *(const LongIntervalMatrix &x) const;	// LongFloat * LongIntervalMatrix
    LongIntervalMatrix operator /(const LongIntervalMatrix &x) const;	// LongFloat / LongIntervalMatrix

    bool operator ==(int x) const;				// LongFloat == int
    bool operator !=(int x) const;				// LongFloat != int
    bool operator <(int x) const;				// LongFloat < int
    bool operator >(int x) const;				// LongFloat > int
    bool operator <=(int x) const;				// LongFloat <= int
    bool operator >=(int x) const;				// LongFloat >= int

    bool operator ==(const LongFloat &x) const;			// LongFloat == LongFloat
    bool operator !=(const LongFloat &x) const;			// LongFloat != LongFloat
    bool operator <(const LongFloat &x) const;			// LongFloat < LongFloat
    bool operator >(const LongFloat &x) const;			// LongFloat > LongFloat
    bool operator <=(const LongFloat &x) const;			// LongFloat <= LongFloat
    bool operator >=(const LongFloat &x) const;			// LongFloat >= LongFloat

    int operator <(const  LongInterval &x) const;		// LongFloat < LongInterval
    int operator >(const  LongInterval &x) const;		// LongFloat > LongInterval
    int operator <=(const LongInterval &x) const;		// LongFloat <= LongInterval
    int operator >=(const LongInterval &x) const;		// LongFloat >= LongInterval

    LongFloat &operator =(int x);				// LongFloat = int
    LongFloat &operator *=(int x);				// LongFloat *= int
    LongFloat &operator /=(int x);				// LongFloat /= int

    LongFloat &operator =(const LongFloat &x);			// LongFloat = LongFloat
    LongFloat &operator +=(const LongFloat &x);			// LongFloat += LongFloat
    LongFloat &operator -=(const LongFloat &x);			// LongFloat -= LongFloat
    LongFloat &operator *=(const LongFloat &x);			// LongFloat *= LongFloat
    LongFloat &operator /=(const LongFloat &x);			// LongFloat /= LongFloat

  friend LongFloat operator +(int a, const LongFloat &b);	// int + LongFloat
  friend LongFloat operator -(int a, const LongFloat &b);	// int - LongFloat
  friend LongFloat operator *(int a, const LongFloat &b);	// int * LongFloat
  friend LongFloat operator /(int a, const LongFloat &b);	// int / LongFloat

  friend bool operator ==(int a, const LongFloat &b);		// int == LongFloat
  friend bool operator !=(int a, const LongFloat &b);		// int != LongFloat
  friend bool operator <(int a, const LongFloat &b);		// int < LongFloat
  friend bool operator >(int a, const LongFloat &b);		// int > LongFloat
  friend bool operator <=(int a, const LongFloat &b);		// int <= LongFloat
  friend bool operator >=(int a, const LongFloat &b);		// int >= LongFloat

  friend LongFloat abs(const LongFloat &x);			// Βl
  friend LongFloat pow(const LongFloat &x, int n);		// ׂ
  friend LongFloat sqrt(const LongFloat &x);			// 

  friend class Radius;						// ԔaNX
  friend class LongInterval;					// {ԃNX
  friend class LongMatrix;					// {sNX
  friend class LongIntervalMatrix;				// {ԍsNX

  friend LongInterval operator /(int a, const LongInterval &b);	// int / LongInterval
  friend LongInterval sqrt(const LongInterval &x);		// 

  friend LongMatrix abs(const LongMatrix &a);			// Βl
};

// std::ostream << LongFloat
std::ostream &operator <<(std::ostream &output, const LongFloat &x);

////////////////////////////////////////////////////////////////////////////////

// {NX(10 i)
class LongDecimal{
  private:
  public:
    int size;							// z̃TCY
    uint32_t *limb;						// ւ̃|C^
    int exponent;						// w

    LongDecimal(int n);						// RXgN^

    std::string getInternalData() const;			// f[^\̎擾
};

// std::ostream << LongDecimal
std::ostream &operator <<(std::ostream &output, const LongDecimal &x);

// {ԃNX
class LongInterval{
  private:
    LongFloat center;						// Sl
    Radius radius;						// a

    void copy(const LongInterval &x, int size);			// limb ̈قȂ LongInterval 

    void addAbs(const LongFloat &a, const LongFloat &b);	// *this = |a| + |b|
    void subAbs(const LongFloat &a, const LongFloat &b);	// *this = |a| - |b|

    void inverse(const LongInterval &x);			// *this = 1 / x

    void mul(const LongFloat &a, int b);			// *this = a * b
    void div(const LongFloat &a, int b);			// *this = a / b

    void add(const LongFloat &a, const LongFloat &b);		// *this = a + b
    void sub(const LongFloat &a, const LongFloat &b);		// *this = a - b
    void mul(const LongFloat &a, const LongFloat &b);		// *this = a * b

    LongFloat infIn() const;					// [̎擾(ւ̊ۂ)
    LongFloat supIn() const;					// [̎擾(ւ̊ۂ)

  public:
    LongInterval();						// RXgN^
    LongInterval(int x);					// RXgN^
    LongInterval(double x);					// RXgN^
    LongInterval(const LongFloat &x);				// RXgN^
    LongInterval(const LongInterval &x);			// Rs[RXgN^
    LongInterval(int mid, int rad);				// RXgN^
    LongInterval(const LongFloat &mid, int rad);		// RXgN^
    LongInterval(int mid, const LongFloat &rad);		// RXgN^
    LongInterval(const LongFloat &mid, const LongFloat &rad);	// RXgN^
    ~LongInterval();						// fXgN^

    void setDouble(double x);					// double ̕ϊ

    void setMidRad(int mid, int rad);				// SlƔa̐ݒ
    void setMidRad(const LongFloat &mid, int rad);		// SlƔa̐ݒ
    void setMidRad(int mid, const LongFloat &rad);		// SlƔa̐ݒ
    void setMidRad(const LongFloat &mid, const LongFloat &rad);	// SlƔa̐ݒ

/*
    void setInfSup(int inf, int sup);				// [Ə[̐ݒ
    void setInfSup(const LongFloat &inf, int sup);		// [Ə[̐ݒ
    void setInfSup(int inf, const LongFloat &sup);		// [Ə[̐ݒ
    void setInfSup(const LongFloat &inf, const LongFloat &sup);	// [Ə[̐ݒ
*/

    double getDouble() const;					// double ւ̕ϊ
    std::string getMidRad() const;				// SlƔa\̎擾
    std::string getInfSup() const;				// [Ə[\̎擾
    std::string getInternalData() const;			// f[^\̎擾

    LongFloat mid() const;					// Sl̎擾
    LongFloat rad() const;					// a̎擾
    LongFloat diam() const;					// a̎擾
    LongFloat inf() const;					// [̎擾
    LongFloat sup() const;					// [̎擾
    LongFloat mig() const;					// ŏΒl̎擾
    LongFloat mag() const;					// őΒl̎擾

    int contains(int x) const;					// x ܂ނ
    int containsEqual(int x) const;				// x ܂ނ(E܂)
    int contains(const LongFloat &x) const;			// x ܂ނ
    int containsEqual(const LongFloat &x) const;		// x ܂ނ(E܂)
    int contains(const LongInterval &x) const;			// x ܂ނ
    int containsEqual(const LongInterval &x) const;		// x ܂ނ(E܂)

    LongInterval operator +() const;				// +LongInterval
    LongInterval operator -() const;				// -LongInterval

    LongInterval operator +(int x) const;			// LongInterval + int
    LongInterval operator -(int x) const;			// LongInterval - int
    LongInterval operator *(int x) const;			// LongInterval * int
    LongInterval operator /(int x) const;			// LongInterval / int

    LongInterval operator +(const LongFloat &x) const;		// LongInterval + LongFloat
    LongInterval operator -(const LongFloat &x) const;		// LongInterval - LongFloat
    LongInterval operator *(const LongFloat &x) const;		// LongInterval * LongFloat
    LongInterval operator /(const LongFloat &x) const;		// LongInterval / LongFloat

    LongInterval operator +(const LongInterval &x) const;	// LongInterval + LongInterval
    LongInterval operator -(const LongInterval &x) const;	// LongInterval - LongInterval
    LongInterval operator *(const LongInterval &x) const;	// LongInterval * LongInterval
    LongInterval operator /(const LongInterval &x) const;	// LongInterval / LongInterval

    LongIntervalMatrix operator +(const LongMatrix &x) const;	// LongInterval + LongMatrix
    LongIntervalMatrix operator -(const LongMatrix &x) const;	// LongInterval - LongMatrix
    LongIntervalMatrix operator *(const LongMatrix &x) const;	// LongInterval * LongMatrix
    LongIntervalMatrix operator /(const LongMatrix &x) const;	// LongInterval / LongMatrix

    LongIntervalMatrix operator +(const LongIntervalMatrix &x) const;	// LongInterval + LongIntervalMatrix
    LongIntervalMatrix operator -(const LongIntervalMatrix &x) const;	// LongInterval - LongIntervalMatrix
    LongIntervalMatrix operator *(const LongIntervalMatrix &x) const;	// LongInterval * LongIntervalMatrix
    LongIntervalMatrix operator /(const LongIntervalMatrix &x) const;	// LongInterval / LongIntervalMatrix

    int operator <(int x) const;				// LongInterval < int
    int operator >(int x) const;				// LongInterval > int
    int operator <=(int x) const;				// LongInterval <= int
    int operator >=(int x) const;				// LongInterval >= int

    int operator <(const LongFloat &x) const;			// LongInterval < LongFloat
    int operator >(const LongFloat &x) const;			// LongInterval > LongFloat
    int operator <=(const LongFloat &x) const;			// LongInterval <= LongFloat
    int operator >=(const LongFloat &x) const;			// LongInterval >= LongFloat

    bool operator ==(const LongInterval &x) const;		// LongInterval == LongInterval
    bool operator !=(const LongInterval &x) const;		// LongInterval != LongInterval

    int operator <(const LongInterval &x) const;		// LongInterval < LongInterval
    int operator >(const LongInterval &x) const;		// LongInterval > LongInterval
    int operator <=(const LongInterval &x) const;		// LongInterval <= LongInterval
    int operator >=(const LongInterval &x) const;		// LongInterval >= LongInterval

    LongInterval &operator =(int x);				// LongInterval = int
    LongInterval &operator +=(int x);				// LongInterval += int
    LongInterval &operator -=(int x);				// LongInterval -= int
    LongInterval &operator *=(int x);				// LongInterval *= int
    LongInterval &operator /=(int x);				// LongInterval /= int

    LongInterval &operator =(const LongFloat &x);		// LongInterval = LongFloat
    LongInterval &operator +=(const LongFloat &x);		// LongInterval += LongFloat
    LongInterval &operator -=(const LongFloat &x);		// LongInterval -= LongFloat
    LongInterval &operator *=(const LongFloat &x);		// LongInterval *= LongFloat
    LongInterval &operator /=(const LongFloat &x);		// LongInterval /= LongFloat

    LongInterval &operator =(const LongInterval &x);		// LongInterval = LongInterval
    LongInterval &operator +=(const LongInterval &x);		// LongInterval += LongInterval
    LongInterval &operator -=(const LongInterval &x);		// LongInterval -= LongInterval
    LongInterval &operator *=(const LongInterval &x);		// LongInterval *= LongInterval
    LongInterval &operator /=(const LongInterval &x);		// LongInterval /= LongInterval

  friend LongInterval operator +(int a, const LongInterval &b);	// int + LongInterval
  friend LongInterval operator -(int a, const LongInterval &b);	// int - LongInterval
  friend LongInterval operator *(int a, const LongInterval &b);	// int * LongInterval
  friend LongInterval operator /(int a, const LongInterval &b);	// int / LongInterval

  friend int operator <(int a, const LongInterval &b);		// int < LongInterval
  friend int operator >(int a, const LongInterval &b);		// int > LongInterval
  friend int operator <=(int a, const LongInterval &b);		// int <= LongInterval
  friend int operator >=(int a, const LongInterval &b);		// int >= LongInterval

  friend LongInterval pow(const LongInterval &x, int n);	// ׂ
  friend LongInterval sqrt(const LongInterval &x);		// 

  friend class LongFloat;					// {NX
  friend class LongIntervalMatrix;				// {ԍsNX
};

// std::ostream << LongInterval
std::ostream &operator <<(std::ostream &output, const LongInterval &x);

////////////////////////////////////////////////////////////////////////////////

// {sNX
class LongMatrix{
  private:
    int m;							// s
    int n;							// 
    LongFloat **value;						// zւ̃|C^

  public:
    LongMatrix();						// RXgN^
    LongMatrix(int rows, int columns);				// RXgN^
    LongMatrix(const LongMatrix &x);				// Rs[RXgN^
    ~LongMatrix();						// fXgN^

    void resize(int rows, int columns);				// TCY̕ύX

    std::string getString() const;				// ւ̕ϊ

    int rows() const;						// s̎擾
    int columns() const;					// 񐔂̎擾

    LongFloat *operator[](int row) const;			// s̎擾

    LongMatrix operator +() const;				// +LongMatrix
    LongMatrix operator -() const;				// -LongMatrix

    LongMatrix operator +(int x) const;				// LongMatrix + int
    LongMatrix operator -(int x) const;				// LongMatrix - int
    LongMatrix operator *(int x) const;				// LongMatrix * int
    LongMatrix operator /(int x) const;				// LongMatrix / int

    LongMatrix operator +(const LongFloat &x) const;		// LongMatrix + LongFloat
    LongMatrix operator -(const LongFloat &x) const;		// LongMatrix - LongFloat
    LongMatrix operator *(const LongFloat &x) const;		// LongMatrix * LongFloat
    LongMatrix operator /(const LongFloat &x) const;		// LongMatrix / LongFloat

    LongIntervalMatrix operator +(const LongInterval &x) const;	// LongMatrix + LongInterval
    LongIntervalMatrix operator -(const LongInterval &x) const;	// LongMatrix - LongInterval
    LongIntervalMatrix operator *(const LongInterval &x) const;	// LongMatrix * LongInterval
    LongIntervalMatrix operator /(const LongInterval &x) const;	// LongMatrix / LongInterval

    LongMatrix operator +(const LongMatrix &x) const;		// LongMatrix + LongMatrix
    LongMatrix operator -(const LongMatrix &x) const;		// LongMatrix - LongMatrix
    LongMatrix operator *(const LongMatrix &x) const;		// LongMatrix * LongMatrix

    LongIntervalMatrix operator +(const LongIntervalMatrix &x) const;	// LongMatrix + LongIntervalMatrix
    LongIntervalMatrix operator -(const LongIntervalMatrix &x) const;	// LongMatrix - LongIntervalMatrix
    LongIntervalMatrix operator *(const LongIntervalMatrix &x) const;	// LongMatrix * LongIntervalMatrix

    LongMatrix &operator +=(int x);				// LongMatrix += int
    LongMatrix &operator -=(int x);				// LongMatrix -= int
    LongMatrix &operator *=(int x);				// LongMatrix *= int
    LongMatrix &operator /=(int x);				// LongMatrix /= int

    LongMatrix &operator +=(const LongFloat &x);		// LongMatrix += LongFloat
    LongMatrix &operator -=(const LongFloat &x);		// LongMatrix -= LongFloat
    LongMatrix &operator *=(const LongFloat &x);		// LongMatrix *= LongFloat
    LongMatrix &operator /=(const LongFloat &x);		// LongMatrix /= LongFloat

    LongMatrix &operator =(const LongMatrix &x);		// LongMatrix = LongMatrix
    LongMatrix &operator +=(const LongMatrix &x);		// LongMatrix += LongMatrix
    LongMatrix &operator -=(const LongMatrix &x);		// LongMatrix -= LongMatrix

  friend LongMatrix operator +(int a, const LongMatrix &b);	// int + LongMatrix
  friend LongMatrix operator -(int a, const LongMatrix &b);	// int - LongMatrix
  friend LongMatrix operator *(int a, const LongMatrix &b);	// int * LongMatrix
  friend LongMatrix operator /(int a, const LongMatrix &b);	// int / LongMatrix

  friend LongMatrix abs(const LongMatrix &a);			// Βl
  friend LongMatrix sqrt(const LongMatrix &a);			// 
  friend LongMatrix trans(const LongMatrix &a);			// ]us

  friend class LongFloat;					// {NX
  friend class LongInterval;					// {ԃNX
  friend class LongIntervalMatrix;				// {ԍsNX
};

// std::ostream << LongMatrix
std::ostream &operator <<(std::ostream &output, const LongMatrix &x);

LongMatrix zeros(int rows, int columns);			// Svf 0 ̍s
LongMatrix ones(int rows, int columns);				// Svf 1 ̍s
LongMatrix eye(int size);					// Pʍs

void qr(LongMatrix &q, LongMatrix &r, const LongMatrix &a);	// QR 

////////////////////////////////////////////////////////////////////////////////

// {ԍsNX
class LongIntervalMatrix{
  private:
    int m;							// s
    int n;							// 
    LongInterval **value;					// zւ̃|C^

  public:
    LongIntervalMatrix();					// RXgN^
    LongIntervalMatrix(int rows, int columns);			// RXgN^
    LongIntervalMatrix(const LongMatrix &x);			// RXgN^
    LongIntervalMatrix(const LongIntervalMatrix &x);		// Rs[RXgN^
    ~LongIntervalMatrix();					// fXgN^

    void resize(int rows, int columns);				// TCY̕ύX

    std::string getMidRad() const;				// SlƔa\̎擾
    std::string getInfSup() const;				// [Ə[\̎擾

    int rows() const;						// s̎擾
    int columns() const;					// 񐔂̎擾

    LongMatrix mid() const;					// Sl̎擾
    LongMatrix rad() const;					// a̎擾
    LongMatrix diam() const;					// a̎擾
    LongMatrix inf() const;					// [̎擾
    LongMatrix sup() const;					// [̎擾
    LongMatrix mig() const;					// ŏΒl̎擾
    LongMatrix mag() const;					// őΒl̎擾

    LongInterval *operator[](int row) const;			// s̎擾

    LongIntervalMatrix operator +() const;			// +LongIntervalMatrix
    LongIntervalMatrix operator -() const;			// -LongIntervalMatrix

    LongIntervalMatrix operator +(int x) const;			// LongIntervalMatrix + int
    LongIntervalMatrix operator -(int x) const;			// LongIntervalMatrix - int
    LongIntervalMatrix operator *(int x) const;			// LongIntervalMatrix * int
    LongIntervalMatrix operator /(int x) const;			// LongIntervalMatrix / int

    LongIntervalMatrix operator +(const LongFloat &x) const;	// LongIntervalMatrix + LongFloat
    LongIntervalMatrix operator -(const LongFloat &x) const;	// LongIntervalMatrix - LongFloat
    LongIntervalMatrix operator *(const LongFloat &x) const;	// LongIntervalMatrix * LongFloat
    LongIntervalMatrix operator /(const LongFloat &x) const;	// LongIntervalMatrix / LongFloat

    LongIntervalMatrix operator +(const LongInterval &x) const;	// LongIntervalMatrix + LongInterval
    LongIntervalMatrix operator -(const LongInterval &x) const;	// LongIntervalMatrix - LongInterval
    LongIntervalMatrix operator *(const LongInterval &x) const;	// LongIntervalMatrix * LongInterval
    LongIntervalMatrix operator /(const LongInterval &x) const;	// LongIntervalMatrix / LongInterval

    LongIntervalMatrix operator +(const LongMatrix &x) const;	// LongIntervalMatrix + LongMatrix
    LongIntervalMatrix operator -(const LongMatrix &x) const;	// LongIntervalMatrix - LongMatrix
    LongIntervalMatrix operator *(const LongMatrix &x) const;	// LongIntervalMatrix * LongMatrix

    LongIntervalMatrix operator +(const LongIntervalMatrix &x) const;	// LongIntervalMatrix + LongIntervalMatrix
    LongIntervalMatrix operator -(const LongIntervalMatrix &x) const;	// LongIntervalMatrix - LongIntervalMatrix
    LongIntervalMatrix operator *(const LongIntervalMatrix &x) const;	// LongIntervalMatrix * LongIntervalMatrix

    LongIntervalMatrix &operator +=(int x);			// LongIntervalMatrix += int
    LongIntervalMatrix &operator -=(int x);			// LongIntervalMatrix -= int
    LongIntervalMatrix &operator *=(int x);			// LongIntervalMatrix *= int
    LongIntervalMatrix &operator /=(int x);			// LongIntervalMatrix /= int

    LongIntervalMatrix &operator +=(const LongFloat &x);	// LongIntervalMatrix += LongFloat
    LongIntervalMatrix &operator -=(const LongFloat &x);	// LongIntervalMatrix -= LongFloat
    LongIntervalMatrix &operator *=(const LongFloat &x);	// LongIntervalMatrix *= LongFloat
    LongIntervalMatrix &operator /=(const LongFloat &x);	// LongIntervalMatrix /= LongFloat

    LongIntervalMatrix &operator +=(const LongInterval &x);	// LongIntervalMatrix += LongInterval
    LongIntervalMatrix &operator -=(const LongInterval &x);	// LongIntervalMatrix -= LongInterval
    LongIntervalMatrix &operator *=(const LongInterval &x);	// LongIntervalMatrix *= LongInterval
    LongIntervalMatrix &operator /=(const LongInterval &x);	// LongIntervalMatrix /= LongInterval

    LongIntervalMatrix &operator =(const LongMatrix &x);	// LongIntervalMatrix = LongMatrix
    LongIntervalMatrix &operator +=(const LongMatrix &x);	// LongIntervalMatrix += LongMatrix
    LongIntervalMatrix &operator -=(const LongMatrix &x);	// LongIntervalMatrix -= LongMatrix

    LongIntervalMatrix &operator =(const LongIntervalMatrix &x);	// LongIntervalMatrix = LongIntervalMatrix
    LongIntervalMatrix &operator +=(const LongIntervalMatrix &x);	// LongIntervalMatrix += LongIntervalMatrix
    LongIntervalMatrix &operator -=(const LongIntervalMatrix &x);	// LongIntervalMatrix -= LongIntervalMatrix

  friend LongIntervalMatrix operator +(int a, const LongIntervalMatrix &b);	// int + LongIntervalMatrix
  friend LongIntervalMatrix operator -(int a, const LongIntervalMatrix &b);	// int - LongIntervalMatrix
  friend LongIntervalMatrix operator *(int a, const LongIntervalMatrix &b);	// int * LongIntervalMatrix
  friend LongIntervalMatrix operator /(int a, const LongIntervalMatrix &b);	// int / LongIntervalMatrix

  friend LongIntervalMatrix sqrt(const LongIntervalMatrix &a);	// 
  friend LongIntervalMatrix trans(const LongIntervalMatrix &a);	// ]us

  friend class LongFloat;					// {NX
  friend class LongInterval;					// {ԃNX
  friend class LongMatrix;					// {sNX
};

// std::ostream << LongIntervalMatrix
std::ostream &operator <<(std::ostream &output, const LongIntervalMatrix &x);

#endif
