#
# spec file for package pacemaker-mgmt (Version 2.0.0)
#
# Copyright (c) 2010 SUSE LINUX Products GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via http://bugs.opensuse.org/
#

# norootforbuild
%define __check_files %{nil}

%if 0%{?suse_version}
%define _libexecdir %{_libdir}
%endif
%define with_extra_warnings   	0
%define with_debugging  	0
%define without_fatal_warnings 	1
%define with_ais_support        1
%define with_heartbeat_support  0
%define enable_snmp_subagent	1
%define gname haclient		
%define uname hacluster
%if 0%{?fedora_version} || 0%{?centos_version} || 0%{?rhel_version}
%define pkg_group System Environment/Daemons
%else
%define pkg_group Productivity/Clustering/HA
%endif

Name:           pacemaker-mgmt
Summary:        Management Tools for Pacemaker based HA solution
Version:        2.0
Release:        1.el5
License:        GPL v2 or later
Url:            http://hg.clusterlabs.org/pacemaker/pygui
Group:          Productivity/Clustering/HA
Source:         pacemaker-mgmt.tar.gz
#Source1:        pacemaker_starter.py
#Source2:        pacemaker-starter.glade
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
AutoReqProv:    on
Conflicts:      heartbeat < 2.99
Obsoletes:      pacemaker-pygui
Conflicts:      pacemaker-pygui
Requires:       cluster-glue pacemaker findutils
#Recommends:	pacemaker-mgmt-client
%if 0%{?suse_version}
BuildRequires:  libglue-devel libpacemaker-devel
%else
BuildRequires:  cluster-glue-libs-devel pacemaker-libs-devel
%endif
#BuildRequires:  e2fsprogs-devel glib2-devel gnutls-devel libxml2-devel ncurses-devel pam-devel python-devel swig
BuildRequires:  glib2-devel gnutls-devel intltool libxml2-devel ncurses-devel pam-devel python-devel swig
%if %enable_snmp_subagent
BuildRequires:  net-snmp-devel
Requires:       net-snmp
%endif
%if %with_ais_support
BuildRequires:  corosynclib-devel
Requires:       corosync
%endif
%if %with_heartbeat_support
BuildRequires:  heartbeat-devel
Requires:       heartbeat
%endif
%if 0%{?suse_version}
BuildRequires:  tcpd-devel
#%if 0%{?suse_version} == 930
#BuildRequires:  rpm-devel
#%endif
#%if 0%{?suse_version} == 1000
#BuildRequires:  lzo lzo-devel
#%endif
#%if 0%{?sles_version} == 9
#BuildRequires:  pkgconfig
#%endif
%endif
%if 0%{?fedora_version} || 0%{?centos_version} || 0%{?rhel_version}
BuildRequires:  which
#BuildRequires:  rpm-devel
#BuildRequires:  tcp_wrappers-devel
BuildRequires:  lm_sensors-devel openssl-devel
%endif
%if 0%{?fedora_version} >= 11
BuildRequires:  libtool-ltdl-devel
%endif
%if 0%{?rhel_version} == 406
BuildRequires:  gcc-c++ libselinux-devel
%endif
%if 0%{?suse_version}
BuildRequires:  update-desktop-files
%endif

%description
pacemaker-mgmt includes a server/client GUI and a snmp plugin, to help
to manage and monitor pacemaker based HA solution.



Authors:
--------
    Yan Gao <ygao@novell.com>

%package client
License:        GPL v2 or later
Summary:        Management Tools for Pacemaker based HA solution
Group:          Productivity/Clustering/HA
Obsoletes:      pacemaker-pygui
Conflicts:      pacemaker-pygui
#%if 0%{?fedora_version} || 0%{?centos_version} || 0%{?rhel_version}
Requires:       PyXML
Requires:       pygtk2
#%else
#%if 0%{?suse_version} < 1140
#Requires:       pyxml
#%endif
#Requires:       python-gtk
#%endif
#%if 0%{?centos_version} == 0 && 0%{?rhel_version} == 0
Requires:       python-lxml
#%endif
#%if 0%{?suse_version} || 0%{?fedora_version} || 0%{?sles_version} > 10
#%if 0%{?suse_version} || 0%{?fedora_version}
#Requires:       graphviz-python
#%endif
%if 0%{?mandriva_version}
Requires:       libgraphvizpython0
%endif

%description client
pacemaker-mgmt includes a server/client GUI and a snmp plugin, to help
to manage and monitor pacemaker based HA solution.



Authors:
--------
    Yan Gao <ygao@novell.com>

%package devel 
License:        GPL v2 or later
Summary:        Management Tools for Pacemaker based HA solution
Group:          Productivity/Clustering/HA
Obsoletes:      pacemaker-pygui-devel
Conflicts:      pacemaker-pygui-devel
Requires:       %{name} = %{version}-%{release}

%description devel
pacemaker-mgmt includes a server/client GUI and a snmp plugin, to help
to manage and monitor pacemaker based HA solution.



Authors:
--------
    Yan Gao <ygao@novell.com>

%prep
###########################################################
%setup -n pacemaker-mgmt
###########################################################

%build
# TODO: revisit -all
CFLAGS="${CFLAGS} ${RPM_OPT_FLAGS}"
# Feature-dependent CFLAGS:
%if %with_extra_warnings
# CFLAGS="${CFLAGS} -Wshadow -Wfloat-equal -Waggregate-return -Wnested-externs -Wunreachable-code -Wendif-labels -Winline"
CFLAGS="${CFLAGS} -Wfloat-equal -Wendif-labels -Winline"
%endif
%if %with_debugging
CFLAGS="${CFLAGS} -O0"
%endif
# Distribution specific settings:
%if 0%{?suse_version} > 1001
CFLAGS="${CFLAGS} -fstack-protector-all"
%endif
%if 0%{?suse_version} < 1001
export PKG_CONFIG_PATH="$PKG_CONFIG_PATH:/opt/gnome/%{_lib}/pkgconfig:/opt/gnome/share/pkgconfig"
%endif
%if 0%{?suse_version} > 1020
CFLAGS="$CFLAGS -fgnu89-inline"
%endif
%if 0%{?fedora_version} > 6
CFLAGS="$CFLAGS -fgnu89-inline"
%endif
export CFLAGS
./ConfigureMe configure --prefix=%{_prefix} --sysconfdir=%{_sysconfdir} \
	--localstatedir=%{_var} --infodir=%{_infodir} 		\
	--mandir=%{_mandir} --libdir=%{_libdir} 		\
	--libexecdir=%{_libexecdir} 				\
	--with-ais-prefix=%{_prefix}				\
%if %without_fatal_warnings
	--enable-fatal-warnings=no 			        \
%endif
%if %enable_snmp_subagent
	--enable-snmp-subagent					\
	--with-mibsdir=%{_datadir}/snmp/mibs			\
%endif
	--with-hapkgversion=%{version}
%if %enable_snmp_subagent
%if %with_heartbeat_support
pushd snmp_subagent
ln -sf /usr/lib/libclm.so.1.0.0 libclm.so
ln -sf /usr/lib/libccmclient.so.1.0.0 libccmclient.so
ln -sf /usr/lib/libhbclient.so.1.0.0 libhbclient.so
popd
%endif
%endif
export MAKE="make %{?jobs:-j%jobs}"
make %{?jobs:-j%jobs}
###########################################################

%install
###########################################################
#make DESTDIR=$RPM_BUILD_ROOT install-strip
make DESTDIR=$RPM_BUILD_ROOT install
#install -m 755 %{SOURCE1} $RPM_BUILD_ROOT/usr/share/heartbeat-gui
#install -m 644 %{SOURCE2} $RPM_BUILD_ROOT/usr/share/heartbeat-gui
#pushd $RPM_BUILD_ROOT/usr/bin
#ln -sf ../share/heartbeat-gui/pacemaker_starter.py pacemaker_starter
#popd
%find_lang haclient
%if 0%{?suse_version}
%suse_update_desktop_file crm_gui
%endif
# Cleanup
[ -d $RPM_BUILD_ROOT/usr/man ] && rm -rf $RPM_BUILD_ROOT/usr/man
[ -d $RPM_BUILD_ROOT/usr/share/libtool ] && rm -rf $RPM_BUILD_ROOT/usr/share/libtool
find $RPM_BUILD_ROOT -name '*.a' -type f -print0 | xargs -0 rm -f
find $RPM_BUILD_ROOT -name '*.la' -type f -print0 | xargs -0 rm -f
find $RPM_BUILD_ROOT -name '*.pyc' -type f -print0 | xargs -0 rm -f
find $RPM_BUILD_ROOT -name '*.pyo' -type f -print0 | xargs -0 rm -f
###########################################################

%clean
###########################################################
if
  [ -n "${RPM_BUILD_ROOT}" -a "${RPM_BUILD_ROOT}" != "/" ]
then
  rm -rf $RPM_BUILD_ROOT
fi
rm -rf $RPM_BUILD_DIR/pacemaker-mgmt
###########################################################
#%pre
#%preun
# Use the following if more commands need to be executed
# %post
# /sbin/ldconfig
# [...]
# http://en.opensuse.org/SUSE_Package_Conventions/RPM_Macros

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
###########################################################
%defattr(-,root,root)
%config %{_sysconfdir}/pam.d/hbmgmtd
#%{_bindir}/pacemaker_starter
%{_libdir}/heartbeat/mgmtd
%{_libdir}/heartbeat/mgmtdtest
%{_libdir}/libhbmgmt.so.*
%{_libdir}/libhbmgmtclient.so.*
%{_libdir}/libhbmgmtcommon.so.*
%{_libdir}/libhbmgmttls.so.*
#%{_datadir}/heartbeat-gui/*.glade
#%dir %{_docdir}/pacemaker-mgmt
#%doc %{_docdir}/pacemaker-mgmt/*
%dir %{_datadir}/doc/packages/pacemaker-mgmt
%doc %{_datadir}/doc/packages/pacemaker-mgmt/*
%if %enable_snmp_subagent
%{_libdir}/heartbeat/hbagent
%{_libdir}/heartbeat/SNMPAgentSanityCheck
%{_datadir}/snmp/mibs/LINUX-HA-MIB.txt
%endif

%files client -f haclient.lang
%defattr(-,root,root)
%{_bindir}/crm_gui
%{_bindir}/hb_gui
%dir %{_libdir}/heartbeat-gui
%{_libdir}/heartbeat-gui/haclient.py
%{_libdir}/heartbeat-gui/pymgmt.py
%{_libdir}/heartbeat-gui/_pymgmt.so*
%dir %{_datadir}/heartbeat-gui
%{_datadir}/heartbeat-gui/*.py
%{_datadir}/heartbeat-gui/*.png
%{_datadir}/applications/*.desktop
#%lang(zh_CN) %{_datadir}/locale/zh_CN/LC_MESSAGES/haclient.mo

%files devel
%defattr(-,root,root)
%dir %{_includedir}/heartbeat/mgmt	
%{_includedir}/heartbeat/mgmt/mgmt.h
%{_includedir}/heartbeat/mgmt/mgmt_client.h
%{_includedir}/heartbeat/mgmt/mgmt_common.h
%{_includedir}/heartbeat/mgmt/mgmt_tls.h
%{_includedir}/heartbeat/mgmt_config.h
%{_libdir}/*.so

%changelog
