﻿/*
 * VibratoType.cs
 * Copyright (c) 2008-2009 kbinani
 *
 * This file is part of Boare.Lib.Vsq.
 *
 * Boare.Lib.Vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Lib.Vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;

namespace Boare.Lib.Vsq {

    public enum VibratoType : int {
        NormalType1 = 1,
        NormalType2,
        NormalType3,
        NormalType4,
        ExtremeType1,
        ExtremeType2,
        ExtremeType3,
        ExtremeType4,
        FastType1,
        FastType2,
        FastType3,
        FastType4,
        SlightType1,
        SlightType2,
        SlightType3,
        SlightType4,
    }

    public class VibratoTypeUtil {
        public static VibratoType FromIconID( string icon_id ) {
            switch ( icon_id ) {
                case "$04040001":
                    return VibratoType.NormalType1;
                case "$04040002":
                    return VibratoType.NormalType2;
                case  "$04040003":
                    return VibratoType.NormalType3;
                case "$0400004":
                    return VibratoType.NormalType4;
                case "$04040005":
                    return VibratoType.ExtremeType1;
                case "$04040006":
                    return VibratoType.ExtremeType2;
                case "$04040007":
                    return VibratoType.ExtremeType3;
                case "$04040008":
                    return VibratoType.ExtremeType4;
                case "$04040009":
                    return VibratoType.FastType1;
                case "$0404000a":
                    return VibratoType.FastType2;
                case "$0404000b":
                    return VibratoType.FastType3;
                case "$0404000c":
                    return VibratoType.FastType4;
                case "$0404000d":
                    return VibratoType.SlightType1;
                case "$0404000e":
                    return VibratoType.SlightType2;
                case "$0404000f":
                    return VibratoType.SlightType3;
                case "$04040010":
                    return VibratoType.SlightType4;
            }
            return VibratoType.NormalType1;
        }


        public static string GetIconID( VibratoType type ) {
            switch ( type ) {
                case VibratoType.NormalType1:
                    return "$04040001";
                case VibratoType.NormalType2:
                    return "$04040002";
                case VibratoType.NormalType3:
                    return "$04040003";
                case VibratoType.NormalType4:
                    return "$0400004";
                case VibratoType.ExtremeType1:
                    return "$04040005";
                case VibratoType.ExtremeType2:
                    return "$04040006";
                case VibratoType.ExtremeType3:
                    return "$04040007";
                case VibratoType.ExtremeType4:
                    return "$04040008";
                case VibratoType.FastType1:
                    return "$04040009";
                case VibratoType.FastType2:
                    return "$0404000a";
                case VibratoType.FastType3:
                    return "$0404000b";
                case VibratoType.FastType4:
                    return "$0404000c";
                case VibratoType.SlightType1:
                    return "$0404000d";
                case VibratoType.SlightType2:
                    return "$0404000e";
                case VibratoType.SlightType3:
                    return "$0404000f";
                case VibratoType.SlightType4:
                    return "$04040010";
            }
            return "";
        }


        public static VibratoHandle GetDefaultVibratoHandle( VibratoType type, int vibrato_clocks ) {
            VibratoHandle res = new VibratoHandle();
            res.Type = VsqHandleType.Vibrato;
            res.Length = vibrato_clocks;
            res.Original = 1;
            res.DepthBPNum = 0;
            res.RateBPNum = 0;
            res.Caption = ToString( type );
            res.IconID = GetIconID( type );
            switch ( type ) {
                case VibratoType.NormalType1:
                    res.IDS = "normal";
                    res.StartDepth = 64;
                    res.StartRate = 50;
                    break;
                case VibratoType.NormalType2:
                    res.IDS = "normal";
                    res.StartDepth = 40;
                    res.StartRate = 40;
                    break;
                case VibratoType.NormalType3:
                    res.IDS = "normal";
                    res.StartDepth = 127;
                    res.StartRate = 50;
                    break;
                case VibratoType.NormalType4:
                    res.IDS = "normal";
                    res.StartDepth = 64;
                    res.DepthBPNum = 57;
                    res.DepthBPX = new float[57] { 0.603900f, 0.612500f, 0.616400f, 0.621100f, 0.625000f, 0.633600f, 0.637500f, 0.641400f, 0.646100f, 0.653900f, 0.658600f, 0.666400f, 0.670300f, 0.675000f, 0.678900f, 0.683600f, 0.691400f, 0.696100f, 0.703900f, 0.708600f, 0.712500f, 0.716400f, 0.721100f, 0.725000f, 0.728900f, 0.737500f, 0.746100f, 0.750000f, 0.758600f, 0.762500f, 0.766400f, 0.771100f, 0.775000f, 0.783600f, 0.791400f, 0.795300f, 0.800000f, 0.803900f, 0.808600f, 0.812500f, 0.821100f, 0.828900f, 0.837500f, 0.841400f, 0.846100f, 0.850000f, 0.853900f, 0.862500f, 0.866400f, 0.875000f, 0.878900f, 0.883600f, 0.887500f, 0.891400f, 0.896100f, 0.900000f, 1.000000f };
                    res.DepthBPY = new int[57] { 64, 63, 62, 61, 59, 58, 57, 56, 55, 54, 52, 51, 50, 49, 48, 47, 45, 44, 43, 42, 41, 40, 39, 38, 37, 35, 34, 32, 31, 30, 29, 28, 27, 25, 24, 23, 22, 21, 20, 19, 17, 15, 14, 13, 12, 11, 10, 8, 7, 6, 5, 4, 3, 2, 1, 0, 0 };
                    res.StartRate = 50;
                    res.RateBPNum = 52;
                    res.RateBPX = new float[52] { 0.600000f, 0.612500f, 0.616400f, 0.621100f, 0.628900f, 0.633600f, 0.637500f, 0.641400f, 0.653900f, 0.658600f, 0.662500f, 0.666400f, 0.675000f, 0.683600f, 0.687500f, 0.691400f, 0.700000f, 0.703900f, 0.708600f, 0.712500f, 0.725000f, 0.728900f, 0.732800f, 0.737500f, 0.746100f, 0.750000f, 0.758600f, 0.762500f, 0.771100f, 0.775000f, 0.778900f, 0.783600f, 0.795300f, 0.800000f, 0.803900f, 0.808600f, 0.816400f, 0.821100f, 0.828900f, 0.833600f, 0.841400f, 0.846100f, 0.850000f, 0.853900f, 0.866400f, 0.871100f, 0.875000f, 0.878900f, 0.887500f, 0.891400f, 0.900000f, 1.000000f };
                    res.RateBPY = new int[52] { 50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0, 0 };
                    break;
                case VibratoType.ExtremeType1:
                    res.IDS = "extreme";
                    res.StartDepth = 64;
                    res.StartRate = 64;
                    break;
                case VibratoType.ExtremeType2:
                    res.IDS = "extreme";
                    res.StartDepth = 32;
                    res.StartRate = 32;
                    break;
                case VibratoType.ExtremeType3:
                    res.IDS = "extreme";
                    res.StartDepth = 100;
                    res.StartRate = 50;
                    break;
                case VibratoType.ExtremeType4:
                    res.IDS = "extreme";
                    res.StartDepth = 64;
                    res.DepthBPNum = 57;
                    res.DepthBPX = new float[57] { 0.603900f, 0.612500f, 0.616400f, 0.621100f, 0.625000f, 0.633600f, 0.637500f, 0.641400f, 0.646100f, 0.653900f, 0.658600f, 0.666400f, 0.670300f, 0.675000f, 0.678900f, 0.683600f, 0.691400f, 0.696100f, 0.703900f, 0.708600f, 0.712500f, 0.716400f, 0.721100f, 0.725000f, 0.728900f, 0.737500f, 0.746100f, 0.750000f, 0.758600f, 0.762500f, 0.766400f, 0.771100f, 0.775000f, 0.783600f, 0.791400f, 0.795300f, 0.800000f, 0.803900f, 0.808600f, 0.812500f, 0.821100f, 0.828900f, 0.837500f, 0.841400f, 0.846100f, 0.850000f, 0.853900f, 0.862500f, 0.866400f, 0.875000f, 0.878900f, 0.883600f, 0.887500f, 0.891400f, 0.896100f, 0.900000f, 1.000000f };
                    res.DepthBPY = new int[57] { 64, 63, 62, 61, 59, 58, 57, 56, 55, 54, 52, 51, 50, 49, 48, 47, 45, 44, 43, 42, 41, 40, 39, 38, 37, 35, 34, 32, 31, 30, 29, 28, 27, 25, 24, 23, 22, 21, 20, 19, 17, 15, 14, 13, 12, 11, 10, 8, 7, 6, 5, 4, 3, 2, 1, 0, 0 };
                    res.StartRate = 64;
                    res.RateBPNum = 57;
                    res.RateBPX = new float[57] { 0.603900f, 0.612500f, 0.616400f, 0.621100f, 0.625000f, 0.633600f, 0.637500f, 0.641400f, 0.646100f, 0.653900f, 0.658600f, 0.666400f, 0.670300f, 0.675000f, 0.678900f, 0.683600f, 0.691400f, 0.696100f, 0.703900f, 0.708600f, 0.712500f, 0.716400f, 0.721100f, 0.725000f, 0.728900f, 0.737500f, 0.746100f, 0.750000f, 0.758600f, 0.762500f, 0.766400f, 0.771100f, 0.775000f, 0.783600f, 0.791400f, 0.795300f, 0.800000f, 0.803900f, 0.808600f, 0.812500f, 0.821100f, 0.828900f, 0.837500f, 0.841400f, 0.846100f, 0.850000f, 0.853900f, 0.862500f, 0.866400f, 0.875000f, 0.878900f, 0.883600f, 0.887500f, 0.891400f, 0.896100f, 0.900000f, 1.000000f };
                    res.RateBPY = new int[57] { 64, 63, 62, 61, 59, 58, 57, 56, 55, 54, 52, 51, 50, 49, 48, 47, 45, 44, 43, 42, 41, 40, 39, 38, 37, 35, 34, 32, 31, 30, 29, 28, 27, 25, 24, 23, 22, 21, 20, 19, 17, 15, 14, 13, 12, 11, 10, 8, 7, 6, 5, 4, 3, 2, 1, 0, 0 };
                    break;
                case VibratoType.FastType1:
                    res.IDS = "fast";
                    res.StartDepth = 64;
                    res.StartRate = 64;
                    break;
                case VibratoType.FastType2:
                    res.IDS = "fast";
                    res.StartDepth = 40;
                    res.StartRate = 50;
                    break;
                case VibratoType.FastType3:
                    res.IDS = "fast";
                    res.StartDepth = 80;
                    res.StartRate = 70;
                    break;
                case VibratoType.FastType4:
                    res.IDS = "fast";
                    res.StartDepth = 64;
                    res.DepthBPNum = 57;
                    res.DepthBPX = new float[57] { 0.603900f, 0.612500f, 0.616400f, 0.621100f, 0.625000f, 0.633600f, 0.637500f, 0.641400f, 0.646100f, 0.653900f, 0.658600f, 0.666400f, 0.670300f, 0.675000f, 0.678900f, 0.683600f, 0.691400f, 0.696100f, 0.703900f, 0.708600f, 0.712500f, 0.716400f, 0.721100f, 0.725000f, 0.728900f, 0.737500f, 0.746100f, 0.750000f, 0.758600f, 0.762500f, 0.766400f, 0.771100f, 0.775000f, 0.783600f, 0.791400f, 0.795300f, 0.800000f, 0.803900f, 0.808600f, 0.812500f, 0.821100f, 0.828900f, 0.837500f, 0.841400f, 0.846100f, 0.850000f, 0.853900f, 0.862500f, 0.866400f, 0.875000f, 0.878900f, 0.883600f, 0.887500f, 0.891400f, 0.896100f, 0.900000f, 1.000000f };
                    res.DepthBPY = new int[57] { 64, 63, 62, 61, 59, 58, 57, 56, 55, 54, 52, 51, 50, 49, 48, 47, 45, 44, 43, 42, 41, 40, 39, 38, 37, 35, 34, 32, 31, 30, 29, 28, 27, 25, 24, 23, 22, 21, 20, 19, 17, 15, 14, 13, 12, 11, 10, 8, 7, 6, 5, 4, 3, 2, 1, 0, 0 };
                    res.StartRate = 64;
                    res.RateBPNum = 57;
                    res.RateBPX = new float[57] { 0.603900f, 0.612500f, 0.616400f, 0.621100f, 0.625000f, 0.633600f, 0.637500f, 0.641400f, 0.646100f, 0.653900f, 0.658600f, 0.666400f, 0.670300f, 0.675000f, 0.678900f, 0.683600f, 0.691400f, 0.696100f, 0.703900f, 0.708600f, 0.712500f, 0.716400f, 0.721100f, 0.725000f, 0.728900f, 0.737500f, 0.746100f, 0.750000f, 0.758600f, 0.762500f, 0.766400f, 0.771100f, 0.775000f, 0.783600f, 0.791400f, 0.795300f, 0.800000f, 0.803900f, 0.808600f, 0.812500f, 0.821100f, 0.828900f, 0.837500f, 0.841400f, 0.846100f, 0.850000f, 0.853900f, 0.862500f, 0.866400f, 0.875000f, 0.878900f, 0.883600f, 0.887500f, 0.891400f, 0.896100f, 0.900000f, 1.000000f };
                    res.RateBPY = new int[57] { 64, 63, 62, 61, 59, 58, 57, 56, 55, 54, 52, 51, 50, 49, 48, 47, 45, 44, 43, 42, 41, 40, 39, 38, 37, 35, 34, 32, 31, 30, 29, 28, 27, 25, 24, 23, 22, 21, 20, 19, 17, 15, 14, 13, 12, 11, 10, 8, 7, 6, 5, 4, 3, 2, 1, 0, 0 };
                    break;
                case VibratoType.SlightType1:
                    res.IDS = "slight";
                    res.StartDepth = 64;
                    res.StartRate = 64;
                    break;
                case VibratoType.SlightType2:
                    res.IDS = "slight";
                    res.StartDepth = 40;
                    res.StartRate = 64;
                    break;
                case VibratoType.SlightType3:
                    res.IDS = "slight";
                    res.StartDepth = 72;
                    res.StartRate = 64;
                    break;
                case VibratoType.SlightType4:
                    res.IDS = "slight";
                    res.StartDepth = 64;
                    res.DepthBPNum = 57;
                    res.DepthBPX = new float[57] { 0.604300f, 0.612500f, 0.616800f, 0.620700f, 0.625000f, 0.633200f, 0.637500f, 0.641800f, 0.645700f, 0.654300f, 0.658200f, 0.666800f, 0.670700f, 0.675000f, 0.679300f, 0.683200f, 0.691800f, 0.695700f, 0.704300f, 0.708200f, 0.712500f, 0.716800f, 0.720700f, 0.725000f, 0.729300f, 0.737500f, 0.745700f, 0.750000f, 0.758200f, 0.762500f, 0.766800f, 0.770700f, 0.775000f, 0.783200f, 0.791800f, 0.795700f, 0.800000f, 0.804300f, 0.808200f, 0.812500f, 0.820700f, 0.829300f, 0.837500f, 0.841800f, 0.845700f, 0.850000f, 0.854300f, 0.862500f, 0.866800f, 0.875000f, 0.879300f, 0.883200f, 0.887500f, 0.891800f, 0.895700f, 0.900000f, 1.000000f };
                    res.DepthBPY = new int[57] { 64, 63, 62, 61, 59, 58, 57, 56, 55, 54, 52, 51, 50, 49, 48, 47, 45, 44, 43, 42, 41, 40, 39, 38, 37, 35, 34, 32, 31, 30, 29, 28, 27, 25, 24, 23, 22, 21, 20, 19, 17, 15, 14, 13, 12, 11, 10, 8, 7, 6, 5, 4, 3, 2, 1, 0, 0 };
                    res.StartRate = 64;
                    res.RateBPNum = 57;
                    res.RateBPX = new float[57] { 0.604300f, 0.612500f, 0.616800f, 0.620700f, 0.625000f, 0.633200f, 0.637500f, 0.641800f, 0.645700f, 0.654300f, 0.658200f, 0.666800f, 0.670700f, 0.675000f, 0.679300f, 0.683200f, 0.691800f, 0.695700f, 0.704300f, 0.708200f, 0.712500f, 0.716800f, 0.720700f, 0.725000f, 0.729300f, 0.737500f, 0.745700f, 0.750000f, 0.758200f, 0.762500f, 0.766800f, 0.770700f, 0.775000f, 0.783200f, 0.791800f, 0.795700f, 0.800000f, 0.804300f, 0.808200f, 0.812500f, 0.820700f, 0.829300f, 0.837500f, 0.841800f, 0.845700f, 0.850000f, 0.854300f, 0.862500f, 0.866800f, 0.875000f, 0.879300f, 0.883200f, 0.887500f, 0.891800f, 0.895700f, 0.900000f, 1.000000f };
                    res.RateBPY = new int[57] { 64, 63, 62, 61, 59, 58, 57, 56, 55, 54, 52, 51, 50, 49, 48, 47, 45, 44, 43, 42, 41, 40, 39, 38, 37, 35, 34, 32, 31, 30, 29, 28, 27, 25, 24, 23, 22, 21, 20, 19, 17, 15, 14, 13, 12, 11, 10, 8, 7, 6, 5, 4, 3, 2, 1, 0, 0 };
                    break;
            }
            return res;
        }


        public static string ToString( VibratoType value ) {
            switch ( value ) {
                case VibratoType.NormalType1:
                    return "[Normal] Type 1";
                case VibratoType.NormalType2:
                    return "[Normal] Type 2";
                case VibratoType.NormalType3:
                    return "[Normal] Type 3";
                case VibratoType.NormalType4:
                    return "[Normal] Type 4";
                case VibratoType.ExtremeType1:
                    return "[Extreme] Type 1";
                case VibratoType.ExtremeType2:
                    return "[Extreme] Type 2";
                case VibratoType.ExtremeType3:
                    return "[Extreme] Type 3";
                case VibratoType.ExtremeType4:
                    return "[Extreme] Type 4";
                case VibratoType.FastType1:
                    return "[Fast] Type 1";
                case VibratoType.FastType2:
                    return "[Fast] Type 2";
                case VibratoType.FastType3:
                    return "[Fast] Type 3";
                case VibratoType.FastType4:
                    return "[Fast] Type 4";
                case VibratoType.SlightType1:
                    return "[Slight] Type 1";
                case VibratoType.SlightType2:
                    return "[Slight] Type 2";
                case VibratoType.SlightType3:
                    return "[Slight] Type 3";
                case VibratoType.SlightType4:
                    return "[Slight] Type 4";
            }
            return "";
        }
    }

}