﻿/*
 * VsqEvent.cs
 * Copyright (c) 2008-2009 kbinani
 *
 * This file is part of Boare.Lib.Vsq.
 *
 * Boare.Lib.Vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Lib.Vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;

namespace Boare.Lib.Vsq {

    /// <summary>
    /// vsqファイルのメタテキスト内に記述されるイベント。
    /// </summary>
    [Serializable]
    public class VsqEvent : IComparable<VsqEvent>, ICloneable {
        int m_internal_id;
        int m_clock;
        VsqID m_id;

        /// <summary>
        /// このオブジェクトのコピーを作成します
        /// </summary>
        /// <returns></returns>
        public object Clone() {
            VsqEvent ret = new VsqEvent( m_clock, m_id );
            ret.InternalID = m_internal_id;
            return ret;
        }

        /// <summary>
        /// 内部で使用するインスタンス固有のID
        /// </summary>
        public int InternalID {
            get {
                return m_internal_id;
            }
            set {
                m_internal_id = value;
            }
        }

        /// <summary>
        /// このイベントが発生するクロック。
        /// </summary>
        public int Clock {
            get {
                return m_clock;
            }
            set {
                m_clock = value;
            }
        }

        /// <summary>
        /// 発生するイベントの内容を表したID
        /// </summary>
        public VsqID ID {
            get {
                return m_id;
            }
            set {
                m_id = value;
            }
        }

        public int CompareTo( VsqEvent item ) {
            int ret = this.Clock - item.Clock;
            if ( ret == 0 ) {
                if ( this.ID != null && item.ID != null ) {
                    return (int)this.ID.type - (int)item.ID.type;
                } else {
                    return ret;
                }
            } else {
                return ret;
            }
        }

        public VsqEvent( string line ) {
            string[] spl = line.Split( new char[] { '=' } );
            Clock = int.Parse( spl[0] );
            if ( spl[1] == "EOS" ) {
                ID = VsqID.EOS;
            }
        }

        public VsqEvent( int clock, VsqID id /*, int internal_id*/ ) {
            Clock = clock;
            ID = (VsqID)id.Clone();
            //InternalID = internal_id;
            InternalID = 0;
        }
    }

}
