/*
 * VsqCommand.java
 * Copyright (c) 2008 kbinani
 *
 * This file is part of jp.sourceforge.lipsync.vsq.
 *
 * jp.sourceforge.lipsync.vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * jp.sourceforge.lipsync.vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package jp.sourceforge.lipsync.vsq;

import java.util.*;
/// <summary>
/// 
/// </summary>

public class VsqCommand {
    public VsqCommandType Type;
    /**
     * コマンドの処理内容を保持します。Args具体的な内容は、処理するクラスごとに異なります
     */
    public Object[] Args;
    /**
     * 後続するコマンド
     */
    public Vector<VsqCommand> Children = new Vector<VsqCommand>();
    /**
     * このコマンドの親
     */
    public VsqCommand Parent = null;

    /**
     * VsqCommandは各クラスのGenerateCommandからコンストラクトしなければならない。
     * なので、無引数のコンストラクタを隠蔽するためのもの。
     */
    protected VsqCommand() {
        //throw new Exception( "このコンストラクトは呼び出しちゃいけませんよ" );
    }

}
