/*
 * VsqMixer.java
 * Copyright (c) 2008 kbinani
 *
 * This file is part of jp.sourceforge.lipsync.vsq.
 *
 * jp.sourceforge.lipsync.vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * jp.sourceforge.lipsync.vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package jp.sourceforge.lipsync.vsq;

import java.util.*;

/// <summary>
/// vsqファイルのメタテキストの[Mixer]セクションに記録される内容を取り扱う
/// </summary>
public class VsqMixer implements Cloneable {
    //private int MasterFeder;
    public int MasterFeder;
    //private int MasterPanpot;
    public int MasterPanpot;
    //private int MasterMute;
    public int MasterMute;
//private int OutputMode;
    public int OutputMode;
//public int Tracks;
    /// <summary>
    /// vsqファイルの各トラックのfader, panpot, muteおよびoutputmode値を保持します
    /// </summary>
    public Vector<VsqMixerEntry> Slave = new Vector<VsqMixerEntry>();

    /// <summary>
    /// このインスタンスのSlave要素に保持されるアイテムの個数。vsqファイルの"トラック数 - 1"に等しい
    /// </summary>
    public int getTracks() {
        return Slave.size();
    }


    /*public property Vector<VsqMixerEntry> Slave {
    get {
    return m_slave;
    }
    set {
    m_slave = value;
    }
    };*/
    /*public property int MasterFeder {
    get {
    return MasterFeder;
    }
    set {
    MasterFeder = value;
    }
    };*/
    /*public property int MasterPanpot {
    get {
    return MasterPanpot;
    }
    set {
    MasterPanpot = value;
    }
    };*/
    /*public property int MasterMute {
    get {
    return MasterMute;
    }
    set {
    MasterMute = value;
    }
    };*/
    /*public property int OutputMode {
    get {
    return MasterMute;
    }
    set {
    MasterMute = value;
    }
    };*/
    public Object clone() {
        VsqMixer res = new VsqMixer( MasterFeder, MasterPanpot, MasterMute, OutputMode );
        res.Slave = new Vector<VsqMixerEntry>();
        //res.Tracks = Tracks;
        for ( int i = 0; i < Slave.size(); i++ ) {
            VsqMixerEntry item = Slave.get( i );
            res.Slave.add( (VsqMixerEntry) item.clone() );
        }
        return res;
    }


    /// <summary>
    /// 各パラメータを指定したコンストラクタ
    /// </summary>
    /// <param name="master_fader">MasterFader値</param>
    /// <param name="master_panpot">MasterPanpot値</param>
    /// <param name="master_mute">MasterMute値</param>
    /// <param name="output_mode">OutputMode値</param>
    public VsqMixer( int master_fader, int master_panpot, int master_mute, int output_mode ) {
        this.MasterFeder = master_fader;
        this.MasterMute = master_mute;
        this.MasterPanpot = master_panpot;
        this.OutputMode = output_mode;
        Slave = new Vector<VsqMixerEntry>();
    }


    /// <summary>
    /// テキストファイルからのコンストラクタ
    /// </summary>
    /// <param name="sr">読み込み対象</param>
    /// <param name="last_line">最後に読み込んだ行が返されます</param>
    public VsqMixer( TextMemoryStream sr, TextResult last_line ) {
        MasterFeder = 0;
        MasterPanpot = 0;
        MasterMute = 0;
        OutputMode = 0;
        //Tracks = 1;
        int tracks = 0;
        String[] spl;
        String buffer = "";
        last_line.set( sr.readLine() );
        while ( !last_line.get().startsWith( "[" ) ) {
            spl = last_line.get().split( "=" );
            if ( spl[0].equals( "MasterFeder" ) ) {
                MasterFeder = Integer.parseInt( spl[1] );
            } else if ( spl[0].equals( "MasterPanpot" ) ) {
                MasterPanpot = Integer.parseInt(
                        spl[1] );
            } else if ( spl[0].equals( "MasterMute" ) ) {
                MasterMute = Integer.parseInt(
                        spl[1] );
            } else if ( spl[0].equals( "OutputMode" ) ) {
                OutputMode = Integer.parseInt(
                        spl[1] );
            } else if ( spl[0].equals( "Tracks" ) ) {
                tracks = Integer.parseInt(
                        spl[1] );
            } else {
                if ( spl[0].startsWith( "Feder" ) ||
                        spl[0].startsWith( "Panpot" ) ||
                        spl[0].startsWith( "Mute" ) ||
                        spl[0].startsWith( "Solo" ) ) {
                    buffer += spl[0] + "=" + spl[1] + "\n";
                }
            }
            if ( sr.peek() < 0 ) {
                break;
            }
            last_line.set( sr.readLine() );
        }

        Slave = new Vector<VsqMixerEntry>();
        for ( int i = 0; i < tracks; i++ ) {
            Slave.add( new VsqMixerEntry( 0, 0, 0, 0 ) );
        }
        spl = buffer.split( "\n" );
        String[] spl2;
        for ( int i = 0; i < spl.length; i++ ) {
            String ind = "";
            int index;
            spl2 = spl[i].split( "=" );
            if ( spl2[0].startsWith( "Feder" ) ) {
                ind = spl2[0].replace( "Feder", "" );
                index = Integer.parseInt(
                        ind );
                Slave.get( index ).Feder = Integer.parseInt(
                        spl2[1] );
            } else if ( spl2[0].startsWith( "Panpot" ) ) {
                ind = spl2[0].replace( "Panpot", "" );
                index = Integer.parseInt(
                        ind );
                Slave.get( index ).Panpot = Integer.parseInt(
                        spl2[1] );
            } else if ( spl2[0].startsWith( "Mute" ) ) {
                ind = spl2[0].replace( "Mute", "" );
                index = Integer.parseInt(
                        ind );
                Slave.get( index ).Mute = Integer.parseInt(
                        spl2[1] );
            } else if ( spl2[0].startsWith( "Solo" ) ) {
                ind = spl2[0].replace( "Solo", "" );
                index = Integer.parseInt(
                        ind );
                Slave.get( index ).Solo = Integer.parseInt(
                        spl2[1] );
            }

        }
    }


    /// <summary>
    /// このインスタンスをテキストファイルに出力します
    /// </summary>
    /// <param name="sw">出力対象</param>
    public void write( TextMemoryStream sw ) {
        sw.writeLine( "[Mixer]" );
        sw.writeLine( "MasterFeder=" + MasterFeder );
        sw.writeLine( "MasterPanpot=" + MasterPanpot );
        sw.writeLine( "MasterMute=" + MasterMute );
        sw.writeLine( "OutputMode=" + OutputMode );
        sw.writeLine( "Tracks=" + getTracks() );
        for ( int i = 0; i < Slave.size(); i++ ) {
            sw.writeLine( "Feder" + i + "=" + Slave.get( i ).Feder );
            sw.writeLine( "Panpot" + i + "=" + Slave.get( i ).Panpot );
            sw.writeLine( "Mute" + i + "=" + Slave.get( i ).Mute );
            sw.writeLine( "Solo" + i + "=" + Slave.get( i ).Solo );
        }
    }

}



