﻿/*
 * EditingBounds.cs
 * Copyright (c) 2009 kbinani
 *
 * This file is part of LipSync.
 *
 * LipSync is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * LipSync is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Drawing;

namespace LipSync {

    public class EditingBounds {
        private Rectangle m_rect;
        private bool m_fixed;
        public bool XFixed;
        public bool YFixed;

        public EditingBounds() {
            m_rect = new Rectangle();
            m_fixed = false;
            XFixed = false;
            YFixed = false;
        }

        public EditingBounds( Rectangle bounds, bool item_fixed, bool x_fixed, bool y_fixed ) {
            m_rect = bounds;
            m_fixed = item_fixed;
            XFixed = x_fixed;
            YFixed = y_fixed;
        }

        public int X {
            get {
                return m_rect.X;
            }
        }

        public int Y {
            get {
                return m_rect.Y;
            }
        }

        public int Width {
            get {
                return m_rect.Width;
            }
        }

        public int Height {
            get {
                return m_rect.Height;
            }
        }

        public bool Fixed {
            get {
                return m_fixed;
            }
        }

        public Rectangle Bounds {
            get {
                return m_rect;
            }
        }
    }

}
