﻿/*
 * FormPreview.cs
 * Copyright (c) 2008-2009 kbinani
 *
 * This file is part of LipSync.
 *
 * LipSync is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * LipSync is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Drawing;
using System.Windows.Forms;

namespace LipSync {

    public partial class FormPreview : Form, IMultiLanguageControl {
        public FormPreview() {
            InitializeComponent();
            Rectangle r = AppManager.Config.PreviewWindowPos;
            Point pt_lt = new Point( r.Left, r.Top );
            Point pt_lb = new Point( r.Left, r.Bottom );
            Point pt_rt = new Point( r.Right, r.Top );
            Point pt_rb = new Point( r.Right, r.Bottom );
            bool visible = false;
            foreach ( Screen s in Screen.AllScreens ) {
                visible = visible | (IsInRectangle( pt_lt, s.Bounds ) | IsInRectangle( pt_lb, s.Bounds ) | IsInRectangle( pt_rt, s.Bounds ) | IsInRectangle( pt_rb, s.Bounds ));
            }
            if ( visible ) {
                this.Left = r.Left;
                this.Top = r.Top;
                this.Width = r.Width;
                this.Height = r.Height;
            } else {
                this.Width = Screen.PrimaryScreen.Bounds.Width / 2;
                this.Height = Screen.PrimaryScreen.Bounds.Height / 2;
                this.Left = this.Width / 2;
                this.Top = this.Height / 2;
            }
            if ( AppManager.Config.PreviewMaximized ) {
                this.WindowState = FormWindowState.Maximized;
            } else {
                this.WindowState = FormWindowState.Normal;
            }
            this.SizeChanged += new EventHandler( FormPreview_LocationOrSizeChanged );
            this.LocationChanged += new EventHandler( FormPreview_LocationOrSizeChanged );
        }

        /// <summary>
        /// rectの中にpointが入っているかどうかを判定
        /// </summary>
        /// <param name="point"></param>
        /// <param name="rect"></param>
        /// <returns></returns>
        private static bool IsInRectangle( Point point, Rectangle rect ) {
            if ( rect.X <= point.X && point.X <= rect.X + rect.Width ) {
                if ( rect.Y <= point.Y && point.Y <= rect.Y + rect.Height ) {
                    return true;
                }
            }
            return false;
        }

        public void ApplyLanguage() {
        }

        public void ApplyFont( Font font ) {
            this.Font = font;
            foreach ( Control c in this.Controls ) {
                Boare.Lib.AppUtil.Misc.ApplyFontRecurse( c, font );
            }
        }

        private void FormPreview_LocationOrSizeChanged( object sender, EventArgs e ) {
            if ( AppManager.Config != null ) {
                if ( this.WindowState == FormWindowState.Normal ) {
                    AppManager.Config.PreviewWindowPos = this.Bounds;
                }
                AppManager.Config.PreviewMaximized = (this.WindowState == FormWindowState.Maximized);
            }
        }
    }

}
