﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Windows.Forms;

using Boare.Lib.AppUtil;

namespace LipSync {

    public partial class FormVocalomark : Form, IMultiLanguageControl {
        private string[] m_image_titles;
        public float BlendLipFromDefault = 0.1f;
        public float BlendLipToDefault = 0.2f;
        public float BlendEyeFromDefault = 0.05f;
        public float BlendEyeToDefault = 0.1f;
        public float BlendEyebrowFromDefault = 0.1f;
        public float BlendEyebrowToDefault = 0.1f;

        public FormVocalomark( Character3 character ) {
            InitializeComponent();
            ApplyFont( AppManager.Config.Font.GetFont() );
            ApplyLanguage();
            m_image_titles = new string[character.Count + 1];
            m_image_titles[0] = "";
            for ( int i = 0; i < character.Count; i++ ) {
                m_image_titles[i + 1] = character[i].title;
            }
            comboLipA.Items.AddRange( m_image_titles );
            comboLipE.Items.AddRange( m_image_titles );
            comboLipI.Items.AddRange( m_image_titles );
            comboLipO.Items.AddRange( m_image_titles );
            comboLipU.Items.AddRange( m_image_titles );
            for ( int i = 0; i < m_image_titles.Length; i++ ) {
                switch ( m_image_titles[i] ) {
                    case "a":
                        comboLipA.SelectedIndex = i;
                        break;
                    case "e":
                        comboLipE.SelectedIndex = i;
                        break;
                    case "i":
                        comboLipI.SelectedIndex = i;
                        break;
                    case "o":
                        comboLipO.SelectedIndex = i;
                        break;
                    case "u":
                        comboLipU.SelectedIndex = i;
                        break;
                }
            }

            comboEyeClose.Items.AddRange( m_image_titles );
            comboEyeSad.Items.AddRange( m_image_titles );
            comboEyeSerious.Items.AddRange( m_image_titles );
            comboEyeSmile.Items.AddRange( m_image_titles );
            comboEyeSurprise.Items.AddRange( m_image_titles );
            comboEyeWinkL.Items.AddRange( m_image_titles );
            comboEyeWinkR.Items.AddRange( m_image_titles );

            comboEyebrowConfuse.Items.AddRange( m_image_titles );
            comboEyebrowSad.Items.AddRange( m_image_titles );
            comboEyebrowSerious.Items.AddRange( m_image_titles );
            comboEyebrowSurprise.Items.AddRange( m_image_titles );

            txtLipBlendFromDefault.Text = BlendLipFromDefault.ToString();
            txtLipBlendToDefault.Text = BlendLipToDefault.ToString();
            txtEyeBlendFromDefault.Text = BlendEyeFromDefault.ToString();
            txtEyeBlendToDefault.Text = BlendEyeToDefault.ToString();
            txtEyebrowBlendFromDefault.Text = BlendEyebrowFromDefault.ToString();
            txtEyebrowBlendToDefault.Text = BlendEyebrowToDefault.ToString();
        }

        private static string _( string id ) {
            return Messaging.GetMessage( id );
        }

        public void ApplyLanguage() {
            groupLip.Text = _( "Lip Assignment" );
            groupEye.Text = _( "Eye Assignment" );
            groupEyebrow.Text = _( "Eyebrow Assignment" );
            btnOK.Text = _( "OK" );
            btnCancel.Text = _( "Cancel" );
            lblEyeBlendFromDefault.Text = _( "Blend time for E_Default -> E_*" );
            lblEyeBlendToDefault.Text = _( "Blend time for E_* -> E_Default" );
            lblEyebrowBlendFromDefault.Text = _( "Blend time for EB_Default -> EB_*" );
            lblEyebrowBlendToDefault.Text = _( "Blend time for EB_* -> EB_Default" );
            lblLipBlendFromDefault.Text = _( "Blend time for L_Default -> L_*" );
            lblLipBlendToDefault.Text = _( "Blend time for L_* -> L_Default" );
        }

        public void ApplyFont( Font font ) {
            Boare.Lib.AppUtil.Misc.ApplyFontRecurse( this, font );
        }

        public KeyValuePair<string, string>[] Assignment {
            get {
                List<KeyValuePair<string, string>> ret = new List<KeyValuePair<string, string>>();
                if ( comboLipA.SelectedIndex > 0 ) {
                    ret.Add( new KeyValuePair<string, string>( "L_A", m_image_titles[comboLipA.SelectedIndex] ) );
                }
                if ( comboLipE.SelectedIndex > 0 ) {
                    ret.Add( new KeyValuePair<string, string>( "L_E", m_image_titles[comboLipE.SelectedIndex] ) );
                }
                if ( comboLipI.SelectedIndex > 0 ) {
                    ret.Add( new KeyValuePair<string, string>( "L_I", m_image_titles[comboLipI.SelectedIndex] ) );
                }
                if ( comboLipO.SelectedIndex > 0 ) {
                    ret.Add( new KeyValuePair<string, string>( "L_O", m_image_titles[comboLipO.SelectedIndex] ) );
                }
                if ( comboLipU.SelectedIndex > 0 ) {
                    ret.Add( new KeyValuePair<string, string>( "L_U", m_image_titles[comboLipU.SelectedIndex] ) );
                }
                if ( comboEyebrowConfuse.SelectedIndex > 0 ) {
                    ret.Add( new KeyValuePair<string, string>( "EB_Confuse", m_image_titles[comboEyebrowConfuse.SelectedIndex] ) );
                }
                if ( comboEyebrowSad.SelectedIndex > 0 ) {
                    ret.Add( new KeyValuePair<string, string>( "EB_Sad", m_image_titles[comboEyebrowSad.SelectedIndex] ) );
                }
                if ( comboEyebrowSerious.SelectedIndex > 0 ) {
                    ret.Add( new KeyValuePair<string, string>( "EB_Serious", m_image_titles[comboEyebrowSerious.SelectedIndex] ) );
                }
                if ( comboEyebrowSurprise.SelectedIndex > 0 ) {
                    ret.Add( new KeyValuePair<string, string>( "EB_Surprise", m_image_titles[comboEyebrowSurprise.SelectedIndex] ) );
                }
                if ( comboEyeClose.SelectedIndex > 0 ) {
                    ret.Add( new KeyValuePair<string, string>( "E_Close", m_image_titles[comboEyeClose.SelectedIndex] ) );
                }
                if ( comboEyeSad.SelectedIndex > 0 ) {
                    ret.Add( new KeyValuePair<string, string>( "E_Sad", m_image_titles[comboEyeSad.SelectedIndex] ) );
                }
                if ( comboEyeSerious.SelectedIndex > 0 ) {
                    ret.Add( new KeyValuePair<string, string>( "E_Serious", m_image_titles[comboEyeSerious.SelectedIndex] ) );
                }
                if ( comboEyeSmile.SelectedIndex > 0 ) {
                    ret.Add( new KeyValuePair<string, string>( "E_Smile", m_image_titles[comboEyeSmile.SelectedIndex] ) );
                }
                if ( comboEyeSurprise.SelectedIndex > 0 ) {
                    ret.Add( new KeyValuePair<string, string>( "E_Surprise", m_image_titles[comboEyeSurprise.SelectedIndex] ) );
                }
                if ( comboEyeWinkL.SelectedIndex > 0 ) {
                    ret.Add( new KeyValuePair<string, string>( "E_WinkL", m_image_titles[comboEyeWinkL.SelectedIndex] ) );
                }
                if ( comboEyeWinkR.SelectedIndex > 0 ) {
                    ret.Add( new KeyValuePair<string, string>( "E_WinkR", m_image_titles[comboEyeWinkR.SelectedIndex] ) );
                }
                return ret.ToArray();
            }
        }

        private void btnOK_Click( object sender, EventArgs e ) {
            this.DialogResult = DialogResult.OK;
        }

        private void txtLipBlendFromDefault_TextChanged( object sender, EventArgs e ) {
            float value;
            if ( float.TryParse( txtLipBlendFromDefault.Text, out value ) ) {
                BlendLipFromDefault = value;
            }
        }

        private void txtLipBlendToDefault_TextChanged( object sender, EventArgs e ) {
            float value;
            if ( float.TryParse( txtLipBlendToDefault.Text, out value ) ) {
                BlendLipToDefault = value;
            }
        }

        private void txtEyeBlendFromDefault_TextChanged( object sender, EventArgs e ) {
            float value;
            if ( float.TryParse( txtEyeBlendFromDefault.Text, out value ) ) {
                BlendEyeFromDefault = value;
            }
        }

        private void txtEyeBlendToDefault_TextChanged( object sender, EventArgs e ) {
            float value;
            if ( float.TryParse( txtEyeBlendToDefault.Text, out value ) ){
                BlendEyeToDefault = value;
            }
        }

        private void txtEyebrowBlendFromDefault_TextChanged( object sender, EventArgs e ) {
            float value;
            if ( float.TryParse( txtEyebrowBlendFromDefault.Text, out value ) ) {
                BlendEyebrowFromDefault = value;
            }
        }

        private void txtEyebrowBlendToDefault_TextChanged( object sender, EventArgs e ) {
            float value;
            if ( float.TryParse( txtEyebrowBlendToDefault.Text, out value ) ) {
                BlendEyebrowToDefault = value;
            }
        }
    }

}
