﻿/*
 * MListView.cs
 * Copyright (c) 2007-2009 kbinani
 *
 * This file is part of LipSync.
 *
 * LipSync is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * LipSync is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System.Drawing;
using System.Windows.Forms;

namespace LipSync {

    public partial class MListView : UserControl {
        private Color m_back_color = SystemColors.Window;

        public MListView() {
            InitializeComponent();
        }

        public ListView.ListViewItemCollection Items {
            get {
                return listView2.Items;
            }
        }

        public bool CheckBoxes {
            get {
                return listView2.CheckBoxes;
            }
            set {
                listView2.CheckBoxes = value;
            }
        }

        new public Color BackColor {
            get {
                return m_back_color;
            }
            set {
                m_back_color = value;
                listView1.BackColor = m_back_color;
                listView2.BackColor = m_back_color;
            }
        }

        public string Header {
            get {
                return listView1.Groups[0].Header;
            }
            set {
                listView1.Groups[0].Header = value;
            }
        }

        public HorizontalAlignment HeaderAlignment {
            get {
                return listView1.Groups[0].HeaderAlignment;
            }
            set {
                listView1.Groups[0].HeaderAlignment = value;
            }
        }
    }

}
