﻿/*
 * Previewer.cs
 * Copyright (c) 2008-2009 kbinani
 *
 * This file is part of LipSync.
 *
 * LipSync is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * LipSync is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Drawing;
using System.Windows.Forms;

using Boare.Lib.AppUtil;

namespace LipSync {

    public partial class Previewer : UserControl {
        /// <summary>
        /// プレビュー用のイメージ．PreviewP.Imageの本体として指定される
        /// </summary>
        Bitmap m_preview = null;

        public event EventHandler PlayPauseClicked;
        public event EventHandler StopClicked;
        public event EventHandler SpeedClicked;
        public event EventHandler CheckMuteCheckedChanged;
        public event MouseEventHandler TrackSpeedMouseUp;
        public event EventHandler TrackSpeedScroll;
        public event EventHandler TrackVolumeScroll;
        public event EventHandler TrackBarScroll;
        public event MouseEventHandler PreviewMouseDoubleClick;
        public event MouseEventHandler PreviewMouseDown;
        public event MouseEventHandler PreviewMouseMove;
        public event MouseEventHandler PreviewMouseUp;
        public event PaintEventHandler PreviewPaint;
        public event EventHandler MenuHundredClick;
        public event EventHandler MenuFitClick;
        public event EventHandler LabelTimeMouseDoubleClick;
        public event EventHandler PreviewSizeChanged;

        public Previewer() {
            InitializeComponent();
        }

        public static string _( string s ) {
            return Messaging.GetMessage( s );
        }

        public Bitmap Image {
            get {
                return m_preview;
            }
            set {
                m_preview = value;
                PreviewP.Image = m_preview;
            }
        }

        #region PropertyProxy
        public string PlayPauseText {
            get {
                return play_pause.Text;
            }
            set {
                play_pause.Text = value;
            }
        }


        public bool PlayPauseEnabled {
            get {
                return play_pause.Enabled;
            }
            set {
                play_pause.Enabled = value;
            }
        }


        public bool CheckMuteChecked {
            get {
                return checkMute.Checked;
            }
            set {
                checkMute.Checked = value;
            }
        }

        public int TrackSpeedValue {
            get {
                return trackSpeed.Value;
            }
            set {
                trackSpeed.Value = value;
            }
        }

        public int TrackVolumeValue {
            get {
                return trackVolume.Value;
            }
            set {
                trackVolume.Value = value;
            }
        }

        public int TrackBarValue {
            get {
                return trackBar1.Value;
            }
            set {
                trackBar1.Value = value;
            }
        }


        public int TrackBarMaximum {
            get {
                return trackBar1.Maximum;
            }
            set {
                trackBar1.Maximum = value;
            }
        }


        public int TrackBarMinimum {
            get {
                return trackBar1.Minimum;
            }
            set {
                trackBar1.Minimum = value;
            }
        }


        public bool TrackBarEnabled {
            get {
                return trackBar1.Enabled;
            }
            set {
                trackBar1.Enabled = value;
            }
        }


        public string LabelTimeText {
            get {
                return lblTime.Text;
            }
            set {
                lblTime.Text = value;
            }
        }


        public string LabelSpeedText {
            get {
                return lblSpeed.Text;
            }
            set {
                lblSpeed.Text = value;
            }
        }


        public PictureBoxSizeMode PreviewSizeMode {
            get {
                return PreviewP.SizeMode;
            }
            set {
                PreviewP.SizeMode = value;
            }
        }


        public int PreviewWidth {
            get {
                return PreviewP.Width;
            }
        }


        public int PreviewHeight {
            get {
                return PreviewP.Height;
            }
        }


        public PictureBox Preview {
            get {
                return PreviewP;
            }
        }
        #endregion

        #region EventHandlerProxy
        private void play_pause_Click( object sender, EventArgs e ) {
            if ( PlayPauseClicked != null ) {
                PlayPauseClicked( sender, e );
            }
        }

        private void stop_Click( object sender, EventArgs e ) {
            if ( StopClicked != null ) {
                StopClicked( sender, e );
            }
        }

        private void btnSpeed_Click( object sender, EventArgs e ) {
            if ( SpeedClicked != null ) {
                SpeedClicked( sender, e );
            }
        }

        private void checkMute_CheckedChanged( object sender, EventArgs e ) {
            if ( CheckMuteCheckedChanged != null ) {
                CheckMuteCheckedChanged( sender, e );
            }
        }

        private void trackSpeed_MouseUp( object sender, MouseEventArgs e ) {
            if ( TrackSpeedMouseUp != null ) {
                TrackSpeedMouseUp( sender, e );
            }
        }

        private void trackSpeed_Scroll( object sender, EventArgs e ) {
            if ( TrackSpeedScroll != null ) {
                TrackSpeedScroll( sender, e );
            }
        }

        private void trackVolume_Scroll( object sender, EventArgs e ) {
            if ( TrackVolumeScroll != null ) {
                TrackVolumeScroll( sender, e );
            }
        }

        private void trackBar1_Scroll( object sender, EventArgs e ) {
            if ( TrackBarScroll != null ) {
                TrackBarScroll( sender, e );
            }
        }

        private void PreviewP_MouseDoubleClick( object sender, MouseEventArgs e ) {
            if ( PreviewMouseDoubleClick != null ) {
                PreviewMouseDoubleClick( sender, e );
            }
        }

        private void PreviewP_MouseDown( object sender, MouseEventArgs e ) {
            if ( PreviewMouseDown != null ) {
                PreviewMouseDown( sender, e );
            }
        }

        private void PreviewP_MouseMove( object sender, MouseEventArgs e ) {
            if ( AppManager.Playing ) {
                return;
            }
            if ( PreviewMouseMove != null ) {
                PreviewMouseMove( sender, e );
            }
            PreviewP.Invalidate();
        }

        private void PreviewP_MouseUp( object sender, MouseEventArgs e ) {
            if ( PreviewMouseUp != null ) {
                PreviewMouseUp( sender, e );
            }
        }

        private void PreviewP_Paint( object sender, PaintEventArgs e ) {
            if ( PreviewPaint != null ) {
                PreviewPaint( sender, e );
            }
        }

        private void menuHundred_Click( object sender, EventArgs e ) {
            if ( MenuHundredClick != null ) {
                MenuHundredClick( sender, e );
            }
        }

        private void menuFit_Click( object sender, EventArgs e ) {
            if ( MenuFitClick != null ) {
                MenuFitClick( sender, e );
            }
        }

        private void lblTime_MouseDoubleClick( object sender, MouseEventArgs e ) {
            if ( LabelTimeMouseDoubleClick != null ) {
                LabelTimeMouseDoubleClick( sender, e );
            }
        }
        #endregion

        private void Previewer_Paint( object sender, PaintEventArgs e ) {
            PreviewP.Refresh();
        }

        private void Previewer_FontChanged( object sender, EventArgs e ) {
            contextMenuStrip1.Font = this.Font;
        }

        private void PreviewP_SizeChanged( object sender, EventArgs e ) {
            if ( PreviewSizeChanged != null ) {
                PreviewSizeChanged( sender, e );
            }
        }
    }

}
