﻿/*
 * TrackSelecter.cs
 * Copyright (c) 2007-2009 kbinani
 *
 * This file is part of LipSync.
 *
 * LipSync is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * LipSync is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Drawing;
using System.Windows.Forms;

using Boare.Lib.AppUtil;

namespace LipSync {

    public partial class TrackSelecter : Form, IMultiLanguageControl {
        public TrackSelecter( string file_name, string[] track_names ) {
            InitializeComponent();
            ApplyLanguage();
            ApplyFont( AppManager.Config.Font.GetFont() );
            checkedListBox1.Items.Clear();
            for ( int i = 0; i < track_names.Length; i++ ) {
                if ( track_names[i] != "Master Track" ) {
                    checkedListBox1.Items.Add( track_names[i], true );
                } else {
                    checkedListBox1.Items.Add( track_names[i], false );
                }
            }
            textBox1.Text = file_name;
        }

        public void ApplyFont( Font font ) {
            this.Font = font;
            foreach ( Control c in this.Controls ) {
                Boare.Lib.AppUtil.Misc.ApplyFontRecurse( c, font );
            }
        }

        public void ApplyLanguage() {
            this.button1.Text = _( "Cancel" );
            this.button2.Text = _( "OK" );
            this.Text = _( "Select track" );
            this.checkImportTempoAndTimesig.Text = _( "import tempo and time-signal information" );
        }

        public string _( string s ) {
            return Messaging.GetMessage( s );
        }
        
        public bool ImportTempoAndTimesig {
            get {
                return checkImportTempoAndTimesig.Checked;
            }
            set {
                checkImportTempoAndTimesig.Checked = value;
            }
        }

        public int[] CheckedItem {
            get {
                int count = 0;
                for ( int i = 0; i < checkedListBox1.Items.Count; i++ ) {
                    if ( checkedListBox1.GetItemChecked( i ) ) {
                        count++;
                    }
                }
                int[] list = new int[count];
                //MessageBox.Show( "count=" + count );
                count = -1;
                for ( int i = 0; i < checkedListBox1.Items.Count; i++ ) {
                    //MessageBox.Show( "item no." + i + " GetItemChecked=" + checkedListBox1.GetItemChecked( i ) );
                    if ( checkedListBox1.GetItemChecked( i ) ) {
                        count++;
                        list[count] = i;
                    }
                }
                return list;
            }
        }

        private void button2_Click( object sender, EventArgs e ) {
            this.DialogResult = DialogResult.OK;
            this.Close();
        }

        private void button1_Click( object sender, EventArgs e ) {
            this.DialogResult = DialogResult.Cancel;
            this.Close();
        }
    }

}
