<?php
/**
 *  Secioss_Unit.php
 *
 *  @author     {$author}
 *  @package    Secioss
 *  @version    $Id: skel.app_object.php,v 1.3 2006/11/06 14:31:24 cocoitiban Exp $
 */
require_once 'Secioss_AppObject.php';

/**
 *  Secioss_UnitManager
 *
 *  @author     {$author}
 *  @access     public
 *  @package    Secioss
 */
class Secioss_UnitManager extends Ethna_AppManager
{
}

/**
 *  Secioss_Unit
 *
 *  @author     {$author}
 *  @access     public
 *  @package    Secioss
 */
class Secioss_Unit extends Secioss_AppObject
{
    /**
     *  プロパティの表示名を取得する
     *
     *  @access public
     */
    function getName($key)
    {
        return $this->get($key);
    }

    function searchProp($keys = null, $filter = null, $order = null,
                        $offset = null, $count = null)
    {
        $conf = $this->config->get('secioss');
        $num = 0;
        $list = array();

        $r = parent::searchProp($keys, $filter, $order, $offset, $count);
        if (Ethna::isError($r)) {
            return $r;
        }

        for ($i = 0; $i < $r[0]; $i++) {
            $sr = @ldap_list($this->my_ldap, $r[1][$i]['id'], '(objectClass=*)');
            if ($r) {
                $entries = ldap_get_entries($this->my_ldap, $sr);
                foreach ($entries as $entry) {
                    if (preg_match('/^'.$conf['user']['objectdn'].',/i', $entry['dn'])) {
                        $num++;
                        $list[] = $r[1][$i];
                        break;
                    }
                }
            } else {
                return Ethna::raiseError(ldap_error($this->my_ldap));
            }
            ldap_free_result($sr);
        }

        return array($num, $list);
    }
}
?>
