<?php
/**
 *  Sync/Update.php
 *
 *  @author     {$author}
 *  @package    Secioss
 *  @version    $Id: skel.action.php,v 1.10 2006/11/06 14:31:24 cocoitiban Exp $
 */

/**
 *  sync_updateフォームの実装
 *
 *  @author     {$author}
 *  @access     public
 *  @package    Secioss
 */
class Secioss_Form_SyncUpdate extends Secioss_ActionForm
{
    /** @var    bool    バリデータにプラグインを使うフラグ */
    var $use_validator_plugin = true;

    /**
     *  @access private
     *  @var    array   フォーム値定義
     */
    var $form = array(
        'sync_systems' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN,
            'required'      => true
        ),
        'master_systems' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN,
            'required'      => true
        ),
        'filter'  => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN,
        )
    );
}

/**
 *  sync_updateアクションの実装
 *
 *  @author     {$author}
 *  @access     public
 *  @package    Secioss
 */
class Secioss_Action_SyncUpdate extends Secioss_ActionClass
{
    /**
     *  sync_updateアクションの前処理
     *
     *  @access public
     *  @return string      遷移名(正常終了ならnull, 処理終了ならfalse)
     */
    function prepare()
    {
        return null;
    }

    /**
     *  sync_updateアクションの実装
     *
     *  @access public
     *  @return string  遷移名
     */
    function perform()
    {
        $auth =& $this->backend->getManager('Auth');
        $logger =& $this->backend->getLogger();
        $conf = $this->config->get('secioss');
        $login_user = $this->session->get('user');

        $base = null;
        $tenant = $this->session->get('tenant');
        if (isset($conf['area']['id']) && $tenant) {
            $base = isset($conf['system']) ? 'ou=Master,'.$conf['basedn'] : $conf['basedn'];
            $base = $conf['area']['id']."=$tenant,$base";
        }

        $filter = $this->af->get('filter');
        //エスケープしていた空白を元にもどす
        $filter = preg_replace('/\\\20/'," ",$filter);
        $master_systems = $this->af->get('master_systems');
        $sync_systems = $this->af->get('sync_systems');

        if ($sync_systems) {
            if ($auth->updateSync('cluster', $sync_systems, $filter, $base)) {
                $logger->log(LOG_ERR, "$login_user failed to update lismsync");
                $this->ae->add(null, _et(S_INTERNAL_ERR_MSG));

                return 'sync_update';
            }
        }
        if ($master_systems) {
            if($auth->updateSync('master', $master_systems, $filter, $base)) {
                $logger->log(LOG_ERR, "$login_user failed to update lismsync");
                $this->ae->add(null, _et(S_INTERNAL_ERR_MSG));

                return 'sync_update';
            }
        }

        $this->af->setApp('message', _et(O_SYNC_SUCCESS_MSG));

        return 'sync_update';
    }
}
?>
