<?php
/**
 *  System/Update.php
 *
 *  @author     {$author}
 *  @package    Secioss
 *  @version    $Id: skel.action.php 387 2006-11-06 14:31:24Z cocoitiban $
 */

/**
 *  System_Updateフォームの実装
 *
 *  @author     {$author}
 *  @access     public
 *  @package    Secioss
 */
class Secioss_Form_SystemUpdate extends Secioss_ActionForm
{
    /** @var    bool    バリデータにプラグインを使うフラグ */
    var $use_validator_plugin = true;

    /**
     *  @access private
     *  @var    array   フォーム値定義
     */
    var $form = array(
        'dn' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN,
            'name'          => 'ID'
        ),
        'synctype' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN,
            'name'          => '同期サーバのタイプ'
        ),
        'ldaptype' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN,
            'name'          => 'LDAPサーバの種類'
        ),
        'ldapuri' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => 'LDAPサーバのURI',
            'regexp'        => '/^ldaps?:\/\/.+/'
        ),
        'basedn' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => 'LDAPサーバのベースDN',
        ),
        'binddn' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_TEXT,
            'name'          => 'LDAPサーバのユーザ名',
        ),
        'bindpw' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_PASSWORD,
            'name'          => 'LDAPサーバのパスワード',
        ),
        'pwhash' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_SELECT,
            'name'          => 'パスワードハッシュ形式',
            'option'        => array('PLAINTEXT' => 'PLAINTEXT', 'CRYPT' => 'CRYPT', 'MD5' => 'MD5', 'SHA' => 'SHA', 'AD' => 'Active Directory')
        ),
        'operation' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN
        )
    );
}

/**
 *  System_Updateアクションの実装
 *
 *  @author     {$author}
 *  @access     public
 *  @package    Secioss
 */
class Secioss_Action_SystemUpdate extends Secioss_ActionClass
{
    /**
     *  System_Updateアクションの前処理
     *
     *  @access public
     *  @return string      遷移名(正常終了ならnull, 処理終了ならfalse)
     */
    function prepare()
    {
        if ($this->af->get('operation') == 'update' && $this->af->validate() > 0) {
            $this->ae->add(null, $this->getInvalidValMsg($this->getErrorFormName()));

            return 'System_Update';
        }

        return null;
    }

    /**
     *  System_Updateアクションの実装
     *
     *  @access public
     *  @return string  遷移名
     */
    function perform()
    {
        $confmgr =& $this->backend->getManager('Config');
        $logger = & $this->backend->getLogger();
        $login_user = $this->session->get('user');

        $id = $this->af->get('dn');
        $ldaptype = $this->af->get('ldaptype');
        $ldapuri = $this->af->get('ldapuri');
        $basedn = $this->af->get('basedn');
        $binddn = $this->af->get('binddn');
        $bindpw = $this->af->get('bindpw');
        $op = $this->af->get('operation');
        $conf = $this->config->get('secioss');

        if ($ldaptype == 'AD') {
            $this->af->set('pwhash', 'AD');
        }
        $hash = $this->af->get('pwhash');

        if ($op == 'update') {
            $params['uri'] = $ldapuri;
            $params['basedn'] = $basedn;
            $params['binddn'] = $binddn;
            if($bindpw) {
                $params['bindpw'] = $bindpw;
            }
            $params['hash'] = $hash;

            $r = $confmgr->setXmlFile(LISMCONF, $params, $id);
            if(Ethna::isError($r)) {
                $logger->log(LOG_ERR,$r->getMessage());
                $this->ae->add(null, _et(S_INTERNAL_ERR_MSG));

                return 'System_Update';
            }
            if (system(LISMRELOAD) === false) {
                $logger->log(LOG_ERR,$r->getMessage());
                $this->ae->add(null, _et(C_RELOAD_ERR_MSG));

                return 'System_Update';
            }

            $this->af->setApp('message', _et(C_UPDATE_SUCCESS_MSG));
            $logger->log(LOG_INFO, "Succeeded to add LDAP config");
        } else {
            $params = array('master', 'storage', 'uri', 'basedn', 'binddn', 'hash');
            $values = $confmgr->getXmlFile(LISMCONF, $params, $id);
            if(Ethna::isError($values)) {
                $logger->log(LOG_ERR, $values->getMessage());
                $this->ae->add(null, _et(S_INTERNAL_ERR_MSG));

                return 'System_Update';
            }

            $this->af->set('ldaptype', $values[1]);
            $this->af->set('ldapuri', $values[2]);
            $this->af->set('basedn', $values[3]);
            $this->af->set('binddn', $values[4]);
            $this->af->set('pwhash', $values[5]);
            if ($values[0] == $id) {
                $this->af->set('synctype', 'master');
            } else {
                $this->af->set('synctype', 'slave');
            }
        }

        return 'System_Update';
    }
}
?>
