<?php
/**
 *  User/ImportCSV.php
 *
 *  @author     {$author}
 *  @package    Secioss
 *  @version    $Id: skel.action.php,v 1.10 2006/11/06 14:31:24 cocoitiban Exp $
 */

/**
 *  user_ImportCSVフォームの実装
 *
 *  @author     {$author}
 *  @access     public
 *  @package    Secioss
 */
class Secioss_Form_UserImportCSV extends Secioss_ActionForm
{
    /** @var    bool    バリデータにプラグインを使うフラグ */
    var $use_validator_plugin = true;

    /**
     *  @access private
     *  @var    array   フォーム値定義
     */
    var $form = array(
        'file' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_FILE,
            'name'          => 'CSVファイル'
        ),
        'operation' => array(
            'type'          => VAR_TYPE_STRING,
            'form_type'     => FORM_TYPE_HIDDEN
        )
    );

}

/**
 *  user_ImportCSVアクションの実装
 *
 *  @author     {$author}
 *  @access     public
 *  @package    Secioss
 */
class Secioss_Action_UserImportCSV extends Secioss_ActionClass
{
    /**
     *  user_ImportCSVアクションの前処理
     *
     *  @access public
     *  @return string      遷移名(正常終了ならnull, 処理終了ならfalse)
     */
    function prepare()
    {
        if (!isset($_FILES['file']['name']) || !$_FILES['file']['name']) {
            return 'user_importCSV';
        }

        if ($this->af->validate() > 0) {
            return 'user_importCSV';
        }

        return null;
    }

    /**
     *  user_ImportCSVアクションの実装
     *
     *  @access public
     *  @return string  遷移名
     */
    function perform()
    {
        $auth =& $this->backend->getManager('Auth');
        $logger =& $this->backend->getLogger();
        $login_user = $this->session->get('user');
        $conf = $this->config->get('secioss');

        $role = $this->session->get('role');

        if ($_FILES['file']['size'] == 0) {
            $this->ae->add(null, S_INTERNAL_ERR_MSG);

            return 'user_importCSV';
        }

        while ($line = FILE::readLine($_FILES['file']['tmp_name'])) {
            if (PEAR::isError($line)) {
                $logger->log(LOG_ERR, "$login_user failed to read ".$_FILES['file']['name'].": ".$line->getMessage());
                $this->ae->add(null, S_INTERNAL_ERR_MSG);

                return 'user_importCSV';
            }

            $line = mb_convert_encoding($line, "utf-8", "sjis,jis,ascii,euc-jp,utf-8");
            $data = split(',', $line);
            if (count($data) < 7) {
                $this->ae->add(null, S_INVALID_INPUT_VALUE_MSG);

                return 'user_importCSV';
            }

            $prop = array(
                'uid' => $data[0],
                'employeenumber' => $data[1],
                'cn' => $data[2]." ".$data[3],
                'sn' => $data[2],
                'mail' => $data[6]
               );

            if ($data[3]) {
                $prop['givenname'] = $data[3];
            }
            if ($data[4]) {
                $prop['cn;lang-ja;phonetic'] = $data[4]." ".$data[5];
                $prop['sn;lang-ja;phonetic'] = $data[4];
            }
            if ($data[5]) {
                $prop['givenname;lang-ja;phonetic'] = $data[5];
            }
            if ($data[7]) {
                $prop['userpassword'] = $data[7];
            }

            $opt_num = 8;
            if (isset($conf['user']['loginidattr'])) {
                $prop[$conf['user']['loginidattr']] = $data[$opt_num];
                $opt_num++;
            }
            if (isset($conf['user']['statusattr'])) {
                $prop[$conf['user']['statusattr']] = $data[$opt_num];
                $opt_num++;
            }
            if (isset($conf['area'])) {
                if ($role == 'system_admin') {
                    $prop['area'] = $data[$opt_num];
                    $opt_num++;
                } else {
                    $prop['area'] = $this->session->get('tenant');
                }
            }
            if (isset($conf['user']['pwlodurationattr'])) {
                $prop['pwdattribute'] = '2.5.4.35';
            }
            if (isset($conf['system'])) {
                if ($data[$opt_num]) {
                    $prop['system'] = $data[$opt_num];
                } else {
                    $prop['system'] = 'master';
                }
            }

            // add user data
            $user = $auth->addObject('user', $prop);
            if (Ethna::isError($user)) {
                $logger->log(LOG_ERR, "$login_user failed to add the user($data[0]): ".$user->getMessage());
                $this->af->setApp('record', $data[0]);
                $this->ae->add(null, O_ADD_ERR_MSG);

                return 'user_importCSV';
            }

        }

        $this->af->setApp('message', O_ADD_SUCCESS_MSG);
        $logger->log(LOG_INFO, "$login_user succeded to import ".$_FILES['file']['name']);

        return 'user_importCSV';
    }
}
?>
