<?php
/**
 *  User/Create.php
 *
 *  @author     {$author}
 *  @package    Secioss
 *  @version    $Id: skel.view.php,v 1.8 2006/11/06 14:31:24 cocoitiban Exp $
 */

/**
 *  user_createビューの実装
 *
 *  @author     {$author}
 *  @access     public
 *  @package    Secioss
 */
class Secioss_View_UserCreate extends Secioss_ViewClass
{
    /**
     *  遷移前処理
     *
     *  @access public
     */
    function preforward()
    {
        $auth =& $this->backend->getManager('Auth');
        $confmgr =& $this->backend->getManager('Config');
        $logger =& $this->backend->getLogger();
        $conf = $this->config->get('secioss');

        $this->af->system_select = $auth->getAttrList('system');

        if (isset($conf['sync'])) {
            $this->af->sync_select = $conf['sync'];
        }

        if ($this->session->get('role') == 'system_admin') {
            $list = $auth->getAttrList('area');
            if (Ethna::isError($list)) {
                $logger->log(LOG_ERR, "Failed to get the tenants: ".$list->getMessage());
                $this->ae->add(null, S_INTERNAL_ERR_MSG);

                return;
            }
            $this->af->tenant_select = $list;
        }

        $list = $auth->getAttrList('unit_user');
        if (Ethna::isError($list)) {
            $logger->log(LOG_ERR, "Failed to get the units: ".$list->getMessage());
            $this->ae->add(null, S_INTERNAL_ERR_MSG);

            return;
        }
        $this->af->unit_select = $list;

        $conf = $this->config->get('ldap');
        $type = $this->session->get('ldaptype');
        if (!$type) {
            if (isset($conf['type'])) {
                if ($conf['type'] != 'LISM') {
                    $type = $conf['type'];
                } else {
                    $type = $auth->readCluster('master');
                    if(Ethna::isError($type)) {
                        $logger->log(LOG_ERR, $type->getMessage());
                        return;
                    }
                }
            } else {
                if (file_exists(CONFIG)) {
                    $values = $confmgr->getIniFile(CONFIG, array('pwhash'));
                    if(Ethna::isError($values)) {
                        $logger->log(LOG_ERR,$values->getMessage());
                        $this->ae->add(null, S_INTERNAL_ERR_MSG);

                        return;
                    }
                    $type = $values[0] == 'AD' ? 'AD' : 'LDAP';
                }
            }
            $this->session->set('ldaptype', $type);
        }
    }
}
?>
