/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Iterator;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.modeler.Registry;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ActionHook;
import org.apache.coyote.Adapter;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.RequestGroupInfo;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.http11.Http11AprProcessor;
import org.apache.tomcat.util.net.AprEndpoint;
import org.apache.tomcat.util.res.StringManager;

public class Http11AprProtocol
implements ProtocolHandler,
MBeanRegistration {
    protected static StringManager sm = StringManager.getManager((String)"org.apache.coyote.http11");
    ObjectName tpOname;
    ObjectName rgOname;
    protected AprEndpoint ep = new AprEndpoint();
    protected boolean secure;
    protected Hashtable attributes = new Hashtable();
    private int maxKeepAliveRequests = 100;
    private int timeout = 300000;
    private int maxSavePostSize = 4096;
    private int maxHttpHeaderSize = 4096;
    private int socketCloseDelay = -1;
    private boolean disableUploadTimeout = true;
    private int socketBuffer = 9000;
    private Adapter adapter;
    private Http11ConnectionHandler cHandler = new Http11ConnectionHandler(this);
    private String compression = "off";
    private String noCompressionUserAgents = null;
    private String restrictedUserAgents = null;
    private String compressableMimeTypes = "text/html,text/xml,text/plain";
    private int compressionMinSize = 2048;
    private String server;
    protected static Log log = LogFactory.getLog(Http11AprProtocol.class);
    protected String domain;
    protected ObjectName oname;
    protected MBeanServer mserver;

    public Http11AprProtocol() {
        this.setSoLinger(-1);
        this.setSoTimeout(60000);
        this.setTcpNoDelay(true);
    }

    public void setAttribute(String name, Object value) {
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("http11protocol.setattribute", (Object)name, value));
        }
        this.attributes.put(name, value);
    }

    public Object getAttribute(String key) {
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("http11protocol.getattribute", (Object)key));
        }
        return this.attributes.get(key);
    }

    public Iterator getAttributeNames() {
        return this.attributes.keySet().iterator();
    }

    public void setProperty(String name, String value) {
        this.setAttribute(name, value);
    }

    public String getProperty(String name) {
        return (String)this.getAttribute(name);
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    public void init() throws Exception {
        this.ep.setName(this.getName());
        this.ep.setHandler((AprEndpoint.Handler)this.cHandler);
        try {
            this.ep.init();
        }
        catch (Exception ex) {
            log.error((Object)sm.getString("http11protocol.endpoint.initerror"), (Throwable)ex);
            throw ex;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("http11protocol.init", (Object)this.getName()));
        }
    }

    public void start() throws Exception {
        if (this.domain != null) {
            try {
                this.tpOname = new ObjectName(this.domain + ":" + "type=ThreadPool,name=" + this.getName());
                Registry.getRegistry(null, null).registerComponent((Object)this.ep, this.tpOname, null);
            }
            catch (Exception e) {
                log.error((Object)"Can't register threadpool");
            }
            this.rgOname = new ObjectName(this.domain + ":type=GlobalRequestProcessor,name=" + this.getName());
            Registry.getRegistry(null, null).registerComponent((Object)this.cHandler.global, this.rgOname, null);
        }
        try {
            this.ep.start();
        }
        catch (Exception ex) {
            log.error((Object)sm.getString("http11protocol.endpoint.starterror"), (Throwable)ex);
            throw ex;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("http11protocol.start", (Object)this.getName()));
        }
    }

    public void pause() throws Exception {
        try {
            this.ep.pause();
        }
        catch (Exception ex) {
            log.error((Object)sm.getString("http11protocol.endpoint.pauseerror"), (Throwable)ex);
            throw ex;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("http11protocol.pause", (Object)this.getName()));
        }
    }

    public void resume() throws Exception {
        try {
            this.ep.resume();
        }
        catch (Exception ex) {
            log.error((Object)sm.getString("http11protocol.endpoint.resumeerror"), (Throwable)ex);
            throw ex;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("http11protocol.resume", (Object)this.getName()));
        }
    }

    public void destroy() throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("http11protocol.stop", (Object)this.getName()));
        }
        this.ep.destroy();
        if (this.tpOname != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.tpOname);
        }
        if (this.rgOname != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.rgOname);
        }
    }

    public int getMaxThreads() {
        return this.ep.getMaxThreads();
    }

    public void setMaxThreads(int maxThreads) {
        this.ep.setMaxThreads(maxThreads);
        this.setAttribute("maxThreads", "" + maxThreads);
    }

    public void setThreadPriority(int threadPriority) {
        this.ep.setThreadPriority(threadPriority);
        this.setAttribute("threadPriority", "" + threadPriority);
    }

    public int getThreadPriority() {
        return this.ep.getThreadPriority();
    }

    public int getBacklog() {
        return this.ep.getBacklog();
    }

    public void setBacklog(int i) {
        this.ep.setBacklog(i);
        this.setAttribute("backlog", "" + i);
    }

    public int getPort() {
        return this.ep.getPort();
    }

    public void setPort(int port) {
        this.ep.setPort(port);
        this.setAttribute("port", "" + port);
    }

    public int getFirstReadTimeout() {
        return this.ep.getFirstReadTimeout();
    }

    public void setFirstReadTimeout(int i) {
        this.ep.setFirstReadTimeout(i);
        this.setAttribute("firstReadTimeout", "" + i);
    }

    public int getPollTime() {
        return this.ep.getPollTime();
    }

    public void setPollTime(int i) {
        this.ep.setPollTime(i);
        this.setAttribute("pollTime", "" + i);
    }

    public void setPollerSize(int i) {
        this.ep.setPollerSize(i);
        this.setAttribute("pollerSize", "" + i);
    }

    public int getPollerSize() {
        return this.ep.getPollerSize();
    }

    public void setSendfileSize(int i) {
        this.ep.setSendfileSize(i);
        this.setAttribute("sendfileSize", "" + i);
    }

    public int getSendfileSize() {
        return this.ep.getSendfileSize();
    }

    public boolean getUseSendfile() {
        return this.ep.getUseSendfile();
    }

    public void setUseSendfile(boolean useSendfile) {
        this.ep.setUseSendfile(useSendfile);
    }

    public InetAddress getAddress() {
        return this.ep.getAddress();
    }

    public void setAddress(InetAddress ia) {
        this.ep.setAddress(ia);
        this.setAttribute("address", "" + ia);
    }

    public String getName() {
        String encodedAddr = "";
        if (this.getAddress() != null) {
            encodedAddr = "" + this.getAddress();
            if (encodedAddr.startsWith("/")) {
                encodedAddr = encodedAddr.substring(1);
            }
            encodedAddr = URLEncoder.encode(encodedAddr) + "-";
        }
        return "http-" + encodedAddr + this.ep.getPort();
    }

    public boolean getTcpNoDelay() {
        return this.ep.getTcpNoDelay();
    }

    public void setTcpNoDelay(boolean b) {
        this.ep.setTcpNoDelay(b);
        this.setAttribute("tcpNoDelay", "" + b);
    }

    public boolean getDisableUploadTimeout() {
        return this.disableUploadTimeout;
    }

    public void setDisableUploadTimeout(boolean isDisabled) {
        this.disableUploadTimeout = isDisabled;
    }

    public int getSocketBuffer() {
        return this.socketBuffer;
    }

    public void setSocketBuffer(int valueI) {
        this.socketBuffer = valueI;
    }

    public String getCompression() {
        return this.compression;
    }

    public void setCompression(String valueS) {
        this.compression = valueS;
        this.setAttribute("compression", valueS);
    }

    public int getMaxSavePostSize() {
        return this.maxSavePostSize;
    }

    public void setMaxSavePostSize(int valueI) {
        this.maxSavePostSize = valueI;
        this.setAttribute("maxSavePostSize", "" + valueI);
    }

    public int getMaxHttpHeaderSize() {
        return this.maxHttpHeaderSize;
    }

    public void setMaxHttpHeaderSize(int valueI) {
        this.maxHttpHeaderSize = valueI;
        this.setAttribute("maxHttpHeaderSize", "" + valueI);
    }

    public String getRestrictedUserAgents() {
        return this.restrictedUserAgents;
    }

    public void setRestrictedUserAgents(String valueS) {
        this.restrictedUserAgents = valueS;
        this.setAttribute("restrictedUserAgents", valueS);
    }

    public String getNoCompressionUserAgents() {
        return this.noCompressionUserAgents;
    }

    public void setNoCompressionUserAgents(String valueS) {
        this.noCompressionUserAgents = valueS;
        this.setAttribute("noCompressionUserAgents", valueS);
    }

    public String getCompressableMimeType() {
        return this.compressableMimeTypes;
    }

    public void setCompressableMimeType(String valueS) {
        this.compressableMimeTypes = valueS;
        this.setAttribute("compressableMimeTypes", valueS);
    }

    public int getCompressionMinSize() {
        return this.compressionMinSize;
    }

    public void setCompressionMinSize(int valueI) {
        this.compressionMinSize = valueI;
        this.setAttribute("compressionMinSize", "" + valueI);
    }

    public int getSoLinger() {
        return this.ep.getSoLinger();
    }

    public void setSoLinger(int i) {
        this.ep.setSoLinger(i);
        this.setAttribute("soLinger", "" + i);
    }

    public int getSoTimeout() {
        return this.ep.getSoTimeout();
    }

    public void setSoTimeout(int i) {
        this.ep.setSoTimeout(i);
        this.setAttribute("soTimeout", "" + i);
    }

    public String getProtocol() {
        return this.getProperty("protocol");
    }

    public void setProtocol(String k) {
        this.setSecure(true);
        this.setAttribute("protocol", k);
    }

    public boolean getSecure() {
        return this.secure;
    }

    public void setSecure(boolean b) {
        this.secure = b;
        this.setAttribute("secure", "" + b);
    }

    public int getMaxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public void setMaxKeepAliveRequests(int mkar) {
        this.maxKeepAliveRequests = mkar;
        this.setAttribute("maxKeepAliveRequests", "" + mkar);
    }

    public boolean getKeepAlive() {
        return this.maxKeepAliveRequests != 0 && this.maxKeepAliveRequests != 1;
    }

    public void setKeepAlive(boolean keepAlive) {
        if (!keepAlive) {
            this.setMaxKeepAliveRequests(1);
        }
    }

    public int getSocketCloseDelay() {
        return this.socketCloseDelay;
    }

    public void setSocketCloseDelay(int d) {
        this.socketCloseDelay = d;
        this.setAttribute("socketCloseDelay", "" + d);
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getServer() {
        return this.server;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeouts) {
        this.timeout = timeouts;
        this.setAttribute("timeout", "" + timeouts);
    }

    public String getSSLEngine() {
        return this.ep.getSSLEngine();
    }

    public void setSSLEngine(String SSLEngine) {
        this.ep.setSSLEngine(SSLEngine);
    }

    public String getSSLProtocol() {
        return this.ep.getSSLProtocol();
    }

    public void setSSLProtocol(String SSLProtocol) {
        this.ep.setSSLProtocol(SSLProtocol);
    }

    public String getSSLPassword() {
        return this.ep.getSSLPassword();
    }

    public void setSSLPassword(String SSLPassword) {
        this.ep.setSSLPassword(SSLPassword);
    }

    public String getSSLCipherSuite() {
        return this.ep.getSSLCipherSuite();
    }

    public void setSSLCipherSuite(String SSLCipherSuite) {
        this.ep.setSSLCipherSuite(SSLCipherSuite);
    }

    public String getSSLCertificateFile() {
        return this.ep.getSSLCertificateFile();
    }

    public void setSSLCertificateFile(String SSLCertificateFile) {
        this.ep.setSSLCertificateFile(SSLCertificateFile);
    }

    public String getSSLCertificateKeyFile() {
        return this.ep.getSSLCertificateKeyFile();
    }

    public void setSSLCertificateKeyFile(String SSLCertificateKeyFile) {
        this.ep.setSSLCertificateKeyFile(SSLCertificateKeyFile);
    }

    public String getSSLCertificateChainFile() {
        return this.ep.getSSLCertificateChainFile();
    }

    public void setSSLCertificateChainFile(String SSLCertificateChainFile) {
        this.ep.setSSLCertificateChainFile(SSLCertificateChainFile);
    }

    public String getSSLCACertificatePath() {
        return this.ep.getSSLCACertificatePath();
    }

    public void setSSLCACertificatePath(String SSLCACertificatePath) {
        this.ep.setSSLCACertificatePath(SSLCACertificatePath);
    }

    public String getSSLCACertificateFile() {
        return this.ep.getSSLCACertificateFile();
    }

    public void setSSLCACertificateFile(String SSLCACertificateFile) {
        this.ep.setSSLCACertificateFile(SSLCACertificateFile);
    }

    public String getSSLCARevocationPath() {
        return this.ep.getSSLCARevocationPath();
    }

    public void setSSLCARevocationPath(String SSLCARevocationPath) {
        this.ep.setSSLCARevocationPath(SSLCARevocationPath);
    }

    public String getSSLCARevocationFile() {
        return this.ep.getSSLCARevocationFile();
    }

    public void setSSLCARevocationFile(String SSLCARevocationFile) {
        this.ep.setSSLCARevocationFile(SSLCARevocationFile);
    }

    public String getSSLVerifyClient() {
        return this.ep.getSSLVerifyClient();
    }

    public void setSSLVerifyClient(String SSLVerifyClient) {
        this.ep.setSSLVerifyClient(SSLVerifyClient);
    }

    public int getSSLVerifyDepth() {
        return this.ep.getSSLVerifyDepth();
    }

    public void setSSLVerifyDepth(int SSLVerifyDepth) {
        this.ep.setSSLVerifyDepth(SSLVerifyDepth);
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    static class Http11ConnectionHandler
    implements AprEndpoint.Handler {
        Http11AprProtocol proto;
        static int count = 0;
        RequestGroupInfo global = new RequestGroupInfo();
        ThreadLocal localProcessor = new ThreadLocal();

        Http11ConnectionHandler(Http11AprProtocol proto) {
            this.proto = proto;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean process(long socket) {
            Http11AprProcessor processor = null;
            try {
                processor = (Http11AprProcessor)this.localProcessor.get();
                if (processor == null) {
                    processor = new Http11AprProcessor(this.proto.maxHttpHeaderSize, this.proto.ep);
                    processor.setAdapter(this.proto.adapter);
                    processor.setMaxKeepAliveRequests(this.proto.maxKeepAliveRequests);
                    processor.setTimeout(this.proto.timeout);
                    processor.setDisableUploadTimeout(this.proto.disableUploadTimeout);
                    processor.setCompression(this.proto.compression);
                    processor.setCompressionMinSize(this.proto.compressionMinSize);
                    processor.setNoCompressionUserAgents(this.proto.noCompressionUserAgents);
                    processor.setCompressableMimeTypes(this.proto.compressableMimeTypes);
                    processor.setRestrictedUserAgents(this.proto.restrictedUserAgents);
                    processor.setSocketBuffer(this.proto.socketBuffer);
                    processor.setMaxSavePostSize(this.proto.maxSavePostSize);
                    processor.setServer(this.proto.server);
                    this.localProcessor.set(processor);
                    if (this.proto.getDomain() != null) {
                        Http11ConnectionHandler http11ConnectionHandler = this;
                        synchronized (http11ConnectionHandler) {
                            try {
                                RequestInfo rp = processor.getRequest().getRequestProcessor();
                                rp.setGlobalProcessor(this.global);
                                ObjectName rpName = new ObjectName(this.proto.getDomain() + ":type=RequestProcessor,worker=" + this.proto.getName() + ",name=HttpRequest" + count++);
                                Registry.getRegistry(null, null).registerComponent((Object)rp, rpName, null);
                            }
                            catch (Exception e) {
                                log.warn((Object)"Error registering request");
                            }
                        }
                    }
                }
                if (processor instanceof ActionHook) {
                    processor.action(ActionCode.ACTION_START, null);
                }
                boolean bl = processor.process(socket);
                return bl;
            }
            catch (SocketException e) {
                log.debug((Object)sm.getString("http11protocol.proto.socketexception.debug"), (Throwable)e);
            }
            catch (IOException e) {
                log.debug((Object)sm.getString("http11protocol.proto.ioexception.debug"), (Throwable)e);
            }
            catch (Throwable e) {
                log.error((Object)sm.getString("http11protocol.proto.error"), e);
            }
            finally {
                if (processor instanceof ActionHook) {
                    processor.action(ActionCode.ACTION_STOP, null);
                }
            }
            return false;
        }
    }
}

