/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ActionHook;
import org.apache.coyote.Adapter;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.RequestGroupInfo;
import org.apache.coyote.http11.Http11Processor;
import org.apache.tomcat.util.net.PoolTcpEndpoint;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.ServerSocketFactory;
import org.apache.tomcat.util.net.TcpConnection;
import org.apache.tomcat.util.net.TcpConnectionHandler;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.threads.ThreadPool;

public class Http11BaseProtocol
implements ProtocolHandler {
    protected static StringManager sm = StringManager.getManager((String)"org.apache.coyote.http11");
    protected ThreadPool tp = ThreadPool.createThreadPool((boolean)true);
    protected PoolTcpEndpoint ep = new PoolTcpEndpoint(this.tp);
    protected boolean secure;
    protected ServerSocketFactory socketFactory;
    protected SSLImplementation sslImplementation;
    protected Hashtable attributes = new Hashtable();
    protected String socketFactoryName = null;
    protected String sslImplementationName = null;
    private int maxKeepAliveRequests = 100;
    private int timeout = 300000;
    private int maxSavePostSize = 4096;
    private int maxHttpHeaderSize = 4096;
    private String reportedname;
    private int socketCloseDelay = -1;
    private boolean disableUploadTimeout = true;
    private int socketBuffer = 9000;
    private Adapter adapter;
    protected Http11ConnectionHandler cHandler;
    private String compression = "off";
    private String noCompressionUserAgents = null;
    private String restrictedUserAgents = null;
    private String compressableMimeTypes = "text/html,text/xml,text/plain";
    private int compressionMinSize = 2048;
    private String server;
    public static final int THREAD_DATA_PROCESSOR = 1;
    public static final int THREAD_DATA_OBJECT_NAME = 2;
    protected static Log log = LogFactory.getLog(Http11BaseProtocol.class);

    public Http11BaseProtocol() {
        this.setSoLinger(-1);
        this.setSoTimeout(60000);
        this.setServerSoTimeout(0);
        this.setTcpNoDelay(true);
    }

    public void setAttribute(String name, Object value) {
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("http11protocol.setattribute", (Object)name, value));
        }
        this.attributes.put(name, value);
    }

    public Object getAttribute(String key) {
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("http11protocol.getattribute", (Object)key));
        }
        return this.attributes.get(key);
    }

    public Iterator getAttributeNames() {
        return this.attributes.keySet().iterator();
    }

    public void setProperty(String name, String value) {
        this.setAttribute(name, value);
    }

    public String getProperty(String name) {
        return (String)this.getAttribute(name);
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    protected Http11ConnectionHandler createConnectionHandler() {
        return new Http11ConnectionHandler(this);
    }

    public void init() throws Exception {
        this.cHandler = this.createConnectionHandler();
        this.ep.setConnectionHandler((TcpConnectionHandler)this.cHandler);
        try {
            this.checkSocketFactory();
        }
        catch (Exception ex) {
            log.error((Object)sm.getString("http11protocol.socketfactory.initerror"), (Throwable)ex);
            throw ex;
        }
        if (this.socketFactory != null) {
            Enumeration attE = this.attributes.keys();
            while (attE.hasMoreElements()) {
                String key = (String)attE.nextElement();
                Object v = this.attributes.get(key);
                this.socketFactory.setAttribute(key, v);
            }
        }
        try {
            this.ep.initEndpoint();
        }
        catch (Exception ex) {
            log.error((Object)sm.getString("http11protocol.endpoint.initerror"), (Throwable)ex);
            throw ex;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("http11protocol.init", (Object)this.getName()));
        }
    }

    public void start() throws Exception {
        try {
            this.ep.startEndpoint();
        }
        catch (Exception ex) {
            log.error((Object)sm.getString("http11protocol.endpoint.starterror"), (Throwable)ex);
            throw ex;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("http11protocol.start", (Object)this.getName()));
        }
    }

    public void pause() throws Exception {
        try {
            this.ep.pauseEndpoint();
        }
        catch (Exception ex) {
            log.error((Object)sm.getString("http11protocol.endpoint.pauseerror"), (Throwable)ex);
            throw ex;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("http11protocol.pause", (Object)this.getName()));
        }
    }

    public void resume() throws Exception {
        try {
            this.ep.resumeEndpoint();
        }
        catch (Exception ex) {
            log.error((Object)sm.getString("http11protocol.endpoint.resumeerror"), (Throwable)ex);
            throw ex;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("http11protocol.resume", (Object)this.getName()));
        }
    }

    public void destroy() throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("http11protocol.stop", (Object)this.getName()));
        }
        this.ep.stopEndpoint();
    }

    public int getMaxThreads() {
        return this.ep.getMaxThreads();
    }

    public void setMaxThreads(int maxThreads) {
        this.ep.setMaxThreads(maxThreads);
        this.setAttribute("maxThreads", "" + maxThreads);
    }

    public int getMaxSpareThreads() {
        return this.ep.getMaxSpareThreads();
    }

    public void setMaxSpareThreads(int maxThreads) {
        this.ep.setMaxSpareThreads(maxThreads);
        this.setAttribute("maxSpareThreads", "" + maxThreads);
    }

    public int getMinSpareThreads() {
        return this.ep.getMinSpareThreads();
    }

    public void setMinSpareThreads(int minSpareThreads) {
        this.ep.setMinSpareThreads(minSpareThreads);
        this.setAttribute("minSpareThreads", "" + minSpareThreads);
    }

    public void setThreadPriority(int threadPriority) {
        this.ep.setThreadPriority(threadPriority);
        this.setAttribute("threadPriority", "" + threadPriority);
    }

    public int getThreadPriority() {
        return this.ep.getThreadPriority();
    }

    public void setStrategy(String strategy) {
        this.ep.setStrategy(strategy);
        this.setAttribute("strategy", strategy);
    }

    public String getStrategy() {
        return this.ep.getStrategy();
    }

    public int getBacklog() {
        return this.ep.getBacklog();
    }

    public void setBacklog(int i) {
        this.ep.setBacklog(i);
        this.setAttribute("backlog", "" + i);
    }

    public int getPort() {
        return this.ep.getPort();
    }

    public void setPort(int port) {
        this.ep.setPort(port);
        this.setAttribute("port", "" + port);
    }

    public InetAddress getAddress() {
        return this.ep.getAddress();
    }

    public void setAddress(InetAddress ia) {
        this.ep.setAddress(ia);
        this.setAttribute("address", "" + ia);
    }

    public String getName() {
        String encodedAddr = "";
        if (this.getAddress() != null) {
            encodedAddr = "" + this.getAddress();
            if (encodedAddr.startsWith("/")) {
                encodedAddr = encodedAddr.substring(1);
            }
            encodedAddr = URLEncoder.encode(encodedAddr) + "-";
        }
        return "http-" + encodedAddr + this.ep.getPort();
    }

    public String getSocketFactory() {
        return this.socketFactoryName;
    }

    public void setSocketFactory(String valueS) {
        this.socketFactoryName = valueS;
        this.setAttribute("socketFactory", valueS);
    }

    public String getSSLImplementation() {
        return this.sslImplementationName;
    }

    public void setSSLImplementation(String valueS) {
        this.sslImplementationName = valueS;
        this.setSecure(true);
        this.setAttribute("sslImplementation", valueS);
    }

    public boolean getTcpNoDelay() {
        return this.ep.getTcpNoDelay();
    }

    public void setTcpNoDelay(boolean b) {
        this.ep.setTcpNoDelay(b);
        this.setAttribute("tcpNoDelay", "" + b);
    }

    public boolean getDisableUploadTimeout() {
        return this.disableUploadTimeout;
    }

    public void setDisableUploadTimeout(boolean isDisabled) {
        this.disableUploadTimeout = isDisabled;
    }

    public int getSocketBuffer() {
        return this.socketBuffer;
    }

    public void setSocketBuffer(int valueI) {
        this.socketBuffer = valueI;
    }

    public String getCompression() {
        return this.compression;
    }

    public void setCompression(String valueS) {
        this.compression = valueS;
        this.setAttribute("compression", valueS);
    }

    public int getMaxSavePostSize() {
        return this.maxSavePostSize;
    }

    public void setMaxSavePostSize(int valueI) {
        this.maxSavePostSize = valueI;
        this.setAttribute("maxSavePostSize", "" + valueI);
    }

    public int getMaxHttpHeaderSize() {
        return this.maxHttpHeaderSize;
    }

    public void setMaxHttpHeaderSize(int valueI) {
        this.maxHttpHeaderSize = valueI;
        this.setAttribute("maxHttpHeaderSize", "" + valueI);
    }

    public String getRestrictedUserAgents() {
        return this.restrictedUserAgents;
    }

    public void setRestrictedUserAgents(String valueS) {
        this.restrictedUserAgents = valueS;
        this.setAttribute("restrictedUserAgents", valueS);
    }

    public String getNoCompressionUserAgents() {
        return this.noCompressionUserAgents;
    }

    public void setNoCompressionUserAgents(String valueS) {
        this.noCompressionUserAgents = valueS;
        this.setAttribute("noCompressionUserAgents", valueS);
    }

    public String getCompressableMimeType() {
        return this.compressableMimeTypes;
    }

    public void setCompressableMimeType(String valueS) {
        this.compressableMimeTypes = valueS;
        this.setAttribute("compressableMimeTypes", valueS);
    }

    public int getCompressionMinSize() {
        return this.compressionMinSize;
    }

    public void setCompressionMinSize(int valueI) {
        this.compressionMinSize = valueI;
        this.setAttribute("compressionMinSize", "" + valueI);
    }

    public int getSoLinger() {
        return this.ep.getSoLinger();
    }

    public void setSoLinger(int i) {
        this.ep.setSoLinger(i);
        this.setAttribute("soLinger", "" + i);
    }

    public int getSoTimeout() {
        return this.ep.getSoTimeout();
    }

    public void setSoTimeout(int i) {
        this.ep.setSoTimeout(i);
        this.setAttribute("soTimeout", "" + i);
    }

    public int getServerSoTimeout() {
        return this.ep.getServerSoTimeout();
    }

    public void setServerSoTimeout(int i) {
        this.ep.setServerSoTimeout(i);
        this.setAttribute("serverSoTimeout", "" + i);
    }

    public String getKeystore() {
        return this.getProperty("keystore");
    }

    public void setKeystore(String k) {
        this.setAttribute("keystore", k);
    }

    public String getKeypass() {
        return this.getProperty("keypass");
    }

    public void setKeypass(String k) {
        this.attributes.put("keypass", k);
    }

    public String getKeytype() {
        return this.getProperty("keystoreType");
    }

    public void setKeytype(String k) {
        this.setAttribute("keystoreType", k);
    }

    public String getClientauth() {
        return this.getProperty("clientauth");
    }

    public void setClientauth(String k) {
        this.setAttribute("clientauth", k);
    }

    public String getProtocol() {
        return this.getProperty("protocol");
    }

    public void setProtocol(String k) {
        this.setSecure(true);
        this.setAttribute("protocol", k);
    }

    public String getProtocols() {
        return this.getProperty("protocols");
    }

    public void setProtocols(String k) {
        this.setAttribute("protocols", k);
    }

    public String getAlgorithm() {
        return this.getProperty("algorithm");
    }

    public void setAlgorithm(String k) {
        this.setAttribute("algorithm", k);
    }

    public boolean getSecure() {
        return this.secure;
    }

    public void setSecure(boolean b) {
        this.secure = b;
        this.setAttribute("secure", "" + b);
    }

    public String getCiphers() {
        return this.getProperty("ciphers");
    }

    public void setCiphers(String ciphers) {
        this.setAttribute("ciphers", ciphers);
    }

    public String getKeyAlias() {
        return this.getProperty("keyAlias");
    }

    public void setKeyAlias(String keyAlias) {
        this.setAttribute("keyAlias", keyAlias);
    }

    public int getMaxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public void setMaxKeepAliveRequests(int mkar) {
        this.maxKeepAliveRequests = mkar;
        this.setAttribute("maxKeepAliveRequests", "" + mkar);
    }

    public boolean getKeepAlive() {
        return this.maxKeepAliveRequests != 0 && this.maxKeepAliveRequests != 1;
    }

    public void setKeepAlive(boolean keepAlive) {
        if (!keepAlive) {
            this.setMaxKeepAliveRequests(1);
        }
    }

    public int getSocketCloseDelay() {
        return this.socketCloseDelay;
    }

    public void setSocketCloseDelay(int d) {
        this.socketCloseDelay = d;
        this.setAttribute("socketCloseDelay", "" + d);
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getServer() {
        return this.server;
    }

    private static ServerSocketFactory string2SocketFactory(String val) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> chC = Class.forName(val);
        return (ServerSocketFactory)chC.newInstance();
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeouts) {
        this.timeout = timeouts;
        this.setAttribute("timeout", "" + timeouts);
    }

    public String getReportedname() {
        return this.reportedname;
    }

    public void setReportedname(String reportedName) {
        this.reportedname = reportedName;
    }

    private void checkSocketFactory() throws Exception {
        if (this.secure) {
            this.sslImplementation = SSLImplementation.getInstance((String)this.sslImplementationName);
            this.socketFactory = this.sslImplementation.getServerSocketFactory();
            this.ep.setServerSocketFactory(this.socketFactory);
        }
        if (this.socketFactoryName != null) {
            this.socketFactory = Http11BaseProtocol.string2SocketFactory(this.socketFactoryName);
            this.ep.setServerSocketFactory(this.socketFactory);
        }
    }

    static class Http11ConnectionHandler
    implements TcpConnectionHandler {
        Http11BaseProtocol proto;
        static int count = 0;
        RequestGroupInfo global = new RequestGroupInfo();

        Http11ConnectionHandler(Http11BaseProtocol proto) {
            this.proto = proto;
        }

        public void setAttribute(String name, Object value) {
        }

        public void setServer(Object o) {
        }

        public Object[] init() {
            Object[] thData = new Object[3];
            Http11Processor processor = new Http11Processor(this.proto.maxHttpHeaderSize);
            processor.setAdapter(this.proto.adapter);
            processor.setThreadPool(this.proto.tp);
            processor.setEndpoint(this.proto.ep);
            processor.setMaxKeepAliveRequests(this.proto.maxKeepAliveRequests);
            processor.setTimeout(this.proto.timeout);
            processor.setDisableUploadTimeout(this.proto.disableUploadTimeout);
            processor.setCompression(this.proto.compression);
            processor.setCompressionMinSize(this.proto.compressionMinSize);
            processor.setNoCompressionUserAgents(this.proto.noCompressionUserAgents);
            processor.setCompressableMimeTypes(this.proto.compressableMimeTypes);
            processor.setRestrictedUserAgents(this.proto.restrictedUserAgents);
            processor.setSocketBuffer(this.proto.socketBuffer);
            processor.setMaxSavePostSize(this.proto.maxSavePostSize);
            processor.setServer(this.proto.server);
            thData[1] = processor;
            return thData;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processConnection(TcpConnection connection, Object[] thData) {
            Socket socket = null;
            Http11Processor processor = null;
            try {
                processor = (Http11Processor)thData[1];
                if (processor instanceof ActionHook) {
                    processor.action(ActionCode.ACTION_START, null);
                }
                socket = connection.getSocket();
                InputStream in = socket.getInputStream();
                OutputStream out = socket.getOutputStream();
                if (this.proto.secure) {
                    SSLSupport sslSupport = null;
                    if (this.proto.sslImplementation != null) {
                        sslSupport = this.proto.sslImplementation.getSSLSupport(socket);
                    }
                    processor.setSSLSupport(sslSupport);
                } else {
                    processor.setSSLSupport(null);
                }
                processor.setSocket(socket);
                processor.process(in, out);
                if (this.proto.socketCloseDelay >= 0) {
                    try {
                        Thread.sleep(this.proto.socketCloseDelay);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
                TcpConnection.shutdownInput((Socket)socket);
            }
            catch (SocketException e) {
                log.debug((Object)sm.getString("http11protocol.proto.socketexception.debug"), (Throwable)e);
            }
            catch (IOException e) {
                log.debug((Object)sm.getString("http11protocol.proto.ioexception.debug"), (Throwable)e);
            }
            catch (Throwable e) {
                log.error((Object)sm.getString("http11protocol.proto.error"), e);
            }
            finally {
                if (processor instanceof ActionHook) {
                    processor.action(ActionCode.ACTION_STOP, null);
                }
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException e) {}
            }
        }
    }
}

