/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.ajp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Iterator;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.modeler.Registry;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ActionHook;
import org.apache.coyote.Adapter;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.RequestGroupInfo;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.ajp.AjpAprProcessor;
import org.apache.tomcat.util.net.AprEndpoint;
import org.apache.tomcat.util.res.StringManager;

public class AjpAprProtocol
implements ProtocolHandler,
MBeanRegistration {
    protected static Log log = LogFactory.getLog(AjpAprProtocol.class);
    protected static StringManager sm = StringManager.getManager((String)"org.apache.coyote.ajp");
    protected ObjectName tpOname;
    protected ObjectName rgOname;
    protected AprEndpoint ep = new AprEndpoint();
    protected Hashtable attributes = new Hashtable();
    protected boolean tomcatAuthentication = true;
    protected String requiredSecret = null;
    private Adapter adapter;
    private AjpConnectionHandler cHandler = new AjpConnectionHandler(this);
    protected String domain;
    protected ObjectName oname;
    protected MBeanServer mserver;

    public AjpAprProtocol() {
        this.setSoLinger(-1);
        this.setSoTimeout(-1);
        this.setTcpNoDelay(true);
    }

    public void setAttribute(String name, Object value) {
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("ajpprotocol.setattribute", (Object)name, value));
        }
        this.attributes.put(name, value);
    }

    public Object getAttribute(String key) {
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("ajpprotocol.getattribute", (Object)key));
        }
        return this.attributes.get(key);
    }

    public Iterator getAttributeNames() {
        return this.attributes.keySet().iterator();
    }

    public void setProperty(String name, String value) {
        this.setAttribute(name, value);
    }

    public String getProperty(String name) {
        return (String)this.getAttribute(name);
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    public void init() throws Exception {
        this.ep.setName(this.getName());
        this.ep.setHandler((AprEndpoint.Handler)this.cHandler);
        this.ep.setUseSendfile(false);
        try {
            this.ep.init();
        }
        catch (Exception ex) {
            log.error((Object)sm.getString("ajpprotocol.endpoint.initerror"), (Throwable)ex);
            throw ex;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("ajpprotocol.init", (Object)this.getName()));
        }
    }

    public void start() throws Exception {
        if (this.domain != null) {
            try {
                this.tpOname = new ObjectName(this.domain + ":" + "type=ThreadPool,name=" + this.getName());
                Registry.getRegistry(null, null).registerComponent((Object)this.ep, this.tpOname, null);
            }
            catch (Exception e) {
                log.error((Object)"Can't register threadpool");
            }
            this.rgOname = new ObjectName(this.domain + ":type=GlobalRequestProcessor,name=" + this.getName());
            Registry.getRegistry(null, null).registerComponent((Object)this.cHandler.global, this.rgOname, null);
        }
        try {
            this.ep.start();
        }
        catch (Exception ex) {
            log.error((Object)sm.getString("ajpprotocol.endpoint.starterror"), (Throwable)ex);
            throw ex;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("ajpprotocol.start", (Object)this.getName()));
        }
    }

    public void pause() throws Exception {
        try {
            this.ep.pause();
        }
        catch (Exception ex) {
            log.error((Object)sm.getString("ajpprotocol.endpoint.pauseerror"), (Throwable)ex);
            throw ex;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("ajpprotocol.pause", (Object)this.getName()));
        }
    }

    public void resume() throws Exception {
        try {
            this.ep.resume();
        }
        catch (Exception ex) {
            log.error((Object)sm.getString("ajpprotocol.endpoint.resumeerror"), (Throwable)ex);
            throw ex;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("ajpprotocol.resume", (Object)this.getName()));
        }
    }

    public void destroy() throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("ajpprotocol.stop", (Object)this.getName()));
        }
        this.ep.destroy();
        if (this.tpOname != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.tpOname);
        }
        if (this.rgOname != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.rgOname);
        }
    }

    public int getMaxThreads() {
        return this.ep.getMaxThreads();
    }

    public void setMaxThreads(int maxThreads) {
        this.ep.setMaxThreads(maxThreads);
        this.setAttribute("maxThreads", "" + maxThreads);
    }

    public void setThreadPriority(int threadPriority) {
        this.ep.setThreadPriority(threadPriority);
        this.setAttribute("threadPriority", "" + threadPriority);
    }

    public int getThreadPriority() {
        return this.ep.getThreadPriority();
    }

    public int getBacklog() {
        return this.ep.getBacklog();
    }

    public void setBacklog(int i) {
        this.ep.setBacklog(i);
        this.setAttribute("backlog", "" + i);
    }

    public int getPort() {
        return this.ep.getPort();
    }

    public void setPort(int port) {
        this.ep.setPort(port);
        this.setAttribute("port", "" + port);
    }

    public boolean getUseSendfile() {
        return this.ep.getUseSendfile();
    }

    public void setUseSendfile(boolean useSendfile) {
    }

    public InetAddress getAddress() {
        return this.ep.getAddress();
    }

    public void setAddress(InetAddress ia) {
        this.ep.setAddress(ia);
        this.setAttribute("address", "" + ia);
    }

    public String getName() {
        String encodedAddr = "";
        if (this.getAddress() != null) {
            encodedAddr = "" + this.getAddress();
            if (encodedAddr.startsWith("/")) {
                encodedAddr = encodedAddr.substring(1);
            }
            encodedAddr = URLEncoder.encode(encodedAddr) + "-";
        }
        return "ajp-" + encodedAddr + this.ep.getPort();
    }

    public boolean getTcpNoDelay() {
        return this.ep.getTcpNoDelay();
    }

    public void setTcpNoDelay(boolean b) {
        this.ep.setTcpNoDelay(b);
        this.setAttribute("tcpNoDelay", "" + b);
    }

    public boolean getTomcatAuthentication() {
        return this.tomcatAuthentication;
    }

    public void setTomcatAuthentication(boolean tomcatAuthentication) {
        this.tomcatAuthentication = tomcatAuthentication;
    }

    public int getFirstReadTimeout() {
        return this.ep.getFirstReadTimeout();
    }

    public void setFirstReadTimeout(int i) {
        this.ep.setFirstReadTimeout(i);
        this.setAttribute("firstReadTimeout", "" + i);
    }

    public int getPollTime() {
        return this.ep.getPollTime();
    }

    public void setPollTime(int i) {
        this.ep.setPollTime(i);
        this.setAttribute("pollTime", "" + i);
    }

    public void setPollerSize(int i) {
        this.ep.setPollerSize(i);
        this.setAttribute("pollerSize", "" + i);
    }

    public int getPollerSize() {
        return this.ep.getPollerSize();
    }

    public int getSoLinger() {
        return this.ep.getSoLinger();
    }

    public void setSoLinger(int i) {
        this.ep.setSoLinger(i);
        this.setAttribute("soLinger", "" + i);
    }

    public int getSoTimeout() {
        return this.ep.getSoTimeout();
    }

    public void setSoTimeout(int i) {
        this.ep.setSoTimeout(i);
        this.setAttribute("soTimeout", "" + i);
    }

    public void setRequiredSecret(String requiredSecret) {
        this.requiredSecret = requiredSecret;
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    protected static class AjpConnectionHandler
    implements AprEndpoint.Handler {
        protected AjpAprProtocol proto;
        protected static int count = 0;
        protected RequestGroupInfo global = new RequestGroupInfo();
        protected ThreadLocal localProcessor = new ThreadLocal();

        public AjpConnectionHandler(AjpAprProtocol proto) {
            this.proto = proto;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean process(long socket) {
            AjpAprProcessor processor = null;
            try {
                processor = (AjpAprProcessor)this.localProcessor.get();
                if (processor == null) {
                    processor = new AjpAprProcessor(this.proto.ep);
                    processor.setAdapter(this.proto.adapter);
                    processor.setTomcatAuthentication(this.proto.tomcatAuthentication);
                    processor.setRequiredSecret(this.proto.requiredSecret);
                    this.localProcessor.set(processor);
                    if (this.proto.getDomain() != null) {
                        AjpConnectionHandler ajpConnectionHandler = this;
                        synchronized (ajpConnectionHandler) {
                            try {
                                RequestInfo rp = processor.getRequest().getRequestProcessor();
                                rp.setGlobalProcessor(this.global);
                                ObjectName rpName = new ObjectName(this.proto.getDomain() + ":type=RequestProcessor,worker=" + this.proto.getName() + ",name=AjpRequest" + count++);
                                Registry.getRegistry(null, null).registerComponent((Object)rp, rpName, null);
                            }
                            catch (Exception ex) {
                                log.warn((Object)sm.getString("ajpprotocol.request.register"));
                            }
                        }
                    }
                }
                if (processor instanceof ActionHook) {
                    processor.action(ActionCode.ACTION_START, null);
                }
                boolean bl = processor.process(socket);
                return bl;
            }
            catch (SocketException e) {
                log.debug((Object)sm.getString("ajpprotocol.proto.socketexception.debug"), (Throwable)e);
            }
            catch (IOException e) {
                log.debug((Object)sm.getString("ajpprotocol.proto.ioexception.debug"), (Throwable)e);
            }
            catch (Throwable e) {
                log.error((Object)sm.getString("ajpprotocol.proto.error"), e);
            }
            finally {
                if (processor instanceof ActionHook) {
                    processor.action(ActionCode.ACTION_STOP, null);
                }
            }
            return false;
        }
    }
}

