package cornflower.v10.test;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

import org.lixm.core.common.LIXMPhaseException;
import org.lixm.core.common.XMLModelizer;
import org.lixm.core.list.XMLCursor;
import org.lixm.core.list.XMLModelList;
import org.lixm.optional.v10.atattch.impl.jsr172.XMLModelizerImpl;

import cornflower.v10.test.canvas.Test1Canvas;

public class Main extends MIDlet implements CommandListener {

	XMLModelizer tok;
	XMLModelList list;
	XMLCursor cur;

	Test1Canvas canv;
	Command[] cmds;

	final String[] names = { "svg01.svg", "xhtml02.html", "Amaya.svg" };

	String filePath;
	long renderInterval;

	public Main() {
		super( );
		appPropDissolve( );
		init( );
	}

	private void appPropDissolve() {
		int no = Integer.parseInt(getAppProperty("lixm-test-xml-path"));
		if ( names.length > no ) {
			filePath = "/res/xml/" + names[no];
		} else {
			filePath = "/res/xml/" + names[0];
		}

		renderInterval = (
			getAppProperty("lixm-test-render-interval") == null ) ?
				200	: Long.parseLong(getAppProperty("lixm-test-render-interval"));
	}

	public void init() {

		initXMLList( );
		initCanvas( );
		initCommand( );

		//		testXML( );
		Display.getDisplay(this).setCurrent(canv);
	}

	//	private void testXML() {
	//	//        System.out.println();
	//
	//	}

	public void initCommand() {
		cmds = new Command[5];

		cmds[0] = new Command("restart", Command.SCREEN, 3);
		// cmds[1] = new Command("exit",Command.EXIT,2);
		cmds[2] = new Command("p/r", Command.STOP, 1);

		canv.addCommand(cmds[0]);
		// canv.addCommand(cmds[1]);
		canv.addCommand(cmds[2]);

		canv.setCommandListener(this);
	}

	public void initCanvas() {

		canv = new Test1Canvas(this, tok, false);
		canv.setInterval(renderInterval);
	}

	private void initXMLList() {

		try {
			tok =  new XMLModelizerImpl(new XMLModelList( ), true);
			tok.modelize(filePath);
		} catch ( LIXMPhaseException e ) {
			err(e);
		} catch ( Exception e ) {
			err(e);
		}
		list = tok.getList( );
	}

	private void err(
		Exception e)
	{

		//AlertDissolver.showError(e.getMessage( ), this, canv);
		System.err.println(e.getMessage( ));
		System.err
			.println("--------------------------------------------------------------------------------");
		e.printStackTrace( );
		shutdown(false);
	}

	public void shutdown(boolean unconditional) {
		try {
			destroyApp(unconditional);
		} catch ( MIDletStateChangeException e ) {
			// AlertDissolver.showError(e.getMessage(), this, canv);
			System.out.println(e.getMessage( ));
		}
		if(!unconditional){
			notifyDestroyed( );
		}
	}

	protected void destroyApp(
		boolean unconditional) throws MIDletStateChangeException
	{
	// 

	}

	protected void pauseApp() {
	//

	}

	protected void startApp() throws MIDletStateChangeException {
	//
	// init();
	}

	public void commandAction(
		Command c, Displayable d)
	{
		switch ( c.getCommandType( ) ) {
		case Command.EXIT :
			shutdown(false);
			break;

		case Command.STOP :
			canv.toggleSuspend( );
			break;

		case Command.SCREEN :
			if ( c == cmds[0] ) {
				canv.startTimeAttack( );
			}
		default :
			break;
		}
	}

}
