package org.lixm.core.model;

import org.lixm.core.common.XMLType;


/**
 * <p>要素をモデル化します。</p>
 * @author tasogare
 * @version 1.0M1
 */
public class ElementModel extends AbstractModel {

    private String name;
    private String pref;
    private String id;

    public ElementModel(
        String name, String pref, String id)
    {
        super(XMLType.ELEMENT);

        this.name = name;
        this.pref = pref;
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public String getPefix() {
        return pref;
    }

    public String getNamespace() {
        return id;
    }

    public String toLocalName() {
        return getName( );
    }

    public String toQname() {
        String QName;
        if (getPefix( ) != null) {
            QName = getPefix( ) + ":" + getName( );
        } else {
            QName = getName( );
        }
        return QName;
    }

    public String toString() {
        return toLocalName( );
    }

    public boolean equals(
        Object o)
    {
        if (!super.equals(o)) return false;
        return ( this.toString( ) == o.toString( ) );
    }
}
