package org.lixm.core.model;

import org.lixm.core.common.XMLType;

/**
 * <p>処理命令をモデル化します。</p>
 * @author tasogare
 * @version 1.0M1
 */
public class ProcessingInstructionModel extends AbstractModel {

    private String target;
    private String data;

    public ProcessingInstructionModel(
        String target, String data)
    {
        super(XMLType.PI);

        this.target = target;
        this.data = data;
    }

    public String getTarget() {
        return target;
    }

    public String getData() {
        return data;
    }

    /*
     * public void setData(char[] data){ this.data = data; } public void
     * setData(String data){ this.data = data.toCharArray(); }
     */

    public String toString() {
        return "<?" + getTarget( ) + " " + getData( ) + "?>";
    }

    public boolean equals(
        Object o)
    {
        if (!super.equals(o)) return false;
        return ( this.toString( ) == o.toString( ) );
    }

}
