package org.lixm.core.model;

import org.lixm.core.common.XMLType;
import org.lixm.core.list.AttributesList;



/**
 * <p>開始タグをモデル化します。</p>
 * @author tasogare
 * @version 1.0M1
 */
public class StartTagModel extends AbstractModel {

    private ElementModel   elem;
    private AttributesList attrs;

    public StartTagModel(
        ElementModel element, AttributesList attributes)
    {
        super(XMLType.START_TAG);
        elem = element;
        attrs = attributes;
    }

    public StartTagModel(
        ElementModel element)
    {
        super(XMLType.START_TAG);
        elem = element;
        attrs = null;
    }

    public String getName() {
        return getElement( ).getName( );
    }

    public ElementModel getElement() {
        return elem;
    }

    /*
     * public void setElement(ElementModel elem){ this.elem = elem; }
     */
    public AttributesList getAttributes() {
        return attrs;
    }

    /*
     * public void setAttributes(AttributesList attrs){ this.attrs = attrs; }
     */
    public String toStartTag() {
        return toString( );
    }

    public String toString() {
    	return ( "<" + getElement( ).toString( ) + 
        	((getAttributes( ) != null ) ?
        		getAttributes( ).toString( ) : "") + ">" );

    }

    public boolean equals(
        Object o)
    {
        if (!super.equals(o)) return false;
        return ( this.toString( ) == o.toString( ) );
    }
}
