package org.lixm.core.model;


/**
 * <p>{@link org.lixm.core.model.XMLModel XMLModel}
 * を実装した全てのXML構成要素を表す抽象クラスです。</p>
 * 
 * @author tasogare
 * 
 * @see org.lixm.core.common.XMLType
 * @see XMLModel
 *
 */
public abstract class AbstractModel  implements XMLModel {

    protected int TYPE;

    protected AbstractModel(
        int type)
    {
        TYPE = type;
    }

    /**
     * {@inheritDoc}
     */
    public int getXMLType() {
        return TYPE;
    }

    /**
     * <p>モデルの実装依存な文字列表現を返します。</p>
     */
    public String toString() {
        return String.valueOf(getXMLType( ));
    }

    /**
     * <p>このXMLモデルがどのXMLType定数と一致するか調べます</p>
     * 
     * @param type 比較する{@link org.lixm.core.common.XMLType XMLType}定数。
     * @return 比較結果
     * @see org.lixm.core.common.XMLType
     */
    public boolean matchTypes(
        int type)
    {
        return this.getXMLType( ) == type;
    }

    /**
     * <p>このオブジェクトと任意の
     * {@link AbstractModel}インスタンスが同一かどうか調べます。</p>
     * <p>このクラスの実装では{@link org.lixm.core.common.XMLType XMLType}
     * 定数が一致するかどうかで同一性を調べますが、
     * 通常この動作は各サブクラスによってオーバーライドされます。</p>
     * 
     * @return 比較対象の<code>AbstractModel</code>インスタンス
     * @see #getXMLType()
     */
    public boolean equals(
        Object o)
    {
    	if(!(o instanceof AbstractModel)) return false;
        return ( this.matchTypes(((AbstractModel) o ).getXMLType( )));
    }
}
