package org.lixm.core.model;

import org.lixm.core.common.XMLType;
import org.lixm.core.list.AttributesList;



/**
 * <p>開始タグをモデル化します。</p>
 * @author tasogare
 */
public class StartTagModel extends AbstractModel {

    private ElementModel   elem;
    private AttributesList attrs;

    public StartTagModel(
        ElementModel element, AttributesList attributes)
    {
        super(XMLType.START_TAG);
        elem = element;
        attrs = attributes;
    }

    public StartTagModel(
        ElementModel element)
    {
        super(XMLType.START_TAG);
        elem = element;
        attrs = null;
    }

    /**
     * <p>この開始タグの要素名へ簡単にアクセスするための簡易メソッドです。</p>
     * @return 必ず<code>getElement().getName()</code>の値が返されます。
     */
    public String getName() {
        return getElement( ).getName( );
    }

    /**
     * <p>この開始タグの要素を取得します。</p>
     * 
     * @return 要素モデル
     */
    public ElementModel getElement() {
        return elem;
    }

    /**
     * <p>この開始タグの要素を設定します。</p>
     * 
     * @param elem 新たな開始タグの要素
     */
    public void setElement(ElementModel elem) {
        this.elem = elem;
    }

    /**
     * <p>この開始タグの属性リストを取得します。</p>
     * 
     * @return 属性リストモデル。存在しない場合は<code>null</code>。
     */
    public AttributesList getAttributes() {
        return attrs;
    }

    /**
     * <p>この開始タグの属性リストを設定します。</p>
     * 
     * @param attrs 新たな属性リスト
     */
    public void setAttributes(AttributesList attrs){
    	this.attrs = attrs;
    }

    /**
     * <p>この開始タグのXMLとして有効な文字列表現を返します。</p>
     * 
     * @return XMLとして有効な文字列表現 
     */
    public String toStartTag() {
        return toString( );
    }

    /**
     * {@inheritDoc}
     */
    public String toString() {
    	return ( "<" + getElement( ).toString( ) + 
        	((getAttributes( ) != null ) ?
        		getAttributes( ).toString( ) : "") + ">" );

    }

    /**
     * <p>モデルの同一性を論理的に調べその結果を返します。</p>
     * @return 同一のモデルなら<code>true</code>、違うなら<code>false</code>。
     */
    public boolean equals(
        Object o)
    {
        if (!super.equals(o)) return false;
        return ( this.toString( ) == o.toString( ) );
    }
}
