/************************************************************
 *
 * COPYRIGHT (C) HITACHI,LTD. 2004
 * WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY
 *
 * Created by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
 *
 ************************************************************/

#include <linux/lkst.h>
#include "lkst_lsm.h"

MODULE_AUTHOR("Masami Hiramatsu <hiramatu@sdl.hitachi.co.jp>");
MODULE_DESCRIPTION("LKST LSM events hooking module");
MODULE_LICENSE("GPL");

struct security_operations *real_ops = NULL;

static int __init lkst_lsm_init(void)
{
	int ret, i;
	/* Initialization of hook header */
	for ( i =0 ; i < LKST_LSM_OPS_NUM;i++) {
		ret = lkst_hook_etype_register(lkst_lsm_infos[i]);
		if (ret < 0) goto error;
	}

	real_ops = security_ops;
	security_ops = &lkst_lsm_ops;
	return 0;
error:
	for (i--; i >= 0;i--)
		lkst_hook_etype_unregister(lkst_lsm_infos[i]);
	return ret;
}

static void __exit lkst_lsm_exit(void)
{
	int i;
	security_ops = real_ops;
	/* Cleanup of hook header for module */
	for ( i =0 ; i < LKST_LSM_OPS_NUM;i++)
		lkst_hook_etype_unregister(lkst_lsm_infos[i]);
}

module_init(lkst_lsm_init);
module_exit(lkst_lsm_exit);
