/*****************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2004 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: amenu.c,v 1.37 2004/07/26 10:02:44 bowkenken Exp $
*****************************************************************/

#include	"gmain.h"
/*#include	"misc.h"*/
/*#include	"turn.h"*/
/*#include	"dun.h"*/
/*#include	"town.h"*/
#include	"item.h"
/*#include	"spell.h"*/
/*#include	"chr.h"*/
/*#include	"party.h"*/
/*#include	"mnstr.h"*/
/*#include	"pet.h"*/
/*#include	"fight.h"*/
/*#include	"fx.h"*/
/*#include	"trap.h"*/
#include	"draw.h"
/*#include	"curs.h"*/
#include	"menu.h"
#include	"amenu.h"
/*#include	"request.h"*/
/*#include	"gfile.h"*/
/*#include	"msg.h"*/
/*#include	"ver.h"*/
#include	"gmain-prot.h"
#include	"misc-prot.h"
/*#include	"turn-prot.h"*/
#include	"dun-prot.h"
/*#include	"town-prot.h"*/
#include	"item-prot.h"
/*#include	"spell-prot.h"*/
#include	"chr-prot.h"
#include	"party-prot.h"
#include	"mnstr-prot.h"
/*#include	"pet-prot.h"*/
/*#include	"fight-prot.h"*/
/*#include	"fx-prot.h"*/
/*#include	"trap-prot.h"*/
#include	"draw-prot.h"
/*#include	"curs-prot.h"*/
#include	"menu-prot.h"
/*#include	"tmenu-prot.h"*/
#include	"amenu-prot.h"
/*#include	"request-prot.h"*/
/*#include	"gfile-prot.h"*/
/*#include	"msg-prot.h"*/

/**/

/* ưޡ */

static auto_mark_t	ls_auto_mark[LS_MBR_MAX_N][AUTO_MARK_MAX_N];
static char	msg_ttl_auto_mark[AUTO_MARK_MAX_N]
		[MSG_TTL_AUTO_MARK_MAX_LEN + 1];
static long	auto_mark_cur_n;
static mbr_t	*g_sel_mbr;

static auto_mark_t	dflt_auto_mark_fight = {
	AUTO_MARK_TRGT_MNSTR,
	AUTO_MARK_DIST_NEAR,
	AUTO_MARK_ACT_FIGHT,
	AUTO_MARK_COND_DISPERSE,
	FLG_AUTO_MARK_EDIT_CONT,
};

static auto_mark_t	dflt_auto_mark_fight_pri = {
	AUTO_MARK_TRGT_MNSTR,
	AUTO_MARK_DIST_NEAR,
	AUTO_MARK_ACT_FIGHT,
	AUTO_MARK_COND_DISPERSE,
	FLG_AUTO_MARK_EDIT_PRIORITY | FLG_AUTO_MARK_EDIT_CONT,
};

static auto_mark_t	dflt_auto_mark_throw = {
	AUTO_MARK_TRGT_MNSTR,
	AUTO_MARK_DIST_MEDIUM,
	AUTO_MARK_ACT_THROW,
	AUTO_MARK_COND_DISPERSE,
	FLG_NULL,
};

static auto_mark_t	dflt_auto_mark_throw_pri = {
	AUTO_MARK_TRGT_MNSTR,
	AUTO_MARK_DIST_MEDIUM,
	AUTO_MARK_ACT_THROW,
	AUTO_MARK_COND_DISPERSE,
	FLG_AUTO_MARK_EDIT_PRIORITY | FLG_AUTO_MARK_EDIT_CONT,
};

static auto_mark_t	dflt_auto_mark_fight_far = {
	AUTO_MARK_TRGT_MNSTR,
	AUTO_MARK_DIST_FAR,
	AUTO_MARK_ACT_FIGHT,
	AUTO_MARK_COND_DISPERSE,
	FLG_NULL,
};

static auto_mark_t	dflt_auto_mark_fight_far_pri = {
	AUTO_MARK_TRGT_MNSTR,
	AUTO_MARK_DIST_FAR,
	AUTO_MARK_ACT_FIGHT,
	AUTO_MARK_COND_DISPERSE,
	FLG_AUTO_MARK_EDIT_PRIORITY | FLG_AUTO_MARK_EDIT_CONT,
};

static auto_mark_t	dflt_auto_mark_fight_all = {
	AUTO_MARK_TRGT_MNSTR,
	AUTO_MARK_DIST_NEAR,
	AUTO_MARK_ACT_FIGHT,
	AUTO_MARK_COND_DISPERSE,
	FLG_NULL,
};

static auto_mark_t	dflt_auto_mark_fight_all_pri = {
	AUTO_MARK_TRGT_MNSTR,
	AUTO_MARK_DIST_NEAR,
	AUTO_MARK_ACT_FIGHT,
	AUTO_MARK_COND_DISPERSE,
	FLG_AUTO_MARK_EDIT_PRIORITY | FLG_AUTO_MARK_EDIT_CONT,
};

static auto_mark_t	dflt_auto_mark_item_all = {
	AUTO_MARK_TRGT_ITEM,
	AUTO_MARK_DIST_NEAR,
	AUTO_MARK_ACT_PICK_UP,
	AUTO_MARK_COND_DISPERSE,
	FLG_AUTO_MARK_EDIT_PRIORITY | FLG_AUTO_MARK_EDIT_CONT,
};

static auto_mark_t	dflt_auto_mark_item_own = {
	AUTO_MARK_TRGT_ITEM,
	AUTO_MARK_DIST_NEAR,
	AUTO_MARK_ACT_PICK_UP,
	AUTO_MARK_COND_OWN,
	FLG_AUTO_MARK_EDIT_PRIORITY | FLG_AUTO_MARK_EDIT_CONT,
};

static auto_mark_t	dflt_auto_mark_clear = {
	AUTO_MARK_TRGT_CLEAR,
	AUTO_MARK_DIST_NEAR,
	AUTO_MARK_ACT_FIGHT,
	AUTO_MARK_COND_DISPERSE,
	FLG_AUTO_MARK_EDIT_PRIORITY,
};

static auto_mark_appoint_item_t	auto_mark_appoint_item
		[LS_MBR_MAX_N][AUTO_MARK_MAX_N]
		[AUTO_MARK_APPOINT_ITEM_MAX_N];

static auto_mark_appoint_item_t	auto_mark_appoint_item_dflt
		[AUTO_MARK_APPOINT_ITEM_MAX_N] = {
	{ FACE_MJR_WEAPON, FACE_MNR_KNIFE, TRUE },
	{ FACE_MJR_WEAPON, FACE_MNR_SHORT_SWORD, TRUE },
	{ FACE_MJR_WEAPON, FACE_MNR_LONG_SWORD, TRUE },
	{ FACE_MJR_WEAPON, FACE_MNR_SABRE, TRUE },
	{ FACE_MJR_WEAPON, FACE_MNR_RAPIER, TRUE },
	{ FACE_MJR_WEAPON, FACE_MNR_HAND_AXE, TRUE },
	{ FACE_MJR_WEAPON, FACE_MNR_BATTLE_AXE, TRUE },
	{ FACE_MJR_WEAPON, FACE_MNR_SPEAR, TRUE },
	{ FACE_MJR_WEAPON, FACE_MNR_LANCE, TRUE },
	{ FACE_MJR_WEAPON, FACE_MNR_FLAIL, TRUE },
	{ FACE_MJR_WEAPON, FACE_MNR_MACE, TRUE },
	{ FACE_MJR_WEAPON, FACE_MNR_HAMMER, TRUE },
	{ FACE_MJR_WEAPON, FACE_MNR_GLAIVE, TRUE },
	{ FACE_MJR_WEAPON, FACE_MNR_KNUCKLE, TRUE },
	{ FACE_MJR_WEAPON, FACE_MNR_BOW, TRUE },
	{ FACE_MJR_WEAPON, FACE_MNR_ARW, TRUE },
	{ FACE_MJR_WEAPON, FACE_MNR_STONE, TRUE },
	{ FACE_MJR_WEAPON, FACE_MNR_DAGGER, TRUE },

	{ FACE_MJR_ARMOR, FACE_MNR_ARMOR_SHIELD, TRUE },
	{ FACE_MJR_ARMOR, FACE_MNR_ARMOR_HEAD, TRUE },
	{ FACE_MJR_ARMOR, FACE_MNR_ARMOR_BODY, TRUE },
	{ FACE_MJR_ARMOR, FACE_MNR_ARMOR_ARM, TRUE },
	{ FACE_MJR_ARMOR, FACE_MNR_ARMOR_FEET, TRUE },
	{ FACE_MJR_ARMOR, FACE_MNR_ARMOR_ABOUT_BODY, TRUE },

	{ FACE_MJR_POTION, FACE_MNR_NULL, TRUE },

	{ FACE_MJR_SCROLL, FACE_MNR_NULL, TRUE },

	{ FACE_MJR_STICK, FACE_MNR_WAND, TRUE },
	{ FACE_MJR_STICK, FACE_MNR_ROD, TRUE },
	{ FACE_MJR_STICK, FACE_MNR_STAFF, TRUE },

	{ FACE_MJR_ACCESSORY, FACE_MNR_RING, TRUE },
	{ FACE_MJR_ACCESSORY, FACE_MNR_AMULET, TRUE },
	{ FACE_MJR_ACCESSORY, FACE_MNR_NECKLACE, TRUE },

	{ FACE_MJR_FOOD, FACE_MNR_NULL, TRUE },

	{ FACE_MJR_CHEST, FACE_MNR_NULL, FALSE },

	{ FACE_MJR_COIN, FACE_MNR_NULL, TRUE },

	{ FACE_MJR_GEM, FACE_MNR_NULL, TRUE },

	{ FACE_MJR_MISC, FACE_MNR_INST, TRUE },
	{ FACE_MJR_MISC, FACE_MNR_ANTHOLOGY, TRUE },
	{ FACE_MJR_MISC, FACE_MNR_LIGHT, TRUE },
	{ FACE_MJR_MISC, FACE_MNR_SPIKE, TRUE },
	{ FACE_MJR_MISC, FACE_MNR_TOBACCO, TRUE },
	{ FACE_MJR_MISC, FACE_MNR_PIPE, TRUE },
	{ FACE_MJR_MISC, FACE_MNR_RARE_GOODS, TRUE },
	{ FACE_MJR_MISC, FACE_MNR_JUNK, FALSE },

	{ FACE_MJR_NULL, FACE_MNR_NULL, FALSE },
};

/**/

#include	"amenu-tab.h"

/**/

/*****************************************************************
* 
*****************************************************************/

void	init_auto_menu( void )
{
	long	i, j, k;

	auto_mark_cur_n = 0;

	for( i = 0; i < LS_MBR_MAX_N; i++ ){
		for( j = 0; j < AUTO_MARK_MAX_N; j++ ){
			for( k = 0; k < AUTO_MARK_APPOINT_ITEM_MAX_N; k++ ){
				auto_mark_appoint_item_t	*a;

				a = &(auto_mark_appoint_item_dflt[k]);
				auto_mark_appoint_item[i][j][k] = *a;
			}
		}
	}

	init_auto_mark_all_mbr();
}

/*****************************************************************
* ٤ƤΥСν
*****************************************************************/

void	init_auto_mark_all_mbr( void )
{
	long	i;

	for( i = 0; i < LS_MBR_MAX_N; i++ )
		init_auto_mark_mbr( i );
}

/*****************************************************************
* Сν
* long ls_mbr_n : СΥꥹֹ
*****************************************************************/

void	init_auto_mark_mbr( long ls_mbr_n )
{
	long	j;

	/*  */

	for( j = 0; j < AUTO_MARK_MAX_N; j++ ){
		ls_auto_mark[ls_mbr_n][j] = dflt_auto_mark_clear;
		strncpy( msg_ttl_auto_mark[j],
				MSG_NAME_DFLT_AUTO_MARK_CLEAR,
				MSG_TTL_AUTO_MARK_MAX_LEN );
	}

	/* Ʈ(ɲ) */

	j = 0;

	switch( ls_mbr_n ){
	default:
	case 0:
	case 1:
	case 3:
		ls_auto_mark[ls_mbr_n][j] = dflt_auto_mark_fight;
		break;
	case 2:
		ls_auto_mark[ls_mbr_n][j] = dflt_auto_mark_throw;
		break;
	case 4:
	case 5:
		ls_auto_mark[ls_mbr_n][j] = dflt_auto_mark_fight_far;
		break;
	}
	strncpy( msg_ttl_auto_mark[j],
			MSG_NAME_DFLT_AUTO_MARK_FIGHT,
			MSG_TTL_AUTO_MARK_MAX_LEN );
	j++;

	/* Ʈ() */

	switch( ls_mbr_n ){
	default:
	case 0:
	case 1:
	case 3:
		ls_auto_mark[ls_mbr_n][j] = dflt_auto_mark_fight_pri;
		break;
	case 2:
		ls_auto_mark[ls_mbr_n][j] = dflt_auto_mark_throw_pri;
		break;
	case 4:
	case 5:
		ls_auto_mark[ls_mbr_n][j] = dflt_auto_mark_fight_far_pri;
		break;
	}
	strncpy( msg_ttl_auto_mark[j],
			MSG_NAME_DFLT_AUTO_MARK_FIGHT_PRI,
			MSG_TTL_AUTO_MARK_MAX_LEN );
	j++;

	/* ܶƮ(ɲ) */

	if( j < AUTO_MARK_MAX_N ){
		ls_auto_mark[ls_mbr_n][j] = dflt_auto_mark_fight_all;
		strncpy( msg_ttl_auto_mark[j],
				MSG_NAME_DFLT_AUTO_MARK_FIGHT_ALL,
				MSG_TTL_AUTO_MARK_MAX_LEN );
	}
	j++;

	/* ܶƮ() */

	if( j < AUTO_MARK_MAX_N ){
		ls_auto_mark[ls_mbr_n][j] = dflt_auto_mark_fight_all_pri;
		strncpy( msg_ttl_auto_mark[j],
				MSG_NAME_DFLT_AUTO_MARK_FIGHT_ALL_PRI,
				MSG_TTL_AUTO_MARK_MAX_LEN );
	}
	j++;

	/* ƤΥƥ */

	j += 2;

	if( j < AUTO_MARK_MAX_N ){
		ls_auto_mark[ls_mbr_n][j] = dflt_auto_mark_item_all;
		strncpy( msg_ttl_auto_mark[j],
				MSG_NAME_DFLT_AUTO_MARK_ITEM_ALL,
				MSG_TTL_AUTO_MARK_MAX_LEN );
	}
	j++;

	/* äƤ륢ƥ */

	if( j < AUTO_MARK_MAX_N ){
		ls_auto_mark[ls_mbr_n][j] = dflt_auto_mark_item_own;
		strncpy( msg_ttl_auto_mark[j],
				MSG_NAME_DFLT_AUTO_MARK_ITEM_OWN,
				MSG_TTL_AUTO_MARK_MAX_LEN );
	}
	j++;

	j = AUTO_MARK_MAX_N - 1;
	ls_auto_mark[ls_mbr_n][j] = dflt_auto_mark_clear;
	strncpy( msg_ttl_auto_mark[j],
			MSG_NAME_DFLT_AUTO_MARK_CLEAR,
			MSG_TTL_AUTO_MARK_MAX_LEN );
}

/*****************************************************************
* ˥塼
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
*****************************************************************/

char	*menu_auto_mark( menu_t **pp, menu_t **dflt )
{
	*dflt = NULL;

	set_menu_auto_mark( dflt );

	*pp = ls_menu_auto_mark;

	return NULL;
}

/*****************************************************************
* ˥塼ΥꥹȤ
* menu_t **dflt : ˥塼Υǥե
*****************************************************************/

void	set_menu_auto_mark( menu_t **dflt )
{
	menu_t	*p;
	long	i, k;

	p = ls_menu_auto_mark;
	k = 0;

	strncpy( p[k].path, "/Auto mark", MENU_PATH_MAX_LEN );
	strncpy( p[k].kind, "<Branch>", MENU_KIND_MAX_LEN );
	p[k].key = '\0';
	p[k].accel_key[0] = '\0';
	p[k].msg[0] = '\0';
	p[k].call_back = NULL;
	p[k].arg = NULL;
	p[k].flg = FLG_NULL;
	k++;

	strncpy( p[k].path, "/Auto mark/Title", MENU_PATH_MAX_LEN );
	strncpy( p[k].kind, "<Title>", MENU_KIND_MAX_LEN );
	p[k].key = '\0';
	p[k].accel_key[0] = '\0';
	strncpy( p[k].msg, MSG_TTL_MENU_AUTO_MARK,
			MENU_MSG_MAX_LEN );
	p[k].call_back = NULL;
	p[k].arg = NULL;
	p[k].flg = FLG_NULL;
	k++;

	for( i = 0; i < AUTO_MARK_MAX_N; i++ ){
		long	kk;

		kk = k;

		if( i == auto_mark_cur_n )
			*dflt = &(p[k]);

		sprintf( p[k].path, "/Auto mark/%ld", i );
		strncpy( p[k].kind, "<Branch>", MENU_KIND_MAX_LEN );
		p[k].key = (char)('A' + i);
		p[k].accel_key[0] = '\0';
		strncpy( p[k].msg, get_msg_ttl_auto_mark( i ),
				MENU_MSG_MAX_LEN );
		p[k].call_back = NULL;
		p[k].arg = NULL;
		p[k].flg = FLG_NULL;
		k++;

		sprintf( p[k].path, "%s/Exec", p[kk].path );
		strncpy( p[k].kind, "<Item>", MENU_KIND_MAX_LEN );
		p[k].key = 'X';
		p[k].accel_key[0] = '\0';
		strncpy( p[k].msg, MSG_MENU_AUTO_MARK_EXEC,
				MENU_MSG_MAX_LEN );
		p[k].call_back = cb_menu_auto_mark_exec;
		p[k].arg = (void *)i;
		p[k].flg = FLG_NULL;
		k++;

		sprintf( p[k].path, "%s/Edit", p[kk].path );
		strncpy( p[k].kind, "<Branch>", MENU_KIND_MAX_LEN );
		p[k].key = 'E';
		p[k].accel_key[0] = '\0';
		strncpy( p[k].msg, MSG_MENU_AUTO_MARK_EDIT,
				MENU_MSG_MAX_LEN );
		p[k].call_back = cb_menu_auto_mark_edit;
		p[k].arg = (void *)i;
		p[k].flg = FLG_NULL;
		k++;

		sprintf( p[k].path, "%s/Arrange", p[kk].path );
		strncpy( p[k].kind, "<Item>", MENU_KIND_MAX_LEN );
		p[k].key = 'A';
		p[k].accel_key[0] = '\0';
		strncpy( p[k].msg, MSG_MENU_AUTO_MARK_ARRANGE,
				MENU_MSG_MAX_LEN );
		p[k].call_back = cb_menu_auto_mark_arrange;
		p[k].arg = (void *)i;
		p[k].flg = FLG_NULL;
		k++;
	}
	p[k].path[0] = '\0';
}

/*****************************************************************
* ˥塼Ǽ¹Ԥ򤵤줿˸ƤФ
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
*****************************************************************/

char	*cb_menu_auto_mark_exec( menu_t **pp, menu_t **dflt )
{
	party_t	*pty = get_party();
	long	n;
	long	i;

	n = (long)((*pp)->arg);
	if( auto_mark_cur_n != n ){
		auto_mark_cur_n = n;

		for( i = 0; i < MBR_MAX_N; i++ ){
			set_auto_mark_cont( pty->mbr[i] );
		}
	}

	for( i = 0; i < MBR_MAX_N; i++ )
		exec_menu_auto_mark( pty->mbr[i] );

	return NULL;
}

/*****************************************************************
* Ū˥ޡʤʤϢ³ޡ
* mbr_t *mbr : С
*****************************************************************/

void	set_auto_mark_cont( mbr_t *mbr )
{
	if( mbr == NULL )
		return;

	if( chk_flg( ls_auto_mark[mbr->ls_mbr_n][auto_mark_cur_n].flg,
			FLG_AUTO_MARK_EDIT_PRIORITY ) ){
		mbr->flg_chr &= ~(FLG_CHR_AUTO_MARK_CONT);
	}
}

/*****************************************************************
* ˥塼¹Ԥ
* mbr_t *mbr : С
* return : Ԥ
*****************************************************************/

bool_t	exec_menu_auto_mark( mbr_t *mbr )
{
	auto_mark_t	*am;
	bool_t	flg_clr;

	if( chk_flg_or( mbr->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return FALSE;

	am = &(ls_auto_mark[mbr->ls_mbr_n][auto_mark_cur_n]);

	/* Ǥ˥ޡƤ뤫 */
	if( !chk_flg( am->flg, FLG_AUTO_MARK_EDIT_PRIORITY ) )
		if( mbr->act.kind != ACT_KIND_NULL )
			return FALSE;

	flg_clr = FALSE;
	switch( am->trgt ){
	case AUTO_MARK_TRGT_MNSTR:
		if( !exec_menu_auto_mark_mnstr( mbr ) )
			flg_clr = TRUE;
		break;
	case AUTO_MARK_TRGT_ITEM:
		if( !exec_menu_auto_mark_item( mbr ) )
			flg_clr = TRUE;
		break;
	case AUTO_MARK_TRGT_DOOR:
		if( !exec_menu_auto_mark_door( mbr ) )
			flg_clr = TRUE;
		break;
	case AUTO_MARK_TRGT_TRAP:
		break;
	case AUTO_MARK_TRGT_MBR:
		if( !exec_menu_auto_mark_mbr( mbr ) )
			flg_clr = TRUE;
		break;
	case AUTO_MARK_TRGT_UNCHANGE:
		return TRUE;
	case AUTO_MARK_TRGT_CLEAR:
		flg_clr = TRUE;
		break;
	}

	if( flg_clr )
		clr_chr_trgt_act( mbr, TRUE );

	if( chk_flg( ls_auto_mark[mbr->ls_mbr_n][auto_mark_cur_n].flg,
			FLG_AUTO_MARK_EDIT_CONT ) ){
		mbr->flg_chr |= FLG_CHR_AUTO_MARK_CONT;
	} else {
		mbr->flg_chr &= ~(FLG_CHR_AUTO_MARK_CONT);
	}

	return TRUE;
}

/*****************************************************************
* 󥹥оݤ˥˥塼¹Ԥ
* mbr_t *mbr : С
* return : Ԥ
*****************************************************************/

bool_t	exec_menu_auto_mark_mnstr( mbr_t *mbr )
{
	auto_mark_t	*am;
	mnstr_t	*mnstr;
	dist_t	dist;
	act_kind_t	act_kind;

	am = &(ls_auto_mark[mbr->ls_mbr_n][auto_mark_cur_n]);

	switch( am->act ){
	case AUTO_MARK_ACT_FIGHT:
		act_kind = ACT_KIND_MNSTR_FIGHT;
		break;
	case AUTO_MARK_ACT_THROW:
		act_kind = ACT_KIND_MNSTR_THROW;
		break;
	case AUTO_MARK_ACT_STEAL:
		act_kind = ACT_KIND_MNSTR_STEAL;
		break;
	case AUTO_MARK_ACT_TAIL:
		act_kind = ACT_KIND_MNSTR_TAIL;
		break;
	case AUTO_MARK_ACT_PICK_UP:
	case AUTO_MARK_ACT_OPEN:
	case AUTO_MARK_ACT_CLOSE:
	case AUTO_MARK_ACT_JAM:
	case AUTO_MARK_ACT_DISARM:
	case AUTO_MARK_ACT_BREAK:
	case AUTO_MARK_ACT_PEEP:
	case AUTO_MARK_ACT_CHK:
	default:
		return FALSE;
	}

	/* 󥹥õ */
	mnstr = NULL;
	switch( am->cond ){
	case AUTO_MARK_COND_NEAREST:
		mnstr = get_mnstr_nearest( mbr->x, mbr->y );
		break;
	case AUTO_MARK_COND_DISPERSE:
		mnstr = get_mnstr_disperse( mbr );
		if( mnstr == NULL )
			mnstr = get_mnstr_randm( mbr->x, mbr->y );
		break;
	case AUTO_MARK_COND_STAGGER:
	case AUTO_MARK_COND_OWN:
		return FALSE;
	}
	if( mnstr == NULL )
		return FALSE;

	/* ֹ礤򥻥å */
	switch( am->dist ){
	case AUTO_MARK_DIST_NEAR:
		dist = DIST_NEAR;
		break;
	case AUTO_MARK_DIST_MEDIUM:
		dist = DIST_MEDIUM;
		break;
	case AUTO_MARK_DIST_FAR:
		dist = DIST_FAR;
		break;
	default:
		return FALSE;
	}

	/* 򥻥å */
	set_chr_act( mbr, act_kind, NULL, NULL, 0, 0 );

	/* 󥹥ޡ */
	mark_mnstr( mbr, mnstr, dist );

	draw_mbr_stat( mbr );

	return TRUE;
}

/*****************************************************************
* ƥоݤ˥˥塼¹Ԥ
* mbr_t *mbr : С
* return : Ԥ
*****************************************************************/

bool_t	exec_menu_auto_mark_item( mbr_t *mbr )
{
	auto_mark_t	*am;
	item_t	*item;
	dist_t	dist;
	act_kind_t	act_kind;

	am = &(ls_auto_mark[mbr->ls_mbr_n][auto_mark_cur_n]);

	switch( am->act ){
	case AUTO_MARK_ACT_FIGHT:
	case AUTO_MARK_ACT_THROW:
	case AUTO_MARK_ACT_STEAL:
	case AUTO_MARK_ACT_TAIL:
		return FALSE;
	case AUTO_MARK_ACT_PICK_UP:
		act_kind = ACT_KIND_ITEM_PICK_UP;
		break;
	case AUTO_MARK_ACT_OPEN:
		act_kind = ACT_KIND_ITEM_OPEN;
		break;
	case AUTO_MARK_ACT_CLOSE:
	case AUTO_MARK_ACT_JAM:
		return FALSE;
	case AUTO_MARK_ACT_DISARM:
		act_kind = ACT_KIND_ITEM_DISARM;
		break;
	case AUTO_MARK_ACT_BREAK:
		act_kind = ACT_KIND_ITEM_BREAK;
		break;
	case AUTO_MARK_ACT_PEEP:
		return FALSE;
	case AUTO_MARK_ACT_CHK:
		act_kind = ACT_KIND_ITEM_CHK;
		break;
	default:
		return FALSE;
	}

	/* ƥõ */
	item = NULL;
	switch( am->cond ){
	case AUTO_MARK_COND_NEAREST:
		item = get_item_nearest( mbr, act_kind, TRUE );
		break;
	case AUTO_MARK_COND_DISPERSE:
		item = get_item_disperse( mbr, act_kind, TRUE );
		if( item == NULL )
			item = get_item_randm( mbr, act_kind, TRUE );
		break;
	case AUTO_MARK_COND_STAGGER:
		return FALSE;
	case AUTO_MARK_COND_OWN:
		item = get_item_own( mbr, act_kind, TRUE );
		break;
	}
	if( item == NULL )
		return FALSE;

	/* ֹ礤򥻥å */
	switch( am->dist ){
	case AUTO_MARK_DIST_NEAR:
		dist = DIST_NEAR;
		break;
	case AUTO_MARK_DIST_MEDIUM:
		dist = DIST_MEDIUM;
		break;
	case AUTO_MARK_DIST_FAR:
		dist = DIST_FAR;
		break;
	default:
		return FALSE;
	}

	/* 򥻥å */
	set_chr_act( mbr, act_kind, NULL, NULL, 0, 0 );

	/* ƥޡ */
	mark_item( mbr, item, dist );

	draw_mbr_stat( mbr );

	return TRUE;
}

/*****************************************************************
* ɥоݤ˥˥塼¹Ԥ
* mbr_t *mbr : С
* return : Ԥ
*****************************************************************/

bool_t	exec_menu_auto_mark_door( mbr_t *mbr )
{
	auto_mark_t	*am;
	door_t	*door;
	dist_t	dist;
	act_kind_t	act_kind;

	am = &(ls_auto_mark[mbr->ls_mbr_n][auto_mark_cur_n]);

	switch( am->act ){
	case AUTO_MARK_ACT_FIGHT:
	case AUTO_MARK_ACT_THROW:
	case AUTO_MARK_ACT_STEAL:
	case AUTO_MARK_ACT_TAIL:
	case AUTO_MARK_ACT_PICK_UP:
		return FALSE;
	case AUTO_MARK_ACT_OPEN:
		act_kind = ACT_KIND_DOOR_OPEN;
		break;
	case AUTO_MARK_ACT_CLOSE:
		act_kind = ACT_KIND_DOOR_CLOSE;
		break;
	case AUTO_MARK_ACT_JAM:
		act_kind = ACT_KIND_DOOR_JAM;
		break;
	case AUTO_MARK_ACT_DISARM:
		act_kind = ACT_KIND_DOOR_DISARM;
		break;
	case AUTO_MARK_ACT_BREAK:
		act_kind = ACT_KIND_DOOR_BREAK;
		break;
	case AUTO_MARK_ACT_PEEP:
		act_kind = ACT_KIND_DOOR_PEEP;
		break;
	case AUTO_MARK_ACT_CHK:
		act_kind = ACT_KIND_DOOR_CHK;
		break;
	default:
		return FALSE;
	}

	/* ɥõ */
	door = NULL;
	switch( am->cond ){
	case AUTO_MARK_COND_NEAREST:
		door = get_door_nearest( mbr->x, mbr->y, act_kind );
		break;
	case AUTO_MARK_COND_DISPERSE:
		door = get_door_disperse( mbr, act_kind );
		if( door == NULL )
			door = get_door_randm( mbr->x, mbr->y, act_kind );
		break;
	case AUTO_MARK_COND_STAGGER:
	case AUTO_MARK_COND_OWN:
		return FALSE;
	}
	if( door == NULL )
		return FALSE;

	/* ֹ礤򥻥å */
	switch( am->dist ){
	case AUTO_MARK_DIST_NEAR:
		dist = DIST_NEAR;
		break;
	case AUTO_MARK_DIST_MEDIUM:
		dist = DIST_MEDIUM;
		break;
	case AUTO_MARK_DIST_FAR:
		dist = DIST_FAR;
		break;
	default:
		return FALSE;
	}

	/* 򥻥å */
	set_chr_act( mbr, act_kind, NULL, NULL, 0, 0 );

	/* ɥޡ */
	mark_door( mbr, door, dist );

	draw_mbr_stat( mbr );

	return TRUE;
}

/*****************************************************************
* Соݤ˥˥塼¹Ԥ
* mbr_t *mbr : С
* return : Ԥ
*****************************************************************/

bool_t	exec_menu_auto_mark_mbr( mbr_t *mbr )
{
	auto_mark_t	*am;
	mbr_t	*p;
	dist_t	dist;
	act_kind_t	act_kind;

	am = &(ls_auto_mark[mbr->ls_mbr_n][auto_mark_cur_n]);

	/* Сõ */
	p = NULL;
	switch( am->cond ){
	case AUTO_MARK_COND_NEAREST:
		p = get_mbr_nearest( mbr->x, mbr->y );
		break;
	case AUTO_MARK_COND_DISPERSE:
		p = get_mbr_disperse( mbr );
		if( p == NULL )
			p = get_mbr_randm( mbr->x, mbr->y );
		break;
	case AUTO_MARK_COND_STAGGER:
		p = get_mbr_stagger( mbr );
		break;
	case AUTO_MARK_COND_OWN:
		return FALSE;
	}
	if( p == NULL )
		return FALSE;

	/* ֹ礤򥻥å */
	switch( am->dist ){
	case AUTO_MARK_DIST_NEAR:
		dist = DIST_NEAR;
		break;
	case AUTO_MARK_DIST_MEDIUM:
		dist = DIST_MEDIUM;
		break;
	case AUTO_MARK_DIST_FAR:
		dist = DIST_FAR;
		break;
	default:
		return FALSE;
	}

	switch( am->act ){
	case AUTO_MARK_ACT_FIGHT:
		act_kind = ACT_KIND_MBR_FIGHT;
		break;
	case AUTO_MARK_ACT_THROW:
		act_kind = ACT_KIND_MBR_THROW;
		break;
	case AUTO_MARK_ACT_STEAL:
		act_kind = ACT_KIND_MBR_STEAL;
		break;
	case AUTO_MARK_ACT_TAIL:
		act_kind = ACT_KIND_MBR_TAIL;
		break;
	case AUTO_MARK_ACT_PICK_UP:
	case AUTO_MARK_ACT_OPEN:
	case AUTO_MARK_ACT_CLOSE:
	case AUTO_MARK_ACT_JAM:
	case AUTO_MARK_ACT_DISARM:
	case AUTO_MARK_ACT_BREAK:
	case AUTO_MARK_ACT_PEEP:
	case AUTO_MARK_ACT_CHK:
		return FALSE;
	default:
		return FALSE;
	}

	/* 򥻥å */
	set_chr_act( mbr, act_kind, NULL, NULL, 0, 0 );

	/* Сޡ */
	mark_mbr( mbr, p, dist );

	draw_mbr_stat( mbr );

	return TRUE;
}

/*****************************************************************
* ˥塼Խ򤵤줿˸ƤФ
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
*****************************************************************/

char	*cb_menu_auto_mark_edit( menu_t **pp, menu_t **dflt )
{
	char	*str_goto;

	auto_mark_cur_n = (long)((*pp)->arg);

	while( 1 ){
		str_goto = exec_menu_sel_mbr( &g_sel_mbr, NULL, TRUE, FALSE );
		if( str_goto != NULL )
			return str_goto;

		while( 1 ){
			str_goto = exec_menu(
					ls_menu_auto_mark_edit,
					NULL, NULL );
			if( str_goto == NULL )
				continue;
			if( strcmp( str_goto, STR_MENU_ERR ) == 0 )
				return STR_MENU_ERR;
			if( strcmp( str_goto, STR_MENU_CANCEL ) == 0 )
				break;
		}
	}

	return STR_MENU_ERR;
}

/*****************************************************************
* Խ˥塼
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
*****************************************************************/

char	*cb_menu_auto_mark_edit_init(
	menu_t **pp, menu_t **dflt
)
{
	menu_t	*p;

	/* ȥ */
	p = srch_menu( *pp, "Title" );
	if( p == NULL )
		return STR_MENU_ERR;
	sprintf( p->msg, MSG_TTL_MENU_AUTO_MARK_EDIT,
			get_msg_ttl_auto_mark( auto_mark_cur_n ),
			g_sel_mbr->name );

	/* о */
	p = srch_menu( *pp, "Target" );
	if( p == NULL )
		return STR_MENU_ERR;
	sprintf( p->msg, MSG_MENU_AUTO_MARK_EDIT_TRGT,
			get_msg_menu_auto_mark_edit_trgt( g_sel_mbr ) );

	/* ֹ礤 */
	p = srch_menu( *pp, "Dist" );
	if( p == NULL )
		return STR_MENU_ERR;
	sprintf( p->msg, MSG_MENU_AUTO_MARK_EDIT_DIST,
			get_msg_menu_auto_mark_edit_dist( g_sel_mbr ) );

	/* ư */
	p = srch_menu( *pp, "Action" );
	if( p == NULL )
		return STR_MENU_ERR;
	sprintf( p->msg, MSG_MENU_AUTO_MARK_EDIT_ACT,
			get_msg_menu_auto_mark_edit_act( g_sel_mbr ) );

	/*  */
	p = srch_menu( *pp, "Condition" );
	if( p == NULL )
		return STR_MENU_ERR;
	sprintf( p->msg, MSG_MENU_AUTO_MARK_EDIT_COND,
			get_msg_menu_auto_mark_edit_cond( g_sel_mbr ) );

	/* ƥ */
	if( ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].trgt
			== AUTO_MARK_TRGT_ITEM ){
		clr_flg_menu( *pp, "Appoint item", FLG_MENU_HIDDEN );
	} else {
		set_flg_menu( *pp, "Appoint item", FLG_MENU_HIDDEN );
	}

	/* Ϣ³ޡ */
	if( chk_flg( ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].flg,
			FLG_AUTO_MARK_EDIT_CONT ) ){
		set_chk_on_menu( *pp, "Continue" );
	} else {
		set_chk_off_menu( *pp, "Continue" );
	}

	/* ߤͥ */
	if( chk_flg( ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].flg,
			FLG_AUTO_MARK_EDIT_PRIORITY ) ){
		set_chk_on_menu( *pp, "Priority" );
	} else {
		set_chk_off_menu( *pp, "Priority" );
	}

	return NULL;
}

/*****************************************************************
* Խ˥塼оݤ
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
*****************************************************************/

char	*cb_menu_auto_mark_trgt_init(
	menu_t **pp, menu_t **dflt
)
{
	menu_t	*p;
	char	*s;

	p = srch_menu( *pp, "Title" );
	if( p == NULL )
		return STR_MENU_ERR;
	sprintf( p->msg, MSG_TTL_MENU_AUTO_MARK_TRGT,
			get_msg_ttl_auto_mark( auto_mark_cur_n ),
			g_sel_mbr->name );

	s = NULL;
	switch( ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].trgt ){
	case AUTO_MARK_TRGT_MNSTR:
		s = "Monster";
		break;
	case AUTO_MARK_TRGT_ITEM:
		s = "Item";
		break;
	case AUTO_MARK_TRGT_DOOR:
		s = "Door";
		break;
	case AUTO_MARK_TRGT_TRAP:
		s = "Trap";
		break;
	case AUTO_MARK_TRGT_MBR:
		s = "Member";
		break;
	case AUTO_MARK_TRGT_UNCHANGE:
		s = "Unchange";
		break;
	case AUTO_MARK_TRGT_CLEAR:
		s = "Clear";
		break;
	}

	*dflt = srch_menu( *pp, s );

	return NULL;
}

/*****************************************************************
* Խ˥塼оݤ򤷤
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
*****************************************************************/

char	*cb_menu_auto_mark_trgt( menu_t **pp, menu_t **dflt )
{
	auto_mark_trgt_t	trgt;

	trgt = (auto_mark_trgt_t)((*pp)->arg);
	ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].trgt = trgt;

	switch( trgt ){
	case AUTO_MARK_TRGT_MNSTR:
		ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].act
				= AUTO_MARK_ACT_FIGHT;
		break;
	case AUTO_MARK_TRGT_ITEM:
		ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].act
				= AUTO_MARK_ACT_PICK_UP;
		break;
	case AUTO_MARK_TRGT_DOOR:
		ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].act
				= AUTO_MARK_ACT_OPEN;
		break;
	case AUTO_MARK_TRGT_TRAP:
		ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].act
				= AUTO_MARK_ACT_DISARM;
		break;
	case AUTO_MARK_TRGT_MBR:
		ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].act
				= AUTO_MARK_ACT_TAIL;
		break;
	case AUTO_MARK_TRGT_UNCHANGE:
	case AUTO_MARK_TRGT_CLEAR:
		break;
	}

	return NULL;
}

/*****************************************************************
* Խ˥塼δֹ礤
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
*****************************************************************/

char	*cb_menu_auto_mark_dist_init(
	menu_t **pp, menu_t **dflt
)
{
	menu_t	*p;
	char	*s;

	if( ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].trgt
			== AUTO_MARK_TRGT_UNCHANGE ){
		return STR_MENU_CANCEL;
	}
	if( ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].trgt
			== AUTO_MARK_TRGT_CLEAR ){
		return STR_MENU_CANCEL;
	}

	p = srch_menu( *pp, "Title" );
	if( p == NULL )
		return STR_MENU_ERR;
	sprintf( p->msg, MSG_TTL_MENU_AUTO_MARK_DIST,
			get_msg_ttl_auto_mark( auto_mark_cur_n ),
			g_sel_mbr->name );

	s = NULL;
	switch( ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].dist ){
	case AUTO_MARK_DIST_NEAR:
		s = "Near";
		break;
	case AUTO_MARK_DIST_MEDIUM:
		s = "Medium";
		break;
	case AUTO_MARK_DIST_FAR:
		s = "Far";
		break;
	}

	*dflt = srch_menu( *pp, s );

	return NULL;
}

/*****************************************************************
* Խ˥塼δֹ礤򤷤
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
*****************************************************************/

char	*cb_menu_auto_mark_dist( menu_t **pp, menu_t **dflt )
{
	ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].dist
			= (auto_mark_dist_t)((*pp)->arg);

	return NULL;
}

/*****************************************************************
* Խ˥塼ιư
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
*****************************************************************/

char	*cb_menu_auto_mark_act_init( menu_t **pp, menu_t **dflt )
{
	menu_t	*p;
	char	*s;

	clr_flg_menu( *pp, NULL, FLG_MENU_ALL );

	if( ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].trgt
			== AUTO_MARK_TRGT_UNCHANGE ){
		return STR_MENU_CANCEL;
	}
	if( ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].trgt
			== AUTO_MARK_TRGT_CLEAR ){
		return STR_MENU_CANCEL;
	}

	p = srch_menu( *pp, "Title" );
	if( p == NULL )
		return STR_MENU_ERR;
	sprintf( p->msg, MSG_TTL_MENU_AUTO_MARK_ACT,
			get_msg_ttl_auto_mark( auto_mark_cur_n ),
			g_sel_mbr->name );

	s = NULL;
	switch( ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].act ){
	case AUTO_MARK_ACT_FIGHT:
		s = "Fight";
		break;
	case AUTO_MARK_ACT_THROW:
		s = "Throw";
		break;
	case AUTO_MARK_ACT_STEAL:
		s = "Steal";
		break;
	case AUTO_MARK_ACT_TAIL:
		s = "Tail";
		break;
	case AUTO_MARK_ACT_PICK_UP:
		s = "Pick up";
		break;
	case AUTO_MARK_ACT_OPEN:
		s = "Open";
		break;
	case AUTO_MARK_ACT_CLOSE:
		s = "Close";
		break;
	case AUTO_MARK_ACT_JAM:
		s = "Jam";
		break;
	case AUTO_MARK_ACT_DISARM:
		s = "Disarm";
		break;
	case AUTO_MARK_ACT_BREAK:
		s = "Break";
		break;
	case AUTO_MARK_ACT_PEEP:
		s = "Peep";
		break;
	case AUTO_MARK_ACT_CHK:
		s = "Check";
		break;
	}

	*dflt = srch_menu( *pp, s );

	/* оݤ˱ƥ˥塼ܤ̵ */

	switch( ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].trgt ){
	case AUTO_MARK_TRGT_MNSTR:
		set_flg_menu( *pp, "Pick up", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Open", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Close", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Jam", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Disarm", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Break", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Peep", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Search", FLG_MENU_HIDDEN );
		break;
	case AUTO_MARK_TRGT_ITEM:
		set_flg_menu( *pp, "Fight", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Throw", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Steal", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Tail", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Close", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Jam", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Peep", FLG_MENU_HIDDEN );
		break;
	case AUTO_MARK_TRGT_DOOR:
		set_flg_menu( *pp, "Fight", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Throw", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Steal", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Tail", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Pick up", FLG_MENU_HIDDEN );
		break;
	case AUTO_MARK_TRGT_TRAP:
		set_flg_menu( *pp, "Fight", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Throw", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Steal", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Tail", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Pick up", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Open", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Close", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Jam", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Peep", FLG_MENU_HIDDEN );
		break;
	case AUTO_MARK_TRGT_MBR:
		set_flg_menu( *pp, "Pick up", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Open", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Close", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Jam", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Disarm", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Break", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Peep", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Search", FLG_MENU_HIDDEN );
		break;
	case AUTO_MARK_TRGT_UNCHANGE:
	case AUTO_MARK_TRGT_CLEAR:
		return STR_MENU_CANCEL;
	}

	if( chk_flg( (*dflt)->flg, FLG_MENU_HIDDEN ) )
		*dflt = NULL;

	return NULL;
}

/*****************************************************************
* Խ˥塼ιư򤷤
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
*****************************************************************/

char	*cb_menu_auto_mark_act( menu_t **pp, menu_t **dflt )
{
	ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].act
			= (auto_mark_act_t)((*pp)->arg);

	return NULL;
}

/*****************************************************************
* Խ˥塼ξ
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
*****************************************************************/

char	*cb_menu_auto_mark_cond_init(
	menu_t **pp, menu_t **dflt
)
{
	char	*s;
	menu_t	*p;

	clr_flg_menu( *pp, NULL, FLG_MENU_ALL );

	if( ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].trgt
			== AUTO_MARK_TRGT_UNCHANGE ){
		return STR_MENU_CANCEL;
	}
	if( ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].trgt
			== AUTO_MARK_TRGT_CLEAR ){
		return STR_MENU_CANCEL;
	}

	p = srch_menu( *pp, "Title" );
	if( p == NULL )
		return STR_MENU_ERR;
	sprintf( p->msg, MSG_TTL_MENU_AUTO_MARK_COND,
			get_msg_ttl_auto_mark( auto_mark_cur_n ),
			g_sel_mbr->name );

	/* ǥեȤΥ */

	s = NULL;
	switch( ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].cond ){
	case AUTO_MARK_COND_NEAREST:
		s = "Nearest";
		break;
	case AUTO_MARK_COND_DISPERSE:
		s = "Disperse";
		break;
	case AUTO_MARK_COND_STAGGER:
		s = "Stagger";
		break;
	case AUTO_MARK_COND_OWN:
		s = "Own";
		break;
	}
	*dflt = srch_menu( *pp, s );

	/* оݤ˱ƥ˥塼ܤ̵ */

	switch( ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].trgt ){
	case AUTO_MARK_TRGT_DOOR:
	case AUTO_MARK_TRGT_TRAP:
	case AUTO_MARK_TRGT_MNSTR:
		set_flg_menu( *pp, "Stagger", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "Own", FLG_MENU_HIDDEN );
		break;
	case AUTO_MARK_TRGT_ITEM:
		set_flg_menu( *pp, "Stagger", FLG_MENU_HIDDEN );
		break;
	case AUTO_MARK_TRGT_MBR:
		set_flg_menu( *pp, "Own", FLG_MENU_HIDDEN );
		break;
	case AUTO_MARK_TRGT_UNCHANGE:
	case AUTO_MARK_TRGT_CLEAR:
		return STR_MENU_ERR;
	}

	if( (*dflt != NULL) && chk_flg( (*dflt)->flg, FLG_MENU_HIDDEN ) )
		*dflt = NULL;

	p = srch_menu( *pp, "Title" );
	if( p == NULL )
		return STR_MENU_ERR;
	sprintf( p->msg, MSG_TTL_MENU_AUTO_MARK_COND,
			get_msg_ttl_auto_mark( auto_mark_cur_n ),
			g_sel_mbr->name );

	return NULL;
}

/*****************************************************************
* Խ˥塼ξ򤷤
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
*****************************************************************/

char	*cb_menu_auto_mark_cond( menu_t **pp, menu_t **dflt )
{
	switch( (auto_mark_cond_t)((*pp)->arg) ){
	case AUTO_MARK_COND_NEAREST:
		ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].cond
				= AUTO_MARK_COND_NEAREST;
		break;
	case AUTO_MARK_COND_DISPERSE:
		ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].cond
				= AUTO_MARK_COND_DISPERSE;
		break;
	case AUTO_MARK_COND_STAGGER:
		ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].cond
				= AUTO_MARK_COND_STAGGER;
		break;
	case AUTO_MARK_COND_OWN:
		ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].cond
				= AUTO_MARK_COND_OWN;
		break;
	}

	return NULL;
}

/*****************************************************************
* Խ˥塼Υƥ̤򤷤
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
*****************************************************************/

char	*cb_menu_auto_mark_appoint_item(
	menu_t **pp, menu_t **dflt
)
{
	menu_t	*ls;
	long	k;
	auto_mark_appoint_item_t	*apo;
	long	i;

	if( ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].trgt
			!= AUTO_MARK_TRGT_ITEM ){
		return STR_MENU_CANCEL;
	}

	ls = ls_menu_appoint_item;
	k = 0;

	strncpy( ls[k].path, "/Appoint item",
			MENU_PATH_MAX_LEN );
	strncpy( ls[k].kind, "<Branch>",
			MENU_KIND_MAX_LEN );
	ls[k].key = '\0';
	ls[k].accel_key[0] = '\0';
	ls[k].n_msg = N_MSG_NULL;
	ls[k].msg[0] = '\0';
	ls[k].call_back = NULL;
	ls[k].arg = NULL;
	ls[k].flg = FLG_NULL;
	k++;

	strncpy( ls[k].path, "/Appoint item/Title",
			MENU_PATH_MAX_LEN );
	strncpy( ls[k].kind, "<Title>",
			MENU_KIND_MAX_LEN );
	ls[k].key = '\0';
	ls[k].accel_key[0] = '\0';
	ls[k].n_msg = N_MSG_NULL;
	sprintf( ls[k].msg, MSG_TTL_MENU_AUTO_MARK_APPOINT_ITEM_MJR,
			get_msg_ttl_auto_mark( auto_mark_cur_n ),
			g_sel_mbr->name );
	ls[k].call_back = NULL;
	ls[k].arg = NULL;
	ls[k].flg = FLG_NULL;
	k++;

	apo = get_auto_mark_appoint_item( g_sel_mbr );
	if( apo == NULL )
		return STR_MENU_ERR;

	for( i = 0; i < LOOP_MAX_1000; i++ ){
		char	*ret;

		if( apo->mjr == FACE_MJR_NULL )
			break;

		ret = set_menu_auto_mark_appoint_item(
				ls, &k, (char)('A' + i), &apo );
		if( ret != NULL )
			return ret;
	}
	ls[k].path[0] = '\0';

	*pp = ls;
	*dflt = NULL;

	return NULL;
}

/*****************************************************************
* Խ˥塼Υƥ̤
* menu_t *ls : ˥塼
* long *k : Υ˥塼ֹ
* char mjr_key : 򥭡
* auto_mark_appoint_item_t **apo : ƥ̤Υǡ
* return : ˥塼ΰư
*****************************************************************/

char	*set_menu_auto_mark_appoint_item(
	menu_t *ls, long *k, char mjr_key,
	auto_mark_appoint_item_t **apo
)
{
	char	mjr;
	char	mnr_key;

	mjr = (*apo)->mjr;

	sprintf( ls[*k].path, "/Appoint item/%c", mjr );
	strncpy( ls[*k].kind, "<Branch>",
			MENU_KIND_MAX_LEN );
	ls[*k].key = mjr_key;
	ls[*k].accel_key[0] = '\0';
	ls[*k].n_msg = N_MSG_NULL;
	strncpy( ls[*k].msg, get_item_mjr_name( mjr ),
			MENU_MSG_MAX_LEN );
	ls[*k].call_back = cb_menu_auto_mark_appoint_item_init;
	ls[*k].arg = (void *)(*apo);
	ls[*k].flg = FLG_NULL;
	(*k)++;

	mnr_key = 'A';
	for( ; (*apo)->mjr != FACE_MJR_NULL; (*apo)++ ){
		if( (*apo)->mjr != mjr )
			break;

		sprintf( ls[*k].path, "/Appoint item/%c/%c",
				(*apo)->mjr, (*apo)->mnr );
		strncpy( ls[*k].kind, "<CheckItem>",
				MENU_KIND_MAX_LEN );
		ls[*k].key = mnr_key;
		ls[*k].accel_key[0] = '\0';
		ls[*k].n_msg = N_MSG_NULL;
		strncpy( ls[*k].msg, get_item_mnr_name( mjr, (*apo)->mnr ),
				MENU_MSG_MAX_LEN );
		ls[*k].call_back = cb_menu_auto_mark_appoint_item_mnr;
		ls[*k].arg = (void *)(*apo);
		ls[*k].flg = FLG_NULL;
		(*k)++;

		mnr_key++;
	}

	return NULL;
}

/*****************************************************************
* Խ˥塼Υƥ̤
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
*****************************************************************/

char	*cb_menu_auto_mark_appoint_item_init(
	menu_t **pp, menu_t **dflt
)
{
	auto_mark_appoint_item_t	*apo;
	char	mjr;
	char	sub_path[MENU_PATH_MAX_LEN + 1];

	apo = (auto_mark_appoint_item_t *)((*pp)->arg);
	mjr = apo->mjr;

	for( ; apo->mjr != FACE_MJR_NULL; apo++ ){
		if( apo->mjr != mjr )
			break;

		sprintf( sub_path, "%c", apo->mnr );
		if( apo->flg_ena )
			set_chk_on_menu( *pp, sub_path );
		else
			set_chk_off_menu( *pp, sub_path );
	}

	return NULL;
}

/*****************************************************************
* Խ˥塼Υƥ̤ξܺ٤򤷤
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
*****************************************************************/

char	*cb_menu_auto_mark_appoint_item_mnr(
	menu_t **pp, menu_t **dflt
)
{
	auto_mark_appoint_item_t	*apo;

	apo = (auto_mark_appoint_item_t *)((*pp)->arg);
	if( chk_flg( (*pp)->flg, FLG_MENU_CHK_ON ) )
		apo->flg_ena = TRUE;
	else
		apo->flg_ena = FALSE;

	return STR_MENU_CANCEL;
}

/*****************************************************************
* Խ˥塼Ϣ³ޡ
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
*****************************************************************/

char	*cb_menu_auto_mark_cont( menu_t **pp, menu_t **dflt )
{
	if( chk_flg( (*pp)->flg, FLG_MENU_CHK_ON ) ){
		ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].flg
				|= FLG_AUTO_MARK_EDIT_CONT;
	} else {
		ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].flg
				&= ~(FLG_AUTO_MARK_EDIT_CONT);
	}

	return STR_MENU_CANCEL;
}

/*****************************************************************
* Խ˥塼ͥ
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
*****************************************************************/

char	*cb_menu_auto_mark_priority( menu_t **pp, menu_t **dflt )
{
	if( chk_flg( (*pp)->flg, FLG_MENU_CHK_ON ) ){
		ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].flg
				|= FLG_AUTO_MARK_EDIT_PRIORITY;
	} else {
		ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].flg
				&= ~(FLG_AUTO_MARK_EDIT_PRIORITY);
	}

	return STR_MENU_CANCEL;
}

/*****************************************************************
* Ƭ¤ٴ˥塼򤷤
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
*****************************************************************/

char	*cb_menu_auto_mark_arrange( menu_t **pp, menu_t **dflt )
{
	long	n, i, j;
	auto_mark_t	am;
	char	buf[MSG_TTL_AUTO_MARK_MAX_LEN + 1];

	n = (long)((*pp)->arg);

	/**/

	for( i = 0; i < LS_MBR_MAX_N; i++ ){
		am = ls_auto_mark[i][n];

		for( j = n - 1; j >= 0; j-- )
			ls_auto_mark[i][j + 1] = ls_auto_mark[i][j];

		ls_auto_mark[i][0] = am;
	}

	/**/

	strncpy( buf, get_msg_ttl_auto_mark( n ),
			MSG_TTL_AUTO_MARK_MAX_LEN );

	for( j = n - 1; j >= 0; j-- ){
		strncpy( get_msg_ttl_auto_mark( j + 1 ),
				get_msg_ttl_auto_mark( j ),
				MSG_TTL_AUTO_MARK_MAX_LEN );
	}

	strncpy( get_msg_ttl_auto_mark( 0 ), buf,
			MSG_TTL_AUTO_MARK_MAX_LEN );

	/**/

	set_menu_auto_mark( dflt );
	auto_mark_cur_n = 0;

	return "/Auto mark/0";
}

/*****************************************************************
* оݤоݤʸѴ
* mbr_t *mbr : С
* return : оݤΥ˥塼ʸ
*****************************************************************/

char	*get_msg_menu_auto_mark_edit_trgt( mbr_t *mbr )
{
	switch( ls_auto_mark[mbr->ls_mbr_n][auto_mark_cur_n].trgt ){
	case AUTO_MARK_TRGT_MNSTR:
		return MSG_MENU_AUTO_MARK_TRGT_MNSTR;
	case AUTO_MARK_TRGT_ITEM:
		return MSG_MENU_AUTO_MARK_TRGT_ITEM;
	case AUTO_MARK_TRGT_DOOR:
		return MSG_MENU_AUTO_MARK_TRGT_DOOR;
	case AUTO_MARK_TRGT_TRAP:
		return MSG_MENU_AUTO_MARK_TRGT_TRAP;
	case AUTO_MARK_TRGT_MBR:
		return MSG_MENU_AUTO_MARK_TRGT_MBR;
	case AUTO_MARK_TRGT_UNCHANGE:
		return MSG_MENU_AUTO_MARK_TRGT_UNCHANGE;
	case AUTO_MARK_TRGT_CLEAR:
		return MSG_MENU_AUTO_MARK_TRGT_CLEAR;
	}

	return MSG_NOT_NULL;
}

/*****************************************************************
* ֹ礤ֹ礤ʸѴ
* mbr_t *mbr : С
* return : ֹ礤Υ˥塼ʸ
*****************************************************************/

char	*get_msg_menu_auto_mark_edit_dist( mbr_t *mbr )
{
	auto_mark_trgt_t	trgt;

	trgt = ls_auto_mark[mbr->ls_mbr_n][auto_mark_cur_n].trgt;
	if( (trgt == AUTO_MARK_TRGT_UNCHANGE)
			|| (trgt ==AUTO_MARK_TRGT_CLEAR) ){
		return MSG_MENU_AUTO_MARK_INVALID;
	}

	switch( ls_auto_mark[mbr->ls_mbr_n][auto_mark_cur_n].dist ){
	case AUTO_MARK_DIST_NEAR:
		return MSG_MENU_AUTO_MARK_DIST_NEAR;
	case AUTO_MARK_DIST_MEDIUM:
		return MSG_MENU_AUTO_MARK_DIST_MEDIUM;
	case AUTO_MARK_DIST_FAR:
		return MSG_MENU_AUTO_MARK_DIST_FAR;
	}

	return MSG_NOT_NULL;
}

/*****************************************************************
* ưưʸѴ
* mbr_t *mbr : С
* return : ưΥ˥塼ʸ
*****************************************************************/

char	*get_msg_menu_auto_mark_edit_act( mbr_t *mbr )
{
	auto_mark_trgt_t	trgt;

	trgt = ls_auto_mark[mbr->ls_mbr_n][auto_mark_cur_n].trgt;
	if( (trgt == AUTO_MARK_TRGT_UNCHANGE)
			|| (trgt ==AUTO_MARK_TRGT_CLEAR) ){
		return MSG_MENU_AUTO_MARK_INVALID;
	}

	switch( ls_auto_mark[mbr->ls_mbr_n][auto_mark_cur_n].act ){
	case AUTO_MARK_ACT_FIGHT:
		return MSG_MENU_AUTO_MARK_ACT_FIGHT;
	case AUTO_MARK_ACT_THROW:
		return MSG_MENU_AUTO_MARK_ACT_THROW;
	case AUTO_MARK_ACT_STEAL:
		return MSG_MENU_AUTO_MARK_ACT_STEAL;
	case AUTO_MARK_ACT_TAIL:
		return MSG_MENU_AUTO_MARK_ACT_TAIL;
	case AUTO_MARK_ACT_PICK_UP:
		return MSG_MENU_AUTO_MARK_ACT_PICK_UP;
	case AUTO_MARK_ACT_OPEN:
		return MSG_MENU_AUTO_MARK_ACT_OPEN;
	case AUTO_MARK_ACT_CLOSE:
		return MSG_MENU_AUTO_MARK_ACT_CLOSE;
	case AUTO_MARK_ACT_JAM:
		return MSG_MENU_AUTO_MARK_ACT_JAM;
	case AUTO_MARK_ACT_DISARM:
		return MSG_MENU_AUTO_MARK_ACT_DISARM;
	case AUTO_MARK_ACT_BREAK:
		return MSG_MENU_AUTO_MARK_ACT_BREAK;
	case AUTO_MARK_ACT_PEEP:
		return MSG_MENU_AUTO_MARK_ACT_PEEP;
	case AUTO_MARK_ACT_CHK:
		return MSG_MENU_AUTO_MARK_ACT_CHK;
	}

	return MSG_NOT_NULL;
}

/*****************************************************************
* 狼ʸѴ
* mbr_t *mbr : С
* return : Υ˥塼ʸ
*****************************************************************/

char	*get_msg_menu_auto_mark_edit_cond( mbr_t *mbr )
{
	auto_mark_trgt_t	trgt;

	trgt = ls_auto_mark[mbr->ls_mbr_n][auto_mark_cur_n].trgt;
	if( (trgt == AUTO_MARK_TRGT_UNCHANGE)
			|| (trgt ==AUTO_MARK_TRGT_CLEAR) ){
		return MSG_MENU_AUTO_MARK_INVALID;
	}

	switch( ls_auto_mark[mbr->ls_mbr_n][auto_mark_cur_n].cond ){
	case AUTO_MARK_COND_NEAREST:
		return MSG_MENU_AUTO_MARK_COND_NEAREST;
	case AUTO_MARK_COND_DISPERSE:
		return MSG_MENU_AUTO_MARK_COND_DISPERSE;
	case AUTO_MARK_COND_STAGGER:
		return MSG_MENU_AUTO_MARK_COND_STAGGER;
	case AUTO_MARK_COND_OWN:
		return MSG_MENU_AUTO_MARK_COND_OWN;
	}

	return MSG_NOT_NULL;
}

/*****************************************************************
* ߤμưޡֹ֤
* return : ߤμưޡֹ
*****************************************************************/

long	get_auto_mark_cur_n( void )
{
	return auto_mark_cur_n;
}

/*****************************************************************
* ߤμưޡΥƥ̤֤
* return : ߤμưޡΥƥ
*****************************************************************/

auto_mark_appoint_item_t	*get_auto_mark_appoint_item( mbr_t *mbr )
{
	long	n;

	if( mbr == NULL )
		return NULL;

	n = get_auto_mark_cur_n();

	return auto_mark_appoint_item[mbr->ls_mbr_n][n];
}

/*****************************************************************
* ưޡΥȥʸ֤
* n : ưޡֹ
* return : ưޡΥȥʸ֤
*****************************************************************/

char	*get_msg_ttl_auto_mark( long n )
{
	return msg_ttl_auto_mark[n];
}

/*****************************************************************
* ưޡΥǡ֤
* long ls_mbr_n : СꥹȤֹ
* return : ưޡΥǡ֤
*****************************************************************/

auto_mark_t	*get_ls_auto_mark( long ls_mbr_n )
{
	if( ls_mbr_n < 0 )
		return NULL;
	if( ls_mbr_n >= LS_MBR_MAX_N )
		return NULL;

	return( ls_auto_mark[ls_mbr_n] );
}
