/*****************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2004 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: gmain.c,v 1.57 2004/07/30 14:29:27 bowkenken Exp $
*****************************************************************/

#include	<signal.h>

#include	"gmain.h"
#include	"misc.h"
#include	"turn.h"
#include	"town.h"
#include	"item.h"
#include	"spell.h"
#include	"chr.h"
#include	"party.h"
#include	"mnstr.h"
#include	"pet.h"
#include	"fight.h"
#include	"fx.h"
#include	"trap.h"
#include	"draw.h"
#include	"curs.h"
#include	"menu.h"
#include	"amenu.h"
#include	"request.h"
#include	"gfile.h"
#include	"msg.h"
#include	"ver.h"
#include	"gmain-prot.h"
#include	"misc-prot.h"
#include	"turn-prot.h"
#include	"dun-prot.h"
#include	"town-prot.h"
#include	"item-prot.h"
#include	"spell-prot.h"
#include	"chr-prot.h"
#include	"party-prot.h"
#include	"mnstr-prot.h"
#include	"pet-prot.h"
#include	"fight-prot.h"
#include	"fx-prot.h"
#include	"trap-prot.h"
#include	"draw-prot.h"
#include	"curs-prot.h"
#include	"menu-prot.h"
#include	"tmenu-prot.h"
#include	"amenu-prot.h"
#include	"request-prot.h"
#include	"gfile-prot.h"
#include	"msg-prot.h"

#ifdef	D_DOS
# include	"main-dos-prot.h"
#else	/* D_DOS */
# include	"main-unix-prot.h"
#endif	/* D_DOS */

/**/

void	init_arg( void )
{
	g_flg_debug = FALSE;
#ifdef	DEBUG
	g_flg_debug = TRUE;
#endif	/* DEBUG */
#ifdef	NDEBUG
	g_flg_debug = FALSE;
#endif	/* NDEBUG */

	g_flg_gui = FALSE;
	g_flg_cui = TRUE;
	g_flg_clr_key_buf = TRUE;
	g_flg_echo_key = FALSE;
	g_flg_use_curs = TRUE;
	g_flg_use_keypad = FALSE;
	g_flg_measure_clk_tck = FALSE;
}

/**/

void	init_game( void )
{
	dun_t	*dun;

	init_signal();
	init_scrn();

	srandm( time( NULL ) );
	init_turn();

	init_msg();
	init_draw();

	ena_scrn( TRUE );
	ena_curs_draw();
	wipe_all();

	init_game_file();

	init_dun();
	init_item();
	init_trap();
	init_fx();
	init_chr();
	init_spell();
	init_town();
	init_menu();
	init_tmenu();
	init_auto_menu();
	init_request();
	init_mbr_formation();

	if( g_flg_debug )
		set_flg_no_save( TRUE );

	if( !load_game_conf() )
		g_flg_measure_clk_tck = TRUE;

	if( g_flg_measure_clk_tck )
		measure_clk_tck();

	dun = get_dun();
	dun->lev = 0;
	up_dun( 0 );

	if( !g_flg_debug ){
		door_t	*dr;

		print_msg( FLG_NULL, MSG_HINT_CANCEL_MENU_1 );
		print_msg( FLG_NULL, MSG_HINT_CANCEL_MENU_2 );

		menu_bar_load();

		dr = get_shop_door( SHOP_N_BAR );
		if( dr != NULL ){
			open_door_shop( dr->n );
			exec_all_phase();
		}
	}
}

/**/

void	game_main( void )
{
	while( 1 ){
		chk_key( TRUE );
	}
}

/**/

void	exit_game( long code )
{
	FILE	*fp;

	curs_move( WIN_MSG_DRAW_MIN_Y, SCREEN_MIN_X );

	reset_scrn();

	if( code == 0 )
		fp = stdout;
	else
		fp = stderr;

	version( fp );

	exit( code );
}

/**/

void	about_game( void )
{
	static char	tmp[1023 + 1];

	curs_move( WIN_MSG_DRAW_MIN_Y, SCREEN_MIN_X );

	dis_scrn();

	fprintf( OUT_FP, MSG_FMT_COPYRIGHT, LS_STR_COPYRIGHT );
	fprintf( OUT_FP, "\n%s\n", MSG_HIT_ENTER_KEY );
	fflush( OUT_FP );
	fgets( tmp, sizeof( tmp ) - 1, stdin );

	fprintf( OUT_FP, MSG_S, MSG_ABOUT_GAME );
	fprintf( OUT_FP, "\n%s\n", MSG_HIT_ENTER_KEY );
	fflush( OUT_FP );
	fgets( tmp, sizeof( tmp ) - 1, stdin );

	ena_scrn( FALSE );
}

/**/

void	version( FILE *fp )
{
	fprintf( fp, STR_FMT_COPYRIGHT, LS_STR_COPYRIGHT );
	fflush( fp );
}

/**/

void	child_ps( void )
{
#ifdef	D_DOS
	child_ps_dos();
#else	/* D_DOS */
	child_ps_unix();
#endif	/* D_DOS */
}

/**/

void	init_signal( void )
{
#ifdef	D_X68K
	signal( SIGINT, signal_handler );
	signal( SIGABRT, signal_handler );
	signal( SIGTERM, signal_handler );
#elif	defined( D_DOS )
	signal( SIGINT, signal_handler );
	signal( SIGSEGV, signal_handler );
	signal( SIGABRT, signal_handler );
	signal( SIGTERM, signal_handler );
#else	/* D_X68K */
	signal( SIGHUP, signal_handler );
	signal( SIGINT, signal_handler );
	signal( SIGKILL, signal_handler );
	signal( SIGBUS, signal_handler );
	signal( SIGSEGV, signal_handler );
	signal( SIGABRT, signal_handler );
	signal( SIGTERM, signal_handler );
#endif	/* D_X68K */
}

/**/

void	signal_handler( int sig )
{
	reset_scrn();

	exit( EXIT_FAILURE );
}

/**/

void	init_scrn( void )
{
	init_curs();
	init_term();
}

/**/

void	reset_scrn( void )
{
	while( chk_term() )
		dis_term();

	curs_refresh();
	while( chk_curs() ){
		curs_endwin();
	}
}

/**/

void	ena_scrn( bool_t flg_initscr )
{
	if( flg_initscr ){
		curs_initscr();
		curs_keypad( stdscr, TRUE );
	} else {
		curs_clearok( stdscr, TRUE );
		curs_refresh();
	}

	ena_term();
}

/**/

void	dis_scrn( void )
{
	dis_term();

	curs_refresh();
	curs_endwin();
}

/**/

void	init_term( void )
{
#ifdef	D_DOS
	init_term_dos();
#else	/* D_DOS */
	init_term_unix();
#endif	/* D_DOS */
}

/**/

bool_t	chk_term( void )
{
#ifdef	D_DOS
	return chk_term_dos();
#else	/* D_DOS */
	return chk_term_unix();
#endif	/* D_DOS */
}

/**/

void	ena_term( void )
{
#ifdef	D_DOS
	ena_term_dos();
#else	/* D_DOS */
	ena_term_unix();
#endif	/* D_DOS */
}

/**/

void	dis_term( void )
{
#ifdef	D_DOS
	dis_term_dos();
#else	/* D_DOS */
	dis_term_unix();
#endif	/* D_DOS */
}

/**/

void	set_key_wait( void )
{
#ifdef	D_DOS
	set_key_wait_dos();
#else	/* D_DOS */
	set_key_wait_unix();
#endif	/* D_DOS */
}

/**/

void	clr_key_wait( void )
{
#ifdef	D_DOS
	clr_key_wait_dos();
#else	/* D_DOS */
	clr_key_wait_unix();
#endif	/* D_DOS */
}

/**/

