/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2006 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: Key.cpp,v 1.14 2006/01/12 08:51:40 bowkenken Exp $
***************************************************************/

#include "gmain.h"
#include "curs.h"
#include "draw.h"
#include "draw-prot.h"

#include "Key.h"
#include "GlobalVar.h"

////////////////////////////////////////////////////////////////
// WideStudio ΥХ롦եåΥϥɥ
// long keyCode : 
// WSCbool flagOn : Υ󡿥
// return : false ʤ饭Ϥ˴
////////////////////////////////////////////////////////////////

static WSCbool handler( long keyCode, WSCbool flagOn )
{
	long key = '\0';

	if( !flagOn )
		return true;

	if( (WSK_a <= keyCode) && (keyCode <= WSK_z) ){
		if( WSGIappKeyboard()->withCntl() ){
			key = keyCode - WSK_a + 1;
		} else {
			key = keyCode;
		}

		gKey.setChar( key, true );
		return false;
	}
	if( (WSK_A <= keyCode) && (keyCode <= WSK_Z) ){
		if( WSGIappKeyboard()->withCntl() ){
			key = keyCode - WSK_A + 1;
		} else {
			key = keyCode;
		}

		gKey.setChar( key, true );
		return false;
	}

	switch( keyCode ){
	// 롦
	case WSK_Up:
		key = '8';
		break;
	case WSK_Down:
		key = '2';
		break;
	case WSK_Left:
		key = '4';
		break;
	case WSK_Right:
		key = '6';
		break;
	// 롦
	case WSK_Insert:
		key = '/';
		break;
	case WSK_Home:
		key = '*';
		break;
	case WSK_Page_Up:
		key = '-';
		break;
	case WSK_Page_Down:
		key = '+';
		break;
	case WSK_Delete:
		key = 'H' - '@';
		break;
	case WSK_End:
		key = '.';
		break;
	// ƥ󡦥
	case WSK_KP_0:
		key = '0';
		break;
	case WSK_KP_1:
		key = '1';
		break;
	case WSK_KP_2:
		key = '2';
		break;
	case WSK_KP_3:
		key = '3';
		break;
	case WSK_KP_4:
		key = '4';
		break;
	case WSK_KP_5:
		key = '5';
		break;
	case WSK_KP_6:
		key = '6';
		break;
	case WSK_KP_7:
		key = '7';
		break;
	case WSK_KP_8:
		key = '8';
		break;
	case WSK_KP_9:
		key = '9';
		break;
	// ƥ󡦥
	case WSK_KP_Enter:
		key = 'M' - '@';
		break;
	case WSK_KP_Divide:
		key = '/';
		break;
	case WSK_KP_Multiply:
		key = '*';
		break;
	case WSK_KP_Subtract:
		key = '-';
		break;
	case WSK_KP_Add:
		key = '+';
		break;
	case WSK_KP_Decimal:
		key = '.';
		break;
	// ե󥯥󡦥
	case WSK_F1:
		key = KEY_F( 1 );
		break;
	case WSK_F2:
		key = KEY_F( 2 );
		break;
	case WSK_F3:
		key = KEY_F( 3 );
		break;
	case WSK_F4:
		key = KEY_F( 4 );
		break;
	case WSK_F5:
		key = KEY_F( 5 );
		break;
	case WSK_F6:
		key = KEY_F( 6 );
		break;
	case WSK_F7:
		key = KEY_F( 7 );
		break;
	case WSK_F8:
		key = KEY_F( 8 );
		break;
	case WSK_F9:
		key = KEY_F( 9 );
		break;
	case WSK_F10:
		key = KEY_F( 10 );
		break;
	case WSK_F11:
		key = KEY_F( 11 );
		break;
	case WSK_F12:
		key = KEY_F( 12 );
		break;
	case WSK_F13:
		key = KEY_F( 13 );
		break;
	case WSK_F14:
		key = KEY_F( 14 );
		break;
	case WSK_F15:
		key = KEY_F( 15 );
		break;
	// ¾
	case WSK_bracketleft:
		if( WSGIappKeyboard()->withCntl() )
			key = 'H' - '@';
		else
			key = '[';
		break;
	case WSK_Tab:
		key = 'I' - '@';
		break;
	case WSK_Escape:
		key = 'H' - '@';
		break;
	case WSK_Shift_L:
	case WSK_Control_L:
	case WSK_Alt_L:
	case WSK_Meta_L:
		key = '\0';
		break;
	default:
		key = keyCode;
		break;
	}

	gKey.setChar( key, true );
	return false;
}

////////////////////////////////////////////////////////////////
// Х롦եåΥϥɥϿ
////////////////////////////////////////////////////////////////

void Key::init()
{
	WSGIappKeyboard()->setGlobalKeyHook( handler );
}

////////////////////////////////////////////////////////////////
// Хåե飱ʸФ
// return : 
////////////////////////////////////////////////////////////////

long Key::getChar()
{
	if( buf.getChars() <= 0 )
		return -1;

	long c = buf[0];
	buf.deleteChar( 0 );

	return c;
}

////////////////////////////////////////////////////////////////
// Хåեˣʸɲ
// long c : 
// bool flagCheckClear : ԡȤХåե
//                       ޤʤͤˤ뤫
////////////////////////////////////////////////////////////////

void Key::setChar( long c, bool flagCheckClear )
{
	char s[4 + 1] = "";
	s[0] = c;
	s[1] = '\0';

	setString( s, flagCheckClear );
}

////////////////////////////////////////////////////////////////
// Хåեʸɲ
// WSCstring s : ʸ
// bool flagCheckClear : ԡȤХåե
//                       ޤʤͤˤ뤫
////////////////////////////////////////////////////////////////

void Key::setString( WSCstring s, bool flagCheckClear )
{
	if( flagCheckClear && g_flg_clr_key_buf ){
		static long gPreChar = -1;

		if( get_key_buf_char() == '\0' )
			gPreChar = -1;

		for( long i = 0; i < s.getChars(); i++ ){
			if( s[i] == gPreChar ){
				s.deleteChar( i );
				i--;
			} else {
				gPreChar = s[i];
			}
		}
	}

	if( s.getChars() <= 0 )
		return;
	if( s[0] == '\0' )
		return;

	switch( g_gui_key_kind ){
	case GUI_KEY_KIND_CONSOLE:
	case GUI_KEY_KIND_KEY_BUF_INTERRUPT:
		setStringKeyTab( s );
		break;
	case GUI_KEY_KIND_CLASS_KEY:
		buf += s;
		break;
	case GUI_KEY_KIND_MAX_N:
		break;
	}
}

////////////////////////////////////////////////////////////////
// Хåեʸɲ
// WSCstring s : ʸ
////////////////////////////////////////////////////////////////

void Key::setStringKeyTab( WSCstring s )
{
	char **tab = get_key_tab();

	for( ; s.getChars() > 0; s.deleteChar( 0 ) ){
		long c;
		c = s[0];

		bool bFlgTab;
		bFlgTab = true;

		if( c <= '\0' )
			bFlgTab = false;
		if( c >= KEY_TAB_MAX_N )
			bFlgTab = false;
		if( tab[c] == NULL )
			bFlgTab = false;

		if( bFlgTab ){
			set_key_buf_str( tab[c] );
		} else {
			WSCstring buf;
			buf = s;
			buf.cutString( 1 );

			set_key_buf_str( buf );
		}
	}

	set_flg_break_key( TRUE );
}
