/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2006 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: PcgDun.cpp,v 1.23 2006/02/02 19:37:24 bowkenken Exp $
***************************************************************/

#include	"gmain.h"
#include	"misc.h"
//#include	"turn.h"
#include	"dun.h"
//#include	"town.h"
//#include	"item.h"
//#include	"spell.h"
//#include	"chr.h"
#include	"party.h"
#include	"mnstr.h"
//#include	"pet.h"
//#include	"fight.h"
//#include	"fx.h"
//#include	"trap.h"
#include	"draw.h"
//#include	"curs.h"
#include	"menu.h"
//#include	"amenu.h"
//#include	"request.h"
//#include	"gfile.h"
//#include	"msg.h"
//#include	"ver.h"
#include	"gmain-prot.h"
#include	"misc-prot.h"
//#include	"turn-prot.h"
#include	"dun-prot.h"
//#include	"town-prot.h"
//#include	"item-prot.h"
//#include	"spell-prot.h"
//#include	"chr-prot.h"
//#include	"party-prot.h"
#include	"mnstr-prot.h"
//#include	"pet-prot.h"
//#include	"fight-prot.h"
//#include	"fx-prot.h"
//#include	"trap-prot.h"
#include	"draw-prot.h"
//#include	"curs-prot.h"
//#include	"menu-prot.h"
#include	"mmenu-prot.h"
//#include	"imenu-prot.h"
//#include	"tmenu-prot.h"
//#include	"amenu-prot.h"
//#include	"request-prot.h"
//#include	"gfile-prot.h"
//#include	"msg-prot.h"

#include "PcgDun.h"
#include "FileList.h"

#include <WSCform.h>
#include <WSCvscrBar.h>

extern WSCform *MapForm;
extern WSCvscrBar *MapScrollX;
extern WSCvscrBar *MapScrollY;

////////////////////////////////////////////////////////////////
// ѥΥơ֥
////////////////////////////////////////////////////////////////

PcgTab gPcgTabNullTown[] = {
	{
		// 
		MNSTR_KIND_NULL, 100,
		"null/town/",
	},
	{
		MNSTR_KIND_NULL, -1,
		"",
	},
};

PcgTab gPcgTabNullDun[] = {
	{
		// 
		MNSTR_KIND_NULL, 100,
		"null/dungeon/",
	},
	{
		MNSTR_KIND_NULL, -1,
		"",
	},
};

PcgTab gPcgTabFloorTown[] = {
	{
		// 
		MNSTR_KIND_NULL, 100,
		"floor/town/",
	},
	{
		// 夿ޤ
		MNSTR_KIND_NULL, 10,
		"floor/town/puddle/",
	},
	{
		// 
		MNSTR_KIND_NULL, 10,
		"floor/town/moss/",
	},
	{
		MNSTR_KIND_NULL, -1,
		"",
	},
};

PcgTab gPcgTabFloorDun[] = {
	{
		// 
		MNSTR_KIND_NULL, 100,
		"floor/dungeon/",
	},
	{
		// 夿ޤ
		MNSTR_KIND_NULL, 10,
		"floor/dungeon/puddle/",
	},
	{
		// 
		MNSTR_KIND_NULL, 10,
		"floor/dungeon/moss/",
	},
	{
		MNSTR_KIND_NULL, -1,
		"",
	},
};

PcgTab gPcgTabWallTown[] = {
	{
		// 
		MNSTR_KIND_NULL, 100,
		"wall/town/",
	},
	{
		// 
		MNSTR_KIND_NULL, 10,
		"wall/town/moss/",
	},
	{
		MNSTR_KIND_NULL, -1,
		"",
	},
};

PcgTab gPcgTabWallDun[] = {
	{
		// 
		MNSTR_KIND_NULL, 100,
		"wall/dungeon/",
	},
	{
		// 
		MNSTR_KIND_NULL, 10,
		"wall/dungeon/moss/",
	},
	{
		MNSTR_KIND_NULL, -1,
		"",
	},
};

PcgTab gPcgTabDoorCloseTown[] = {
	{
		// 
		MNSTR_KIND_NULL, 100,
		"door/close/town/",
	},
	{
		MNSTR_KIND_NULL, -1,
		"",
	},
};

PcgTab gPcgTabDoorCloseDun[] = {
	{
		// 
		MNSTR_KIND_NULL, 100,
		"door/close/dungeon/",
	},
	{
		MNSTR_KIND_NULL, -1,
		"",
	},
};

PcgTab gPcgTabDoorOpenTown[] = {
	{
		// 
		MNSTR_KIND_NULL, 100,
		"door/open/town/",
	},
	{
		MNSTR_KIND_NULL, -1,
		"",
	},
};

PcgTab gPcgTabDoorOpenDun[] = {
	{
		// 
		MNSTR_KIND_NULL, 100,
		"door/open/dungeon/",
	},
	{
		MNSTR_KIND_NULL, -1,
		"",
	},
};

PcgTab gPcgTabCrsr[] = {
	{
		// 
		MNSTR_KIND_NULL, 100,
		"cursor/",
	},
	{
		MNSTR_KIND_NULL, -1,
		"",
	},
};

PcgTab gPcgTabMnstr[] = {
	{
		MNSTR_KIND_GIANT_BAT, 100,
		"monster/animal/giant_bat/",
	},
	{
		MNSTR_KIND_GIANT_RAT, 100,
		"monster/animal/giant_rat/",
	},
	{
		MNSTR_KIND_NULL, -1,
		"",
	},
};

////////////////////////////////////////////////////////////////
// ѥ󡦥ǥåΥơ֥
////////////////////////////////////////////////////////////////

const long gBitIdxWallN = 1 << 0;
const long gBitIdxWallS = 1 << 1;
const long gBitIdxWallE = 1 << 2;
const long gBitIdxWallW = 1 << 3;

pos_t gIdxWall[2 * 2 * 2 * 2] = {
	{ +3, +3 }, //....
	{ +3, +2 }, //...N
	{ +3, +0 }, //..S.
	{ +3, +1 }, //..SN

	{ +0, +3 }, //.E.
	{ +0, +2 }, //.E.N
	{ +0, +0 }, //.ES.
	{ +0, +1 }, //.ESN

	{ +2, +3 }, //W...
	{ +2, +2 }, //W..N
	{ +2, +0 }, //W.S.
	{ +2, +1 }, //W.SN

	{ +1, +3 }, //WE..
	{ +1, +2 }, //WE.N
	{ +1, +0 }, //WES.
	{ +1, +1 }, //WESN
};

const long gBitIdxWallNE = 1 << 0;
const long gBitIdxWallNW = 1 << 1;
const long gBitIdxWallSE = 1 << 2;
const long gBitIdxWallSW = 1 << 3;

pos_t gIdxWallDiagonal[2 * 2 * 2 * 2] = {
	{ +1, +1 }, //.. .. .. ..
	{ +1, +1 }, //.. .. .. NE
	{ +1, +1 }, //.. .. NW ..
	{ +1, +1 }, //.. .. NW NE

	{ +1, +1 }, //.. SE .. ..
	{ +1, +1 }, //.. SE .. NE
	{ +1, +1 }, //.. SE NW ..
	{ +1, +4 }, //.. SE NW NE

	{ +1, +1 }, //SW .. .. ..
	{ +1, +1 }, //SW .. .. NE
	{ +1, +1 }, //SW .. NW ..
	{ +0, +4 }, //SW .. NW NE

	{ +1, +1 }, //SW SE .. ..
	{ +3, +4 }, //SW SE .. NE
	{ +2, +4 }, //SW SE NW ..
	{ +1, +1 }, //SW SE NW NE
};

////////////////////////////////////////////////////////////////
// 
////////////////////////////////////////////////////////////////

void PcgDun::init()
{
	FileList ls;
	WSCstring ext = "png jpg bmp";

	// ̤õ
	for( long i = 0; i < PCG_NULL_MAX_N; i++ ){
		nNullTownN[i] = 0;

		if( gPcgTabNullTown[i].nRatio <= -1 )
			break;

		ls.reset( gPcgTabNullTown[i].sDir, ext );
		long j = 0;
		for( j = 0; j < PCG_LS_MAX_N; j++ ){
			WSCstring path = ls.next();
			if( path.getChars() <= 0 )
				break;
			aNullTown[i][j].init( path );
		}
		nNullTownN[i] = j;
	}
	for( long i = 0; i < PCG_NULL_MAX_N; i++ ){
		nNullDunN[i] = 0;

		if( gPcgTabNullDun[i].nRatio <= -1 )
			break;

		ls.reset( gPcgTabNullDun[i].sDir, ext );
		long j = 0;
		for( j = 0; j < PCG_LS_MAX_N; j++ ){
			WSCstring path = ls.next();
			if( path.getChars() <= 0 )
				break;
			aNullDun[i][j].init( path );
		}
		nNullDunN[i] = j;
	}

	// 
	for( long i = 0; i < PCG_FLOOR_MAX_N; i++ ){
		nFloorTownN[i] = 0;

		if( gPcgTabFloorTown[i].nRatio <= -1 )
			break;

		ls.reset( gPcgTabFloorTown[i].sDir, ext );
		long j = 0;
		for( j = 0; j < PCG_LS_MAX_N; j++ ){
			WSCstring path = ls.next();
			if( path.getChars() <= 0 )
				break;
			aFloorTown[i][j].init( path );
		}
		nFloorTownN[i] = j;
	}
	for( long i = 0; i < PCG_FLOOR_MAX_N; i++ ){
		nFloorDunN[i] = 0;

		if( gPcgTabFloorDun[i].nRatio <= -1 )
			break;

		ls.reset( gPcgTabFloorDun[i].sDir, ext );
		long j = 0;
		for( j = 0; j < PCG_LS_MAX_N; j++ ){
			WSCstring path = ls.next();
			if( path.getChars() <= 0 )
				break;
			aFloorDun[i][j].init( path );
		}
		nFloorDunN[i] = j;
	}

	// 
	for( long i = 0; i < PCG_WALL_MAX_N; i++ ){
		nWallTownN[i] = 0;

		if( gPcgTabWallTown[i].nRatio <= -1 )
			break;

		ls.reset( gPcgTabWallTown[i].sDir, ext );
		long j = 0;
		for( j = 0; j < PCG_LS_MAX_N; j++ ){
			WSCstring path = ls.next();
			if( path.getChars() <= 0 )
				break;
			aWallTown[i][j].init( path );
		}
		nWallTownN[i] = j;
	}
	for( long i = 0; i < PCG_WALL_MAX_N; i++ ){
		nWallDunN[i] = 0;

		if( gPcgTabWallDun[i].nRatio <= -1 )
			break;

		ls.reset( gPcgTabWallDun[i].sDir, ext );
		long j = 0;
		for( j = 0; j < PCG_LS_MAX_N; j++ ){
			WSCstring path = ls.next();
			if( path.getChars() <= 0 )
				break;
			aWallDun[i][j].init( path );
		}
		nWallDunN[i] = j;
	}

	// Ĥޤäɥ
	for( long i = 0; i < PCG_DOOR_MAX_N; i++ ){
		nDoorCloseTownN[i] = 0;

		if( gPcgTabDoorCloseTown[i].nRatio <= -1 )
			break;

		ls.reset( gPcgTabDoorCloseTown[i].sDir, ext );
		long j = 0;
		for( j = 0; j < PCG_LS_MAX_N; j++ ){
			WSCstring path = ls.next();
			if( path.getChars() <= 0 )
				break;
			aDoorCloseTown[i][j].init( path );
		}
		nDoorCloseTownN[i] = j;
	}
	for( long i = 0; i < PCG_DOOR_MAX_N; i++ ){
		nDoorCloseDunN[i] = 0;

		if( gPcgTabDoorCloseDun[i].nRatio <= -1 )
			break;

		ls.reset( gPcgTabDoorCloseDun[i].sDir, ext );
		long j = 0;
		for( j = 0; j < PCG_LS_MAX_N; j++ ){
			WSCstring path = ls.next();
			if( path.getChars() <= 0 )
				break;
			aDoorCloseDun[i][j].init( path );
		}
		nDoorCloseDunN[i] = j;
	}

	// ɥ
	for( long i = 0; i < PCG_DOOR_MAX_N; i++ ){
		nDoorOpenTownN[i] = 0;

		if( gPcgTabDoorOpenTown[i].nRatio <= -1 )
			break;

		ls.reset( gPcgTabDoorOpenTown[i].sDir, ext );
		long j = 0;
		for( j = 0; j < PCG_LS_MAX_N; j++ ){
			WSCstring path = ls.next();
			if( path.getChars() <= 0 )
				break;
			aDoorOpenTown[i][j].init( path );
		}
		nDoorOpenTownN[i] = j;
	}
	for( long i = 0; i < PCG_DOOR_MAX_N; i++ ){
		nDoorOpenDunN[i] = 0;

		if( gPcgTabDoorOpenDun[i].nRatio <= -1 )
			break;

		ls.reset( gPcgTabDoorOpenDun[i].sDir, ext );
		long j = 0;
		for( j = 0; j < PCG_LS_MAX_N; j++ ){
			WSCstring path = ls.next();
			if( path.getChars() <= 0 )
				break;
			aDoorOpenDun[i][j].init( path );
		}
		nDoorOpenDunN[i] = j;
	}

	// 
	for( long i = 0; i < PCG_CRSR_MAX_N; i++ ){
		nCrsrN[i] = 0;

		if( gPcgTabCrsr[i].nRatio <= -1 )
			break;

		ls.reset( gPcgTabCrsr[i].sDir, ext );
		long j = 0;
		for( j = 0; j < PCG_LS_MAX_N; j++ ){
			WSCstring path = ls.next();
			if( path.getChars() <= 0 )
				break;
			aCrsr[i][j].init( path );
		}
		nCrsrN[i] = j;
	}

	// 󥹥
	for( long i = 0; i < PCG_MNSTR_MAX_N; i++ ){
break;//@@@
		nMnstrN[i] = 0;

		if( gPcgTabMnstr[i].nRatio <= -1 )
			break;

		if( gPcgTabMnstr[i].nMnstrKind == MNSTR_KIND_NULL )
			break;

		ls.reset( gPcgTabMnstr[i].sDir, ext );
		long j = 0;
		for( j = 0; j < PCG_LS_MAX_N; j++ ){
			WSCstring path = ls.next();
			if( path.getChars() <= 0 )
				break;
			aMnstr[i][j].init( path );
		}
		nMnstrN[i] = j;

		aMnstr[i][j].dis();
	}

	reset();
}

////////////////////////////////////////////////////////////////
// ꥻå
////////////////////////////////////////////////////////////////

void PcgDun::reset()
{
	resetUpdateFlg();

	for( long i = 0; i < PCG_MNSTR_MAX_N; i++ ){
break;//@@@
		if( gPcgTabMnstr[i].nRatio <= -1 )
			break;
		if( gPcgTabMnstr[i].nMnstrKind == MNSTR_KIND_NULL )
			break;

		for( long j = 0; j < PCG_LS_MAX_N; j++ ){
			aMnstr[i][j].dis();
		}
	}

	if( get_dun()->lev == 0 ){
		resetMap( gPcgTabNullTown, aaMapNull );
		resetMap( gPcgTabFloorTown, aaMapFloor );
		resetMap( gPcgTabWallTown, aaMapWall );
		resetMap( gPcgTabDoorCloseTown, aaMapDoorClose );
		resetMap( gPcgTabDoorOpenTown, aaMapDoorOpen );
	} else {
		resetMap( gPcgTabNullDun, aaMapNull );
		resetMap( gPcgTabFloorDun, aaMapFloor );
		resetMap( gPcgTabWallDun, aaMapWall );
		resetMap( gPcgTabDoorCloseDun, aaMapDoorClose );
		resetMap( gPcgTabDoorOpenDun, aaMapDoorOpen );
	}
}

////////////////////////////////////////////////////////////////
// ѥΥХꥨ󡦥ޥåפΥꥻå
// PcgTab tab[] : ѥΥơ֥
// PcgMap map[MAP_MAX_Y][MAP_MAX_X] : ХꥨΥޥå
////////////////////////////////////////////////////////////////

void PcgDun::resetMap( PcgTab tab[], PcgMap map[MAP_MAX_Y][MAP_MAX_X] )
{
	long nRatioSum = 0;
	for( long i = 0; i < LOOP_MAX_100; i++ ){
		if( tab[i].nRatio <= -1 )
			break;

		nRatioSum += tab[i].nRatio;
	}

	for( long y = 0; y < MAP_MAX_Y; y++ ){
		for( long x = 0; x < MAP_MAX_X; x++ ){
			map[y][x] = 0;

			long n = randm( nRatioSum );
			long nSum = 0;
			long i = 0;
			for( i = 0; i < LOOP_MAX_100; i++ ){
				if( tab[i].nRatio <= -1 )
					break;

				nSum += tab[i].nRatio;
				if( n < nSum ){
					map[y][x] = i;
					break;
				}
			}
		}
	}
}

////////////////////////////////////////////////////////////////
// ե졼ࡦХåե֤
// return : ե졼ࡦХåե
////////////////////////////////////////////////////////////////

WSDmwindowDev *PcgDun::getBG()
{
	if( pBG == NULL ){
		pBG = WSDmwindowDev::getNewInstance();
		pBG->createPixmap( MAP_MAX_X * nTileSizeX,
				MAP_MAX_Y * nTileSizeY );
	}

	return pBG;
}

////////////////////////////////////////////////////////////////
// ޥåפΥʥκɸǻꤹ
// long mapX : X ɸ
// long mapY : Y ɸ
////////////////////////////////////////////////////////////////

void PcgDun::scrollTile( long mapX, long mapY )
{
	scrollMap( mapX * nTileSizeX, mapY * nTileSizeY );
}

////////////////////////////////////////////////////////////////
// ޥåפΥʥɥåȤκɸǻꤹ
// long x : X ɸ
// long y : Y ɸ
////////////////////////////////////////////////////////////////

void PcgDun::scrollMap( long x, long y )
{
	long maxX = (long)MapScrollX->getProperty( WSNmaximum );
	long maxY = (long)MapScrollY->getProperty( WSNmaximum );
	long w = (long)MapScrollX->getProperty( WSNsliderSize );
	long h = (long)MapScrollY->getProperty( WSNsliderSize );

	if( x < 0 )
		x = 0;
	if( y < 0 )
		y = 0;
	if( x > maxX + w )
		x = maxX + w;
	if( y > maxY + h )
		y = maxY + h;

	MapScrollX->setProperty( WSNvalue, x );
	MapScrollY->setProperty( WSNvalue, y );

	drawScroll( x, y, w, h );
}

////////////////////////////////////////////////////////////////
// ޥåפ뤷褹ɬפͭ뤫å
// long x : X ɸ
// long y : Y ɸ
// long w : 
// long h : ⤵
// return : 褹ɬפͭ뤫
////////////////////////////////////////////////////////////////

bool PcgDun::chkScroll( long x, long y, long w, long h )
{
	x /= nTileSizeX;
	y /= nTileSizeY;

	static long preX = -1;
	static long preY = -1;
	static long preW = -1;
	static long preH = -1;

	if( (x == preX) && (y == preY) && (w == preW) && (h == preH) )
		return false;

	preX = x;
	preY = y;
	preW = w;
	preH = h;

	return true;
}

////////////////////////////////////////////////////////////////
// ޥåפ뤷
// long x : X ɸ
// long y : Y ɸ
// long w : 
// long h : ⤵
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool PcgDun::drawScroll( long x, long y, long w, long h )
{
	if( chk_nest_flg_dun() )
		return false;

	long mapX = x / nTileSizeX;
	long mapY = y / nTileSizeY;
	long mapW = (w + nTileSizeX - 1) / nTileSizeX;
	long mapH = (h + nTileSizeY - 1) / nTileSizeY;

	for( long dy = 0; dy < mapH; dy++ ){
		for( long dx = 0; dx < mapW; dx++ ){
			long xx = mapX + dx;
			long yy = mapY + dy;

			if( !getUpdateFlg( xx, yy ) )
				continue;

			if( !drawTile( xx, yy, false ) )
				return false;
		}
	}

	flush( mapX, mapY, mapW, mapH );

	return true;
}

////////////////////////////////////////////////////////////////
// κɸޥåפΥɥϰ⤫Ĵ٤
// long mapX : X ɸ
// long mapY : Y ɸ
// return : ϰ⤫
////////////////////////////////////////////////////////////////

bool PcgDun::clipWin( long mapX, long mapY )
{
	long x = (long)MapScrollX->getProperty( WSNvalue );
	long y = (long)MapScrollY->getProperty( WSNvalue );
	long w = (long)MapForm->getProperty( WSNwidth );
	long h = (long)MapForm->getProperty( WSNheight );

	x /= nTileSizeX;
	y /= nTileSizeY;
	w = (w + nTileSizeX - 1) / nTileSizeX;
	h = (h + nTileSizeY - 1) / nTileSizeY;

	if( mapX < x )
		return false;
	if( mapY < y )
		return false;
	if( mapX >= x + w )
		return false;
	if( mapY >= y + w )
		return false;

	return true;
}

////////////////////////////////////////////////////////////////
// ޥåפκ
////////////////////////////////////////////////////////////////

void PcgDun::redraw()
{
	draw( 0, 0, MAP_MAX_X, MAP_MAX_Y );
}

////////////////////////////////////////////////////////////////
// ޥåפ
// long mapX : X ɸ
// long mapY : Y ɸ
// long mapW : 
// long mapH : ⤵
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool PcgDun::draw( long mapX, long mapY, long mapW, long mapH )
{
	if( chk_nest_flg_dun() )
		return false;

	for( long dy = 0; dy < mapH; dy++ ){
		for( long dx = 0; dx < mapW; dx++ ){
			if( !drawTile( mapX + dx, mapY + dy, true ) ){
				return false;
			}
		}
	}

	return true;
}

////////////////////////////////////////////////////////////////
// ե졼ࡦХåե饦ɥؤ
// long mapX : X ɸ
// long mapY : Y ɸ
// long mapW : 
// long mapH : ⤵
////////////////////////////////////////////////////////////////

void PcgDun::flush( long mapX, long mapY, long mapW, long mapH )
{
	if( chk_nest_flg_dun() )
		return;

	long x = mapX * nTileSizeX;
	long y = mapY * nTileSizeY;
	long w = (mapW + 1) * nTileSizeX;
	long h = (mapH + 1) * nTileSizeY;

	long minX = (long)MapScrollX->getProperty( WSNvalue );
	long minY = (long)MapScrollY->getProperty( WSNvalue );
	long maxX = minX + (long)MapForm->getProperty( WSNwidth );
	long maxY = minY + (long)MapForm->getProperty( WSNheight );

	if( x < minX )
		x = minX;
	if( y < minY )
		y = minY;
	if( x > maxX )
		x = maxX;
	if( y > maxY )
		y = maxY;

	if( w > maxX - minX )
		w = maxX - minX;
	if( h > maxY - minY )
		h = maxY - minY;
	if( w <= 0 )
		return;
	if( h <= 0 )
		return;

	if( !getBG()->getReady() )
		return;
	if( !MapForm->getdev()->getReady() )
		return;

	getBG()->copyToWindow( MapForm->getdev(),
			x, y, w, h,
			x - minX, y - minY );
}

////////////////////////////////////////////////////////////////
// ե饰Υꥻå
////////////////////////////////////////////////////////////////

void PcgDun::resetUpdateFlg()
{
	for( long y = 0; y < MAP_MAX_Y; y++ )
		for( long x = 0; x < MAP_MAX_X; x++ )
			setUpdateFlg( x, y, true );
}

////////////////////////////////////////////////////////////////
// ե饰
// long mapX : X ɸ
// long mapY : Y ɸ
// bool flg : 褹ɬפ뤫
////////////////////////////////////////////////////////////////

void PcgDun::setUpdateFlg( long mapX, long mapY, bool flg )
{
	if( !clip_pos( mapX, mapY ) )
		return;

	bFlgUpdate[mapY][mapX] = flg;
}

////////////////////////////////////////////////////////////////
// ե饰μ
// long mapX : X ɸ
// long mapY : Y ɸ
// return : 褹ɬפ뤫
////////////////////////////////////////////////////////////////

bool PcgDun::getUpdateFlg( long mapX, long mapY )
{
	if( !clip_pos( mapX, mapY ) )
		return false;

	return bFlgUpdate[mapY][mapX];
}

////////////////////////////////////////////////////////////////
// 饯
// long mapX : X ɸ
// long mapY : Y ɸ
// bool flgFlush : ե졼ࡦХåե饦ɥ
//     褹뤫
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool PcgDun::drawTile( long mapX, long mapY, bool flgFlush )
{
	if( chk_nest_flg_dun() ){
		setUpdateFlg( mapX, mapY, true );

		return false;
	}

	if( clipWin( mapX, mapY ) ){
		if( !drawObj( mapX, mapY ) ){
			setUpdateFlg( mapX, mapY, true );
			return false;
		}

		if( flgFlush )
			flush( mapX, mapY, 1, 1 );

		setUpdateFlg( mapX, mapY, false );
	} else {
		setUpdateFlg( mapX, mapY, true );
	}

	return true;
}

////////////////////////////////////////////////////////////////
// ֥Ȥ
// long mapX : X ɸ
// long mapY : Y ɸ
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool PcgDun::drawObj( long mapX, long mapY )
{
	bool flgSuccess = false;

	if( !clip_pos( mapX, mapY ) )
		return true;

	if( !getBG()->getReady() )
		return false;
	if( !MapForm->getdev()->getReady() )
		return false;

	char mjr = FACE_MJR_NULL;
	char mnr = FACE_MNR_NULL;
	set_face_from_map_obj( TRUE, mapX, mapY, &mjr, &mnr );

	switch( mjr ){
	default:
	case FACE_MJR_NULL:
		flgSuccess = drawNull( mapX, mapY );
		break;
	case FACE_MJR_FLOOR:
		flgSuccess = drawFloor( mapX, mapY );
		break;
	case FACE_MJR_WALL:
		flgSuccess = drawWall( mapX, mapY );
		break;
	case FACE_MJR_DOOR_CLOSE:
		flgSuccess = drawDoorClose( mapX, mapY );
		break;
	case FACE_MJR_DOOR_OPEN:
		flgSuccess = drawDoorOpen( mapX, mapY );
		break;
	}
	if( !flgSuccess )
		return false;

	if( chkDrawCrsr( mapX, mapY ) )
		flgSuccess = drawCrsr();

	return true;
}

////////////////////////////////////////////////////////////////
// 
// long mapX : X ɸ
// long mapY : Y ɸ
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool PcgDun::drawNull( long mapX, long mapY )
{
	if( !clip_pos( mapX, mapY ) )
		return true;

	long n = aaMapNull[mapY][mapX];

	if( get_dun()->lev == 0 ){
		return aNullTown[n][0].drawFix( getBG(),
				mapX * nTileSizeX,
				mapY * nTileSizeY,
				1 * nTileSizeX,
				1 * nTileSizeY );
	} else {
		return aNullDun[n][0].drawFix( getBG(),
				mapX * nTileSizeX,
				mapY * nTileSizeY,
				1 * nTileSizeX,
				1 * nTileSizeY );
	}

	return false;
}

////////////////////////////////////////////////////////////////
// 
// long mapX : X ɸ
// long mapY : Y ɸ
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool PcgDun::drawFloor( long mapX, long mapY )
{
	if( !clip_pos( mapX, mapY ) )
		return true;

	long n = aaMapFloor[mapY][mapX];

	if( get_dun()->lev == 0 ){
		return aFloorTown[n][0].drawFix( getBG(),
				mapX * nTileSizeX,
				mapY * nTileSizeY,
				1 * nTileSizeX,
				1 * nTileSizeY );
	} else {
		return aFloorDun[n][0].drawFix( getBG(),
				mapX * nTileSizeX,
				mapY * nTileSizeY,
				1 * nTileSizeX,
				1 * nTileSizeY );
	}

	return false;
}

////////////////////////////////////////////////////////////////
// ɤ
// long mapX : X ɸ
// long mapY : Y ɸ
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool PcgDun::drawWall( long mapX, long mapY )
{
	if( !clip_pos( mapX, mapY ) )
		return true;

	long bit = 0;

	// Τդȹ礻

	if( chkDrawWall( mapX + 0, mapY - 1 ) )
		bit |= gBitIdxWallN;

	if( chkDrawWall( mapX + 0, mapY + 1 ) )
		bit |= gBitIdxWallS;

	if( chkDrawWall( mapX + 1, mapY + 0 ) )
		bit |= gBitIdxWallE;

	if( chkDrawWall( mapX - 1, mapY + 0 ) )
		bit |= gBitIdxWallW;

	long idxX = gIdxWall[bit].x;
	long idxY = gIdxWall[bit].y;

	// ƤդäƤ뤫?

	long bitAll = (gBitIdxWallN | gBitIdxWallS
			| gBitIdxWallE | gBitIdxWallW);
	if( (bit & bitAll) == bitAll ){
		// ФΤդȹ礻

		long bitDiagonal = 0;

		if( chkDrawWall( mapX - 1, mapY - 1 ) )
			bitDiagonal |= gBitIdxWallNW;

		if( chkDrawWall( mapX + 1, mapY - 1 ) )
			bitDiagonal |= gBitIdxWallNE;

		if( chkDrawWall( mapX - 1, mapY + 1 ) )
			bitDiagonal |= gBitIdxWallSW;

		if( chkDrawWall( mapX + 1, mapY + 1 ) )
			bitDiagonal |= gBitIdxWallSE;

		idxX = gIdxWallDiagonal[bitDiagonal].x;
		idxY = gIdxWallDiagonal[bitDiagonal].y;
	}

	long n = aaMapWall[mapY][mapX];

	if( get_dun()->lev == 0 ){
		return aWallTown[n][0].drawIdx( getBG(),
				mapX * nTileSizeX,
				mapY * nTileSizeY,
				1 * nTileSizeX,
				1 * nTileSizeY,
				idxX,
				idxY,
				nTileSizeX,
				nTileSizeY );
	} else {
		return aWallDun[n][0].drawIdx( getBG(),
				mapX * nTileSizeX,
				mapY * nTileSizeY,
				1 * nTileSizeX,
				1 * nTileSizeY,
				idxX,
				idxY,
				nTileSizeX,
				nTileSizeY );
	}

	return false;
}

////////////////////////////////////////////////////////////////
// Ĥɥ
// long mapX : X ɸ
// long mapY : Y ɸ
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool PcgDun::drawDoorClose( long mapX, long mapY )
{
	if( !clip_pos( mapX, mapY ) )
		return true;

	long idxX = +1;
	long idxY = +1;
	char mjr = FACE_MJR_NULL;
	char mnr = FACE_MNR_NULL;

	set_face_from_map_obj( FALSE, mapX - 1, mapY, &mjr, &mnr );
	if( mjr != FACE_MJR_DOOR_CLOSE )
		idxX += -1;
	set_face_from_map_obj( FALSE, mapX + 1, mapY, &mjr, &mnr );
	if( mjr != FACE_MJR_DOOR_CLOSE )
		idxX += +1;

	set_face_from_map_obj( FALSE, mapX, mapY - 1, &mjr, &mnr );
	if( mjr != FACE_MJR_DOOR_CLOSE )
		idxY += -1;
	set_face_from_map_obj( FALSE, mapX, mapY + 1, &mjr, &mnr );
	if( mjr != FACE_MJR_DOOR_CLOSE )
		idxY += +1;

	long n = aaMapDoorClose[mapY][mapX];

	if( get_dun()->lev == 0 ){
		return aDoorCloseTown[n][0].drawIdx( getBG(),
				mapX * nTileSizeX,
				mapY * nTileSizeY,
				1 * nTileSizeX,
				1 * nTileSizeY,
				idxX, idxY,
				nTileSizeX, nTileSizeY );
	} else {
		return aDoorCloseDun[n][0].drawIdx( getBG(),
				mapX * nTileSizeX,
				mapY * nTileSizeY,
				1 * nTileSizeX,
				1 * nTileSizeY,
				idxX, idxY,
				nTileSizeX, nTileSizeY );
	}

	return false;
}

////////////////////////////////////////////////////////////////
// ɥ
// long mapX : X ɸ
// long mapY : Y ɸ
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool PcgDun::drawDoorOpen( long mapX, long mapY )
{
	if( !clip_pos( mapX, mapY ) )
		return true;

	long idxX = +1;
	long idxY = +1;
	char mjr = FACE_MJR_NULL;
	char mnr = FACE_MNR_NULL;

	set_face_from_map_obj( FALSE, mapX - 1, mapY, &mjr, &mnr );
	if( mjr != FACE_MJR_DOOR_OPEN )
		idxX += -1;
	set_face_from_map_obj( FALSE, mapX + 1, mapY, &mjr, &mnr );
	if( mjr != FACE_MJR_DOOR_OPEN )
		idxX += +1;

	set_face_from_map_obj( FALSE, mapX, mapY - 1, &mjr, &mnr );
	if( mjr != FACE_MJR_DOOR_OPEN )
		idxY += -1;
	set_face_from_map_obj( FALSE, mapX, mapY + 1, &mjr, &mnr );
	if( mjr != FACE_MJR_DOOR_OPEN )
		idxY += +1;

	long n = aaMapDoorOpen[mapY][mapX];

	if( get_dun()->lev == 0 ){
		return aDoorOpenTown[n][0].drawIdx( getBG(),
				mapX * nTileSizeX,
				mapY * nTileSizeY,
				1 * nTileSizeX,
				1 * nTileSizeY,
				idxX, idxY,
				nTileSizeX, nTileSizeY );
	} else {
		return aDoorOpenDun[n][0].drawIdx( getBG(),
				mapX * nTileSizeX,
				mapY * nTileSizeY,
				1 * nTileSizeX,
				1 * nTileSizeY,
				idxX, idxY,
				nTileSizeX, nTileSizeY );
	}

	return false;
}

////////////////////////////////////////////////////////////////
// 
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool PcgDun::drawCrsr()
{
	pos_t *crsr = get_crsr();
	if( crsr == NULL )
		return true;
	if( !clip_pos( crsr->x, crsr->y ) )
		return true;

	long w = aCrsr[0][0].getWidth();
	long h = aCrsr[0][0].getHeight();
	long x = (crsr->x * nTileSizeX) + (nTileSizeX / 2) - (w / 2);
	long y = (crsr->y * nTileSizeY) + (nTileSizeY / 2) - (h / 2);

	return aCrsr[0][0].draw( getBG(), x, y, w, h );
//@@@	return aCrsr[0][0].draw( (WSDmwindowDev *)MapForm->getdev(),
//			x, y, w, h );
}

////////////////////////////////////////////////////////////////
// κɸɤĴ٤
// long mapX : X ɸ
// long mapY : Y ɸ
// return : ɤ
////////////////////////////////////////////////////////////////

bool PcgDun::chkDrawWall( long mapX, long mapY )
{
	if( !clip_pos( mapX, mapY ) )
		return true;

	char mjr = FACE_MJR_NULL;
	set_face_from_map_obj( FALSE, mapX, mapY, &mjr, NULL );

	switch( mjr ){
	case FACE_MJR_WALL:
	case FACE_MJR_DOOR_OPEN:
	case FACE_MJR_DOOR_CLOSE:
		return true;
	}

	return false;
}

////////////////////////////////////////////////////////////////
// κɸ˥뤬뤫Ĵ٤
// long mapX : X ɸ
// long mapY : Y ɸ
// return : 뤬뤫
////////////////////////////////////////////////////////////////

bool PcgDun::chkDrawCrsr( long mapX, long mapY )
{
	if( !clip_pos( mapX, mapY ) )
		return false;

	pos_t *crsr = get_crsr();
	if( crsr == NULL )
		return false;
	if( !clip_pos( crsr->x, crsr->y ) )
		return false;

	long x = mapX * nTileSizeX;
	long y = mapY * nTileSizeY;
	long w = aCrsr[0][0].getWidth();
	long h = aCrsr[0][0].getHeight();

	long bx = (crsr->x * nTileSizeX) - (w / 2);
	long by = (crsr->y * nTileSizeY) - (h / 2);
	long ex = bx + w;
	long ey = by + h;

	if( x < bx )
		return false;
	if( y < by )
		return false;
	if( x > ex )
		return false;
	if( y > ey )
		return false;

	return true;
}
