/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2006 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: PcgDun.h,v 1.15 2006/01/12 08:51:40 bowkenken Exp $
***************************************************************/

#ifndef PCG_DUN_H
#define PCG_DUN_H	1

////////////////////////////////////////////////////////////////
// 󥸥
////////////////////////////////////////////////////////////////

#include "misc.h"
#include "mnstr-kind.h"
#include "item.h"
#include "trap.h"
#include "mnstr.h"

#include "Pcg.h"

// ѥΥХꥨμ
typedef char PcgMap;

// ѥΥơ֥
struct PcgTab {
	// 󥹥ξμ
	mnstr_kind_t	nMnstrKind;
	// ѥλȤ
	ratio_t nRatio;
	// ѥΥեΤǥ쥯ȥ
	WSCstring sDir;
};

class PcgDun {
public:
	// ѥδॵ
	long nTileSizeX, nTileSizeY;

private:
	// Ʊǥ쥯ȥˤѥΥեκ
	static const long PCG_LS_MAX_N = 4;

	// ΥѥΥХꥨκ
	static const long PCG_NULL_MAX_N = 4;
	// ΥѥΥХꥨκ
	static const long PCG_FLOOR_MAX_N = 8;
	// ɤΥѥΥХꥨκ
	static const long PCG_WALL_MAX_N = 8;
	// ɥΥѥΥХꥨκ
	static const long PCG_DOOR_MAX_N = 4;
	// ΥѥΥХꥨκ
	static const long PCG_CRSR_MAX_N = 1;

	// ƥΥѥΥХꥨκ
	static const long PCG_ITEM_MAX_N = ITEM_KIND_MAX_N;
	// 櫤ΥѥΥХꥨκ
	static const long PCG_TRAP_MAX_N = TRAP_KIND_MAX_N;

	// 󥹥ΥѥΥХꥨκ
	static const long PCG_MNSTR_MAX_N = MNSTR_KIND_MAX_N;

	// Υѥ
	Pcg aNullTown[PCG_NULL_MAX_N][PCG_LS_MAX_N];
	Pcg aNullDun[PCG_NULL_MAX_N][PCG_LS_MAX_N];
	// Υѥ
	Pcg aFloorTown[PCG_FLOOR_MAX_N][PCG_LS_MAX_N];
	Pcg aFloorDun[PCG_FLOOR_MAX_N][PCG_LS_MAX_N];
	// ɤΥѥ
	Pcg aWallTown[PCG_WALL_MAX_N][PCG_LS_MAX_N];
	Pcg aWallDun[PCG_WALL_MAX_N][PCG_LS_MAX_N];
	// ɥΥѥ
	Pcg aDoorCloseTown[PCG_DOOR_MAX_N][PCG_LS_MAX_N];
	Pcg aDoorCloseDun[PCG_DOOR_MAX_N][PCG_LS_MAX_N];
	Pcg aDoorOpenTown[PCG_DOOR_MAX_N][PCG_LS_MAX_N];
	Pcg aDoorOpenDun[PCG_DOOR_MAX_N][PCG_LS_MAX_N];
	// Υѥ
	Pcg aCrsr[PCG_CRSR_MAX_N][PCG_LS_MAX_N];
	// ƥΥѥ
	Pcg aItem[PCG_ITEM_MAX_N][PCG_LS_MAX_N];
	// 櫤Υѥ
	Pcg aTrap[PCG_TRAP_MAX_N][PCG_LS_MAX_N];
	// 󥹥Υѥ
	Pcg aMnstr[PCG_MNSTR_MAX_N][PCG_LS_MAX_N];

	// ѥΥե
	long nNullTownN[PCG_NULL_MAX_N];
	long nNullDunN[PCG_NULL_MAX_N];
	long nFloorTownN[PCG_FLOOR_MAX_N];
	long nFloorDunN[PCG_FLOOR_MAX_N];
	long nWallTownN[PCG_WALL_MAX_N];
	long nWallDunN[PCG_WALL_MAX_N];
	long nDoorCloseTownN[PCG_DOOR_MAX_N];
	long nDoorCloseDunN[PCG_DOOR_MAX_N];
	long nDoorOpenTownN[PCG_DOOR_MAX_N];
	long nDoorOpenDunN[PCG_DOOR_MAX_N];
	long nCrsrN[PCG_CRSR_MAX_N];
	long nItemN[PCG_ITEM_MAX_N];
	long nTrapN[PCG_TRAP_MAX_N];
	long nMnstrN[PCG_MNSTR_MAX_N];

	// ѥΥХꥨμΥޥå
	PcgMap aaMapNull[MAP_MAX_Y][MAP_MAX_X];
	PcgMap aaMapFloor[MAP_MAX_Y][MAP_MAX_X];
	PcgMap aaMapWall[MAP_MAX_Y][MAP_MAX_X];
	PcgMap aaMapDoorClose[MAP_MAX_Y][MAP_MAX_X];
	PcgMap aaMapDoorOpen[MAP_MAX_Y][MAP_MAX_X];

	// 褹ɬפ륭饯Υޥå
	bool bFlgUpdate[MAP_MAX_Y][MAP_MAX_X];

	// ե졼ࡦХåե
	WSDmwindowDev *pBG;

public:
	PcgDun()
	{
		resetUpdateFlg();

		pBG = NULL;

		nTileSizeX = 32;
		nTileSizeY = 32;
	}
	~PcgDun()
	{
	}

	void PcgDun::init();
	void PcgDun::reset();

	void PcgDun::scrollTile( long mapX, long mapY );
	void PcgDun::scrollMap( long x, long y );
	bool PcgDun::chkScroll( long x, long y, long w, long h );
	bool PcgDun::drawScroll( long x, long y, long w, long h );

	bool PcgDun::clipWin( long mapX, long mapY );
	void PcgDun::redraw();
	bool PcgDun::draw( long mapX, long mapY, long mapW, long mapH );
	void PcgDun::flush( long mapX, long mapY, long mapW, long mapH );

	void PcgDun::resetUpdateFlg();
	void PcgDun::setUpdateFlg( long mapX, long mapY, bool flg );
	bool PcgDun::getUpdateFlg( long mapX, long mapY );

private:
	void PcgDun::resetMap( PcgTab tab[],
			PcgMap map[MAP_MAX_Y][MAP_MAX_X] );

	WSDmwindowDev *PcgDun::getBG();

	bool PcgDun::drawTile( long mapX, long mapY, bool flgFlush );
	bool PcgDun::drawObj( long mapX, long mapY );
	bool PcgDun::drawNull( long mapX, long mapY );
	bool PcgDun::drawFloor( long mapX, long mapY );
	bool PcgDun::drawWall( long mapX, long mapY );
	bool PcgDun::drawDoorClose( long mapX, long mapY );
	bool PcgDun::drawDoorOpen( long mapX, long mapY );
	bool PcgDun::drawCrsr();

	bool PcgDun::chkDrawWall( long mapX, long mapY );
	bool PcgDun::chkDrawCrsr( long mapX, long mapY );
};

#endif /* PCG_DUN_H */
