/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2007 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: MouseMap.cpp,v 1.13 2007/02/20 01:55:22 bowkenken Exp $
***************************************************************/

#ifdef D_WS

# include <WScom.h>
# include <WSCfunctionList.h>
# include <WSCbase.h>

# include <WSCvscrBar.h>
# include <WSCwindow.h>

#endif // D_WS

#include "gmain.h"
#include "menu.h"
#include "draw.h"
#include "gmain-prot.h"
#include "mmenu-prot.h"
#include "imenu-prot.h"
#include "draw-prot.h"

#include "MouseMap.h"
#include "Key.h"
#include "GlobalVar.h"

#ifdef D_WS
extern WSCwindow* MenuWin;
extern WSCvscrBar *MapScrollX;
extern WSCvscrBar *MapScrollY;
#endif // D_WS

////////////////////////////////////////////////////////////////
// ޥˤݥȤΥ롦Хå
// MouseMotion::MouseButtonN n : ޥܥֹ
// long nBgnX : ɥå X ɸ
// long nBgnY : ɥå Y ɸ
// long nCurX : ߤ X ɸ
// long nCurY : ߤ Y ɸ
////////////////////////////////////////////////////////////////

void initMouseMotionFunc()
{
	// ݥ

	gMouseMotion.setFuncPoint(
			funcMotionPoint );

	// ɥå

	gMouseMotion.setFunc(
			MouseMotion::nMouseButtonL,
			MouseMotion::nMotionDrag,
			funcMotionDragL );

	// ܥκɥåΥ롦Хå

	gMouseMotion.setFunc(
			MouseMotion::nMouseButtonR,
			MouseMotion::nMotionLeft,
			funcMotionLeftR );

	// ܥαɥåΥ롦Хå

	gMouseMotion.setFunc(
			MouseMotion::nMouseButtonR,
			MouseMotion::nMotionRight,
			funcMotionRightR );

	// ܥξɥåΥ롦Хå

	gMouseMotion.setFunc(
			MouseMotion::nMouseButtonR,
			MouseMotion::nMotionUp,
			funcMotionUpR );

	// ܥβɥåΥ롦Хå

	gMouseMotion.setFunc(
			MouseMotion::nMouseButtonR,
			MouseMotion::nMotionDown,
			funcMotionDownR );

	// å

	gMouseMotion.setFuncClick(
			MouseMotion::nMouseButtonL,
			funcMotionClick );

	// 楯å

	gMouseMotion.setFuncClick(
			MouseMotion::nMouseButtonM,
			funcMotionClick );

	// å

	long btnMin = (long)MouseMotion::nMouseButton3;
	long btnMax = (long)MouseMotion::nMouseButtonMaxN;
	for( long i = btnMin; i < btnMax; i++ ){
		gMouseMotion.setFuncClick(
				(MouseMotion::MouseButtonN)i,
				funcMotionClick );
	}

	// å

	gMouseMotion.setFuncClick(
			MouseMotion::nMouseButtonR,
			funcMotionClick );

	// ץ쥹 + å

	gMouseMotion.setFuncClickLR(
			MouseMotion::nMouseButtonL,
			funcMotionClickLR );

	// ץ쥹 + å

	gMouseMotion.setFuncClickLR(
			MouseMotion::nMouseButtonR,
			funcMotionClickLR );
}

////////////////////////////////////////////////////////////////
// ޥˤݥȤΥ롦Хå
// MouseMotion::MouseButtonN n : ޥܥֹ
// long nBgnX : ɥå X ɸ
// long nBgnY : ɥå Y ɸ
// long nCurX : ߤ X ɸ
// long nCurY : ߤ Y ɸ
////////////////////////////////////////////////////////////////

void funcMotionPoint(
	MouseMotion::MouseButtonN n,
	long nBgnX, long nBgnY,
	long nCurX, long nCurY
)
{
	if( get_flg_draw_menu() )
		return;

	long x = 0;
	long y = 0;

#ifdef D_WS
	if( (WSCbool)(MenuWin->getProperty( WSNvis )) )
		return;

	x = (long)MapScrollX->getProperty( WSNvalue );
	y = (long)MapScrollY->getProperty( WSNvalue );
#endif // D_WS

#ifdef D_GTK
//@@@	if( (WSCbool)(MenuWin->getProperty( WSNvis )) )
//@@@		return;

	GtkAdjustment *hAdj = GTK_ADJUSTMENT( gMapHScrollBarAdjustment );
	GtkAdjustment *vAdj = GTK_ADJUSTMENT( gMapVScrollBarAdjustment );

	x = (long)hAdj->value;
	y = (long)vAdj->value;
#endif // D_GTK


	long mapX = (x + nCurX) / gPcgDun.getTileSizeX();
	long mapY = (y + nCurY) / gPcgDun.getTileSizeY();

	pos_t *crsr = get_crsr();
	if( (crsr->x != mapX) || (crsr->y != mapY) ){
		crsr->x = mapX;
		crsr->y = mapY;
		gKey.setString( "|", true );
	}
}

////////////////////////////////////////////////////////////////
// ɥåΥ롦Хå
// MouseMotion::MouseButtonN n : ޥܥֹ
// long nBgnX : ɥå X ɸ
// long nBgnY : ɥå Y ɸ
// long nCurX : ߤ X ɸ
// long nCurY : ߤ Y ɸ
////////////////////////////////////////////////////////////////

void funcMotionDragL(
	MouseMotion::MouseButtonN n,
	long nBgnX, long nBgnY,
	long nCurX, long nCurY
)
{
	long w = 1;
	long h = 1;
	long maxX = 1;
	long maxY = 1;

#ifdef D_WS
	if( (WSCbool)(MenuWin->getProperty( WSNvis )) )
		return;

	maxX = (long)MapScrollX->getProperty( WSNmaximum );
	maxY = (long)MapScrollY->getProperty( WSNmaximum );
#endif // D_WS

#ifdef D_GTK
	GtkAdjustment *hAdj = GTK_ADJUSTMENT( gMapHScrollBarAdjustment );
	GtkAdjustment *vAdj = GTK_ADJUSTMENT( gMapVScrollBarAdjustment );

	w = (long)hAdj->page_size;
	h = (long)vAdj->page_size;
	maxX = (long)(hAdj->upper - w);
	maxY = (long)(vAdj->upper - h);
#endif // D_GTK

	long x = gMapDragBgnX - (nCurX - nBgnX);
	long y = gMapDragBgnY - (nCurY - nBgnY);

	if( x < 0 )
		x = 0;
	if( y < 0 )
		y = 0;
	if( x > maxX)
		x = maxX;
	if( y > maxY)
		y = maxY;

	x = (x / gPcgDun.getTileSizeX()) * gPcgDun.getTileSizeX();
	y = (y / gPcgDun.getTileSizeY()) * gPcgDun.getTileSizeY();

	if( gPcgDun.chkScroll( x, y, w, h ) )
		gPcgDun.scrollMap( x, y );
}

////////////////////////////////////////////////////////////////
// ܥκɥåΥ롦Хå
// MouseMotion::MouseButtonN n : ޥܥֹ
// long nBgnX : ɥå X ɸ
// long nBgnY : ɥå Y ɸ
// long nCurX : ߤ X ɸ
// long nCurY : ߤ Y ɸ
////////////////////////////////////////////////////////////////

void funcMotionLeftR(
	MouseMotion::MouseButtonN n,
	long nBgnX, long nBgnY,
	long nCurX, long nCurY
)
{
	gKey.setString( "/" );
}

////////////////////////////////////////////////////////////////
// ܥαɥåΥ롦Хå
// MouseMotion::MouseButtonN n : ޥܥֹ
// long nBgnX : ɥå X ɸ
// long nBgnY : ɥå Y ɸ
// long nCurX : ߤ X ɸ
// long nCurY : ߤ Y ɸ
////////////////////////////////////////////////////////////////

void funcMotionRightR(
	MouseMotion::MouseButtonN n,
	long nBgnX, long nBgnY,
	long nCurX, long nCurY
)
{
	gKey.setString( "*" );
}

////////////////////////////////////////////////////////////////
// ܥξɥåΥ롦Хå
// MouseMotion::MouseButtonN n : ޥܥֹ
// long nBgnX : ɥå X ɸ
// long nBgnY : ɥå Y ɸ
// long nCurX : ߤ X ɸ
// long nCurY : ߤ Y ɸ
////////////////////////////////////////////////////////////////

void funcMotionUpR(
	MouseMotion::MouseButtonN n,
	long nBgnX, long nBgnY,
	long nCurX, long nCurY
)
{
	gKey.setString( "-" );
}

////////////////////////////////////////////////////////////////
// ܥβɥåΥ롦Хå
// MouseMotion::MouseButtonN n : ޥܥֹ
// long nBgnX : ɥå X ɸ
// long nBgnY : ɥå Y ɸ
// long nCurX : ߤ X ɸ
// long nCurY : ߤ Y ɸ
////////////////////////////////////////////////////////////////

void funcMotionDownR(
	MouseMotion::MouseButtonN n,
	long nBgnX, long nBgnY,
	long nCurX, long nCurY
)
{
	gKey.setString( "+" );
}

////////////////////////////////////////////////////////////////
// 汦åΥ롦Хå
// MouseMotion::MouseButtonN n : ޥܥֹ
// long nBgnX : ɥå X ɸ
// long nBgnY : ɥå Y ɸ
// long nCurX : ߤ X ɸ
// long nCurY : ߤ Y ɸ
////////////////////////////////////////////////////////////////

void funcMotionClick(
	MouseMotion::MouseButtonN n,
	long nBgnX, long nBgnY,
	long nCurX, long nCurY
)
{
	if( n < MouseMotion::nMouseButton0 )
		return;
	if( n >= MouseMotion::nMouseButtonMaxN )
		return;

	if( n == MouseMotion::nMouseButtonL ){
		gKey.setChar( 'M' - '@' );
	} else if( n == MouseMotion::nMouseButtonM ){
		gKey.setString( "+" );
	} else if( n == MouseMotion::nMouseButtonR ){
		gKey.setString( "." );
	} else {
		char str[15 + 1];
		sprintf( str, "&%2ld", (long)n );
		gKey.setString( str );
	}
}

////////////////////////////////////////////////////////////////
// ƱåΥ롦Хå
// MouseMotion::MouseButtonN n : ˥ץ쥹ޥܥֹ
// long nBgnX : ɥå X ɸ
// long nBgnY : ɥå Y ɸ
// long nCurX : ߤ X ɸ
// long nCurY : ߤ Y ɸ
////////////////////////////////////////////////////////////////

void funcMotionClickLR(
	MouseMotion::MouseButtonN n,
	long nBgnX, long nBgnY,
	long nCurX, long nCurY
)
{
	if( n == MouseMotion::nMouseButtonL ){
		gKey.setStringKeyTab( "&11" );
	}

	if( n == MouseMotion::nMouseButtonR ){
		gKey.setStringKeyTab( "&12" );
	}
}
