/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2007 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: Pcg.cpp,v 1.10 2007/02/25 02:13:11 bowkenken Exp $
***************************************************************/

#include <time.h>

#include "gmain.h"
#include "misc.h"
#include "draw.h"
#include "town.h"
#include "amenu.h"
#include "spell.h"
#include "gfile.h"
#include "gmain-prot.h"
#include "misc-prot.h"
#include "draw-prot.h"
#include "gfile-prot.h"

#include "Pcg.h"
#include "GlobalVar.h"

////////////////////////////////////////////////////////////////
// 
// WSCstring path : եåեХѥ
////////////////////////////////////////////////////////////////

void Pcg::init( WSCstring path )
{
	load( path );
}

////////////////////////////////////////////////////////////////
// եåեɤ߹
// WSCstring path : եåեХѥ
////////////////////////////////////////////////////////////////

void Pcg::load( WSCstring path )
{
	dis();

	WSCstring dir = path;
	long pos = dir.getWordCharPos( dir.getWords( "/" ), "/" ) - 1;
	if( pos > 0 ){
		dir.cutString( pos );
		make_dir( dir );
	}

#ifdef D_WS
	pImage = WSGIappImageSet()->getImage( path );
#endif // D_WS

#ifdef D_GTK
	GdkPixbuf *buf = gdk_pixbuf_new_from_file( path, NULL );
	long w = gdk_pixbuf_get_width( buf );
	long h = gdk_pixbuf_get_height( buf );
	w = w * gPcgDun.nTileSizeRate / _100_PERCENT;
	h = h * gPcgDun.nTileSizeRate / _100_PERCENT;
	buf = gdk_pixbuf_scale_simple( buf, w, h, GDK_INTERP_BILINEAR );

	pImage = new WSDimage( buf );
#endif // D_GTK
}

////////////////////////////////////////////////////////////////
// եåǡͭ
////////////////////////////////////////////////////////////////

void Pcg::ena()
{
}

////////////////////////////////////////////////////////////////
// եåǡ̵
////////////////////////////////////////////////////////////////

void Pcg::dis()
{
return;//@@@
	if( pImage != NULL ){
		pImage->destroyImage();
	}
}

////////////////////////////////////////////////////////////////
// եåѥ֤
// return : 
////////////////////////////////////////////////////////////////

long Pcg::getWidth()
{
	if( pImage == NULL )
		return 0;

#ifdef D_WS
	return pImage->getImageWidth();
#endif // D_WS

#ifdef D_GTK
	return pImage->getImageWidth();
#endif // D_GTK
}

////////////////////////////////////////////////////////////////
// եåѥι⤵֤
// return : ⤵
////////////////////////////////////////////////////////////////

long Pcg::getHeight()
{
	if( pImage == NULL )
		return 0;

#ifdef D_WS
	return pImage->getImageHeight();
#endif // D_WS

#ifdef D_GTK
	return pImage->getImageHeight();
#endif // D_GTK
}

////////////////////////////////////////////////////////////////
// ǽԤ
// WSDmwindowDev *mDev : ե졼ࡦХåեʥɥ
// return : false ʤڤ
////////////////////////////////////////////////////////////////

bool Pcg::waitReady( WSDmwindowDev *mDev )
{
return true;//@@@
	if( mDev == NULL )
		return false;

	double frame = (double)*get_clk_tck();
	frame = frame * (double)nWaitReadyMSec / 1000.0;
	clock_t end_clock = clock() + (clock_t)frame;

	while( clock() < end_clock ){
		if( mDev->getReady() )
			return true;
	}

//@@@	mDev->endDraw();

	return false;
}

////////////////////////////////////////////////////////////////
// եåѥ
// WSDmwindowDev *mDev : ե졼ࡦХåեʥɥ
// long x : X ɸ
// long y : Y ɸ
// long w : W 
// long h : H ⤵
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool Pcg::draw( WSDmwindowDev *mDev,
		long x, long y, long w, long h )
{
	ena();

	if( mDev == NULL )
		return false;
	if( pImage == NULL )
		return false;
	if( w < 1 )
		return true;
	if( h < 1 )
		return true;

#ifdef D_WS
	mDev->beginDraw( x, y, w, h );
	mDev->drawImage( x, y, w, h, pImage, WS_LEFT_TOP );
	mDev->endDraw();
#endif // D_WS

#ifdef D_GTK
	GdkGC *gc = gMapDrawingArea->style->fg_gc[GTK_STATE_NORMAL];

	gdk_pixbuf_render_to_drawable(
			pImage->getPixbuf(),
			mDev->getPixMap(),
			gc,
			0, 0,
			x, y,
			w, h,
			GDK_RGB_DITHER_NONE,
			0, 0 );
#endif // D_GTK

	return true;
}

////////////////////////////////////////////////////////////////
// եåѥ
// ʥѥкɸ
// WSDmwindowDev *mDev : ե졼ࡦХåեʥɥ
// long x : X ɸ
// long y : Y ɸ
// long w : W 
// long h : H ⤵
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool Pcg::drawFix( WSDmwindowDev *mDev,
		long x, long y, long w, long h )
{
	ena();

	if( mDev == NULL )
		return false;
	if( pImage == NULL )
		return false;
	if( w < 1 )
		return true;
	if( h < 1 )
		return true;

	long iw = pImage->getImageWidth();
	long ih = pImage->getImageHeight();
	if( iw < 1 )
		return false;
	if( ih < 1 )
		return false;
	long bgnX = (x / iw) * iw;
	long bgnY = (y / ih) * ih;

	long drawH = ih - (y - bgnY);
	for( long yy = bgnY; yy < y + h; yy += ih ){
		if( drawH > (y + h - yy) )
			drawH = (y + h - yy);

		long drawW = iw - (x - bgnX);
		for( long xx = bgnX; xx < x + w; xx += iw ){
			if( drawW > (x + w - xx) )
				drawW = (x + w - xx);

			if( !waitReady( mDev ) )
				return false;

#ifdef D_WS
			mDev->beginDraw( xx, yy, drawW, drawH );
			mDev->drawImage( xx, yy, drawW, drawH,
					pImage, WS_LEFT_TOP );
			mDev->endDraw();
#endif // D_WS

#ifdef D_GTK
			GdkGC	*gc;
			gc = gMapDrawingArea->style->fg_gc
					[GTK_STATE_NORMAL];

			gdk_pixbuf_render_to_drawable(
					pImage->getPixbuf(),
					mDev->getPixMap(),
					gc,
					0, 0,
					xx, yy,
					drawW, drawH,
					GDK_RGB_DITHER_NONE,
					0, 0 );
#endif // D_GTK

			drawW = iw;
		}

		drawH = ih;
	}

	return true;
}

////////////////////////////////////////////////////////////////
// եåѥ
// ʥѥΥǥåդ
// WSDmwindowDev *mDev : ե졼ࡦХåեʥɥ
// long x : X ɸ
// long y : Y ɸ
// long w : W 
// long h : H ⤵
// long idxX : X ΥѥΥǥå
// long idxY : Y ΥѥΥǥå
// long sizeX : X ΥѥΥ
// long sizeY : Y ΥѥΥ
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool Pcg::drawIdx( WSDmwindowDev *mDev,
		long x, long y, long w, long h,
		long idxX, long idxY,
		long sizeX, long sizeY )
{
	ena();

	if( mDev == NULL )
		return false;
	if( pImage == NULL )
		return false;
	if( w < 1 )
		return true;
	if( h < 1 )
		return true;

	long iw = pImage->getImageWidth();
	long ih = pImage->getImageHeight();
	if( iw < 1 )
		return false;
	if( ih < 1 )
		return false;

#ifdef D_WS
	mDev->beginDraw( x, y, sizeX, sizeY );
	mDev->drawImage(
			x - (idxX * sizeX),
			y - (idxY * sizeY),
			iw, ih,
			pImage, WS_LEFT_TOP );
	mDev->endDraw();
#endif // D_WS

#ifdef D_GTK
	GdkGC	*gc = gMapDrawingArea->style->fg_gc[GTK_STATE_NORMAL];

	gdk_pixbuf_render_to_drawable(
			pImage->getPixbuf(),
			mDev->getPixMap(),
			gc,
			idxX * sizeX,
			idxY * sizeY,
			x, y,
			sizeX, sizeY,
			GDK_RGB_DITHER_NONE,
			0, 0 );
#endif // D_GTK
//@@@
	return true;

#if	0
//@@@
	long iw = sizeX;
	long ih = sizeY;
	if( iw < 1 )
		return false;
	if( ih < 1 )
		return false;
	long bgnX = (x / iw) * iw;
	long bgnY = (y / ih) * ih;

#if	0
//@@@
	long bgnDrawX = max_l( x, 0 );
	long bgnDrawY = max_l( y, 0 );
	long bgnDrawW = w - (bgnDrawX - x);
	long bgnDrawH = h - (bgnDrawY - y);
	mDev->beginDraw( bgnDrawX, bgnDrawY, bgnDrawW, bgnDrawH );
#endif

	long drawH = ih - (y - bgnY);
	for( long yy = bgnY; yy < y + h; yy += ih ){
		long drawW = iw - (x - bgnX);

		if( drawH > (y + h - yy) )
			drawH = (y + h - yy);

		for( long xx = bgnX; xx < x + w; xx += iw ){
			if( drawW > (x + w - xx) )
				drawW = (x + w - xx);

			if( !waitReady( mDev ) )
				return false;

#ifdef	D_WIN
			mDev->beginDraw( xx, yy, sizeX, sizeY );
			mDev->drawImage(
					xx - (idxX * sizeX),
					yy - (idxY * sizeY),
					pImage->getImageWidth(),
					pImage->getImageHeight(),
					pImage, WS_LEFT_TOP );
			mDev->endDraw();
#else
			pMDev->copyToWindow( mDev,
					idxX * sizeX,
					idxY * sizeY,
					sizeX, sizeY,
					xx, yy );
#endif

			drawW = iw;
		}

		drawH = ih;
	}

#if	0
//@@@
	mDev->endDraw();
#endif

	return true;
#endif
}

////////////////////////////////////////////////////////////////
// 饯
// WSDmwindowDev *mDev : ե졼ࡦХåեʥɥ
// long x : X ɸ
// long y : Y ɸ
// long w : W 
// long h : H ⤵
// long offsetX : X եå
// long offsetY : Y եå
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool Pcg::drawOffset( WSDmwindowDev *mDev,
		long x, long y, long w, long h,
		long offsetX, long offsetY )
{
	ena();

	if( mDev == NULL )
		return false;
	if( pImage == NULL )
		return false;
	if( w < 1 )
		return true;
	if( h < 1 )
		return true;

#ifdef D_WS
	long xx = x - offsetX;
	long yy = y - offsetY;
	long ww = w + offsetX;
	long hh = h + offsetY;
	if( ww > pImage->getImageWidth() )
		ww = pImage->getImageWidth();
	if( hh > pImage->getImageHeight() )
		hh = pImage->getImageHeight();

	mDev->beginDraw( x, y, w, h );
	mDev->drawImage( xx, yy, ww, hh, pImage, WS_LEFT_TOP );
	mDev->endDraw();
#endif // D_WS

#ifdef D_GTK
	if( x < 0 )
		x = 0;
	if( y < 0 )
		y = 0;
	if( w > pImage->getImageWidth() )
		w = pImage->getImageWidth();
	if( h > pImage->getImageHeight() )
		h = pImage->getImageHeight();

	GdkGC	*gc = gMapDrawingArea->style->fg_gc[GTK_STATE_NORMAL];

	gdk_pixbuf_render_to_drawable(
			pImage->getPixbuf(),
			mDev->getPixMap(),
			gc,
			offsetX, offsetY,
			x, y,
			w, h,
			GDK_RGB_DITHER_NONE,
			0, 0 );
#endif // D_GTK

	return true;
}

