/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2007 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: PcgDun.cpp,v 1.20 2007/02/19 08:42:00 bowkenken Exp $
***************************************************************/

#include	"gmain.h"
#include	"misc.h"
#include	"turn.h"
#include	"dun.h"
#include	"town.h"
//#include	"item.h"
//#include	"spell.h"
#include	"chr.h"
#include	"party.h"
#include	"mnstr.h"
//#include	"pet.h"
//#include	"fight.h"
//#include	"fx.h"
//#include	"trap.h"
#include	"draw.h"
//#include	"curs.h"
#include	"menu.h"
#include	"amenu.h"
//#include	"request.h"
#include	"gfile.h"
//#include	"msg.h"
//#include	"ver.h"
#include	"gmain-prot.h"
#include	"misc-prot.h"
#include	"turn-prot.h"
#include	"dun-prot.h"
//#include	"town-prot.h"
//#include	"item-prot.h"
//#include	"spell-prot.h"
#include	"chr-prot.h"
#include	"party-prot.h"
#include	"mnstr-prot.h"
//#include	"pet-prot.h"
//#include	"fight-prot.h"
//#include	"fx-prot.h"
//#include	"trap-prot.h"
#include	"draw-prot.h"
//#include	"curs-prot.h"
//#include	"menu-prot.h"
#include	"mmenu-prot.h"
//#include	"imenu-prot.h"
//#include	"tmenu-prot.h"
//#include	"amenu-prot.h"
//#include	"request-prot.h"
#include	"gfile-prot.h"
//#include	"msg-prot.h"

#include "PcgDun.h"
#include "FileList.h"
#include "GlobalVar.h"

#ifdef D_WS
# include <WSCform.h>
# include <WSCvscrBar.h>
#endif // D_WS

#ifdef D_GTK
# include <gtk/gtk.h>
# include <gdk-pixbuf/gdk-pixbuf.h>
#endif // D_GTK

#ifdef D_WS
extern WSCform *MapForm;
extern WSCvscrBar *MapScrollX;
extern WSCvscrBar *MapScrollY;
#endif // D_WS

#include "PcgDunTab.h"

////////////////////////////////////////////////////////////////
// ѥ󡦥ǥåΥơ֥
////////////////////////////////////////////////////////////////

const long gBitIdxWallN = 1 << 0;
const long gBitIdxWallS = 1 << 1;
const long gBitIdxWallE = 1 << 2;
const long gBitIdxWallW = 1 << 3;

pos_t gIdxWall[2 * 2 * 2 * 2] = {
	{ +3, +3 }, //....
	{ +3, +2 }, //...N
	{ +3, +0 }, //..S.
	{ +3, +1 }, //..SN

	{ +0, +3 }, //.E.
	{ +0, +2 }, //.E.N
	{ +0, +0 }, //.ES.
	{ +0, +1 }, //.ESN

	{ +2, +3 }, //W...
	{ +2, +2 }, //W..N
	{ +2, +0 }, //W.S.
	{ +2, +1 }, //W.SN

	{ +1, +3 }, //WE..
	{ +1, +2 }, //WE.N
	{ +1, +0 }, //WES.
	{ +1, +1 }, //WESN
};

const long gBitIdxWallNE = 1 << 0;
const long gBitIdxWallNW = 1 << 1;
const long gBitIdxWallSE = 1 << 2;
const long gBitIdxWallSW = 1 << 3;

pos_t gIdxWallDiagonal[2 * 2 * 2 * 2] = {
	{ +1, +1 }, //.. .. .. ..
	{ +1, +1 }, //.. .. .. NE
	{ +1, +1 }, //.. .. NW ..
	{ +1, +1 }, //.. .. NW NE

	{ +1, +1 }, //.. SE .. ..
	{ +1, +1 }, //.. SE .. NE
	{ +1, +1 }, //.. SE NW ..
	{ +1, +4 }, //.. SE NW NE

	{ +1, +1 }, //SW .. .. ..
	{ +1, +1 }, //SW .. .. NE
	{ +1, +1 }, //SW .. NW ..
	{ +0, +4 }, //SW .. NW NE

	{ +1, +1 }, //SW SE .. ..
	{ +3, +4 }, //SW SE .. NE
	{ +2, +4 }, //SW SE NW ..
	{ +1, +1 }, //SW SE NW NE
};

////////////////////////////////////////////////////////////////
// 
////////////////////////////////////////////////////////////////

void PcgDun::init()
{
	nTileSizeRate = g_graph_scale_rate;

	FileList ls;
	WSCstring ext = STR_GRAPH_FILE_EXT;

	// ̤õ

	for( long i = 0; i < PCG_NULL_MAX_N; i++ ){
		nNullTownN[i] = 0;

		if( gPcgTabNullTown[i].nRatio <= -1 )
			break;

		ls.reset( gPcgTabNullTown[i].sDir, ext );
		long j = 0;
		for( j = 0; j < PCG_LS_MAX_N; j++ ){
			WSCstring path = ls.next();
			if( path.getChars() <= 0 )
				break;
			aNullTown[i][j].init( path );
		}
		nNullTownN[i] = j;
	}
	for( long i = 0; i < PCG_NULL_MAX_N; i++ ){
		nNullDunN[i] = 0;

		if( gPcgTabNullDun[i].nRatio <= -1 )
			break;

		ls.reset( gPcgTabNullDun[i].sDir, ext );
		long j = 0;
		for( j = 0; j < PCG_LS_MAX_N; j++ ){
			WSCstring path = ls.next();
			if( path.getChars() <= 0 )
				break;
			aNullDun[i][j].init( path );
		}
		nNullDunN[i] = j;
	}

	// 

	for( long i = 0; i < PCG_FLOOR_MAX_N; i++ ){
		nFloorTownN[i] = 0;

		if( gPcgTabFloorTown[i].nRatio <= -1 )
			break;

		ls.reset( gPcgTabFloorTown[i].sDir, ext );
		long j = 0;
		for( j = 0; j < PCG_LS_MAX_N; j++ ){
			WSCstring path = ls.next();
			if( path.getChars() <= 0 )
				break;
			aFloorTown[i][j].init( path );
		}
		nFloorTownN[i] = j;
	}
	for( long i = 0; i < PCG_FLOOR_MAX_N; i++ ){
		nFloorDunN[i] = 0;

		if( gPcgTabFloorDun[i].nRatio <= -1 )
			break;

		ls.reset( gPcgTabFloorDun[i].sDir, ext );
		long j = 0;
		for( j = 0; j < PCG_LS_MAX_N; j++ ){
			WSCstring path = ls.next();
			if( path.getChars() <= 0 )
				break;
			aFloorDun[i][j].init( path );
		}
		nFloorDunN[i] = j;
	}

	// 

	for( long i = 0; i < PCG_WALL_MAX_N; i++ ){
		nWallTownN[i] = 0;

		if( gPcgTabWallTown[i].nRatio <= -1 )
			break;

		ls.reset( gPcgTabWallTown[i].sDir, ext );
		long j = 0;
		for( j = 0; j < PCG_LS_MAX_N; j++ ){
			WSCstring path = ls.next();
			if( path.getChars() <= 0 )
				break;
			aWallTown[i][j].init( path );
		}
		nWallTownN[i] = j;
	}
	for( long i = 0; i < PCG_WALL_MAX_N; i++ ){
		nWallDunN[i] = 0;

		if( gPcgTabWallDun[i].nRatio <= -1 )
			break;

		ls.reset( gPcgTabWallDun[i].sDir, ext );
		long j = 0;
		for( j = 0; j < PCG_LS_MAX_N; j++ ){
			WSCstring path = ls.next();
			if( path.getChars() <= 0 )
				break;
			aWallDun[i][j].init( path );
		}
		nWallDunN[i] = j;
	}

	// 곬

	for( long i = 0; i < PCG_STAIRS_MAX_N; i++ ){
		nStairsUpTownN[i] = 0;

		if( gPcgTabStairsUpTown[i].nRatio <= -1 )
			break;

		ls.reset( gPcgTabStairsUpTown[i].sDir, ext );
		long j = 0;
		for( j = 0; j < PCG_LS_MAX_N; j++ ){
			WSCstring path = ls.next();
			if( path.getChars() <= 0 )
				break;
			aStairsUpTown[i][j].init( path );
		}
		nStairsUpTownN[i] = j;
	}
	for( long i = 0; i < PCG_STAIRS_MAX_N; i++ ){
		nStairsUpDunN[i] = 0;

		if( gPcgTabStairsUpDun[i].nRatio <= -1 )
			break;

		ls.reset( gPcgTabStairsUpDun[i].sDir, ext );
		long j = 0;
		for( j = 0; j < PCG_LS_MAX_N; j++ ){
			WSCstring path = ls.next();
			if( path.getChars() <= 0 )
				break;
			aStairsUpDun[i][j].init( path );
		}
		nStairsUpDunN[i] = j;
	}

	// 곬

	for( long i = 0; i < PCG_STAIRS_MAX_N; i++ ){
		nStairsDownTownN[i] = 0;

		if( gPcgTabStairsDownTown[i].nRatio <= -1 )
			break;

		ls.reset( gPcgTabStairsDownTown[i].sDir, ext );
		long j = 0;
		for( j = 0; j < PCG_LS_MAX_N; j++ ){
			WSCstring path = ls.next();
			if( path.getChars() <= 0 )
				break;
			aStairsDownTown[i][j].init( path );
		}
		nStairsDownTownN[i] = j;
	}
	for( long i = 0; i < PCG_STAIRS_MAX_N; i++ ){
		nStairsDownDunN[i] = 0;

		if( gPcgTabStairsDownDun[i].nRatio <= -1 )
			break;

		ls.reset( gPcgTabStairsDownDun[i].sDir, ext );
		long j = 0;
		for( j = 0; j < PCG_LS_MAX_N; j++ ){
			WSCstring path = ls.next();
			if( path.getChars() <= 0 )
				break;
			aStairsDownDun[i][j].init( path );
		}
		nStairsDownDunN[i] = j;
	}

	// Ĥޤäɥ

	for( long i = 0; i < PCG_DOOR_MAX_N; i++ ){
		nDoorCloseTownN[i] = 0;

		if( gPcgTabDoorCloseTown[i].nRatio <= -1 )
			break;

		ls.reset( gPcgTabDoorCloseTown[i].sDir, ext );
		long j = 0;
		for( j = 0; j < PCG_LS_MAX_N; j++ ){
			WSCstring path = ls.next();
			if( path.getChars() <= 0 )
				break;
			aDoorCloseTown[i][j].init( path );
		}
		nDoorCloseTownN[i] = j;
	}
	for( long i = 0; i < PCG_DOOR_MAX_N; i++ ){
		nDoorCloseDunN[i] = 0;

		if( gPcgTabDoorCloseDun[i].nRatio <= -1 )
			break;

		ls.reset( gPcgTabDoorCloseDun[i].sDir, ext );
		long j = 0;
		for( j = 0; j < PCG_LS_MAX_N; j++ ){
			WSCstring path = ls.next();
			if( path.getChars() <= 0 )
				break;
			aDoorCloseDun[i][j].init( path );
		}
		nDoorCloseDunN[i] = j;
	}

	// ɥ

	for( long i = 0; i < PCG_DOOR_MAX_N; i++ ){
		nDoorOpenTownN[i] = 0;

		if( gPcgTabDoorOpenTown[i].nRatio <= -1 )
			break;

		ls.reset( gPcgTabDoorOpenTown[i].sDir, ext );
		long j = 0;
		for( j = 0; j < PCG_LS_MAX_N; j++ ){
			WSCstring path = ls.next();
			if( path.getChars() <= 0 )
				break;
			aDoorOpenTown[i][j].init( path );
		}
		nDoorOpenTownN[i] = j;
	}
	for( long i = 0; i < PCG_DOOR_MAX_N; i++ ){
		nDoorOpenDunN[i] = 0;

		if( gPcgTabDoorOpenDun[i].nRatio <= -1 )
			break;

		ls.reset( gPcgTabDoorOpenDun[i].sDir, ext );
		long j = 0;
		for( j = 0; j < PCG_LS_MAX_N; j++ ){
			WSCstring path = ls.next();
			if( path.getChars() <= 0 )
				break;
			aDoorOpenDun[i][j].init( path );
		}
		nDoorOpenDunN[i] = j;
	}

	// 

	for( long i = 0; i < PCG_CRSR_MAX_N; i++ ){
		nCrsrN[i] = 0;

		if( gPcgTabCrsr[i].nRatio <= -1 )
			break;

		ls.reset( gPcgTabCrsr[i].sDir, ext );
		long j = 0;
		for( j = 0; j < PCG_LS_MAX_N; j++ ){
			WSCstring path = ls.next();
			if( path.getChars() <= 0 )
				break;
			aCrsr[i][j].init( path );
		}
		nCrsrN[i] = j;
	}

	// 󥫡

	nSquareN = 0;

	ls.reset( gPcgTabSquare.sDir, ext );
	long j = 0;
	for( j = 0; j < PCG_SQUARE_MAX_N; j++ ){
		WSCstring path = ls.next();
		if( path.getChars() <= 0 )
			break;
		aSquare[j].init( path );
	}
	nSquareN = j;

	// ƥ

	for( long i = 0; i < PCG_ITEM_MAX_N; i++ ){
		nItemN[i] = 0;

		if( gPcgTabItem[i].nRatio <= -1 )
			break;

		ls.reset( gPcgTabItem[i].sDir, ext );
		long j = 0;
		for( j = 0; j < PCG_LS_MAX_N; j++ ){
			WSCstring path = ls.next();
			if( path.getChars() <= 0 )
				break;
			aItem[i][j].init( path );
		}
		nItemN[i] = j;
	}

	// С

	mbr_t **ls_mbr = get_ls_mbr();

	for( long i = 0; i < LS_MBR_MAX_N; i++ ){
		ls.reset( gPcgTabMbrDflt.sDir, ext );
		WSCstring path = ls.jointDir( ls.getBaseDir(),
				gPcgTabMbrDflt.sDir );

		bool flagExist = true;
		if( ls_mbr[i] == NULL )
			flagExist = false;
		if( chk_flg( ls_mbr[i]->stat, FLG_STAT_NOT_EXIST ) )
			flagExist = false;
		if( ls_mbr[i]->graph_name[0] == '\0' )
			flagExist = false;

		if( flagExist ){
			path = ls.jointDir( path, ls_mbr[i]->graph_name );

			if( chk_exist_file( path ) ){
				aMbr[i].init( path );
				continue;
			}
		}

		ls.reset( gPcgTabMbrNull.sDir, ext );
		WSCstring file = ls.next();
		if( file.getChars() <= 0 )
			continue;
		aMbr[i].init( file );
	}

	// 󥹥

	for( long i = 0; i < MNSTR_KIND_MAX_N; i++ ){
		nMnstrN[i] = 0;
	}
	for( long i = 0; i < PCG_MNSTR_MAX_N; i++ ){
		if( gPcgTabMnstr[i].nRatio <= -1 )
			break;

		mnstr_kind_t kind = gPcgTabMnstr[i].nMnstrKind;
		if( kind == MNSTR_KIND_NULL )
			break;

		nMnstrN[kind] = 0;
		ls.reset( gPcgTabMnstr[i].sDir, ext );
		long j = 0;
		for( j = 0; j < PCG_LS_MAX_N; j++ ){
			WSCstring path = ls.next();
			if( path.getChars() <= 0 )
				break;
			aMnstr[kind][j].init( path );

			aMnstr[kind][j].dis();
		}
		nMnstrN[kind] = j;
	}

	reset();
}

////////////////////////////////////////////////////////////////
// ꥻå
////////////////////////////////////////////////////////////////

void PcgDun::reset()
{
	resetUpdateFlg();

	for( long i = 0; i < PCG_MNSTR_MAX_N; i++ ){
		if( gPcgTabMnstr[i].nRatio <= -1 )
			break;
		if( gPcgTabMnstr[i].nMnstrKind == MNSTR_KIND_NULL )
			break;

		for( long j = 0; j < PCG_LS_MAX_N; j++ ){
			aMnstr[i][j].dis();
		}
	}

	if( get_dun()->lev == 0 ){
		resetMap( gPcgTabNullTown, aaMapNull );
		resetMap( gPcgTabFloorTown, aaMapFloor );
		resetMap( gPcgTabWallTown, aaMapWall );
		resetMap( gPcgTabStairsUpTown, aaMapStairsUp );
		resetMap( gPcgTabStairsDownTown, aaMapStairsDown );
		resetMap( gPcgTabDoorCloseTown, aaMapDoorClose );
		resetMap( gPcgTabDoorOpenTown, aaMapDoorOpen );
	} else {
		resetMap( gPcgTabNullDun, aaMapNull );
		resetMap( gPcgTabFloorDun, aaMapFloor );
		resetMap( gPcgTabWallDun, aaMapWall );
		resetMap( gPcgTabStairsUpDun, aaMapStairsUp );
		resetMap( gPcgTabStairsDownDun, aaMapStairsDown );
		resetMap( gPcgTabDoorCloseDun, aaMapDoorClose );
		resetMap( gPcgTabDoorOpenDun, aaMapDoorOpen );
	}
}

////////////////////////////////////////////////////////////////
// ѥΥХꥨ󡦥ޥåפΥꥻå
// PcgTab tab[] : ѥΥơ֥
// PcgMap map[MAP_MAX_Y][MAP_MAX_X] : ХꥨΥޥå
////////////////////////////////////////////////////////////////

void PcgDun::resetMap( PcgTab tab[], PcgMap map[MAP_MAX_Y][MAP_MAX_X] )
{
	long nRatioSum = 0;
	for( long i = 0; i < LOOP_MAX_100; i++ ){
		if( tab[i].nRatio <= -1 )
			break;

		nRatioSum += tab[i].nRatio;
	}

	for( long y = 0; y < MAP_MAX_Y; y++ ){
		for( long x = 0; x < MAP_MAX_X; x++ ){
			map[y][x] = 0;

			long n = randm( nRatioSum );
			long nSum = 0;
			long i = 0;
			for( i = 0; i < LOOP_MAX_100; i++ ){
				if( tab[i].nRatio <= -1 )
					break;

				nSum += tab[i].nRatio;
				if( n < nSum ){
					map[y][x] = i;
					break;
				}
			}
		}
	}
}

////////////////////////////////////////////////////////////////
// ֥롦Хåե֤
// return : ե졼ࡦХåե
////////////////////////////////////////////////////////////////

WSDmwindowDev *PcgDun::getWBuf()
{
	if( pWBuf == NULL ){
		pWBuf = WSDmwindowDev::getNewInstance();
		pWBuf->createPixmap( MAP_MAX_X * getTileSizeX(),
				MAP_MAX_Y * getTileSizeY() );
	}

	return pWBuf;
}

////////////////////////////////////////////////////////////////
// ޥåפΥʥκɸǻꤹ
// long mapX : X ɸ
// long mapY : Y ɸ
////////////////////////////////////////////////////////////////

void PcgDun::scrollTile( long mapX, long mapY )
{
	scrollMap( mapX * getTileSizeX(), mapY * getTileSizeY() );
}

////////////////////////////////////////////////////////////////
// ޥåפΥʥɥåȤκɸǻꤹ
// long x : X ɸ
// long y : Y ɸ
////////////////////////////////////////////////////////////////

void PcgDun::scrollMap( long x, long y )
{
	long maxX = 1;
	long maxY = 1;
	long w = 1;
	long h = 1;

#ifdef D_WS
	w = (long)MapScrollX->getProperty( WSNsliderSize );
	h = (long)MapScrollY->getProperty( WSNsliderSize );
	maxX = (long)MapScrollX->getProperty( WSNmaximum );
	maxY = (long)MapScrollY->getProperty( WSNmaximum );
#endif // D_WS

#ifdef D_GTK
	GtkAdjustment *hAdj = GTK_ADJUSTMENT( gMapHScrollBarAdjustment );
	GtkAdjustment *vAdj = GTK_ADJUSTMENT( gMapVScrollBarAdjustment );

	w = (long)hAdj->page_size;
	h = (long)vAdj->page_size;
	maxX = (long)hAdj->upper - w;
	maxY = (long)vAdj->upper - h;
#endif // D_GTK

	if( x < 0 )
		x = 0;
	if( y < 0 )
		y = 0;
	if( x > maxX )
		x = maxX;
	if( y > maxY )
		y = maxY;

#ifdef D_WS
	MapScrollX->setProperty( WSNvalue, x );
	MapScrollY->setProperty( WSNvalue, y );
#endif // D_WS

#ifdef D_GTK
	hAdj->value = x;
	vAdj->value = y;
	gtk_adjustment_value_changed( hAdj );
	gtk_adjustment_value_changed( vAdj );
#endif // D_GTK

	drawScroll( x, y, w, h );
}

////////////////////////////////////////////////////////////////
// ޥåפ뤷褹ɬפͭ뤫å
// long x : X ɸ
// long y : Y ɸ
// long w : 
// long h : ⤵
// return : 褹ɬפͭ뤫
////////////////////////////////////////////////////////////////

bool PcgDun::chkScroll( long x, long y, long w, long h )
{
	x /= getTileSizeX();
	y /= getTileSizeY();

	static long preX = -1;
	static long preY = -1;
	static long preW = -1;
	static long preH = -1;

	if( (x == preX) && (y == preY) && (w == preW) && (h == preH) )
		return false;

	preX = x;
	preY = y;
	preW = w;
	preH = h;

	return true;
}

////////////////////////////////////////////////////////////////
// ޥåפ뤷
// long x : X ɸ
// long y : Y ɸ
// long w : 
// long h : ⤵
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool PcgDun::drawScroll( long x, long y, long w, long h )
{
	if( chk_nest_flg_dun() )
		return false;

	long mapX = x / getTileSizeX();
	long mapY = y / getTileSizeY();
	long mapW = (w + getTileSizeX() - 1) / getTileSizeX();
	long mapH = (h + getTileSizeY() - 1) / getTileSizeY();

	for( long dy = 0; dy < mapH; dy++ ){
		for( long dx = 0; dx < mapW; dx++ ){
			long xx = mapX + dx;
			long yy = mapY + dy;

			if( !getUpdateFlg( xx, yy ) )
				continue;

			if( !drawTile( xx, yy, false ) )
				return false;
		}
	}

	flush( mapX, mapY, mapW, mapH );

	return true;
}

////////////////////////////////////////////////////////////////
// κɸޥåפΥɥϰ⤫Ĵ٤
// long mapX : X ɸ
// long mapY : Y ɸ
// return : ϰ⤫
////////////////////////////////////////////////////////////////

bool PcgDun::clipWin( long mapX, long mapY )
{
	return( clipWinX( mapX ) && clipWinY( mapY ) );
}

////////////////////////////////////////////////////////////////
//  X ɸޥåפΥɥϰ⤫Ĵ٤
// long mapX : X ɸ
// return : ϰ⤫
////////////////////////////////////////////////////////////////

bool PcgDun::clipWinX( long mapX )
{
	long x = 0;
	long w = 32;

#ifdef D_WS
	x = (long)MapScrollX->getProperty( WSNvalue );
	w = (long)MapForm->getProperty( WSNwidth );
#endif // D_WS

#ifdef D_GTK
	GtkAdjustment *hAdj = GTK_ADJUSTMENT( gMapHScrollBarAdjustment );

	x = (long)hAdj->value;
	w = (long)hAdj->page_size;
#endif // D_GTK

	x /= getTileSizeX();
	w = (w + getTileSizeX() - 1) / getTileSizeX();

	if( mapX < x )
		return false;
	if( mapX >= x + w )
		return false;

	return true;
}

////////////////////////////////////////////////////////////////
//  Y ɸޥåפΥɥϰ⤫Ĵ٤
// long mapX : Y ɸ
// return : ϰ⤫
////////////////////////////////////////////////////////////////

bool PcgDun::clipWinY( long mapY )
{
	long y = 0;
	long h = 32;

#ifdef D_WS
	y = (long)MapScrollY->getProperty( WSNvalue );
	h = (long)MapForm->getProperty( WSNheight );
#endif // D_WS

#ifdef D_GTK
	GtkAdjustment *vAdj = GTK_ADJUSTMENT( gMapVScrollBarAdjustment );

	y = (long)vAdj->value;
	h = (long)vAdj->page_size;
#endif // D_GTK

	y /= getTileSizeY();
	h = (h + getTileSizeY() - 1) / getTileSizeY();

	if( mapY < y )
		return false;
	if( mapY >= y + h )
		return false;

	return true;
}

////////////////////////////////////////////////////////////////
// ޥåפκ
////////////////////////////////////////////////////////////////

void PcgDun::redraw()
{
	draw( 0, 0, MAP_MAX_X, MAP_MAX_Y );
}

////////////////////////////////////////////////////////////////
// ޥåפ
// long mapX : X ɸ
// long mapY : Y ɸ
// long mapW : 
// long mapH : ⤵
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool PcgDun::draw( long mapX, long mapY, long mapW, long mapH )
{
	if( chk_nest_flg_dun() )
		return false;

	bool flgSuccess = true;

	for( long dy = 0; dy < mapH; dy++ ){
		for( long dx = 0; dx < mapW; dx++ ){
			if( !drawTile( mapX + dx, mapY + dy, true ) ){
				flgSuccess = false;
			}
		}
	}

	return flgSuccess;
}

////////////////////////////////////////////////////////////////
// ե졼ࡦХåե饦ɥؤ
// long mapX : X ɸ
// long mapY : Y ɸ
// long mapW : 
// long mapH : ⤵
////////////////////////////////////////////////////////////////

void PcgDun::flush( long mapX, long mapY, long mapW, long mapH )
{
	if( chk_nest_flg_dun() )
		return;

	long x = mapX * getTileSizeX();
	long y = mapY * getTileSizeY();
	long w = (mapW + 1) * getTileSizeX();
	long h = (mapH + 1) * getTileSizeY();

	long minX = 0;
	long minY = 0;
	long maxX = 1;
	long maxY = 1;

#ifdef D_WS
	minX = (long)MapScrollX->getProperty( WSNvalue );
	minY = (long)MapScrollY->getProperty( WSNvalue );
	maxX = minX + (long)MapForm->getProperty( WSNwidth );
	maxY = minY + (long)MapForm->getProperty( WSNheight );
#endif // D_WS

#ifdef D_GTK
	GtkAdjustment *hAdj = GTK_ADJUSTMENT( gMapHScrollBarAdjustment );
	GtkAdjustment *vAdj = GTK_ADJUSTMENT( gMapVScrollBarAdjustment );

	minX = (long)hAdj->value;
	minY = (long)vAdj->value;
	maxX = (long)hAdj->page_size + minX;
	maxY = (long)vAdj->page_size + minY;
#endif // D_GTK

	if( x < minX )
		x = minX;
	if( y < minY )
		y = minY;
	if( x > maxX )
		x = maxX;
	if( y > maxY )
		y = maxY;

	if( w > maxX - minX )
		w = maxX - minX;
	if( h > maxY - minY )
		h = maxY - minY;
	if( w <= 0 )
		return;
	if( h <= 0 )
		return;

	if( !getWBuf()->getReady() )
		return;
#ifdef D_WS
	if( !MapForm->getdev()->getReady() )
		return;

//@@@ jjjj
	getWBuf()->copyToWindow( MapForm->getdev(),
			x, y, w, h,
			x - minX, y - minY );
#endif // D_WS

#ifdef D_GTK
	GdkRectangle updateRect;
	updateRect.x = x - minX;
	updateRect.y = y - minY;
	updateRect.width = w;
	updateRect.height = h;
	gtk_widget_draw( gMapDrawingArea, &updateRect );
#endif // D_GTK
}

////////////////////////////////////////////////////////////////
// ե饰Υꥻå
////////////////////////////////////////////////////////////////

void PcgDun::resetUpdateFlg()
{
	for( long y = 0; y < MAP_MAX_Y; y++ )
		for( long x = 0; x < MAP_MAX_X; x++ )
			setUpdateFlg( x, y, true );
}

////////////////////////////////////////////////////////////////
// ե饰
// long mapX : X ɸ
// long mapY : Y ɸ
// bool flg : 褹ɬפ뤫
////////////////////////////////////////////////////////////////

void PcgDun::setUpdateFlg( long mapX, long mapY, bool flg )
{
	if( !clip_pos( mapX, mapY ) )
		return;

	bFlgUpdate[mapY][mapX] = flg;
}

////////////////////////////////////////////////////////////////
// ե饰μ
// long mapX : X ɸ
// long mapY : Y ɸ
// return : 褹ɬפ뤫
////////////////////////////////////////////////////////////////

bool PcgDun::getUpdateFlg( long mapX, long mapY )
{
	if( !clip_pos( mapX, mapY ) )
		return false;

	return bFlgUpdate[mapY][mapX];
}

////////////////////////////////////////////////////////////////
// 饯
// long mapX : X ɸ
// long mapY : Y ɸ
// bool flgFlush : ե졼ࡦХåե饦ɥ
//     褹뤫
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool PcgDun::drawTile( long mapX, long mapY, bool flgFlush )
{
	if( chk_nest_flg_dun() ){
		setUpdateFlg( mapX, mapY, true );

		return true;
	}
	if( !clipWin( mapX, mapY ) ){
		setUpdateFlg( mapX, mapY, true );

		return true;
	}

	if( !drawObj( mapX, mapY ) ){
		setUpdateFlg( mapX, mapY, true );
		return false;
	}
	if( !drawSquare( mapX, mapY ) ){
		setUpdateFlg( mapX, mapY, true );
		return false;
	}
	if( !drawItemAll( mapX, mapY ) ){
		setUpdateFlg( mapX, mapY, true );
		return false;
	}
	if( !drawChrList( mapX, mapY, true ) ){
		setUpdateFlg( mapX, mapY, true );
		return false;
	}
	if( !drawCrsrAll( mapX, mapY ) ){
		setUpdateFlg( mapX, mapY, true );
		return false;
	}

	if( flgFlush )
		flush( mapX, mapY, 1, 1 );
	setUpdateFlg( mapX, mapY, false );

	return true;
}

////////////////////////////////////////////////////////////////
// ֥Ȥ
// long mapX : X ɸ
// long mapY : Y ɸ
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool PcgDun::drawObj( long mapX, long mapY )
{
	bool flgSuccess = false;

	if( !clip_pos( mapX, mapY ) )
		return true;

	if( !getWBuf()->getReady() )
		return false;
#ifdef D_WS
	if( !MapForm->getdev()->getReady() )
		return false;
#endif // D_WS

	char mjr = FACE_MJR_NULL;
	char mnr = FACE_MNR_NULL;
	set_face_from_map_obj( TRUE, mapX, mapY, &mjr, &mnr );

	switch( mjr ){
	default:
	case FACE_MJR_NULL:
		flgSuccess = drawNull( mapX, mapY );
		break;
	case FACE_MJR_FLOOR:
		flgSuccess = drawFloor( mapX, mapY );
		break;
	case FACE_MJR_WALL:
		flgSuccess = drawWall( mapX, mapY );
		break;
	case FACE_MJR_STAIRS_UP:
		flgSuccess = drawStairsUp( mapX, mapY );
		break;
	case FACE_MJR_STAIRS_DOWN:
		flgSuccess = drawStairsDown( mapX, mapY );
		break;
	case FACE_MJR_DOOR_CLOSE:
		flgSuccess = drawDoorClose( mapX, mapY );
		break;
	case FACE_MJR_DOOR_OPEN:
		flgSuccess = drawDoorOpen( mapX, mapY );
		break;
	case FACE_MJR_WEAPON:
	case FACE_MJR_ARMOR:
	case FACE_MJR_POTION:
	case FACE_MJR_SCROLL:
	case FACE_MJR_STICK:
	case FACE_MJR_ACCESSORY:
	case FACE_MJR_FOOD:
	case FACE_MJR_CHEST:
	case FACE_MJR_COIN:
	case FACE_MJR_GEM:
	case FACE_MJR_MISC:
		flgSuccess = drawFloor( mapX, mapY );
		break;
	}

	return flgSuccess;
}

////////////////////////////////////////////////////////////////
// Υƥ
// long mapX : X ɸ
// long mapY : Y ɸ
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool PcgDun::drawItemAll( long mapX, long mapY )
{
	bool flgSuccess = false;

	if( !clip_pos( mapX, mapY ) )
		return true;

	if( !getWBuf()->getReady() )
		return false;
#ifdef D_WS
	if( !MapForm->getdev()->getReady() )
		return false;
#endif // D_WS

	char mjr = FACE_MJR_NULL;
	char mnr = FACE_MNR_NULL;
	set_face_from_map_obj( TRUE, mapX, mapY, &mjr, &mnr );

	switch( mjr ){
	default:
	case FACE_MJR_NULL:
		flgSuccess = true;
		break;
	case FACE_MJR_WEAPON:
	case FACE_MJR_ARMOR:
	case FACE_MJR_POTION:
	case FACE_MJR_SCROLL:
	case FACE_MJR_STICK:
	case FACE_MJR_ACCESSORY:
	case FACE_MJR_FOOD:
	case FACE_MJR_CHEST:
	case FACE_MJR_COIN:
	case FACE_MJR_GEM:
	case FACE_MJR_MISC:
		flgSuccess = drawItem( mapX, mapY, mjr, mnr );
		break;
	}

	return flgSuccess;
}

////////////////////////////////////////////////////////////////
// 
// long mapX : X ɸ
// long mapY : Y ɸ
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool PcgDun::drawNull( long mapX, long mapY )
{
	if( !clip_pos( mapX, mapY ) )
		return true;

	long n = aaMapNull[mapY][mapX];

	if( get_dun()->lev == 0 ){
		return aNullTown[n][0].drawFix( getWBuf(),
				mapX * getTileSizeX(),
				mapY * getTileSizeY(),
				1 * getTileSizeX(),
				1 * getTileSizeY() );
	} else {
		return aNullDun[n][0].drawFix( getWBuf(),
				mapX * getTileSizeX(),
				mapY * getTileSizeY(),
				1 * getTileSizeX(),
				1 * getTileSizeY() );
	}

	return false;
}

////////////////////////////////////////////////////////////////
// 
// long mapX : X ɸ
// long mapY : Y ɸ
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool PcgDun::drawFloor( long mapX, long mapY )
{
	if( !clip_pos( mapX, mapY ) )
		return true;

	long n = aaMapFloor[mapY][mapX];

	if( get_dun()->lev == 0 ){
		return aFloorTown[n][0].drawFix( getWBuf(),
				mapX * getTileSizeX(),
				mapY * getTileSizeY(),
				1 * getTileSizeX(),
				1 * getTileSizeY() );
	} else {
		return aFloorDun[n][0].drawFix( getWBuf(),
				mapX * getTileSizeX(),
				mapY * getTileSizeY(),
				1 * getTileSizeX(),
				1 * getTileSizeY() );
	}

	return false;
}

////////////////////////////////////////////////////////////////
// ɤ
// long mapX : X ɸ
// long mapY : Y ɸ
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool PcgDun::drawWall( long mapX, long mapY )
{
	if( !clip_pos( mapX, mapY ) )
		return true;

	long bit = 0;

	// Τդȹ礻

	if( chkDrawWall( mapX + 0, mapY - 1 ) )
		bit |= gBitIdxWallN;

	if( chkDrawWall( mapX + 0, mapY + 1 ) )
		bit |= gBitIdxWallS;

	if( chkDrawWall( mapX + 1, mapY + 0 ) )
		bit |= gBitIdxWallE;

	if( chkDrawWall( mapX - 1, mapY + 0 ) )
		bit |= gBitIdxWallW;

	long idxX = gIdxWall[bit].x;
	long idxY = gIdxWall[bit].y;

	// ƤդäƤ뤫?

	long bitAll = (gBitIdxWallN | gBitIdxWallS
			| gBitIdxWallE | gBitIdxWallW);
	if( (bit & bitAll) == bitAll ){
		// ФΤդȹ礻

		long bitDiagonal = 0;

		if( chkDrawWall( mapX - 1, mapY - 1 ) )
			bitDiagonal |= gBitIdxWallNW;

		if( chkDrawWall( mapX + 1, mapY - 1 ) )
			bitDiagonal |= gBitIdxWallNE;

		if( chkDrawWall( mapX - 1, mapY + 1 ) )
			bitDiagonal |= gBitIdxWallSW;

		if( chkDrawWall( mapX + 1, mapY + 1 ) )
			bitDiagonal |= gBitIdxWallSE;

		idxX = gIdxWallDiagonal[bitDiagonal].x;
		idxY = gIdxWallDiagonal[bitDiagonal].y;
	}

	long n = aaMapWall[mapY][mapX];

	if( get_dun()->lev == 0 ){
		return aWallTown[n][0].drawIdx( getWBuf(),
				mapX * getTileSizeX(),
				mapY * getTileSizeY(),
				1 * getTileSizeX(),
				1 * getTileSizeY(),
				idxX,
				idxY,
				getTileSizeX(),
				getTileSizeY() );
	} else {
		return aWallDun[n][0].drawIdx( getWBuf(),
				mapX * getTileSizeX(),
				mapY * getTileSizeY(),
				1 * getTileSizeX(),
				1 * getTileSizeY(),
				idxX,
				idxY,
				getTileSizeX(),
				getTileSizeY() );
	}

	return false;
}

////////////////////////////////////////////////////////////////
// 곬ʤ
// long mapX : X ɸ
// long mapY : Y ɸ
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool PcgDun::drawStairsUp( long mapX, long mapY )
{
	if( !clip_pos( mapX, mapY ) )
		return true;

	long n = aaMapStairsUp[mapY][mapX];

	if( get_dun()->lev == 0 ){
		return aStairsUpTown[n][0].drawFix( getWBuf(),
				mapX * getTileSizeX(),
				mapY * getTileSizeY(),
				1 * getTileSizeX(),
				1 * getTileSizeY() );
	} else {
		return aStairsUpDun[n][0].drawFix( getWBuf(),
				mapX * getTileSizeX(),
				mapY * getTileSizeY(),
				1 * getTileSizeX(),
				1 * getTileSizeY() );
	}

	return false;
}

////////////////////////////////////////////////////////////////
// 곬ʤ
// long mapX : X ɸ
// long mapY : Y ɸ
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool PcgDun::drawStairsDown( long mapX, long mapY )
{
	if( !clip_pos( mapX, mapY ) )
		return true;

	long n = aaMapStairsDown[mapY][mapX];

	if( get_dun()->lev == 0 ){
		return aStairsDownTown[n][0].drawFix( getWBuf(),
				mapX * getTileSizeX(),
				mapY * getTileSizeY(),
				1 * getTileSizeX(),
				1 * getTileSizeY() );
	} else {
		return aStairsDownDun[n][0].drawFix( getWBuf(),
				mapX * getTileSizeX(),
				mapY * getTileSizeY(),
				1 * getTileSizeX(),
				1 * getTileSizeY() );
	}

	return false;
}

////////////////////////////////////////////////////////////////
// Ĥɥ
// long mapX : X ɸ
// long mapY : Y ɸ
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool PcgDun::drawDoorClose( long mapX, long mapY )
{
	if( !clip_pos( mapX, mapY ) )
		return true;

	long idxX = +1;
	long idxY = +1;
	char mjr = FACE_MJR_NULL;
	char mnr = FACE_MNR_NULL;

	set_face_from_map_obj( FALSE, mapX - 1, mapY, &mjr, &mnr );
	if( mjr != FACE_MJR_DOOR_CLOSE )
		idxX += -1;
	set_face_from_map_obj( FALSE, mapX + 1, mapY, &mjr, &mnr );
	if( mjr != FACE_MJR_DOOR_CLOSE )
		idxX += +1;

	set_face_from_map_obj( FALSE, mapX, mapY - 1, &mjr, &mnr );
	if( mjr != FACE_MJR_DOOR_CLOSE )
		idxY += -1;
	set_face_from_map_obj( FALSE, mapX, mapY + 1, &mjr, &mnr );
	if( mjr != FACE_MJR_DOOR_CLOSE )
		idxY += +1;

	long n = aaMapDoorClose[mapY][mapX];

	if( get_dun()->lev == 0 ){
		return aDoorCloseTown[n][0].drawIdx( getWBuf(),
				mapX * getTileSizeX(),
				mapY * getTileSizeY(),
				1 * getTileSizeX(),
				1 * getTileSizeY(),
				idxX, idxY,
				getTileSizeX(), getTileSizeY() );
	} else {
		return aDoorCloseDun[n][0].drawIdx( getWBuf(),
				mapX * getTileSizeX(),
				mapY * getTileSizeY(),
				1 * getTileSizeX(),
				1 * getTileSizeY(),
				idxX, idxY,
				getTileSizeX(), getTileSizeY() );
	}

	return false;
}

////////////////////////////////////////////////////////////////
// ɥ
// long mapX : X ɸ
// long mapY : Y ɸ
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool PcgDun::drawDoorOpen( long mapX, long mapY )
{
	if( !clip_pos( mapX, mapY ) )
		return true;

	long idxX = +1;
	long idxY = +1;
	char mjr = FACE_MJR_NULL;
	char mnr = FACE_MNR_NULL;

	set_face_from_map_obj( FALSE, mapX - 1, mapY, &mjr, &mnr );
	if( mjr != FACE_MJR_DOOR_OPEN )
		idxX += -1;
	set_face_from_map_obj( FALSE, mapX + 1, mapY, &mjr, &mnr );
	if( mjr != FACE_MJR_DOOR_OPEN )
		idxX += +1;

	set_face_from_map_obj( FALSE, mapX, mapY - 1, &mjr, &mnr );
	if( mjr != FACE_MJR_DOOR_OPEN )
		idxY += -1;
	set_face_from_map_obj( FALSE, mapX, mapY + 1, &mjr, &mnr );
	if( mjr != FACE_MJR_DOOR_OPEN )
		idxY += +1;

	long n = aaMapDoorOpen[mapY][mapX];

	if( get_dun()->lev == 0 ){
		return aDoorOpenTown[n][0].drawIdx( getWBuf(),
				mapX * getTileSizeX(),
				mapY * getTileSizeY(),
				1 * getTileSizeX(),
				1 * getTileSizeY(),
				idxX, idxY,
				getTileSizeX(), getTileSizeY() );
	} else {
		return aDoorOpenDun[n][0].drawIdx( getWBuf(),
				mapX * getTileSizeX(),
				mapY * getTileSizeY(),
				1 * getTileSizeX(),
				1 * getTileSizeY(),
				idxX, idxY,
				getTileSizeX(), getTileSizeY() );
	}

	return false;
}

////////////////////////////////////////////////////////////////
// ᥤȥ֤Υ
// long mapX : X ɸ
// long mapY : Y ɸ
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool PcgDun::drawCrsrAll( long mapX, long mapY )
{
	bool flagNoErr = true;

	if( !drawCrsrSub( mapX, mapY ) )
		flagNoErr = false;

	if( !drawCrsr( mapX, mapY ) )
		flagNoErr = false;

	return flagNoErr;
}

////////////////////////////////////////////////////////////////
// 
// long mapX : X ɸ
// long mapY : Y ɸ
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool PcgDun::drawCrsr( long mapX, long mapY )
{
	if( !clipWin( mapX, mapY ) )
		return true;

	pos_t *crsr = get_crsr();
	if( crsr == NULL )
		return true;
	if( !clip_pos( crsr->x, crsr->y ) )
		return true;
	if( !clipWin( crsr->x, crsr->y ) )
		return true;

	if( !chkDrawCrsr( mapX, mapY ) )
		return true;

	long crsrW = aCrsr[0][0].getWidth();
	long crsrH = aCrsr[0][0].getHeight();
	long crsrX = (crsr->x * getTileSizeX());
	long crsrY = (crsr->y * getTileSizeY());
	crsrX += (getTileSizeX() / 2) - (crsrW / 2);
	crsrY += (getTileSizeY() / 2) - (crsrH / 2);

	long drawW = getTileSizeX();
	long drawH = getTileSizeY();
	long drawX = mapX * getTileSizeX();
	long drawY = mapY * getTileSizeY();

	long w = (drawX + drawW) - (crsrX + crsrW);
	long h = (drawY + drawH) - (crsrY + crsrH);
	if( w > 0 )
		drawW -= w;
	if( h > 0 )
		drawH -= h;
	if( drawW < 1 )
		return true;
	if( drawH < 1 )
		return true;

	long offsetX = drawX - crsrX;
	long offsetY = drawY - crsrY;

	return( aCrsr[0][0].drawOffset( getWBuf(),
			drawX, drawY, drawW, drawH, offsetX, offsetY ) );
}

////////////////////////////////////////////////////////////////
// ֡
// long mapX : X ɸ
// long mapY : Y ɸ
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool PcgDun::drawCrsrSub( long mapX, long mapY )
{
	if( !clipWin( mapX, mapY ) )
		return true;

	pos_t *crsrSub = get_sub_crsr();
	if( crsrSub == NULL )
		return true;
	if( !clip_pos( crsrSub->x, crsrSub->y ) )
		return true;
	if( !clipWin( crsrSub->x, crsrSub->y ) )
		return true;

	if( !chkDrawCrsrSub( mapX, mapY ) )
		return true;

	long crsrSubW = aCrsrSub[0][0].getWidth();
	long crsrSubH = aCrsrSub[0][0].getHeight();
	long crsrSubX = (crsrSub->x * getTileSizeX());
	long crsrSubY = (crsrSub->y * getTileSizeY());
	crsrSubX += (getTileSizeX() / 2) - (crsrSubW / 2);
	crsrSubY += (getTileSizeY() / 2) - (crsrSubH / 2);

	long drawW = getTileSizeX();
	long drawH = getTileSizeY();
	long drawX = mapX * getTileSizeX();
	long drawY = mapY * getTileSizeY();

	long w = (drawX + drawW) - (crsrSubX + crsrSubW);
	long h = (drawY + drawH) - (crsrSubY + crsrSubH);
	if( w > 0 )
		drawW -= w;
	if( h > 0 )
		drawH -= h;
	if( drawW < 1 )
		return true;
	if( drawH < 1 )
		return true;

	long offsetX = drawX - crsrSubX;
	long offsetY = drawY - crsrSubY;

	return( aCrsrSub[0][0].drawOffset( getWBuf(),
			drawX, drawY, drawW, drawH, offsetX, offsetY ) );
}

////////////////////////////////////////////////////////////////
// 󥫡
// long mapX : X ɸ
// long mapY : Y ɸ
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool PcgDun::drawSquare( long mapX, long mapY )
{
	if( !clipWin( mapX, mapY ) )
		return true;
	if( nSquareN <= 0 )
		return false;

	square_t	*square = get_square_mbr();
	if( square == NULL )
		return true;
	if( !clip_pos( square->x, square->y ) )
		return true;
	if( !clipWin( square->x, square->y ) )
		return true;

	if( !chkDrawSquare( mapX, mapY ) )
		return true;

	long squareW = aSquare[0].getWidth();
	long squareH = aSquare[0].getHeight();
	long squareX = (square->x * getTileSizeX());
	long squareY = (square->y * getTileSizeY());
	squareX += (getTileSizeX() / 2) - (squareW / 2);
	squareY += (getTileSizeY() / 2) - (squareH / 2);

	long drawW = getTileSizeX();
	long drawH = getTileSizeY();
	long drawX = mapX * getTileSizeX();
	long drawY = mapY * getTileSizeY();

	long w = (drawX + drawW) - (squareX + squareW);
	long h = (drawY + drawH) - (squareY + squareH);
	if( w > 0 )
		drawW -= w;
	if( h > 0 )
		drawH -= h;
	if( drawW < 1 )
		return true;
	if( drawH < 1 )
		return true;

	long offsetX = drawX - squareX;
	long offsetY = drawY - squareY;

	return( aSquare[0].drawOffset( getWBuf(),
			drawX, drawY, drawW, drawH, offsetX, offsetY ) );
}

////////////////////////////////////////////////////////////////
// ƥ
// long mapX : X ɸ
// long mapY : Y ɸ
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool PcgDun::drawItem( long mapX, long mapY, char mjr, char mnr )
{
	if( !clip_pos( mapX, mapY ) )
		return true;

	long n = 0;
	for( long i = 0; i < LOOP_MAX_1000; i++ ){
		if( gPcgTabItem[i].nRatio <= -1 ){
			n = 0;
			break;
		}
		if( (gPcgTabItem[i].mjr == mjr)
				&& (gPcgTabItem[i].mnr == mnr) ){
			n = i;
			break;
		}
	}

	long x = mapX * getTileSizeX();
	long y = mapY * getTileSizeY();
	long w = aItem[n][0].getWidth();
	long h = aItem[n][0].getHeight();
	long dx = (getTileSizeX() - w) / 2;
	long dy = (getTileSizeY() - h) / 2;

	return( aItem[n][0].draw( getWBuf(),
			x + dx, y + dy,
			w, h ) );
}

////////////////////////////////////////////////////////////////
// ɸϰ饯
// long mapX : X ɸ
// long mapY : Y ɸ
// bool flagOneTile : 1 ʬ褹뤫
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool PcgDun::drawChrList( long mapX, long mapY, bool flagOneTile )
{
	if( !clipWin( mapX, mapY ) )
		return true;

	chr_t *p = get_sort_chr_head();

	for( long i = 0; i < LOOP_MAX_1000; i++, p = p->sort_chr_next ){
		if( p == NULL )
			break;

		if( !chkDrawChr( mapX, mapY, p ) )
			continue;

		Pcg *pPcg = getChrPcg( p );
		if( !drawChr( mapX, mapY, p, pPcg, flagOneTile ) ){
			return false;
		}
	}

	return true;
}

////////////////////////////////////////////////////////////////
// ɸϰ饯
// long mapX : X ɸ
// long mapY : Y ɸ
// chr_t *chr : 饯
// Pcg *pPcg : ѥ
// bool flagOneTile : 1 ʬ褹뤫
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool PcgDun::drawChr(
	long mapX, long mapY,
	chr_t *chr, Pcg *pPcg,
	bool flagOneTile
)
{
	if( chr == NULL )
		return false;
	if( pPcg == NULL )
		return false;

	if( !clipWin( mapX, mapY ) )
		return true;

	long x1 = getChrDrawLeft( chr, pPcg, false );
	long x2 = getChrDrawRight( chr, pPcg, false );
	long y1 = getChrDrawTop( chr, pPcg, false );
	long y2 = getChrDrawBottom( chr, pPcg, false );

	long xx1 = x1;
	long xx2 = x2;
	long yy1 = y1;
	long yy2 = y2;

	if( flagOneTile ){
		if( xx1 < ((mapX + 0) * getTileSizeX()) )
			xx1 = ((mapX + 0) * getTileSizeX());
		if( xx2 > ((mapX + 1) * getTileSizeX()) )
			xx2 = ((mapX + 1) * getTileSizeX());

		if( yy1 < ((mapY + 0) * getTileSizeY()) )
			yy1 = ((mapY + 0) * getTileSizeY());
		if( yy2 > ((mapY + 1) * getTileSizeY()) )
			yy2 = ((mapY + 1) * getTileSizeY());
	}

	long w = xx2 - xx1;
	long h = yy2 - yy1;
	if( w < 1 )
		return true;
	if( h < 1 )
		return true;

	long offsetX = xx1 - x1;
	long offsetY = yy1 - y1;

	bool flgDir4 = false;
	if( (chr->kind == CHR_KIND_MBR)
			&& (nPtnDirMbr == N_PTN_DIR_CHR_4) ){
		flgDir4 = true;
	}
	if( (chr->kind == CHR_KIND_MNSTR)
			&& (nPtnDirMnstr == N_PTN_DIR_CHR_4) ){
		flgDir4 = true;
	}
	if( flgDir4 ){
		long dirIdx = get_chr_dir_idx( chr );
		dirIdx *= getHeightChr( chr, pPcg );
		offsetY += dirIdx;
	}

	return( pPcg->drawOffset( getWBuf(),
			xx1, yy1, w, h, offsetX, offsetY ) );
}

////////////////////////////////////////////////////////////////
// 饯Υѥ֤
// chr_t *chr : 饯
// return : ѥ
////////////////////////////////////////////////////////////////

Pcg *PcgDun::getChrPcg( chr_t *chr )
{
	if( chr == NULL )
		return NULL;

	if( chr->kind == CHR_KIND_MBR ){
		return( &(aMbr[chr->ls_mbr_n]) );
	} else if( chr->kind == CHR_KIND_MNSTR ){
		long n = chr->mnstr_kind;
		long m = 0;

		if( nMnstrN[n] <= 0 )
			n = MNSTR_KIND_NULL;

		return( &(aMnstr[n][m]) );
	}

	return NULL;
}

////////////////////////////////////////////////////////////////
// 饯κüκɸ֤
// chr_t *chr : 饯
// Pcg *pPcg : ѥ
// bool flagPre : 1 κɸ
// return : ɸ
////////////////////////////////////////////////////////////////

long PcgDun::getChrDrawLeft( chr_t *chr, Pcg *pPcg, bool flagPre )
{
	if( chr == NULL )
		return MAP_DEL_X;
	if( pPcg == NULL )
		return MAP_DEL_X;

	long bx = 0;
	long ex = 0;
	if( flagPre ){
		bx = get_chr_left( chr->pre_draw_x, chr->dx );
		ex = (get_chr_right( chr->pre_draw_x, chr->dx ) + 1);
	} else {
		bx = get_chr_left( chr->x, chr->dx );
		ex = (get_chr_right( chr->x, chr->dx ) + 1);
	}
	bx *= getTileSizeX();
	ex *= getTileSizeX();

	long x1 = ((ex + bx) / 2) - (getWidthChr( chr, pPcg ) / 2);

	return x1;
}

////////////////////////////////////////////////////////////////
// 饯αüκɸ֤
// chr_t *chr : 饯
// Pcg *pPcg : ѥ
// bool flagPre : 1 κɸ
// return : ɸ
////////////////////////////////////////////////////////////////

long PcgDun::getChrDrawRight( chr_t *chr, Pcg *pPcg, bool flagPre )
{
	if( chr == NULL )
		return MAP_DEL_X;
	if( pPcg == NULL )
		return MAP_DEL_X;

	long bx = 0;
	long ex = 0;
	if( flagPre ){
		bx = get_chr_left( chr->pre_draw_x, chr->dx );
		ex = (get_chr_right( chr->pre_draw_x, chr->dx ) + 1);
	} else {
		bx = get_chr_left( chr->x, chr->dx );
		ex = (get_chr_right( chr->x, chr->dx ) + 1);
	}
	bx *= getTileSizeX();
	ex *= getTileSizeX();

	long x2 = ((ex + bx) / 2) + (getWidthChr( chr, pPcg ) / 2);

	return x2;
}

////////////////////////////////////////////////////////////////
// 饯ξüκɸ֤
// chr_t *chr : 饯
// Pcg *pPcg : ѥ
// bool flagPre : 1 κɸ
// return : ɸ
////////////////////////////////////////////////////////////////

long PcgDun::getChrDrawTop( chr_t *chr, Pcg *pPcg, bool flagPre )
{
	if( chr == NULL )
		return MAP_DEL_Y;
	if( pPcg == NULL )
		return MAP_DEL_Y;

	long ey = 0;
	if( flagPre ){
		ey = (get_chr_bottom( chr->pre_draw_y, chr->dy ) + 1);
		ey = (get_chr_bottom( chr->pre_draw_y, chr->dy ) + 1);
	} else {
		ey = (get_chr_bottom( chr->y, chr->dy ) + 1);
		ey = (get_chr_bottom( chr->y, chr->dy ) + 1);
	}
	ey *= getTileSizeY();

	long y1 = ey - getHeightChr( chr, pPcg );

	return y1;
}

////////////////////////////////////////////////////////////////
// 饯βüκɸ֤
// chr_t *chr : 饯
// Pcg *pPcg : ѥ
// bool flagPre : 1 κɸ
// return : ɸ
////////////////////////////////////////////////////////////////

long PcgDun::getChrDrawBottom( chr_t *chr, Pcg *pPcg, bool flagPre )
{
	if( chr == NULL )
		return MAP_DEL_Y;
	if( pPcg == NULL )
		return MAP_DEL_Y;

	long ey = 0;
	if( flagPre ){
		ey = (get_chr_bottom( chr->pre_draw_y, chr->dy ) + 1);
		ey = (get_chr_bottom( chr->pre_draw_y, chr->dy ) + 1);
	} else {
		ey = (get_chr_bottom( chr->y, chr->dy ) + 1);
		ey = (get_chr_bottom( chr->y, chr->dy ) + 1);
	}
	ey *= getTileSizeY();

	long y2 = ey;

	return y2;
}

////////////////////////////////////////////////////////////////
// κɸɤĴ٤
// long mapX : X ɸ
// long mapY : Y ɸ
// return : ɤ
////////////////////////////////////////////////////////////////

bool PcgDun::chkDrawWall( long mapX, long mapY )
{
	if( !clip_pos( mapX, mapY ) )
		return true;

	char mjr = FACE_MJR_NULL;
	set_face_from_map_obj( FALSE, mapX, mapY, &mjr, NULL );

	switch( mjr ){
	case FACE_MJR_WALL:
	case FACE_MJR_DOOR_OPEN:
	case FACE_MJR_DOOR_CLOSE:
		return true;
	}

	return false;
}

////////////////////////////////////////////////////////////////
// κɸ˥뤬뤫Ĵ٤
// long mapX : X ɸ
// long mapY : Y ɸ
// return : 뤬뤫
////////////////////////////////////////////////////////////////

bool PcgDun::chkDrawCrsr( long mapX, long mapY )
{
	if( !clip_pos( mapX, mapY ) )
		return false;

	pos_t *crsr = get_crsr();
	if( crsr == NULL )
		return false;
	if( !clip_pos( crsr->x, crsr->y ) )
		return false;

	long x = mapX * getTileSizeX();
	long y = mapY * getTileSizeY();
	long w = aCrsr[0][0].getWidth();
	long h = aCrsr[0][0].getHeight();

	long bx = (crsr->x * getTileSizeX()) - (w / 2);
	long by = (crsr->y * getTileSizeY()) - (h / 2);
	long ex = bx + w;
	long ey = by + h;

	if( x < bx )
		return false;
	if( y < by )
		return false;
	if( x > ex )
		return false;
	if( y > ey )
		return false;

	return true;
}

////////////////////////////////////////////////////////////////
// κɸ˥֡뤬뤫Ĵ٤
// long mapX : X ɸ
// long mapY : Y ɸ
// return : 뤬뤫
////////////////////////////////////////////////////////////////

bool PcgDun::chkDrawCrsrSub( long mapX, long mapY )
{
	if( !clip_pos( mapX, mapY ) )
		return false;

	pos_t *crsrSub = get_sub_crsr();
	if( crsrSub == NULL )
		return false;
	if( !clip_pos( crsrSub->x, crsrSub->y ) )
		return false;

	long x = mapX * getTileSizeX();
	long y = mapY * getTileSizeY();
	long w = aCrsrSub[0][0].getWidth();
	long h = aCrsrSub[0][0].getHeight();

	long bx = (crsrSub->x * getTileSizeX()) - (w / 2);
	long by = (crsrSub->y * getTileSizeY()) - (h / 2);
	long ex = bx + w;
	long ey = by + h;

	if( x < bx )
		return false;
	if( y < by )
		return false;
	if( x > ex )
		return false;
	if( y > ey )
		return false;

	return true;
}

////////////////////////////////////////////////////////////////
// κɸ˥󥫡뤫Ĵ٤
// long mapX : X ɸ
// long mapY : Y ɸ
// return : 󥫡뤫
////////////////////////////////////////////////////////////////

bool PcgDun::chkDrawSquare( long mapX, long mapY )
{
	if( !clip_pos( mapX, mapY ) )
		return false;

	square_t	*square = get_square_mbr();
	if( square == NULL )
		return false;
	if( !clip_pos( square->x, square->y ) )
		return false;

	long x = mapX * getTileSizeX();
	long y = mapY * getTileSizeY();
	long w = aSquare[0].getWidth();
	long h = aSquare[0].getHeight();

	long bx = (square->x * getTileSizeX()) - (w / 2);
	long by = (square->y * getTileSizeY()) - (h / 2);
	long ex = bx + w;
	long ey = by + h;

	if( x < bx )
		return false;
	if( y < by )
		return false;
	if( x > ex )
		return false;
	if( y > ey )
		return false;

	return true;
}

////////////////////////////////////////////////////////////////
// 饯Υѥ󤬻κɸϰ⤫Ĵ٤
// long mapX : X ɸ
// long mapY : Y ɸ
// chr_t *chr : 饯
// return : ϰ⤫
////////////////////////////////////////////////////////////////

bool PcgDun::chkDrawChr( long mapX, long mapY, chr_t *chr )
{
	if( chr == NULL )
		return false;

	if( !clip_pos( mapX, mapY ) )
		return false;
	if( !clipWin( mapX, mapY ) )
		return false;
	if( chr->kind == CHR_KIND_MNSTR )
		if( !chk_flg( chr->flg_map, FLG_MAP_CHR_FIND ) )
			return false;
	if( chk_flg_or( chr->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return false;

	Pcg *pPcg = getChrPcg( chr );

	long x1 = getChrDrawLeft( chr, pPcg, false );
	long x2 = getChrDrawRight( chr, pPcg, false );
	long y1 = getChrDrawTop( chr, pPcg, false );
	long y2 = getChrDrawBottom( chr, pPcg, false );

	long sx = getTileSizeX();
	long sy = getTileSizeY();

	if( x1 >= ((mapX + 1) * sx) )
		return false;
	if( x2 < ((mapX + 0) * sx) )
		return false;

	if( y1 >= ((mapY + 1) * sy) )
		return false;
	if( y2 < ((mapY + 0) * sy) )
		return false;

	return true;
}

////////////////////////////////////////////////////////////////
// 1 饯ʬΥեåѥ֤
// chr_t *chr : 饯
// Pcg *pPcg : ѥ
// return : 
////////////////////////////////////////////////////////////////

long PcgDun::getWidthChr( chr_t *chr, Pcg *pPcg )
{
	if( chr == NULL )
		return 0;
	if( pPcg == NULL )
		return 0;

	long n = 1;
	if( chr->kind == CHR_KIND_MBR )
		n = nPtnDirMbr;
	if( chr->kind == CHR_KIND_MNSTR )
		n = nPtnDirMnstr;

	return( pPcg->getWidth() / n );
}

////////////////////////////////////////////////////////////////
// 1 饯ʬΥեåѥι⤵֤
// chr_t *chr : 饯
// Pcg *pPcg : ѥ
// return : ⤵
////////////////////////////////////////////////////////////////

long PcgDun::getHeightChr( chr_t *chr, Pcg *pPcg )
{
	if( chr == NULL )
		return 0;
	if( pPcg == NULL )
		return 0;

	long n = 1;
	if( chr->kind == CHR_KIND_MBR )
		n = nPtnDirMbr;
	if( chr->kind == CHR_KIND_MNSTR )
		n = nPtnDirMnstr;

	return( pPcg->getHeight() / n );
}
