/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2007 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: PcgDun.h,v 1.13 2007/02/19 08:42:00 bowkenken Exp $
***************************************************************/

#ifndef PCG_DUN_H
#define PCG_DUN_H	1

////////////////////////////////////////////////////////////////
// 󥸥
////////////////////////////////////////////////////////////////

#include "misc.h"
#include "mnstr-kind.h"
#include "item.h"
#include "trap.h"
#include "party.h"
#include "mnstr.h"

#include "Pcg.h"

#ifdef D_WS
# include <WSCstring.h>
#endif //D_WS

#ifdef D_GTK
# include "GtkWSCstring.h"
#endif //D_GTK

////////////////////////////////////////////////////////////////

// ѥΥե̾γĥ
#define	STR_GRAPH_FILE_EXT	"png jpg gif bmp"

// ѥΥХꥨμ
typedef char PcgMap;

// ѥΥơ֥
struct PcgTab {
	// 󥹥ξμ
	mnstr_kind_t nMnstrKind;
	// ʸ
	char mjr, mnr;
	// ѥλȤ
	ratio_t nRatio;
	// ѥΥեΤǥ쥯ȥ
	WSCstring sDir;
};

typedef enum {
	N_PTN_DIR_CHR_1 = 1,
	N_PTN_DIR_CHR_4 = 4,
} NPtnDirChr;

////////////////////////////////////////////////////////////////

class PcgDun {
public:
	// ѥγΨ
	rate_t nTileSizeRate;

private:
	// ѥδॵ
	long nTileSizeX, nTileSizeY;

	// Ʊǥ쥯ȥˤѥΥեκ
	static const long PCG_LS_MAX_N = 4;

	// ΥѥΥХꥨκ
	static const long PCG_NULL_MAX_N = 4;
	// ΥѥΥХꥨκ
	static const long PCG_FLOOR_MAX_N = 8;
	// ɤΥѥΥХꥨκ
	static const long PCG_WALL_MAX_N = 8;
	// ʤΥѥΥХꥨκ
	static const long PCG_STAIRS_MAX_N = 4;
	// ɥΥѥΥХꥨκ
	static const long PCG_DOOR_MAX_N = 4;

	// ΥѥΥХꥨκ
	static const long PCG_CRSR_MAX_N = 1;
	// 󥫡ΥѥΥХꥨκ
	static const long PCG_SQUARE_MAX_N = 8;

	// ƥΥѥΥХꥨκ
	static const long PCG_ITEM_MAX_N = 48;
	// 櫤ΥѥΥХꥨκ
	static const long PCG_TRAP_MAX_N = TRAP_KIND_MAX_N;

	// СΥѥΥХꥨκ
	static const long PCG_MBR_MAX_N = LS_MBR_MAX_N;

	// 󥹥ΥѥΥХꥨκ
	static const long PCG_MNSTR_MAX_N = MNSTR_KIND_MAX_N;

	// Υѥ
	Pcg aNullTown[PCG_NULL_MAX_N][PCG_LS_MAX_N];
	Pcg aNullDun[PCG_NULL_MAX_N][PCG_LS_MAX_N];
	// Υѥ
	Pcg aFloorTown[PCG_FLOOR_MAX_N][PCG_LS_MAX_N];
	Pcg aFloorDun[PCG_FLOOR_MAX_N][PCG_LS_MAX_N];
	// ɤΥѥ
	Pcg aWallTown[PCG_WALL_MAX_N][PCG_LS_MAX_N];
	Pcg aWallDun[PCG_WALL_MAX_N][PCG_LS_MAX_N];
	// ʤΥѥ
	Pcg aStairsUpTown[PCG_STAIRS_MAX_N][PCG_LS_MAX_N];
	Pcg aStairsUpDun[PCG_STAIRS_MAX_N][PCG_LS_MAX_N];
	Pcg aStairsDownTown[PCG_STAIRS_MAX_N][PCG_LS_MAX_N];
	Pcg aStairsDownDun[PCG_STAIRS_MAX_N][PCG_LS_MAX_N];
	// ɥΥѥ
	Pcg aDoorCloseTown[PCG_DOOR_MAX_N][PCG_LS_MAX_N];
	Pcg aDoorCloseDun[PCG_DOOR_MAX_N][PCG_LS_MAX_N];
	Pcg aDoorOpenTown[PCG_DOOR_MAX_N][PCG_LS_MAX_N];
	Pcg aDoorOpenDun[PCG_DOOR_MAX_N][PCG_LS_MAX_N];

	// Υѥ
	Pcg aCrsr[PCG_CRSR_MAX_N][PCG_LS_MAX_N];
	Pcg aCrsrSub[PCG_CRSR_MAX_N][PCG_LS_MAX_N];
	// 󥫡ΥѥΥХꥨκ
	Pcg aSquare[PCG_SQUARE_MAX_N];

	// ƥΥѥ
	Pcg aItem[PCG_ITEM_MAX_N][PCG_LS_MAX_N];
	// 櫤Υѥ
	Pcg aTrap[PCG_TRAP_MAX_N][PCG_LS_MAX_N];

	// СΥѥ
	Pcg aMbr[PCG_MBR_MAX_N];
	// 󥹥Υѥ
	Pcg aMnstr[MNSTR_KIND_MAX_N][PCG_LS_MAX_N];

	// ѥΥե
	long nNullTownN[PCG_NULL_MAX_N];
	long nNullDunN[PCG_NULL_MAX_N];
	long nFloorTownN[PCG_FLOOR_MAX_N];
	long nFloorDunN[PCG_FLOOR_MAX_N];
	long nWallTownN[PCG_WALL_MAX_N];
	long nWallDunN[PCG_WALL_MAX_N];
	long nStairsUpTownN[PCG_STAIRS_MAX_N];
	long nStairsUpDunN[PCG_STAIRS_MAX_N];
	long nStairsDownTownN[PCG_STAIRS_MAX_N];
	long nStairsDownDunN[PCG_STAIRS_MAX_N];
	long nDoorCloseTownN[PCG_DOOR_MAX_N];
	long nDoorCloseDunN[PCG_DOOR_MAX_N];
	long nDoorOpenTownN[PCG_DOOR_MAX_N];
	long nDoorOpenDunN[PCG_DOOR_MAX_N];
	long nCrsrN[PCG_CRSR_MAX_N];
	long nCrsrSubN[PCG_CRSR_MAX_N];
	long nSquareN;
	long nItemN[PCG_ITEM_MAX_N];
	long nTrapN[PCG_TRAP_MAX_N];
	long nMnstrN[MNSTR_KIND_MAX_N];

	// ѥΥХꥨμΥޥå
	PcgMap aaMapNull[MAP_MAX_Y][MAP_MAX_X];
	PcgMap aaMapFloor[MAP_MAX_Y][MAP_MAX_X];
	PcgMap aaMapWall[MAP_MAX_Y][MAP_MAX_X];
	PcgMap aaMapStairsUp[MAP_MAX_Y][MAP_MAX_X];
	PcgMap aaMapStairsDown[MAP_MAX_Y][MAP_MAX_X];
	PcgMap aaMapDoorClose[MAP_MAX_Y][MAP_MAX_X];
	PcgMap aaMapDoorOpen[MAP_MAX_Y][MAP_MAX_X];

	// 饯θƤΥѥ
	NPtnDirChr nPtnDirMbr;
	NPtnDirChr nPtnDirMnstr;

	// 褹ɬפ륭饯Υޥå
	bool bFlgUpdate[MAP_MAX_Y][MAP_MAX_X];

	// ֥롦Хåե
	WSDmwindowDev *pWBuf;

public:
	PcgDun()
	{
		resetUpdateFlg();

		pWBuf = NULL;

		nTileSizeX = 32;
		nTileSizeY = 32;
		nTileSizeRate = _100_PERCENT;

		nPtnDirMbr = N_PTN_DIR_CHR_1;
		nPtnDirMnstr = N_PTN_DIR_CHR_1;
	}
	~PcgDun()
	{
	}

	void init();
	void reset();

	WSDmwindowDev *getWBuf();

	long getTileSizeX()
	{
		long n = nTileSizeX * nTileSizeRate / _100_PERCENT;
		if( n < 1 )
			n = 1;

		return n;
	}
	long getTileSizeY()
	{
		long n = nTileSizeY * nTileSizeRate / _100_PERCENT;
		if( n < 1 )
			n = 1;

		return n;
	}

	void scrollTile( long mapX, long mapY );
	void scrollMap( long x, long y );
	bool chkScroll( long x, long y, long w, long h );
	bool drawScroll( long x, long y, long w, long h );

	bool clipWin( long mapX, long mapY );
	bool clipWinX( long mapX );
	bool clipWinY( long mapY );
	void redraw();
	bool draw( long mapX, long mapY, long mapW, long mapH );
	void flush( long mapX, long mapY, long mapW, long mapH );

	void resetUpdateFlg();
	void setUpdateFlg( long mapX, long mapY, bool flg );
	bool getUpdateFlg( long mapX, long mapY );

	Pcg *getChrPcg( chr_t *chr );

	long getChrDrawLeft( chr_t *chr, Pcg *pPcg, bool flagPre );
	long getChrDrawRight( chr_t *chr, Pcg *pPcg, bool flagPre );
	long getChrDrawTop( chr_t *chr, Pcg *pPcg, bool flagPre );
	long getChrDrawBottom( chr_t *chr, Pcg *pPcg, bool flagPre );

private:
	void resetMap( PcgTab tab[],
			PcgMap map[MAP_MAX_Y][MAP_MAX_X] );

	bool drawTile( long mapX, long mapY, bool flgFlush );
	bool drawObj( long mapX, long mapY );
	bool drawNull( long mapX, long mapY );
	bool drawFloor( long mapX, long mapY );
	bool drawWall( long mapX, long mapY );
	bool drawStairsUp( long mapX, long mapY );
	bool drawStairsDown( long mapX, long mapY );
	bool drawDoorClose( long mapX, long mapY );
	bool drawDoorOpen( long mapX, long mapY );
	bool drawCrsrAll( long mapX, long mapY );
	bool drawCrsr( long mapX, long mapY );
	bool drawCrsrSub( long mapX, long mapY );
	bool drawSquare( long mapX, long mapY );
	bool drawItemAll( long mapX, long mapY );
	bool drawItem( long mapX, long mapY, char mjr, char mnr );
	bool drawChrList( long mapX, long mapY, bool flagOneTile );
	bool drawChr( long mapX, long mapY, chr_t *chr, Pcg *pPcg,
			bool flagOneTile );

	bool chkDrawWall( long mapX, long mapY );
	bool chkDrawCrsr( long mapX, long mapY );
	bool chkDrawCrsrSub( long mapX, long mapY );
	bool chkDrawSquare( long mapX, long mapY );
	bool chkDrawChr( long mapX, long mapY, chr_t *chr );

	long getWidthChr( chr_t *chr, Pcg *pPcg );
	long getHeightChr( chr_t *chr, Pcg *pPcg );
};

#endif /* PCG_DUN_H */
