/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2007 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: main-gtk.cpp,v 1.23 2007/02/26 00:50:37 bowkenken Exp $
***************************************************************/

////////////////////////////////////////////////////////////////
// GTK+ ѤΥᥤ
////////////////////////////////////////////////////////////////

#define	MAIN_GTK_CPP
#include "inc.h"

////////////////////////////////////////////////////////////////

#define	TILE_X_SIZE	(gPcgDun.getTileSizeX())
#define	TILE_Y_SIZE	(gPcgDun.getTileSizeY())

#define	MAP_PIX_MAX_X	(MAP_MAX_X * TILE_X_SIZE)
#define	MAP_PIX_MAX_Y	(MAP_MAX_Y * TILE_Y_SIZE)

#define	MAP_WIN_INIT_WIDTH	(20 * TILE_X_SIZE)
#define	MAP_WIN_INIT_HEIGHT	(20 * TILE_Y_SIZE)

////////////////////////////////////////////////////////////////

GtkWidget *btnMapExec;

////////////////////////////////////////////////////////////////
// ᥤ󡦥롼
// int argc : ο
// char **argv : Υꥹ
// return : λ
////////////////////////////////////////////////////////////////

int	main( int argc, char **argv )
{
	init_arg();

	g_flg_gui = TRUE;

#if	defined( NDEBUG )
	g_flg_cui = FALSE;
#elif	defined( DEBUG )
	g_flg_cui = TRUE;
#else
	g_flg_cui = FALSE;
#endif

	// ᥤν

	chk_arg( argc, argv );
	init_game();

	if( g_flg_gui ){
		init_gtk_win( argc, argv );

		if( !call_game_thread_create( main_thread ) )
			return EXIT_FAILURE;

		// ᥤν򤷤ʤ

		gPcgDun.reset();
		chk_scroll( TRUE );
		redraw_all();

		// GUI Υᥤ󡦥롼פ򳫻

		gtk_main();
	} else {
		// CUI Υᥤ󡦥롼פ򳫻

		game_main();
	}

	close_game( EXIT_SUCCESS );
	gtk_exit( EXIT_SUCCESS );
	return EXIT_SUCCESS;
}

////////////////////////////////////////////////////////////////
// GTK+ ν
// int argc : ο
// char **argv : Υꥹ
////////////////////////////////////////////////////////////////

void	init_gtk_win( int argc, char **argv )
{
	GtkAttachOptions xOpt, yOpt;

	// GTK+ 

	g_thread_init( NULL );
	gdk_threads_init();

	gtk_init( &argc, &argv );

	gdk_rgb_init();

	gPcgDun.nTileSizeRate = g_graph_scale_rate;

	// ᥤ󡦥ɥ

	gMapWin = gtk_window_new( GTK_WINDOW_TOPLEVEL );
	if( gMapWin == NULL ){
		print_msg( FLG_MSG_ERR, "gtk_window_new()" );
		exit_game( EXIT_FAILURE );
	}

	GtkWidget *vBox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( gMapWin ), vBox );
	gtk_widget_show( vBox );

	// ᥤ󡦥ɥؤΥ٥ȡϥɥ

	gtk_signal_connect( GTK_OBJECT( gMapWin ),
			"delete_event",
			GTK_SIGNAL_FUNC( handle_delete ),
			NULL );
	gtk_signal_connect( GTK_OBJECT( gMapWin ),
			"destroy",
			GTK_SIGNAL_FUNC( handle_destroy ),
			NULL );

	// ġ롦С

	GtkWidget *handleBox = gtk_handle_box_new();
	gtk_box_pack_start( GTK_BOX( vBox ), handleBox, FALSE, FALSE, 0 );
	gtk_widget_show( handleBox );

	GtkWidget *toolBar = gtk_toolbar_new();
	gtk_toolbar_set_orientation( GTK_TOOLBAR( toolBar ),
			GTK_ORIENTATION_HORIZONTAL );
	gtk_toolbar_set_style( GTK_TOOLBAR( toolBar ),
			GTK_TOOLBAR_ICONS );
	gtk_widget_show( toolBar );

	gtk_container_add( GTK_CONTAINER( handleBox ), toolBar );

	// ġ롦СΥܥ

	btnMapExec = gtk_button_new_with_label(
			MSG_GUI_MAP_EXEC );
	gMapButtonContExec = gtk_toggle_button_new_with_label(
			MSG_GUI_MAP_CONT_EXEC );

	gtk_toggle_button_set_active(
			GTK_TOGGLE_BUTTON( gMapButtonContExec ), FALSE );

	gtk_toolbar_append_widget( GTK_TOOLBAR( toolBar ),
			btnMapExec,
			MSG_GUI_MAP_TOOL_TIP_EXEC,
			NULL );
	gtk_toolbar_append_widget( GTK_TOOLBAR( toolBar ),
			gMapButtonContExec,
			MSG_GUI_MAP_TOOL_TIP_CONT_EXEC,
			NULL );

	gtk_widget_show( btnMapExec );
	gtk_widget_show( gMapButtonContExec );

	// ġ롦СؤΥ٥ȡϥɥ

	gtk_signal_connect( GTK_OBJECT( btnMapExec ),
			"clicked",
			GTK_SIGNAL_FUNC( handle_exec_clicked ),
			NULL );
	gtk_signal_connect( GTK_OBJECT( gMapButtonContExec ),
			"toggled",
			GTK_SIGNAL_FUNC( handle_cont_exec_toggled ),
			NULL );

	// 襨ꥢ

	GtkWidget *pTab = gtk_table_new( 2, 2, FALSE );
	gtk_box_pack_start( GTK_BOX( vBox ), pTab, TRUE, TRUE, 0 );
	gtk_widget_show( pTab );

	gMapDrawingArea = gtk_drawing_area_new();
	if( gMapDrawingArea == NULL ){
		print_msg( FLG_MSG_ERR, "gtk_drawing_area_new()" );
		exit_game( EXIT_FAILURE );
	}
	gtk_drawing_area_size( GTK_DRAWING_AREA( gMapDrawingArea ),
			MAP_WIN_INIT_WIDTH, MAP_WIN_INIT_HEIGHT );
	xOpt = (GtkAttachOptions)(GTK_EXPAND | GTK_SHRINK | GTK_FILL);
	yOpt = (GtkAttachOptions)(GTK_EXPAND | GTK_SHRINK | GTK_FILL);
	gtk_table_attach( GTK_TABLE( pTab ), gMapDrawingArea,
			0, 1, 0, 1,
			xOpt, yOpt,
			0, 0 );
	gtk_widget_show( gMapDrawingArea );

	// 襨ꥢؤΥ٥ȡϥɥ

	gtk_signal_connect( GTK_OBJECT( gMapDrawingArea ),
			"expose_event",
			GTK_SIGNAL_FUNC( handle_map_expose ),
			NULL );
	gtk_signal_connect( GTK_OBJECT( gMapDrawingArea ),
			"configure_event",
			GTK_SIGNAL_FUNC( handle_map_configure ),
			NULL );

	// 襨ꥢΥޥ⡼Υ٥ȡϥɥ

	gtk_signal_connect( GTK_OBJECT( gMapDrawingArea ),
			"motion_notify_event",
			GTK_SIGNAL_FUNC( handle_map_motion_notify ),
			NULL );
	gtk_signal_connect( GTK_OBJECT( gMapDrawingArea ),
			"button_press_event",
			GTK_SIGNAL_FUNC( handle_map_button_press ),
			NULL );
	gtk_signal_connect( GTK_OBJECT( gMapDrawingArea ),
			"button_release_event",
			GTK_SIGNAL_FUNC( handle_map_button_release ),
			NULL );
	gtk_widget_set_events(
			gMapDrawingArea,
			(GDK_EXPOSURE_MASK
//@@@			| GDK_LEAVE_NOTIFY_MASK
			| GDK_BUTTON_PRESS_MASK
			| GDK_BUTTON_RELEASE_MASK
			| GDK_POINTER_MOTION_MASK
			| GDK_POINTER_MOTION_HINT_MASK) );

	// ʿ롦СĴ

	gMapHScrollBarAdjustment = gtk_adjustment_new(
			0,
			0, MAP_PIX_MAX_Y,
			1 * TILE_Y_SIZE,
			AREA_MAX_Y * TILE_Y_SIZE / 2,
			AREA_MAX_Y * TILE_Y_SIZE );
	if( gMapHScrollBarAdjustment == NULL ){
		print_msg( FLG_MSG_ERR, "gtk_adjustment_new()" );
		exit_game( EXIT_FAILURE );
	}

	// ʿ롦СĴΥ٥ȡϥɥ

	gtk_signal_connect( GTK_OBJECT( gMapHScrollBarAdjustment ),
			"changed",
			GTK_SIGNAL_FUNC( handle_map_scroll_changed ),
			NULL );
	gtk_signal_connect( GTK_OBJECT( gMapHScrollBarAdjustment ),
			"value_changed",
			GTK_SIGNAL_FUNC( handle_map_scroll_changed ),
			NULL );

	// ʿ롦С

	gMapHScrollBar = gtk_hscrollbar_new(
			GTK_ADJUSTMENT( gMapHScrollBarAdjustment ) );
	if( gMapHScrollBar == NULL ){
		print_msg( FLG_MSG_ERR, "gtk_hscrollbar_new()" );
		exit_game( EXIT_FAILURE );
	}
	xOpt = (GtkAttachOptions)(GTK_SHRINK | GTK_FILL);
	yOpt = (GtkAttachOptions)(GTK_FILL);
	gtk_table_attach( GTK_TABLE( pTab ),
			gMapHScrollBar,
			0, 1, 1, 2,
			xOpt, yOpt,
			0, 0 );
	gtk_widget_show( gMapHScrollBar );

	// ľ롦СĴ

	gMapVScrollBarAdjustment = gtk_adjustment_new(
			0,
			0, MAP_PIX_MAX_X,
			1 * TILE_X_SIZE,
			AREA_MAX_X * TILE_X_SIZE / 2,
			AREA_MAX_X * TILE_X_SIZE );
	if( gMapVScrollBarAdjustment == NULL ){
		print_msg( FLG_MSG_ERR, "gtk_adjustment_new()" );
		exit_game( EXIT_FAILURE );
	}

	// ľ롦СĴΥ٥ȡϥɥ

	gtk_signal_connect( GTK_OBJECT( gMapVScrollBarAdjustment ),
			"changed",
			GTK_SIGNAL_FUNC( handle_map_scroll_changed ),
			NULL );
	gtk_signal_connect( GTK_OBJECT( gMapVScrollBarAdjustment ),
			"value_changed",
			GTK_SIGNAL_FUNC( handle_map_scroll_changed ),
			NULL );

	// ľ롦С

	gMapVScrollBar = gtk_vscrollbar_new(
			GTK_ADJUSTMENT( gMapVScrollBarAdjustment ) );
	if( gMapVScrollBar == NULL ){
		print_msg( FLG_MSG_ERR, "gtk_vscrollbar_new()" );
		exit_game( EXIT_FAILURE );
	}
	xOpt = (GtkAttachOptions)(GTK_FILL);
	yOpt = (GtkAttachOptions)(GTK_SHRINK | GTK_FILL);
	gtk_table_attach( GTK_TABLE( pTab ),
			gMapVScrollBar,
			1, 2, 0, 1,
			xOpt, yOpt,
			0, 0 );
	gtk_widget_show( gMapVScrollBar );

	// ᥤ󡦥ɥɽ

	gtk_widget_show( gMapWin );

	// ֥롦Хåե

#if	0
//@@@
	gPcgDun.getWBuf() = gdk_pixmap_new(
			gMapWin->window,
			MAP_PIX_MAX_X,
			MAP_PIX_MAX_Y,
			-1 );
#endif

	// ץ饤Ȥ

	// ե졼ࡦ졼Ȥ

#if	0
	gtk_timeout_add( 1000 * 1 / 60, handle_map_redraw,
			gMapDrawingArea );
#elif	0
	gtk_timeout_add( 1000 * 20 / 60, handle_map_redraw,
			gMapDrawingArea );
#else
//@@@
#endif

	// Ƽ

	gPcgDun.init();
	gGuiMenu.init();
	gGuiMessage.init();
	gGuiStat.init();
	gKey.init();
	initMouseMotionFunc();

	gPcgDun.redraw();
}

////////////////////////////////////////////////////////////////
// GTK+ νλ׵Υϥɥ
////////////////////////////////////////////////////////////////

gint	handle_delete(
	GtkWidget *widget, GdkEvent *event, gpointer user_data
)
{
	gKey.setChar( 'Q', TRUE );

	return TRUE;
}

////////////////////////////////////////////////////////////////
// GTK+ νλΥϥɥ
////////////////////////////////////////////////////////////////

void	handle_destroy(
	GtkWidget *widget, gpointer user_data
)
{
	gtk_main_quit();
}

////////////////////////////////////////////////////////////////
// ޥåסɥ襤٥Ȥν
// GtkWidget *widget : ޥåפΥɥ󥰡ꥢ
// GdkEventExpose *event : ٥
// return : ?
////////////////////////////////////////////////////////////////

gint	handle_map_expose( GtkWidget *widget, GdkEventExpose *event )
{
	GtkAdjustment *hAdj = GTK_ADJUSTMENT( gMapHScrollBarAdjustment );
	GtkAdjustment *vAdj = GTK_ADJUSTMENT( gMapVScrollBarAdjustment );

	long srcX = (long)(hAdj->value + event->area.x);
	long srcY = (long)(vAdj->value + event->area.y);
	long dstX = (long)event->area.x;
	long dstY = (long)event->area.y;
	long w = (long)event->area.width;
	long h = (long)event->area.height;

	// طʤ

	GdkGC *gc = gMapDrawingArea->style->fg_gc[GTK_STATE_NORMAL];

	gdk_draw_pixmap(
			gMapDrawingArea->window,
			gc,
			gPcgDun.getWBuf()->getPixMap(),
			srcX, srcY,
			dstX, dstY,
			w, h );
	return TRUE;
}

////////////////////////////////////////////////////////////////
// ޥåסɥΥѹ٥Ȥν
// GtkWidget *widget : ޥåפΥɥ󥰡ꥢ
// GdkEventConfigure *event : ٥
// return : ?
////////////////////////////////////////////////////////////////

gint	handle_map_configure( GtkWidget *widget, GdkEventConfigure *event )
{
	// ʿ롦СĴ

	long w = gMapDrawingArea->allocation.width;
	GtkAdjustment *hAdj = GTK_ADJUSTMENT( gMapHScrollBarAdjustment );

	hAdj->lower = 0;
	hAdj->upper = MAP_MAX_X * gPcgDun.getTileSizeX();
	hAdj->step_increment = 1 * gPcgDun.getTileSizeX();
	hAdj->page_increment = w / 2;
	hAdj->page_size = w;
	if( hAdj->value > hAdj->upper - w )
		hAdj->value = hAdj->upper - w;

	gtk_adjustment_changed( hAdj );

	// ľ롦СĴ

	long h = gMapDrawingArea->allocation.height;
	GtkAdjustment *vAdj = GTK_ADJUSTMENT( gMapVScrollBarAdjustment );

	vAdj->lower = 0;
	vAdj->upper = MAP_MAX_Y * gPcgDun.getTileSizeY();
	vAdj->step_increment = 1 * gPcgDun.getTileSizeY();
	vAdj->page_increment = h / 2;
	vAdj->page_size = h;
	if( vAdj->value > vAdj->upper - h )
		vAdj->value = vAdj->upper - h;

	gtk_adjustment_changed( vAdj );

	//

	return TRUE;
}

////////////////////////////////////////////////////////////////
// 롦С٥Ȥν
// GtkAdjustment *adjustment : ʿľ롦СĴ
// gpointer user_data : ϿϤ줿ǡ
////////////////////////////////////////////////////////////////

void	handle_map_scroll_changed(
	GtkAdjustment *adjustment,
	gpointer user_data
)
{
	if( !g_flg_gui )
		return;

	GtkAdjustment *hAdj = GTK_ADJUSTMENT( gMapHScrollBarAdjustment );
	GtkAdjustment *vAdj = GTK_ADJUSTMENT( gMapVScrollBarAdjustment );

	long x = (long)hAdj->value;
	long y = (long)vAdj->value;
	long w = (long)hAdj->page_size;
	long h = (long)vAdj->page_size;

	gPcgDun.drawScroll( x, y, w, h );
}

////////////////////////////////////////////////////////////////
// ޥåסɥΥޡν
// gpointer p : ޥåפΥɥ󥰡ꥢ
// return : ?
////////////////////////////////////////////////////////////////

gint	handle_map_redraw( gpointer p )
{
	GtkWidget *drawingArea = (GtkWidget *)p;
	GdkGC *gc = drawingArea->style->fg_gc[GTK_STATE_NORMAL];

	GtkAdjustment *hAdj = GTK_ADJUSTMENT( gMapHScrollBarAdjustment );
	GtkAdjustment *vAdj = GTK_ADJUSTMENT( gMapVScrollBarAdjustment );

	long x = (long)hAdj->value;
	long y = (long)vAdj->value;
	long w = (long)hAdj->page_size;
	long h = (long)vAdj->page_size;

	// طʤ

	gdk_draw_pixmap(
			drawingArea->window,
			gc,
			gPcgDun.getWBuf()->getPixMap(),
			x, y,
			0, 0,
			w, h );

	return TRUE;
}

////////////////////////////////////////////////////////////////
// ޥåסɥΥޥ⡼Υ٥Ƚ
// GtkWidget *widget : ޥåפΥɥ󥰡ꥢ
// GdkEventMotion *event : ٥
// return : ?
////////////////////////////////////////////////////////////////

gint	handle_map_motion_notify(
	GtkWidget *widget, GdkEventMotion *event
)
{
	gint x = 0;
	gint y = 0;
	GdkModifierType state = (GdkModifierType)0;

	if( event->is_hint ){
		gdk_window_get_pointer( event->window, &x, &y, &state );
	} else {
		x = (gint)(event->x);
		y = (gint)(event->y);
		state = (GdkModifierType)(event->state);
	}

	gMouseMotion.move( x, y );

	return TRUE;
}

////////////////////////////////////////////////////////////////
// ޥåסɥμ¹ԥܥΥå٥Ƚ
// GtkWidget *widget : ܥ
// gpointer data : ϿϤ줿ǡ
////////////////////////////////////////////////////////////////

void	handle_exec_clicked(
	GtkWidget *widget, gpointer *data
)
{
	gKey.setChar( '.', TRUE );
}

////////////////////////////////////////////////////////////////
// ޥåסɥϢ³¹ԥܥΥȥ롦٥Ƚ
// GtkToggleButton *togglebutton : 
// gpointer user_data : ϿϤ줿ǡ
////////////////////////////////////////////////////////////////

void	handle_cont_exec_toggled(
	GtkToggleButton *btn,
	gpointer user_data
)
{
	bool_t flg = gtk_toggle_button_get_active( btn );
	if( !flg == !chk_continue_exec_mode() )
		return;

	if( gtk_toggle_button_get_active( btn ) )
		gKey.setChar( ',', FALSE );
	else
		gKey.setChar( '|', FALSE );
}

////////////////////////////////////////////////////////////////
// ޥåסɥΥޥץ쥹٥Ƚ
// GtkWidget *widget : ޥåפΥɥ󥰡ꥢ
// GdkEventMotion *event : ٥
// return : ?
////////////////////////////////////////////////////////////////

gint	handle_map_button_press(
	GtkWidget *widget, GdkEventMotion *event
)
{
	gint x = 0;
	gint y = 0;
	GdkModifierType state = (GdkModifierType)0;

	if( event->is_hint ){
		gdk_window_get_pointer( event->window, &x, &y, &state );
	} else {
		x = (gint)(event->x);
		y = (gint)(event->y);
		state = (GdkModifierType)(event->state);
	}

	if( state & (GDK_BUTTON1_MASK | GDK_BUTTON2_MASK
			| GDK_BUTTON3_MASK | GDK_BUTTON4_MASK
			| GDK_BUTTON5_MASK) ){
		GtkAdjustment *hAdj = GTK_ADJUSTMENT(
				gMapHScrollBarAdjustment );
		GtkAdjustment *vAdj = GTK_ADJUSTMENT(
				gMapVScrollBarAdjustment );
		gMapDragBgnX = (long)hAdj->value;
		gMapDragBgnY = (long)vAdj->value;
	}

	if( state & GDK_BUTTON1_MASK )
		gMouseMotion.begin( MouseMotion::nMouseButton0, x, y );
	if( state & GDK_BUTTON2_MASK )
		gMouseMotion.begin( MouseMotion::nMouseButton1, x, y );
	if( state & GDK_BUTTON3_MASK )
		gMouseMotion.begin( MouseMotion::nMouseButton2, x, y );
	if( state & GDK_BUTTON4_MASK )
		gMouseMotion.begin( MouseMotion::nMouseButton3, x, y );
	if( state & GDK_BUTTON5_MASK )
		gMouseMotion.begin( MouseMotion::nMouseButton4, x, y );

	return TRUE;
}

////////////////////////////////////////////////////////////////
// ޥåסɥΥޥ꡼٥Ƚ
// GtkWidget *widget : ޥåפΥɥ󥰡ꥢ
// GdkEventMotion *event : ٥
// return : ?
////////////////////////////////////////////////////////////////

gint	handle_map_button_release(
	GtkWidget *widget, GdkEventMotion *event
)
{
	gint x = 0;
	gint y = 0;
	GdkModifierType state = (GdkModifierType)0;

	if( event->is_hint ){
		gdk_window_get_pointer( event->window, &x, &y, &state );
	} else {
		x = (gint)(event->x);
		y = (gint)(event->y);
		state = (GdkModifierType)(event->state);
	}

	if( !(state & GDK_BUTTON1_MASK) )
		gMouseMotion.end( MouseMotion::nMouseButton0, x, y );
	if( !(state & GDK_BUTTON2_MASK) )
		gMouseMotion.end( MouseMotion::nMouseButton1, x, y );
	if( !(state & GDK_BUTTON3_MASK) )
		gMouseMotion.end( MouseMotion::nMouseButton2, x, y );
	if( !(state & GDK_BUTTON4_MASK) )
		gMouseMotion.end( MouseMotion::nMouseButton3, x, y );
	if( !(state & GDK_BUTTON5_MASK) )
		gMouseMotion.end( MouseMotion::nMouseButton4, x, y );

	gMapDragBgnX = -1;
	gMapDragBgnY = -1;

	return TRUE;
}

////////////////////////////////////////////////////////////////
// ¸ɸ˥ɥɽ
// GtkWidget *widget : ɥ
// gint *nPreX : X ɸ¸
// gint *nPreY : Y ɸ¸
////////////////////////////////////////////////////////////////

void	showWin(
	GtkWidget *mMenuWin,
	gint *nPreX, gint *nPreY,
	gint *nPreW, gint *nPreH
)
{
	if( mMenuWin == NULL )
		return;

	if( !GTK_WIDGET_VISIBLE( mMenuWin ) ){
		if( (nPreX != NULL) && (nPreY != NULL)
				&& (*nPreX > -1) && (*nPreY > -1) ){
			gtk_widget_set_uposition(
					mMenuWin, *nPreX, *nPreY );
		}
	}

	if( (nPreW != NULL) && (nPreH != NULL)
			&& (*nPreW > -1) && (*nPreH > -1) ){
		mMenuWin->allocation.width = *nPreW;
		mMenuWin->allocation.height = *nPreH;
		gtk_widget_set_size_request(
				mMenuWin, *nPreW, *nPreH );
	}

	gtk_widget_show( mMenuWin );
}

////////////////////////////////////////////////////////////////
// ɥκɸ¸Ĥ
// GtkWidget *widget : ɥ
// gint *nPreX : X ɸ¸
// gint *nPreY : Y ɸ¸
////////////////////////////////////////////////////////////////

void	wipeWin(
	GtkWidget *mMenuWin,
	gint *nPreX, gint *nPreY,
	gint *nPreW, gint *nPreH
)
{
	if( mMenuWin == NULL )
		return;

	if( (nPreX != NULL) && (nPreY != NULL) ){
		gint bgnX, bgnY, endX, endY;

		gdk_window_get_position( mMenuWin->window,
				nPreX, nPreY );
		gdk_window_get_root_origin( mMenuWin->window,
				&bgnX, &bgnY );
		gdk_window_get_origin( mMenuWin->window,
				&endX, &endY );

		*nPreX -= endX - bgnX;
		*nPreY -= endY - bgnY;
	}

	if( nPreW != NULL )
		*nPreW = mMenuWin->allocation.width;
	if( nPreH != NULL )
		*nPreH = mMenuWin->allocation.height;

	gtk_widget_hide( mMenuWin );
}
