/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2007 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: msg.c,v 1.31 2007/03/12 18:39:54 bowkenken Exp $
***************************************************************/

/***************************************************************
* å
***************************************************************/

#define	MSG_C
#include	"inc.h"

/***************************************************************/

#define	STR_S	"%s"
#define	STR_ENV_LANG	"LANG"
#define	STR_SUPPORT_LANG	"Supporting language is:"
#define	STR_SUPPORT_LANG_LIST	"\t`%s'\n"
#define	STR_ERR_LANG	"Don't support language: LANG=%s"
#define	STR_ERR_REDEFINED_MSG	"Redefined message data: LANG=%s %ld `%s'"
#define	STR_ERR_NOT_DEFINED_MSG	"Don't defined message data: LANG=%s %ld"

/***************************************************************
* ̾
***************************************************************/

#ifdef	D_DOS
# define	STR_LANG_NAME_ENGLISH	"English"
# define	STR_LANG_NAME_JAPANESE_EUC	"Japanese"
# define	STR_LANG_NAME_JAPANESE_UTF_8	"Japanese"
# define	STR_LANG_NAME_JAPANESE_SJIS	"Japanese"
#else	/* D_DOS */
# define	STR_LANG_NAME_ENGLISH	"English"
# define	STR_LANG_NAME_JAPANESE_EUC	"Japanese (EUC)"
# define	STR_LANG_NAME_JAPANESE_UTF_8	"Japanese (UTF-8)"
# define	STR_LANG_NAME_JAPANESE_SJIS	"Japanese (Shift-JIS)"
#endif	/* D_DOS */

/***************************************************************
* 
***************************************************************/

/* ơ֥κ */
#define	LANG_TAB_MAX_N	64
/* ǥեȤθ */
#define	STR_DFLT_LANG	"ja_JP.eucJP"

/* μ */
static lang_kind_t	g_lang_kind, g_lang_kind_next;
/* ͥ褹 */
static bool_t	g_flg_lang_ls_priority;

/* Υǡ */
typedef struct {
	char	*id;
	char	*name;
	lang_kind_t	kind;
} lang_t;

/* Υǡ */
static lang_t	lang_tab[LANG_TAB_MAX_N] = {
	{
		"C",
		STR_LANG_NAME_ENGLISH,
		LANG_KIND_ENGLISH,
	},
	{
		"ja_JP.eucJP",
		STR_LANG_NAME_JAPANESE_EUC,
		LANG_KIND_JAPANESE_EUC,
	},
	{
		"ja_JP.ujis",
		STR_LANG_NAME_JAPANESE_EUC,
		LANG_KIND_JAPANESE_EUC,
	},
	{
		"ja_JP.UTF-8",
		STR_LANG_NAME_JAPANESE_UTF_8,
		LANG_KIND_JAPANESE_UTF_8,
	},
	{
		"ja_JP.SJIS",
		STR_LANG_NAME_JAPANESE_SJIS,
		LANG_KIND_JAPANESE_SJIS,
	},
	{
		NULL,
		NULL,
		LANG_KIND_MAX_N,
	},
};

/***************************************************************
* å
***************************************************************/

/* åơ֥Υǡ */

typedef struct {
	n_msg_t	n;
	char	*s;
} msg_t;

/* åơ֥ */

static msg_t	all_lang_msg[LANG_KIND_MAX_N][N_MSG_MAX_N] = {
	{
#include	"msg-eng.h"
	},
	{
#ifdef	D_DOS
# include	"msg-jpn-sjis.h"
#else	/* D_DOS */
# include	"msg-jpn.h"
#endif	/* D_DOS */
	},
	{
#ifdef	D_DOS
# include	"msg-jpn-sjis.h"
#else	/* D_DOS */
# include	"msg-jpn-utf8.h"
#endif	/* D_DOS */
	},
	{
#include	"msg-jpn-sjis.h"
	},
};

/* åƤʤåѤΥǡ */
static bool_t	flg_msg_def[N_MSG_MAX_N];

/***************************************************************
* åν
***************************************************************/

void	init_msg( void )
{
	bool_t	flg_exit;
	char	*lang;
	long	lang_tab_kind;
	long	m;
	long	k;
	long	i;

	flg_exit = FALSE;

	/* Ķѿθͤ */

	lang = getenv( STR_ENV_LANG );
	if( lang == NULL )
		lang = STR_DFLT_LANG;

	/* Ķѿǻꤵ줿μõ */

	g_lang_kind = LANG_KIND_MAX_N;
	lang_tab_kind = 0;
	for( k = 0; k < LANG_TAB_MAX_N; k++ ){
		if( lang_tab[k].id == NULL )
			break;

		if( strcmp( lang, lang_tab[k].id ) == 0 ){
			g_lang_kind = lang_tab[k].kind;
			lang_tab_kind = k;
			break;
		}
	}
	g_lang_kind_next = g_lang_kind;

	/* ꤵ줿줬Ĥʤä饨顼λ */

	if( g_lang_kind >= LANG_KIND_MAX_N ){
		print_err( STR_ERR_LANG, lang );
		print_err( STR_S, STR_SUPPORT_LANG );
		for( k = 0; k < LANG_TAB_MAX_N; k++ ){
			if( lang_tab[k].id == NULL )
				break;

			fprintf( stderr, STR_SUPPORT_LANG_LIST,
					lang_tab[k].id );
		}
		fprintf( stderr, "\n" );
		exit_game( EXIT_FAILURE );
	}

	for( m = 0; m < N_MSG_MAX_N; m++ )
		flg_msg_def[m] = FALSE;

	/* åƤʤå */

	for( i = 0; i < N_MSG_MAX_N; i++ ){
		if( all_lang_msg[g_lang_kind][i].s == NULL )
			break;

		m = all_lang_msg[g_lang_kind][i].n;
		if( flg_msg_def[m] ){
			char	*s;

			/* åƤ */
			s = all_lang_msg[g_lang_kind][m].s;
			print_err( STR_ERR_REDEFINED_MSG,
					lang_tab[lang_tab_kind].id, m, s );
			flg_exit = TRUE;
		}

		/* å򥳥ԡ */
		ary_msg[m] = all_lang_msg[g_lang_kind][i].s;
		flg_msg_def[m] = TRUE;
	}

	/* åƤ뤫å */

	for( m = 0; m < N_MSG_MAX_N; m++ ){
		if( !flg_msg_def[m] ){
			/* åƤʤ */
			print_err( STR_ERR_NOT_DEFINED_MSG,
					lang_tab[lang_tab_kind].id, m );
			flg_exit = TRUE;
		}
	}

	if( flg_exit )
		exit_game( EXIT_FAILURE );
}

/***************************************************************
* åθ
* lang_kind_t kind : μ
***************************************************************/

void	reset_msg( lang_kind_t kind )
{
	n_msg_t	m;
	long	i;

	if( kind < 0 )
		return;
	if( kind >= LANG_KIND_MAX_N )
		return;

	g_lang_kind = kind;
	g_lang_kind_next = kind;

	for( i = 0; i < N_MSG_MAX_N; i++ ){
		if( all_lang_msg[g_lang_kind][i].s == NULL )
			break;

		m = all_lang_msg[g_lang_kind][i].n;
		ary_msg[m] = all_lang_msg[g_lang_kind][i].s;
	}
}

/***************************************************************
* μ֤
* return : μ
***************************************************************/

lang_kind_t	get_lang_kind( void )
{
	return g_lang_kind;
}

/***************************************************************
* Ƽ¹Ըͭˤʤμ֤
* return : μ
***************************************************************/

lang_kind_t	get_lang_kind_next( void )
{
	return g_lang_kind_next;
}

/***************************************************************
* Ƽ¹Ըͭˤʤμ
* lang_kind_t kind : μ
* return : μ
***************************************************************/

lang_kind_t	set_lang_kind_next( lang_kind_t kind )
{
	g_lang_kind_next = kind;

	return g_lang_kind_next;
}

/***************************************************************
* Ƽ¹Ըͭˤʤ ID ֤
* return :  ID
***************************************************************/

char	*get_lang_id_next( void )
{
	long	k;

	for( k = 0; k < LANG_TAB_MAX_N; k++ ){
		if( lang_tab[k].id == NULL )
			break;

		if( lang_tab[k].kind == g_lang_kind_next ){
			return( lang_tab[k].id );
		}
	}

	return( lang_tab[0].id );
}

/***************************************************************
* ͥ褹뤫֤
* return : ͥ褹뤫?
***************************************************************/

bool_t	get_flg_lang_ls_priority( void )
{
	return g_flg_lang_ls_priority;
}

/***************************************************************
* ͥ褹뤫
* bool_t flg : ͥ褹뤫?
* return : ͥ褹뤫?
***************************************************************/

bool_t	set_flg_lang_ls_priority( bool_t flg )
{
	g_flg_lang_ls_priority = flg;

	return g_flg_lang_ls_priority;
}

/***************************************************************
* μफ֤̾
* lang_kind_t kind : μ
* return : ̾
***************************************************************/

char	*get_lang_kind_name( lang_kind_t kind )
{
	long	i;

	if( kind < 0 )
		return MSG_NULL;
	if( kind >= LANG_KIND_MAX_N )
		return MSG_NULL;

	for( i = 0; i < LANG_TAB_MAX_N; i++ ){
		if( lang_tab[i].id == NULL )
			break;

		if( lang_tab[i].kind == kind ){
			return( lang_tab[i].name );
		}
	}

	return MSG_NULL;
}

/***************************************************************
*  ID ֤
* char *id :  ID
* return : μ
***************************************************************/

lang_kind_t	trans_lang_id_to_kind( char *id )
{
	long	k;

	for( k = 0; k < LANG_TAB_MAX_N; k++ ){
		if( lang_tab[k].id == NULL )
			break;

		if( strcmp( id, lang_tab[k].id ) == 0 ){
			return( lang_tab[k].kind );
		}
	}

	return LANG_KIND_JAPANESE_EUC;
}

/***************************************************************
* ʸɽʸ֤
* const char *s : ʸ
* return : ʸ
***************************************************************/

long	str_len_draw( const char *s )
{
#ifdef	D_DOS

	return( (long)strlen( s ) );

#else	/* D_DOS */

	switch( get_lang_kind() ){
	case LANG_KIND_ENGLISH:
		return str_len_draw_english( s );
	case LANG_KIND_JAPANESE_EUC:
		return str_len_draw_japanese_euc( s );
	case LANG_KIND_JAPANESE_UTF_8:
		return str_len_draw_japanese_utf_8( s );
	case LANG_KIND_JAPANESE_SJIS:
		return str_len_draw_japanese_sjis( s );
	case LANG_KIND_MAX_N:
		break;
	}

	return( (long)strlen( s ) );

#endif	/* D_DOS */
}

/***************************************************************
* Ѹʸɽʸ֤
* const char *s : ʸ
* return : ʸ
***************************************************************/

long	str_len_draw_english( const char *s )
{
	return( (long)strlen( s ) );
}

/***************************************************************
* ܸ(EUC)ʸɽʸ֤
* const char *s : ʸ
* return : ʸ
***************************************************************/

long	str_len_draw_japanese_euc( const char *s )
{
	long	len;

	for( len = 0; *s != '\0'; len++, s++ ){
		unsigned char	c;

		c = (unsigned char)*s;
		if( (0x80 <= c) && (c <= 0x9f) )
			len--;
	}

	return len;
}

/***************************************************************
* ܸ(UTF-8)ʸɽʸ֤
* const char *s : ʸ
* return : ʸ
***************************************************************/

long	str_len_draw_japanese_utf_8( const char *s )
{
	long	len;
	unsigned char	c;
	long	skip_n;
	long	i;

	len = 0;
	for( ; *s != '\0'; s++ ){
		c = (unsigned char)*s;
		skip_n = 0;

		if( (c & 0x80) == 0x00 ){
			len++;
			continue;
		} else if( (c & 0xe0) == 0xc0 ){
			skip_n = 2;
		} else if( (c & 0xf0) == 0xe0 ){
			skip_n = 3;
		} else if( (c & 0xf8) == 0xf0 ){
			skip_n = 4;
		} else if( (c & 0xfc) == 0xf8 ){
			skip_n = 5;
		} else if( (c & 0xfe) == 0xfc ){
			skip_n = 6;
		}

		len += 2;
		s++;
		for( i = 1; i < skip_n; i++ ){
			if( *s == '\0' ){
				s--;
				break;
			}
			if( (c & 0xc0) != 0x80 ){
				s--;
				break;
			}

			s++;
		}
	}

	return len;
}

/***************************************************************
* ܸ(Shift-JIS)ʸɽʸ֤
* const char *s : ʸ
* return : ʸ
***************************************************************/

long	str_len_draw_japanese_sjis( const char *s )
{
	long	len;

	for( len = 0; *s != '\0'; len++, s++ )
		;

	return len;
}

