/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2007 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: gmain.c,v 1.99 2007/12/24 16:36:55 bowkenken Exp $
***************************************************************/

/***************************************************************
* ᥤ
***************************************************************/

#define	EXTERN

#define	GMAIN_C
#include	"inc.h"

/***************************************************************
* 
***************************************************************/

#define	STR_ENV_SHELL	"SHELL"

#ifdef	D_DOS
# define	STR_DFLT_SHELL	"command"
#else	/* D_DOS */
# define	STR_DFLT_SHELL	"sh"
#endif	/* D_DOS */

/***************************************************************
* Ԥ
***************************************************************/

#define	KEY_WAIT_VMIN	0
#define	KEY_WAIT_VTIME	1

/***************************************************************
* ѿ
***************************************************************/

static long	flg_term;

#if	HAVE_TERMIOS_H
static struct termios	pre_tbuf;
#elif	HAVE_TERMIO_H
static struct termio	pre_tbuf;
#endif

/***************************************************************
* 
***************************************************************/

#define	OPT_ARG_MAX_LEN	128
#define	STR_OPT	"GCUT:D:S:l:k:e:s:p:md:Vh"

#if	HAVE_GETOPT_LONG
static struct option	long_opt[] = {
	{ "gui",           no_argument,       NULL, 'G' },
	{ "cui",           no_argument,       NULL, 'C' },
	{ "gui-and-cui",   no_argument,       NULL, 'U' },
	{ "text-mode",     required_argument, NULL, 'T' },
	{ "sel-graph-dir", required_argument, NULL, 'D' },
	{ "map-scale",     required_argument, NULL, 'S' },
	{ "language",      required_argument, NULL, 'l' },
	{ "clear-key-buf", required_argument, NULL, 'k' },
	{ "echo-key",      required_argument, NULL, 'e' },
	{ "use-curses",    required_argument, NULL, 's' },
	{ "use-keypad",    required_argument, NULL, 'p' },
	{ "measure-clock", no_argument,       NULL, 'm' },
	{ "debug",         required_argument, NULL, 'd' },
	{ "version",       no_argument,       NULL, 'V' },
	{ "help",          no_argument,       NULL, 'h' },
	{ 0, 0, 0, 0 }
};
#endif	/* HAVE_GETOPT_LONG */

/***************************************************************
* 
***************************************************************/

char	str_usage[] = {
	"Usage: %s [OPTION]...\n"
	"OPTION:\n"
	"  -G, --gui                set GUI mode\n"
	"  -C, --cui                set CUI mode\n"
	"  -U, --gui-and-cui        set GUI and CUI mode\n"
	"  -T, --text-mode=POINT    set TEXT mode:\n"
	"                             point of font, ON or OFF\n"
	"  -D, --sel-graph-dir=DIR  select graphic directory:\n"
	"                             graphic directory\n"
	"  -S, --map-scale=N        set scale of map character:\n"
	"                             scale(%%)\n"
	"  -l, --language=LANGUAGE  set language:\n"
	"                             language\n"
	"  -k, --clear-key-buf=FLAG clear key buffer:\n"
	"                             ON or OFF\n"
	"  -e, --echo-key=FLAG      echo key:\n"
	"                             ON or OFF\n"
	"  -s, --use-curses=FLAG    use curses library:\n"
	"                             ON or OFF\n"
	"  -p, --use-keypad=FLAG    use cursor key (call keypad):\n"
	"                             ON or OFF\n"
	"  -m, --measure-clock      measure frame rate\n"
#if	defined( DEBUG ) || !defined( NDEBUG )
	"  -d, --debug=FLAG         set debug mode:\n"
	"                             ON or OFF\n"
#endif
	"  -V, --version            display version and exit\n"
	"  -h, --help               display this help and exit\n"
};

/***************************************************************
* ν
***************************************************************/

void	init_arg( void )
{
	g_flg_debug = FALSE;
#ifdef	DEBUG
	g_flg_debug = TRUE;
#endif	/* DEBUG */
#ifdef	NDEBUG
	g_flg_debug = FALSE;
#endif	/* NDEBUG */

	g_flg_cui = TRUE;
	g_flg_gui = FALSE;

	g_flg_text_mode = FALSE;
	g_text_mode_point = 0;

	g_graph_scale_rate = _100_PERCENT;
	g_gui_key_kind = GUI_KEY_KIND_CONSOLE;

	g_language = NULL;

	g_flg_clr_key_buf_arg_overwrite = FALSE;
	g_flg_clr_key_buf_arg = FALSE;
	g_flg_clr_key_buf = TRUE;
	g_flg_clr_key_buf_menu = TRUE;

	g_flg_echo_key = FALSE;

	g_flg_use_curs = TRUE;
	g_flg_use_keypad = FALSE;

	g_flg_measure_clk_tck = FALSE;

	g_flg_send_item_exec_turn = FALSE;
}

/***************************************************************
* ν
* int argc : ο
* char **argv : Υꥹ
***************************************************************/

void	chk_arg( int argc, char **argv )
{
	long	len;
	long	mem_size;
#if	(!HAVE_GETOPT && !HAVE_GETOPT_LONG)
	long	n = 0;
	char	*optarg;
	long	optind = argc;
#endif	/* (!HAVE_GETOPT && !HAVE_GETOPT_LONG) */

	if( argv == NULL )
		return;

	while( 1 ){
		long	c;
#if	HAVE_GETOPT_LONG
		int	opt_idx;
#endif	/* HAVE_GETOPT_LONG */

#if	HAVE_GETOPT_LONG
		c = getopt_long( argc, argv, STR_OPT, long_opt, &opt_idx );
#elif	HAVE_GETOPT
		c = getopt( argc, argv, STR_OPT );
#else	/* HAVE_GETOPT_LONG */
		n++;
		if( n > argc - 1 )
			break;
		optarg = argv[n + 1];

		if( argv[n][0] == '-' )
			c = argv[n][1];
		else
			continue;
#endif	/* HAVE_GETOPT_LONG */

		if( c <= -1 )
			break;
		switch( c ){
		case 'G':
			g_flg_cui = FALSE;
			g_flg_gui = TRUE;
			break;
		case 'C':
			g_flg_cui = TRUE;
			g_flg_gui = FALSE;
			break;
		case 'U':
			g_flg_cui = TRUE;
			g_flg_gui = TRUE;
			break;
		case 'T':
			if( chk_opt_flg( optarg, &g_flg_text_mode,
					FALSE ) ){
				g_text_mode_point = 0;
			} else {
				g_flg_text_mode = TRUE;
				chk_opt_num( optarg, &g_text_mode_point,
						TRUE );
			}
			break;
		case 'D':
			set_str_dir_sel_graph( optarg );
			break;
		case 'S':
			chk_opt_num( optarg, &g_graph_scale_rate, TRUE );
			break;
		case 'l':
			if( g_language != NULL )
				free_mem( g_language );

			len = str_len_std( optarg );
			mem_size = len * sizeof( char );
			g_language = (char *)alloc_mem( mem_size, TRUE );

			str_nz_cpy( g_language, optarg, len );
			break;
		case 'k':
			g_flg_clr_key_buf_arg_overwrite = TRUE;
			chk_opt_flg( optarg, &g_flg_clr_key_buf_arg, TRUE );
			break;
		case 'e':
			chk_opt_flg( optarg, &g_flg_echo_key, TRUE );
			break;
		case 's':
			chk_opt_flg( optarg, &g_flg_use_curs, TRUE );
			break;
		case 'p':
			chk_opt_flg( optarg, &g_flg_use_keypad, TRUE );
			break;
		case 'm':
			g_flg_measure_clk_tck = TRUE;
			break;
		case 'd':
			chk_opt_flg( optarg, &g_flg_debug, TRUE );
			break;
		case 'V':
			version( stdout );
			gexit( EXIT_SUCCESS );
			break;
		case 'h':
			usage( stdout );
			gexit( EXIT_SUCCESS );
			break;
		case '\0':
			break;
		case '?':
		case ':':
		default:
			usage( stderr );
			gexit( EXIT_FAILURE );
			break;
		}
	}

	if( (argc - optind) > 0 ){
		usage( stderr );
		gexit( EXIT_FAILURE );
	}
}

/***************************************************************
* ͤΰå
* const char *optarg : ץʸ
* long *pn : ֤ͤ
* bool_t flg_err_exit : 顼ǽλ뤫?
* return : 顼̵ä?
***************************************************************/

bool_t	chk_opt_num(
	const char *optarg, long *pn, bool_t flg_err_exit
)
{
	do {
		if( optarg == NULL )
			break;
		if( pn == NULL )
			break;
		if( !isdigit( optarg[0] ) )
			break;

		/* ͤꤵ줿 */

		*pn = strtol( optarg, NULL, 0 );

		return TRUE;
		break;
	} while( 0 );

	/* 顼 */

	if( flg_err_exit ){
		usage( stderr );
		gexit( EXIT_FAILURE );
	}

	return FALSE;
}

/***************************************************************
* Υ󡿥դΥե饰å
* const char *optarg : ץʸ
* bool_t *flg : ե饰󤫤ɤ֤
* bool_t flg_err_exit : 顼ǽλ뤫?
* return : 顼̵ä?
***************************************************************/

bool_t	chk_opt_flg(
	const char *optarg, bool_t *flg, bool_t flg_err_exit
)
{
	static char	str[OPT_ARG_MAX_LEN + 1];
	long	i;

	if( optarg == NULL ){
		if( flg_err_exit ){
			usage( stderr );
			gexit( EXIT_FAILURE );
		}

		return FALSE;
	}

	for( i = 0; i < OPT_ARG_MAX_LEN; i++ ){
		if( optarg[i] == '\0' )
			break;
		str[i] = toupper( optarg[i] );
	}
	str[i] = '\0';

	*flg = TRUE;
	if( strcmp( str, "ON" ) == 0 )
		return TRUE;
	if( strcmp( str, "TRUE" ) == 0 )
		return TRUE;
	if( strcmp( str, "T" ) == 0 )
		return TRUE;
	if( strcmp( str, "YES" ) == 0 )
		return TRUE;
	if( strcmp( str, "1" ) == 0 )
		return TRUE;

	*flg = FALSE;
	if( strcmp( str, "OFF" ) == 0 )
		return TRUE;
	if( strcmp( str, "FALSE" ) == 0 )
		return TRUE;
	if( strcmp( str, "NIL" ) == 0 )
		return TRUE;
	if( strcmp( str, "NO" ) == 0 )
		return TRUE;
	if( strcmp( str, "0" ) == 0 )
		return TRUE;

	if( flg_err_exit ){
		usage( stderr );
		gexit( EXIT_FAILURE );
	}

	return FALSE;
}

/***************************************************************
* ǻꤵ줿
***************************************************************/

void	overwrite_arg()
{
	if( g_flg_clr_key_buf_arg_overwrite ){
		g_flg_clr_key_buf = g_flg_clr_key_buf_arg;
		g_flg_clr_key_buf_menu = g_flg_clr_key_buf_arg;
	}
}

/***************************************************************
* ɽ
* FILE *fp : ե
***************************************************************/

void	usage( FILE *fp )
{
	if( !g_flg_cui )
		return;

	fprintf( fp, str_usage, STR_FILE_NAME_GAME );
	fflush( fp );
}

/***************************************************************
* Τν
***************************************************************/

void	init_game( void )
{
	dun_t	*dun;

	/* ƽθƤֽ֤˵դ */

	g_flg_init = FALSE;

	init_signal();
	init_scrn();

	srandm( (long)time( NULL ) );

	init_scene();
	init_turn();

	init_msg();
	init_draw();
	init_replay();

	init_game_file();

	init_var_menu();
	init_var_main_menu();
	init_var_misc_menu();

	if( !load_game_conf() )
		g_flg_measure_clk_tck = TRUE;
	overwrite_arg();

	ena_scrn( TRUE );
	ena_curs_draw();
	wipe_all();

	init_dun();
	init_item();
	init_trap();
	init_fx();
	init_spell();
	init_chr();
	init_town();
	init_menu();
	init_tmenu();
	init_auto_menu();
	init_misc_menu();
	init_main_menu();
	init_request();

	init_mbr_formation();

	if( g_flg_debug )
		init_spell_debug();
	else
		init_spell_dflt();
	init_spell_nin();

	if( g_flg_debug )
		set_flg_no_save( TRUE );

	if( g_flg_measure_clk_tck )
		measure_clk_tck();

	dun = get_dun();
	dun->lev = 0;
	up_dun( 0 );

	g_flg_init = TRUE;
}

/***************************************************************
* ᥤ󡦥롼
***************************************************************/

void	game_main( void )
{
	chk_scroll( TRUE );
	redraw_all();

	if( !g_flg_debug ){
		print_msg( FLG_NULL, MSG_HINT_CANCEL_MENU_1 );
		print_msg( FLG_NULL, MSG_HINT_CANCEL_MENU_2 );

		menu_load_bar();

		party_exit_bar();
	}

	while( 1 ){
		chk_key( g_flg_clr_key_buf, TRUE );
	}
}

/***************************************************************
* νλ
* long code : λ
***************************************************************/

void	exit_game( long code )
{
	close_game( code );

	gexit( code );
}

/***************************************************************
* νλν
* long code : λ
***************************************************************/

void	close_game( long code )
{
	close_item();

	curs_move( WIN_MSG_DRAW_MIN_Y, SCREEN_MIN_X );
	reset_scrn();

	fflush( stdout );
	fflush( stderr );

	if( code == 0 )
		version( stdout );
	else
		version( stderr );

	fflush( stdout );
	fflush( stderr );
}

/***************************************************************
* ɽ
***************************************************************/

void	about_game( void )
{
	static char	tmp[1023 + 1];

	curs_move( WIN_MSG_DRAW_MIN_Y, SCREEN_MIN_X );

	dis_scrn();

	fprintf( OUT_FP, MSG_FMT_COPYRIGHT, LS_STR_COPYRIGHT );
	fprintf( OUT_FP, "\n%s\n", MSG_HIT_ENTER_KEY );
	fflush( OUT_FP );
	fgets( tmp, sizeof( tmp ) - 1, stdin );

	fprintf( OUT_FP, MSG_S, MSG_ABOUT_GAME );
	fprintf( OUT_FP, "\n%s\n", MSG_HIT_ENTER_KEY );
	fflush( OUT_FP );
	fgets( tmp, sizeof( tmp ) - 1, stdin );

	ena_scrn( FALSE );
}

/***************************************************************
* ΥСɽ
* FILE *fp : ե
***************************************************************/

void	version( FILE *fp )
{
	fprintf( fp, STR_FMT_COPYRIGHT, LS_STR_COPYRIGHT );
	fflush( fp );
}

/***************************************************************
* ƤӽФ
***************************************************************/

void	child_ps( void )
{
#ifdef	D_DOS
	child_ps_dos();
#else	/* D_DOS */
	child_ps_unix();
#endif	/* D_DOS */
}

/***************************************************************
* ʥν
***************************************************************/

void	init_signal( void )
{
#ifdef	D_X68K
	signal( SIGINT, signal_handler );
	signal( SIGABRT, signal_handler );
	signal( SIGTERM, signal_handler );
#elif	defined( D_DOS )
	signal( SIGINT, signal_handler );
	signal( SIGSEGV, signal_handler );
	signal( SIGABRT, signal_handler );
	signal( SIGTERM, signal_handler );
#else
	signal( SIGHUP, signal_handler );
	signal( SIGINT, signal_handler );
	signal( SIGKILL, signal_handler );
	signal( SIGBUS, signal_handler );
	signal( SIGSEGV, signal_handler );
	signal( SIGABRT, signal_handler );
	signal( SIGTERM, signal_handler );
#endif
}

/***************************************************************
* ʥνϥɥ
* int sig : ʥ
***************************************************************/

void	signal_handler( int sig )
{
	reset_scrn();

	exit_game( EXIT_FAILURE );
}

/***************************************************************
* ̤ν
***************************************************************/

void	init_scrn( void )
{
	init_curs();
	init_term();
}

/***************************************************************
* ̤Υꥻå
***************************************************************/

void	reset_scrn( void )
{
	while( chk_term() )
		dis_term();

	curs_refresh();
	while( chk_curs() ){
		curs_endwin();
	}
}

/***************************************************************
* ̤ͭ
* bool_t flg_initscr : curses 뤫?
***************************************************************/

void	ena_scrn( bool_t flg_initscr )
{
	if( flg_initscr ){
		curs_initscr();
		curs_keypad( stdscr, TRUE );
	} else {
		curs_clearok( stdscr, TRUE );
		curs_refresh();
	}

	ena_term();
}

/***************************************************************
* ̵̤
***************************************************************/

void	dis_scrn( void )
{
	dis_term();

	curs_refresh();
	curs_endwin();
}

/***************************************************************
* üν
***************************************************************/

void	init_term( void )
{
#ifdef	D_DOS
	init_term_dos();
#else	/* D_DOS */
	init_term_unix();
#endif	/* D_DOS */
}

/***************************************************************
* üͭĴ٤
* return : üͭ?
***************************************************************/

bool_t	chk_term( void )
{
#ifdef	D_DOS
	return chk_term_dos();
#else	/* D_DOS */
	return chk_term_unix();
#endif	/* D_DOS */
}

/***************************************************************
* üͭ
***************************************************************/

void	ena_term( void )
{
#ifdef	D_DOS
	ena_term_dos();
#else	/* D_DOS */
	ena_term_unix();
#endif	/* D_DOS */
}

/***************************************************************
* ü̵
***************************************************************/

void	dis_term( void )
{
#ifdef	D_DOS
	dis_term_dos();
#else	/* D_DOS */
	dis_term_unix();
#endif	/* D_DOS */
}

/***************************************************************
* Ԥ
***************************************************************/

void	set_key_wait( void )
{
#ifdef	D_DOS
	set_key_wait_dos();
#else	/* D_DOS */
	set_key_wait_unix();
#endif	/* D_DOS */
}

/***************************************************************
* Ԥ
***************************************************************/

void	clr_key_wait( void )
{
#ifdef	D_DOS
	clr_key_wait_dos();
#else	/* D_DOS */
	clr_key_wait_unix();
#endif	/* D_DOS */
}

/***************************************************************
* θƤӽФ
***************************************************************/

void	child_ps_unix( void )
{
	char	*shell;

	if( !g_flg_cui )
		return;

	dis_scrn();

	shell = getenv( STR_ENV_SHELL );
	if( shell == NULL )
		shell = STR_DFLT_SHELL;

	fprintf( stdout, MSG_CHILD_PS, shell );
	fflush( stdout );
	system( shell );

	ena_scrn( FALSE );
}

/***************************************************************
* θƤӽФ
***************************************************************/

void	child_ps_dos( void )
{
	char	*shell;

	if( !g_flg_cui )
		return;

	dis_scrn();

	shell = getenv( STR_ENV_SHELL );
	if( shell == NULL )
		shell = STR_DFLT_SHELL;

	fprintf( stdout, MSG_CHILD_PS, shell );
	fflush( stdout );
	system( shell );

	ena_scrn( FALSE );
}

/***************************************************************
* üν
***************************************************************/

void	init_term_unix( void )
{
	flg_term = 0;
}

/***************************************************************
* üͭĴ٤
* return : üͭ?
***************************************************************/

bool_t	chk_term_unix( void )
{
	return( flg_term > 0 );
}

/***************************************************************
* üͭˤ
***************************************************************/

void	ena_term_unix( void )
{
	if( !g_flg_cui )
		return;

	flg_term++;

#if	(HAVE_TERMIOS_H || HAVE_TERMIO_H)
	if( flg_term == 1 ){
		/* ¤Τ */
# if	HAVE_TERMIOS_H
		struct termios	tbuf;
# elif	HAVE_TERMIO_H
		struct termio	tbuf;
# endif

		/* Υå */
# if	HAVE_TERMIOS_H
		tcgetattr( fileno( stdin ), &tbuf );
# elif	HAVE_TERMIO_H
		ioctl( 0, TCGETA, &tbuf );
# endif

		/* Խ */
		pre_tbuf = tbuf;

		tbuf.c_iflag &= ~(INLCR | ICRNL | ISTRIP | IXON | BRKINT);
		tbuf.c_oflag &= ~(OPOST);
		if( g_flg_clr_key_buf ){
			tbuf.c_cc[VMIN] = KEY_WAIT_VMIN;
			tbuf.c_cc[VTIME] = KEY_WAIT_VTIME;
		}
		tbuf.c_lflag &= ~(ICANON | ISIG | ECHO);

		/* ^C ͭˤ */
		if( g_flg_debug ){
			tbuf.c_iflag |= BRKINT;
			tbuf.c_lflag |= ISIG;
		}

		/* Υå */
# if	HAVE_TERMIOS_H
		if( tcsetattr( fileno( stdin ), TCSANOW, &tbuf ) != 0 ){
			fprintf( stderr, MSG_S, MSG_ERR_SET_TTY );
			exit_game( EXIT_FAILURE );
		}
# elif	HAVE_TERMIO_H
		if( ioctl( 0, TCSETAF, &tbuf ) != 0 ){
			fprintf( stderr, MSG_S, MSG_ERR_SET_TTY );
			exit_game( EXIT_FAILURE );
		}
# endif	/* HAVE_TERMIOS_H */
	}
#endif	/* (HAVE_TERMIOS_H || HAVE_TERMIO_H) */
}

/***************************************************************
* ü̵ˤ
***************************************************************/

void	dis_term_unix( void )
{
	if( !g_flg_cui )
		return;

	if( flg_term == 1 ){
#if	HAVE_TERMIOS_H
		tcsetattr( fileno( stdin ), TCSANOW, &pre_tbuf );
#elif	HAVE_TERMIO_H
		ioctl( 0, TCSETAF, &pre_tbuf );
#endif
	}

	flg_term--;
}

/***************************************************************
* Ԥ
***************************************************************/

void	set_key_wait_unix( void )
{
	set_key_wait_vtime( KEY_WAIT_VTIME );
}

/***************************************************************
* Ԥ
***************************************************************/

void	clr_key_wait_unix( void )
{
	set_key_wait_vtime( 0 );
}

/***************************************************************
* Ԥ֤
* long wait_vtime : Ԥ
***************************************************************/

void	set_key_wait_vtime( long wait_vtime )
{
#if	(HAVE_TERMIOS_H || HAVE_TERMIO_H)
	/* ¤Τ */
# if	HAVE_TERMIOS_H
	struct termios	tbuf;
# elif	HAVE_TERMIO_H
	struct termio	tbuf;
# endif

	if( !g_flg_cui )
		return;

	/* Υå */
# if	HAVE_TERMIOS_H
	tcgetattr( fileno( stdin ), &tbuf );
# elif	HAVE_TERMIO_H
	ioctl( 0, TCGETA, &tbuf );
# endif

	/* Խ */
	tbuf.c_cc[VTIME] = wait_vtime;

	/* Υå */
# if	HAVE_TERMIOS_H
	if( tcsetattr( fileno( stdin ), TCSANOW, &tbuf ) != 0 ){
		fprintf( stderr, MSG_S, MSG_ERR_SET_TTY );
		exit_game( EXIT_FAILURE );
	}
# elif	HAVE_TERMIO_H
	if( ioctl( 0, TCSETAF, &tbuf ) != 0 ){
		fprintf( stderr, MSG_S, MSG_ERR_SET_TTY );
		exit_game( EXIT_FAILURE );
	}
# endif
#endif	/* (HAVE_TERMIOS_H || HAVE_TERMIO_H) */
}

/***************************************************************
* üν
***************************************************************/

void	init_term_dos( void )
{
	flg_term = 0;
}

/***************************************************************
* üͭĴ٤
* return : üͭ?
***************************************************************/

bool_t	chk_term_dos( void )
{
	return( flg_term > 0 );
}

/***************************************************************
* üͭˤ
***************************************************************/

void	ena_term_dos( void )
{
	if( !g_flg_cui )
		return;

	flg_term++;
}

/***************************************************************
* ü̵ˤ
***************************************************************/

void	dis_term_dos( void )
{
	if( !g_flg_cui )
		return;

	flg_term--;
}

/***************************************************************
* Ԥ
***************************************************************/

void	set_key_wait_dos( void )
{
	set_key_wait_vtime( 1 );
}

/***************************************************************
* Ԥ
***************************************************************/

void	clr_key_wait_dos( void )
{
	set_key_wait_vtime( 0 );
}
