/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2008 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
* 
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
* 
* $Id: msg-eng.h,v 1.128 2008/04/03 08:17:01 bowkenken Exp $
***************************************************************/

#include	"ver.h"

#define	STR_GOLD	"GENAMA"
#define	STR_GOLD_SHORT	"G"
#define	STR_GOLD_FMT	"%s " STR_GOLD
#define	STR_GOLD_FMT_MAX	"%12s " STR_GOLD
#define	STR_GOLD_SHORT_FMT	"%s " STR_GOLD_SHORT
#define	STR_GOLD_SHORT_FMT_MAX	"%12s " STR_GOLD_SHORT

#define	STR_SQUARE	"Anchor"

#define	STR_EQUIP_WIELDING	"Wielding"
#define	STR_EQUIP_SHIELD	"Shield"
#define	STR_EQUIP_BOW	"Bow"
#define	STR_EQUIP_ARW	"Arw"
#define	STR_EQUIP_HEAD	"Head"
#define	STR_EQUIP_NECK	"Neck"
#define	STR_EQUIP_BODY	"Body"
#define	STR_EQUIP_ARM	"Arm"
#define	STR_EQUIP_RIGHT_HAND	"Right hand"
#define	STR_EQUIP_LEFT_HAND	"Left hand"
#define	STR_EQUIP_FEET	"Feet"
#define	STR_EQUIP_ABOUT_BODY	"About body"
#define	STR_EQUIP_LIGHT_SOURCE	"Light source"

#define	STR_DISARM	"Disarm"

#define	STR_FIG	"Fighter's ability"
#define	STR_MON	"Monk's ability"
#define	STR_HUN	"Hunter's ability"
#define	STR_THI	"Thief's ability"

#define	STR_MAG	"Magician's ability"
#define	STR_SOR	"Sorcerer's ability"
#define	STR_ENC	"Enchanter's ability"
#define	STR_SUM	"Summoner's ability"
#define	STR_PRI	"Priest's ability"
#define	STR_SHA	"Shaman's ability"
#define	STR_BAR	"Bard's ability"
#define	STR_NIN	"Ninja's ability"

	{ N_MSG_NULL,
		"" },
	{ N_MSG_NOT_NULL,
		" " },

	{ N_MSG_S,
		"%s" },

	{ N_MSG_GAME_NAME,
		STR_FILE_NAME_GAME },

	{ N_MSG_CANCEL,
		"You Canceled" },
	{ N_MSG_HIT_ANY_KEY,
		"- Hit any Key -" },
	{ N_MSG_HIT_ENTER_KEY,
		"- Hit [ENTER] Key -" },
	{ N_MSG_HINT_CANCEL_MENU_1,
		"If you hit [ESC], [BACK-SPACE] or [DELETE] key"
	},
	{ N_MSG_HINT_CANCEL_MENU_2,
		"then you can close menu"
	},

	{ N_MSG_H_LINE,
		"-" },
	{ N_MSG_V_LINE,
		"|" },
	{ N_MSG_CROSS,
		"+" },
	{ N_MSG_H_FRAME,
		"----------------------------------------"
		"+---------------------------------------" },
	{ N_MSG_STAT_FRAME,
		"---------------------------------------" },

	{ N_MSG_SQUARE,
		STR_SQUARE },

	{ N_MSG_MORE,
		"-more-" },
	{ N_MSG_MORE_CLEAR,
		"      " },

	{ N_MSG_WAIT_KEY,
		"- Hit [ENTER] key. -" },

	{ N_MSG_INCOMPLETE,
		"This hasn't been made yet." },

	{ N_MSG_GAME_OVER,
		"A party was completely destroyed."
		" Hit [CTRL] + [Q] key and quit game." },

	{ N_MSG_CHILD_PS,
		"Call %s\n" },

	{ N_MSG_OUT_MAP_FILE_1,
		"Input the file name which a map is outputted in." },
	{ N_MSG_OUT_MAP_FILE_2,
		"Default '%s'" },
	{ N_MSG_OUT_MAP_FILE_3,
		"Output file name '%s'" },
	{ N_MSG_OUT_MAP_FILE_ASK_OK,
		"Do you output it?" },

	{ N_MSG_ECHO_KEY,
		"['%c': 0x%04lx]" },
	{ N_MSG_MEASURE_CLK_TCK,
		"A frame rate is being measured (%ld sec.) ..." },
	{ N_MSG_MEASURE_CLK_TCK_FINISH,
		"(%ld - %ld) / %ld == %ld" },

	{ N_MSG_MAIN_RACE_HUMAN,
		"Human" },
	{ N_MSG_MAIN_RACE_HALF_ELF,
		"Half Elf" },
	{ N_MSG_MAIN_RACE_ELF,
		"Elf" },
	{ N_MSG_MAIN_RACE_DWARF,
		"Dwarf" },
	{ N_MSG_MAIN_RACE_VIVID,
		"Vivid" },

	{ N_MSG_SUB_RACE_NULL,
		"Nothing" },
	{ N_MSG_SUB_RACE_CAT,
		"Cat" },
	{ N_MSG_SUB_RACE_DOG,
		"Dog" },
	{ N_MSG_SUB_RACE_MOUSE,
		"Mouse" },
	{ N_MSG_SUB_RACE_RABBIT,
		"Rabbit" },
	{ N_MSG_SUB_RACE_MONKEY,
		"Monkey" },
	{ N_MSG_SUB_RACE_PIG,
		"Pig" },
	{ N_MSG_SUB_RACE_BIRD,
		"Bird" },
	{ N_MSG_SUB_RACE_LIZARD,
		"Lizard" },

	{ N_MSG_RACE_NAME_VEGE,
		"Vege" },
	{ N_MSG_RACE_NAME_NEKOMIMI,
		"Nekomimi" },

	{ N_MSG_MALE,
		"Male" },
	{ N_MSG_FEMALE,
		"Female" },

	{ N_MSG_EQUIP_WIELDING,
		STR_EQUIP_WIELDING },
	{ N_MSG_EQUIP_SHIELD,
		STR_EQUIP_SHIELD },
	{ N_MSG_EQUIP_BOW,
		STR_EQUIP_BOW },
	{ N_MSG_EQUIP_ARW,
		STR_EQUIP_ARW },
	{ N_MSG_EQUIP_HEAD,
		STR_EQUIP_HEAD },
	{ N_MSG_EQUIP_NECK,
		STR_EQUIP_NECK },
	{ N_MSG_EQUIP_BODY,
		STR_EQUIP_BODY },
	{ N_MSG_EQUIP_ARM,
		STR_EQUIP_ARM },
	{ N_MSG_EQUIP_RIGHT_HAND,
		STR_EQUIP_RIGHT_HAND },
	{ N_MSG_EQUIP_LEFT_HAND,
		STR_EQUIP_LEFT_HAND },
	{ N_MSG_EQUIP_FEET,
		STR_EQUIP_FEET },
	{ N_MSG_EQUIP_ABOUT_BODY,
		STR_EQUIP_ABOUT_BODY },
	{ N_MSG_EQUIP_LIGHT_SOURCE,
		STR_EQUIP_LIGHT_SOURCE },

	{ N_MSG_STAT_DEAD,
		"Dead" },
	{ N_MSG_STAT_STONE,
		"Stone" },
	{ N_MSG_STAT_PARALYZE,
		"Paralyze" },
	{ N_MSG_STAT_POISON,
		"Poison" },
	{ N_MSG_STAT_CONFUSION,
		"Confusion" },
	{ N_MSG_STAT_BLIND,
		"Blind" },
	{ N_MSG_STAT_SLEEP,
		"Sleep" },
	{ N_MSG_STAT_SILENCE,
		"Silence" },
	{ N_MSG_STAT_CAUGHT,
		"Caught" },
	{ N_MSG_STAT_FEAR,
		"Fear" },
	{ N_MSG_STAT_HALLUCINATION,
		"Hallucination" },
	{ N_MSG_STAT_CHARM,
		"Charm" },
	{ N_MSG_STAT_FLY,
		"Fly" },
	{ N_MSG_STAT_VANISH,
		"Vanish" },
	{ N_MSG_STAT_IRON_BODY,
		"Iron body" },
	{ N_MSG_STAT_PASSWALL,
		"Passwall" },
	{ N_MSG_STAT_SENSE_INVISIBLE,
		"Sense Invisible" },
	{ N_MSG_STAT_HUNGRY,
		"Hungry" },
	{ N_MSG_STAT_STARVATION,
		"Starvation" },
	{ N_MSG_STAT_FAINT,
		"Faint" },
	{ N_MSG_STAT_DRUNK,
		"Drunk" },

	{ N_MSG_ABL_NAME_HP,
		"HP" },
	{ N_MSG_ABL_NAME_MP,
		"MP" },
	{ N_MSG_ABL_NAME_DEX,
		"DEX" },
	{ N_MSG_ABL_NAME_STR,
		"STR" },
	{ N_MSG_ABL_NAME_AGI,
		"AGI" },
	{ N_MSG_ABL_NAME_INT,
		"INT" },
	{ N_MSG_ABL_NAME_WIS,
		"WIS" },
	{ N_MSG_ABL_NAME_CHA,
		"CHA" },
	{ N_MSG_ABL_NAME_FIG,
		"FIG" },
	{ N_MSG_ABL_NAME_MON,
		"MON" },
	{ N_MSG_ABL_NAME_HUN,
		"HUN" },
	{ N_MSG_ABL_NAME_THI,
		"THI" },
	{ N_MSG_ABL_NAME_MAG,
		"MAG" },
	{ N_MSG_ABL_NAME_SOR,
		"SOR" },
	{ N_MSG_ABL_NAME_ENC,
		"ENC" },
	{ N_MSG_ABL_NAME_SUM,
		"SUM" },
	{ N_MSG_ABL_NAME_PRI,
		"PRI" },
	{ N_MSG_ABL_NAME_SHA,
		"SHA" },
	{ N_MSG_ABL_NAME_BAR,
		"BAR" },
	{ N_MSG_ABL_NAME_NIN,
		"NIN" },

	{ N_MSG_CLASS_FIGHTER,
		"Fighter" },
	{ N_MSG_CLASS_MONK,
		"Monk" },
	{ N_MSG_CLASS_HUNTER,
		"Hunter" },
	{ N_MSG_CLASS_THIEF,
		"Thief" },
	{ N_MSG_CLASS_WIZARD,
		"Wizard" },
	{ N_MSG_CLASS_SUMMONER,
		"Summoner" },
	{ N_MSG_CLASS_PRIEST,
		"Priest" },
	{ N_MSG_CLASS_SHAMAN,
		"Shaman" },
	{ N_MSG_CLASS_BARD,
		"Bard" },
	{ N_MSG_CLASS_NINJA,
		"Ninja" },
	{ N_MSG_CLASS_BISHOP,
		"Bishop" },
	{ N_MSG_ERR_CLASS_NOT_100_PERCENT,
		"There is no total of the ability value"
		" in the %s in the 100%%." },

	{ N_MSG_DIE_CHR,
		"*** %s died. ***" },

	{ N_MSG_EXP_PARTY,
		"Each member got the experience value of %ld." },
	{ N_MSG_EXP_MBR,
		"%s got the experience value of the %ld." },
	{ N_MSG_VFX_LEV_UP,
		"LEVEL UP" },
	{ N_MSG_VFX_LEV_DOWN,
		"LEVEL DOWN" },
	{ N_MSG_LEV_UP,
		"*** As for %s, the level of %s rose to the %3ld. ***" },
	{ N_MSG_LEV_DOWN,
		"*** As for %s, the level of %s moved to the %3ld. ***" },

	{ N_MSG_ADD_PARTY_GOLD,
		"The party distributed " STR_GOLD_FMT " equally." },
	{ N_MSG_SUB_PARTY_GOLD,
		"It was shared, and a party paid " STR_GOLD_FMT "." },

	{ N_MSG_JOIN_CHR,
		"A company gained a %s." },
	{ N_MSG_NOT_JOIN_CHR,
		"A %s came off from the company." },

	{ N_MSG_FLOOR,
		"Floor" },
	{ N_MSG_BASE,
		"Base" },
	{ N_MSG_GROUND,
		"Ground" },
	{ N_MSG_STORY,
		"Story" },

	{ N_MSG_FLOOR_FMT,
		"Floor %ld" },
	{ N_MSG_BASE_FMT,
		"Base %ld" },

	{ N_MSG_STAT_DUN_LEV_FLOOR,
		"Floor : %4ld" },
	{ N_MSG_STAT_DUN_LEV_BASE,
		"Base  : %4ld" },
	{ N_MSG_STAT_DUN_LEV_GROUND,
		"Ground: %4ld" },

	{ N_MSG_STAT_TIME,
		"%02ld:%02ld" },

	{ N_MSG_NAME_BAR,
		"Bar" },
	{ N_MSG_NAME_INN,
		"Inn" },
	{ N_MSG_NAME_WPN,
		"Wpn" },
	{ N_MSG_NAME_ARMOR,
		"Armor" },
	{ N_MSG_NAME_MAGIC,
		"Magic guild" },
	{ N_MSG_NAME_TEMPLE,
		"Temple" },
	{ N_MSG_NAME_ALCHEMY,
		"Alchemy" },
	{ N_MSG_NAME_MUSIC,
		"Music academy" },
	{ N_MSG_NAME_GROCERY,
		"Grocery" },
	{ N_MSG_NAME_RESTAURANT,
		"Restaurant" },
	{ N_MSG_NAME_TEAROOM,
		"Tearoom" },
	{ N_MSG_NAME_TOBACCO,
		"Tobacco" },
	{ N_MSG_NAME_PET_SHOP,
		"Pet shop" },

	{ N_MSG_DAY_OF_WEEK_ELEC,
		"Light" },
	{ N_MSG_DAY_OF_WEEK_PHYS,
		"Moon" },
	{ N_MSG_DAY_OF_WEEK_HEAT,
		"Fire" },
	{ N_MSG_DAY_OF_WEEK_COLD,
		"Water" },
	{ N_MSG_DAY_OF_WEEK_MIND,
		"Air" },
	{ N_MSG_DAY_OF_WEEK_ACID,
		"Earth" },
	{ N_MSG_DAY_OF_WEEK_POIS,
		"Dark" },

	{ N_MSG_AUTO_RELOAD,
		"A %s was loaded with the %s automatically." },

	{ N_MSG_ATTACK_PUNCH,
		"%s punched %s." },
	{ N_MSG_ATTACK_KICK,
		"%s kicked %s." },
	{ N_MSG_ATTACK_KNOCK,
		"%s knocked %s." },
	{ N_MSG_ATTACK_SLASH,
		"%s slashed %s." },
	{ N_MSG_ATTACK_STING,
		"%s stinged %s." },
	{ N_MSG_ATTACK_MOW,
		"%s mowed %s." },
	{ N_MSG_ATTACK_SHOOT,
		"%s shooted %s." },
	{ N_MSG_ATTACK_THROW,
		"%s throwed %s." },
	{ N_MSG_ATTACK_BITE,
		"%s bited %s." },
	{ N_MSG_ATTACK_PECK,
		"%s pecked %s." },
	{ N_MSG_ATTACK_CLAW,
		"%s clawed %s." },
	{ N_MSG_ATTACK_NIP,
		"%s nipped %s." },
	{ N_MSG_ATTACK_STRANGLE,
		"%s strangled %s." },
	{ N_MSG_ATTACK_TACKLE,
		"%s tackled %s." },
	{ N_MSG_ATTACK_TOUCH,
		"%s touched %s." },
	{ N_MSG_ATTACK_INDICATE,
		"%s indicated %s." },
	{ N_MSG_ATTACK_KISS,
		"%s kissed %s." },
	{ N_MSG_ATTACK_SEDUCE,
		"%s seduced %s." },
	{ N_MSG_ATTACK_CARESS_BUST,
		"%s caressed bust of %s." },
	{ N_MSG_ATTACK_CARESS_HIP,
		"%s caressed hip of %s." },
	{ N_MSG_ATTACK_CARESS_CROTCH,
		"%s caressed crotch of %s." },
	{ N_MSG_FIGHT_CRTCL_STD,
		"%s is Critical Hit." },
	{ N_MSG_FIGHT_CRTCL_NINJA,
		"%s is Kubi kiri." },
	{ N_MSG_FIGHT_HIT_STD,
		"Hitted %s to %d." },
	{ N_MSG_FIGHT_MISS_STD,
		"%s missed %s." },
	{ N_MSG_FIGHT_KILL_STD,
		"++XX %s killed %s. XX++" },
	{ N_MSG_FIGHT_MAGIC_PROTECT,
		"This weapon don't effect to %s." },
	{ N_MSG_FIGHT_SUBSTITUTE,
		"It's substitute for %s." },
	{ N_MSG_REPEL_ATTACK,
		"%s repeled attack from %s." },

	{ N_MSG_SPELL,
		"%s casted spell of %s." },
	{ N_MSG_FAIL_SPELL,
		"%s failed spell of %s." },
	{ N_MSG_FAIL_SPELL_SANCTUARY,
		"Holy power denied %s's spell." },
	{ N_MSG_RESI_SPELL,
		"%s resisted spell of %s." },
	{ N_MSG_REPEL_SPELL,
		"%s repeled spell of %s." },

	{ N_MSG_TRGT_POS,
		"Position designation" },

	{ N_MSG_ACT_NULL,
		"" },
	{ N_MSG_ACT_MNSTR_FIGHT,
		"Fight" },
	{ N_MSG_ACT_MNSTR_THROW,
		"Shoot" },
	{ N_MSG_ACT_MNSTR_STEAL,
		"Steal" },
	{ N_MSG_ACT_MNSTR_TAIL,
		"Follow" },
	{ N_MSG_ACT_MBR_FIGHT,
		"Fight against the member." },
	{ N_MSG_ACT_MBR_THROW,
		"Shoot it to the member." },
	{ N_MSG_ACT_MBR_STEAL,
		"Steal it from the member." },
	{ N_MSG_ACT_MBR_TAIL,
		"Run after a member." },
	{ N_MSG_ACT_DOOR_OPEN,
		"Open a door." },
	{ N_MSG_ACT_DOOR_CLOSE,
		"Close a door." },
	{ N_MSG_ACT_DOOR_JAM,
		"Fix a door." },
	{ N_MSG_ACT_DOOR_DISARM,
		"Cancel the fixation of the door." },
	{ N_MSG_ACT_DOOR_BREAK,
		"Break a door." },
	{ N_MSG_ACT_DOOR_PEEP,
		"Peep into the keyhole." },
	{ N_MSG_ACT_DOOR_CHK,
		"Check a door." },
	{ N_MSG_ACT_TRAP_DISARM,
		"Cancel a trap." },
	{ N_MSG_ACT_TRAP_BREAK,
		"Break a trap." },
	{ N_MSG_ACT_TRAP_CHK,
		"Examine a trap." },
	{ N_MSG_ACT_ITEM_PICK_UP,
		"Pick up a item" },
	{ N_MSG_ACT_ITEM_OPEN,
		"Open a item." },
	{ N_MSG_ACT_ITEM_DISARM,
		"Cancel a item." },
	{ N_MSG_ACT_ITEM_BREAK,
		"Break a item." },
	{ N_MSG_ACT_ITEM_CHK,
		"Check a item." },
	{ N_MSG_ACT_ITEM_SEND,
		"Deliver a item." },
	{ N_MSG_ACT_ITEM_DROP,
		"Drop a item." },
	{ N_MSG_ACT_ITEM_RECEIVE,
		"Get a item." },
	{ N_MSG_ACT_POTION_QUAFF,
		"Quaff a potion." },
	{ N_MSG_ACT_POTION_FILL,
		"Fill lamp with a potion." },
	{ N_MSG_ACT_SCROLL_READ,
		"Read a scroll." },
	{ N_MSG_ACT_STICK_ZAP,
		"Zap a Stick." },
	{ N_MSG_ACT_FOOD_EAT,
		"Eat food." },
	{ N_MSG_ACT_TOBACCO_SMOKE,
		"Smoke Tobacco." },
	{ N_MSG_ACT_TOBACCO_DISPOSE,
		"Put a cigarette end." },
	{ N_MSG_ACT_EQUIP,
		"Equip it." },
	{ N_MSG_ACT_TAKE_OFF,
		"Take off it." },
	{ N_MSG_ACT_EQUIP_MBR,
		"Equip ohter's it." },
	{ N_MSG_ACT_TAKE_OFF_MBR,
		"Take off other's it." },
	{ N_MSG_ACT_SRCH,
		"Search" },

	{ N_MSG_INC_DISCOUNT_QUEUE,
		"%s stood in the line." },

/* ƥ */
	{ N_MSG_ITEM_UNKNOWN,
		"Unknown item" },

	{ N_MSG_ITEM_MJR_NAME_WEAPON,
		"Weapon" },
	{ N_MSG_ITEM_MJR_NAME_ARMOR,
		"Armor" },
	{ N_MSG_ITEM_MJR_NAME_POTION,
		"Potion" },
	{ N_MSG_ITEM_MJR_NAME_SCROLL,
		"Scroll" },
	{ N_MSG_ITEM_MJR_NAME_STICK,
		"Stick" },
	{ N_MSG_ITEM_MJR_NAME_ACCESSORY,
		"Accessory" },
	{ N_MSG_ITEM_MJR_NAME_FOOD,
		"Food" },
	{ N_MSG_ITEM_MJR_NAME_CHEST,
		"Chest" },
	{ N_MSG_ITEM_MJR_NAME_COIN,
		"Coin" },
	{ N_MSG_ITEM_MJR_NAME_GEM,
		"Gem" },
	{ N_MSG_ITEM_MJR_NAME_MISC,
		"Misc" },
	{ N_MSG_ITEM_MJR_NAME_ERR,
		"Unknown" },

	{ N_MSG_ITEM_MNR_NAME_KNIFE,
		"Knife" },
	{ N_MSG_ITEM_MNR_NAME_SHORT_SWORD,
		"Short sword" },
	{ N_MSG_ITEM_MNR_NAME_LONG_SWORD,
		"Long sword" },
	{ N_MSG_ITEM_MNR_NAME_SABRE,
		"Sabre" },
	{ N_MSG_ITEM_MNR_NAME_RAPIER,
		"Rapier" },
	{ N_MSG_ITEM_MNR_NAME_HAND_AXE,
		"Hand axe" },
	{ N_MSG_ITEM_MNR_NAME_BATTLE_AXE,
		"Battle axe" },
	{ N_MSG_ITEM_MNR_NAME_SPEAR,
		"Spear" },
	{ N_MSG_ITEM_MNR_NAME_LANCE,
		"Lance" },
	{ N_MSG_ITEM_MNR_NAME_FLAIL,
		"Flail" },
	{ N_MSG_ITEM_MNR_NAME_MACE,
		"Mace" },
	{ N_MSG_ITEM_MNR_NAME_HAMMER,
		"Hammer" },
	{ N_MSG_ITEM_MNR_NAME_GLAIVE,
		"Glaive" },
	{ N_MSG_ITEM_MNR_NAME_KNUCKLE,
		"Knuckle" },
	{ N_MSG_ITEM_MNR_NAME_BOW,
		"Bow" },
	{ N_MSG_ITEM_MNR_NAME_ARW,
		"Arw" },
	{ N_MSG_ITEM_MNR_NAME_STONE,
		"Stone" },
	{ N_MSG_ITEM_MNR_NAME_DAGGER,
		"Dagger" },
	{ N_MSG_ITEM_MNR_NAME_ARMOR_HEAD,
		"Armor head" },
	{ N_MSG_ITEM_MNR_NAME_ARMOR_BODY,
		"Armor body" },
	{ N_MSG_ITEM_MNR_NAME_ARMOR_ABOUT_BODY,
		"Armor about body" },
	{ N_MSG_ITEM_MNR_NAME_ARMOR_ARM,
		"Armor arm" },
	{ N_MSG_ITEM_MNR_NAME_ARMOR_SHIELD,
		"Armor shield" },
	{ N_MSG_ITEM_MNR_NAME_ARMOR_FEET,
		"Armor feet" },
	{ N_MSG_ITEM_MNR_NAME_POTION,
		"Potion" },
	{ N_MSG_ITEM_MNR_NAME_SCROLL,
		"Scroll" },
	{ N_MSG_ITEM_MNR_NAME_WAND,
		"Wand" },
	{ N_MSG_ITEM_MNR_NAME_ROD,
		"Rod" },
	{ N_MSG_ITEM_MNR_NAME_STAFF,
		"Staff" },
	{ N_MSG_ITEM_MNR_NAME_RING,
		"Ring" },
	{ N_MSG_ITEM_MNR_NAME_AMULET,
		"Amulet" },
	{ N_MSG_ITEM_MNR_NAME_NECKLACE,
		"Necklace" },
	{ N_MSG_ITEM_MNR_NAME_FOOD,
		"Food" },
	{ N_MSG_ITEM_MNR_NAME_CHEST,
		"Chest" },
	{ N_MSG_ITEM_MNR_NAME_COIN,
		"Coin" },
	{ N_MSG_ITEM_MNR_NAME_GEM,
		"Gem" },
	{ N_MSG_ITEM_MNR_NAME_INST,
		"Musical instrument" },
	{ N_MSG_ITEM_MNR_NAME_INST_BRASS,
		"Brass instrument" },
	{ N_MSG_ITEM_MNR_NAME_INST_WOODWIND,
		"Woodwind instrument" },
	{ N_MSG_ITEM_MNR_NAME_INST_STRINGED,
		"Stringed instrument" },
	{ N_MSG_ITEM_MNR_NAME_INST_PERCUSSION,
		"Percussion instrument" },
	{ N_MSG_ITEM_MNR_NAME_INST_MISC,
		"Misc instrument" },
	{ N_MSG_ITEM_MNR_NAME_ANTHOLOGY,
		"Anthology of legend" },
	{ N_MSG_ITEM_MNR_NAME_LIGHT,
		"Light" },
	{ N_MSG_ITEM_MNR_NAME_SPIKE,
		"Spike" },
	{ N_MSG_ITEM_MNR_NAME_TOBACCO,
		"Tobacco" },
	{ N_MSG_ITEM_MNR_NAME_PIPE,
		"Pipe" },
	{ N_MSG_ITEM_MNR_NAME_DISPOSAL,
		"Disposal" },
	{ N_MSG_ITEM_MNR_NAME_RARE_GOODS,
		"Rare goods" },
	{ N_MSG_ITEM_MNR_NAME_BONE_GOOD,
		"Someone's bone" },
	{ N_MSG_ITEM_MNR_NAME_BONE_EVIL,
		"Monster's bone" },
	{ N_MSG_ITEM_MNR_NAME_JUNK,
		"Junk" },
	{ N_MSG_ITEM_MNR_NAME_ERR,
		"Unknown" },

/* Check Item Data */

	{ N_MSG_CHK_ITEM_DATA_NAME,
		"You detect %s" },
	{ N_MSG_CHK_ITEM_DATA_KIND,
		"This is %s" },

	{ N_MSG_CHK_ITEM_DATA_CAN_USE_MON,
		"You will fight with " STR_MON "(MON)" },

	{ N_MSG_CHK_ITEM_DATA_CAN_NOT_USE_FIG,
		"if equip this then You will limit " STR_FIG "(FIG)" },
	{ N_MSG_CHK_ITEM_DATA_CAN_NOT_USE_MON,
		"if equip this then You will limit " STR_MON "(MON)" },
	{ N_MSG_CHK_ITEM_DATA_CAN_NOT_USE_HUN,
		"if equip this then You will limit " STR_HUN "(HUN)" },
	{ N_MSG_CHK_ITEM_DATA_CAN_NOT_USE_THI,
		"if equip this then You will limit " STR_THI "(THI)" },

	{ N_MSG_CHK_ITEM_DATA_CAN_NOT_USE_MAG,
		"if equip this then You will limit " STR_MAG "(MAG)" },
	{ N_MSG_CHK_ITEM_DATA_CAN_NOT_USE_SOR,
		"if equip this then You will limit " STR_SOR "(SOR)" },
	{ N_MSG_CHK_ITEM_DATA_CAN_NOT_USE_ENC,
		"if equip this then You will limit " STR_ENC "(ENC)" },
	{ N_MSG_CHK_ITEM_DATA_CAN_NOT_USE_SUM,
		"if equip this then You will limit " STR_SUM "(SUM)" },

	{ N_MSG_CHK_ITEM_DATA_CAN_NOT_USE_PRI,
		"if equip this then You will limit " STR_PRI "(PRI)" },
	{ N_MSG_CHK_ITEM_DATA_CAN_NOT_USE_SHA,
		"if equip this then You will limit " STR_SHA "(SHA)" },
	{ N_MSG_CHK_ITEM_DATA_CAN_NOT_USE_BAR,
		"if equip this then You will limit " STR_BAR "(BAR)" },
	{ N_MSG_CHK_ITEM_DATA_CAN_NOT_USE_NIN,
		"if equip this then You will limit " STR_NIN "(NIN)" },

/*  */

	{ N_MSG_WPN_KNIFE,
		"Knife" },
	{ N_MSG_WPN_KRIS_KNIFE,
		"Kris knife" },
	{ N_MSG_WPN_MAIN_GAUCHE,
		"Main=Gauche" },
	{ N_MSG_WPN_SWORD_BREAKER,
		"Sword breaker" },
	{ N_MSG_WPN_KATAR,
		"Katar" },
	{ N_MSG_WPN_JAMADHAR,
		"Jamadhar" },
	{ N_MSG_WPN_KUKRI,
		"Kukri" },

	{ N_MSG_WPN_SHORT_SWORD,
		"Short sword" },
	{ N_MSG_WPN_GLADIUS,
		"Gladius" },

	{ N_MSG_WPN_LONG_SWORD,
		"Long sword" },
	{ N_MSG_WPN_BROAD_SWORD,
		"Broad sword" },
	{ N_MSG_WPN_CLAYMORE,
		"Claymore" },
	{ N_MSG_WPN_BASTARD_SWORD,
		"Bastard sword" },
	{ N_MSG_WPN_GREAT_SWORD,
		"Great sword" },
	{ N_MSG_WPN_EXCALIBUR,
		"Excalibur" },

	{ N_MSG_WPN_SABRE,
		"Sabre" },
	{ N_MSG_WPN_SHAMSHIR,
		"Shamshir" },
	{ N_MSG_WPN_TALWAR,
		"Talwar" },
	{ N_MSG_WPN_FALCHION,
		"Falchion" },
	{ N_MSG_WPN_CUTLASS,
		"Cutlass" },
	{ N_MSG_WPN_SHOTEL,
		"Shotel" },
	{ N_MSG_WPN_KATANA,
		"Katana" },

	{ N_MSG_WPN_RAPIER,
		"Rapier" },
	{ N_MSG_WPN_ESTOC,
		"Estoc" },

	{ N_MSG_WPN_HAND_AXE,
		"Hand axe" },
	{ N_MSG_WPN_FRANCISCA,
		"Francisca" },
	{ N_MSG_WPN_BHUJ,
		"Bhuj" },

	{ N_MSG_WPN_BATTLE_AXE,
		"Battle axe" },
	{ N_MSG_WPN_BROAD_AXE,
		"Broad axe" },
	{ N_MSG_WPN_GREAT_AXE,
		"Great axe" },

	{ N_MSG_WPN_SPEAR,
		"Spear" },
	{ N_MSG_WPN_PILUM,
		"Pilum" },
	{ N_MSG_WPN_PIKE,
		"Pike" },
	{ N_MSG_WPN_JAVELIN,
		"Javelin" },
	{ N_MSG_WPN_TRIDENT,
		"Trident" },

	{ N_MSG_WPN_LANCE,
		"Lance" },
	{ N_MSG_WPN_LANCE_OF_LONGINUS,
		"Lance of longinus" },

	{ N_MSG_WPN_LIGHT_FLAIL,
		"Light flail" },
	{ N_MSG_WPN_HEAVY_FLAIL,
		"Heavy flail" },
	{ N_MSG_WPN_MORNINGSTAR,
		"Morningstar" },
	{ N_MSG_WPN_NUNCHAKUS,
		"Nunchakus" },

	{ N_MSG_WPN_WOODEN_CLUB,
		"Wooden club" },
	{ N_MSG_WPN_QUARTER_STAFF,
		"Quarter staff" },
	{ N_MSG_WPN_LIGHT_MACE,
		"Light mace" },
	{ N_MSG_WPN_HEAVY_MACE,
		"Heavy mace" },

	{ N_MSG_WPN_WAR_HAMMER,
		"War hammer" },
	{ N_MSG_WPN_WAR_PICK,
		"War pick" },
	{ N_MSG_WPN_ZAGHNOL,
		"Zaghnol" },
	{ N_MSG_WPN_BEC_DE_CORBIN,
		"Bec de corbin" },

	{ N_MSG_WPN_PARTIZAN,
		"Partizan" },
	{ N_MSG_WPN_POLEAXE,
		"Poleaxe" },
	{ N_MSG_WPN_GLAIVE,
		"Glaive" },
	{ N_MSG_WPN_HALBERD,
		"Halberd" },
	{ N_MSG_WPN_CHAUVE_SOURIS,
		"Chauve souris" },
	{ N_MSG_WPN_CORSESCA,
		"Corsesca" },
	{ N_MSG_WPN_SCYTHE,
		"Scythe" },
	{ N_MSG_WPN_FAUCHARD,
		"Fauchard" },
	{ N_MSG_WPN_GUISARME,
		"Guisarme" },

	{ N_MSG_WPN_BRASS_KNUCKLE,
		"Brass knuckle" },
	{ N_MSG_WPN_BAGH_NAKH,
		"Bagh nakh" },

	{ N_MSG_WPN_SLING,
		"Sling" },
	{ N_MSG_WPN_SHORT_BOW,
		"Short bow" },
	{ N_MSG_WPN_LONG_BOW,
		"Long bow" },
	{ N_MSG_WPN_COMPOSITE_BOW,
		"Composite bow" },
	{ N_MSG_WPN_LIGHT_CROSS_BOW,
		"Light Cross bow" },
	{ N_MSG_WPN_HEAVY_CROSS_BOW,
		"Heavy Cross bow" },
	{ N_MSG_WPN_BLOW_GUN,
		"Blow gun" },

	{ N_MSG_WPN_STONE,
		"Stone" },
	{ N_MSG_WPN_BULLET,
		"Bullet" },
	{ N_MSG_WPN_ARW,
		"Arw" },
	{ N_MSG_WPN_BOLT,
		"Bolt" },
	{ N_MSG_WPN_NEEDLE,
		"Needle" },

	{ N_MSG_WPN_DAGGER,
		"Dagger" },
	{ N_MSG_WPN_DARTS,
		"Darts" },
	{ N_MSG_WPN_SHURIKEN,
		"Shuriken" },
	{ N_MSG_WPN_BOOMERANG,
		"Boomerang" },

/* ɶ */

	{ N_MSG_ARMOR_LEATHER_CAP,
		"Leather cap" },
	{ N_MSG_ARMOR_METAL_CAP,
		"Metal cap" },
	{ N_MSG_ARMOR_SALLET,
		"Sallet" },
	{ N_MSG_ARMOR_CLOSE_HELMET,
		"Close helmet" },
	{ N_MSG_ARMOR_SILVER_CROWN,
		"Silver crown" },
	{ N_MSG_ARMOR_GOLDEN_CROWN,
		"Golden crown" },
	{ N_MSG_ARMOR_JEWELED_CROWN,
		"Jeweled crown" },

	{ N_MSG_ARMOR_ROBE,
		"Robe" },
	{ N_MSG_ARMOR_SOFT_LEATHER_ARMOR,
		"Soft leather armor" },
	{ N_MSG_ARMOR_HARD_LEATHER_ARMOR,
		"Hard leather armor" },
	{ N_MSG_ARMOR_RING_MAIL,
		"Ring mail" },
	{ N_MSG_ARMOR_SCALE_MAIL,
		"Scale mail" },
	{ N_MSG_ARMOR_RED_DRAGON_SCALE,
		"Red dragon Scale" },
	{ N_MSG_ARMOR_BLUE_DRAGON_SCALE,
		"Blue dragon Scale" },
	{ N_MSG_ARMOR_YELLOW_DRAGON_SCALE,
		"Yellow dragon Scale" },
	{ N_MSG_ARMOR_GREEN_DRAGON_SCALE,
		"Green dragon Scale" },
	{ N_MSG_ARMOR_WHITE_DRAGON_SCALE,
		"White dragon Scale" },
	{ N_MSG_ARMOR_BLACK_DRAGON_SCALE,
		"Black dragon Scale" },
	{ N_MSG_ARMOR_COPPER_DRAGON_SCALE,
		"Copper dragon Scale" },
	{ N_MSG_ARMOR_SILVER_DRAGON_SCALE,
		"Silver dragon Scale" },
	{ N_MSG_ARMOR_GOLD_DRAGON_SCALE,
		"Gold dragon Scale" },
	{ N_MSG_ARMOR_LAMELLAR_ARMOR,
		"Lamellar armor" },
	{ N_MSG_ARMOR_CHAIN_MAIL,
		"Chain mail" },
	{ N_MSG_ARMOR_MITHRIL_CHAIN,
		"Mithril chain" },
	{ N_MSG_ARMOR_PLATE_ARMOR,
		"Plate armor" },

	{ N_MSG_ARMOR_CLOAK,
		"Cloak" },

	{ N_MSG_ARMOR_LEATHER_GLOVES,
		"Leather gloves" },
	{ N_MSG_ARMOR_GAUNTLETS,
		"Gauntlets" },
	{ N_MSG_ARMOR_GAUNTLETS_OF_POW_UP_HIT,
		"Gauntlets (Hit+)" },
	{ N_MSG_ARMOR_GAUNTLETS_OF_POW_DOWN_HIT,
		"Gauntlets (Hit-)" },
	{ N_MSG_ARMOR_GAUNTLETS_OF_POW_UP_WPN_CRTCL,
		"Gauntlets (Critical+)" },
	{ N_MSG_ARMOR_GAUNTLETS_OF_POW_DOWN_WPN_CRTCL,
		"Gauntlets (Critical-)" },
	{ N_MSG_ARMOR_GAUNTLETS_OF_POW_UP_DAM,
		"Gauntlets (Damage+)" },
	{ N_MSG_ARMOR_GAUNTLETS_OF_POW_DOWN_DAM,
		"Gauntlets (Damage-)" },

	{ N_MSG_ARMOR_LEATHER_BOOTS,
		"Leather boots" },
	{ N_MSG_ARMOR_GREAVE,
		"Greave" },
	{ N_MSG_ARMOR_SPEED_BOOTS,
		"Speed boots" },
	{ N_MSG_ARMOR_SLOW_BOOTS,
		"Slow boots" },

	{ N_MSG_ARMOR_BUCKLER_SHIELD,
		"Buckler shield" },
	{ N_MSG_ARMOR_ROUND_SHIELD,
		"Round shield" },
	{ N_MSG_ARMOR_KITE_SHIELD,
		"Kite shield" },
	{ N_MSG_ARMOR_HEATER_SHIELD,
		"Heater shield" },

/* Potion */

	{ N_MSG_POTION_WATER,
		"Water" },
	{ N_MSG_POTION_MILK,
		"Milk" },
	{ N_MSG_POTION_WHITE_WINE,
		"White wine" },
	{ N_MSG_POTION_RED_WINE,
		"Red wine" },
	{ N_MSG_POTION_ROSE_WINE,
		"Rose wine" },
	{ N_MSG_POTION_ALE,
		"Ale" },
	{ N_MSG_POTION_BRANDY,
		"Brandy" },
	{ N_MSG_POTION_RUM,
		"Rum" },
	{ N_MSG_POTION_COFFE,
		"Coffe" },
	{ N_MSG_POTION_ICE_COFFE,
		"Ice coffe" },
	{ N_MSG_POTION_TEA,
		"Tea" },
	{ N_MSG_POTION_MILK_TEA,
		"Milk tea" },
	{ N_MSG_POTION_LEMON_TEA,
		"Lemon tea" },
	{ N_MSG_POTION_ICE_TEA,
		"Ice tea" },
	{ N_MSG_POTION_ICE_MILK_TEA,
		"Ice milk tea" },
	{ N_MSG_POTION_ICE_LEMON_TEA,
		"Ice lemon tea" },
	{ N_MSG_POTION_APPLE_JUICE,
		"Apple juice" },
	{ N_MSG_POTION_GRAPE_JUICE,
		"Grape juice" },
	{ N_MSG_POTION_ORANGE_JUICE,
		"Orange juice" },
	{ N_MSG_POTION_BLACK_BERRY_JUICE,
		"Black berry juice" },
	{ N_MSG_POTION_CRAN_BERRY_JUICE,
		"Cran berry juice" },
	{ N_MSG_POTION_RASP_BERRY_JUICE,
		"Rasp berry juice" },
	{ N_MSG_POTION_STRAW_BERRY_JUICE,
		"Straw berry juice" },
	{ N_MSG_POTION_OIL,
		"Oil" },
	{ N_MSG_POTION_STONE,
		"Potion of stone" },
	{ N_MSG_POTION_PARALYZE,
		"Potion of paralyze" },
	{ N_MSG_POTION_POISON,
		"Potion of poison" },
	{ N_MSG_POTION_CONFUSION,
		"Potion of confusion" },
	{ N_MSG_POTION_BLIND,
		"Potion of blind" },
	{ N_MSG_POTION_SLEEP,
		"Potion of sleep" },
	{ N_MSG_POTION_SILENCE,
		"Potion of silence" },
	{ N_MSG_POTION_FEAR,
		"Potion of fear" },
	{ N_MSG_POTION_HALLUCINATION,
		"Potion of hallucination" },
	{ N_MSG_POTION_CHARM,
		"Potion of charm" },
	{ N_MSG_POTION_FLY,
		"Potion of fly" },
	{ N_MSG_POTION_VANISH,
		"Potion of vanish" },
	{ N_MSG_POTION_IRON_BODY,
		"Potion of iron body" },
	{ N_MSG_POTION_PASSWALL,
		"Potion of passwall" },
	{ N_MSG_POTION_SENSE_INVISIBLE,
		"Potion of sense invisible" },
	{ N_MSG_POTION_CURE_LEV,
		"Potion of cure lev" },
	{ N_MSG_POTION_CURE_HP_LIGHT,
		"Potion of cure HP light" },
	{ N_MSG_POTION_CURE_HP_MODERATE,
		"Potion of cure HP moderate" },
	{ N_MSG_POTION_CURE_HP_SERIOUS,
		"Potion of cure HP serious" },
	{ N_MSG_POTION_CURE_HP_MAX,
		"Potion of cure HP max" },
	{ N_MSG_POTION_CURE_POISON,
		"potion of cure poison" },
	{ N_MSG_POTION_CURE_STATUS,
		"Potion of cure status" },
	{ N_MSG_POTION_RESI_PHYS,
		"Potion of resi PHYS" },
	{ N_MSG_POTION_RESI_HEAT,
		"Potion of resi HEAT" },
	{ N_MSG_POTION_RESI_COLD,
		"Potion of resi COLD" },
	{ N_MSG_POTION_RESI_MIND,
		"Potion of resi MIND" },
	{ N_MSG_POTION_RESI_ACID,
		"Potion of resi ACID" },
	{ N_MSG_POTION_RESI_ELEC,
		"Potion of resi ELEC" },
	{ N_MSG_POTION_RESI_POIS,
		"Potion of resi POIS" },
	{ N_MSG_POTION_SHARPNESS,
		"Potion of sharpness" },
	{ N_MSG_POTION_DULLNESS,
		"Potion of dullness" },
	{ N_MSG_POTION_STRENGTH,
		"Potion of strength" },
	{ N_MSG_POTION_WEAKNESS,
		"Potion of weakness" },
	{ N_MSG_POTION_QUICKNESS,
		"Potion of quickness" },
	{ N_MSG_POTION_SLOWNESS,
		"Potion of slowness" },
	{ N_MSG_POTION_BRAINY,
		"Potion of brainy" },
	{ N_MSG_POTION_BRAINLESS,
		"Potion of brainless" },
	{ N_MSG_POTION_WISE,
		"Potion of wise" },
	{ N_MSG_POTION_FOOLISH,
		"Potion of foolish" },
	{ N_MSG_POTION_ATTRACTIVE,
		"Potion of attractive" },
	{ N_MSG_POTION_UNATTRACTIVE,
		"Potion of unattractive" },
	{ N_MSG_POTION_POW_UP_HP,
		"Potion of pow up HP" },
	{ N_MSG_POTION_SPEED_UP,
		"Potion of speed up" },
	{ N_MSG_POTION_SPEED_DOWN,
		"Potion of speed down" },
	{ N_MSG_POTION_DETECT_MNSTR,
		"Potion of detect mnstr" },

	{ N_MSG_POTION_COLOR_CRYSTAL,
		"Crystal" },
	{ N_MSG_POTION_COLOR_CRYSTAL_WHITE,
		"Crystal white" },
	{ N_MSG_POTION_COLOR_CRYSTAL_BLACK,
		"Crystal black" },
	{ N_MSG_POTION_COLOR_CRYSTAL_RED,
		"Crystal red" },
	{ N_MSG_POTION_COLOR_CRYSTAL_GREEN,
		"Crystal green" },
	{ N_MSG_POTION_COLOR_CRYSTAL_BLUE,
		"Crystal blue" },
	{ N_MSG_POTION_COLOR_CRYSTAL_YELLOW,
		"Crystal yellow" },
	{ N_MSG_POTION_COLOR_CRYSTAL_RED_PURPLE,
		"Crystal red purple" },
	{ N_MSG_POTION_COLOR_CRYSTAL_BLUE_PURPLE,
		"Crystal blue purple" },
	{ N_MSG_POTION_COLOR_CRYSTAL_ORANGE,
		"Crystal orange" },
	{ N_MSG_POTION_COLOR_CRYSTAL_PINK,
		"Crystal pink" },
	{ N_MSG_POTION_COLOR_CRYSTAL_BROWN,
		"Crystal brown" },
	{ N_MSG_POTION_COLOR_WHITE,
		"White" },
	{ N_MSG_POTION_COLOR_BLACK,
		"Black" },
	{ N_MSG_POTION_COLOR_RED,
		"Red" },
	{ N_MSG_POTION_COLOR_GREEN,
		"Green" },
	{ N_MSG_POTION_COLOR_BLUE,
		"Blue" },
	{ N_MSG_POTION_COLOR_YELLOW,
		"Yellow" },
	{ N_MSG_POTION_COLOR_RED_PURPLE,
		"Red purple" },
	{ N_MSG_POTION_COLOR_BLUE_PURPLE,
		"Blue purple" },
	{ N_MSG_POTION_COLOR_ORANGE,
		"Orange" },
	{ N_MSG_POTION_COLOR_PINK,
		"Pink" },
	{ N_MSG_POTION_COLOR_BROWN,
		"Brown" },
	{ N_MSG_POTION_COLOR_LUMINOUS_WHITE,
		"Luminous white" },
	{ N_MSG_POTION_COLOR_LUMINOUS_BLACK,
		"Luminous black" },
	{ N_MSG_POTION_COLOR_LUMINOUS_RED,
		"Luminous red" },
	{ N_MSG_POTION_COLOR_LUMINOUS_GREEN,
		"Luminous green" },
	{ N_MSG_POTION_COLOR_LUMINOUS_BLUE,
		"Luminous blue" },
	{ N_MSG_POTION_COLOR_LUMINOUS_YELLOW,
		"Luminous yellow" },
	{ N_MSG_POTION_COLOR_LUMINOUS_RED_PURPLE,
		"Luminous red purple" },
	{ N_MSG_POTION_COLOR_LUMINOUS_BLUE_PURPLE,
		"Luminous blue purple" },
	{ N_MSG_POTION_COLOR_LUMINOUS_ORANGE,
		"Luminous orange" },
	{ N_MSG_POTION_COLOR_LUMINOUS_PINK,
		"Luminous pink" },
	{ N_MSG_POTION_COLOR_LUMINOUS_BROWN,
		"Luminous brown" },
	{ N_MSG_POTION_COLOR_SPOTTED_WHITE,
		"Spotted white" },
	{ N_MSG_POTION_COLOR_SPOTTED_BLACK,
		"Spotted black" },
	{ N_MSG_POTION_COLOR_SPOTTED_RED,
		"Spotted red" },
	{ N_MSG_POTION_COLOR_SPOTTED_GREEN,
		"Spotted green" },
	{ N_MSG_POTION_COLOR_SPOTTED_BLUE,
		"Spotted blue" },
	{ N_MSG_POTION_COLOR_SPOTTED_YELLOW,
		"Spotted yellow" },
	{ N_MSG_POTION_COLOR_SPOTTED_RED_PURPLE,
		"Spotted red purple" },
	{ N_MSG_POTION_COLOR_SPOTTED_BLUE_PURPLE,
		"Spotted blue purple" },
	{ N_MSG_POTION_COLOR_SPOTTED_ORANGE,
		"Spotted orange" },
	{ N_MSG_POTION_COLOR_SPOTTED_PINK,
		"Spotted pink" },
	{ N_MSG_POTION_COLOR_SPOTTED_BROWN,
		"Spotted brown" },
	{ N_MSG_POTION_COLOR_MILK,
		"Milk" },
	{ N_MSG_POTION_COLOR_WHITE_WINE,
		"White wine" },
	{ N_MSG_POTION_COLOR_RED_WINE,
		"Red wine" },
	{ N_MSG_POTION_COLOR_ROSE_WINE,
		"Rose wine" },
	{ N_MSG_POTION_COLOR_ALE,
		"Ale" },
	{ N_MSG_POTION_COLOR_BRANDY,
		"Brandy" },
	{ N_MSG_POTION_COLOR_RUM,
		"Rum" },
	{ N_MSG_POTION_COLOR_COFFE,
		"Coffe" },
	{ N_MSG_POTION_COLOR_ICE_COFFE,
		"Ice coffe" },
	{ N_MSG_POTION_COLOR_TEA,
		"Tea" },
	{ N_MSG_POTION_COLOR_MILK_TEA,
		"Milk tea" },
	{ N_MSG_POTION_COLOR_LEMON_TEA,
		"Lemon tea" },
	{ N_MSG_POTION_COLOR_ICE_TEA,
		"Ice tea" },
	{ N_MSG_POTION_COLOR_ICE_MILK_TEA,
		"Ice milk tea" },
	{ N_MSG_POTION_COLOR_ICE_LEMON_TEA,
		"Ice lemon tea" },
	{ N_MSG_POTION_COLOR_APPLE_JUICE,
		"Apple juice" },
	{ N_MSG_POTION_COLOR_GRAPE_JUICE,
		"Grape juice" },
	{ N_MSG_POTION_COLOR_ORANGE_JUICE,
		"Orange juice" },
	{ N_MSG_POTION_COLOR_BLACK_BERRY_JUICE,
		"Black berry juice" },
	{ N_MSG_POTION_COLOR_CRAN_BERRY_JUICE,
		"Cran berry juice" },
	{ N_MSG_POTION_COLOR_RASP_BERRY_JUICE,
		"Rasp berry juice" },
	{ N_MSG_POTION_COLOR_STRAW_BERRY_JUICE,
		"Straw berry juice" },

/* Scroll */

	{ N_MSG_SCROLL_SLEEP,
		"Scroll of sleep" },
	{ N_MSG_SCROLL_IDENTIFY_ITEM,
		"Scroll of identify item" },
	{ N_MSG_SCROLL_IDENTIFY_ALL_ITEM,
		"Scroll of identify all item" },
	{ N_MSG_SCROLL_DETECT_ITEM,
		"Scroll of detect item" },
	{ N_MSG_SCROLL_TELEPORT,
		"Scroll of teleport" },
	{ N_MSG_SCROLL_POW_UP_WPN_HIT,
		"Scroll of power up weapon hit" },
	{ N_MSG_SCROLL_POW_UP_WPN_CRTCL,
		"Scroll of power up weapon crtcl" },
	{ N_MSG_SCROLL_POW_UP_WPN_DAM,
		"Scroll of power up weapon dam" },
	{ N_MSG_SCROLL_POW_UP_ARMOR_DEF,
		"Scroll of power up armor def" },
	{ N_MSG_SCROLL_POW_UP_ARMOR_CRTCL,
		"Scroll of power up armor crtcl" },
	{ N_MSG_SCROLL_POW_UP_ARMOR_AC,
		"Scroll of power up armor ac" },
	{ N_MSG_SCROLL_PROTECT_ARMOR,
		"Scroll of protect armor" },
	{ N_MSG_SCROLL_REMOVE_CURSE,
		"Scroll of remove curse" },
	{ N_MSG_SCROLL_RECALL,
		"Scroll of recall" },
	{ N_MSG_SCROLL_TYPHOON,
		"Scroll of typhoon" },
	{ N_MSG_SCROLL_CONFLAGRATION,
		"Scroll of conflagration" },
	{ N_MSG_SCROLL_EARTHQUAKE,
		"Scroll of earthquake" },
	{ N_MSG_SCROLL_THUNDERCLOUD,
		"Scroll of thundercloud" },
	{ N_MSG_SCROLL_INUNDATION,
		"Scroll of inundation" },
	{ N_MSG_SCROLL_SUBSTITUTE,
		"Scroll of substitute" },
	{ N_MSG_SCROLL_BURNING_HANDS,
		"Scroll of burning hands" },
	{ N_MSG_SCROLL_RALLY,
		"Scroll of try again even harder" },
	{ N_MSG_SCROLL_IRON_MAN,
		"Scroll of iron man" },
	{ N_MSG_SCROLL_MIND_READING,
		"Scroll of mind reading" },

	{ N_MSG_READ_SCROLL_FAILURE,
		"%s can't read scroll because around is darkness" },

	{ N_MSG_SCROLL_TTL_SYLLABLE_DIV,
		"-" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_000,
		"A" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_001,
		"IN" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_002,
		"THE" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_010,
		"ON" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_011,
		"KIRI-KIRI" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_012,
		"BASARA" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_013,
		"NHATTA" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_020,
		"ABURA" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_021,
		"KADABURA" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_030,
		"BIBIDE" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_031,
		"BABIDE" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_032,
		"BOO" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_040,
		"SYO" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_041,
		"GYO" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_042,
		"MUJOU" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_050,
		"NAM" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_051,
		"AMIDA" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_052,
		"BUTSU" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_060,
		"KESERAN" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_061,
		"PASARAN" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_070,
		"ERO" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_071,
		"IMM" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_072,
		"ESSAIM" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_080,
		"MINO" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_081,
		"MON" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_082,
		"TA" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_090,
		"KUKKU" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_091,
		"DODORU" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_092,
		"DOO" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_101,
		"YUNA" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_102,
		"DABU" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_103,
		"TRAY" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_104,
		"TETO" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_110,
		"HIKI" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_111,
		"REKI" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_120,
		"KESERA" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_121,
		"SERA" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_130,
		"ENNYA" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_131,
		"KORYA" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_140,
		"UN" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_141,
		"PON" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_142,
		"TAN" },

/* Stick */

	{ N_MSG_STICK_FAILURE,
		"Nothing happened." },

	{ N_MSG_STICK_MATERIAL_APPLEWOOD,
		"Applewood" },
	{ N_MSG_STICK_MATERIAL_ASHEN,
		"Ashen" },
	{ N_MSG_STICK_MATERIAL_ASPEN,
		"Aspen" },
	{ N_MSG_STICK_MATERIAL_AVOCADO_WOOD,
		"Avocado Wood" },
	{ N_MSG_STICK_MATERIAL_BALSA,
		"Balsa" },
	{ N_MSG_STICK_MATERIAL_BANYAN,
		"Banyan" },
	{ N_MSG_STICK_MATERIAL_BIRCH,
		"Birch" },
	{ N_MSG_STICK_MATERIAL_CEDAR,
		"Cedar" },
	{ N_MSG_STICK_MATERIAL_CHERRYWOOD,
		"Cherrywood" },
	{ N_MSG_STICK_MATERIAL_COTTONWOOD,
		"Cottonwood" },
	{ N_MSG_STICK_MATERIAL_CYPRESS,
		"Cypress" },
	{ N_MSG_STICK_MATERIAL_DOGWOOD,
		"Dogwood" },
	{ N_MSG_STICK_MATERIAL_DRIFTWOOD,
		"Driftwood" },
	{ N_MSG_STICK_MATERIAL_EBONY,
		"Ebony" },
	{ N_MSG_STICK_MATERIAL_ELM_WOOD,
		"Elm Wood" },
	{ N_MSG_STICK_MATERIAL_EUCALYPTUS,
		"Eucalyptus" },
	{ N_MSG_STICK_MATERIAL_GRAPEVINE,
		"Grapevine" },
	{ N_MSG_STICK_MATERIAL_HAWTHORN,
		"Hawthorn" },
	{ N_MSG_STICK_MATERIAL_HEMLOCK,
		"Hemlock" },
	{ N_MSG_STICK_MATERIAL_HICKORY,
		"Hickory" },
	{ N_MSG_STICK_MATERIAL_JUNIPER,
		"Juniper" },
	{ N_MSG_STICK_MATERIAL_LOCUST,
		"Locust" },
	{ N_MSG_STICK_MATERIAL_MAHOGANY,
		"Mahogany" },
	{ N_MSG_STICK_MATERIAL_MAGNOLIA,
		"Magnolia" },
	{ N_MSG_STICK_MATERIAL_MAPLE,
		"Maple" },
	{ N_MSG_STICK_MATERIAL_MULBERRY,
		"Mulberry" },
	{ N_MSG_STICK_MATERIAL_OAK,
		"Oak" },
	{ N_MSG_STICK_MATERIAL_PECAN,
		"Pecan" },
	{ N_MSG_STICK_MATERIAL_PERSIMMON,
		"Persimmon" },
	{ N_MSG_STICK_MATERIAL_PINE,
		"Pine" },
	{ N_MSG_STICK_MATERIAL_REDWOOD,
		"Redwood" },
	{ N_MSG_STICK_MATERIAL_ROSEWOOD,
		"Rosewood" },
	{ N_MSG_STICK_MATERIAL_SPRUCE,
		"Spruce" },
	{ N_MSG_STICK_MATERIAL_SUMAC,
		"Sumac" },
	{ N_MSG_STICK_MATERIAL_SYCAMORE,
		"Sycamore" },
	{ N_MSG_STICK_MATERIAL_TEAK,
		"Teak" },
	{ N_MSG_STICK_MATERIAL_WALNUT,
		"Walnut" },

/* Accecery */

	{ N_MSG_RING_SLOW_DIGESTION,
		"Ring of slow digestion" },
	{ N_MSG_RING_TELEPORT_PARTY,
		"Ring of teleport party" },
	{ N_MSG_RING_TELEPORT,
		"Ring of teleport" },
	{ N_MSG_RING_SHARPNESS,
		"Ring of sharpness" },
	{ N_MSG_RING_DULLNESS,
		"Ring of dullness" },
	{ N_MSG_RING_STRENGTH,
		"Ring of strength" },
	{ N_MSG_RING_WEAKNESS,
		"Ring of weakness" },
	{ N_MSG_RING_QUICKNESS,
		"Ring of quickness" },
	{ N_MSG_RING_SLOWNESS,
		"Ring of slowness" },
	{ N_MSG_RING_BRAINY,
		"Ring of brainy" },
	{ N_MSG_RING_BRAINLESS,
		"Ring of brainless" },
	{ N_MSG_RING_WISE,
		"Ring of wise" },
	{ N_MSG_RING_FOOLISH,
		"Ring of foolish" },
	{ N_MSG_RING_ATTRACTIVE,
		"Ring of attractive" },
	{ N_MSG_RING_UNATTRACTIVE,
		"Ring of unattractive" },
	{ N_MSG_RING_CURE_HP,
		"Ring of cure HP" },
	{ N_MSG_RING_CURE_MP,
		"Ring of cure MP" },
	{ N_MSG_RING_DRAIN_HP,
		"Ring of drain HP" },
	{ N_MSG_RING_DRAIN_MP,
		"Ring of drain MP" },

	{ N_MSG_AMULET_RESI_STAT_DEAD,
		"Amulet of resist dead" },
	{ N_MSG_AMULET_RESI_STAT_STONE,
		"Amulet of resist stone" },
	{ N_MSG_AMULET_RESI_STAT_PARALYZE,
		"Amulet of resist paralyze" },
	{ N_MSG_AMULET_RESI_STAT_POISON,
		"Amulet of resist poison" },
	{ N_MSG_AMULET_RESI_STAT_CONFUSION,
		"Amulet of resist confusion" },
	{ N_MSG_AMULET_RESI_STAT_BLIND,
		"Amulet of resist blind" },
	{ N_MSG_AMULET_RESI_STAT_SLEEP,
		"Amulet of resist sleep" },
	{ N_MSG_AMULET_RESI_STAT_SILENCE,
		"Amulet of resist silence" },
	{ N_MSG_AMULET_RESI_STAT_FEAR,
		"Amulet of resist fear" },
	{ N_MSG_AMULET_RESI_STAT_HALLUCINATION,
		"Amulet of resist hallucination" },
	{ N_MSG_AMULET_RESI_STAT_CHARM,
		"Amulet of resist charm" },
	{ N_MSG_AMULET_RESI_STAT_DRUNK,
		"Amulet of resist drunk" },
	{ N_MSG_AMULET_RESI_STAT_FLY,
		"Amulet of resist fly" },
	{ N_MSG_AMULET_RESI_STAT_VANISH,
		"Amulet of resist vanish" },
	{ N_MSG_AMULET_RESI_STAT_IRON_BODY,
		"Amulet of resist iron body" },
	{ N_MSG_AMULET_RESI_STAT_PASSWALL,
		"Amulet of resist passwall" },
	{ N_MSG_AMULET_RESI_STAT_SENSE_INVISIBLE,
		"Amulet of resist sense invisible" },

	{ N_MSG_NECKLACE_RESI_PHYS,
		"Necklace of resist PHYS" },
	{ N_MSG_NECKLACE_RESI_HEAT,
		"Necklace of resist HEAT" },
	{ N_MSG_NECKLACE_RESI_COLD,
		"Necklace of resist COLD" },
	{ N_MSG_NECKLACE_RESI_MIND,
		"Necklace of resist MIND" },
	{ N_MSG_NECKLACE_RESI_ACID,
		"Necklace of resist ACID" },
	{ N_MSG_NECKLACE_RESI_ELEC,
		"Necklace of resist ELEC" },
	{ N_MSG_NECKLACE_RESI_POIS,
		"Necklace of resist POIS" },

	{ N_MSG_NECKLACE_CURSE_PHYS,
		"Necklace of weak PHYS" },
	{ N_MSG_NECKLACE_CURSE_HEAT,
		"Necklace of weak HEAT" },
	{ N_MSG_NECKLACE_CURSE_COLD,
		"Necklace of weak COLD" },
	{ N_MSG_NECKLACE_CURSE_MIND,
		"Necklace of weak MIND" },
	{ N_MSG_NECKLACE_CURSE_ACID,
		"Necklace of weak ACID" },
	{ N_MSG_NECKLACE_CURSE_ELEC,
		"Necklace of weak ELEC" },
	{ N_MSG_NECKLACE_CURSE_POIS,
		"Necklace of weak POIS" },

	{ N_MSG_ACCE_MATERIAL_BONE,
		"Bone" },
	{ N_MSG_ACCE_MATERIAL_GOLD,
		"Gold" },
	{ N_MSG_ACCE_MATERIAL_SILVER,
		"Silver" },

	{ N_MSG_ACCE_GEM_AMBER,
		"Amber" },
	{ N_MSG_ACCE_GEM_AGATE,
		"Agate" },
	{ N_MSG_ACCE_GEM_ALEXANDRITE,
		"Alexandrite" },
	{ N_MSG_ACCE_GEM_AMETHYST,
		"Amethyst" },
	{ N_MSG_ACCE_GEM_ANTLERITE,
		"Antlerite" },
	{ N_MSG_ACCE_GEM_AQUAMARINE,
		"Aquamarine" },
	{ N_MSG_ACCE_GEM_ARGENTITE,
		"Argentite" },
	{ N_MSG_ACCE_GEM_AZURITE,
		"Azurite" },
	{ N_MSG_ACCE_GEM_BERYL,
		"Beryl" },
	{ N_MSG_ACCE_GEM_BLOODSTONE,
		"Bloodstone" },
	{ N_MSG_ACCE_GEM_CALCITE,
		"Calcite" },
	{ N_MSG_ACCE_GEM_CARNELIAN,
		"Carnelian" },
	{ N_MSG_ACCE_GEM_CORAL,
		"Coral" },
	{ N_MSG_ACCE_GEM_CORUNDUM,
		"Corundum" },
	{ N_MSG_ACCE_GEM_CRYOLITE,
		"Cryolite" },
	{ N_MSG_ACCE_GEM_DIAMOND,
		"Diamond" },
	{ N_MSG_ACCE_GEM_DIORITE,
		"Diorite" },
	{ N_MSG_ACCE_GEM_EMERALD,
		"Emerald" },
	{ N_MSG_ACCE_GEM_FLINT,
		"Flint" },
	{ N_MSG_ACCE_GEM_FLUORITE,
		"Fluorite" },
	{ N_MSG_ACCE_GEM_GABBRO,
		"Gabbro" },
	{ N_MSG_ACCE_GEM_GARNET,
		"Garnet" },
	{ N_MSG_ACCE_GEM_GRANITE,
		"Granite" },
	{ N_MSG_ACCE_GEM_GYPSUM,
		"Gypsum" },
	{ N_MSG_ACCE_GEM_HEMATITE,
		"Hematite" },
	{ N_MSG_ACCE_GEM_JADE,
		"Jade" },
	{ N_MSG_ACCE_GEM_JASPER,
		"Jasper" },
	{ N_MSG_ACCE_GEM_KRYPTONITE,
		"Kryptonite" },
	{ N_MSG_ACCE_GEM_LAPIS_LAZULI,
		"Lapis_LAZULI" },
	{ N_MSG_ACCE_GEM_LIMESTONE,
		"Limestone" },
	{ N_MSG_ACCE_GEM_MALACHITE,
		"Malachite" },
	{ N_MSG_ACCE_GEM_MANGANITE,
		"Manganite" },
	{ N_MSG_ACCE_GEM_MARBLE,
		"Marble" },
	{ N_MSG_ACCE_GEM_MOONSTONE,
		"Moonstone" },
	{ N_MSG_ACCE_GEM_NEPTUNITE,
		"Neptunite" },
	{ N_MSG_ACCE_GEM_OBSIDIAN,
		"Obsidian" },
	{ N_MSG_ACCE_GEM_ONYX,
		"Onyx" },
	{ N_MSG_ACCE_GEM_OPAL,
		"Opal" },
	{ N_MSG_ACCE_GEM_PEARL,
		"Pearl" },
	{ N_MSG_ACCE_GEM_PYRITES,
		"Pyrites" },
	{ N_MSG_ACCE_GEM_QUARTZ,
		"Quartz" },
	{ N_MSG_ACCE_GEM_QUARTZITE,
		"Quartzite" },
	{ N_MSG_ACCE_GEM_RHODONITE,
		"Rhodonite" },
	{ N_MSG_ACCE_GEM_RHYOLITE,
		"Rhyolite" },
	{ N_MSG_ACCE_GEM_RUBY,
		"Ruby" },
	{ N_MSG_ACCE_GEM_SAPPHIRE,
		"Sapphire" },
	{ N_MSG_ACCE_GEM_SPHALERITE,
		"Sphalerite" },
	{ N_MSG_ACCE_GEM_STAUROLITE,
		"Staurolite" },
	{ N_MSG_ACCE_GEM_TIGER_EYE,
		"Tiger_EYE" },
	{ N_MSG_ACCE_GEM_TOPAZ,
		"Topaz" },
	{ N_MSG_ACCE_GEM_TURQUOISE,
		"Turquoise" },
	{ N_MSG_ACCE_GEM_ZIRCON,
		"Zircon" },

/* Musical Instrument */

	{ N_MSG_INST_TRUMPET,
		"Trumpet" },
	{ N_MSG_INST_TROMBONE,
		"Trombone" },
	{ N_MSG_INST_FLUGELHORN,
		"Flugelhorn" },
	{ N_MSG_INST_CORNET,
		"Cornet" },
	{ N_MSG_INST_HORN,
		"Horn" },
	{ N_MSG_INST_TUBA,
		"Tuba" },
	{ N_MSG_INST_SOUSAPHONE,
		"Sousaphone" },
	{ N_MSG_INST_BUGLE,
		"Bugle" },
	{ N_MSG_INST_FLUTE,
		"Flute" },
	{ N_MSG_INST_CLARINET,
		"Clarinet" },
	{ N_MSG_INST_BASS_CLARINET,
		"Bass clarinet" },
	{ N_MSG_INST_PICCOLO,
		"Piccolo" },
	{ N_MSG_INST_OBOE,
		"Oboe" },
	{ N_MSG_INST_BASSOON,
		"Bassoon" },
	{ N_MSG_INST_SAXOPHONE,
		"Saxophone" },
	{ N_MSG_INST_VIOLIN,
		"Violin" },
	{ N_MSG_INST_VIOLA,
		"Viola" },
	{ N_MSG_INST_CELLO,
		"Cello" },
	{ N_MSG_INST_DOUBLEBASS,
		"Doublebass" },
	{ N_MSG_INST_HARP,
		"Harp" },
	{ N_MSG_INST_MANDOLIN,
		"Mandolin" },
	{ N_MSG_INST_BANJO,
		"Banjo" },
	{ N_MSG_INST_SITAR,
		"Sitar" },
	{ N_MSG_INST_BASS_DRUM,
		"Bass drum" },
	{ N_MSG_INST_TENOR_DRUM,
		"Tenor drum" },
	{ N_MSG_INST_SNARE_DRUM,
		"Snare drum" },
	{ N_MSG_INST_TOMTOM,
		"Tomtom" },
	{ N_MSG_INST_CONGAS,
		"Congas" },
	{ N_MSG_INST_TIMPANI,
		"Timpani" },
	{ N_MSG_INST_CYMBAL,
		"Cymbal" },
	{ N_MSG_INST_GONG,
		"Gong" },
	{ N_MSG_INST_MARACA,
		"Maraca" },
	{ N_MSG_INST_TRIANGLE,
		"Triangle" },
	{ N_MSG_INST_CASTANETS,
		"Castanets" },
	{ N_MSG_INST_TUBULAR_BELLS,
		"Tubular bells" },
	{ N_MSG_INST_XYLOPHONE,
		"Xylophone" },
	{ N_MSG_INST_ACCORDION,
		"Accordion" },
	{ N_MSG_INST_BAGPIPE,
		"Bagpipe" },
	{ N_MSG_INST_HARMONICA,
		"Harmonica" },
	{ N_MSG_INST_KAZOO,
		"Kazoo" },

/* Anthology */

	{ N_MSG_ANTHOLOGY_CURE,
		"Anthology of love (Cure)" },
	{ N_MSG_ANTHOLOGY_STRENGTHEN_ABL,
		"Anthology of superior (Strengthen Ability)" },
	{ N_MSG_ANTHOLOGY_WEAKEN_ABL,
		"Anthology of evil (Weaken Ability)" },
	{ N_MSG_ANTHOLOGY_RESI_STAT,
		"Anthology of wise men (Resist Status)" },

/* Light */

	{ N_MSG_LIGHT_TORCH,
		"Torch" },
	{ N_MSG_LIGHT_LANTERN,
		"Lantern" },
	{ N_MSG_LIGHT_LAMP,
		"Lamp" },

/* Spike */

	{ N_MSG_SPIKE,
		"Spike" },

/* Food */

	{ N_MSG_FOOD_PRESERVED,
		"Preserved food" },
	{ N_MSG_FOOD_SAUSAGE,
		"Sausage" },
	{ N_MSG_FOOD_BACON,
		"Bacon" },
	{ N_MSG_FOOD_CHIPPED_BEEF,
		"Chipped beef" },
	{ N_MSG_FOOD_CORNED_BEEF,
		"Corned beef" },
	{ N_MSG_FOOD_BREAD,
		"Bread" },
	{ N_MSG_FOOD_BROWN_BREAD,
		"Brown bread" },
	{ N_MSG_FOOD_TOAST,
		"Toast" },
	{ N_MSG_FOOD_PANCAKE,
		"Pancake" },
	{ N_MSG_FOOD_SALAD,
		"Salad" },
	{ N_MSG_FOOD_POTATO_SALAD,
		"Potato salad" },
	{ N_MSG_FOOD_SCRAMBLED_EGGS,
		"Scrambled eggs" },
	{ N_MSG_FOOD_FRIED_EGGS,
		"Fried eggs" },
	{ N_MSG_FOOD_HARD_BOILED_EGGS,
		"Hard boiled eggs" },
	{ N_MSG_FOOD_SOFT_BOILED_EGGS,
		"Soft boiled eggs" },
	{ N_MSG_FOOD_BEEF_STEAK,
		"Beef steak" },
	{ N_MSG_FOOD_PORK_SAUTE,
		"Pork saute" },
	{ N_MSG_FOOD_FRIED_CHICKEN,
		"Fried chicken" },
	{ N_MSG_FOOD_FRIED_FISH,
		"Fried fish" },
	{ N_MSG_FOOD_FRIED_POTATO,
		"Fried potato" },
	{ N_MSG_FOOD_STEWED_BEEF,
		"Stewed beef" },
	{ N_MSG_FOOD_CONSOMME,
		"Consomme" },
	{ N_MSG_FOOD_POTAGE,
		"Potage" },
	{ N_MSG_FOOD_APPLE_PIE,
		"Apple pie" },
	{ N_MSG_FOOD_APPLE,
		"Apple" },
	{ N_MSG_FOOD_GRAPE,
		"Grape" },
	{ N_MSG_FOOD_ORANGE,
		"Orange" },
	{ N_MSG_FOOD_PEAR,
		"Pear" },
	{ N_MSG_FOOD_GRAPEFRUIT,
		"Grapefruit" },
	{ N_MSG_FOOD_PLUM,
		"Plum" },
	{ N_MSG_FOOD_PEACH,
		"Peach" },
	{ N_MSG_FOOD_APRICOT,
		"Apricot" },
	{ N_MSG_FOOD_BLACK_BERRY,
		"Black berry" },
	{ N_MSG_FOOD_CRAN_BERRY,
		"Cran berry" },
	{ N_MSG_FOOD_RASP_BERRY,
		"Rasp berry" },
	{ N_MSG_FOOD_STRAW_BERRY,
		"Straw berry" },

/* Chest */

	{ N_MSG_CHEST,
		"Chest" },

/* Tobacco */

	{ N_MSG_TOBACCO_CIGARET,
		"Cigaret" },
	{ N_MSG_TOBACCO_CIGAR,
		"Cigar" },
	{ N_MSG_TOBACCO_CUT_TOBACCO,
		"Cut tobacco" },
	{ N_MSG_TOBACCO_SNUFF_TOBACCO,
		"Snuff tobacco" },
	{ N_MSG_TOBACCO_CHEWING_TOBACCO,
		"Chewing tobacco" },
	{ N_MSG_TOBACCO_ABSTAIN_GUM,
		"Abstain gum" },

/* CIGARET */
	{ N_MSG_TOBACCO_BRAND_HELLO,
		"HELLO" },
	{ N_MSG_TOBACCO_BRAND_SUN_SHINE,
		"SUN SHINE" },
	{ N_MSG_TOBACCO_BRAND_CHERRY_TREE,
		"CHERRY TREE" },
	{ N_MSG_TOBACCO_BRAND_GOLDEN_RAT,
		"GOLDEN RAT" },
	{ N_MSG_TOBACCO_BRAND_AIR_SHIT,
		"AIR SHIT" },
	{ N_MSG_TOBACCO_BRAND_HOP,
		"HOP" },
	{ N_MSG_TOBACCO_BRAND_PIECE,
		"PIECE" },
	{ N_MSG_TOBACCO_BRAND_HARPY,
		"HARPY" },
	{ N_MSG_TOBACCO_BRAND_HIGH_LIGHT,
		"HIGH LIGHT" },
	{ N_MSG_TOBACCO_BRAND_SHOOTING_STARS,
		"SHOOTING STARS" },
	{ N_MSG_TOBACCO_BRAND_WILD_NINE,
		"WILD NINE" },
	{ N_MSG_TOBACCO_BRAND_WILD_NINE_MENTHOL,
		"WILD NINE MENTHOL" },
	{ N_MSG_TOBACCO_BRAND_LODGE,
		"LODGE" },
	{ N_MSG_TOBACCO_BRAND_LODGE_MENTHOL,
		"LODGE MENTHOL" },
	{ N_MSG_TOBACCO_BRAND_CANCER,
		"CANCER" },
	{ N_MSG_TOBACCO_BRAND_CANCER_MENTHOL,
		"CANCER MENTHOL" },
	{ N_MSG_TOBACCO_BRAND_FRONT_LINE,
		"FRONT LINE" },
	{ N_MSG_TOBACCO_BRAND_FRONT_LINE_MENTHOL,
		"FRONT LINE MENTHOL" },
	{ N_MSG_TOBACCO_BRAND_MARCO_POLO,
		"MARCO POLO" },
	{ N_MSG_TOBACCO_BRAND_CAMELLIA,
		"CAMELLIA" },
	{ N_MSG_TOBACCO_BRAND_GOOD_LUCK,
		"GOOD LUCK" },
	{ N_MSG_TOBACCO_BRAND_BAD_GUY,
		"BAD GUY" },

/* CIGAR */
	{ N_MSG_TOBACCO_BRAND_ARCADIA,
		"ARCADIA" },
	{ N_MSG_TOBACCO_BRAND_GLORIA,
		"GLORIA" },
	{ N_MSG_TOBACCO_BRAND_VULCAN,
		"VULCAN" },
	{ N_MSG_TOBACCO_BRAND_PONY,
		"PONY" },
	{ N_MSG_TOBACCO_BRAND_KEITH,
		"KEITH" },
	{ N_MSG_TOBACCO_BRAND_LUMBERJACK,
		"LUMBERJACK" },
	{ N_MSG_TOBACCO_BRAND_CORONA,
		"CORONA" },
	{ N_MSG_TOBACCO_BRAND_HALF_CORONA,
		"HALF CORONA" },
	{ N_MSG_TOBACCO_BRAND_CRYSTAL,
		"CRYSTAL" },

/* CUT TOBACCO */
	{ N_MSG_TOBACCO_BRAND_FOREST_BRANDY,
		"FOREST BRANDY" },
	{ N_MSG_TOBACCO_BRAND_SILK_ROAD,
		"SILK ROAD" },
	{ N_MSG_TOBACCO_BRAND_PROMENADE,
		"PROMENADE" },
	{ N_MSG_TOBACCO_BRAND_BIG_HORN,
		"BIG HORN" },
	{ N_MSG_TOBACCO_BRAND_ROCKING_CHAIR,
		"ROCKING CHAIR" },
	{ N_MSG_TOBACCO_BRAND_VANILLA,
		"VANILLA" },
	{ N_MSG_TOBACCO_BRAND_WILD_MANGO,
		"WILD MANGO" },
	{ N_MSG_TOBACCO_BRAND_KENTUCKY_BIRD,
		"KENTUCKY BIRD" },
	{ N_MSG_TOBACCO_BRAND_ORIENT,
		"ORIENT" },
	{ N_MSG_TOBACCO_BRAND_FUJI,
		"FUJI" },

/* SNUFF TOBACCO */
	{ N_MSG_TOBACCO_BRAND_DOGGY_APRICOT,
		"DOGGY APRICOT" },
	{ N_MSG_TOBACCO_BRAND_DOGGY_WHISKY,
		"DOGGY WHISKY" },
	{ N_MSG_TOBACCO_BRAND_DOGGY_HONEY,
		"DOGGY HONEY" },
	{ N_MSG_TOBACCO_BRAND_DOGGY_SPEARMINT,
		"DOGGY SPEARMINT" },
	{ N_MSG_TOBACCO_BRAND_DOGGY_PEPPERMINT,
		"DOGGY PEPPERMINT" },
	{ N_MSG_TOBACCO_BRAND_DOGGY_VANILLA,
		"DOGGY VANILLA" },
	{ N_MSG_TOBACCO_BRAND_DOGGY_MENTHOL,
		"DOGGY MENTHOL" },
	{ N_MSG_TOBACCO_BRAND_DOGGY_CITRUS,
		"DOGGY CITRUS" },
	{ N_MSG_TOBACCO_BRAND_DOGGY_SHERRY,
		"DOGGY SHERRY" },

/* CHEWING TOBACCO */
	{ N_MSG_TOBACCO_BRAND_ROSE_PREMIUM,
		"ROSE PREMIUM" },
	{ N_MSG_TOBACCO_BRAND_ROSE_VANILLA,
		"ROSE VANILLA" },
	{ N_MSG_TOBACCO_BRAND_ROSE_MENTHOL,
		"ROSE MENTHOL" },

/* ABSTAIN GUM */
	{ N_MSG_TOBACCO_BRAND_NICOTIME,
		"NICOTIME" },

/* STUB */
	{ N_MSG_TOBACCO_STUB,
		"Stub" },

/* PIPE */
	{ N_MSG_PIPE_PIPE,
		"Pipe" },
	{ N_MSG_PIPE_KISEL,
		"Kisel" },
	{ N_MSG_PIPE_CIGARET_HOLDER,
		"Cigaret holder" },
	{ N_MSG_PIPE_STUB,
		"Stub" },

	{ N_MSG_SMOKE_FAILURE,
		"You must equip pipe" },

/* RARE_GOODS */
	{ N_MSG_RARE_GOODS_DAEMON_SCORE,
		"Daemon's score" },
	{ N_MSG_RARE_GOODS_VAMPIRES_CROSS,
		"Vampire's cross" },
	{ N_MSG_RARE_GOODS_SCHWARZSCHILD_DAEMON,
		"Schwarzschild daemon" },
	{ N_MSG_RARE_GOODS_REASON_OF_DECLINE,
		"Reason of all that prosper must decline" },
	{ N_MSG_RARE_GOODS_GARGOYLES_TEARS,
		"Gargoyle's tears" },
	{ N_MSG_RARE_GOODS_FLUTE_OF_MADONNA,
		"Flute of the madonna" },
	{ N_MSG_RARE_GOODS_THE_ART_OF_WAR,
		"The art of war peace reigns over the land" },
	{ N_MSG_RARE_GOODS_TICKET_TO_PARADISE,
		"Ticket to paradise" },
	{ N_MSG_RARE_GOODS_CALL_OF_HADES,
		"Call of hades" },
	{ N_MSG_RARE_GOODS_MEMORIES_OF_THE_GOLDEN_AGE,
		"Memories of the golden age" },
	{ N_MSG_RARE_GOODS_ISNT_REALIZED,
		"Feeling which isn't realized" },

/* GOLD */

	{ N_MSG_COIN_GOLD,
		STR_GOLD },
	{ N_MSG_COIN_SILVER,
		"Silver coins" },
	{ N_MSG_COIN_COPPER,
		"Copper coins" },

/* MISC */

	{ N_MSG_JUNK,
		"Junk" },

/**/

	{ N_MSG_TRGT,
		"Terget" },

/* mbr act */

	{ N_MSG_DOWN_DUN,
		"It came down the stairs with all of the members." },
	{ N_MSG_UP_DUN,
		"It went up the stairs with all of the members." },
	{ N_MSG_UP_DOWN_DUN_FLOOR,
		"A party arrived at the ground the %ld floor." },
	{ N_MSG_UP_DOWN_DUN_BASE,
		"A party arrived at the underground the %ld floor." },
	{ N_MSG_UP_DOWN_DUN_GROUND,
		"A party arrived at the town." },
	{ N_MSG_FEEL_BOSS,
		"A party felt a powerful enemy" },
	{ N_MSG_BOSS_FIND_MBR,
		"It was found by powerful enemy's %s !" },

	{ N_MSG_COLLECT_GOLD,
		"%s Yamadas were gathered " STR_GOLD_FMT "." },
	{ N_MSG_DIVIDE_GOLD,
		"Each member distributed " STR_GOLD_FMT "." },
	{ N_MSG_GIVE_GOLD,
		"%s pass " STR_GOLD_FMT " to %s." },
	{ N_MSG_NOT_FRIEND_GOLD,
		"%s refused the exchange of the " STR_GOLD },

	{ N_MSG_STOMACH_FULL,
		"As for %s, a stomach became stomach." },

	{ N_MSG_STEAL_ITEM_1,
		"%s stole a sword from %s." },
	{ N_MSG_STEAL_ITEM_2,
		"%s got a %s." },
	{ N_MSG_STEAL_ITEM_FAILURE,
		"%s couldn't steal a item." },

	{ N_MSG_DOOR_OPEN,
		"%s opened a door." },
	{ N_MSG_DOOR_CLOSE,
		"%s closed a door." },
	{ N_MSG_DOOR_JAM,
		"%s fixed a door." },
	{ N_MSG_DOOR_DISARM,
		"%s canceled the fixation of the door." },
	{ N_MSG_DOOR_BREAK,
		"%s broke a door." },
	{ N_MSG_DOOR_SRCH,
		"%s find a door." },

	{ N_MSG_CHK_DOOR_SHOP,
		"It is the door of the %s" },
	{ N_MSG_CHK_DOOR_OPEN,
		"This door is open." },
	{ N_MSG_CHK_DOOR_CLOSE,
		"This door is close." },
	{ N_MSG_CHK_DOOR_JAMMED,
		"This door is fixed." },
	{ N_MSG_CHK_DOOR_BROKEN,
		"This door breaks." },

	{ N_MSG_TRAP_DISARM,
		"%s canceled a trap." },
	{ N_MSG_TRAP_BREAK,
		"%s broke a trap." },
	{ N_MSG_TRAP_SRCH,
		"%s find a trap." },

	{ N_MSG_CHK_TRAP,
		"This is a %s" },

	{ N_MSG_ITEM_PICK_UP,
		"%s picked up a %s." },
	{ N_MSG_ITEM_OPEN,
		"%s opened a %s." },
	{ N_MSG_ITEM_DISARM,
		"%s canceled the key of the %s." },
	{ N_MSG_ITEM_DISARM_ALREADY,
		"The key of the %s is already open." },
	{ N_MSG_ITEM_BREAK,
		"%s broke a %s." },

	{ N_MSG_CHK_ITEM,
		"This is a %s." },

	{ N_MSG_READY_THROW_CHEST,
		"On the inside something the %s." },

	{ N_MSG_DONT_EXHIBIT_ABL_EQUIP,
		"%s can't show the ability of the %s"
		" because of the equipment."
	},

	{ N_MSG_ERR_HP_SHORT,
		"%s isn't enough for HP by %ld." },
	{ N_MSG_ERR_MP_SHORT,
		"%s isn't enough for MP by %ld." },
	{ N_MSG_ERR_GOLD_SHORT,
		"%s isn't enough for the " STR_GOLD " by %ld." },
	{ N_MSG_ERR_RESI_SHORT,
		"%s isn't enough for the tolerance value by %ld" },

/* FX */

	{ N_MSG_FX_QUAFF_POTION,
		"%s quaff the %s." },
	{ N_MSG_FX_READ_SCROLL,
		"%s read the %s." },
	{ N_MSG_FX_ZAP_STICK,
		"%s zap the %s." },
	{ N_MSG_EAT_FOOD,
		"%s eat the %s." },
	{ N_MSG_MNSTR_CATCH_FOOD,
		"%s take the bait." },
	{ N_MSG_FILL_LAMP_OIL,
		"%s refueled to the %s." },

	{ N_MSG_FX_STONE,
		"%s is stoned." },
	{ N_MSG_FX_PARALYZE,
		"%s is paralyzed." },
	{ N_MSG_FX_POISON,
		"%s is poisoned." },
	{ N_MSG_FX_CONFUSION,
		"%s is confusioned." },
	{ N_MSG_FX_BLIND,
		"%s is blinded." },
	{ N_MSG_FX_SLEEP,
		"%s is sleept." },
	{ N_MSG_FX_SILENCE,
		"%s is silenced." },
	{ N_MSG_FX_FEAR,
		"%s is feared." },
	{ N_MSG_FX_HALLUCINATION,
		"%s is hallucinationed" },
	{ N_MSG_FX_CHARM,
		"%s is charmed" },
	{ N_MSG_FX_FLY,
		"%s is flyed" },
	{ N_MSG_FX_FAINT,
		"%s is fainted" },
	{ N_MSG_FX_DRUNK,
		"%s is drunked" },
	{ N_MSG_FX_VANISH,
		"%s is vanished" },
	{ N_MSG_FX_IRON_BODY,
		"%s steeled the body" },
	{ N_MSG_FX_PASSWALL,
		"%s feels that ground is soft." },
	{ N_MSG_FX_POLYMORPH,
		"%s turned into a monster." },
	{ N_MSG_FX_SENSE_INVISIBLE,
		"It seems that an eye got well as for the %s." },
	{ N_MSG_FX_RESI_STAT,
		"The effect is not effective in %s." },

	{ N_MSG_FX_WEAK_HEAT,
		"%s was encompassed by the heat." },
	{ N_MSG_FX_WEAK_COLD,
		"%s was encompassed by the cold." },
	{ N_MSG_FX_WEAK_MIND,
		"%s was encompassed by the tornado." },
	{ N_MSG_FX_WEAK_ACID,
		"%s was encompassed by the acid." },
	{ N_MSG_FX_WEAK_ELEC,
		"%s was encompassed by lightning." },
	{ N_MSG_FX_WEAK_POIS,
		"%s was encompassed by the poison" },

	{ N_MSG_FX_RESI_PHYS,
		"%s was able to take muscular pain." },
	{ N_MSG_FX_RESI_HEAT,
		"%s became cool." },
	{ N_MSG_FX_RESI_COLD,
		"%s became warm." },
	{ N_MSG_FX_RESI_MIND,
		"%s felt a comfortable wind." },
	{ N_MSG_FX_RESI_ACID,
		"%s became smooth the skin." },
	{ N_MSG_FX_RESI_ELEC,
		"Static electricity disappeared in %s" },
	{ N_MSG_FX_RESI_POIS,
		"%s became comfortable." },

	{ N_MSG_FX_SHARPNESS,
		"Moves as the body thinks of %s" },
	{ N_MSG_FX_DULLNESS,
		"%s was not able to move his body well." },
	{ N_MSG_FX_STRENGTH,
		"%s became powerful." },
	{ N_MSG_FX_WEAKNESS,
		"%s has weakened power." },
	{ N_MSG_FX_QUICKNESS,
		"body of %s lightened." },
	{ N_MSG_FX_SLOWNESS,
		"%s became heavy the body." },
	{ N_MSG_FX_BRAINY,
		"%s thinks that oneself becomes clever." },
	{ N_MSG_FX_BRAINLESS,
		"%s became stupid." },
	{ N_MSG_FX_WISE,
		"%s thinks that oneself becomes wise." },
	{ N_MSG_FX_FOOLISH,
		"%s thinks that oneself becomes foolish." },
	{ N_MSG_FX_ATTRACTIVE,
		"%s became beautiful." },
	{ N_MSG_FX_UNATTRACTIVE,
		"%s has become ugly." },

	{ N_MSG_FX_WATER,
		"%s enriched the throat." },
	{ N_MSG_FX_OIL,
		"This is oil." },
	{ N_MSG_FX_CREATE_FOOD,
		"%s generated %s." },
	{ N_MSG_FX_DETECT_MNSTR,
		"%s felt monster's sign." },
	{ N_MSG_FX_DETECT_ITEM,
		"%s felt the position of items." },
	{ N_MSG_FX_POW_UP_HP,
		"%s became tough." },
	{ N_MSG_FX_MAGIC_SHIELD,
		"%s equipped it with a transparent shield." },
	{ N_MSG_FX_MAGE_ARMOR,
		"%s equipped it with a transparent armor." },
	{ N_MSG_FX_COUNTER_MAGIC,
		"The ball of small iron"
		" began to turn round %s surroundings." },
	{ N_MSG_FX_SUBSTITUTE,
		"%s prepared the substitute." },
	{ N_MSG_FX_BURNING_HANDS,
		"both hands of %s blazed up in red." },
	{ N_MSG_FX_RALLY,
		"%s tried to recover from a setback." },
	{ N_MSG_FX_IRON_MAN,
		"%s turned into the iron man." },
	{ N_MSG_FX_MIND_READING,
		"%s \'s reading enemy\'s mind became possible." },
	{ N_MSG_FX_SPEED_UP,
		"%s became light-footed." },
	{ N_MSG_FX_SPEED_DOWN,
		"foot of %s has slowed." },
	{ N_MSG_FX_TELEPORT_PARTY,
		"Surrounding scenery changed suddenly." },
	{ N_MSG_FX_TELEPORT,
		"Scenery around %s changed suddenly." },
	{ N_MSG_FX_BLESS,
		"A %s had a saved feeling." },
	{ N_MSG_FX_STORE_LIGHT,
		"%s inhaled light by the mouth." },

	{ N_MSG_FX_SHELTER_ERR,
		"There is a bothering thing"
		" and a shelter can't be created." },

	{ N_MSG_FX_RECALL,
		"In charging..." },
	{ N_MSG_FX_READ_SCROLL_NIN,
		"It is written, "
		"\"Hold the scroll in the mouth, concentrate, and pray\""
	},
	{ N_MSG_FX_TOBACCO_ABSTAIN,
		"A tobacco wants to absorb it, and a %s is irritated." },
	{ N_MSG_FX_SMOKE_TOBACCO,
		"Let's warn that you absorb it too much"
		" because of the health." },
	{ N_MSG_FX_SMOKE_END,
		"A %s finished smoking a tobacco." },
	{ N_MSG_FX_BREAK_PIPE,
		"It finished using %s\'s %s." },

	{ N_MSG_FX_IDENTIFY_ITEM,
		"Which item is identified? ([ESC]: it cancels)" },
	{ N_MSG_FX_RECALL_ASK,
		"The how many floors do you want to go to?" },

	{ N_MSG_FX_SLEEP_SUCCESS,
		"Monsters the %s environments have slept." },
	{ N_MSG_FX_SLEEP_FAILURE,
		"It had the mind that a loss was done in the %s." },

	{ N_MSG_FX_POW_UP_WPN_HIT_SUCCESS,
		"The weapon of the %s was easy to hit." },
	{ N_MSG_FX_POW_UP_WPN_HIT_FAILURE,
		"Both hands of the %s shone blue." },
	{ N_MSG_FX_POW_UP_WPN_CRTCL_SUCCESS,
		"The critical of the weapon of the %s"
		" became easy to come out." },
	{ N_MSG_FX_POW_UP_WPN_CRTCL_FAILURE,
		"Both hands of the %s shone blue." },
	{ N_MSG_FX_POW_UP_WPN_DAM_SUCCESS,
		"The damage of the weapon of the %s grew big." },
	{ N_MSG_FX_POW_UP_WPN_DAM_FAILURE,
		"Both hands of the %s shone blue." },

	{ N_MSG_FX_POW_UP_ARMOR_DEF_SUCCESS,
		"It became easy for protector of %s to avoid attack." },
	{ N_MSG_FX_POW_UP_ARMOR_DEF_FAILURE,
		"The body of the %s shone red." },
	{ N_MSG_FX_POW_UP_ARMOR_CRTCL_SUCCESS,
		"It became easy for protector of %s"
		" to avoid critical attack." },
	{ N_MSG_FX_POW_UP_ARMOR_CRTCL_FAILURE,
		"The body of the %s shone red." },
	{ N_MSG_FX_POW_UP_ARMOR_AC_SUCCESS,
		"Protector of %s came to decrease damage." },
	{ N_MSG_FX_POW_UP_ARMOR_AC_FAILURE,
		"The body of the %s shone red." },

	{ N_MSG_FX_PROTECT_ARMOR_SUCCESS,
		"protector of %s was protected." },
	{ N_MSG_FX_PROTECT_ARMOR_FAILURE,
		"It tickles the back to %s." },
	{ N_MSG_FX_REMOVE_CURSE_SUCCESS,
		"The curse of the %s was canceled." },
	{ N_MSG_FX_REMOVE_CURSE_FAILURE,
		"A %s is especially fine." },

	{ N_MSG_FX_POW_DOWN_ARMOR,
		"protector of %s has melted." },
	{ N_MSG_FX_PROTECTED_ARMOR,
		"protector of %s is protected." },

	{ N_MSG_FX_SUMMON_MONSTER,
		"A %s was summoned." },
	{ N_MSG_FX_DISMISSAL,
		"A %s was sent back in the original dimension." },
	{ N_MSG_FX_SUMMON_BONE_SEL_ERR,
		"%s doesn\'t have the bone." },

	{ N_MSG_FX_CURE_HP_LIGHT,
		"%s has healed the wound a little." },
	{ N_MSG_FX_CURE_HP_MODERATE,
		"%s has healed the wound very much." },
	{ N_MSG_FX_CURE_HP_SERIOUS,
		"%s has healed considerably the wound." },
	{ N_MSG_FX_CURE_HP_MAX,
		"The wound of the %s was completely healed." },
	{ N_MSG_FX_CURE_HP,
		"The HP of the %s was recovered as to the %ld." },
	{ N_MSG_FX_TRANSFER_MP,
		"%s received MP as for %ld." },
	{ N_MSG_FX_CURE_LEV,
		"As for the %s, the old days were remembered." },
	{ N_MSG_FX_CURE_EXP,
		"A %s recovered a memory." },

	{ N_MSG_FX_RESURRECTION,
		"A %s was revived." },
	{ N_MSG_FX_RESURRECTION_FAILURE,
		"It wasn't revived in the %s." },
	{ N_MSG_FX_SAVE_LIFE,
		"life of %s was saved." },

/* FX CLR */

	{ N_MSG_CLR_FX_STONE,
		"%s returned to the body of the living body." },
	{ N_MSG_CLR_FX_PARALYZE,
		"%s has recovered numbness." },
	{ N_MSG_CLR_FX_POISON,
		"As for %s, nausea calmed down." },
	{ N_MSG_CLR_FX_CONFUSION,
		"As for %s, confusion was put down." },
	{ N_MSG_CLR_FX_BLIND,
		"%s came to see eyes." },
	{ N_MSG_CLR_FX_SLEEP,
		"%s awoke." },
	{ N_MSG_CLR_FX_SILENCE,
		"%s can talk now." },
	{ N_MSG_CLR_FX_FEAR,
		"%s disappeared scary." },
	{ N_MSG_CLR_FX_HALLUCINATION,
		"As for %s, the illusion was settled." },
	{ N_MSG_CLR_FX_CHARM,
		"%s has been crossed in love." },
	{ N_MSG_CLR_FX_FLY,
		"%s landed." },
	{ N_MSG_CLR_FX_DRUNK,
		"%s woke up intoxication." },
	{ N_MSG_CLR_FX_VANISH,
		"%s came to see the body." },
	{ N_MSG_CLR_FX_IRON_BODY,
		"%s became a living body the body." },
	{ N_MSG_CLR_FX_PASSWALL,
		"%s was steady of one\'s feet." },
	{ N_MSG_CLR_FX_POLYMORPH,
		"%s reverted to type." },
	{ N_MSG_CLR_FX_SENSE_INVISIBLE,
		"%s seems to have come to have poor eyesight." },

	{ N_MSG_CLR_FX_WEAK_HEAT,
		"%s escaped from heat." },
	{ N_MSG_CLR_FX_WEAK_COLD,
		"%s escaped from the cold." },
	{ N_MSG_CLR_FX_WEAK_MIND,
		"%s escaped from the tornado." },
	{ N_MSG_CLR_FX_WEAK_ACID,
		"%s escaped from the acid." },
	{ N_MSG_CLR_FX_WEAK_ELEC,
		"%s escaped from the shot of lightning." },
	{ N_MSG_CLR_FX_WEAK_POIS,
		"%s escaped from the poison." },

	{ N_MSG_CLR_FX_RESI_KNOC,
		"%s has a pain in joints." },
	{ N_MSG_CLR_FX_RESI_SLAS,
		"%s has a pain in joints." },
	{ N_MSG_CLR_FX_RESI_STIN,
		"%s has a pain in joints." },
	{ N_MSG_CLR_FX_RESI_HEAT,
		"%s is sultry." },
	{ N_MSG_CLR_FX_RESI_COLD,
		"%s is cool." },
	{ N_MSG_CLR_FX_RESI_MIND,
		"%s became stifling." },
	{ N_MSG_CLR_FX_RESI_ACID,
		"As for %s, the body is smart." },
	{ N_MSG_CLR_FX_RESI_ELEC,
		"Static electricity crackling does %s." },
	{ N_MSG_CLR_FX_RESI_POIS,
		"%s felt sick." },

	{ N_MSG_CLR_FX_SHARPNESS,
		"%s doesn't move as the body thinks." },
	{ N_MSG_CLR_FX_DULLNESS,
		"Moves as the body thinks of %s." },
	{ N_MSG_CLR_FX_STRENGTH,
		"%s lost one's strength." },
	{ N_MSG_CLR_FX_WEAKNESS,
		"As for %s, power has strengthened." },
	{ N_MSG_CLR_FX_QUICKNESS,
		"body of %s is heavy." },
	{ N_MSG_CLR_FX_SLOWNESS,
		"body of %s is light." },
	{ N_MSG_CLR_FX_BRAINY,
		"%s has become stupid." },
	{ N_MSG_CLR_FX_BRAINLESS,
		"%s became smart." },
	{ N_MSG_CLR_FX_WISE,
		"%s has become foolish." },
	{ N_MSG_CLR_FX_FOOLISH,
		"%s became wise." },
	{ N_MSG_CLR_FX_ATTRACTIVE,
		"%s has become ugly." },
	{ N_MSG_CLR_FX_UNATTRACTIVE,
		"%s became beautiful." },

	{ N_MSG_CLR_FX_POW_UP_HP,
		"%s became a lamplight or less." },
	{ N_MSG_CLR_FX_MAGIC_SHIELD,
		"As for %s, the escutcheon seems to have disappeared." },
	{ N_MSG_CLR_FX_MAGE_ARMOR,
		"%s seems to have taken off the armor." },
	{ N_MSG_CLR_FX_COUNTER_MAGIC,
		"Iron balls around %s flew somewhere and it left." },
	{ N_MSG_CLR_FX_SUBSTITUTE,
		"Vicarious victim of %s was found." },
	{ N_MSG_CLR_FX_BURNING_HANDS,
		"The flame of hands of %s was extinguished." },
	{ N_MSG_CLR_FX_RALLY,
		"%s \'s rally ended." },
	{ N_MSG_CLR_FX_IRON_MAN,
		"%s returned to the ordinary man." },
	{ N_MSG_CLR_FX_MIND_READING,
		"%s was not able to read enemy's mind." },
	{ N_MSG_CLR_FX_SPEED_UP,
		"Movement of %s is late." },
	{ N_MSG_CLR_FX_SPEED_DOWN,
		"As for %s, movement has quickened." },
	{ N_MSG_CLR_FX_BLESS,
		"%s regretted." },
	{ N_MSG_CLR_FX_STORE_LIGHT,
		"%s occurred the sigh." },

/* good drink */

	{ N_MSG_FX_DRINK_A00,
		"This is delicious dish %s." },
	{ N_MSG_FX_DRINK_A01,
		"Drinking feelings of this %s are good." },
	{ N_MSG_FX_DRINK_A02,
		"This %s smells elegant." },
	{ N_MSG_FX_DRINK_A03,
		"This %s tastes elegant." },
	{ N_MSG_FX_DRINK_A04,
		"The impression of this %s is good." },
	{ N_MSG_FX_DRINK_A05,
		"This is a mellow %s." },

/* bad drink */

	{ N_MSG_FX_DRINK_B00,
		"This is an unpalatable %s." },

/* good food */

	{ N_MSG_FX_EAT_FOOD_A00,
		"This is delicious dish %s." },
	{ N_MSG_FX_EAT_FOOD_A01,
		"It is %s that is waited and risked." },
	{ N_MSG_FX_EAT_FOOD_A02,
		"It is rich %s." },
	{ N_MSG_FX_EAT_FOOD_A03,
		"It is simple %s." },
	{ N_MSG_FX_EAT_FOOD_A04,
		"It is thick %s." },
	{ N_MSG_FX_EAT_FOOD_A05,
		"It is %s of a taste not persistent." },
	{ N_MSG_FX_EAT_FOOD_A06,
		"This is %s with a deep tasting." },
	{ N_MSG_FX_EAT_FOOD_A07,
		"This is ultimate %s." },
	{ N_MSG_FX_EAT_FOOD_A08,
		"This is %s of supremacy." },

/* bad food */

	{ N_MSG_FX_EAT_FOOD_B00,
		"This is a tasteless %s." },
	{ N_MSG_FX_EAT_FOOD_B01,
		"This %s is a persistent taste." },
	{ N_MSG_FX_EAT_FOOD_B02,
		"The %s is ... !! Call the chief cook!" },

/**/

	{ N_MSG_FX_PICK_GOLD,
		"%s printed her purse." },

/* Monster */

/* Monster major name */
	{ N_MSG_MNSTR_MJR_NAME_UNKNOWN,
		"Unknown" },
	{ N_MSG_MNSTR_MJR_NAME_GOD,
		"God" },
	{ N_MSG_MNSTR_MJR_NAME_DRAGON,
		"Dragon" },
	{ N_MSG_MNSTR_MJR_NAME_ILLUSORY,
		"Illusory" },
	{ N_MSG_MNSTR_MJR_NAME_FAIRY,
		"Fairy" },
	{ N_MSG_MNSTR_MJR_NAME_ELEMENTAL,
		"Elemental" },
	{ N_MSG_MNSTR_MJR_NAME_PLANT,
		"Plant" },
	{ N_MSG_MNSTR_MJR_NAME_ANIMAL,
		"Animal" },
	{ N_MSG_MNSTR_MJR_NAME_INSECT,
		"Insect" },
	{ N_MSG_MNSTR_MJR_NAME_HUMAN,
		"Human" },
	{ N_MSG_MNSTR_MJR_NAME_HYBRID,
		"Hybrid" },
	{ N_MSG_MNSTR_MJR_NAME_GIANT,
		"Giant" },
	{ N_MSG_MNSTR_MJR_NAME_HUGE,
		"Huge" },
	{ N_MSG_MNSTR_MJR_NAME_AQUATIC,
		"Aquatic" },
	{ N_MSG_MNSTR_MJR_NAME_MAGICAL,
		"Magical" },
	{ N_MSG_MNSTR_MJR_NAME_COMPOUND,
		"Compound" },
	{ N_MSG_MNSTR_MJR_NAME_UNDEAD,
		"Undead" },
	{ N_MSG_MNSTR_MJR_NAME_EVIL,
		"Evil" },
	{ N_MSG_MNSTR_MJR_NAME_EVIL_BEAST,
		"Evil beast" },
	{ N_MSG_MNSTR_MJR_NAME_DEVIL,
		"Devil" },
	{ N_MSG_MNSTR_MJR_NAME_BOSS,
		"Boss" },

/* UNKNOWN */
	{ N_MSG_MNSTR_UNKNOWN,
		"Unknown Monster" },
/* GOD */
/* DRAGON */
	{ N_MSG_MNSTR_A_GOLD_DRAGON,
		"Ancient Gold Dragon" },
	{ N_MSG_MNSTR_A_SILVER_DRAGON,
		"Ancient Silver Dragon" },
	{ N_MSG_MNSTR_A_COPPER_DRAGON,
		"Ancient Copper Dragon" },
	{ N_MSG_MNSTR_A_RED_DRAGON,
		"Ancient Red Dragon" },
	{ N_MSG_MNSTR_A_BLUE_DRAGON,
		"Ancient Blue Dragon" },
	{ N_MSG_MNSTR_A_YELLOW_DRAGON,
		"Ancient Yellow Dragon" },
	{ N_MSG_MNSTR_A_GREEN_DRAGON,
		"Ancient Green Dragon" },
	{ N_MSG_MNSTR_A_WHITE_DRAGON,
		"Ancient White Dragon" },
	{ N_MSG_MNSTR_A_BLACK_DRAGON,
		"Ancient Black Dragon" },

	{ N_MSG_MNSTR_M_GOLD_DRAGON,
		"Minor Gold Dragon" },
	{ N_MSG_MNSTR_M_SILVER_DRAGON,
		"Minor Silver Dragon" },
	{ N_MSG_MNSTR_M_COPPER_DRAGON,
		"Minor Copper Dragon" },
	{ N_MSG_MNSTR_M_RED_DRAGON,
		"Minor Red Dragon" },
	{ N_MSG_MNSTR_M_BLUE_DRAGON,
		"Minor Blue Dragon" },
	{ N_MSG_MNSTR_M_YELLOW_DRAGON,
		"Minor Yellow Dragon" },
	{ N_MSG_MNSTR_M_GREEN_DRAGON,
		"Minor Green Dragon" },
	{ N_MSG_MNSTR_M_WHITE_DRAGON,
		"Minor White Dragon" },
	{ N_MSG_MNSTR_M_BLACK_DRAGON,
		"Minor Black Dragon" },
/* ILLUSORY */
	{ N_MSG_MNSTR_PHOENIX,
		"Phoenix" },
	{ N_MSG_MNSTR_UNICORN,
		"Unicorn" },
/* FAIRY */
	{ N_MSG_MNSTR_LEPRECHAUN,
		"Leprechaun" },
/* ELEMENTAL */
	{ N_MSG_MNSTR_FIRE_ELEMENTAL,
		"Fire Elemental" },
	{ N_MSG_MNSTR_SALAMANDER,
		"Salamander" },
	{ N_MSG_MNSTR_WATER_ELEMENTAL,
		"Water Elemental" },
	{ N_MSG_MNSTR_UNDINE,
		"Undine" },
	{ N_MSG_MNSTR_AIR_ELEMENTAL,
		"Air Elemental" },
	{ N_MSG_MNSTR_SYLPH,
		"Sylph" },
	{ N_MSG_MNSTR_EARTH_ELEMENTAL,
		"Earth Elemental" },
	{ N_MSG_MNSTR_GNOME,
		"Gnome" },
	{ N_MSG_MNSTR_WILL_O_WISP,
		"Will O Wisp," },
	{ N_MSG_MNSTR_SHADE,
		"Shade" },
/* PLANT */
	{ N_MSG_MNSTR_VENUS_FLY_TRAP,
		"Venus Fly Trap" },
	{ N_MSG_MNSTR_SLIME,
		"Slime" },
	{ N_MSG_MNSTR_SPORE,
		"Spore" },
/* ANIMAL */
	{ N_MSG_MNSTR_GIANT_BAT,
		"Giant Bat" },
	{ N_MSG_MNSTR_GIANT_RAT,
		"Giant Rat" },
	{ N_MSG_MNSTR_GIANT_SNAKE,
		"Giant Snake" },
	{ N_MSG_MNSTR_VIPER_SNAKE,
		"Viper Snake" },
	{ N_MSG_MNSTR_CAT,
		"Cat" },
	{ N_MSG_MNSTR_DOG,
		"Dog" },
	{ N_MSG_MNSTR_WOLF,
		"Wolf" },
	{ N_MSG_MNSTR_PYON_PYON,
		"Pyon Pyon" },
/* INSECT */
	{ N_MSG_MNSTR_GIANT_CENTIPEDE,
		"Giant Centipede" },
	{ N_MSG_MNSTR_GIANT_BEE,
		"Giant Bee" },
	{ N_MSG_MNSTR_ACID_FLY,
		"Acid Fly" },
	{ N_MSG_MNSTR_GIANT_SCORPION,
		"Giant Scorpion" },
	{ N_MSG_MNSTR_GIANT_ANT,
		"Giant Ant" },
	{ N_MSG_MNSTR_GIANT_SPIDER,
		"Giant Spider" },
	{ N_MSG_MNSTR_GIANT_BEETLE,
		"Giant Beetle" },
/* HUMAN */
	{ N_MSG_MNSTR_FIGHTER,
		"Fighter" },
	{ N_MSG_MNSTR_MONK,
		"Monk" },
	{ N_MSG_MNSTR_HUNTER,
		"Hunter" },
	{ N_MSG_MNSTR_THIEF,
		"Thief" },
	{ N_MSG_MNSTR_WIZARD,
		"Wizard" },
	{ N_MSG_MNSTR_SUMMONER,
		"Summoner" },
	{ N_MSG_MNSTR_PRIEST,
		"Priest" },
	{ N_MSG_MNSTR_SHAMAN,
		"Shaman" },
	{ N_MSG_MNSTR_BARD,
		"Bard" },
	{ N_MSG_MNSTR_NINJA,
		"Ninja" },
	{ N_MSG_MNSTR_BISHOP,
		"Bishop" },
	{ N_MSG_MNSTR_FARMER,
		"Farmer" },
	{ N_MSG_MNSTR_CRAFTSMAN,
		"Craftsman" },
	{ N_MSG_MNSTR_MERCHANT,
		"Merchant" },
/* HYBRID */
	{ N_MSG_MNSTR_HARPY,
		"Harpy" },
	{ N_MSG_MNSTR_ANDRO_SCORPION,
		"Andro Scorpion" },
	{ N_MSG_MNSTR_LAMIA,
		"Lamia" },
	{ N_MSG_MNSTR_CENTAUR,
		"Centaur" },
	{ N_MSG_MNSTR_BIRD_MAN,
		"Bird Man" },
	{ N_MSG_MNSTR_WEREWOLF,
		"Werewolf" },
	{ N_MSG_MNSTR_MINOTAUR,
		"Minotaur" },
	{ N_MSG_MNSTR_MEDUSA,
		"Medusa" },
/* GIANT */
	{ N_MSG_MNSTR_YETI,
		"Yeti" },
	{ N_MSG_MNSTR_OGRE,
		"Ogre" },
	{ N_MSG_MNSTR_TROLL,
		"Troll" },
	{ N_MSG_MNSTR_MORMIN_TROLL,
		"Mormin Troll" },
	{ N_MSG_MNSTR_FIRE_GIANT,
		"Fire Giant" },
	{ N_MSG_MNSTR_FROST_GIANT,
		"Frost Giant" },
	{ N_MSG_MNSTR_CLOUD_GIANT,
		"Cloud Giant" },
	{ N_MSG_MNSTR_MOUNTAIN_GIANT,
		"Mountain Giant" },
	{ N_MSG_MNSTR_CYCLOPS,
		"Cyclops" },
/* HUGE */
/* AQUATIC */
/* MAGICAL */
	{ N_MSG_MNSTR_INVISIBLE_STALKER,
		"Invisible Stalker" },
	{ N_MSG_MNSTR_GARGOYLE,
		"Gargoyle" },
	{ N_MSG_MNSTR_MIMIC,
		"Mimic" },
	{ N_MSG_MNSTR_WOOD_GOLEM,
		"Wood Golem" },
	{ N_MSG_MNSTR_BONE_GOLEM,
		"Bone Golem" },
	{ N_MSG_MNSTR_FLESH_GOLEM,
		"Flesh Golem" },
	{ N_MSG_MNSTR_STONE_GOLEM,
		"Stone Golem" },
	{ N_MSG_MNSTR_IRON_GOLEM,
		"Iron Golem" },
	{ N_MSG_MNSTR_GAS_CLOUD,
		"Gas Cloud" },
/* COMPOUND */
	{ N_MSG_MNSTR_HIPPOGRIFF,
		"Hippogriff" },
	{ N_MSG_MNSTR_GRIFFON,
		"Griffon" },
	{ N_MSG_MNSTR_MANTICORE,
		"Manticore" },
	{ N_MSG_MNSTR_CHIMERA,
		"Chimera" },
/* UNDEAD */
	{ N_MSG_MNSTR_POLTERGEIST,
		"Poltergeist" },
	{ N_MSG_MNSTR_SKELETON,
		"Skeleton" },
	{ N_MSG_MNSTR_ZOMBIE,
		"Zombie" },
	{ N_MSG_MNSTR_GHOUL,
		"Ghoul" },
	{ N_MSG_MNSTR_GHOST,
		"Ghost" },
	{ N_MSG_MNSTR_WIGHT,
		"Wight" },
	{ N_MSG_MNSTR_MUMMY,
		"Mummy" },
	{ N_MSG_MNSTR_DURAHAN,
		"Durahan" },
	{ N_MSG_MNSTR_BANSHEE,
		"Banshee" },
	{ N_MSG_MNSTR_WRAITH,
		"Wraith" },
	{ N_MSG_MNSTR_VAMPIRE,
		"Vampire" },
	{ N_MSG_MNSTR_SPIRIT,
		"Spirit" },
/* EVIL */
	{ N_MSG_MNSTR_KOBOLD,
		"Kobold" },
	{ N_MSG_MNSTR_GOBLIN,
		"Goblin" },
	{ N_MSG_MNSTR_GREMLIN,
		"Gremlin" },
	{ N_MSG_MNSTR_HOBGOBLIN,
		"Hobgoblin" },
	{ N_MSG_MNSTR_ORK,
		"Ork" },
	{ N_MSG_MNSTR_GNOLL,
		"Gnoll" },
	{ N_MSG_MNSTR_INCUBUS,
		"Incubus" },
	{ N_MSG_MNSTR_SUCCUBUS,
		"Succubus" },
	{ N_MSG_MNSTR_EFREET,
		"Efreet" },
	{ N_MSG_MNSTR_DJINNI,
		"Djinni" },
/* EVIL_BEAST */
	{ N_MSG_MNSTR_RUST_MONSTER,
		"Rust Monster" },
	{ N_MSG_MNSTR_HELLHOUND,
		"Hellhound" },
	{ N_MSG_MNSTR_HYDRA,
		"Hydra" },
	{ N_MSG_MNSTR_COCKATRICE,
		"Cockatrice" },
	{ N_MSG_MNSTR_WYVERN,
		"Wyvern" },
	{ N_MSG_MNSTR_CERBERUS,
		"Cerberus" },
	{ N_MSG_MNSTR_GORGON,
		"Gorgon" },
	{ N_MSG_MNSTR_BASILISK,
		"Basilisk" },
/* DEVIL */
	{ N_MSG_MNSTR_IMP,
		"Imp" },
	{ N_MSG_MNSTR_JACK_O_LANTERN,
		"Jack'O Lantern" },
	{ N_MSG_MNSTR_LESSER_DEMON,
		"Lesser Demon" },
	{ N_MSG_MNSTR_GREATER_DEMON,
		"Greater Demon" },
/* BOSS */
	{ N_MSG_MNSTR_GREAT_MINOTAUR,
		"Great Minotaur" },
	{ N_MSG_MNSTR_HIGH_RE_HOO,
		"High Re Hoo" },
	{ N_MSG_MNSTR_MEDUSA_ZOMBIE,
		"Medusa Zombie" },
	{ N_MSG_MNSTR_BLACK_UNICORN,
		"Black Unicorn" },
	{ N_MSG_MNSTR_VAMPIRE_LORD,
		"Vampire Lord" },
	{ N_MSG_MNSTR_GIGANTIC_CENTIPEDE,
		"Gigantic Centipede" },
/**/
	{ N_MSG_MBR_FIND_INVISIBLE,
		"Wait! It is %s!!" },
	{ N_MSG_MNSTR_DISAPPEAR,
		"%s disappeared." },

/* trap */

	{ N_MSG_TRAP_SLEEP,
		"Trap of sleep" },
	{ N_MSG_TRAP_ARW,
		"Trap of bow and arrow" },
	{ N_MSG_TRAP_POISON_DARTS,
		"Trap of poison darts" },
	{ N_MSG_TRAP_BOMB,
		"Trap of bomb" },
	{ N_MSG_TRAP_TELEPORT_PARTY,
		"Trap of movement at party trice" },
	{ N_MSG_TRAP_TELEPORT,
		"Trap of movement at moment" },
	{ N_MSG_TRAP_PIT,
		"Pit" },
	{ N_MSG_TRAP_CHUTE,
		"Chute" },
	{ N_MSG_TRAP_SANCTUARY,
		"Sanctuary" },

	{ N_MSG_TRAPPED,
		"%s was caught in the %s" },
	{ N_MSG_NOT_TRAPPED,
		"%s did not operate the trap" },

/* spell begin */

	{ N_MSG_MAG,
		STR_MAG },
	{ N_MSG_SOR,
		STR_SOR },
	{ N_MSG_ENC,
		STR_ENC },
	{ N_MSG_SUM,
		STR_SUM },

	{ N_MSG_PRI,
		STR_PRI },
	{ N_MSG_SHA,
		STR_SHA },
	{ N_MSG_BAR,
		STR_BAR },
	{ N_MSG_NIN,
		STR_NIN },

	{ N_MSG_MAG_MISC,
		STR_MAG " - Common" },
	{ N_MSG_MAG_DETECT,
		STR_MAG " - Detection" },
	{ N_MSG_MAG_CHANGE_STAT,
		STR_MAG " - State change" },
	{ N_MSG_SOR_ATTACK,
		STR_SOR " - Attack" },
	{ N_MSG_SOR_DEFENSE,
		STR_SOR " - Defense" },
	{ N_MSG_SOR_WEAKEN_STAT,
		STR_SOR " - State deterioration" },
	{ N_MSG_ENC_STRENGTHEN_ABL,
		STR_ENC " - Ability value strengthening" },
	{ N_MSG_ENC_STRENGTHEN_MISC,
		STR_ENC " - Strengthening" },
	{ N_MSG_ENC_WEAKEN_ABL,
		STR_ENC " - Ability value weakness" },
	{ N_MSG_ENC_WEAKEN_MISC,
		STR_ENC " - Weakness" },
	{ N_MSG_SUM_SUMMON,
		STR_SUM " - Summons" },
	{ N_MSG_PRI_CURE,
		STR_PRI " - Cure" },
	{ N_MSG_PRI_CURE_STAT,
		STR_PRI " - State cure" },
	{ N_MSG_PRI_RESIST,
		STR_PRI " - Resistance" },
	{ N_MSG_PRI_HOLY,
		STR_PRI " - Holy" },
	{ N_MSG_SHA_WEAK,
		STR_SHA " - Attack" },
	{ N_MSG_SHA_SUMMON,
		STR_SHA " - Summons" },
	{ N_MSG_BAR_CURE,
		STR_BAR " - Cure" },
	{ N_MSG_BAR_STRENGTHEN_ABL,
		STR_BAR " - Ability value strengthening" },
	{ N_MSG_BAR_WEAKEN_ABL,
		STR_BAR " - Ability value weakness" },
	{ N_MSG_BAR_RESI_STAT,
		STR_BAR " - State resistance" },
	{ N_MSG_NIN_DISASTER,
		STR_NIN " - Extraordinary natural phenomenon" },
	{ N_MSG_NIN_MISC,
		STR_NIN " - Taijuts" },

	{ N_MSG_ERR_SPELL,
		"%s cannot use spell" },
	{ N_MSG_SPELL_NO_LEARN,
		"She/He doesn\'t learn" },
	{ N_MSG_CAN_NOT_LEARN_SPELL,
		"%s cannot learn spell of %s yet." },
	{ N_MSG_LEARN_SPELL,
		"%s learnt the spell of %s." },
	{ N_MSG_FORGET_SPELL,
		"%s forgot the spell of %s" },
	{ N_MSG_ERR_SPELL_NIN_LEARNED,
		"She/He cannot learn the spell of the %s."
		" Internal data is error." },

/* [Basic magic] */

/* Common */

	{ N_MSG_SPELL_LIGHT,
		"Light" },
	{ N_MSG_SPELL_DARKNESS,
		"Darkness" },
	{ N_MSG_SPELL_STORE_LIGHT,
		"Store light" },
	{ N_MSG_SPELL_KNOCK,
		"Knock" },
	{ N_MSG_SPELL_LOCK,
		"Lock" },
	{ N_MSG_SPELL_DISARM_TRAP,
		"Disarm trap" },
	{ N_MSG_SPELL_DISPEL_MAGIC,
		"Dispel magic" },
	{ N_MSG_SPELL_TELEPORT_PARTY,
		"Teleport party" },
	{ N_MSG_SPELL_TELEPORT,
		"Teleport" },
	{ N_MSG_SPELL_RECALL,
		"Recall" },
	{ N_MSG_SPELL_MIRROR_IMAGE,
		"Mirror image" },
	{ N_MSG_SPELL_ANIMATE_OBJECTS,
		"Animate objects" },
	{ N_MSG_SPELL_SHELTER,
		"Shelter" },
	{ N_MSG_SPELL_CREATE_FOOD,
		"Create food" },

/* Detection */

	{ N_MSG_SPELL_IDENTIFY_ITEM,
		"Identify item" },
	{ N_MSG_SPELL_IDENTIFY_ALL_ITEM,
		"Identify all item" },
	{ N_MSG_SPELL_SEARCHING,
		"Searching" },
	{ N_MSG_SPELL_ANALYZE_DWEOMER,
		"Analyze dweomer" },
	{ N_MSG_SPELL_DETECT_ITEM,
		"Detect item" },
	{ N_MSG_SPELL_DETECT_DOORS,
		"Detect doors" },
	{ N_MSG_SPELL_DETECT_TRAPS,
		"Detect traps" },
	{ N_MSG_SPELL_DETECT_MAGIC,
		"Detect magic" },
	{ N_MSG_SPELL_DETECT_MONSTER,
		"Detect monster" },
	{ N_MSG_SPELL_SENSE_INVISIBLE,
		"Sense invisible" },

/* State change */

	{ N_MSG_SPELL_FLY,
		"Fly" },
	{ N_MSG_SPELL_FEATHER_FALL,
		"Feather fall" },
	{ N_MSG_SPELL_VANISH,
		"Vanish" },
	{ N_MSG_SPELL_DARKVISION,
		"Darkvision" },
	{ N_MSG_SPELL_PASSWALL,
		"Passwall" },
	{ N_MSG_SPELL_POLYMORPH_OTHER,
		"Polymorph other" },
	{ N_MSG_SPELL_POLYMORPH_SELF,
		"Polymorph self" },
	{ N_MSG_SPELL_STEALTH,
		"Stealth" },

/* [Combat magic] */

/* Attack */

	{ N_MSG_SPELL_MAGIC_MISSILE,
		"Magic missile" },
	{ N_MSG_SPELL_FIRE_BALL,
		"Fire ball" },
	{ N_MSG_SPELL_ICE_BLIZZARD,
		"Ice blizzard" },
	{ N_MSG_SPELL_MIND_STORM,
		"Mind storm" },
	{ N_MSG_SPELL_ACID_RAIN,
		"Acid rain" },
	{ N_MSG_SPELL_LIGHTNING_BOLT,
		"Lightning bolt" },
	{ N_MSG_SPELL_POISON_CLOUD,
		"Poison cloud" },
	{ N_MSG_SPELL_DEATH_SPELL,
		"Death spell" },
	{ N_MSG_SPELL_WORD_OF_DESTRUCTION,
		"Word of destruction" },

/* Defense */

	{ N_MSG_SPELL_MAGIC_SHIELD,
		"Magic shield" },
	{ N_MSG_SPELL_MAGE_ARMOR,
		"Mage armor" },
	{ N_MSG_SPELL_STONESKIN,
		"Stoneskin" },
	{ N_MSG_SPELL_IRON_BODY,
		"Iron body" },
	{ N_MSG_SPELL_SPELL_RESISTANCE,
		"Spell resistance" },
	{ N_MSG_SPELL_COUNTER_MAGIC,
		"Counter magic" },

/* State deterioration */

	{ N_MSG_SPELL_STONE,
		"Stone" },
	{ N_MSG_SPELL_PARALYZE,
		"Paralyze" },
	{ N_MSG_SPELL_POISON,
		"Poison" },
	{ N_MSG_SPELL_CONFUSION,
		"Confusion" },
	{ N_MSG_SPELL_BLINDNESS,
		"Blindness" },
	{ N_MSG_SPELL_SLEEP,
		"Sleep" },
	{ N_MSG_SPELL_SILENCE,
		"Silence" },
	{ N_MSG_SPELL_FEAR,
		"Fear" },
	{ N_MSG_SPELL_HALLUCINATION,
		"Hallucination" },
	{ N_MSG_SPELL_CHARM,
		"Charm" },

/* [Covering magic] */

/* Ability value strengthening */

	{ N_MSG_SPELL_SHARPNESS,
		"Sharpness" },
	{ N_MSG_SPELL_STRENGTH,
		"Strength" },
	{ N_MSG_SPELL_QUICKNESS,
		"Quickness" },
	{ N_MSG_SPELL_BRAINY,
		"Brainy" },
	{ N_MSG_SPELL_WISE,
		"Wise" },
	{ N_MSG_SPELL_ATTRACTIVE,
		"Attractive" },

/* Strengthening */

	{ N_MSG_SPELL_POWER_UP_HP,
		"Power up HP" },
	{ N_MSG_SPELL_HASTE,
		"Haste" },

/* Ability value weakness */

	{ N_MSG_SPELL_DULLNESS,
		"Dullness" },
	{ N_MSG_SPELL_WEAKNESS,
		"Weakness" },
	{ N_MSG_SPELL_SLOWNESS,
		"Slowness" },
	{ N_MSG_SPELL_BRAINLESS,
		"Brainless" },
	{ N_MSG_SPELL_FOOLISH,
		"Foolish" },
	{ N_MSG_SPELL_UNATTRACTIVE,
		"Unattractive" },

/* Weakness */

	{ N_MSG_SPELL_ENERGY_DRAIN,
		"Energy drain" },
	{ N_MSG_SPELL_SLOW,
		"Slow" },
	{ N_MSG_SPELL_HUNGER,
		"Hunger" },
	{ N_MSG_SPELL_CANCELLATION,
		"Cancellation" },

/* [Summons magic] */

/* Summons */
	{ N_MSG_SPELL_SKELETON_WARRIOR,
		"Skeleton warrior" },
	{ N_MSG_SPELL_SUMMON_UNICORN,
		"Summon unicorn" },
	{ N_MSG_SPELL_SUMMON_EFREET,
		"Summon efreet" },
	{ N_MSG_SPELL_SUMMON_DJINNI,
		"Summon djinni" },
	{ N_MSG_SPELL_SUMMON_PHOENIX,
		"Summon phoenix" },
	{ N_MSG_SPELL_SUMMON_BONE,
		"Summon from bone" },
	{ N_MSG_SPELL_SUMMON_RANDOM,
		"Summon random" },
	{ N_MSG_SPELL_CREATE_UNDEAD,
		"Create undead" },
	{ N_MSG_SPELL_DISMISSAL,
		"Dismissal" },

/* [Prayer] */

/* Cure */

	{ N_MSG_SPELL_CURE_HP_LIGHT,
		"Cure HP light" },
	{ N_MSG_SPELL_CURE_HP_MODERATE,
		"Cure HP moderate" },
	{ N_MSG_SPELL_CURE_HP_SERIOUS,
		"Cure HP serious" },
	{ N_MSG_SPELL_CURE_HP_MAX,
		"Cure HP max" },
	{ N_MSG_SPELL_CURE_MP,
		"Cure MP" },
	{ N_MSG_SPELL_TRANSFER_MP,
		"Transfer MP" },
	{ N_MSG_SPELL_REGENERATION,
		"Regeneration" },
	{ N_MSG_SPELL_RESTORE_EXPERIENCE,
		"Restore experience" },
	{ N_MSG_SPELL_RESURRECTION,
		"Resurrection" },
	{ N_MSG_SPELL_HEAL,
		"Heal" },

/* State cure */

	{ N_MSG_SPELL_CURE_STATUS,
		"Cure status" },

	{ N_MSG_SPELL_CURE_STONE,
		"Cure stone" },
	{ N_MSG_SPELL_CURE_PARALYZE,
		"Cure paralyze" },
	{ N_MSG_SPELL_CURE_POISON,
		"Cure poison" },
	{ N_MSG_SPELL_CURE_CONFUSION,
		"Cure confusion" },
	{ N_MSG_SPELL_CURE_BLINDNESS,
		"Cure blindness" },
	{ N_MSG_SPELL_CURE_SLEEP,
		"Cure sleep" },
	{ N_MSG_SPELL_CURE_SILENCE,
		"Cure silence" },
	{ N_MSG_SPELL_CURE_FEAR,
		"Cure fear" },
	{ N_MSG_SPELL_CURE_HALLUCINATION,
		"Cure hallucination" },
	{ N_MSG_SPELL_CURE_CHARM,
		"Cure charm" },

	{ N_MSG_SPELL_REMOVE_CURSE,
		"Remove curse" },

/* Resistance */

	{ N_MSG_SPELL_PROTECTION,
		"Protection" },
	{ N_MSG_SPELL_RESIST_PHYSICAL,
		"Resist physical" },
	{ N_MSG_SPELL_RESIST_HEAT,
		"Resist heat" },
	{ N_MSG_SPELL_RESIST_COLD,
		"Resist cold" },
	{ N_MSG_SPELL_RESIST_MIND,
		"Resist mind" },
	{ N_MSG_SPELL_RESIST_ACID,
		"Resist acid" },
	{ N_MSG_SPELL_RESIST_ELECTRICITY,
		"Resist electricity" },
	{ N_MSG_SPELL_RESIST_POISON,
		"Resist poison" },

/* Holy */

	{ N_MSG_SPELL_BLESS,
		"Bless" },
	{ N_MSG_SPELL_DISPEL_UNDEAD,
		"Dispel undead" },
	{ N_MSG_SPELL_ESCAPE,
		"Escape" },
	{ N_MSG_SPELL_SANCTUARY,
		"Sanctuary" },
	{ N_MSG_SPELL_WISH,
		"Wish" },

/* [Shaman] */

/* Attack */

	{ N_MSG_SPELL_WEAK_FIRE_ELEMENTAL,
		"Weak fire elemental" },
	{ N_MSG_SPELL_WEAK_WATER_ELEMENTAL,
		"Weak water elemental" },
	{ N_MSG_SPELL_WEAK_AIR_ELEMENTAL,
		"Weak air elemental" },
	{ N_MSG_SPELL_WEAK_EARTH_ELEMENTAL,
		"Weak earth elemental" },
	{ N_MSG_SPELL_WEAK_LIGHT_ELEMENTAL,
		"Weak light elemental" },
	{ N_MSG_SPELL_WEAK_DARK_ELEMENTAL,
		"Weak dark elemental" },

/* Summons */

	{ N_MSG_SPELL_SUMMON_FIRE_ELEMENTAL,
		"Summon fire elemental" },
	{ N_MSG_SPELL_SUMMON_SALAMANDER,
		"Summon salamander" },
	{ N_MSG_SPELL_SUMMON_WATER_ELEMENTAL,
		"Summon water elemental" },
	{ N_MSG_SPELL_SUMMON_UNDINE,
		"Summon undine" },
	{ N_MSG_SPELL_SUMMON_AIR_ELEMENTAL,
		"Summon air elemental" },
	{ N_MSG_SPELL_SUMMON_SYLPH,
		"Summon sylph" },
	{ N_MSG_SPELL_SUMMON_EARTH_ELEMENTAL,
		"Summon earth elemental" },
	{ N_MSG_SPELL_SUMMON_GNOME,
		"Summon gnome" },
	{ N_MSG_SPELL_SUMMON_WILL_O_WISP,
		"Summon will o wisp" },
	{ N_MSG_SPELL_SUMMON_SHADE,
		"Summon shade" },

/* [Bard] */

/* Cure */

	{ N_MSG_SPELL_SONG_CURE_HP,
		"Song cure HP" },
	{ N_MSG_SPELL_SONG_CURE_MP,
		"Song cure mp" },

/* Ability value strengthening */

	{ N_MSG_SPELL_SONG_SHARPNESS,
		"Song sharpness" },
	{ N_MSG_SPELL_SONG_STRENGTH,
		"Song strength" },
	{ N_MSG_SPELL_SONG_QUICKNESS,
		"Song quickness" },
	{ N_MSG_SPELL_SONG_BRAINY,
		"Song brainy" },
	{ N_MSG_SPELL_SONG_WISE,
		"Song wise" },
	{ N_MSG_SPELL_SONG_ATTRACTIVE,
		"Song attractive" },

/* Ability value weakness */

	{ N_MSG_SPELL_SONG_DULLNESS,
		"Song dullness" },
	{ N_MSG_SPELL_SONG_WEAKNESS,
		"Song weakness" },
	{ N_MSG_SPELL_SONG_SLOWNESS,
		"Song slowness" },
	{ N_MSG_SPELL_SONG_BRAINLESS,
		"Song brainless" },
	{ N_MSG_SPELL_SONG_FOOLISH,
		"Song foolish" },
	{ N_MSG_SPELL_SONG_UNATTRACTIVE,
		"Song unattractive" },

/* State resistance */

	{ N_MSG_SPELL_SONG_RESI_STAT_STONE,
		"Song resi stat stone" },
	{ N_MSG_SPELL_SONG_RESI_STAT_PARALYZE,
		"Song resi stat paralyze" },
	{ N_MSG_SPELL_SONG_RESI_STAT_POISON,
		"Song resi stat poison" },
	{ N_MSG_SPELL_SONG_RESI_STAT_CONFUSION,
		"Song resi stat confusion" },
	{ N_MSG_SPELL_SONG_RESI_STAT_BLIND,
		"Song resi stat blind" },
	{ N_MSG_SPELL_SONG_RESI_STAT_SLEEP,
		"Song resi stat sleep" },
	{ N_MSG_SPELL_SONG_RESI_STAT_SILENCE,
		"Song resi stat silence" },
	{ N_MSG_SPELL_SONG_RESI_STAT_FEAR,
		"Song resi stat fear" },
	{ N_MSG_SPELL_SONG_RESI_STAT_HALLUCINATION,
		"Song resi stat hallucination" },
	{ N_MSG_SPELL_SONG_RESI_STAT_CHARM,
		"Song resi stat charm" },
	{ N_MSG_SPELL_SONG_RESI_STAT_DRUNK,
		"Song resi stat drunk" },

/* [Art of Shinobi] */

/* Extraordinary natural phenomenon */

	{ N_MSG_SPELL_TYPHOON,
		"Typhoon" },
	{ N_MSG_SPELL_CONFLAGRATION,
		"Conflagration" },
	{ N_MSG_SPELL_EARTHQUAKE,
		"Earthquake" },
	{ N_MSG_SPELL_THUNDERCLOUD,
		"Thundercloud" },
	{ N_MSG_SPELL_INUNDATION,
		"Inundation" },

/* Taijuts */

	{ N_MSG_SPELL_SUBSTITUTE,
		"Substitute" },
	{ N_MSG_SPELL_BURNING_HANDS,
		"Burning hands" },
	{ N_MSG_SPELL_RALLY,
		"Try again even harder" },
	{ N_MSG_SPELL_IRON_MAN,
		"Iron man" },
	{ N_MSG_SPELL_MIND_READING,
		"Mind reading" },

/* [Ancient magic] */

	{ N_MSG_SPELL_NOTHING,
		"Nothing" },
	{ N_MSG_SPELL_POLTERGEIST,
		"Poltergeist" },

/* spell end */

/* spell format begin */

	{ N_MSG_FMT_SPELL_SPORE,
		"%s scattered the spore." },
	{ N_MSG_FMT_SPELL_ACID,
		"%s vomited the acid." },
	{ N_MSG_FMT_SPELL_ENERGY_DRAIN,
		"%s absorbed vitality." },
	{ N_MSG_FMT_SPELL_CRY,
		"%s put out a frightening cry." },
	{ N_MSG_FMT_SPELL_HEAT_BREATH,
		"%s blew the breath of the flame." },
	{ N_MSG_FMT_SPELL_COLD_BREATH,
		"%s blew the breath of ice." },
	{ N_MSG_FMT_SPELL_MIND_BREATH,
		"%s blew the breath of the wind." },
	{ N_MSG_FMT_SPELL_ACID_BREATH,
		"%s blew the breath of the acid." },
	{ N_MSG_FMT_SPELL_ELEC_BREATH,
		"%s blew the breath of the thunder." },
	{ N_MSG_FMT_SPELL_POIS_BREATH,
		"%s blew the breath of the poison." },
	{ N_MSG_FMT_SPELL_STONE_EYE,
		"%s turned the glance of the petrifaction." },

/* spell format end */

/* color begin */

	{ N_MSG_ATTR_NORMAL,
		"Usual color" },
	{ N_MSG_ATTR_REV,
		"Color of reversing" },
	{ N_MSG_ATTR_ERR,
		"Color of error" },
	{ N_MSG_ATTR_MENU_DIS,
		"Color of invalid menu item" },
	{ N_MSG_ATTR_MENU_SEL,
		"Color of selection menu item" },
	{ N_MSG_ATTR_MAP_ITEM,
		"Color of item" },
	{ N_MSG_ATTR_MAP_SQUARE,
		"Color of " STR_SQUARE },
	{ N_MSG_ATTR_MAP_MNSTR,
		"Color of monster" },
	{ N_MSG_ATTR_MAP_NPC,
		"Color of NPC" },
	{ N_MSG_ATTR_MAP_CRSR,
		"Color of cursor" },
	{ N_MSG_ATTR_FX_MBR_PLUS,
		"Color of recovery of member" },
	{ N_MSG_ATTR_FX_MBR_MINUS,
		"Color of damage to member" },
	{ N_MSG_ATTR_FX_MBR_CRTCL,
		"Color of critical to member" },
	{ N_MSG_ATTR_FX_MNSTR_PLUS,
		"Color of recovery of monster" },
	{ N_MSG_ATTR_FX_MNSTR_MINUS,
		"Color of damage to monster" },
	{ N_MSG_ATTR_FX_MNSTR_CRTCL,
		"Color of critical to monster" },
	{ N_MSG_ATTR_VFX,
		"Color of effect" },
	{ N_MSG_ATTR_MBR_1,
		"Color of member 1" },
	{ N_MSG_ATTR_MBR_2,
		"Color of member 2" },
	{ N_MSG_ATTR_MBR_3,
		"Color of member 3" },
	{ N_MSG_ATTR_MBR_4,
		"Color of member 4" },
	{ N_MSG_ATTR_MBR_5,
		"Color of member 5" },
	{ N_MSG_ATTR_MBR_6,
		"Color of member 6" },

/* color end */

	{ N_MSG_REPLAY_KIND_KEY,
		"key" },
	{ N_MSG_REPLAY_KIND_GETS,
		"gets" },
	{ N_MSG_CHK_REG_REPLAY_ERR,
		"Replay is not recorded." },
	{ N_MSG_BGN_REG_REPLAY,
		"The record of replay begins." },
	{ N_MSG_END_REG_REPLAY,
		"The record of replay was ended." },
	{ N_MSG_LOAD_GAME_REPLAY_SUCCESS,
		"Replay was loaded from the %ld th slot." },
	{ N_MSG_SAVE_GAME_REPLAY_SUCCESS,
		"Replay was saved to the %ld th slot." },
	{ N_MSG_END_PLAY_REPLAY,
		"Replay ended." },
	{ N_MSG_END_PLAY_REPLAY_WAIT_KEY,
		"Please push the cancellation key." },

/* menu begin */

	{ N_MSG_MENU_FRAME,
		"----------------------------------------"
		"----------------------------------------" },
	{ N_MSG_MENU_CLR_FMT,
		"% *s" },
	{ N_MSG_MENU_SELECT_FMT,
		"*%s%s%-*s" },
	{ N_MSG_MENU_NOT_SELECT_FMT,
		" %s%s%-*s" },
	{ N_MSG_MENU_SELECT_SHORT_CUT_FMT,
		"%*s%*s*" },
	{ N_MSG_MENU_NOT_SELECT_SHORT_CUT_FMT,
		"%*s%*s " },
	{ N_MSG_MENU_CONTENTS_FMT,
		"%s%*s" },
	{ N_MSG_MENU_FLG_LS_CHK_ON,
		"[*]" },
	{ N_MSG_MENU_FLG_LS_CHK_OFF,
		"[ ]" },
	{ N_MSG_MENU_FLG_LS_CHK_NULL,
		"   " },
	{ N_MSG_MENU_ACCEL_KEY_FMT,
		"%c)" },
	{ N_MSG_MENU_SHORT_CUT_KEY_FMT,
		"(%s)" },
	{ N_MSG_MENU_H_LINE,
		"-" },
	{ N_MSG_MENU_V_LINE,
		"|" },
	{ N_MSG_MENU_LEFT,
		"+---" },
	{ N_MSG_MENU_LEFT_PREV,
		"+<<=" },
	{ N_MSG_MENU_RIGHT,
		"---+" },
	{ N_MSG_MENU_RIGHT_NEXT,
		"=>>+" },
	{ N_MSG_MENU_PAGE_FMT,
		"-%2ld/%2ld-" },
	{ N_MSG_MENU_CORNER,
		"+" },
	{ N_MSG_MENU_KIND_BRANCH,
		" >" },
	{ N_MSG_MENU_KIND_OPEN_WIN_ITEM,
		"..." },
	{ N_MSG_MENU_KIND_ITEM,
		"" },

	{ N_MSG_MENU_YES,
		"Yes" },
	{ N_MSG_MENU_NO,
		"No" },

	{ N_MSG_MENU_MIN,
		"[min]" },
	{ N_MSG_MENU_MAX,
		"[max]" },
	{ N_MSG_MENU_CLR,
		"[clear]" },
	{ N_MSG_MENU_OK,
		"[ok]" },

	{ N_MSG_TTL_MENU_MAIN_RACE,
		"Race" },
	{ N_MSG_TTL_MENU_SUB_RACE,
		"Crossing" },
	{ N_MSG_TTL_MENU_SEX,
		"Sex" },
	{ N_MSG_TTL_MENU_CLASS,
		"Class" },

/* main menu */

	{ N_MSG_MENU_MARK,
		"Mark" },
	{ N_MSG_MENU_MOVE,
		"Move" },
	{ N_MSG_MENU_EXEC,
		"Execute" },
	{ N_MSG_MENU_ITEM,
		"Item" },
	{ N_MSG_MENU_EQUIP,
		"Equipment" },
	{ N_MSG_MENU_FIGHT,
		"Fight" },
	{ N_MSG_MENU_SPELL,
		"Cast" },
	{ N_MSG_MENU_TOWN,
		"Town" },
	{ N_MSG_MENU_MISC,
		"Miscellaneous" },

/* menu mark begin */

	{ N_MSG_MENU_POINT_CRSR,
		"Choose the marked one." },

	{ N_MSG_MENU_SEL_OBJ_MBR,
		"Member" },
	{ N_MSG_MENU_SEL_OBJ_SQUARE,
		STR_SQUARE },
	{ N_MSG_MENU_SEL_OBJ_ITEM,
		"Item" },
	{ N_MSG_MENU_SEL_OBJ_MNSTR,
		"Monster" },
	{ N_MSG_MENU_SEL_OBJ_DOOR,
		"Door" },
	{ N_MSG_MENU_SEL_OBJ_TRAP,
		"Trap" },
	{ N_MSG_MENU_SEL_OBJ_POS,
		"Position" },
	{ N_MSG_MENU_SEL_OBJ_CLEAR,
		"Clear" },
	{ N_MSG_MENU_SEL_OBJ_AUTO,
		"Strategy" },

	{ N_MSG_MENU_DIST_NEAR,
		"Near" },
	{ N_MSG_MENU_DIST_MEDIUM,
		"Medium" },
	{ N_MSG_MENU_DIST_FAR,
		"Far" },

	{ N_MSG_MENU_MARK_FIGHT,
		"Fight" },
	{ N_MSG_MENU_MARK_THROW,
		"Shoot" },
	{ N_MSG_MENU_MARK_STEAL,
		"Steal" },
	{ N_MSG_MENU_MARK_TAIL,
		"Follow" },

	{ N_MSG_MENU_MARK_ITEM_PICK_UP,
		"Pick up" },
	{ N_MSG_MENU_MARK_ITEM_OPEN,
		"Open" },
	{ N_MSG_MENU_MARK_ITEM_DISARM,
		STR_DISARM },
	{ N_MSG_MENU_MARK_ITEM_BREAK,
		"Break" },
	{ N_MSG_MENU_MARK_ITEM_CHK,
		"Check" },

	{ N_MSG_MENU_MARK_DOOR_OPEN,
		"Open" },
	{ N_MSG_MENU_MARK_DOOR_CLOSE,
		"Close" },
	{ N_MSG_MENU_MARK_DOOR_JAM,
		"Fix" },
	{ N_MSG_MENU_MARK_DOOR_DISARM,
		STR_DISARM },
	{ N_MSG_MENU_MARK_DOOR_BREAK,
		"Break" },
	{ N_MSG_MENU_MARK_DOOR_PEEP,
		"Peep keyhole" },
	{ N_MSG_MENU_MARK_DOOR_CHK,
		"Check" },

	{ N_MSG_MENU_MARK_TRAP_DISARM,
		STR_DISARM },
	{ N_MSG_MENU_MARK_TRAP_BREAK,
		"Break" },
	{ N_MSG_MENU_MARK_TRAP_CHK,
		"Check" },

	{ N_MSG_MENU_MARK_SQUARE_POS,
		"specify the direction." },

/* menu mark end */

/* menu select item begin */

	{ N_MSG_MENU_ITEM_LS_EQUIP,
		"Equipment" },

	{ N_MSG_MENU_ITEM_QUAFF,
		"Quaff" },
	{ N_MSG_MENU_ITEM_READ,
		"Read" },
	{ N_MSG_MENU_ITEM_ZAP,
		"Zap" },
	{ N_MSG_MENU_ITEM_EAT,
		"Eat" },
	{ N_MSG_MENU_ITEM_SMOKE,
		"Smoke" },
	{ N_MSG_MENU_ITEM_DISPOSE,
		"Dispose of tobacco" },
	{ N_MSG_MENU_ITEM_FILL_LAMP,
		"Fill lamp" },
	{ N_MSG_MENU_ITEM_EQUIP,
		"Equip" },
	{ N_MSG_MENU_ITEM_READY_THROW,
		"Ready throw" },
	{ N_MSG_MENU_ITEM_SEND,
		"Go for passing" },
	{ N_MSG_TTL_MENU_ITEM_SEND,
		"To whom do you go for passing?" },
	{ N_MSG_MENU_ITEM_RECEIVE,
		"Come to getting" },
	{ N_MSG_TTL_MENU_ITEM_RECEIVE,
		"Who comes for getting?" },
	{ N_MSG_MENU_ITEM_DROP,
		"Drop" },
	{ N_MSG_MENU_ITEM_CHK,
		"Check" },

/* menu select item end */

/* menu select equipment begin */

	{ N_MSG_MENU_SEL_EQUIP_WIELDING,
		STR_EQUIP_WIELDING },
	{ N_MSG_MENU_SEL_EQUIP_SHIELD,
		STR_EQUIP_SHIELD },
	{ N_MSG_MENU_SEL_EQUIP_BOW,
		STR_EQUIP_BOW },
	{ N_MSG_MENU_SEL_EQUIP_ARW,
		STR_EQUIP_ARW },
	{ N_MSG_MENU_SEL_EQUIP_HEAD,
		STR_EQUIP_HEAD },
	{ N_MSG_MENU_SEL_EQUIP_NECK,
		STR_EQUIP_NECK },
	{ N_MSG_MENU_SEL_EQUIP_BODY,
		STR_EQUIP_BODY },
	{ N_MSG_MENU_SEL_EQUIP_ARM,
		STR_EQUIP_ARM },
	{ N_MSG_MENU_SEL_EQUIP_RIGHT_HAND,
		STR_EQUIP_RIGHT_HAND },
	{ N_MSG_MENU_SEL_EQUIP_LEFT_HAND,
		STR_EQUIP_LEFT_HAND },
	{ N_MSG_MENU_SEL_EQUIP_FEET,
		STR_EQUIP_FEET },
	{ N_MSG_MENU_SEL_EQUIP_ABOUT_BODY,
		STR_EQUIP_ABOUT_BODY },
	{ N_MSG_MENU_SEL_EQUIP_LIGHT_SOURCE,
		STR_EQUIP_LIGHT_SOURCE },
	{ N_MSG_MENU_EQUIP_LS_ITEM,
		"List item" },

	{ N_MSG_MENU_EQUIP_WEAR_SELF,
		"Wear" },
	{ N_MSG_MENU_EQUIP_WEAR_OTHER,
		"Wear other" },
	{ N_MSG_MENU_EQUIP_TAKE_OFF_SELF,
		"Take off" },
	{ N_MSG_MENU_EQUIP_TAKE_OFF_OTHER,
		"Take off other" },
	{ N_MSG_TTL_MENU_EQUIP_WEAR_OTHER,
		"Who is made to equip it?" },
	{ N_MSG_TTL_MENU_EQUIP_TAKE_OFF_OTHER,
		"Who is made to remove equipment?" },

/* menu select equipment end */

/* menu town begin */

	{ N_MSG_MENU_NAVI,
		"Navigate" },
	{ N_MSG_MENU_AUTO_SALE,
		"Sell the summary of the item" },

/* menu town end */

/* menu navi begin */

	{ N_MSG_TTL_MENU_NAVI,
		"Where do you move?" },
	{ N_MSG_NAVI_PARTY,
		"They moved to the %s." },
	{ N_MSG_NAVI_PARTY_STAIRS,
		"The stairs to labyrinth" },

/* menu navi end */

/* menu auto sale begin */

	{ N_MSG_TTL_MENU_AUTO_SALE_SEL_MBR,
		"Whose item is sold?" },
	{ N_MSG_TTL_MENU_AUTO_SALE,
		"Which item is sold? (%s)" },
	{ N_MSG_MENU_AUTO_SALE_EXEC,
		"The checked items is sold" },
	{ N_MSG_TTL_MENU_AUTO_SALE_ASK,
		"Do you really sell it?" },

/* menu auto sale end */

/* menu misc begin */

	{ N_MSG_MENU_CONTINUE_EXEC,
		"Continuous Execute" },
	{ N_MSG_MENU_STAIRS,
		"Stairs" },
	{ N_MSG_MENU_SRCH,
		"Search" },
	{ N_MSG_MENU_MAP_HINT,
		"Character under Cursor" },
	{ N_MSG_MENU_CHR_DATA,
		"Character\'s sheet" },
	{ N_MSG_MENU_GOLD,
		STR_GOLD },
	{ N_MSG_MENU_COLLECT_GOLD,
		"Collect " STR_GOLD },
	{ N_MSG_MENU_DIVIDE_GOLD,
		"Distribute " STR_GOLD },
	{ N_MSG_MENU_GIVE_GOLD,
		"Pass " STR_GOLD },
	{ N_MSG_MENU_FORMATION,
		"Party formation" },
	{ N_MSG_MENU_LS_MSG,
		"List Message" },
	{ N_MSG_MENU_LS_MNSTR,
		"List Monster" },
	{ N_MSG_MENU_LS_REQUEST,
		"List Request" },
	{ N_MSG_MENU_CNF,
		"Config" },
	{ N_MSG_MENU_SYS,
		"System" },

	{ N_MSG_MENU_STAIRS_UP,
		"Up Stairs" },
	{ N_MSG_MENU_STAIRS_DOWN,
		"Down Stairs" },

	{ N_MSG_TTL_MENU_SRCH,
		"Search" },
	{ N_MSG_MENU_SRCH_EXEC,
		"Execute" },
	{ N_MSG_MENU_SRCH_EXEC_ALL,
		"Execute (All member)" },
	{ N_MSG_MENU_SRCH_CANCEL_ALL,
		"Cancel (All member)" },
	{ N_MSG_MENU_SRCH_AUTO_OFF,
		"Auto off" },

	{ N_MSG_MAP_HINT_FMT_CHR,
		"[X:%2ld, Y:%2ld][%c%c] %s" },
	{ N_MSG_MAP_HINT_FMT_CHR_SUB,
		"[X:%2ld, Y:%2ld][%c%c] %s: %s" },
	{ N_MSG_MAP_HINT_MBR,
		"Member" },
	{ N_MSG_MAP_HINT_MNSTR,
		"Monster" },
	{ N_MSG_MAP_HINT_PET,
		"Friend or Pet" },
	{ N_MSG_MAP_HINT_NPC,
		"NPC" },

	{ N_MSG_MAP_HINT_FMT_OBJ,
		"[X:%2ld, Y:%2ld][%c%c] %s" },
	{ N_MSG_MAP_HINT_FMT_OBJ_SUB,
		"[X:%2ld, Y:%2ld][%c%c] %s: %s" },
	{ N_MSG_MAP_HINT_FLOOR,
		"Floor" },
	{ N_MSG_MAP_HINT_WALL,
		"Wall" },
	{ N_MSG_MAP_HINT_STATUE,
		"Statue" },
	{ N_MSG_MAP_HINT_STREETLAMP,
		"Streetlamp" },
	{ N_MSG_MAP_HINT_ITEM,
		"Item" },
	{ N_MSG_MAP_HINT_TRAP,
		"Trap" },
	{ N_MSG_MAP_HINT_DOOR,
		"Door" },
	{ N_MSG_MAP_HINT_SHOP,
		"Shop" },
	{ N_MSG_MAP_HINT_STAIRS_UP,
		"Up Stairs" },
	{ N_MSG_MAP_HINT_STAIRS_DOWN,
		"Down Stairs" },

	{ N_MSG_MNSTR_DATA_NAME,
		"%c%c is %s" },
	{ N_MSG_MNSTR_DATA_MJR_NAME,
		"%c is %s" },
	{ N_MSG_MNSTR_DATA_MAX_LEV,
		"Max Level of %s is %4ld" },
	{ N_MSG_MNSTR_DATA_MIN_LEV,
		"Min Level of %s is %4ld" },
	{ N_MSG_MNSTR_DATA_AVE_LEV,
		"Average Level of %s is %4ld" },
	{ N_MSG_MNSTR_DATA_HP,
		"HP of %s is %6ld/%6ld" },
	{ N_MSG_MNSTR_DATA_MP,
		"MP of %s is %6ld/%6ld" },
	{ N_MSG_MNSTR_DATA_DRUNK,
		"%s is drunk" },

	{ N_MSG_TTL_MENU_GIVE_GOLD,
		"To whom are " STR_GOLD " passed?" },

	{ N_MSG_TTL_MENU_FORMATION_SEL_MBR,
		"Who's member?" },
	{ N_MSG_TTL_MENU_FORMATION_SEL_N,
		"What's number?" },

/* menu cursor begin */

	{ N_MSG_MENU_CRSR,
		"Cursor" },

/* menu cursor move begin */

	{ N_MSG_MENU_CRSR_MOVE,
		"Move" },
	{ N_MSG_MENU_CRSR_MOVE_UP,
		"North" },
	{ N_MSG_MENU_CRSR_MOVE_DOWN,
		"South" },
	{ N_MSG_MENU_CRSR_MOVE_LEFT,
		"West" },
	{ N_MSG_MENU_CRSR_MOVE_RIGHT,
		"East" },
	{ N_MSG_MENU_CRSR_MOVE_UP_LEFT,
		"North West" },
	{ N_MSG_MENU_CRSR_MOVE_UP_RIGHT,
		"North East" },
	{ N_MSG_MENU_CRSR_MOVE_DOWN_LEFT,
		"South West" },
	{ N_MSG_MENU_CRSR_MOVE_DOWN_RIGHT,
		"South East" },
	{ N_MSG_MENU_CRSR_MOVE_ABS,
		"Absolute" },
	{ N_MSG_MENU_CRSR_MOVE_STOP,
		"On the spot" },

/* menu cursor move end */

/* menu cursor quick move begin */

	{ N_MSG_MENU_CRSR_QUICK_MOVE,
		"Move until coming next to something" },
	{ N_MSG_MENU_CRSR_QUICK_MOVE_UP,
		"North" },
	{ N_MSG_MENU_CRSR_QUICK_MOVE_DOWN,
		"South" },
	{ N_MSG_MENU_CRSR_QUICK_MOVE_LEFT,
		"West" },
	{ N_MSG_MENU_CRSR_QUICK_MOVE_RIGHT,
		"East" },
	{ N_MSG_MENU_CRSR_QUICK_MOVE_UP_LEFT,
		"North West" },
	{ N_MSG_MENU_CRSR_QUICK_MOVE_UP_RIGHT,
		"North East" },
	{ N_MSG_MENU_CRSR_QUICK_MOVE_DOWN_LEFT,
		"South West" },
	{ N_MSG_MENU_CRSR_QUICK_MOVE_DOWN_RIGHT,
		"South East" },

/* menu cursor quick move end */

/* menu cursor scroll begin */

	{ N_MSG_MENU_CRSR_SCROLL,
		"Move" },
	{ N_MSG_MENU_CRSR_SCROLL_UP,
		"North" },
	{ N_MSG_MENU_CRSR_SCROLL_DOWN,
		"South" },
	{ N_MSG_MENU_CRSR_SCROLL_LEFT,
		"West" },
	{ N_MSG_MENU_CRSR_SCROLL_RIGHT,
		"East" },
	{ N_MSG_MENU_CRSR_SCROLL_UP_LEFT,
		"North West" },
	{ N_MSG_MENU_CRSR_SCROLL_UP_RIGHT,
		"North East" },
	{ N_MSG_MENU_CRSR_SCROLL_DOWN_LEFT,
		"South West" },
	{ N_MSG_MENU_CRSR_SCROLL_DOWN_RIGHT,
		"South East" },

/* menu cursor scroll end */

	{ N_MSG_MENU_CRSR_MOVE_MBR,
		"Direct Member" },
	{ N_MSG_MENU_CRSR_CENTER,
		"Centering" },

/* menu cursor next position begin */

	{ N_MSG_MENU_CRSR_NEXT_POS,
		"Next Position" },
	{ N_MSG_MENU_CRSR_NEXT_POS_MBR,
		"Next Member" },
	{ N_MSG_MENU_CRSR_NEXT_POS_MNSTR,
		"Next Monster" },
	{ N_MSG_MENU_CRSR_NEXT_POS_ITEM,
		"Next Item" },
	{ N_MSG_MENU_CRSR_NEXT_POS_DOOR,
		"Next Door" },
	{ N_MSG_MENU_CRSR_NEXT_POS_OBJ,
		"Next Object" },
	{ N_MSG_MENU_CRSR_NEXT_POS_SQUARE,
		"Next " STR_SQUARE },
	{ N_MSG_MENU_CRSR_NEXT_POS_ALL,
		"Next" },
	{ N_MSG_MENU_CRSR_PREV_POS,
		"Previous" },

/* menu cursor next position end */

/* menu cursor end */

	{ N_MSG_LS_MNSTR,
		"from %3ld to %3ld : %s" },

/* menu config begin */

	{ N_MSG_MENU_AUTO_FIGHT,
		"If the monster is obstructive, member attacks it" },
	{ N_MSG_MENU_AUTO_DOOR,
		"The door is automatically opened" },
	{ N_MSG_MENU_AVOID_TRAP,
		"The trap is avoided" },
	{ N_MSG_MENU_AUTO_RELOAD,
		"The arrow is loaded automatically" },
	{ N_MSG_MENU_ACTUAL_FIGHTING,
		"Member can attack the companion" },
	{ N_MSG_MENU_SPACE_SELECT,
		"The menu is selected pushing the space bar" },
	{ N_MSG_MENU_RESET_FILE,
		"Initialization of setting" },
	{ N_MSG_MENU_RESET_FILE_CONFIG,
		"Initialization of configuration file" },
	{ N_MSG_MENU_RESET_FILE_TOWN_PTN,
		"Initialization of map file of town" },
	{ N_MSG_TTL_MENU_RESET_FILE_ASK,
		"Do you really initialize it?" },
	{ N_MSG_RESET_FILE,
		"It initialized it." },
	{ N_MSG_MENU_LANG,
		"Language" },
	{ N_MSG_MENU_LANG_LS,
		"Language list" },
	{ N_MSG_MENU_LANG_LS_PRIORITY,
		"It gives priority to this setting more than"
		" the environment variable" },
	{ N_MSG_SET_LANG,
		"The language was set to \"%s\"" },
	{ N_MSG_MENU_SCREEN,
		"Screen" },
	{ N_MSG_MENU_WINDOW,
		"Window" },
	{ N_MSG_MENU_SCROLL_MODE,
		"Scroll" },
	{ N_MSG_MENU_REDRAW_EVERY_TURN,
		"It draws on the screen again at each turn" },
	{ N_MSG_MENU_MUL_MSG_LINE,
		"The message line is made two or more" },
	{ N_MSG_MENU_SCREEN_SIZE,
		"Screen size" },
	{ N_MSG_MENU_SCREEN_SIZE_AUTO,
		"Auto setting" },
	{ N_MSG_MENU_SCREEN_SIZE_LINES,
		"Lines" },
	{ N_MSG_MENU_VFX,
		"Visual effects" },
	{ N_MSG_MENU_COLOR,
		"Display color" },
	{ N_MSG_MENU_CRSR_PTN,
		"Shape of cursor" },
	{ N_MSG_MENU_KEY,
		"Keyboard" },
	{ N_MSG_MENU_CLR_KEY_BUF,
		"The key buffer is cleared" },
	{ N_MSG_MENU_CLR_KEY_BUF_EVERY,
		"Time usually" },
	{ N_MSG_MENU_CLR_KEY_BUF_MENU,
		"When menu is selected" },
	{ N_MSG_MENU_ECHO_KEY,
		"The input key is displayed" },
	{ N_MSG_MENU_KEY_BIND,
		"Key allocation" },
	{ N_MSG_MENU_FUNC,
		"Function key" },
	{ N_MSG_MENU_USER,
		"User menu" },

	{ N_MSG_REG_MACRO_BGN,
		"The record of the macro begins." },
	{ N_MSG_REG_MACRO_END,
		"The record of the macro is ended. [%s]" },

	{ N_MSG_MENU_SCROLL_PAGE,
		"Page scroll" },
	{ N_MSG_MENU_SCROLL_SMOOTH,
		"Smoothness scroll" },
	{ N_MSG_MENU_SCROLL_CENTER,
		"The screen is smoothly scrolled centering on the cursor" },

	{ N_MSG_MENU_VFX_MBR_CURE,
		"VFX of recovery of member" },
	{ N_MSG_MENU_VFX_MBR_DAM,
		"VFX of damage to member" },
	{ N_MSG_MENU_VFX_MBR_CRTCL,
		"VFX of critical to member" },
	{ N_MSG_MENU_VFX_MBR_ARW,
		"VFX of member\'s distance attack" },
	{ N_MSG_MENU_VFX_MNSTR_CURE,
		"VFX of recovery of monster" },
	{ N_MSG_MENU_VFX_MNSTR_DAM,
		"VFX of damage to monster" },
	{ N_MSG_MENU_VFX_MNSTR_CRTCL,
		"VFX of critical to monster" },
	{ N_MSG_MENU_VFX_MNSTR_ARW,
		"VFX of monster\'s distance attack" },
	{ N_MSG_MENU_VFX_WAIT,
		"Wait of VFX [%ld]" },
	{ N_MSG_MENU_VFX_MEASURE_CLK_TCK,
		"The frame rate is measured" },

	{ N_MSG_MENU_FG,
		"Foreground color" },
	{ N_MSG_MENU_BG,
		"Background color" },
	{ N_MSG_MENU_COLOR_BLACK,
		"black" },
	{ N_MSG_MENU_COLOR_RED,
		"Red" },
	{ N_MSG_MENU_COLOR_GREEN,
		"Green" },
	{ N_MSG_MENU_COLOR_YELLOW,
		"Yellow" },
	{ N_MSG_MENU_COLOR_BLUE,
		"Blue" },
	{ N_MSG_MENU_COLOR_MAGENTA,
		"Magenta" },
	{ N_MSG_MENU_COLOR_CYAN,
		"Cyan" },
	{ N_MSG_MENU_COLOR_WHITE,
		"White" },

	{ N_MSG_MENU_ATTR,
		"Attribute" },
	{ N_MSG_MENU_UNDERLINE,
		"Underline" },
	{ N_MSG_MENU_REVERSE,
		"Reverse" },
	{ N_MSG_MENU_BLINK,
		"Blink" },
	{ N_MSG_MENU_BOLD,
		"Bold" },

	{ N_MSG_MENU_SET_KEY,
		"Allocate it in the key" },
	{ N_MSG_MENU_SET_KEY_REG_MACRO,
		"Allocate the key the recorded macro" },
	{ N_MSG_MENU_UNSET_KEY,
		"Release the allocation of the key" },
	{ N_MSG_GETS_SET_KEY_KEY,
		"Please input the key to the allocation. : " },
	{ N_MSG_GETS_SET_KEY_PREV,
		"Present command : \"%s\"" },
	{ N_MSG_GETS_SET_KEY_CMD,
		"Please input the command. (Within %ld characters) : " },
	{ N_MSG_MENU_SET_KEY_DONE,
		"The macro was allocated. : \'%s\' \"%s\"" },
	{ N_MSG_GETS_UNSET_KEY_KEY,
		"Please input the key that release a allocation. : " },

	{ N_MSG_MENU_FUNC_KEY,
		"Function key F%ld" },
	{ N_MSG_MENU_FUNC_EXEC,
		"Execute" },
	{ N_MSG_MENU_FUNC_EDIT,
		"Edit" },
	{ N_MSG_MENU_FUNC_SET_REG_MACRO,
		"Allocate the key the recorded macro" },
	{ N_MSG_GETS_FUNC_PREV,
		"Present command : \"%s\"" },
	{ N_MSG_GETS_FUNC_EDIT,
		"Please input the command. (Within %ld characters) : " },
	{ N_MSG_TTL_MENU_FUNC_SET_REG_MACRO,
		"Do you allocate it in [%ld] of the function key?" },
	{ N_MSG_MENU_FUNC_KEY_DONE,
		"The macro was allocated. : F%ld \"%s\"" },

	{ N_MSG_MENU_USER_NEW,
		"New" },
	{ N_MSG_MENU_USER_NEW_REG_MACRO,
		"Make it from the recorded macro newly" },
	{ N_MSG_MENU_USER_ARRANGE_TOP,
		"Rearrange it to the head" },
	{ N_MSG_MENU_USER_ARRANGE_BOTTOM,
		"Rearrange it to the tail" },
	{ N_MSG_MENU_USER_REMOVE,
		"Remove" },
	{ N_MSG_GETS_USER_MENU_NAME,
		"Please input the menu name. : " },
	{ N_MSG_GETS_USER_MENU_CMD,
		"Please input the command. (Within %ld characters) : " },
	{ N_MSG_MENU_USER_NEW_DONE_1,
		"The macro was allocated. : \"%s\"" },
	{ N_MSG_MENU_USER_NEW_DONE_2,
		"\"%s\"" },

	{ N_MSG_GETS_AUTO_MARK_INFO_TTL,
		"Detailed name of strategy at present : \"%s\"" },
	{ N_MSG_GETS_AUTO_MARK_INFO_NAME,
		"Please input a detailed name of the strategy. : " },
	{ N_MSG_GETS_AUTO_MARK_HINT_TTL,
		"Call of strategy at present : \"%s\"" },
	{ N_MSG_GETS_AUTO_MARK_HINT_NAME,
		"Please input the call of the strategy. : " },

	{ N_MSG_GETS_AUTO_MARK_EDIT_MACRO_TTL,
		"Present command : \"%s\"" },
	{ N_MSG_GETS_AUTO_MARK_EDIT_MACRO_CMD,
		"Please input the command. (Within %ld characters) : " },
	{ N_MSG_TTL_MENU_AUTO_MARK_EDIT_MACRO_REG_MACRO,
		"Is the recorded macro allocated?" },
	{ N_MSG_MENU_AUTO_MARK_EDIT_MACRO_DONE,
		"The macro was allocated. : \"%s\"" },

/* menu config end */

/* menu system begin */

	{ N_MSG_MENU_REPLAY,
		"Replay" },
	{ N_MSG_MENU_COMMAND,
		"Input command" },
	{ N_MSG_MENU_WIZARD,
		"Wizard" },
	{ N_MSG_MENU_OUT_MAP_FILE,
		"Output map to file" },
	{ N_MSG_MENU_SHELL,
		"Shell" },
	{ N_MSG_MENU_ABOUT_GAME,
		"About " STR_FILE_NAME_GAME },
	{ N_MSG_MENU_EXIT,
		"Exit" },

/* menu replay begin */

	{ N_MSG_MENU_REPLAY_LOAD,
		"Load replay" },
	{ N_MSG_MENU_REPLAY_SAVE,
		"Save replay" },
	{ N_MSG_MENU_REPLAY_DEBUG,
		"Debug" },
	{ N_MSG_MENU_REPLAY_BUG_REPO,
		"Bug report" },
	{ N_MSG_REPLAY_BUG_REPO_1,
		"Please append the following directories" },
	{ N_MSG_REPLAY_BUG_REPO_2,
		" and send the mail of the bug report." },

/* menu replay end */

/* menu wizard begin */

	{ N_MSG_TTL_MENU_WIZARD,
		"The limitation is released" },
	{ N_MSG_MENU_WIZARD_ON_LIGHT,
		"The light is turned on" },
	{ N_MSG_MENU_WIZARD_OFF_LIGHT,
		"The light is turned off" },
	{ N_MSG_MENU_WIZARD_ADD_TURN,
		"Turn is advanced" },
	{ N_MSG_MENU_WIZARD_LEV_UP,
		"Raise their levels" },
	{ N_MSG_MENU_WIZARD_TEXT_LOAD,
		"Load the file saved by text" },
	{ N_MSG_MENU_WIZARD_TEXT_SAVE,
		"Save the file saved by text" },

/* menu wizard end */

	{ N_MSG_TTL_MENU_EXIT,
		"Do you exit really?" },

/* menu system end */

/* menu misc end */

/* menu auto mark begin */

	{ N_MSG_TTL_MENU_AUTO_MARK,
		"Strategy" },
	{ N_MSG_MENU_AUTO_MARK_EXEC,
		"Execute" },
	{ N_MSG_MENU_AUTO_MARK_EDIT,
		"Edit" },
	{ N_MSG_MENU_AUTO_MARK_EDIT_NAME,
		"Edit title" },
	{ N_MSG_MENU_AUTO_MARK_COPY,
		"Copy" },
	{ N_MSG_MENU_AUTO_MARK_PASTE,
		"Paste" },
	{ N_MSG_MENU_AUTO_MARK_ARRANGE_TOP,
		"Rearrange it to the head" },
	{ N_MSG_MENU_AUTO_MARK_ARRANGE_BOTTOM,
		"Rearrange it to the tail" },
	{ N_MSG_MENU_AUTO_MARK_INVALID,
		"----" },

	{ N_MSG_MENU_AUTO_MARK_DONE_COPY,
		"Copy was done" },
	{ N_MSG_MENU_AUTO_MARK_DONE_PASTE,
		"Paste was done" },
	{ N_MSG_MENU_AUTO_MARK_DONE_ARRANGE_TOP,
		"Arrange was done" },
	{ N_MSG_MENU_AUTO_MARK_DONE_ARRANGE_BOTTOM,
		"Arrange was done" },

	{ N_MSG_TTL_MENU_AUTO_MARK_EDIT,
		"Setup (%s) - %s" },
	{ N_MSG_MENU_AUTO_MARK_EDIT_TRGT,
		"Target    : %s" },
	{ N_MSG_MENU_AUTO_MARK_EDIT_DIST,
		"Distance  : %s" },
	{ N_MSG_MENU_AUTO_MARK_EDIT_ACT,
		"Action    : %s" },
	{ N_MSG_MENU_AUTO_MARK_EDIT_COND,
		"Condition : %s" },
	{ N_MSG_MENU_AUTO_MARK_EDIT_APPOINT_ITEM,
		"Appoint item" },
	{ N_MSG_MENU_AUTO_MARK_EDIT_MACRO,
		"Macro" },
	{ N_MSG_MENU_AUTO_MARK_EDIT_MACRO_BIND,
		"Edit macro" },
	{ N_MSG_MENU_AUTO_MARK_EDIT_MACRO_REG_MACRO,
		"Allocate the recorded macro." },
	{ N_MSG_MENU_AUTO_MARK_EDIT_CONT,
		"Continue" },
	{ N_MSG_MENU_AUTO_MARK_EDIT_PRIORITY,
		"Priority" },

	{ N_MSG_TTL_MENU_AUTO_MARK_TRGT,
		"Target (%s) - %s" },
	{ N_MSG_MENU_AUTO_MARK_TRGT_MNSTR,
		"Monster" },
	{ N_MSG_MENU_AUTO_MARK_TRGT_ITEM,
		"Item" },
	{ N_MSG_MENU_AUTO_MARK_TRGT_DOOR,
		"Door" },
	{ N_MSG_MENU_AUTO_MARK_TRGT_TRAP,
		"Trap" },
	{ N_MSG_MENU_AUTO_MARK_TRGT_MBR,
		"Member" },
	{ N_MSG_MENU_AUTO_MARK_TRGT_UNCHANGE,
		"Unchange" },
	{ N_MSG_MENU_AUTO_MARK_TRGT_CLEAR,
		"Clear" },

	{ N_MSG_TTL_MENU_AUTO_MARK_DIST,
		"Distance (%s) - %s" },
	{ N_MSG_MENU_AUTO_MARK_DIST_NEAR,
		"Near" },
	{ N_MSG_MENU_AUTO_MARK_DIST_MEDIUM,
		"Medium" },
	{ N_MSG_MENU_AUTO_MARK_DIST_FAR,
		"Far" },

	{ N_MSG_TTL_MENU_AUTO_MARK_ACT,
		"Action (%s) - %s" },
	{ N_MSG_MENU_AUTO_MARK_ACT_FIGHT,
		"Fight" },
	{ N_MSG_MENU_AUTO_MARK_ACT_THROW,
		"Shoot" },
	{ N_MSG_MENU_AUTO_MARK_ACT_STEAL,
		"Steal" },
	{ N_MSG_MENU_AUTO_MARK_ACT_TAIL,
		"Follow" },
	{ N_MSG_MENU_AUTO_MARK_ACT_CHK,
		"Check" },
	{ N_MSG_MENU_AUTO_MARK_ACT_PICK_UP,
		"Pick up" },
	{ N_MSG_MENU_AUTO_MARK_ACT_BREAK,
		"Break" },
	{ N_MSG_MENU_AUTO_MARK_ACT_OPEN,
		"Open" },
	{ N_MSG_MENU_AUTO_MARK_ACT_CLOSE,
		"Close" },
	{ N_MSG_MENU_AUTO_MARK_ACT_JAM,
		"Fix" },
	{ N_MSG_MENU_AUTO_MARK_ACT_DISARM,
		STR_DISARM },
	{ N_MSG_MENU_AUTO_MARK_ACT_PEEP,
		"The keyhole is excluded" },

	{ N_MSG_TTL_MENU_AUTO_MARK_COND,
		"Condition (%s) - %s" },
	{ N_MSG_MENU_AUTO_MARK_COND_NEAREST,
		"Nearest" },
	{ N_MSG_MENU_AUTO_MARK_COND_DISPERSE,
		"Disperse" },
	{ N_MSG_MENU_AUTO_MARK_COND_STAGGER,
		"Stagger" },
	{ N_MSG_MENU_AUTO_MARK_COND_OWN,
		"It has it" },
	{ N_MSG_MENU_AUTO_MARK_COND_HP_MIN,
		"Few of MP" },
	{ N_MSG_MENU_AUTO_MARK_COND_HP_MAX,
		"A lot of HP" },
	{ N_MSG_MENU_AUTO_MARK_COND_MP_MIN,
		"Few of MP" },
	{ N_MSG_MENU_AUTO_MARK_COND_MP_MAX,
		"A lot of MP" },

	{ N_MSG_TTL_MENU_AUTO_MARK_APPOINT_ITEM_MJR,
		"Item kind (%s) - %s" },
	{ N_MSG_TTL_MENU_AUTO_MARK_APPOINT_ITEM_MNR,
		"Item details (%s) - %s" },

	{ N_MSG_NAME_DFLT_AUTO_MARK_FIGHT,
		"Battle (addition)\nFight!" },
	{ N_MSG_NAME_DFLT_AUTO_MARK_FIGHT_PRIO,
		"Battle (all)\nFight!" },
	{ N_MSG_NAME_DFLT_AUTO_MARK_FIGHT_NO_THROW,
		"Approach battle (addition)\nDon't use arrow" },
	{ N_MSG_NAME_DFLT_AUTO_MARK_FIGHT_NO_THROW_PRIO,
		"Approach battle (all)\nDon't use arrow" },
	{ N_MSG_NAME_DFLT_AUTO_MARK_FIGHT_ALL,
		"annihilating battle (addition)\nIt's small frys" },
	{ N_MSG_NAME_DFLT_AUTO_MARK_FIGHT_ALL_PRIO,
		"annihilating battle (all)\nIt's small frys" },
	{ N_MSG_NAME_DFLT_AUTO_MARK_ITEM_ALL,
		"All item\nPick it up early" },
	{ N_MSG_NAME_DFLT_AUTO_MARK_ITEM_OWN,
		"Had item\nPick up the dropping arrow" },
	{ N_MSG_NAME_DFLT_AUTO_MARK_CLEAR,
		"Clear" },

/* menu auto mark end */

/* menu town begin */

	{ N_MSG_MENU_SHOP_SEL_MBR,
		"Who enters the %s?" },

	{ N_MSG_BUY,
		"Buy" },
	{ N_MSG_SALE_ITEM,
		"Sell item" },
	{ N_MSG_SALE_EQUIP,
		"Sell equipment" },

	{ N_MSG_MENU_BUY,
		"Do you buy %s?" },
	{ N_MSG_MENU_SALE,
		"Do you sell %s?" },
	{ N_MSG_TTL_MENU_BUY,
		"Do you buy it?" },
	{ N_MSG_TTL_MENU_SALE,
		"Do you sell it?" },
	{ N_MSG_MENU_REACHED_BUY,
		"%s was bought." },
	{ N_MSG_MENU_REACHED_SALE,
		"%s was sold." },
	{ N_MSG_NO_DEAL,
		"I cannot deal this %s." },

	{ N_MSG_FMT_MENU_SHOP,
		"%s %s %s " STR_GOLD_FMT_MAX },
	{ N_MSG_FMT_MENU_MAGIC_GUILD,
		"%-24s Level %3ld, " STR_GOLD_FMT_MAX },
	{ N_MSG_FMT_MENU_PET_SHOP,
		"%-32s " STR_GOLD_FMT_MAX },

	{ N_MSG_MENU_SHOP_DATA,
		"Character\'s sheet" },
	{ N_MSG_MENU_SHOP_COLLECT_GOLD,
		"Collect " STR_GOLD },
	{ N_MSG_MENU_SHOP_DIVIDE_GOLD,
		"Distribute " STR_GOLD },
	{ N_MSG_MENU_SHOP_GIVE_GOLD,
		"Pass " STR_GOLD },
	{ N_MSG_MENU_SHOP_BUY,
		"Buy" },
	{ N_MSG_MENU_SHOP_SALE_ITEM,
		"Sell item" },
	{ N_MSG_MENU_SHOP_SALE_EQUIP,
		"Sell equipment" },

	{ N_MSG_TTL_MENU_TEMPLE,
		"%s %s " STR_GOLD_FMT },
	{ N_MSG_FMT_MENU_TEMPLE,
		"%-*s " STR_GOLD_FMT_MAX },
	{ N_MSG_MENU_TEMPLE_REMOVE_CURSE,
		"Remove curse" },
	{ N_MSG_MENU_TEMPLE_CURE_STATUS,
		"Cure status" },
	{ N_MSG_MENU_TEMPLE_RESURRECTION,
		"Resurrection" },
	{ N_MSG_MENU_TEMPLE_CONTRIBUTION,
		"Contribution" },

	{ N_MSG_TTL_MENU_TEMPLE_REMOVE_CURSE,
		"Do you want to remove curse?" },
	{ N_MSG_TTL_MENU_TEMPLE_CURE_STATUS,
		"Do you want to cure status?" },
	{ N_MSG_TTL_MENU_TEMPLE_RESURRECTION,
		"Do you want to be resurrected?" },
	{ N_MSG_TTL_MENU_TEMPLE_CONTRIBUTION,
		"Do you contribute it?" },

	{ N_MSG_MENU_REMOVE_CURSE,
		"curse of %s was removed." },
	{ N_MSG_MENU_REMOVE_CURSE_ERR,
		"%s is not cursed." },
	{ N_MSG_MENU_CURE_STATUS,
		"Status of %s was cured." },
	{ N_MSG_MENU_CURE_STATUS_ERR,
		"Status of %s is not bad." },
	{ N_MSG_TTL_MENU_RESURRECTION,
		"Who do you want to resurrect?" },
	{ N_MSG_MENU_RESURRECTION_ERR_ALL_MBR,
		"No one is dead." },
	{ N_MSG_MENU_RESURRECTION_ERR,
		"%s is not dead." },
	{ N_MSG_MENU_CONTRIBUTION,
		"%s contributed " STR_GOLD_FMT "." },

	{ N_MSG_TTL_MENU_ORDER,
		"What do you order?" },
	{ N_MSG_MENU_ORDER_MBR,
		"%s : %s" },
	{ N_MSG_MENU_ORDER_CHOSE,
		"Order" },
	{ N_MSG_MENU_ORDER_NULL,
		"She/He doesn't order" },

	{ N_MSG_MENU_BAR_ORDER,
		"drink and eat." },
	{ N_MSG_MENU_BAR_REQUEST,
		"Request" },
	{ N_MSG_MENU_BAR_FORM,
		"Party formation" },

	{ N_MSG_MENU_REQUEST_REFRESH,
		"---- Pay " STR_GOLD_FMT " and look at another. ----" },
	{ N_MSG_TTL_MENU_REQUEST_REFRESH_ASK,
		"Do you pay the commission?" },
	{ N_MSG_TTL_MENU_REQUEST_MBR_CONTRACT,
		"Do you undertake this request?" },
	{ N_MSG_TTL_MENU_REQUEST_MBR_CANCEL,
		"Do you pay " STR_GOLD_FMT " and decline this request?" },

	{ N_MSG_MENU_BAR_EDIT_MBR,
		"Edit member" },
	{ N_MSG_MENU_BAR_NEW_MBR,
		"Register a new member" },
	{ N_MSG_MENU_BAR_REMOVE_MBR,
		"Remove member" },

	{ N_MSG_MENU_BAR_EDIT_CLASS,
		"Edit class" },
	{ N_MSG_MENU_BAR_NEW_CLASS,
		"Register a new class" },
	{ N_MSG_MENU_BAR_REMOVE_CLASS,
		"Remove class" },

	{ N_MSG_MENU_BAR_LOAD,
		"Load" },
	{ N_MSG_MENU_BAR_SAVE,
		"Save" },
	{ N_MSG_TTL_MENU_ASK_LOAD,
		"Do you really load it?" },
	{ N_MSG_TTL_MENU_ASK_SAVE,
		"Do you really save it?" },
	{ N_MSG_SAVE_LOAD_TTL_FMT,
		"%2ld: %s" },
	{ N_MSG_SAVE_LOAD_TTL_NULL,
		"-------- NO DATA  --------" },
	{ N_MSG_MENU_LOAD_SUCCESS,
		"Data was loaded from the %ld th slot." },
	{ N_MSG_MENU_SAVE_SUCCESS_BIN,
		"Data was saved to the %ld th slot." },
	{ N_MSG_MENU_SAVE_SUCCESS_TXT,
		"Data was saved to the %ld th slot in the wizard mode." },

	{ N_MSG_TTL_MENU_BAR_FORM,
		"Party formation" },
	{ N_MSG_MENU_BAR_JOIN,
		"Add it to the party" },
	{ N_MSG_MENU_BAR_NOT_JOIN,
		"Remove it from the party" },

	{ N_MSG_TTL_MENU_BAR_EDIT_MBR,
		"Edit a member" },
	{ N_MSG_TTL_MENU_BAR_EDIT_MBR_SUB,
		"Edit %s" },
	{ N_MSG_MENU_BAR_ARRANGE_TOP,
		"Rearrange it to the head" },
	{ N_MSG_MENU_BAR_ARRANGE_BOTTOM,
		"Rearrange it to the tail" },
	{ N_MSG_TTL_MENU_BAR_REMOVE_MBR,
		"Delete a member" },

	{ N_MSG_TTL_MENU_ASK_EDIT_MBR,
		"Do you keep a change?" },
	{ N_MSG_TTL_MENU_ASK_NEW_MBR,
		"Do you register a member by this setup?" },
	{ N_MSG_TTL_MENU_ASK_REMOVE_MBR,
		"Do you really delete a member?" },

	{ N_MSG_MENU_REMOVE_MBR_NAME,
		"Delete %s" },
	{ N_MSG_MENU_REMOVE_MBR_LEV,
		"The highest level is a percent 4ld." },
	{ N_MSG_MENU_REMOVE_MBR_GOLD,
		"They have " STR_GOLD_FMT "." },
	{ N_MSG_MENU_REMOVE_MBR,
		"%s was deleted." },
	{ N_MSG_MENU_REMOVE_MBR_CANCEL,
		"%s wasn't deleted." },

	{ N_MSG_TTL_MENU_ASK_EDIT_CLASS,
		"Do you keep a change?" },
	{ N_MSG_TTL_MENU_ASK_NEW_CLASS,
		"Do you register a class by this setup?" },
	{ N_MSG_TTL_MENU_ASK_REMOVE_CLASS,
		"Do you really delete a class?" },

	{ N_MSG_TTL_MENU_SEL_EDIT_CLASS,
		"Edit a class" },
	{ N_MSG_MENU_BAR_ARRANGE_TOP_CLASS,
		"Rearrange it to the head" },
	{ N_MSG_MENU_BAR_ARRANGE_BOTTOM_CLASS,
		"Rearrange it to the tail" },

	{ N_MSG_MENU_NEW_MBR,
		"New Character" },
	{ N_MSG_MENU_NEW_CLASS,
		"New Class" },

	{ N_MSG_MENU_INN_STAY,
		"Stays         " STR_GOLD_FMT_MAX },
	{ N_MSG_MENU_INN_SHORT_STAY,
		"Takes a rest  " STR_GOLD_FMT_MAX },
	{ N_MSG_MENU_INN_STAY_IN_MEWS,
		"Stays in mews " STR_GOLD_FMT_MAX },
	{ N_MSG_MENU_INN_BATH,
		"Take a bath" },
	{ N_MSG_MENU_INN_DO_STAY,
		"It did one night, and the morning came." },
	{ N_MSG_MENU_INN_DO_SHORT_STAY,
		"They took a rest for a while." },
	{ N_MSG_TTL_MENU_INN_BATH,
		"Who steps into a bath?" },
	{ N_MSG_TAKE_BATH,
		"%s stepped into a bath." },
	{ N_MSG_CHR_IS_MOLESTED,
		"%s had someone peeped into the bathroom." },
	{ N_MSG_MENU_INN_CALENDAR,
		"It became %s" },

	{ N_MSG_TTL_MENU_MAGIC_GUILD,
		"%s %s " STR_GOLD_FMT },

/* menu pet shop begin */

	{ N_MSG_TTL_MENU_PET_SHOP,
		"%s %s " STR_GOLD_FMT },
	{ N_MSG_TTL_MENU_PET_SHOP_TAKE,
		"%s %s Take" },
	{ N_MSG_TTL_MENU_PET_SHOP_LEAVE,
		"%s %s Leave" },
	{ N_MSG_TTL_MENU_PET_SHOP_NAME,
		"%s %s Name" },
	{ N_MSG_TTL_MENU_PET_SHOP_REMOVE,
		"%s %s Remove" },

	{ N_MSG_MENU_PET_SHOP_BUY,
		"Buy a pet" },
	{ N_MSG_MENU_PET_SHOP_TAKE,
		"Take a pet" },
	{ N_MSG_MENU_PET_SHOP_LEAVE,
		"Leave a pet" },
	{ N_MSG_MENU_PET_SHOP_NAME,
		"Name a pet" },
	{ N_MSG_MENU_PET_SHOP_REMOVE,
		"Remove a pet" },

	{ N_MSG_MENU_PET_SHOP_NAME_LS,
		"%s (%s)" },

	{ N_MSG_MENU_PET_SHOP_ASK_BUY,
		"Do you buy %s ?" },
	{ N_MSG_TTL_MENU_PET_SHOP_ASK_BUY,
		"Do you buy really?" },

	{ N_MSG_MENU_PET_SHOP_ASK_REMOVE,
		"Do you remove %s really?" },
	{ N_MSG_TTL_MENU_PET_SHOP_ASK_REMOVE,
		"Do you remove pet really?" },

	{ N_MSG_MENU_PET_SHOP_BUY_SUCCESS,
		"Bought %s" },
	{ N_MSG_MENU_PET_SHOP_TAKE_SUCCESS,
		"You taked %s" },
	{ N_MSG_MENU_PET_SHOP_LEAVE_SUCCESS,
		"You leaved %s" },
	{ N_MSG_MENU_PET_SHOP_NAME_SUCCESS,
		"You named %s" },
	{ N_MSG_MENU_PET_SHOP_REMOVE_SUCCESS,
		"You removed %s" },

/* menu pet shop end */

/* menu town end */

/* menu spell begin */

	{ N_MSG_MENU_SPELL_LS,
		"%-30s MP:%3ld HP:%3ld " STR_GOLD ":%3ld" },

	{ N_MSG_MENU_SPELL_EXTENT_NORMAL,
		"Normal" },
	{ N_MSG_MENU_SPELL_EXTENT_SPREAD,
		"Spread (X 2)" },
	{ N_MSG_MENU_SPELL_EXTENT_MASS,
		"Mass (X 3)" },
	{ N_MSG_MENU_SPELL_EXTENT_LIMIT,
		"Limit" },
	{ N_MSG_MENU_SPELL_EXTENT_HALF,
		"Half (/ 2)" },
	{ N_MSG_MENU_SPELL_EXTENT_DOUBLE,
		"Double (X 2)" },

/* menu spell end */

/* menu end */

/* GUI menu begin */

	{ N_MSG_SEL_CONF_LABEL,
		"Choose a graphic setting." },
	{ N_MSG_SEL_CONF_OK,
		"START" },
	{ N_MSG_SEL_CONF_CANCEL,
		"EXIT" },

	{ N_MSG_GUI_MAP_EXEC,
		"   Exec   " },
	{ N_MSG_GUI_MAP_CONT_EXEC,
		"Continuous" },

	{ N_MSG_GUI_MAP_TOOL_TIP_EXEC,
		"   Exec   " },
	{ N_MSG_GUI_MAP_TOOL_TIP_CONT_EXEC,
		"Continuous" },

	{ N_MSG_GUI_MENU_PREV_PAGE_ON,
		" << " },
	{ N_MSG_GUI_MENU_PREV_PAGE_OFF,
		"    " },
	{ N_MSG_GUI_MENU_NEXT_PAGE_ON,
		" >> " },
	{ N_MSG_GUI_MENU_NEXT_PAGE_OFF,
		"    " },
	{ N_MSG_GUI_MENU_CANCEL_ON,
		" Back " },
	{ N_MSG_GUI_MENU_CANCEL_OFF,
		"      " },
	{ N_MSG_GUI_MENU_CANCEL_ALL_ON,
		"Close " },
	{ N_MSG_GUI_MENU_CANCEL_ALL_OFF,
		"      " },

	{ N_MSG_GUI_MENU_TOOL_TIP_PREV_PAGE,
		"Previous page" },
	{ N_MSG_GUI_MENU_TOOL_TIP_NEXT_PAGE,
		"Next page" },
	{ N_MSG_GUI_MENU_TOOL_TIP_CANCEL,
		"Back menu" },
	{ N_MSG_GUI_MENU_TOOL_TIP_CANCEL_ALL,
		"Close menu" },
	{ N_MSG_GUI_MENU_TOOL_TIP_PAGE_N,
		"Number of pages" },

	{ N_MSG_GUI_INPUT_STRING_CANCEL,
		"Cancel" },
	{ N_MSG_GUI_INPUT_STRING_OK,
		"OK" },

/* GUI end */

	{ N_MSG_MBR_DATA_SEL,
		"*%s*" },
	{ N_MSG_MBR_DATA_NOT_SEL,
		" %s " },

	{ N_MSG_GETS_MBR_NAME,
		"Please input the name. (within %ld characters)" },
	{ N_MSG_GETS_MBR_FACE,
		"Please input the emoticon by one character." },
	{ N_MSG_GETS_RACE_NAME,
		"Please input the race name. (within %ld characters)" },

	{ N_MSG_RACE_STR_PUREBRED,
		"%s\'s pureblood" },
	{ N_MSG_RACE_STR_MIXED,
		"%s & %s" },

	{ N_MSG_MBR_DATA_NAME_TTL,
		"Name     : " },
	{ N_MSG_MBR_DATA_FACE_TTL,
		"Face     : " },
	{ N_MSG_MBR_DATA_RACE_STR_TTL,
		"Race     : " },
	{ N_MSG_MBR_DATA_RACE_NAME_TTL,
		"Race Name: " },
	{ N_MSG_MBR_DATA_SEX_TTL,
		"Sex      : " },

	{ N_MSG_MBR_DATA_HP_VAL,
		"HP: " },
	{ N_MSG_MBR_DATA_MP_VAL,
		"MP: " },

	{ N_MSG_MBR_DATA_VAL_TTL,
		"                  Dir. (Ind.)" },
	{ N_MSG_MBR_DATA_HIT_TTL,
		"Hit             : " },
	{ N_MSG_MBR_DATA_HIT,
		"%s%4ld (%4ld)" },
	{ N_MSG_MBR_DATA_WPN_CRTCL_TTL,
		"Critical Hit    : " },
	{ N_MSG_MBR_DATA_WPN_CRTCL,
		"%s%4ld (%4ld)" },
	{ N_MSG_MBR_DATA_DAM_TTL,
		"Damage          : " },
	{ N_MSG_MBR_DATA_DAM,
		"%s%4ld (%4ld)" },
	{ N_MSG_MBR_DATA_DEF_TTL,
		"Defense         : " },
	{ N_MSG_MBR_DATA_DEF,
		"%s%4ld" },
	{ N_MSG_MBR_DATA_ARMOR_CRTCL_TTL,
		"Critical Defense: " },
	{ N_MSG_MBR_DATA_ARMOR_CRTCL,
		"%s%4ld" },
	{ N_MSG_MBR_DATA_AC_TTL,
		"Armor class     : " },
	{ N_MSG_MBR_DATA_AC,
		"%s%4ld" },

	{ N_MSG_MBR_DATA_GOLD_TTL,
		STR_GOLD ": " },
	{ N_MSG_CALENDAR,
		"%4ld/%02ld/%02ld (%sday) %02ld:%02ld" },

	{ N_MSG_MBR_DATA_STAT_TTL,
		"Status:" },
	{ N_MSG_MBR_DATA_STAT_NULL,
		"[               ]" },
	{ N_MSG_MBR_DATA_STAT_DEAD,
		"[Dead           ]" },
	{ N_MSG_MBR_DATA_STAT_STONE,
		"[Stone          ]" },
	{ N_MSG_MBR_DATA_STAT_POISON,
		"[Poison         ]" },
	{ N_MSG_MBR_DATA_STAT_PARALYZE,
		"[Paralyze       ]" },
	{ N_MSG_MBR_DATA_STAT_CONFUSION,
		"[Confusion      ]" },
	{ N_MSG_MBR_DATA_STAT_BLIND,
		"[Blind          ]" },
	{ N_MSG_MBR_DATA_STAT_SLEEP,
		"[Sleep          ]" },
	{ N_MSG_MBR_DATA_STAT_SILENCE,
		"[Silence        ]" },
	{ N_MSG_MBR_DATA_STAT_CAUGHT,
		"[Caught         ]" },
	{ N_MSG_MBR_DATA_STAT_FEAR,
		"[Fear           ]" },
	{ N_MSG_MBR_DATA_STAT_HALLUCINATION,
		"[Hallucination  ]" },
	{ N_MSG_MBR_DATA_STAT_CHARM,
		"[Charm          ]" },
	{ N_MSG_MBR_DATA_STAT_FLY,
		"[Fly            ]" },
	{ N_MSG_MBR_DATA_STAT_VANISH,
		"[Vanish         ]" },
	{ N_MSG_MBR_DATA_STAT_IRON_BODY,
		"[Iron body      ]" },
	{ N_MSG_MBR_DATA_STAT_PASSWALL,
		"[Passwall       ]" },
	{ N_MSG_MBR_DATA_STAT_SENSE_INVISIBLE,
		"[Sense Invisible]" },
	{ N_MSG_MBR_DATA_STAT_HUNGRY,
		"[Hungry         ]" },
	{ N_MSG_MBR_DATA_STAT_STARVATION,
		"[Starvation     ]" },
	{ N_MSG_MBR_DATA_STAT_FAINT,
		"[Faint          ]" },
	{ N_MSG_MBR_DATA_STAT_DRUNK,
		"[Drunk          ]" },

	{ N_MSG_FMT_MBR_DATA_STORE_LIGHT,
		"%s : %ld" },
	{ N_MSG_MBR_DATA_STORE_LIGHT_TTL,
		"Store light" },

	{ N_MSG_MBR_DATA_LEV_TTL,
		"Level" },
	{ N_MSG_MBR_DATA_EXP_TTL,
		"Exp." },
	{ N_MSG_MBR_DATA_NEED_EXP_TTL,
		"Next Exp." },

	{ N_MSG_FMT_MBR_DATA_ABL,
		"%5s%s%4ld %-4s %10ld/%10ld%s" },
	{ N_MSG_FMT_MBR_DATA_VALUE,
		"%4ld" },
	{ N_MSG_FMT_MBR_DATA_ADD_LEV,
		"(%+2ld)" },
	{ N_MSG_MBR_DATA_HP_TTL,
		"HP : " },
	{ N_MSG_MBR_DATA_MP_TTL,
		"MP : " },
	{ N_MSG_MBR_DATA_DEX_TTL,
		"DEX: " },
	{ N_MSG_MBR_DATA_STR_TTL,
		"STR: " },
	{ N_MSG_MBR_DATA_AGI_TTL,
		"AGI: " },
	{ N_MSG_MBR_DATA_INT_TTL,
		"INT: " },
	{ N_MSG_MBR_DATA_WIS_TTL,
		"WIS: " },
	{ N_MSG_MBR_DATA_CHA_TTL,
		"CHA: " },
	{ N_MSG_MBR_DATA_FIG_TTL,
		"FIG: " },
	{ N_MSG_MBR_DATA_MON_TTL,
		"MON: " },
	{ N_MSG_MBR_DATA_HUN_TTL,
		"HUN: " },
	{ N_MSG_MBR_DATA_THI_TTL,
		"THI: " },
	{ N_MSG_MBR_DATA_MAG_TTL,
		"MAG: " },
	{ N_MSG_MBR_DATA_SOR_TTL,
		"SOR: " },
	{ N_MSG_MBR_DATA_ENC_TTL,
		"ENC: " },
	{ N_MSG_MBR_DATA_SUM_TTL,
		"SUM: " },
	{ N_MSG_MBR_DATA_PRI_TTL,
		"PRI: " },
	{ N_MSG_MBR_DATA_SHA_TTL,
		"SHA: " },
	{ N_MSG_MBR_DATA_BAR_TTL,
		"BAR: " },
	{ N_MSG_MBR_DATA_NIN_TTL,
		"NIN: " },

	{ N_MSG_MBR_DATA_RESI_TTL,
		"-resist-" },
	{ N_MSG_MBR_DATA_RESI_TTL_LAWFUL,
		"Lawful" },
	{ N_MSG_MBR_DATA_RESI_TTL_NEUTRAL_1,
		"Neutral" },
	{ N_MSG_MBR_DATA_RESI_TTL_CHAOTIC,
		"Chaotic" },
	{ N_MSG_MBR_DATA_RESI_TTL_GOOD,
		"Good" },
	{ N_MSG_MBR_DATA_RESI_TTL_NEUTRAL_2,
		"Neutral" },
	{ N_MSG_MBR_DATA_RESI_TTL_EVIL,
		"Evil" },

	{ N_MSG_FMT_MBR_DATA_RESI,
		"%s%4ld" },
	{ N_MSG_MBR_DATA_RESI_KNOC_TTL,
		"KNOC:" },
	{ N_MSG_MBR_DATA_RESI_SLAS_TTL,
		"SLAS:" },
	{ N_MSG_MBR_DATA_RESI_STIN_TTL,
		"STIN:" },
	{ N_MSG_MBR_DATA_RESI_HEAT_TTL,
		"FIRE:" },
	{ N_MSG_MBR_DATA_RESI_COLD_TTL,
		"WATE:" },
	{ N_MSG_MBR_DATA_RESI_MIND_TTL,
		"AIR :" },
	{ N_MSG_MBR_DATA_RESI_ACID_TTL,
		"EART:" },
	{ N_MSG_MBR_DATA_RESI_ELEC_TTL,
		"LIGH:" },
	{ N_MSG_MBR_DATA_RESI_POIS_TTL,
		"DARK:" },

	{ N_MSG_MBR_DATA_CLASS_TTL,
		"Class: " },
	{ N_MSG_MBR_DATA_CLASS,
		"%s%s" },

	{ N_MSG_MBR_DATA_PREV_MBR,
		"Previous member" },
	{ N_MSG_MBR_DATA_NEXT_MBR,
		"Next member" },
	{ N_MSG_MBR_DATA_PREV_PAGE,
		"Previous page" },
	{ N_MSG_MBR_DATA_NEXT_PAGE,
		"Next page" },

	{ N_MSG_LEV_UP_LEFT_OFF,
		" " },
	{ N_MSG_LEV_UP_RIGHT_OFF,
		" " },
	{ N_MSG_LEV_UP_LEFT_ON,
		"*" },
	{ N_MSG_LEV_UP_RIGHT_ON,
		"*" },

/* edit class begin */

	{ N_MSG_EDIT_CLASS_TTL,
		"%s%3ld%%" },
	{ N_MSG_EDIT_CLASS_ADD_SEL,
		"<+>" },
	{ N_MSG_EDIT_CLASS_ADD_NOT_SEL,
		" + " },
	{ N_MSG_EDIT_CLASS_SUB_SEL,
		"<->" },
	{ N_MSG_EDIT_CLASS_SUB_NOT_SEL,
		" - " },
	{ N_MSG_EDIT_CLASS_TOTAL,
		"TOTAL: %3ld" },
	{ N_MSG_EDIT_CLASS_NAME,
		"%s%-*s" },
	{ N_MSG_EDIT_CLASS_PREV,
		"Previous class" },
	{ N_MSG_EDIT_CLASS_NEXT,
		"Next class" },

/* edit class end */

/* edit pet name begin */

	{ N_MSG_PET_DATA_NAME_TTL,
		"Please input the name: " },

/* edit pet name end */

/* words begin */

	{ N_MSG_OKURI_00,
		"(" },
	{ N_MSG_OKURI_01,
		"[" },
	{ N_MSG_OKURI_02,
		"{" },
	{ N_MSG_OKURI_03,
		"" },
	{ N_MSG_OKURI_04,
		"" },
	{ N_MSG_OKURI_05,
		"" },
	{ N_MSG_OKURI_06,
		"" },
	{ N_MSG_OKURI_07,
		"" },
	{ N_MSG_OKURI_08,
		"" },
	{ N_MSG_OKURI_09,
		"" },
	{ N_MSG_OKURI_10,
		"" },
	{ N_MSG_OKURI_11,
		"" },
	{ N_MSG_OKURI_12,
		"" },
	{ N_MSG_OKURI_13,
		"" },
	{ N_MSG_OKURI_14,
		"" },
	{ N_MSG_OKURI_15,
		"" },
	{ N_MSG_OKURI_16,
		"" },
	{ N_MSG_OKURI_17,
		"" },
	{ N_MSG_OKURI_18,
		"" },
	{ N_MSG_OKURI_19,
		"" },
	{ N_MSG_OKURI_20,
		"" },
	{ N_MSG_OKURI_21,
		"" },
	{ N_MSG_OKURI_22,
		"" },
	{ N_MSG_OKURI_23,
		"" },
	{ N_MSG_OKURI_24,
		"" },
	{ N_MSG_OKURI_25,
		"" },
	{ N_MSG_OKURI_26,
		"" },
	{ N_MSG_OKURI_27,
		"" },
	{ N_MSG_OKURI_28,
		"" },
	{ N_MSG_OKURI_29,
		"" },

	{ N_MSG_KIN_SOKU_00,
		")" },
	{ N_MSG_KIN_SOKU_01,
		"]" },
	{ N_MSG_KIN_SOKU_02,
		"}" },
	{ N_MSG_KIN_SOKU_03,
		"" },
	{ N_MSG_KIN_SOKU_04,
		"" },
	{ N_MSG_KIN_SOKU_05,
		"," },
	{ N_MSG_KIN_SOKU_06,
		"." },
	{ N_MSG_KIN_SOKU_07,
		"!" },
	{ N_MSG_KIN_SOKU_08,
		"?" },
	{ N_MSG_KIN_SOKU_09,
		"" },
	{ N_MSG_KIN_SOKU_10,
		"" },
	{ N_MSG_KIN_SOKU_11,
		"" },
	{ N_MSG_KIN_SOKU_12,
		"" },
	{ N_MSG_KIN_SOKU_13,
		"" },
	{ N_MSG_KIN_SOKU_14,
		"" },
	{ N_MSG_KIN_SOKU_15,
		"" },
	{ N_MSG_KIN_SOKU_16,
		"" },
	{ N_MSG_KIN_SOKU_17,
		"" },
	{ N_MSG_KIN_SOKU_18,
		"" },
	{ N_MSG_KIN_SOKU_19,
		"" },
	{ N_MSG_KIN_SOKU_20,
		"" },
	{ N_MSG_KIN_SOKU_21,
		"" },
	{ N_MSG_KIN_SOKU_22,
		"" },
	{ N_MSG_KIN_SOKU_23,
		"" },
	{ N_MSG_KIN_SOKU_24,
		"" },
	{ N_MSG_KIN_SOKU_25,
		"" },
	{ N_MSG_KIN_SOKU_26,
		"" },
	{ N_MSG_KIN_SOKU_27,
		"" },
	{ N_MSG_KIN_SOKU_28,
		"" },
	{ N_MSG_KIN_SOKU_29,
		"" },

	{ N_MSG_WORDS_BEGIN,
		"\"" },
	{ N_MSG_WORDS_END,
		"\"" },
	{ N_MSG_WORDS_NEXT,
		"  " },

	{ N_MSG_WORDS_REQUEST_CONTRACT_FEMALE,
		"We firmly request this to you."
	},
	{ N_MSG_WORDS_REQUEST_CONTRACT_MALE,
		"We firmly request this to you."
	},
	{ N_MSG_WORDS_REQUEST_CANCEL_FEMALE,
		"Huh. You are hopeless. Don't fail in next time."
	},
	{ N_MSG_WORDS_REQUEST_CANCEL_MALE,
		"Shit. You are hopeless. Don't fail in next time."
	},
	{ N_MSG_WORDS_REQUEST_CLOSE_1_FEMALE,
		"I think that you achieved the request. "
		"Receive this reward."
	},
	{ N_MSG_WORDS_REQUEST_CLOSE_1_MALE,
		"I think that you achieved the request. "
		"Receive this reward."
	},
	{ N_MSG_WORDS_REQUEST_CLOSE_2_FEMALE,
		"I will request it to you next time too."
	},
	{ N_MSG_WORDS_REQUEST_CLOSE_2_MALE,
		"I will request it to you next time too."
	},

/* REQUEST_TAME_MNSTR */
	{ N_MSG_WORDS_REQUEST_TAME_MNSTR_FIND_FEMALE,
		"I like that kitty."
	},
	{ N_MSG_WORDS_REQUEST_TAME_MNSTR_FIND_MALE,
		"I like that kitty."
	},
	{ N_MSG_WORDS_REQUEST_TAME_MNSTR_JOIN_FEMALE,
		"Tame %s "
	},
	{ N_MSG_WORDS_REQUEST_TAME_MNSTR_JOIN_MALE,
		"Tame %s "
	},
/* REQUEST_RESCUE */
	{ N_MSG_WORDS_REQUEST_RESCUE_FIND_FEMALE,
		"We came here to help you. You are already safe."
	},
	{ N_MSG_WORDS_REQUEST_RESCUE_FIND_MALE,
		"We came here to help you. You are already safe."
	},
	{ N_MSG_WORDS_REQUEST_RESCUE_JOIN_FEMALE,
		"I am %s. Did you come here to help me? "
		"It is good! I thought that I die."
	},
	{ N_MSG_WORDS_REQUEST_RESCUE_JOIN_MALE,
		"I am %s. Did you come here to help me? "
		"It is good! I thought that I die."
	},
	{ N_MSG_WORDS_REQUEST_RESCUE_FINISH_FEMALE,
		"I had a narrow escape by you. "
		"Thank you very much."
	},
	{ N_MSG_WORDS_REQUEST_RESCUE_FINISH_MALE,
		"I had a narrow escape by you. "
		"Thank you very much."
	},
	{ N_MSG_WORDS_REQUEST_RESCUE_LIMIT_FEMALE,
		"I cannot endure any longer. I return alone."
	},
	{ N_MSG_WORDS_REQUEST_RESCUE_LIMIT_MALE,
		"I cannot endure any longer. I return alone."
	},
//@@@ begin
/* REQUEST_TOUR_GUIDE */
	{ N_MSG_WORDS_REQUEST_TOUR_GUIDE_JOIN_FEMALE,
		"ޤơ%s Ǥ"
		"δѸڤߤˤƤ衣"
	},
	{ N_MSG_WORDS_REQUEST_TOUR_GUIDE_JOIN_MALE,
		"ޤơ%s Ǥ"
		"δѸڤߤˤƤ衣"
	},
	{ N_MSG_WORDS_REQUEST_TOUR_GUIDE_FINISH_FEMALE,
		"䤡ѳڤä"
		"Τޤߤޤ"
	},
	{ N_MSG_WORDS_REQUEST_TOUR_GUIDE_FINISH_MALE,
		"䤡ѳڤä"
		"Τޤ衣"
	},
	{ N_MSG_WORDS_REQUEST_TOUR_GUIDE_LIMIT_FEMALE,
		"Ĥޤʤ⤦롣"
	},
	{ N_MSG_WORDS_REQUEST_TOUR_GUIDE_LIMIT_MALE,
		"Ĥޤ󡪤⤦衣"
	},
/* REQUEST_REVENGE */
	{ N_MSG_WORDS_REQUEST_REVENGE_JOIN_FEMALE,
		"ޤơ%s Ǥ"
		"Ƥμꤤޤ"
	},
	{ N_MSG_WORDS_REQUEST_REVENGE_JOIN_MALE,
		"ޤơ%s Ǥ"
		"Ƥμꤤޤ"
	},
	{ N_MSG_WORDS_REQUEST_REVENGE_FIND_FEMALE,
		"Ĥ˸Ĥ %s "
		"и礷ʤ",
	},
	{ N_MSG_WORDS_REQUEST_REVENGE_FIND_MALE,
		"Ĥ˸Ĥ %s "
		"и礷",
	},
	{ N_MSG_WORDS_REQUEST_REVENGE_FINISH_FEMALE,
		"ǵƤ̤ޤͭ񤦸¤ޤ"
	},
	{ N_MSG_WORDS_REQUEST_REVENGE_FINISH_MALE,
		"ǵƤ̤ͭ񤦡"
	},
	{ N_MSG_WORDS_REQUEST_REVENGE_LIMIT_FEMALE,
		"⤦빽ǤʬͤǤޤ"
	},
	{ N_MSG_WORDS_REQUEST_REVENGE_LIMIT_MALE,
		"⤦빽ʬͤǤ衣"
	},
/* REQUEST WANTED CRIMINAL */
	{ N_MSG_WORDS_REQUEST_WANTED_CRIMINAL_FIND_FEMALE,
		"ĤĤȿͤ %s ˴ְ㤤ʤ"
	},
	{ N_MSG_WORDS_REQUEST_WANTED_CRIMINAL_FIND_MALE,
		"ĤĤȿͤ %s ˴ְ㤤ʤ"
	},

/* bar */
	{ N_MSG_WORDS_ORDER_MILK_FEMALE,
		"ޤߥ륯Ǥäơդա"
	},
	{ N_MSG_WORDS_ORDER_MILK_MALE,
		"ߥ륯Ȥ衣ϤäϤϡ"
	},

/* inn */
	{ N_MSG_WORDS_DISCOUNT_DAY_FEMALE,
		" %s ǡäƤޤ衣"
	},
	{ N_MSG_WORDS_DISCOUNT_DAY_MALE,
		" %s ǡäƤޤ衣"
	},

/* rumor */
	{ N_MSG_RUMOR_001_FEMALE,
		"֥쥤äǤϡ٤Ȥˤͤ"
		"ñǸ¤ꤢʪȤơϤä͡"
	},
	{ N_MSG_RUMOR_001_MALE,
		"֥쥤äǤϡ٤Ȥˤͤ"
		"ñǸ¤ꤢʪȤơϤä"
	},
	{ N_MSG_RUMOR_002_FEMALE,
		"λƮǽԤβͤˤʤäЯǡ"
		"Ͼ͡"
	},
	{ N_MSG_RUMOR_002_MALE,
		"λƮǽԤβͤˤʤäЯǡ"
		"Ͼʡ"
	},
	{ N_MSG_RUMOR_003_FEMALE,
		"ǶȺԤµܤ򱣤ȤѤЯ"
		"Ƥ餷͡"
	},
	{ N_MSG_RUMOR_003_MALE,
		"ǶȺԤµܤ򱣤ȤѤЯ"
		"Ƥ餷ʡ"
	},
	{ N_MSG_RUMOR_004_FEMALE,
		"ζβȤǻƸޤ줿Τǡ"
		"äƤͤõƤ뤽衣"
	},
	{ N_MSG_RUMOR_004_MALE,
		"ζβȤǻƸޤ줿Τǡ"
		"äƤͤõƤ뤽"
	},
	{ N_MSG_RUMOR_005_FEMALE,
		"ζβȤǲİǭޤ줿Τǡ"
		"äƤͤõƤ뤽衣"
	},
	{ N_MSG_RUMOR_005_MALE,
		"ζβȤǲİǭޤ줿Τǡ"
		"äƤͤõƤ뤽"
	},
	{ N_MSG_RUMOR_006_FEMALE,
		"ĤٰʼԤϻϹˤ뤱ɡ"
		"Ϲֿͤˤʤ뤽衣"
	},
	{ N_MSG_RUMOR_006_MALE,
		"ĤٰʼԤϻϹˤ뤬"
		"Ϲֿͤˤʤ뤽"
	},
	{ N_MSG_RUMOR_007_FEMALE,
		"ȤΤϵǯ˴ʤäƤޤäɡ"
		"ǤϷǤ֤餻ʤơġ"
		"̿ˤϾƤʤäƻ顣"
	},
	{ N_MSG_RUMOR_007_MALE,
		"ȤΤäϵǯ˴ʤäޤä"
		"ǤϷǤ֤餻ʤƤʡġ"
		"̿ˤϾƤʤäƤä"
	},
	{ N_MSG_RUMOR_008_FEMALE,
		"ɤʤˤǤ˸Ǥ"
		"ɬ餫ˡ§ƯƤơ"
		"̣ͳͭȻϻפ"
	},
	{ N_MSG_RUMOR_008_MALE,
		"ɤʤˤǤ˸Ǥ"
		"ɬ餫ˡ§ƯƤơ"
		"̣ͳͭȲϻפ衣"
	},
//@@@ end
/* bath */
	{ N_MSG_WORDS_TAKE_BATH_FAMALE,
		"Hoo"
	},
	{ N_MSG_WORDS_TAKE_BATH_MALE,
		"Hooaa"
	},
	{ N_MSG_WORDS_CHR_IS_MOLESTED_FAMALE,
		"NO!! SOMEONE IS PEEPING ME!"
	},
	{ N_MSG_WORDS_CHR_IS_MOLESTED_MALE,
		"Why do you peep me?"
	},

/* words end */

/* NPC name begin */

	{ N_MSG_NPC_NAME_YOU_ANATA,
		"you" },
	{ N_MSG_NPC_NAME_YOU_ANATARA,
		"you" },
	{ N_MSG_NPC_NAME_YOU_KIMI,
		"you" },
	{ N_MSG_NPC_NAME_YOU_KIMIRA,
		"you" },
	{ N_MSG_NPC_NAME_YOU_OMAE,
		"you" },
	{ N_MSG_NPC_NAME_YOU_OMAERA,
		"you" },

	{ N_MSG_NPC_NAME_FAMILY,
		"family" },
	{ N_MSG_NPC_NAME_GRAND_MOTHER,
		"grand mother" },
	{ N_MSG_NPC_NAME_GRAND_FATHER,
		"grand father" },
	{ N_MSG_NPC_NAME_MOTHER,
		"mother" },
	{ N_MSG_NPC_NAME_FATHER,
		"father" },
	{ N_MSG_NPC_NAME_OLDER_SISTER,
		"older sister" },
	{ N_MSG_NPC_NAME_OLDER_BROTHER,
		"older brother" },
	{ N_MSG_NPC_NAME_YOUNGER_SISTER,
		"younger sister" },
	{ N_MSG_NPC_NAME_YOUNGER_BROTHER,
		"younger brother" },
	{ N_MSG_NPC_NAME_DAUGHTER,
		"daughter" },
	{ N_MSG_NPC_NAME_SON,
		"son" },
	{ N_MSG_NPC_NAME_WIFE,
		"wife" },
	{ N_MSG_NPC_NAME_HUSBAND,
		"husband" },
	{ N_MSG_NPC_NAME_GIRL_FRIEND,
		"girl friend" },
	{ N_MSG_NPC_NAME_BOY_FRIEND,
		"boy friend" },

	{ N_MSG_NPC_NAME_BAR_MASTER,
		"Master in bar" },
	{ N_MSG_NPC_NAME_BAR_CUSTOMER,
		"Guest in bar" },
	{ N_MSG_NPC_NAME_INN_LANDLORD,
		"Innkeeper" },

/* NPC name female begin */

	{ N_MSG_NPC_NAME_ABIGAIL,
		"Abigail" },
	{ N_MSG_NPC_NAME_ADA,
		"Ada" },
	{ N_MSG_NPC_NAME_ADELA,
		"Adela" },
	{ N_MSG_NPC_NAME_ADELAIDE,
		"Adelaide" },
	{ N_MSG_NPC_NAME_ADELE,
		"Adele" },
	{ N_MSG_NPC_NAME_ADELINE,
		"Adeline" },
	{ N_MSG_NPC_NAME_AGATHA,
		"Agatha" },
	{ N_MSG_NPC_NAME_AGGIE,
		"Aggie" },
	{ N_MSG_NPC_NAME_AGNES,
		"Agnes" },
	{ N_MSG_NPC_NAME_ALBERTA,
		"Alberta" },
	{ N_MSG_NPC_NAME_ALDA,
		"Alda" },
	{ N_MSG_NPC_NAME_ALETHEA,
		"Alethea" },
	{ N_MSG_NPC_NAME_ALEXANDRA,
		"Alexandra" },
	{ N_MSG_NPC_NAME_ALICE,
		"Alice" },
	{ N_MSG_NPC_NAME_ALISON,
		"Alison" },
	{ N_MSG_NPC_NAME_ALMA,
		"Alma" },
	{ N_MSG_NPC_NAME_ALPHA,
		"Alpha" },
	{ N_MSG_NPC_NAME_ALTHEA,
		"Althea" },
	{ N_MSG_NPC_NAME_AMANDA,
		"Amanda" },
	{ N_MSG_NPC_NAME_AMELIA,
		"Amelia" },
	{ N_MSG_NPC_NAME_AMY,
		"Amy" },
	{ N_MSG_NPC_NAME_ANABEL,
		"Anabel" },
	{ N_MSG_NPC_NAME_ANASTASIA,
		"Anastasia" },
	{ N_MSG_NPC_NAME_ANGELA,
		"Angela" },
	{ N_MSG_NPC_NAME_ANGELIA,
		"Angelia" },
	{ N_MSG_NPC_NAME_ANGELICA,
		"Angelica" },
	{ N_MSG_NPC_NAME_ANGELINA,
		"Angelina" },
	{ N_MSG_NPC_NAME_ANGELINE,
		"Angeline" },
	{ N_MSG_NPC_NAME_ANITA,
		"Anita" },
	{ N_MSG_NPC_NAME_ANN,
		"Ann" },
	{ N_MSG_NPC_NAME_ANNA,
		"Anna" },
	{ N_MSG_NPC_NAME_ANNABELLA,
		"Annabella" },
	{ N_MSG_NPC_NAME_ANNIE,
		"Annie" },
	{ N_MSG_NPC_NAME_ANTOINETTE,
		"Antoinette" },
	{ N_MSG_NPC_NAME_ANTONIA,
		"Antonia" },
	{ N_MSG_NPC_NAME_APOLLONIA,
		"Apollonia" },
	{ N_MSG_NPC_NAME_APRIL,
		"April" },
	{ N_MSG_NPC_NAME_ARABELLA,
		"Arabella" },
	{ N_MSG_NPC_NAME_ARLENE,
		"Arlene" },
	{ N_MSG_NPC_NAME_ARTEMISIA,
		"Artemisia" },
	{ N_MSG_NPC_NAME_AUDREY,
		"Audrey" },
	{ N_MSG_NPC_NAME_AUGUSTA,
		"Augusta" },
	{ N_MSG_NPC_NAME_AURELIA,
		"Aurelia" },
	{ N_MSG_NPC_NAME_AVERIL,
		"Averil" },
	{ N_MSG_NPC_NAME_AZALEA,
		"Azalea" },
	{ N_MSG_NPC_NAME_BAB,
		"Bab" },
	{ N_MSG_NPC_NAME_BABETTE,
		"Babette" },
	{ N_MSG_NPC_NAME_BARBARA,
		"Barbara" },
	{ N_MSG_NPC_NAME_BEATRICE,
		"Beatrice" },
	{ N_MSG_NPC_NAME_BEATRIX,
		"Beatrix" },
	{ N_MSG_NPC_NAME_BECKY,
		"Becky" },
	{ N_MSG_NPC_NAME_BELINDA,
		"Belinda" },
	{ N_MSG_NPC_NAME_BELL,
		"Bell" },
	{ N_MSG_NPC_NAME_BELLA,
		"Bella" },
	{ N_MSG_NPC_NAME_BERNICE,
		"Bernice" },
	{ N_MSG_NPC_NAME_BERTHA,
		"Bertha" },
	{ N_MSG_NPC_NAME_BERYL,
		"Beryl" },
	{ N_MSG_NPC_NAME_BETTINA,
		"Bettina" },
	{ N_MSG_NPC_NAME_BIANCA,
		"Bianca" },
	{ N_MSG_NPC_NAME_BLANCHE,
		"Blanche" },
	{ N_MSG_NPC_NAME_BONNIE,
		"Bonnie" },
	{ N_MSG_NPC_NAME_BRENDA,
		"Brenda" },
	{ N_MSG_NPC_NAME_BRIDGET,
		"Bridget" },
	{ N_MSG_NPC_NAME_CAMILLA,
		"Camilla" },
	{ N_MSG_NPC_NAME_CANDICE,
		"Candice" },
	{ N_MSG_NPC_NAME_CARMELLA,
		"Carmella" },
	{ N_MSG_NPC_NAME_CAROLINA,
		"Carolina" },
	{ N_MSG_NPC_NAME_CAROLINE,
		"Caroline" },
	{ N_MSG_NPC_NAME_CATHERINE,
		"Catherine" },
	{ N_MSG_NPC_NAME_CECILIA,
		"Cecilia" },
	{ N_MSG_NPC_NAME_CECILY,
		"Cecily" },
	{ N_MSG_NPC_NAME_CELESTE,
		"Celeste" },
	{ N_MSG_NPC_NAME_CELIA,
		"Celia" },
	{ N_MSG_NPC_NAME_CHARITY,
		"Charity" },
	{ N_MSG_NPC_NAME_CHARLEEN,
		"Charleen" },
	{ N_MSG_NPC_NAME_CHARLOTTE,
		"Charlotte" },
	{ N_MSG_NPC_NAME_CHARMIAN,
		"Charmian" },
	{ N_MSG_NPC_NAME_CHERE,
		"Chere" },
	{ N_MSG_NPC_NAME_CHERRY,
		"Cherry" },
	{ N_MSG_NPC_NAME_CHERYL,
		"Cheryl" },
	{ N_MSG_NPC_NAME_CHLOE,
		"Chloe" },
	{ N_MSG_NPC_NAME_CHRISTIANA,
		"Christiana" },
	{ N_MSG_NPC_NAME_CHRISTINE,
		"Christine" },
	{ N_MSG_NPC_NAME_CINDY,
		"Cindy" },
	{ N_MSG_NPC_NAME_CLAIRE,
		"Claire" },
	{ N_MSG_NPC_NAME_CLARA,
		"Clara" },
	{ N_MSG_NPC_NAME_CLARISSA,
		"Clarissa" },
	{ N_MSG_NPC_NAME_CLAUDIA,
		"Claudia" },
	{ N_MSG_NPC_NAME_COLLEEN,
		"Colleen" },
	{ N_MSG_NPC_NAME_CONNIE,
		"Connie" },
	{ N_MSG_NPC_NAME_CONSTANCE,
		"Constance" },
	{ N_MSG_NPC_NAME_CONSUELO,
		"Consuelo" },
	{ N_MSG_NPC_NAME_CORA,
		"Cora" },
	{ N_MSG_NPC_NAME_CORDELIA,
		"Cordelia" },
	{ N_MSG_NPC_NAME_CORINNA,
		"Corinna" },
	{ N_MSG_NPC_NAME_CORINNE,
		"Corinne" },
	{ N_MSG_NPC_NAME_CORNELIA,
		"Cornelia" },
	{ N_MSG_NPC_NAME_CYNTHIA,
		"Cynthia" },
	{ N_MSG_NPC_NAME_DAISY,
		"Daisy" },
	{ N_MSG_NPC_NAME_DAMARIS,
		"Damaris" },
	{ N_MSG_NPC_NAME_DANA,
		"Dana" },
	{ N_MSG_NPC_NAME_DAPHNE,
		"Daphne" },
	{ N_MSG_NPC_NAME_DARLA,
		"Darla" },
	{ N_MSG_NPC_NAME_DARLENE,
		"Darlene" },
	{ N_MSG_NPC_NAME_DARYL,
		"Daryl" },
	{ N_MSG_NPC_NAME_DAWN,
		"Dawn" },
	{ N_MSG_NPC_NAME_DEANNA,
		"Deanna" },
	{ N_MSG_NPC_NAME_DEBORAH,
		"Deborah" },
	{ N_MSG_NPC_NAME_DEIRDRE,
		"Deirdre" },
	{ N_MSG_NPC_NAME_DELIA,
		"Delia" },
	{ N_MSG_NPC_NAME_DELLA,
		"Della" },
	{ N_MSG_NPC_NAME_DELORIS,
		"Deloris" },
	{ N_MSG_NPC_NAME_DENISE,
		"Denise" },
	{ N_MSG_NPC_NAME_DIANA,
		"Diana" },
	{ N_MSG_NPC_NAME_DIANE,
		"Diane" },
	{ N_MSG_NPC_NAME_DINAH,
		"Dinah" },
	{ N_MSG_NPC_NAME_DIXIE,
		"Dixie" },
	{ N_MSG_NPC_NAME_DOLL,
		"Doll" },
	{ N_MSG_NPC_NAME_DOLLY,
		"Dolly" },
	{ N_MSG_NPC_NAME_DONNA,
		"Donna" },
	{ N_MSG_NPC_NAME_DORA,
		"Dora" },
	{ N_MSG_NPC_NAME_DOREEN,
		"Doreen" },
	{ N_MSG_NPC_NAME_DORIS,
		"Doris" },
	{ N_MSG_NPC_NAME_DOROTHY,
		"Dorothy" },
	{ N_MSG_NPC_NAME_DOTTY,
		"Dotty" },
	{ N_MSG_NPC_NAME_DRUSILLA,
		"Drusilla" },
	{ N_MSG_NPC_NAME_DULCIE,
		"Dulcie" },
	{ N_MSG_NPC_NAME_EDITH,
		"Edith" },
	{ N_MSG_NPC_NAME_EDNA,
		"Edna" },
	{ N_MSG_NPC_NAME_EFFIE,
		"Effie" },
	{ N_MSG_NPC_NAME_EILEEN,
		"Eileen" },
	{ N_MSG_NPC_NAME_ELAINE,
		"Elaine" },
	{ N_MSG_NPC_NAME_ELEANOR,
		"Eleanor" },
	{ N_MSG_NPC_NAME_ELEANORA,
		"Eleanora" },
	{ N_MSG_NPC_NAME_ELIZA,
		"Eliza" },
	{ N_MSG_NPC_NAME_ELIZABETH,
		"Elizabeth" },
	{ N_MSG_NPC_NAME_ELLEN,
		"Ellen" },
	{ N_MSG_NPC_NAME_ELMA,
		"Elma" },
	{ N_MSG_NPC_NAME_ELOISE,
		"Eloise" },
	{ N_MSG_NPC_NAME_ELSIE,
		"Elsie" },
	{ N_MSG_NPC_NAME_ELVIRA,
		"Elvira" },
	{ N_MSG_NPC_NAME_EM,
		"Em" },
	{ N_MSG_NPC_NAME_EMANUEL,
		"Emanuel" },
	{ N_MSG_NPC_NAME_EMILY,
		"Emily" },
	{ N_MSG_NPC_NAME_EMMA,
		"Emma" },
	{ N_MSG_NPC_NAME_EMMELINA,
		"Emmelina" },
	{ N_MSG_NPC_NAME_EMMELINE,
		"Emmeline" },
	{ N_MSG_NPC_NAME_EMMY,
		"Emmy" },
	{ N_MSG_NPC_NAME_ENID,
		"Enid" },
	{ N_MSG_NPC_NAME_ENOLA,
		"Enola" },
	{ N_MSG_NPC_NAME_EPPIE,
		"Eppie" },
	{ N_MSG_NPC_NAME_ERICA,
		"Erica" },
	{ N_MSG_NPC_NAME_ERMENTRUDE,
		"Ermentrude" },
	{ N_MSG_NPC_NAME_ERNESTINE,
		"Ernestine" },
	{ N_MSG_NPC_NAME_ESTELLE,
		"Estelle" },
	{ N_MSG_NPC_NAME_ESTHER,
		"Esther" },
	{ N_MSG_NPC_NAME_ETHEL,
		"Ethel" },
	{ N_MSG_NPC_NAME_ETTA,
		"Etta" },
	{ N_MSG_NPC_NAME_EUNICE,
		"Eunice" },
	{ N_MSG_NPC_NAME_EUPHEMIA,
		"Euphemia" },
	{ N_MSG_NPC_NAME_EVA,
		"Eva" },
	{ N_MSG_NPC_NAME_EVADNE,
		"Evadne" },
	{ N_MSG_NPC_NAME_EVANGELINE,
		"Evangeline" },
	{ N_MSG_NPC_NAME_EVE,
		"Eve" },
	{ N_MSG_NPC_NAME_EVELYN,
		"Evelyn" },
	{ N_MSG_NPC_NAME_FAITH,
		"Faith" },
	{ N_MSG_NPC_NAME_FANNIE,
		"Fannie" },
	{ N_MSG_NPC_NAME_FAY,
		"Fay" },
	{ N_MSG_NPC_NAME_FIONA,
		"Fiona" },
	{ N_MSG_NPC_NAME_FLORA,
		"Flora" },
	{ N_MSG_NPC_NAME_FLORENCE,
		"Florence" },
	{ N_MSG_NPC_NAME_FRANCES,
		"Frances" },
	{ N_MSG_NPC_NAME_FRANCINE,
		"Francine" },
	{ N_MSG_NPC_NAME_FREDA,
		"Freda" },
	{ N_MSG_NPC_NAME_GAIL,
		"Gail" },
	{ N_MSG_NPC_NAME_GENEVIEVE,
		"Genevieve" },
	{ N_MSG_NPC_NAME_GEORGIANA,
		"Georgiana" },
	{ N_MSG_NPC_NAME_GEORGIE,
		"Georgie" },
	{ N_MSG_NPC_NAME_GEORGINA,
		"Georgina" },
	{ N_MSG_NPC_NAME_GERALDINE,
		"Geraldine" },
	{ N_MSG_NPC_NAME_GERDA,
		"Gerda" },
	{ N_MSG_NPC_NAME_GERTIE,
		"Gertie" },
	{ N_MSG_NPC_NAME_GERTRUDE,
		"Gertrude" },
	{ N_MSG_NPC_NAME_GILLIAN,
		"Gillian" },
	{ N_MSG_NPC_NAME_GINEVRA,
		"Ginevra" },
	{ N_MSG_NPC_NAME_GLADYS,
		"Gladys" },
	{ N_MSG_NPC_NAME_GLORIA,
		"Gloria" },
	{ N_MSG_NPC_NAME_GLORIANA,
		"Gloriana" },
	{ N_MSG_NPC_NAME_GRACE,
		"Grace" },
	{ N_MSG_NPC_NAME_GRETA,
		"Greta" },
	{ N_MSG_NPC_NAME_GRETCHEN,
		"Gretchen" },
	{ N_MSG_NPC_NAME_GRISELDA,
		"Griselda" },
	{ N_MSG_NPC_NAME_GRIZEL,
		"Grizel" },
	{ N_MSG_NPC_NAME_GUENDOLEN,
		"Guendolen" },
	{ N_MSG_NPC_NAME_GUINEVERE,
		"Guinevere" },
	{ N_MSG_NPC_NAME_GWENEVERE,
		"Gwenevere" },
	{ N_MSG_NPC_NAME_HANNAH,
		"Hannah" },
	{ N_MSG_NPC_NAME_HARRIET,
		"Harriet" },
	{ N_MSG_NPC_NAME_HAZEL,
		"Hazel" },
	{ N_MSG_NPC_NAME_HEATHER,
		"Heather" },
	{ N_MSG_NPC_NAME_HELEN,
		"Helen" },
	{ N_MSG_NPC_NAME_HELOISE,
		"Heloise" },
	{ N_MSG_NPC_NAME_HENRIETTA,
		"Henrietta" },
	{ N_MSG_NPC_NAME_HENRIETTE,
		"Henriette" },
	{ N_MSG_NPC_NAME_HERMIONE,
		"Hermione" },
	{ N_MSG_NPC_NAME_HESTER,
		"Hester" },
	{ N_MSG_NPC_NAME_HETTIE,
		"Hettie" },
	{ N_MSG_NPC_NAME_HILDA,
		"Hilda" },
	{ N_MSG_NPC_NAME_HILDEGARD,
		"Hildegard" },
	{ N_MSG_NPC_NAME_HOLLY,
		"Holly" },
	{ N_MSG_NPC_NAME_HONOR,
		"Honor" },
	{ N_MSG_NPC_NAME_IDA,
		"Ida" },
	{ N_MSG_NPC_NAME_IMOGEN,
		"Imogen" },
	{ N_MSG_NPC_NAME_INA,
		"Ina" },
	{ N_MSG_NPC_NAME_INEZ,
		"Inez" },
	{ N_MSG_NPC_NAME_INGRID,
		"Ingrid" },
	{ N_MSG_NPC_NAME_IONE,
		"Ione" },
	{ N_MSG_NPC_NAME_IRIS,
		"Iris" },
	{ N_MSG_NPC_NAME_IRMA,
		"Irma" },
	{ N_MSG_NPC_NAME_ISABEL,
		"Isabel" },
	{ N_MSG_NPC_NAME_ISADORA,
		"Isadora" },
	{ N_MSG_NPC_NAME_JACQUELINE,
		"Jacqueline" },
	{ N_MSG_NPC_NAME_JAEL,
		"Jael" },
	{ N_MSG_NPC_NAME_JANE,
		"Jane" },
	{ N_MSG_NPC_NAME_JANET,
		"Janet" },
	{ N_MSG_NPC_NAME_JANICE,
		"Janice" },
	{ N_MSG_NPC_NAME_JANIE,
		"Janie" },
	{ N_MSG_NPC_NAME_JASMINE,
		"Jasmine" },
	{ N_MSG_NPC_NAME_JEAN,
		"Jean" },
	{ N_MSG_NPC_NAME_JEMIMA,
		"Jemima" },
	{ N_MSG_NPC_NAME_JENNIFER,
		"Jennifer" },
	{ N_MSG_NPC_NAME_JENNY,
		"Jenny" },
	{ N_MSG_NPC_NAME_JESSAMINE,
		"Jessamine" },
	{ N_MSG_NPC_NAME_JESSICA,
		"Jessica" },
	{ N_MSG_NPC_NAME_JESSIE,
		"Jessie" },
	{ N_MSG_NPC_NAME_JILL,
		"Jill" },
	{ N_MSG_NPC_NAME_JOAN,
		"Joan" },
	{ N_MSG_NPC_NAME_JOANNA,
		"Joanna" },
	{ N_MSG_NPC_NAME_JOHANNA,
		"Johanna" },
	{ N_MSG_NPC_NAME_JOSEPHINE,
		"Josephine" },
	{ N_MSG_NPC_NAME_JOY,
		"Joy" },
	{ N_MSG_NPC_NAME_JOYCE,
		"Joyce" },
	{ N_MSG_NPC_NAME_JUDITH,
		"Judith" },
	{ N_MSG_NPC_NAME_JULIA,
		"Julia" },
	{ N_MSG_NPC_NAME_JULIANA,
		"Juliana" },
	{ N_MSG_NPC_NAME_JULIET,
		"Juliet" },
	{ N_MSG_NPC_NAME_JUNE,
		"June" },
	{ N_MSG_NPC_NAME_JUSTINA,
		"Justina" },
	{ N_MSG_NPC_NAME_JUSTINE,
		"Justine" },
	{ N_MSG_NPC_NAME_KAREN,
		"Karen" },
	{ N_MSG_NPC_NAME_KATE,
		"Kate" },
	{ N_MSG_NPC_NAME_KATHLEEN,
		"Kathleen" },
	{ N_MSG_NPC_NAME_KATHLYN,
		"Kathlyn" },
	{ N_MSG_NPC_NAME_KATHY,
		"Kathy" },
	{ N_MSG_NPC_NAME_KATINA,
		"Katina" },
	{ N_MSG_NPC_NAME_KATRINA,
		"Katrina" },
	{ N_MSG_NPC_NAME_KAY,
		"Kay" },
	{ N_MSG_NPC_NAME_KEZIA,
		"Kezia" },
	{ N_MSG_NPC_NAME_KITTY,
		"Kitty" },
	{ N_MSG_NPC_NAME_LAETITIA,
		"Laetitia" },
	{ N_MSG_NPC_NAME_LAILA,
		"Laila" },
	{ N_MSG_NPC_NAME_LANA,
		"Lana" },
	{ N_MSG_NPC_NAME_LAURA,
		"Laura" },
	{ N_MSG_NPC_NAME_LAUREL,
		"Laurel" },
	{ N_MSG_NPC_NAME_LAUREN,
		"Lauren" },
	{ N_MSG_NPC_NAME_LAVINIA,
		"Lavinia" },
	{ N_MSG_NPC_NAME_LEAH,
		"Leah" },
	{ N_MSG_NPC_NAME_LEILA,
		"Leila" },
	{ N_MSG_NPC_NAME_LENA,
		"Lena" },
	{ N_MSG_NPC_NAME_LENORE,
		"Lenore" },
	{ N_MSG_NPC_NAME_LEONOR,
		"Leonor" },
	{ N_MSG_NPC_NAME_LEONORA,
		"Leonora" },
	{ N_MSG_NPC_NAME_LETITIA,
		"Letitia" },
	{ N_MSG_NPC_NAME_LIB,
		"Lib" },
	{ N_MSG_NPC_NAME_LIBBY,
		"Libby" },
	{ N_MSG_NPC_NAME_LILLIAN,
		"Lillian" },
	{ N_MSG_NPC_NAME_LILY,
		"Lily" },
	{ N_MSG_NPC_NAME_LINDA,
		"Linda" },
	{ N_MSG_NPC_NAME_LISA,
		"Lisa" },
	{ N_MSG_NPC_NAME_LOLA,
		"Lola" },
	{ N_MSG_NPC_NAME_LOLITA,
		"Lolita" },
	{ N_MSG_NPC_NAME_LORETTA,
		"Loretta" },
	{ N_MSG_NPC_NAME_LORNA,
		"Lorna" },
	{ N_MSG_NPC_NAME_LOTTIE,
		"Lottie" },
	{ N_MSG_NPC_NAME_LOUISA,
		"Louisa" },
	{ N_MSG_NPC_NAME_LOUISE,
		"Louise" },
	{ N_MSG_NPC_NAME_LUANA,
		"Luana" },
	{ N_MSG_NPC_NAME_LUCILLE,
		"Lucille" },
	{ N_MSG_NPC_NAME_LUCINDA,
		"Lucinda" },
	{ N_MSG_NPC_NAME_LUCRETIA,
		"Lucretia" },
	{ N_MSG_NPC_NAME_LUCY,
		"Lucy" },
	{ N_MSG_NPC_NAME_LUDMILLA,
		"Ludmilla" },
	{ N_MSG_NPC_NAME_LULU,
		"Lulu" },
	{ N_MSG_NPC_NAME_LYDIA,
		"Lydia" },
	{ N_MSG_NPC_NAME_LYNETTE,
		"Lynette" },
	{ N_MSG_NPC_NAME_MABEL,
		"Mabel" },
	{ N_MSG_NPC_NAME_MADELEINE,
		"Madeleine" },
	{ N_MSG_NPC_NAME_MADELYN,
		"Madelyn" },
	{ N_MSG_NPC_NAME_MAGDALEN,
		"Magdalen" },
	{ N_MSG_NPC_NAME_MAISIE,
		"Maisie" },
	{ N_MSG_NPC_NAME_MAL,
		"Mal" },
	{ N_MSG_NPC_NAME_MALVINA,
		"Malvina" },
	{ N_MSG_NPC_NAME_MARCIA,
		"Marcia" },
	{ N_MSG_NPC_NAME_MARGARET,
		"Margaret" },
	{ N_MSG_NPC_NAME_MARGERY,
		"Margery" },
	{ N_MSG_NPC_NAME_MARGO,
		"Margo" },
	{ N_MSG_NPC_NAME_MARGOT,
		"Margot" },
	{ N_MSG_NPC_NAME_MARIA,
		"Maria" },
	{ N_MSG_NPC_NAME_MARIAN,
		"Marian" },
	{ N_MSG_NPC_NAME_MARIE,
		"Marie" },
	{ N_MSG_NPC_NAME_MARILYN,
		"Marilyn" },
	{ N_MSG_NPC_NAME_MARION,
		"Marion" },
	{ N_MSG_NPC_NAME_MARJORIE,
		"Marjorie" },
	{ N_MSG_NPC_NAME_MARLENE,
		"Marlene" },
	{ N_MSG_NPC_NAME_MARTHA,
		"Martha" },
	{ N_MSG_NPC_NAME_MARTINA,
		"Martina" },
	{ N_MSG_NPC_NAME_MARY,
		"Mary" },
	{ N_MSG_NPC_NAME_MATILDA,
		"Matilda" },
	{ N_MSG_NPC_NAME_MAUD,
		"Maud" },
	{ N_MSG_NPC_NAME_MAUDLIN,
		"Maudlin" },
	{ N_MSG_NPC_NAME_MAUREEN,
		"Maureen" },
	{ N_MSG_NPC_NAME_MAVIS,
		"Mavis" },
	{ N_MSG_NPC_NAME_MAXINE,
		"Maxine" },
	{ N_MSG_NPC_NAME_MAY,
		"May" },
	{ N_MSG_NPC_NAME_MELINDA,
		"Melinda" },
	{ N_MSG_NPC_NAME_MELISSA,
		"Melissa" },
	{ N_MSG_NPC_NAME_MELODY,
		"Melody" },
	{ N_MSG_NPC_NAME_MELVINA,
		"Melvina" },
	{ N_MSG_NPC_NAME_MERCEDES,
		"Mercedes" },
	{ N_MSG_NPC_NAME_MERCY,
		"Mercy" },
	{ N_MSG_NPC_NAME_MERIEL,
		"Meriel" },
	{ N_MSG_NPC_NAME_MICHELLE,
		"Michelle" },
	{ N_MSG_NPC_NAME_MILDRED,
		"Mildred" },
	{ N_MSG_NPC_NAME_MILLICENT,
		"Millicent" },
	{ N_MSG_NPC_NAME_MINNIE,
		"Minnie" },
	{ N_MSG_NPC_NAME_MIRABEL,
		"Mirabel" },
	{ N_MSG_NPC_NAME_MIRANDA,
		"Miranda" },
	{ N_MSG_NPC_NAME_MIRIAM,
		"Miriam" },
	{ N_MSG_NPC_NAME_MOIRA,
		"Moira" },
	{ N_MSG_NPC_NAME_MOLLY,
		"Molly" },
	{ N_MSG_NPC_NAME_MONA,
		"Mona" },
	{ N_MSG_NPC_NAME_MONICA,
		"Monica" },
	{ N_MSG_NPC_NAME_MURIEL,
		"Muriel" },
	{ N_MSG_NPC_NAME_MYRA,
		"Myra" },
	{ N_MSG_NPC_NAME_MYRTLE,
		"Myrtle" },
	{ N_MSG_NPC_NAME_NADINE,
		"Nadine" },
	{ N_MSG_NPC_NAME_NAN,
		"Nan" },
	{ N_MSG_NPC_NAME_NANCY,
		"Nancy" },
	{ N_MSG_NPC_NAME_NATALIA,
		"Natalia" },
	{ N_MSG_NPC_NAME_NATALIE,
		"Natalie" },
	{ N_MSG_NPC_NAME_NATASHA,
		"Natasha" },
	{ N_MSG_NPC_NAME_NELLIE,
		"Nellie" },
	{ N_MSG_NPC_NAME_NINA,
		"Nina" },
	{ N_MSG_NPC_NAME_NORA,
		"Nora" },
	{ N_MSG_NPC_NAME_NOREEN,
		"Noreen" },
	{ N_MSG_NPC_NAME_NORMA,
		"Norma" },
	{ N_MSG_NPC_NAME_OLIVE,
		"Olive" },
	{ N_MSG_NPC_NAME_OLIVIA,
		"Olivia" },
	{ N_MSG_NPC_NAME_OLYMPIA,
		"Olympia" },
	{ N_MSG_NPC_NAME_OPHELIA,
		"Ophelia" },
	{ N_MSG_NPC_NAME_ORIANA,
		"Oriana" },
	{ N_MSG_NPC_NAME_PAMELA,
		"Pamela" },
	{ N_MSG_NPC_NAME_PANSY,
		"Pansy" },
	{ N_MSG_NPC_NAME_PATRICIA,
		"Patricia" },
	{ N_MSG_NPC_NAME_PATSY,
		"Patsy" },
	{ N_MSG_NPC_NAME_PATTY,
		"Patty" },
	{ N_MSG_NPC_NAME_PEARL,
		"Pearl" },
	{ N_MSG_NPC_NAME_PENELOPE,
		"Penelope" },
	{ N_MSG_NPC_NAME_PERSIS,
		"Persis" },
	{ N_MSG_NPC_NAME_PHILIPPA,
		"Philippa" },
	{ N_MSG_NPC_NAME_PHOEBE,
		"Phoebe" },
	{ N_MSG_NPC_NAME_PHYLLIS,
		"Phyllis" },
	{ N_MSG_NPC_NAME_POLL,
		"Poll" },
	{ N_MSG_NPC_NAME_POLLY,
		"Polly" },
	{ N_MSG_NPC_NAME_PRISCILLA,
		"Priscilla" },
	{ N_MSG_NPC_NAME_PRISSY,
		"Prissy" },
	{ N_MSG_NPC_NAME_RACHEL,
		"Rachel" },
	{ N_MSG_NPC_NAME_RACHELLE,
		"Rachelle" },
	{ N_MSG_NPC_NAME_RAMONA,
		"Ramona" },
	{ N_MSG_NPC_NAME_REBECCA,
		"Rebecca" },
	{ N_MSG_NPC_NAME_REGINA,
		"Regina" },
	{ N_MSG_NPC_NAME_RHODA,
		"Rhoda" },
	{ N_MSG_NPC_NAME_RITA,
		"Rita" },
	{ N_MSG_NPC_NAME_ROBERTA,
		"Roberta" },
	{ N_MSG_NPC_NAME_ROMY,
		"Romy" },
	{ N_MSG_NPC_NAME_ROSE,
		"Rose" },
	{ N_MSG_NPC_NAME_ROSEMARY,
		"Rosemary" },
	{ N_MSG_NPC_NAME_ROWENA,
		"Rowena" },
	{ N_MSG_NPC_NAME_RUBY,
		"Ruby" },
	{ N_MSG_NPC_NAME_RUTH,
		"Ruth" },
	{ N_MSG_NPC_NAME_SADIE,
		"Sadie" },
	{ N_MSG_NPC_NAME_SALLIE,
		"Sallie" },
	{ N_MSG_NPC_NAME_SAMANTHA,
		"Samantha" },
	{ N_MSG_NPC_NAME_SARAH,
		"Sarah" },
	{ N_MSG_NPC_NAME_SELINA,
		"Selina" },
	{ N_MSG_NPC_NAME_SELMA,
		"Selma" },
	{ N_MSG_NPC_NAME_SERAPHINA,
		"Seraphina" },
	{ N_MSG_NPC_NAME_SHARON,
		"Sharon" },
	{ N_MSG_NPC_NAME_SHEILA,
		"Sheila" },
	{ N_MSG_NPC_NAME_SIBYL,
		"Sibyl" },
	{ N_MSG_NPC_NAME_SILVIA,
		"Silvia" },
	{ N_MSG_NPC_NAME_SONIA,
		"Sonia" },
	{ N_MSG_NPC_NAME_SOPHIA,
		"Sophia" },
	{ N_MSG_NPC_NAME_SOPHIE,
		"Sophie" },
	{ N_MSG_NPC_NAME_STELLA,
		"Stella" },
	{ N_MSG_NPC_NAME_STEPHANIE,
		"Stephanie" },
	{ N_MSG_NPC_NAME_SUKEY,
		"Sukey" },
	{ N_MSG_NPC_NAME_SUSAN,
		"Susan" },
	{ N_MSG_NPC_NAME_SUSANNA,
		"Susanna" },
	{ N_MSG_NPC_NAME_SUSIE,
		"Susie" },
	{ N_MSG_NPC_NAME_SUZANNE,
		"Suzanne" },
	{ N_MSG_NPC_NAME_TABITHA,
		"Tabitha" },
	{ N_MSG_NPC_NAME_TALIA,
		"Talia" },
	{ N_MSG_NPC_NAME_TALLULAH,
		"Tallulah" },
	{ N_MSG_NPC_NAME_TAMAR,
		"Tamar" },
	{ N_MSG_NPC_NAME_THELMA,
		"Thelma" },
	{ N_MSG_NPC_NAME_THERESA,
		"Theresa" },
	{ N_MSG_NPC_NAME_TIFFANY,
		"Tiffany" },
	{ N_MSG_NPC_NAME_TRIXIE,
		"Trixie" },
	{ N_MSG_NPC_NAME_UNA,
		"Una" },
	{ N_MSG_NPC_NAME_URSULA,
		"Ursula" },
	{ N_MSG_NPC_NAME_VALERIA,
		"Valeria" },
	{ N_MSG_NPC_NAME_VALERIE,
		"Valerie" },
	{ N_MSG_NPC_NAME_VENUS,
		"Venus" },
	{ N_MSG_NPC_NAME_VERA,
		"Vera" },
	{ N_MSG_NPC_NAME_VERONICA,
		"Veronica" },
	{ N_MSG_NPC_NAME_VICTORIA,
		"Victoria" },
	{ N_MSG_NPC_NAME_VIOLA,
		"Viola" },
	{ N_MSG_NPC_NAME_VIOLET,
		"Violet" },
	{ N_MSG_NPC_NAME_VIRGINIA,
		"Virginia" },
	{ N_MSG_NPC_NAME_VIVIEN,
		"Vivien" },
	{ N_MSG_NPC_NAME_WANDA,
		"Wanda" },
	{ N_MSG_NPC_NAME_WENDY,
		"Wendy" },
	{ N_MSG_NPC_NAME_WINIFRED,
		"Winifred" },
	{ N_MSG_NPC_NAME_XANTHIPPE,
		"Xanthippe" },
	{ N_MSG_NPC_NAME_YOLANDA,
		"Yolanda" },
	{ N_MSG_NPC_NAME_YVONNE,
		"Yvonne" },
	{ N_MSG_NPC_NAME_ZELDA,
		"Zelda" },
	{ N_MSG_NPC_NAME_ZENOBIA,
		"Zenobia" },
	{ N_MSG_NPC_NAME_ZILLAH,
		"Zillah" },

/* NPC name female end */

/* NPC name male begin */

	{ N_MSG_NPC_NAME_AARON,
		"Aaron" },
	{ N_MSG_NPC_NAME_ABNER,
		"Abner" },
	{ N_MSG_NPC_NAME_ABRAHAM,
		"Abraham" },
	{ N_MSG_NPC_NAME_ABRAM,
		"Abram" },
	{ N_MSG_NPC_NAME_ADALBERT,
		"Adalbert" },
	{ N_MSG_NPC_NAME_ADAM,
		"Adam" },
	{ N_MSG_NPC_NAME_ADLAI,
		"Adlai" },
	{ N_MSG_NPC_NAME_ADOLF,
		"Adolf" },
	{ N_MSG_NPC_NAME_ADOLPHUS,
		"Adolphus" },
	{ N_MSG_NPC_NAME_AENEAS,
		"Aeneas" },
	{ N_MSG_NPC_NAME_ALAN,
		"Alan" },
	{ N_MSG_NPC_NAME_ALBERT,
		"Albert" },
	{ N_MSG_NPC_NAME_ALBIN,
		"Albin" },
	{ N_MSG_NPC_NAME_ALDHELM,
		"Aldhelm" },
	{ N_MSG_NPC_NAME_ALDO,
		"Aldo" },
	{ N_MSG_NPC_NAME_ALDOUS,
		"Aldous" },
	{ N_MSG_NPC_NAME_ALEC,
		"Alec" },
	{ N_MSG_NPC_NAME_ALEX,
		"Alex" },
	{ N_MSG_NPC_NAME_ALEXANDER,
		"Alexander" },
	{ N_MSG_NPC_NAME_ALEXIS,
		"Alexis" },
	{ N_MSG_NPC_NAME_ALFRED,
		"Alfred" },
	{ N_MSG_NPC_NAME_ALGERNON,
		"Algernon" },
	{ N_MSG_NPC_NAME_ALLEN,
		"Allen" },
	{ N_MSG_NPC_NAME_ALMON,
		"Almon" },
	{ N_MSG_NPC_NAME_ALVAH,
		"Alvah" },
	{ N_MSG_NPC_NAME_ALVIN,
		"Alvin" },
	{ N_MSG_NPC_NAME_AMBROSE,
		"Ambrose" },
	{ N_MSG_NPC_NAME_ANDREW,
		"Andrew" },
	{ N_MSG_NPC_NAME_ANDY,
		"Andy" },
	{ N_MSG_NPC_NAME_ANGUS,
		"Angus" },
	{ N_MSG_NPC_NAME_ANSEL,
		"Ansel" },
	{ N_MSG_NPC_NAME_ANSELM,
		"Anselm" },
	{ N_MSG_NPC_NAME_ANTHONY,
		"Anthony" },
	{ N_MSG_NPC_NAME_ARCHIBALD,
		"Archibald" },
	{ N_MSG_NPC_NAME_ARCHIE,
		"Archie" },
	{ N_MSG_NPC_NAME_ARNOLD,
		"Arnold" },
	{ N_MSG_NPC_NAME_ARTHUR,
		"Arthur" },
	{ N_MSG_NPC_NAME_ASA,
		"Asa" },
	{ N_MSG_NPC_NAME_AUBREY,
		"Aubrey" },
	{ N_MSG_NPC_NAME_AUGUST,
		"August" },
	{ N_MSG_NPC_NAME_AUGUSTUS,
		"Augustus" },
	{ N_MSG_NPC_NAME_AYLMER,
		"Aylmer" },
	{ N_MSG_NPC_NAME_BARNABAS,
		"Barnabas" },
	{ N_MSG_NPC_NAME_BARNABY,
		"Barnaby" },
	{ N_MSG_NPC_NAME_BARRY,
		"Barry" },
	{ N_MSG_NPC_NAME_BARTHOLOMEW,
		"Bartholomew" },
	{ N_MSG_NPC_NAME_BASIL,
		"Basil" },
	{ N_MSG_NPC_NAME_BENJAMIN,
		"Benjamin" },
	{ N_MSG_NPC_NAME_BENNET,
		"Bennet" },
	{ N_MSG_NPC_NAME_BERNARD,
		"Bernard" },
	{ N_MSG_NPC_NAME_BERNHARD,
		"Bernhard" },
	{ N_MSG_NPC_NAME_BERT,
		"Bert" },
	{ N_MSG_NPC_NAME_BERTRAM,
		"Bertram" },
	{ N_MSG_NPC_NAME_BERTRAND,
		"Bertrand" },
	{ N_MSG_NPC_NAME_BOB,
		"Bob" },
	{ N_MSG_NPC_NAME_BORIS,
		"Boris" },
	{ N_MSG_NPC_NAME_BRENDAN,
		"Brendan" },
	{ N_MSG_NPC_NAME_BRIAN,
		"Brian" },
	{ N_MSG_NPC_NAME_BRUCE,
		"Bruce" },
	{ N_MSG_NPC_NAME_BUD,
		"Bud" },
	{ N_MSG_NPC_NAME_BUDDY,
		"Buddy" },
	{ N_MSG_NPC_NAME_CALVIN,
		"Calvin" },
	{ N_MSG_NPC_NAME_CAMERON,
		"Cameron" },
	{ N_MSG_NPC_NAME_CARL,
		"Carl" },
	{ N_MSG_NPC_NAME_CASSANDRA,
		"Cassandra" },
	{ N_MSG_NPC_NAME_CASSIUS,
		"Cassius" },
	{ N_MSG_NPC_NAME_CECIL,
		"Cecil" },
	{ N_MSG_NPC_NAME_CEDRIC,
		"Cedric" },
	{ N_MSG_NPC_NAME_CEPHAS,
		"Cephas" },
	{ N_MSG_NPC_NAME_CHAD,
		"Chad" },
	{ N_MSG_NPC_NAME_CHARLES,
		"Charles" },
	{ N_MSG_NPC_NAME_CHESTER,
		"Chester" },
	{ N_MSG_NPC_NAME_CHRISTOPHER,
		"Christopher" },
	{ N_MSG_NPC_NAME_CLARENCE,
		"Clarence" },
	{ N_MSG_NPC_NAME_CLARK,
		"Clark" },
	{ N_MSG_NPC_NAME_CLAUD,
		"Claud" },
	{ N_MSG_NPC_NAME_CLEMENT,
		"Clement" },
	{ N_MSG_NPC_NAME_CLIFFORD,
		"Clifford" },
	{ N_MSG_NPC_NAME_CLYDE,
		"Clyde" },
	{ N_MSG_NPC_NAME_COLIN,
		"Colin" },
	{ N_MSG_NPC_NAME_CONRAD,
		"Conrad" },
	{ N_MSG_NPC_NAME_CONSTANT,
		"Constant" },
	{ N_MSG_NPC_NAME_CORNELIUS,
		"Cornelius" },
	{ N_MSG_NPC_NAME_CURTIS,
		"Curtis" },
	{ N_MSG_NPC_NAME_CYRIL,
		"Cyril" },
	{ N_MSG_NPC_NAME_CYRUS,
		"Cyrus" },
	{ N_MSG_NPC_NAME_DALE,
		"Dale" },
	{ N_MSG_NPC_NAME_DAMON,
		"Damon" },
	{ N_MSG_NPC_NAME_DAN,
		"Dan" },
	{ N_MSG_NPC_NAME_DANIEL,
		"Daniel" },
	{ N_MSG_NPC_NAME_DARIUS,
		"Darius" },
	{ N_MSG_NPC_NAME_DATUS,
		"Datus" },
	{ N_MSG_NPC_NAME_DAVID,
		"David" },
	{ N_MSG_NPC_NAME_DEAN,
		"Dean" },
	{ N_MSG_NPC_NAME_DENNIS,
		"Dennis" },
	{ N_MSG_NPC_NAME_DEREK,
		"Derek" },
	{ N_MSG_NPC_NAME_DICK,
		"Dick" },
	{ N_MSG_NPC_NAME_DONALD,
		"Donald" },
	{ N_MSG_NPC_NAME_DOUGAL,
		"Dougal" },
	{ N_MSG_NPC_NAME_DOUGLAS,
		"Douglas" },
	{ N_MSG_NPC_NAME_DUANE,
		"Duane" },
	{ N_MSG_NPC_NAME_DUDLEY,
		"Dudley" },
	{ N_MSG_NPC_NAME_DUGALD,
		"Dugald" },
	{ N_MSG_NPC_NAME_DUKE,
		"Duke" },
	{ N_MSG_NPC_NAME_DUNCAN,
		"Duncan" },
	{ N_MSG_NPC_NAME_DWAYNE,
		"Dwayne" },
	{ N_MSG_NPC_NAME_DWIGHT,
		"Dwight" },
	{ N_MSG_NPC_NAME_EARL,
		"Earl" },
	{ N_MSG_NPC_NAME_EDGAR,
		"Edgar" },
	{ N_MSG_NPC_NAME_EDMUND,
		"Edmund" },
	{ N_MSG_NPC_NAME_EDWARD,
		"Edward" },
	{ N_MSG_NPC_NAME_EDWIN,
		"Edwin" },
	{ N_MSG_NPC_NAME_EGBERT,
		"Egbert" },
	{ N_MSG_NPC_NAME_ELBERT,
		"Elbert" },
	{ N_MSG_NPC_NAME_ELIAS,
		"Elias" },
	{ N_MSG_NPC_NAME_ELIPHALET,
		"Eliphalet" },
	{ N_MSG_NPC_NAME_ELLA,
		"Ella" },
	{ N_MSG_NPC_NAME_ELMER,
		"Elmer" },
	{ N_MSG_NPC_NAME_ENOCH,
		"Enoch" },
	{ N_MSG_NPC_NAME_ENOS,
		"Enos" },
	{ N_MSG_NPC_NAME_ERIC,
		"Eric" },
	{ N_MSG_NPC_NAME_ERNEST,
		"Ernest" },
	{ N_MSG_NPC_NAME_ETHELBERT,
		"Ethelbert" },
	{ N_MSG_NPC_NAME_EUGENE,
		"Eugene" },
	{ N_MSG_NPC_NAME_EWEN,
		"Ewen" },
	{ N_MSG_NPC_NAME_EZRA,
		"Ezra" },
	{ N_MSG_NPC_NAME_FABIAN,
		"Fabian" },
	{ N_MSG_NPC_NAME_FELIX,
		"Felix" },
	{ N_MSG_NPC_NAME_FRANCIS,
		"Francis" },
	{ N_MSG_NPC_NAME_FRANK,
		"Frank" },
	{ N_MSG_NPC_NAME_FRANKLIN,
		"Franklin" },
	{ N_MSG_NPC_NAME_FREDERICK,
		"Frederick" },
	{ N_MSG_NPC_NAME_GABRIEL,
		"Gabriel" },
	{ N_MSG_NPC_NAME_GAD,
		"Gad" },
	{ N_MSG_NPC_NAME_GAMALIEL,
		"Gamaliel" },
	{ N_MSG_NPC_NAME_GARY,
		"Gary" },
	{ N_MSG_NPC_NAME_GEOFFREY,
		"Geoffrey" },
	{ N_MSG_NPC_NAME_GEORGE,
		"George" },
	{ N_MSG_NPC_NAME_GERALD,
		"Gerald" },
	{ N_MSG_NPC_NAME_GERARD,
		"Gerard" },
	{ N_MSG_NPC_NAME_GERRY,
		"Gerry" },
	{ N_MSG_NPC_NAME_GILBERT,
		"Gilbert" },
	{ N_MSG_NPC_NAME_GILES,
		"Giles" },
	{ N_MSG_NPC_NAME_GLENN,
		"Glenn" },
	{ N_MSG_NPC_NAME_GODFREY,
		"Godfrey" },
	{ N_MSG_NPC_NAME_GORDON,
		"Gordon" },
	{ N_MSG_NPC_NAME_GREGORY,
		"Gregory" },
	{ N_MSG_NPC_NAME_GRIFFIN,
		"Griffin" },
	{ N_MSG_NPC_NAME_GRIFFITH,
		"Griffith" },
	{ N_MSG_NPC_NAME_GUS,
		"Gus" },
	{ N_MSG_NPC_NAME_GUSTAVUS,
		"Gustavus" },
	{ N_MSG_NPC_NAME_GUY,
		"Guy" },
	{ N_MSG_NPC_NAME_HAMILTON,
		"Hamilton" },
	{ N_MSG_NPC_NAME_HANNIBAL,
		"Hannibal" },
	{ N_MSG_NPC_NAME_HAROLD,
		"Harold" },
	{ N_MSG_NPC_NAME_HARRY,
		"Harry" },
	{ N_MSG_NPC_NAME_HARVEY,
		"Harvey" },
	{ N_MSG_NPC_NAME_HECTOR,
		"Hector" },
	{ N_MSG_NPC_NAME_HENRY,
		"Henry" },
	{ N_MSG_NPC_NAME_HERBERT,
		"Herbert" },
	{ N_MSG_NPC_NAME_HERCULES,
		"Hercules" },
	{ N_MSG_NPC_NAME_HERMAN,
		"Herman" },
	{ N_MSG_NPC_NAME_HIRAM,
		"Hiram" },
	{ N_MSG_NPC_NAME_HOMER,
		"Homer" },
	{ N_MSG_NPC_NAME_HORACE,
		"Horace" },
	{ N_MSG_NPC_NAME_HORATIO,
		"Horatio" },
	{ N_MSG_NPC_NAME_HOSEA,
		"Hosea" },
	{ N_MSG_NPC_NAME_HOWARD,
		"Howard" },
	{ N_MSG_NPC_NAME_HOWELL,
		"Howell" },
	{ N_MSG_NPC_NAME_HUBERT,
		"Hubert" },
	{ N_MSG_NPC_NAME_HUGH,
		"Hugh" },
	{ N_MSG_NPC_NAME_HUGO,
		"Hugo" },
	{ N_MSG_NPC_NAME_HUMPHREY,
		"Humphrey" },
	{ N_MSG_NPC_NAME_IAN,
		"Ian" },
	{ N_MSG_NPC_NAME_ION,
		"Ion" },
	{ N_MSG_NPC_NAME_IRA,
		"Ira" },
	{ N_MSG_NPC_NAME_IRVINE,
		"Irvine" },
	{ N_MSG_NPC_NAME_IRVING,
		"Irving" },
	{ N_MSG_NPC_NAME_ISAAC,
		"Isaac" },
	{ N_MSG_NPC_NAME_ISADOR,
		"Isador" },
	{ N_MSG_NPC_NAME_ISHMAEL,
		"Ishmael" },
	{ N_MSG_NPC_NAME_IVAN,
		"Ivan" },
	{ N_MSG_NPC_NAME_IVY,
		"Ivy" },
	{ N_MSG_NPC_NAME_JABEZ,
		"Jabez" },
	{ N_MSG_NPC_NAME_JACK,
		"Jack" },
	{ N_MSG_NPC_NAME_JACKSON,
		"Jackson" },
	{ N_MSG_NPC_NAME_JACOB,
		"Jacob" },
	{ N_MSG_NPC_NAME_JAIR,
		"Jair" },
	{ N_MSG_NPC_NAME_JAIRUS,
		"Jairus" },
	{ N_MSG_NPC_NAME_JAMES,
		"James" },
	{ N_MSG_NPC_NAME_JAMIE,
		"Jamie" },
	{ N_MSG_NPC_NAME_JASON,
		"Jason" },
	{ N_MSG_NPC_NAME_JASPER,
		"Jasper" },
	{ N_MSG_NPC_NAME_JEDIDIAH,
		"Jedidiah" },
	{ N_MSG_NPC_NAME_JEHU,
		"Jehu" },
	{ N_MSG_NPC_NAME_JEREMIAH,
		"Jeremiah" },
	{ N_MSG_NPC_NAME_JEREMY,
		"Jeremy" },
	{ N_MSG_NPC_NAME_JEROBOAM,
		"Jeroboam" },
	{ N_MSG_NPC_NAME_JEROME,
		"Jerome" },
	{ N_MSG_NPC_NAME_JESSE,
		"Jesse" },
	{ N_MSG_NPC_NAME_JIM,
		"Jim" },
	{ N_MSG_NPC_NAME_JIMMY,
		"Jimmy" },
	{ N_MSG_NPC_NAME_JOB,
		"Job" },
	{ N_MSG_NPC_NAME_JOEL,
		"Joel" },
	{ N_MSG_NPC_NAME_JOHN,
		"John" },
	{ N_MSG_NPC_NAME_JOHNNY,
		"Johnny" },
	{ N_MSG_NPC_NAME_JONAS,
		"Jonas" },
	{ N_MSG_NPC_NAME_JONATHAN,
		"Jonathan" },
	{ N_MSG_NPC_NAME_JOSEPH,
		"Joseph" },
	{ N_MSG_NPC_NAME_JOSHUA,
		"Joshua" },
	{ N_MSG_NPC_NAME_JUDE,
		"Jude" },
	{ N_MSG_NPC_NAME_JULIUS,
		"Julius" },
	{ N_MSG_NPC_NAME_JUNIUS,
		"Junius" },
	{ N_MSG_NPC_NAME_JUSTIN,
		"Justin" },
	{ N_MSG_NPC_NAME_KENNETH,
		"Kenneth" },
	{ N_MSG_NPC_NAME_KEVIN,
		"Kevin" },
	{ N_MSG_NPC_NAME_LAURENCE,
		"Laurence" },
	{ N_MSG_NPC_NAME_LAZARUS,
		"Lazarus" },
	{ N_MSG_NPC_NAME_LEO,
		"Leo" },
	{ N_MSG_NPC_NAME_LEON,
		"Leon" },
	{ N_MSG_NPC_NAME_LEONARD,
		"Leonard" },
	{ N_MSG_NPC_NAME_LEOPOLD,
		"Leopold" },
	{ N_MSG_NPC_NAME_LESTER,
		"Lester" },
	{ N_MSG_NPC_NAME_LEVI,
		"Levi" },
	{ N_MSG_NPC_NAME_LEWIS,
		"Lewis" },
	{ N_MSG_NPC_NAME_LINUS,
		"Linus" },
	{ N_MSG_NPC_NAME_LIONEL,
		"Lionel" },
	{ N_MSG_NPC_NAME_LLOYD,
		"Lloyd" },
	{ N_MSG_NPC_NAME_LUKE,
		"Luke" },
	{ N_MSG_NPC_NAME_LUTHER,
		"Luther" },
	{ N_MSG_NPC_NAME_MALACHI,
		"Malachi" },
	{ N_MSG_NPC_NAME_MANFRED,
		"Manfred" },
	{ N_MSG_NPC_NAME_MARK,
		"Mark" },
	{ N_MSG_NPC_NAME_MARMADUKE,
		"Marmaduke" },
	{ N_MSG_NPC_NAME_MARTIN,
		"Martin" },
	{ N_MSG_NPC_NAME_MATTHEW,
		"Matthew" },
	{ N_MSG_NPC_NAME_MAURICE,
		"Maurice" },
	{ N_MSG_NPC_NAME_MAX,
		"Max" },
	{ N_MSG_NPC_NAME_MELVIN,
		"Melvin" },
	{ N_MSG_NPC_NAME_MICHAEL,
		"Michael" },
	{ N_MSG_NPC_NAME_MICK,
		"Mick" },
	{ N_MSG_NPC_NAME_MICKY,
		"Micky" },
	{ N_MSG_NPC_NAME_MILES,
		"Miles" },
	{ N_MSG_NPC_NAME_MILTON,
		"Milton" },
	{ N_MSG_NPC_NAME_MORGAN,
		"Morgan" },
	{ N_MSG_NPC_NAME_MOSES,
		"Moses" },
	{ N_MSG_NPC_NAME_NAAMAN,
		"Naaman" },
	{ N_MSG_NPC_NAME_NAHUM,
		"Nahum" },
	{ N_MSG_NPC_NAME_NATHAN,
		"Nathan" },
	{ N_MSG_NPC_NAME_NATHANIEL,
		"Nathaniel" },
	{ N_MSG_NPC_NAME_NEAL,
		"Neal" },
	{ N_MSG_NPC_NAME_NICHOLAS,
		"Nicholas" },
	{ N_MSG_NPC_NAME_NOAH,
		"Noah" },
	{ N_MSG_NPC_NAME_NOEL,
		"Noel" },
	{ N_MSG_NPC_NAME_NORMAN,
		"Norman" },
	{ N_MSG_NPC_NAME_OLIVER,
		"Oliver" },
	{ N_MSG_NPC_NAME_ONESIMUS,
		"Onesimus" },
	{ N_MSG_NPC_NAME_ONESIPHORUS,
		"Onesiphorus" },
	{ N_MSG_NPC_NAME_OSBORN,
		"Osborn" },
	{ N_MSG_NPC_NAME_OSCAR,
		"Oscar" },
	{ N_MSG_NPC_NAME_OSWALD,
		"Oswald" },
	{ N_MSG_NPC_NAME_OTTO,
		"Otto" },
	{ N_MSG_NPC_NAME_OWEN,
		"Owen" },
	{ N_MSG_NPC_NAME_OZIAS,
		"Ozias" },
	{ N_MSG_NPC_NAME_PATRICK,
		"Patrick" },
	{ N_MSG_NPC_NAME_PAUL,
		"Paul" },
	{ N_MSG_NPC_NAME_PENUEL,
		"Penuel" },
	{ N_MSG_NPC_NAME_PERCEVAL,
		"Perceval" },
	{ N_MSG_NPC_NAME_PERCY,
		"Percy" },
	{ N_MSG_NPC_NAME_PETER,
		"Peter" },
	{ N_MSG_NPC_NAME_PHILANDER,
		"Philander" },
	{ N_MSG_NPC_NAME_PHILIP,
		"Philip" },
	{ N_MSG_NPC_NAME_QUENTIN,
		"Quentin" },
	{ N_MSG_NPC_NAME_QUINCY,
		"Quincy" },
	{ N_MSG_NPC_NAME_RAFE,
		"Rafe" },
	{ N_MSG_NPC_NAME_RALPH,
		"Ralph" },
	{ N_MSG_NPC_NAME_RANDAL,
		"Randal" },
	{ N_MSG_NPC_NAME_RANDOLPH,
		"Randolph" },
	{ N_MSG_NPC_NAME_RAYMOND,
		"Raymond" },
	{ N_MSG_NPC_NAME_REGGIE,
		"Reggie" },
	{ N_MSG_NPC_NAME_REGINALD,
		"Reginald" },
	{ N_MSG_NPC_NAME_REX,
		"Rex" },
	{ N_MSG_NPC_NAME_RICHARD,
		"Richard" },
	{ N_MSG_NPC_NAME_RICK,
		"Rick" },
	{ N_MSG_NPC_NAME_ROB,
		"Rob" },
	{ N_MSG_NPC_NAME_ROBERT,
		"Robert" },
	{ N_MSG_NPC_NAME_RODERICK,
		"Roderick" },
	{ N_MSG_NPC_NAME_ROGER,
		"Roger" },
	{ N_MSG_NPC_NAME_ROLAND,
		"Roland" },
	{ N_MSG_NPC_NAME_RONALD,
		"Ronald" },
	{ N_MSG_NPC_NAME_ROSS,
		"Ross" },
	{ N_MSG_NPC_NAME_ROY,
		"Roy" },
	{ N_MSG_NPC_NAME_RUDOLF,
		"Rudolf" },
	{ N_MSG_NPC_NAME_RUFUS,
		"Rufus" },
	{ N_MSG_NPC_NAME_RUPERT,
		"Rupert" },
	{ N_MSG_NPC_NAME_RUSSEL,
		"Russel" },
	{ N_MSG_NPC_NAME_SAM,
		"Sam" },
	{ N_MSG_NPC_NAME_SAMMY,
		"Sammy" },
	{ N_MSG_NPC_NAME_SAMUEL,
		"Samuel" },
	{ N_MSG_NPC_NAME_SANDY,
		"Sandy" },
	{ N_MSG_NPC_NAME_SAUL,
		"Saul" },
	{ N_MSG_NPC_NAME_SCOTT,
		"Scott" },
	{ N_MSG_NPC_NAME_SHERRY,
		"Sherry" },
	{ N_MSG_NPC_NAME_SI,
		"Si" },
	{ N_MSG_NPC_NAME_SILAS,
		"Silas" },
	{ N_MSG_NPC_NAME_SIMON,
		"Simon" },
	{ N_MSG_NPC_NAME_STANLEY,
		"Stanley" },
	{ N_MSG_NPC_NAME_STEPHEN,
		"Stephen" },
	{ N_MSG_NPC_NAME_STEVE,
		"Steve" },
	{ N_MSG_NPC_NAME_STEVIE,
		"Stevie" },
	{ N_MSG_NPC_NAME_STEWART,
		"Stewart" },
	{ N_MSG_NPC_NAME_TED,
		"Ted" },
	{ N_MSG_NPC_NAME_TEDDY,
		"Teddy" },
	{ N_MSG_NPC_NAME_TERENCE,
		"Terence" },
	{ N_MSG_NPC_NAME_THADDEUS,
		"Thaddeus" },
	{ N_MSG_NPC_NAME_THEODORE,
		"Theodore" },
	{ N_MSG_NPC_NAME_THEOPHILUS,
		"Theophilus" },
	{ N_MSG_NPC_NAME_THERON,
		"Theron" },
	{ N_MSG_NPC_NAME_THOMAS,
		"Thomas" },
	{ N_MSG_NPC_NAME_TIMOTHY,
		"Timothy" },
	{ N_MSG_NPC_NAME_TITUS,
		"Titus" },
	{ N_MSG_NPC_NAME_TOBIAS,
		"Tobias" },
	{ N_MSG_NPC_NAME_TOBY,
		"Toby" },
	{ N_MSG_NPC_NAME_TOM,
		"Tom" },
	{ N_MSG_NPC_NAME_TONY,
		"Tony" },
	{ N_MSG_NPC_NAME_TRISTRAM,
		"Tristram" },
	{ N_MSG_NPC_NAME_TROY,
		"Troy" },
	{ N_MSG_NPC_NAME_ULYSSES,
		"Ulysses" },
	{ N_MSG_NPC_NAME_URIAH,
		"Uriah" },
	{ N_MSG_NPC_NAME_URIAN,
		"Urian" },
	{ N_MSG_NPC_NAME_URIEL,
		"Uriel" },
	{ N_MSG_NPC_NAME_VICTOR,
		"Victor" },
	{ N_MSG_NPC_NAME_VINCENT,
		"Vincent" },
	{ N_MSG_NPC_NAME_WALLACE,
		"Wallace" },
	{ N_MSG_NPC_NAME_WALT,
		"Walt" },
	{ N_MSG_NPC_NAME_WALTER,
		"Walter" },
	{ N_MSG_NPC_NAME_WARREN,
		"Warren" },
	{ N_MSG_NPC_NAME_WAT,
		"Wat" },
	{ N_MSG_NPC_NAME_WILFRED,
		"Wilfred" },
	{ N_MSG_NPC_NAME_WILLAM,
		"Willam" },
	{ N_MSG_NPC_NAME_ZANTIPPY,
		"Zantippy" },
	{ N_MSG_NPC_NAME_ZURIEL,
		"Zuriel" },

/* NPC name male end */

/* NPC name male or female begin */

	{ N_MSG_NPC_NAME_ADRIAN,
		"Adrian" },
	{ N_MSG_NPC_NAME_ARIEL,
		"Ariel" },
	{ N_MSG_NPC_NAME_CAROL,
		"Carol" },
	{ N_MSG_NPC_NAME_CHRISTIAN,
		"Christian" },
	{ N_MSG_NPC_NAME_FREDDIE,
		"Freddie" },
	{ N_MSG_NPC_NAME_HILARY,
		"Hilary" },
	{ N_MSG_NPC_NAME_JACKIE,
		"Jackie" },
	{ N_MSG_NPC_NAME_JODY,
		"Jody" },
	{ N_MSG_NPC_NAME_JULIAN,
		"Julian" },
	{ N_MSG_NPC_NAME_KIM,
		"Kim" },
	{ N_MSG_NPC_NAME_PAT,
		"Pat" },
	{ N_MSG_NPC_NAME_RAY,
		"Ray" },
	{ N_MSG_NPC_NAME_SIDNEY,
		"Sidney" },
	{ N_MSG_NPC_NAME_TERRY,
		"Terry" },
	{ N_MSG_NPC_NAME_VIVIAN,
		"Vivian" },

	{ N_MSG_NPC_NAME_ANDREA,
		"Andrea" },
	{ N_MSG_NPC_NAME_CLAIR,
		"Clair" },
	{ N_MSG_NPC_NAME_SHIRLEY,
		"Shirley" },
	{ N_MSG_NPC_NAME_JOCELYN,
		"Jocelyn" },
	{ N_MSG_NPC_NAME_BEVERLY,
		"Beverly" },
	{ N_MSG_NPC_NAME_HOPE,
		"Hope" },
	{ N_MSG_NPC_NAME_MERLE,
		"Merle" },
	{ N_MSG_NPC_NAME_LEE,
		"Lee" },
	{ N_MSG_NPC_NAME_LYNN,
		"Lynn" },
	{ N_MSG_NPC_NAME_LINDSAY,
		"Lindsay" },
	{ N_MSG_NPC_NAME_LESLIE,
		"Leslie" },
	{ N_MSG_NPC_NAME_ROBIN,
		"Robin" },

/* NPC name male or female end */

/* NPC name end */

/* request begin */

	{ N_MSG_REQUEST_KIND_RARE_GOODS,
		"Rare goods"},
	{ N_MSG_REQUEST_KIND_TAME_MNSTR,
		"CapMon" },
	{ N_MSG_REQUEST_KIND_RESCUE,
		"Rescue" },
	{ N_MSG_REQUEST_KIND_TOUR_GUIDE,
		"Tour guide" },
	{ N_MSG_REQUEST_KIND_EXTERMINATE,
		"Exterminate" },
	{ N_MSG_REQUEST_KIND_REVENGE,
		"Revenge" },
	{ N_MSG_REQUEST_KIND_WANTED_CRIMINAL,
		"Wanted" },

	{ N_MSG_REQUEST_CONTRACT_STILL,
		"      " },
	{ N_MSG_REQUEST_CONTRACT_YOU,
		"You   " },
	{ N_MSG_REQUEST_CONTRACT_OTHER,
		"Other " },
	{ N_MSG_REQUEST_CONTRACT_FINISH,
		"Finish" },

	{ N_MSG_REQUEST_LIMIT,
		"The request of %s is overdue." },
	{ N_MSG_REQUEST_FINISH,
		"The request of %s was achieved." },

	{ N_MSG_REQUEST_CONTRACT_FMT,
		"It is %s that undertook this request." },
	{ N_MSG_REQUEST_DO_NOT_CONTRACT,
		"Will you undertake this request?" },

	{ N_MSG_REQUEST_HEADING_FMT,
		"%s:%-12s:%4ldF:%3ldDays:" STR_GOLD_SHORT_FMT_MAX
	},

	{ N_MSG_REQUEST_VAR_QUOTE,
		"%s" },

	{ N_MSG_REQUEST_DUN_LEV,
		"%s" },
	{ N_MSG_REQUEST_DUN_LEV_RANGE,
		"from the %s floor to the %s floor" },

	{ N_MSG_REQUEST_MNSTR_N,
		" %ld" },

	{ N_MSG_WHEN_A00,
		"while it is sleeping" },
	{ N_MSG_WHEN_A01,
		"while it goes shopping" },
	{ N_MSG_WHEN_A02,
		"while it goes out" },
	{ N_MSG_WHEN_A03,
		"while it goes on a trip" },

	{ N_MSG_WHEN_B00,
		"only while it is short" },
	{ N_MSG_WHEN_B01,
		"for a long time" },
	{ N_MSG_WHEN_B02,
		"until recently" },
	{ N_MSG_WHEN_B03,
		"beforehand" },
	{ N_MSG_WHEN_B04,
		"recent" },
	{ N_MSG_WHEN_B05,
		"sometimes" },
	{ N_MSG_WHEN_B06,
		"every day" },

	{ N_MSG_WEAPON_00,
		"fruit knife" },
	{ N_MSG_WEAPON_01,
		"vase" },
	{ N_MSG_WEAPON_02,
		"sword of heirloom" },

/* rare goods */
	{ N_MSG_REQUEST_RARE_GOODS_00,
		"I hear that there is a ${rare_goods}"
		" not obtained though ${client}"
		" collects ${rare_goods} ${when:b}."
		"${monster} seems to have ${rare_goods}."
		"${monster} must be somewhere ${dungeon_level_range}."
		"I want you to look for ${rare_goods} instead of ${client}."
	},

	{ N_MSG_REQUEST_RARE_GOODS_01,
		"I hear that it consulted the fortune teller"
		" because unhappy continues to ${client}"
		" ${when:b}."
		"I hear becoming lucky according"
		" to the fortune-telling being able to drive away"
		" evils if the ${rare_goods} is obtained."
		"${monster} somewhere of ${dungeon_level_range}"
		" has ${rare_goods}."
		"I want you to look for ${rare_goods} for ${client}."
	},

	{ N_MSG_REQUEST_RARE_GOODS_02,
		"${client} was exploring the labyrinth ${when:b}."
		"I hear that ${rare_goods} has been stolen"
		" by ${monster} while it relaxes one's"
		"guard however."
		"${client} seems to have been valuing ${rare_goods}"
		" very much."
		"${monster} must be somewhere of ${dungeon_level_range}."
		"I want you to look for ${rare_goods} instead"
		" of ${client} who says,"
		" \"I do not want to dive any longer in the labyrinth\"."
	},
/* tame mnstr */
	{ N_MSG_REQUEST_TAME_MNSTR_00,
		"I hear that ${client} does ${monster}\'s breeder,"
		" and looks for a rare ${monster} ${when:b}."
		"He hear that a changeable ${monster} is"
		" on the ${dungeon_level_range} in the rumor of"
		" the breeder guild."
		"Then, He want you to look for the ${monster}"
		" and to bring it."
	},

//@@@ begin
	{ N_MSG_REQUEST_TAME_MNSTR_01,
		"${client}${monster}Ȥäơ¸򤷤Ƥ뤽"
		"${when:b}${monster}ο­ʤΤǡ"
		"${monster}õϢ쵢äƤ餤"
		"${monster}ϡ褯${dungeon_level_range}˽Ф餷"
		"${monster}˴ä¸ǤϤʤʤΤǡ"
		"¿Ƥ졣"
	},
/* rescue */
	{ N_MSG_REQUEST_RESCUE_00,
		"${client}${rescue_target}ã"
		"${when:b}µܤõ򤷤ƤΤ"
		"${rescue_target}${dungeon_level_range}"
		"ϤƤޤä"
		"${client}ãˡ${rescue_target}"
		"õϢ쵢äߤ"
	},
/* tour guide */
	{ N_MSG_REQUEST_TOUR_GUIDE_00,
		"${client}Ͼ䤬äٹˤʤäǡ"
		"͵ʡ򤷤Ƥ餷"
		"ͭ;ǤȤƻڤԤ"
		"ǶϤäȻɷ㤬ߤʤꡢ"
		"Ĥˤµܤ˶̣򼨤"
		"ǡ${client}Ϣµܤꡢ"
		"${dungeon_level_range}˵"
		"${monster}${monster_number}ۤݤȤ"
		"ѤƤäߤ"
		"${client}­󽷤ϥåץ"
	},
/* exterminate */
	{ N_MSG_REQUEST_EXTERMINATE_00,
		"${client}ȡã"
		"${when:b}򤷤ƤΤ"
		"µܤ${monster}ã"
		"ǤƤޤä"
		"${client}ϡ"
		"ݤΤޤµܤ˶ʤʤäƤޤä"
		"${monster}${dungeon_level_range}β褫˵Ϥ"
		"ɤƤȸ${client}äơ"
		"${monster}${monster_number}ݤߤ"
	},

	{ N_MSG_REQUEST_EXTERMINATE_01,
		"ϣѻդ${client}"
		"${when:b}¸򤷤ƤΤ"
		"ˤ${monster}ο¡ɬפ餷"
		"¸Ǽ꤬Υʤ${client}ˡ"
		"${monster}${monster_number}ݤߤ"
		"${monster}${dungeon_level_range}β褫˵Ϥ"
	},
/* revenge */
	{ N_MSG_REQUEST_REVENGE_00,
		"${client}${when:a}${client_family}"
		"˻줿"
		"ܷԤξˤȿͤ${monster}"
		"${client}ϼʬμ${monster}"
		"${monster}${dungeon_level_range}β褫˵Ϥ"
		"${client}ϢµܤäƤ졣"
		"Ĥ򻦤Ƥ󽷤Ϥ"
	},

	{ N_MSG_REQUEST_REVENGE_01,
		"${monster}${client}${client_family}${when:b}"
		"${client}Ѥ򤷤Ƥ"
		"̤äΤĤ줫${monster}"
		"${client}${client_family}${weapon}ǡ"
		";äƻޤä餷"
		"${client}${monster}˺碌"
		"${monster}${dungeon_level_range}β褫˵Ϥ"
		"󤿤${client}μ򤷤ơ"
		"${monster}ݤƤɤ"
	},

	{ N_MSG_REQUEST_REVENGE_02,
		"${client}Ϲߤ${monster}${when:b}"
		"ڤƤ"
		"ڶΤʰ̼ޤä"
		"ޤˤϲ²ХХˤʤä"
		"${monster}${dungeon_level_range}β褫˵Ϥ"
		"${monster}ƤƤΤˤʤͤ"
		"${client}ȶϤ${monster}ųݤơ"
		"ߤ餷ƤäƤ졣"
	},

	{ N_MSG_REQUEST_REVENGE_03,
		"${client}${client_mate}ϤȤƤ礬ɤä"
		"${client}${when:b}"
		"ФŻ˼ФФäˡ"
		"${client_mate}${monster}˰Ż줿"
		"${client}ϲǤڤʤġġ"
		"${monster}${dungeon_level_range}β褫˵Ϥ"
		"${client}Ȱˡ${monster}򻦤Ƥ"
		"${client}ε⾯"
	},
/* wanted criminal */
	{ N_MSG_REQUEST_WANTED_CRIMINAL_00,
		"${client}${when:a}${client_family}"
		"˻줿"
		"ܷԤξˤȿͤ${monster}"
		"${monster}${dungeon_level_range}β褫˵Ϥ"
		"Ĥ򻦤Ƥ󽷤Ϥ"
	},

	{ N_MSG_REQUEST_WANTED_CRIMINAL_01,
		"${monster}${client}${when:b}"
		"²Ѥ򤷤Ƥ"
		"̤äΤĤ줫${monster}${client}${weapon}ǡ"
		";äƻޤä餷"
		"${monster}˺碌ʤʤʤ"
		"${monster}${dungeon_level_range}β褫˵Ϥ"
		"󤿤${monster}ݤƤɤ"
	},

	{ N_MSG_REQUEST_WANTED_CRIMINAL_02,
		"${client}Ϲߤ${monster}${when:b}"
		"ڤƤ"
		"ڶΤʰ̼ޤä"
		"ޤˤϲ²ХХˤʤä"
		"${monster}${dungeon_level_range}β褫˵Ϥ"
		"${monster}ƤƤΤˤʤͤ"
		"${monster}ųݤơ${client}κߤ餷ƤäƤ졣"
	},

	{ N_MSG_REQUEST_WANTED_CRIMINAL_03,
		"${client}${client_mate}ϤȤƤ礬ɤä"
		"${client}${when:b}"
		"ФŻ˼ФФäˡ"
		"${client_mate}${monster}˰Ż줿"
		"${client}ϲǤڤʤġġ"
		"${monster}${dungeon_level_range}β褫˵Ϥ"
		"Ĥ򻦤ƤС"
		"${client}ε⾯"
	},
//@@@ end
/**/

/* request end */

	{ N_MSG_FMT_MSG,
		"%-*s" },

	{ N_MSG_FMT_WPN_IDENTIFIED,
		"%c%c %2ld %s (%+ld,%+ld,%+ld)" },
	{ N_MSG_FMT_WPN_SLAYER,
		"%c%c %2ld %s %c Slayer"
		" (%+ld,%+ld,%+ld)" },
	{ N_MSG_FMT_WPN_NOT_IDENTIFIED,
		"%c%c %2ld %s" },
	{ N_MSG_FMT_ARMOR_IDENTIFIED,
		"%c%c %2ld %s[%+ld,%+ld,%+ld]%s" },
	{ N_MSG_PROTECTED_ARMOR,
		" [Protected]" },
	{ N_MSG_FMT_ARMOR_NOT_IDENTIFIED,
		"%c%c %2ld %s" },
	{ N_MSG_FMT_POTION_IDENTIFIED,
		"%c%c %2ld %s" },
	{ N_MSG_FMT_POTION_NOT_IDENTIFIED,
		"%c%c %2ld Potion of %s" },
	{ N_MSG_FMT_SCROLL_IDENTIFIED,
		"%c%c %2ld %s" },
	{ N_MSG_FMT_SCROLL_NOT_IDENTIFIED,
		"%c%c %2ld Scroll of %s" },
	{ N_MSG_FMT_WAND_IDENTIFIED,
		"%c%c %2ld Wand of %s (%ld times)" },
	{ N_MSG_FMT_ROD_IDENTIFIED,
		"%c%c %2ld Rod of %s (%ld times)" },
	{ N_MSG_FMT_STAFF_IDENTIFIED,
		"%c%c %2ld Staff of %s (%ld times)" },
	{ N_MSG_FMT_WAND_NOT_IDENTIFIED,
		"%c%c %2ld Wand of %s" },
	{ N_MSG_FMT_ROD_NOT_IDENTIFIED,
		"%c%c %2ld Rod of %s" },
	{ N_MSG_FMT_STAFF_NOT_IDENTIFIED,
		"%c%c %2ld Staff of %s" },
	{ N_MSG_FMT_ACCE_IDENTIFIED,
		"%c%c %2ld %s" },
	{ N_MSG_FMT_RING_NOT_IDENTIFIED,
		"%c%c %2ld Ring of %s" },
	{ N_MSG_FMT_AMULET_NOT_IDENTIFIED,
		"%c%c %2ld Amulet of %s" },
	{ N_MSG_FMT_NECKLACE_NOT_IDENTIFIED,
		"%c%c %2ld Necklace of %s" },
	{ N_MSG_FMT_INST_IDENTIFIED,
		"%c%c %2ld %s%s%s" },
	{ N_MSG_FMT_INST_NOT_IDENTIFIED,
		"%c%c %2ld %s" },
	{ N_MSG_FMT_ANTHOLOGY_IDENTIFIED,
		"%c%c %2ld %s" },
	{ N_MSG_FMT_ANTHOLOGY_NOT_IDENTIFIED,
		"%c%c %2ld Anthology of legends" },
	{ N_MSG_FMT_LIGHT_IDENTIFIED,
		"%c%c %2ld %s (%ld turn)" },
	{ N_MSG_FMT_LIGHT_NOT_IDENTIFIED,
		"%c%c %2ld %s (%ld turn)" },
	{ N_MSG_FMT_SPIKE_IDENTIFIED,
		"%c%c %2ld %s" },
	{ N_MSG_FMT_SPIKE_NOT_IDENTIFIED,
		"%c%c %2ld %s" },
	{ N_MSG_FMT_FOOD_IDENTIFIED,
		"%c%c %2ld %s" },
	{ N_MSG_FMT_FOOD_NOT_IDENTIFIED,
		"%c%c %2ld %s" },
	{ N_MSG_FMT_CHEST_IDENTIFIED,
		"%c%c %2ld %s" },
	{ N_MSG_FMT_CHEST_NOT_IDENTIFIED,
		"%c%c %2ld %s" },
	{ N_MSG_FMT_TOBACCO_IDENTIFIED,
		"%c%c %2ld %s (%s: %ld)" },
	{ N_MSG_FMT_TOBACCO_NOT_IDENTIFIED,
		"%c%c %2ld %s (%s)" },
	{ N_MSG_FMT_TOBACCO_STUB_IDENTIFIED,
		"%c%c %2ld %s" },
	{ N_MSG_FMT_PIPE_IDENTIFIED,
		"%c%c %2ld %s (%ld)" },
	{ N_MSG_FMT_PIPE_NOT_IDENTIFIED,
		"%c%c %2ld %s" },
	{ N_MSG_FMT_PIPE_STUB_IDENTIFIED,
		"%c%c %2ld %s" },
	{ N_MSG_FMT_DISPOSAL_IDENTIFIED,
		"%c%c %2ld cigarette disposal (%ld/%ld)" },
	{ N_MSG_FMT_RARE_GOODS_IDENTIFIED,
		"%c%c %2ld %s" },
	{ N_MSG_FMT_BONE_IDENTIFIED,
		"%c%c %2ld %s's bone" },
	{ N_MSG_FMT_COIN_IDENTIFIED,
		"%c%c %2ld %s" },
	{ N_MSG_FMT_COIN_NOT_IDENTIFIED,
		"%c%c %2ld %s" },
	{ N_MSG_FMT_JUNK_IDENTIFIED,
		"%c%c %2ld %s" },
	{ N_MSG_FMT_JUNK_NOT_IDENTIFIED,
		"%c%c %2ld %s" },

	{ N_MSG_INST_LIMIT,
		"(Limit)" },
	{ N_MSG_INST_SPELL,
		"(+%s)" },

	{ N_MSG_FMT_EQUIP_NULL,
		"%-*s:" },
	{ N_MSG_FMT_EQUIP,
		"%-*s: %s" },

	{ N_MSG_FMT_ART_NAME,
		" %-*s " STR_GOLD_SHORT_FMT_MAX },
	{ N_MSG_FMT_ART_NAME_EQUIP,
		"%-*s: %s" },

//@@@ begin
	{ N_MSG_FMT_IDENTIFY_ITEM,
		" %s " },
	{ N_MSG_FMT_MARK_MNSTR,
		"%s  %s ޡ" },

	{ N_MSG_ERR_ALLOC_MEM,
		"%ld byte Υ꡼ݽޤǤ" },

	{ N_MSG_ERR_DOOR_OPEN_JAMMED,
		"ɥꤵƤƳޤ" },
	{ N_MSG_ERR_DOOR_CLOSE_JAMMED,
		"ɥꤵƤĤޤ" },
	{ N_MSG_ERR_DOOR_CLOSE_BROKEN,
		"ɥƤĤޤ" },
	{ N_MSG_ERR_DOOR_JAM_SPIKE,
		"%s äƤޤ" },
	{ N_MSG_ERR_DOOR_JAM_BROKEN,
		"ɥƤƸޤ" },
	{ N_MSG_ERR_DOOR_JAM_JAMMED,
		"ɥϸꤵƤޤ" },
	{ N_MSG_ERR_DOOR_DISARM_NOT_JAM,
		"ɥϸꤵƤޤ" },
	{ N_MSG_ERR_DOOR_DISARM_BROKEN,
		"ɥϲƤޤ" },
	{ N_MSG_ERR_DOOR_DISARM_LEV,
		"ɥ" STR_DISARM "˼Ԥ" },
	{ N_MSG_ERR_DOOR_BREAK_SHOP,
		"ʤȤ򤷤ܤޤ" },
	{ N_MSG_ERR_DOOR_BREAK_BROKEN,
		"ɥϴ˲Ƥޤ" },
	{ N_MSG_ERR_DOOR_BREAK_LEV,
		"%s ϥɥޤǤ" },
	{ N_MSG_ERR_DOOR_GATE,
		"γˤϽФޤ" },

	{ N_MSG_ERR_TRAP_DISARM_LEV,
		"櫤" STR_DISARM "˼Ԥ" },
	{ N_MSG_ERR_TRAP_BREAK_LEV,
		"櫤ޤǤ" },

	{ N_MSG_ERR_ITEM_DISARM_LEV,
		"ƥ" STR_DISARM "˼Ԥ" },

	{ N_MSG_ERR_STAIRS,
		"Сʤ¦ˤޤ" },
	{ N_MSG_ERR_STAIRS_UP,
		"С곬ʤ¦ˤޤ" },
	{ N_MSG_ERR_STAIRS_DOWN,
		"С곬ʤ¦ˤޤ" },

	{ N_MSG_ERR_EQUIP_SEL_ITEM,
		"륢ƥबĤޤǤ" },
	{ N_MSG_ERR_CHK_KEY,
		"['%c': 0x%04lx] ̵ʥǤ" },
	{ N_MSG_ERR_REG_MACRO_BUF_OVERFLOW,
		"ޥΥϤĶޤ" },
	{ N_MSG_ERR_NOT_EXIST_ALL_MBR,
		"С1ͤ⤤ʤΤǽФޤ" },

	{ N_MSG_ERR_MENU_SEL_ITEM,
		"%s κξ֤Ǥޤ" },
	{ N_MSG_ERR_MENU_SEL_EQUIP,
		"%s κξ֤Ǥޤ" },
	{ N_MSG_ERR_MENU_MARK_BLIND,
		"%s ܤʤΤǥޡޤ" },
	{ N_MSG_ERR_MENU_NOT_EXIST_MBR,
		"С1ͤ⤤ޤ" },
	{ N_MSG_ERR_MENU_WANTING,
		"%s  " STR_GOLD_FMT " ­ޤ" },
	{ N_MSG_ERR_MENU_DATA_LEV_UP,
		"%s Ϸиͤ­ޤ" },
	{ N_MSG_ERR_MENU_SPELL_LEV,
		"%s ϥ٥뤬­ޤ" },
	{ N_MSG_ERR_MENU_SPELL_INST_LIMIT,
		"%s ϸǽʳڴƤޤ" },

	{ N_MSG_ERR_SHOP_CLOSE,
		"%s αĶȻ֤ %ld  %ld ޤǤǤ" },

	{ N_MSG_ERR_MENU_REQUEST,
		"ͭޤ" },
	{ N_MSG_ERR_MENU_REQUEST_MBR_CANCEL,
		"हΤˡ " STR_GOLD_FMT " ­ޤ" },

	{ N_MSG_ERR_MENU_NO_SAVE,
		"ɡ˥塼ѤΤǥֽޤ" },
	{ N_MSG_ERR_MENU_SAVE_N_SEL_AUTO,
		"ư֤ΥåȤˤϥֽޤ" },

	{ N_MSG_ERR_MENU_EDIT_CLASS,
		"פ 100% ˤƲ" },
	{ N_MSG_ERR_MENU_NEW_CLASS,
		"ʾ奯饹ޤ" },

	{ N_MSG_ERR_MENU_PET_SHOP_BUY,
		"ʾڥåȤޤ" },
	{ N_MSG_ERR_MENU_PET_SHOP_TAKE,
		"ʾڥåȤޤ" },
	{ N_MSG_ERR_MENU_PET_SHOP_LEAVE,
		"ʾڥåȤ¤ޤ" },
	{ N_MSG_ERR_MENU_PET_SHOP_NAME,
		"ڥåȤϻäƤޤ" },
	{ N_MSG_ERR_MENU_PET_SHOP_REMOVE,
		"ڥåȤϻäƤޤ" },

	{ N_MSG_ERR_MENU_PAGE_OVER,
		"˥塼Υڡ¿ޤ" },
	{ N_MSG_ERR_MENU_SRCH_PATH,
		"˥塼θԤޤ'%s'" },
	{ N_MSG_ERR_MENU_KIND,
		"˥塼ιܤμब۾Ǥ '%s'" },
	{ N_MSG_ERR_MENU_ACCEL_KEY,
		"졼ʣƤޤ '%c':'%s'" },
	{ N_MSG_ERR_MENU_SHORT_CUT_KEY,
		"硼ȥåȡʣƤޤ '%s':'%s'" },

	{ N_MSG_ERR_FILL_LAMP,
		"Ƥޤ" },
	{ N_MSG_ERR_FILL_LAMP_NON_OIL,
		"%s  %s ʳ뤷" },
	{ N_MSG_ERR_ATTACK_RANGE,
		"%s ιϤȤɤʤ" },
	{ N_MSG_ERR_THROW,
		"%s ꤲʪ̵ʤޤ" },
	{ N_MSG_ERR_THROW_RANGE,
		"%s ꤲʪϤȤɤʤ" },
	{ N_MSG_ERR_MNSTR_NULL,
		"ˤϥ󥹥Ϥޤ" },
	{ N_MSG_ERR_NOT_FIND,
		"%s  %s ޤ" },
	{ N_MSG_ERR_ITEM_CURSE,
		"%s ϼƤƳޤ" },
	{ N_MSG_ERR_ITEM_FULL,
		"%s ϻʪäѤǤ" },
	{ N_MSG_ERR_ITEM_FLY,
		"%s ⤫ǤΤǥƥ򽦤ޤ" },
	{ N_MSG_ERR_GIVE_MBR_ITEM,
		"%s ϻʪäѤǥƥƤޤ" },
	{ N_MSG_ERR_GIVE_MBR_CHEST,
		"%s ϽŤƤʾ奢ƥƤޤ" },
	{ N_MSG_ERR_ITEM_BREAK_BROKEN,
		"%s ϴ˲Ƥޤ" },
	{ N_MSG_ERR_ITEM_BREAK_LEV,
		"%s ޤǤ" },
	{ N_MSG_ERR_EQUIP_TWO_HANDED_WPN,
		"%s ξȽƱޤ" },

	{ N_MSG_ERR_REMOVE_CLASS,
		"ʾ奯饹ޤ" },

	{ N_MSG_ERR_ITEM_RATIO,
		"ƥνиǡ۾Ǥ (%ld/%ld)" },
	{ N_MSG_ERR_POTION_COLOR,
		"ο̾ǡ۾Ǥ" },
	{ N_MSG_ERR_STICK_MATERIAL,
		"κ̾ǡ۾Ǥ" },
	{ N_MSG_ERR_ACCE_MATERIAL,
		"κ̾ǡ۾Ǥ" },
	{ N_MSG_ERR_WPN_RATE_TAB,
		"ǡ۾Ǥ" },
	{ N_MSG_ERR_MNSTR_LEV_TAB,
		"󥹥Υ٥롦ǡ۾Ǥ" },
	{ N_MSG_ERR_SET_TTY,
		"ü꤬ޤǤ" },
	{ N_MSG_ERR_HOME_DIR,
		"ۡࡦǥ쥯ȥ '%s' ꤬"
		"ޤǤ" },
	{ N_MSG_ERR_GAME_DIR_SAVE,
		"'%s'˽񤭹ޤǤ" },
	{ N_MSG_ERR_FILE_VER_A,
		"ǡեΥС %ld.%ld.%ld "
		"бƤޤ" },
	{ N_MSG_ERR_FILE_VER_B,
		"ΤǿǤ˥åץǡȤƲ" },

	{ N_MSG_ERR_TOWN_MAP,
		"ޥåסǡ۾Ǥ" },
	{ N_MSG_ERR_TOWN_MAP_X_SIZE,
		"ޥåסǡοʿ㤤ޤ %ld/%ld" },
	{ N_MSG_ERR_TOWN_MAP_Y_SIZE,
		"ޥåסǡοľ㤤ޤ %ld/%ld" },
	{ N_MSG_ERR_TOWN_MAP_STR_LEN,
		"ޥåסǡοɽʸĹ"
		"12ʸˤƲ %ld" },
	{ N_MSG_ERR_TOWN_MAP_SHOP,
		"ޥåסǡäƤʤåפͭޤ" },

	{ N_MSG_ERR_RC,
		"ե˥顼ͭޤ" },

	/* Lex */

	{ N_MSG_ERR_RC_LEX,
		"۾ʥȡǤ ['%c', 0x%04lx]" },
	{ N_MSG_ERR_RC_LEX_CHAR,
		"ʸĤƤޤ" },
	{ N_MSG_ERR_RC_LEX_STR,
		"ʸĤƤޤ" },

	/* Parse */

	{ N_MSG_ERR_RC_PARSE,
		"ʸְäƤޤ" },
	{ N_MSG_ERR_RC_PARSE_DEF_ID,
		"ѿְ̾äƤޤ" },
	{ N_MSG_ERR_RC_PARSE_NUM,
		"ͤꤷƲ" },
	{ N_MSG_ERR_RC_PARSE_STR,
		"ʸꤷƲ" },
	{ N_MSG_ERR_RC_PARSE_CHAR,
		"ʸꤷƲ" },
	{ N_MSG_ERR_RC_PARSE_COMMA,
		"','ͭޤ" },
	{ N_MSG_ERR_RC_PARSE_SKIP_CHAR,
		"'%c'ͭޤ" },
	{ N_MSG_ERR_RC_PARSE_CHR_ID,
		"饯˥ԡޤ" },

	/* Data Load */

	{ N_MSG_ERR_LOAD_BIN,
		"ǡե뤬Ƥޤ" },
	{ N_MSG_ERR_LOAD_WQUOTE,
		"'\"' ͭޤ" },
	{ N_MSG_ERR_LOAD_LINE_LEN,
		"Ԥʸ礤ޤ %ld/%ld" },
	{ N_MSG_ERR_LOAD_EOF,
		"ե뤬ڤƤޤ" },
	{ N_MSG_ERR_LOAD_GAME_HEAD,
		"إå۾Ǥ" },

	/* Data Save */

	{ N_MSG_ERR_SAVE_TOWN_PTN,
		"ޥåסǡֽޤǤ" },
	{ N_MSG_ERR_SAVE_CRSR_PTN,
		"롦ѥ󤬥ֽޤǤ" },

	/* Graph Conf Load */

	{ N_MSG_ERR_LOAD_GRAPH_CONF_HEAD,
		"إå۾Ǥ" },

	/* file */

	{ N_MSG_WRN_RENAME,
		"ե̾ѹޤ\n\t'%s' ->\n\t'%s'" },
	{ N_MSG_WRN_CHK_ID,
		"ID:\n'%s'\n'%s'" },
//@@@ end

	/* Copyright */

	{ N_MSG_FMT_COPYRIGHT,
		STR_FMT_COPYRIGHT },

	{ N_MSG_ABOUT_GAME,
		"This program is free software; you can redistribute"
		" it and/or\n"
		"modify it under the terms"
		" of the GNU General Public License\n"
		"as published by the Free Software Foundation;"
		" either version 2\n"
		"of the License, or (at your option) any later version.\n"
		"\n"
		"This program is distributed in the hope"
		" that it will be useful,\n"
		"but WITHOUT ANY WARRANTY;"
		" without even the implied warranty of\n"
		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE."
		"  See the\n"
		"GNU General Public License for more details.\n"
		"\n"
		"You should have received a copy"
		" of the GNU General Public License\n"
		"along with this program; if not,"
		" write to the Free Software\n"
		"Foundation, Inc., 59 Temple Place - Suite 330,"
		" Boston, MA  02111-1307, USA.\n"
	},

#undef	STR_GOLD
#undef	STR_GOLD_FMT
#undef	STR_GOLD_FMT_MAX

#undef	STR_SQUARE

#undef	STR_EQUIP_WIELDING
#undef	STR_EQUIP_SHIELD
#undef	STR_EQUIP_BOW
#undef	STR_EQUIP_ARW
#undef	STR_EQUIP_HEAD
#undef	STR_EQUIP_NECK
#undef	STR_EQUIP_BODY
#undef	STR_EQUIP_ARM
#undef	STR_EQUIP_RIGHT_HAND
#undef	STR_EQUIP_LEFT_HAND
#undef	STR_EQUIP_FEET
#undef	STR_EQUIP_ABOUT_BODY
#undef	STR_EQUIP_LIGHT_SOURCE

#undef	STR_DISARM
#undef	STR_GOLD

#undef	STR_FIG
#undef	STR_MON
#undef	STR_HUN
#undef	STR_THI

#undef	STR_MAG
#undef	STR_SOR
#undef	STR_ENC
#undef	STR_SUM
#undef	STR_PRI
#undef	STR_SHA
#undef	STR_BAR
#undef	STR_NIN
