/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2008 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: menu.h,v 1.47 2008/04/18 23:05:34 bowkenken Exp $
***************************************************************/

#ifndef	MENU_H
#define	MENU_H

/* ˥塼 */

#include	"item.h"
#include	"party.h"
#include	"msg.h"

/***************************************************************/

/****  ****/

#define	STR_MENU_ERR	"# Error"
#define	STR_MENU_CANCEL	".."

/**** ˥塼ѤΥ ****/

#define	CASE_ENTER	\
		'M' - '@': case 'J' - '@'
#define	CASE_CANCEL	\
		'G' - '@': case 'H' - '@': case '0': case '\033'
#define	CASE_EXEC	\
		'5': case '.'
#define	CASE_EXIT	\
		'Q': case 'Q' - '@': case 'C' - '@'
#define	CASE_SQUARE	\
		'v': case '+'

#define	CASE_CRSR_UP	\
		'8': case 'k': case 'w': case 'P' - '@'
#define	CASE_CRSR_DOWN	\
		'2': case 'j': case 's': case 'N' - '@'
#define	CASE_CRSR_LEFT	\
		'4': case 'h': case 'a': case 'B' - '@'
#define	CASE_CRSR_RIGHT	\
		'6': case 'l': case 'd': case 'F' - '@'
#define	CASE_CRSR_UP_LEFT	\
		'7': case 'y'
#define	CASE_CRSR_UP_RIGHT	\
		'9': case 'u'
#define	CASE_CRSR_DOWN_LEFT	\
		'1': case 'b'
#define	CASE_CRSR_DOWN_RIGHT	\
		'3': case 'n'

/* ܤκʸ */
#define	MENU_MAX_LEN	(SCREEN_WIDTH - 4)

/* ڡκܿ */
#define	MENU_MAX_N_PER_PAGE	18

/* ڡ */
#define	MENU_MAX_PAGE	32

/* ܿ */
#define	MENU_MAX_N	(MENU_MAX_N_PER_PAGE * MENU_MAX_PAGE)

/* ̵ */
#define	FLG_MENU_DIS	(1 << 0)

/* ɽ */
#define	FLG_MENU_HIDDEN	(1 << 1)

/* å */
#define	FLG_MENU_CHK_ON	(1 << 4)

/* å */
#define	FLG_MENU_CHK_OFF	(1 << 5)

#define	FLG_MENU_ALL	\
	(FLG_MENU_DIS | FLG_MENU_HIDDEN \
	| FLG_MENU_CHK_ON | FLG_MENU_CHK_OFF)

/* ˥塼ѥκʸ */
#define	MENU_PATH_MAX_LEN	64

/* ܤμκʸ */
#define	MENU_KIND_MAX_LEN	16

/* ޥκʸ */
#define	MACRO_MAX_LEN	256

/* 硼ȡåȡκʸ */
#define	MENU_SHORT_KEY_MAX_LEN	16

/* ܤκʸ */
#define	MENU_MSG_MAX_LEN	(80 * 6 / 2)

/**** ֡ ****/

#define	MENU_SAVE_LOAD_MAX_N	40
#define	MENU_SAVE_LOAD_N_PER_PAGE	10

/**** 饯 ****/

/* 饯ȤΥڡ򥫡롦Ǥ᤯뤫? */
/* TRUE ξ硢롦ǥڡ˥塼ǥС᤯ */
/* FALSE ξ硢롦ǥС˥塼ǥڡ᤯ */
#define	MBR_DATA_CHANGE_PAGE_IS_CRSR	TRUE

/* 饯Ȥκڡ */
#define	MBR_DATA_PAGE_MAX_N	4

/**** 桼˥塼 ****/

/* 桼˥塼κܿ */
#define	USER_MENU_MAX_N	(MENU_MAX_N_PER_PAGE * 4)

/**** ޥɡ˥塼 ****/

#define	MENU_COMMAND_KEY_CHAR	':'
#define	MENU_COMMAND_KEY_STR	":"
#define	MENU_COMMAND_MAX_LEN	2048

/**** ˥塼Υ롦Хåؿ ****/

struct menu_t;
typedef char	*(*menu_call_back_t)(
	struct menu_t **pp, struct menu_t **dflt );

/**** ޥåפΥ ****/

typedef unsigned long	flg_scroll_t;
#define	FLG_SCROLL_SMOOTH	(1 << 0)
#define	FLG_SCROLL_CENTER	(1 << 1)

/**** ե󥯥󡦥 ****/

/* ե󥯥󡦥κ */
#define	FUNC_KEY_MAX	80

/**** ޥ⡼бե󥯥󡦥 ****/

typedef enum {
	FUNC_N_CLICK_L = 21,
	FUNC_N_CLICK_M,
	FUNC_N_CLICK_R,
	FUNC_N_CLICK_0 = FUNC_N_CLICK_L,

	FUNC_N_DBL_CLICK_L = 31,
	FUNC_N_DBL_CLICK_M,
	FUNC_N_DBL_CLICK_R,
	FUNC_N_DBL_CLICK_0 = FUNC_N_DBL_CLICK_L,

	FUNC_N_PRESS_L_CLICK_R = 41,
	FUNC_N_PRESS_R_CLICK_L,

	FUNC_N_PRESS_L = 51,
	FUNC_N_PRESS_M,
	FUNC_N_PRESS_R,
	FUNC_N_PRESS_0 = FUNC_N_PRESS_L,

	FUNC_N_RELEASE_L = 61,
	FUNC_N_RELEASE_M,
	FUNC_N_RELEASE_R,
	FUNC_N_RELEASE_0 = FUNC_N_RELEASE_L,

	FUNC_N_MOTION_LEFT = 71,
	FUNC_N_MOTION_RIGHT,
	FUNC_N_MOTION_UP,
	FUNC_N_MOTION_DOWN,
} func_n_t;

/***************************************************************/

/* ˥塼 */

typedef struct menu_t {
	/* ڹ¤Υѥ */
	char	path[MENU_PATH_MAX_LEN + 1];
	/* ܤμ */
	char	kind[MENU_KIND_MAX_LEN + 1];

	/* 졼 */
	unsigned char	accel_key;
	/* 硼ȡåȡ */
	char	short_key[MENU_SHORT_KEY_MAX_LEN + 1];

	/* ̾ */
	n_msg_t	n_msg;
	char	msg[MENU_MSG_MAX_LEN + 1];

	/* 롦Хåؿ */
	menu_call_back_t	call_back;
	/* 롦Хåؿؤΰ */
	void	*arg;

	/* ե饰 */
	unsigned long	flg;
} menu_t;

typedef struct {
	/* ȥ */
	char	*ttl;

	/* Υ˥塼Υꥹ */
	menu_t	*ls[MENU_MAX_N_PER_PAGE + 1];

	/* 򤵤Ƥܤֹ */
	long	sel_n, prev_sel_n;

	/* ڡ */
	long	page_sel_n, page_max_n;

	/* ƬǽڡǤЯΥե饰 */
	bool_t	flg_min_page, flg_max_page;

	/* ե饰 */
	bool_t	flg_redraw;
} draw_menu_t;

/* Ϥ */

typedef enum {
	ASK_NO,
	ASK_YES,
	ASK_CANCEL,
	ASK_ERR,
} ask_t;

/* μ */

typedef enum {
	DEAL_KIND_BUY,	/* 㤦 */
	DEAL_KIND_SALE_ITEM,	/* ƥ */
	DEAL_KIND_SALE_EQUIP,	/*  */
} deal_kind_t;

/*  */

typedef enum {
	MENU_NUM_MIN,
	MENU_NUM_MAX,
	MENU_NUM_CLR,
	MENU_NUM_OK,
	MENU_NUM_MAX_N
} menu_num_t;

/* ϥ */

#define	KEY_MENU_NUM_OK	'Z'
#define	KEY_MENU_NUM_CLR	'Y'
#define	KEY_MENU_NUM_MAX	'X'
#define	KEY_MENU_NUM_MIN	'W'
#define	KEY_MENU_NUM_SGN	'V'

/* ֥ */

typedef enum {
	NEXT_POS_KIND_SQUARE,
	NEXT_POS_KIND_MBR,
	NEXT_POS_KIND_MNSTR,
	NEXT_POS_KIND_DOOR,
	NEXT_POS_KIND_OBJ,
} next_pos_kind_t;

typedef struct {
	next_pos_kind_t	kind;
	void	*p;
	long	n;
	int	x, y;
} next_pos_t;

/* СǡԽ⡼ */

typedef enum {
	MBR_DATA_EDIT_KIND_SHOW,	/* ɽΤ */
	MBR_DATA_EDIT_KIND_EDIT,	/* Խ */
	MBR_DATA_EDIT_KIND_NEW,	/*  */
	MBR_DATA_EDIT_KIND_MAX_N,
} mbr_data_edit_kind_t;

#endif	/* MENU_H */
