/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2008 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: Pcg.h,v 1.17 2008/10/07 00:41:48 bowkenken Exp $
***************************************************************/

#ifndef PCG_H
#define PCG_H	1

////////////////////////////////////////////////////////////////
// եåѥ
////////////////////////////////////////////////////////////////

#ifdef D_WS
# include <WSCimageSet.h>
# include <WSDmwindowDev.h>
# include <WSCstring.h>
#endif // D_WS

#ifdef D_GTK
# include "GtkWSDimage.h"
# include "GtkWSDmwindowDev.h"
# include "GtkWSCstring.h"
#endif // D_GTK

#ifdef D_MFC
# include "MfcWSDimage.h"
# include "MfcWSDmwindowDev.h"
# include "MfcWSCstring.h"
#endif // D_MFC

class Pcg {
private:
	// ǽԤκԤ֤Υǥեȡʥߥá
	static const long nWaitReadyMSecDflt = 100;

	// եåեΥѥ̾
	WSCstring sPath;
	// եåѥ
	WSDimage *pImage;

public:
	// ꥹȤμι
	Pcg *next;
	// 緿Υѥ
	Pcg *hyper_boss;
	// ѥΥХꥨλΨ
	ratio_t nRatio;
	// ѥΥХꥨλΨ
	rate_t nRate;
	char mjr, mnr;

	// ǽԤκԤ֡ʥߥá
	long nWaitReadyMSec;

public:
	Pcg()
	{
		nWaitReadyMSec = nWaitReadyMSecDflt;

		pImage = NULL;
		next = NULL;
		hyper_boss = NULL;
		nRatio = (ratio_t)1;
		nRate = _100_PERCENT;
		mjr = FACE_MJR_NULL;
		mnr = FACE_MNR_NULL;
	}
	~Pcg()
	{
		if( hyper_boss != NULL ){
			delete hyper_boss;
			hyper_boss = NULL;
		}

		if( pImage != NULL ){
			pImage->destroyImage();
			delete pImage;
			pImage = NULL;
		}
	}

	void init( WSCstring path );
	void load( WSCstring path );
	void ena();
	void dis();

	WSCstring getPath();
	WSCstring getName();

	long getWidth();
	long getHeight();

	bool waitReady( WSDmwindowDev *mDev );

	bool beginAlpha();
	bool endAlpha();

	bool draw( WSDmwindowDev *mDev,
			long x, long y, long dx, long dy );
	bool drawFix( WSDmwindowDev *mDev,
			long x, long y, long dx, long dy );
	bool drawIdx( WSDmwindowDev *mDev,
			long x, long y, long w, long h,
			long idxX, long idxY,
			long sizeX, long sizeY );
	bool drawOffset( WSDmwindowDev *mDev,
			long x, long y, long w, long h,
			long offsetX, long offsetY );

private:
};

#endif /* PCG_H */
