/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2008 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: last-boss.c,v 1.7 2008/10/07 10:27:00 bowkenken Exp $
***************************************************************/

/***************************************************************
* 饹ܥ
***************************************************************/

#define	LAST_BOSS_C
#include	"inc.h"

/***************************************************************
* ѿ
***************************************************************/

const long	EXEL_JUMP_MAX_Y = AREA_MAX_Y;
const long	WAIT_FRAME_N = ANIM_FRAME_N * 6 / 60;

/***************************************************************
* 
***************************************************************/

void	init_last_boss( void )
{
}

/***************************************************************
* ƥåѿꥻå
***************************************************************/

void	reset_static_last_boss( void )
{
}

/***************************************************************
* ǥ椫å
* return : ǥ椫?
***************************************************************/

bool_t	chk_last_boss_demo( void )
{
	if( get_scene() != SCENE_N_LAST_BOSS )
		return FALSE;

	switch( get_last_scene() ){
	case LAST_SCENE_N_NULL:
	case LAST_SCENE_N_ENTER:
		break;
	case LAST_SCENE_N_ENCOUNTER:
	case LAST_SCENE_N_ENCOUNTER_CUT_IN:
	case LAST_SCENE_N_ENCOUNTER_WORDS:
	case LAST_SCENE_N_ENCOUNTER_CUT_OUT:
	case LAST_SCENE_N_ENCOUNTER_CUT_END:
		return TRUE;
	case LAST_SCENE_N_EXEL:
	case LAST_SCENE_N_EXEL_ENTER:
	case LAST_SCENE_N_EXEL_CUT_IN:
	case LAST_SCENE_N_EXEL_WORDS:
	case LAST_SCENE_N_EXEL_CUT_OUT:
	case LAST_SCENE_N_EXEL_CUT_END:
	case LAST_SCENE_N_EXEL_HYPER:
		return TRUE;
	case LAST_SCENE_N_EXEL_BATTLE:
		break;
	case LAST_SCENE_N_EXEL_DIE:
		return TRUE;
	case LAST_SCENE_N_EXELER:
	case LAST_SCENE_N_EXELER_CUT_IN:
	case LAST_SCENE_N_EXELER_WORDS:
	case LAST_SCENE_N_EXELER_CUT_OUT:
	case LAST_SCENE_N_EXELER_CUT_END:
	case LAST_SCENE_N_EXELER_ENTER:
	case LAST_SCENE_N_EXELER_HYPER:
		return TRUE;
	case LAST_SCENE_N_EXELER_BATTLE:
		break;
	case LAST_SCENE_N_EXELER_DIE:
		return TRUE;
	case LAST_SCENE_N_XEX:
	case LAST_SCENE_N_XEX_CUT_IN:
	case LAST_SCENE_N_XEX_WORDS:
	case LAST_SCENE_N_XEX_CUT_OUT:
	case LAST_SCENE_N_XEX_CUT_END:
		return TRUE;
	case LAST_SCENE_N_END:
	case LAST_SCENE_N_MAX_N:
		break;
	}

	return FALSE;
}

/***************************************************************
* ˱ƥǥ
***************************************************************/

void	draw_last_boss( void )
{
	last_scene_n_t	sc;
	bool_t	flg_next_cui, flg_next_gui;

	if( get_scene() != SCENE_N_LAST_BOSS )
		return;

	sc = get_last_scene();
	flg_next_gui = call_demo_last_boss_check_done();
	flg_next_cui = TRUE;

	switch( sc ){
	case LAST_SCENE_N_NULL:
		break;
	case LAST_SCENE_N_ENTER:
		flg_next_cui = FALSE;
		break;
	case LAST_SCENE_N_ENCOUNTER:
		scroll_last_boss();
		break;
	case LAST_SCENE_N_ENCOUNTER_CUT_IN:
		break;
	case LAST_SCENE_N_ENCOUNTER_WORDS:
		draw_words_xex( MSG_WORDS_LAST_BOSS_ENCOUNTER_XEX_1 );
		draw_words_xex( MSG_WORDS_LAST_BOSS_ENCOUNTER_XEX_2 );
		draw_words_xex( MSG_WORDS_LAST_BOSS_ENCOUNTER_XEX_3 );
		draw_words_xex( MSG_WORDS_LAST_BOSS_ENCOUNTER_XEX_4 );
		draw_words_xex( MSG_WORDS_LAST_BOSS_ENCOUNTER_XEX_5 );
		draw_words_xex( MSG_WORDS_LAST_BOSS_ENCOUNTER_XEX_6 );
		draw_words_xex( MSG_WORDS_LAST_BOSS_ENCOUNTER_XEX_7 );
		draw_words_xex( MSG_WORDS_LAST_BOSS_ENCOUNTER_XEX_8 );
		draw_words_xex( MSG_WORDS_LAST_BOSS_ENCOUNTER_XEX_9 );
		draw_words_xex( MSG_WORDS_LAST_BOSS_ENCOUNTER_XEX_10 );
		draw_words_exel( MSG_WORDS_LAST_BOSS_ENCOUNTER_EXEL_1 );
		draw_words_exeler( MSG_WORDS_LAST_BOSS_ENCOUNTER_EXELER_1 );
		break;
	case LAST_SCENE_N_ENCOUNTER_CUT_OUT:
		break;
	case LAST_SCENE_N_ENCOUNTER_CUT_END:
		redraw_all();
		break;
	case LAST_SCENE_N_EXEL:
		scroll_last_boss();
		break;
	case LAST_SCENE_N_EXEL_ENTER:
		draw_exel_enter();
		break;
	case LAST_SCENE_N_EXEL_CUT_IN:
		break;
	case LAST_SCENE_N_EXEL_WORDS:
		draw_words_exel( MSG_WORDS_LAST_BOSS_EXEL_1 );
		break;
	case LAST_SCENE_N_EXEL_CUT_OUT:
		break;
	case LAST_SCENE_N_EXEL_CUT_END:
		redraw_all();
		break;
	case LAST_SCENE_N_EXEL_HYPER:
	case LAST_SCENE_N_EXEL_BATTLE:
		break;
	case LAST_SCENE_N_EXEL_DIE:
		draw_words_exel( MSG_WORDS_LAST_BOSS_EXEL_DIE_1 );
		redraw_all();
		break;
	case LAST_SCENE_N_EXELER:
		scroll_last_boss();
		break;
	case LAST_SCENE_N_EXELER_CUT_IN:
		break;
	case LAST_SCENE_N_EXELER_WORDS:
		draw_words_exeler( MSG_WORDS_LAST_BOSS_EXELER_1 );
		draw_words_exeler( MSG_WORDS_LAST_BOSS_EXELER_2 );
		break;
	case LAST_SCENE_N_EXELER_CUT_OUT:
		break;
	case LAST_SCENE_N_EXELER_CUT_END:
		redraw_all();
		break;
	case LAST_SCENE_N_EXELER_ENTER:
	case LAST_SCENE_N_EXELER_HYPER:
	case LAST_SCENE_N_EXELER_BATTLE:
		break;
	case LAST_SCENE_N_EXELER_DIE:
		draw_words_exeler( MSG_WORDS_LAST_BOSS_EXELER_DIE_1 );
		redraw_all();
		break;
	case LAST_SCENE_N_XEX:
		scroll_last_boss();
		break;
	case LAST_SCENE_N_XEX_CUT_IN:
		break;
	case LAST_SCENE_N_XEX_WORDS:
		draw_words_xex( MSG_WORDS_LAST_BOSS_XEX_1 );
		draw_words_xex( MSG_WORDS_LAST_BOSS_XEX_2 );
		draw_words_xex( MSG_WORDS_LAST_BOSS_XEX_3 );
		break;
	case LAST_SCENE_N_XEX_CUT_OUT:
		break;
	case LAST_SCENE_N_XEX_CUT_END:
		redraw_all();
		break;
	case LAST_SCENE_N_END:
	case LAST_SCENE_N_MAX_N:
		flg_next_cui = FALSE;
		break;
	}

	if( flg_next_cui && flg_next_gui ){
		sc++;
		if( sc > LAST_SCENE_N_END )
			sc = LAST_SCENE_N_END;

		call_demo_last_boss_reset();
		change_last_scene( sc );
	}
}

/***************************************************************
* ɽ
* const char *str : 
***************************************************************/

void	draw_words_exel( const char *str )
{
	print_words( MSG_MNSTR_EXEL, MALE, str, str );
	draw_words( str );
}

/***************************************************************
* 顼ɽ
* const char *str : 
***************************************************************/

void	draw_words_exeler( const char *str )
{
	print_words( MSG_MNSTR_EXELER, FEMALE, str, str );
	draw_words( str );
}

/***************************************************************
* ɽ
* const char *str : 
***************************************************************/

void	draw_words_xex( const char *str )
{
	print_words( MSG_MNSTR_XEX, MALE, str, str );
	draw_words( str );
}

/***************************************************************
* оǥ
***************************************************************/

void	draw_exel_enter( void )
{
	mnstr_t	*p;
	long	x, y;
	long	bgn_x, bgn_y;
	long	dy;

	p = get_last_boss( LAST_BOSS_KIND_EXEL );
	if( p == NULL )
		return;

	bgn_x = p->x;
	bgn_y = p->y;

	for( dy = 0; dy < EXEL_JUMP_MAX_Y; dy++ ){
		x = bgn_x;
		y = bgn_y - dy;

		clr_map_chr( p );
		p->x = x;
		p->y = y;
		set_map_chr( p );

		draw_mnstr( p );
		wait_frame( WAIT_FRAME_N );
	}

	for( dy = EXEL_JUMP_MAX_Y; dy >= 0; dy-- ){
		x = bgn_x;
		y = bgn_y - dy;

		clr_map_chr( p );
		p->x = x;
		p->y = y;
		set_map_chr( p );

		draw_mnstr( p );
		wait_frame( WAIT_FRAME_N );
	}
}

/***************************************************************
* 饹ܥΥǥ򳫻
***************************************************************/

void	begin_last_boss_event( long x, long y )
{
	if( get_last_scene() >= LAST_SCENE_N_ENCOUNTER )
		return;

	scroll_last_boss();
	change_last_scene( LAST_SCENE_N_ENCOUNTER );
}

/***************************************************************
* 饹ܥΥǥ˹碌ƥޥåפ򥹥
***************************************************************/

void	scroll_last_boss( void )
{
	pos_t	pos;

	appear_party_map_event( MAP_EVENT_LAST_BOSS_BATTLE );

	pos = get_map_event_pos( MAP_EVENT_LAST_BOSS_SCROLL_MAP );
	scroll_map( pos.x, pos.y );
}
