/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2009 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: GlobalVar.h,v 1.32 2009/02/14 04:44:02 bowkenken Exp $
***************************************************************/

#ifndef GLOBAL_VAR_H
#define GLOBAL_VAR_H	1

#ifdef D_WS
# include <WSCvlabel.h>
# include <WSCvdrawingArea.h>
#endif // D_WS

#ifdef D_GTK
# include <gtk/gtk.h>
# include <gdk-pixbuf/gdk-pixbuf.h>
#endif // D_GTK

#ifdef D_WS
typedef int gint;
typedef long glong;
typedef long GtkWidget;
typedef void *gpointer;
typedef long GdkEventExpose;
typedef long GtkAdjustment;
typedef long GtkButton;
#endif // D_WS

#include "party.h"
#include "SelConf.h"
#include "GuiMenu.h"
#include "GuiMessage.h"
#include "GuiStat.h"
#include "GuiNum.h"
#include "GuiInputString.h"
#include "GuiWords.h"
#include "GuiReplay.h"
#include "GuiClassEdit.h"
#include "GuiSkillEdit.h"
#include "GuiChrSheet.h"
#include "SelMbrGraph.h"
#include "WinPos.h"
#include "FileList.h"
#include "PcgDun.h"
#include "GameMusic.h"
#include "GameSound.h"
#include "GameJoystick.h"
#include "Key.h"
#include "MouseMotion.h"

#ifdef D_WS
# include "StatWinIdx.h"
#endif // D_WS

#ifdef D_GTK
# include "GuiStat.h"
#endif // D_GTK

#ifdef D_MFC
# include "xlnl-dows/Dir3d.h"
#endif // D_MFC

////////////////////////////////////////////////////////////////
// GUI طΥХѿ
////////////////////////////////////////////////////////////////

// եå
extern SelConf gSelConf;

// ˥塼ɥ
extern GuiMenu gGuiMenu;

// åɥ
extern GuiMessage gGuiMessage;

// ơɥ
extern GuiStat gGuiStat;

// ϥɥ
extern GuiNum gGuiNum;

// ʸϡɥ
extern GuiInputString gGuiInpStr;

// 쥦ɥ
extern GuiWords gGuiWords;

// ץ쥤ɥ
extern GuiReplay gGuiReplay;

// 饹ǥɥ
extern GuiClassEdit gGuiClassEdit;

// 롦ǥɥ
extern GuiSkillEdit gGuiSkillEdit;

// 饯ȡɥ
extern GuiChrSheet gGuiChrSheet;

// СΥեåѥ
extern SelMbrGraph *gSelMbrGraph;

// ɥκɸ
extern WinPos gWinPos[WIN_KIND_MAX_N];

// 󥸥ƤΥ饯ǡ
extern PcgDun gPcgDun;

// BGM δ
extern GameMusic gMusic;

// SE δ
extern GameSound gSound;

// 祤ƥåδ
extern GameJoystick gJoystick;

// ϴǡ
extern Key gKey;

// ޥΥ⡼Ϥδǡ
extern MouseMotion gMouseMotion;

// ޥåסɥΥɥåϺɸ
extern long gMapDragBgnX, gMapDragBgnY;

//
extern long nCharWidth;
extern long nCharHeight;
extern long nMarginX;
extern long nMarginY;

#ifdef D_WS
extern WSCbase *gStatLabel[MBR_MAX_N][STAT_WIN_IDX_MAX_N];
# endif // D_WS

#ifdef D_GTK
extern GtkWidget *gMapWin;

extern GtkWidget *gMapButtonContExec;

extern GtkWidget *gMapDrawingArea;
extern GtkObject *gMapHScrollBarAdjustment;
extern GtkObject *gMapVScrollBarAdjustment;
extern GtkWidget *gMapHScrollBar;
extern GtkWidget *gMapVScrollBar;

// ơɥ
extern GuiStat gGuiStat;
#endif // D_GTK

#ifdef D_MFC
extern volatile bool gFlagInitMfcDone;
extern bool gFlagExit;
extern CDir3d g_Dir3d;
#endif // D_MFC

#endif /* GLOBAL_VAR_H */
