/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2009 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: curs.h,v 1.41 2009/08/09 07:37:02 bowkenken Exp $
***************************************************************/

#ifndef	CURS_H
#define	CURS_H

/***************************************************************
* curses Υåѡ
***************************************************************/

#include	"extern.h"
#include	"msg.h"

#if	defined( HAVE_NCURSESW_H )
# include	<ncursesw.h>
# ifndef	COLOR_WHITE
#  include	"curs-def.h"
# endif
#elif	defined( HAVE_NCURSES_H )
# include	<ncurses.h>
# ifndef	COLOR_WHITE
#  include	"curs-def.h"
# endif
#elif	defined( HAVE_CURSES_H )
# include	<curses.h>
# ifndef	COLOR_WHITE
#  include	"curs-def.h"
# endif
#else
# include	"curs-def.h"
#endif

/***************************************************************
* 
***************************************************************/

/* üΥѹ٥ */

#ifndef	KEY_RESIZE
# define KEY_RESIZE	0632		/* Terminal resize event */
#endif	/* KEY_RESIZE */

/***************************************************************
* °
***************************************************************/

typedef enum {
	CURS_ATTR_N_NORMAL,
	CURS_ATTR_N_REV,
	CURS_ATTR_N_ERR,
	CURS_ATTR_N_MENU_NORMAL,
	CURS_ATTR_N_MENU_DIS,
	CURS_ATTR_N_MENU_SEL,
	CURS_ATTR_N_MAP_ITEM,
	CURS_ATTR_N_MAP_SQUARE,
	CURS_ATTR_N_MAP_MNSTR,
	CURS_ATTR_N_MAP_NPC,
	CURS_ATTR_N_MAP_CRSR,

	CURS_ATTR_N_FX_MBR_PLUS,
	CURS_ATTR_N_FX_MBR_MINUS,
	CURS_ATTR_N_FX_MBR_CRTCL,
	CURS_ATTR_N_FX_MNSTR_PLUS,
	CURS_ATTR_N_FX_MNSTR_MINUS,
	CURS_ATTR_N_FX_MNSTR_CRTCL,
	CURS_ATTR_N_VFX,

	CURS_ATTR_N_MBR_1,
	CURS_ATTR_N_MBR_2,
	CURS_ATTR_N_MBR_3,
	CURS_ATTR_N_MBR_4,
	CURS_ATTR_N_MBR_5,
	CURS_ATTR_N_MBR_6,

	CURS_ATTR_N_HEAT,
	CURS_ATTR_N_COLD,
	CURS_ATTR_N_MIND,
	CURS_ATTR_N_ACID,

	CURS_ATTR_MAX_N,

	CURS_ATTR_N_MAP_NORMAL = CURS_ATTR_N_NORMAL,
} curs_attr_n_t;

typedef unsigned long	chtype_t;

typedef struct {
	short	color_pair_n;
	n_msg_t	name_n;
	int	fg, bg;
	chtype_t	attr;
} curs_attr_t;

/***************************************************************
* ̥
***************************************************************/

#define	SCREEN_SIZE_MIN_COL	(2 + 1 + 1)
#define	SCREEN_SIZE_MAX_COL	(1024 * 2)
#define	SCREEN_SIZE_MIN_ROW	(1 + 1 + 1)
#define	SCREEN_SIZE_MAX_ROW	1024

#endif	/* CURS_H */
