/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2009 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: nest-flg.c,v 1.10 2009/06/26 16:58:16 bowkenken Exp $
***************************************************************/

/***************************************************************
* ͥȲǽե饰
***************************************************************/

#include	"gmain.h"
#include	"nest-flg.h"
#include	"gmain-prot.h"
#include	"nest-flg-prot.h"

/***************************************************************/

static long	g_nest_flg[NEST_FLG_MAX_N];
check_memory_def( check_memory_nest_flg_c_g_nest_flg )
static long	g_nest_flg_n;
check_memory_def( check_memory_nest_flg_c_g_nest_flg_n )

/***************************************************************
* ƥåѿꥻå
***************************************************************/

void	reset_static_nest_flg( void )
{
}

/***************************************************************
* ե饰κ
* return : ե饰ֹreturn <= -1 顼
***************************************************************/

long	make_nest_flg( void )
{
	if( g_nest_flg_n + 1 > NEST_FLG_MAX_N )
		return -1;

	g_nest_flg[g_nest_flg_n] = 0;

	g_nest_flg_n++;

	return( g_nest_flg_n - 1 );
}

/***************************************************************
* ͥȳ
* long flg_n : ե饰ֹ
* return : ͥȤοreturn <= -1 顼
***************************************************************/

long	bgn_nest_flg( long flg_n )
{
	return set_nest_flg( flg_n, +1 );
}

/***************************************************************
* ͥȽλ
* long flg_n : ե饰ֹ
* return : ͥȤοreturn <= -1 顼
***************************************************************/

long	end_nest_flg( long flg_n )
{
	return set_nest_flg( flg_n, -1 );
}

/***************************************************************
* ͥ
* long flg_n : ե饰ֹ
* long n : ͥȤον
* return : ͥȤοreturn <= -1 顼
***************************************************************/

long	set_nest_flg( long flg_n, long n )
{
	if( g_nest_flg_n < 0 )
		return -1;
	if( g_nest_flg_n >= NEST_FLG_MAX_N )
		return -1;

	g_nest_flg[flg_n] += n;

	return g_nest_flg[flg_n];
}

/***************************************************************
* ͥ椫Ĵ٤
* long flg_n : ե饰ֹ
* return : ͥ椫?
***************************************************************/

long	chk_nest_flg( long flg_n )
{
	return g_nest_flg[flg_n];
}

/***************************************************************
* ꡼å
***************************************************************/

void	check_memory_nest_flg_c( void )
{
	check_memory( check_memory_nest_flg_c_g_nest_flg,
			"nest-flg.c: g_nest_flg" );
	check_memory( check_memory_nest_flg_c_g_nest_flg_n,
			"nest-flg.c: g_nest_flg_n" );
}
