/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2010 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: GuiStat.h,v 1.15 2010/01/07 07:22:37 bowkenken Exp $
***************************************************************/

#ifndef GUI_STAT_H
#define GUI_STAT_H	1

////////////////////////////////////////////////////////////////
// ơɥ
////////////////////////////////////////////////////////////////

#ifdef D_GTK
# include <gtk/gtk.h>
# include "GtkWSCstring.h"
# include "party.h"
#endif // D_GTK

#ifdef D_MFC
# include "MfcWSCstring.h"
#endif // D_MFC

////////////////////////////////////////////////////////////////

class GuiStat {

// ץ饤١ȡСѿ
private:

	char mStrPreDunLev[40 + 1];
	char mStrPreTime[40 + 1];

#ifdef D_GTK
	GtkWidget *vBox;
	GtkWidget *handleBox[MBR_MAX_N];
	GtkWidget *toolBar[MBR_MAX_N];
	GtkWidget *vBox2[MBR_MAX_N];
	GtkWidget *hBox1[MBR_MAX_N];
	GtkWidget *btnName[MBR_MAX_N];
	GtkWidget *labelAct[MBR_MAX_N];
	GtkWidget *btnStat[MBR_MAX_N];
	GtkWidget *labelHp[MBR_MAX_N];
	GtkWidget *labelMp[MBR_MAX_N];
	GtkWidget *hBoxHp[MBR_MAX_N];
	GtkWidget *hBoxMp[MBR_MAX_N];

	GtkWidget *vBoxMisc;
	GtkWidget *labelDunLev;
	GtkWidget *labelTime;

	GdkGC *mFgGcHp[MBR_MAX_N];
	GdkGC *mFgGcMp[MBR_MAX_N];
	GdkGC *mBgGcHp[MBR_MAX_N];
	GdkGC *mBgGcMp[MBR_MAX_N];
	GdkGC *mFgGcHpMp;
	GdkGC *mBgGcHpMp;

	GtkWidget *mDrawingAreaHp[MBR_MAX_N];
	GtkWidget *mDrawingAreaMp[MBR_MAX_N];
#endif // D_GTK

#ifdef D_MFC
#endif // D_MFC

// ѥ֥åСѿ
public:

#ifdef D_GTK
	GtkWidget *mStatWin;
#endif // D_GTK

#ifdef D_MFC
	CStatWnd *mStatWin;
#endif // D_MFC

// ѥ֥åСؿ
public:

	GuiStat();
	~GuiStat();

	void init();
	void destroy();

	void redraw( bool flagAdj = true, bool flagExpose = false );
	void draw( long n, bool flagExpose = false );
	void drawMisc();

	WSCstring getStatStr( mbr_t *mbr );

// ץ饤١ȡСؿ
private:

	void newWin();

	void drawHpMp( long n, bool flagHp );
#ifdef D_GTK
	void newWinMbr( mbr_t *mbr, GtkWidget *vBox );
#endif // D_GTK
};

#endif /* GUI_STAT_H */
