/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2010 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: mmenu-tab.h,v 1.59 2010/05/13 17:31:58 bowkenken Exp $
***************************************************************/

#ifndef	MMENU_TAB_H
#define	MMENU_TAB_H

/* ᥤ󡦥˥塼 */

#include	"request.h"
#include	"joy-kind.h"

#include	"request-prot.h"

/**/

menu_t	ls_menu_main_race[] = {
	{
		"/main race",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/main race/title",
		"<Title>",
		'\0',
		"",
		N_MSG_TTL_MENU_MAIN_RACE, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/main race/human",
		"<Item>",
		'H',
		"",
		N_MSG_MAIN_RACE_HUMAN, "",
		cb_menu_main_race, (void *)MAIN_RACE_HUMAN,
		FLG_NULL,
	},
	{
		"/main race/half elf",
		"<Item>",
		'F',
		"",
		N_MSG_MAIN_RACE_HALF_ELF, "",
		cb_menu_main_race, (void *)MAIN_RACE_HALF_ELF,
		FLG_NULL,
	},
	{
		"/main race/elf",
		"<Item>",
		'E',
		"",
		N_MSG_MAIN_RACE_ELF, "",
		cb_menu_main_race, (void *)MAIN_RACE_ELF,
		FLG_NULL,
	},
	{
		"/main race/dwarf",
		"<Item>",
		'D',
		"",
		N_MSG_MAIN_RACE_DWARF, "",
		cb_menu_main_race, (void *)MAIN_RACE_DWARF,
		FLG_NULL,
	},
	{
		"/main race/vivid",
		"<Item>",
		'V',
		"",
		N_MSG_MAIN_RACE_VIVID, "",
		cb_menu_main_race, (void *)MAIN_RACE_VIVID,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_sub_race[] = {
	{
		"/sub race",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/sub race/title",
		"<Title>",
		'\0',
		"",
		N_MSG_TTL_MENU_SUB_RACE, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/sub race/null",
		"<Item>",
		'N',
		"",
		N_MSG_SUB_RACE_NULL, "",
		cb_menu_sub_race, (void *)SUB_RACE_NULL,
		FLG_NULL,
	},
	{
		"/sub race/cat",
		"<Item>",
		'C',
		"",
		N_MSG_SUB_RACE_CAT, "",
		cb_menu_sub_race, (void *)SUB_RACE_CAT,
		FLG_NULL,
	},
	{
		"/sub race/dog",
		"<Item>",
		'D',
		"",
		N_MSG_SUB_RACE_DOG, "",
		cb_menu_sub_race, (void *)SUB_RACE_DOG,
		FLG_NULL,
	},
	{
		"/sub race/mouse",
		"<Item>",
		'U',
		"",
		N_MSG_SUB_RACE_MOUSE, "",
		cb_menu_sub_race, (void *)SUB_RACE_MOUSE,
		FLG_NULL,
	},
	{
		"/sub race/rabbit",
		"<Item>",
		'R',
		"",
		N_MSG_SUB_RACE_RABBIT, "",
		cb_menu_sub_race, (void *)SUB_RACE_RABBIT,
		FLG_NULL,
	},
	{
		"/sub race/monkey",
		"<Item>",
		'K',
		"",
		N_MSG_SUB_RACE_MONKEY, "",
		cb_menu_sub_race, (void *)SUB_RACE_MONKEY,
		FLG_NULL,
	},
	{
		"/sub race/pig",
		"<Item>",
		'P',
		"",
		N_MSG_SUB_RACE_PIG, "",
		cb_menu_sub_race, (void *)SUB_RACE_PIG,
		FLG_NULL,
	},
	{
		"/sub race/bird",
		"<Item>",
		'B',
		"",
		N_MSG_SUB_RACE_BIRD, "",
		cb_menu_sub_race, (void *)SUB_RACE_BIRD,
		FLG_NULL,
	},
	{
		"/sub race/lizard",
		"<Item>",
		'L',
		"",
		N_MSG_SUB_RACE_LIZARD, "",
		cb_menu_sub_race, (void *)SUB_RACE_LIZARD,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_sex[] = {
	{
		"/sex",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/sex/title",
		"<Title>",
		'\0',
		"",
		N_MSG_TTL_MENU_SEX, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/sex/male",
		"<Item>",
		'M',
		"",
		N_MSG_MALE, "",
		cb_menu_sex, (void *)MALE,
		FLG_NULL,
	},
	{
		"/sex/female",
		"<Item>",
		'F',
		"",
		N_MSG_FEMALE, "",
		cb_menu_sex, (void *)FEMALE,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_class
		[1 + CLASS_MAX_N + (CLASS_MAX_N / LS_CLASS_N_PER_PAGE) + 1];

menu_t	ls_menu_main[] = {
	{
		"/",
		"<Branch>",
		'\0',
		"m M ^M ^J",
		N_MSG_NULL, "",
		cb_menu_main_init, NULL,
		FLG_NULL,
	},
	{
		"/mark",
		"<Branch>",
		'M',
		"",
		N_MSG_MENU_MARK, "",
		cb_menu_mark, NULL,
		FLG_NULL,
	},
	{
		"/move",
		"<Item>",
		'V',
		"+ v",
		N_MSG_MENU_MOVE, "",
		cb_menu_move, NULL,
		FLG_NULL,
	},
	{
		"/exec",
		"<Item>",
		'X',
		"5 .",
		N_MSG_MENU_EXEC, "",
		cb_menu_exec, NULL,
		FLG_NULL,
	},
	{
		"/auto mark",
		"<Branch>",
		'Z',
		"/ z",
		N_MSG_MENU_SEL_OBJ_AUTO, "",
		cb_menu_auto_mark, NULL,
		FLG_NULL,
	},
	{
		"/item",
		"<Branch>",
		'I',
		"i",
		N_MSG_MENU_ITEM, "",
		cb_menu_item, NULL,
		FLG_NULL,
	},
	{
		"/equip",
		"<Branch>",
		'E',
		"e",
		N_MSG_MENU_EQUIP, "",
		cb_menu_equip, NULL,
		FLG_NULL,
	},
	{
		"/fight",
		"<Branch>",
		'F',
		"f",
		N_MSG_MENU_FIGHT, "",
		cb_menu_fight, NULL,
		FLG_NULL,
	},
	{
		"/spell",
		"<Branch>",
		'C',
		"- c",
		N_MSG_MENU_SPELL, "",
		cb_menu_sel_spell, NULL,
		FLG_NULL,
	},
	{
		"/town",
		"<Branch>",
		'T',
		"",
		N_MSG_MENU_TOWN, "",
		cb_menu_town_init, NULL,
		FLG_NULL,
	},
	{
		"/town/navi",
		"<Branch>",
		'N',
		"",
		N_MSG_MENU_NAVI, "",
		cb_menu_navi_init, NULL,
		FLG_NULL,
	},
	{
		"/town/auto sale",
		"<Branch>",
		'S',
		"",
		N_MSG_MENU_AUTO_SALE, "",
		cb_menu_auto_sale, NULL,
		FLG_NULL,
	},
/* misc begin */
	{
		"/misc",
		"<Branch>",
		'S',
		"",
		N_MSG_MENU_MISC, "",
		cb_menu_misc, NULL,
		FLG_NULL,
	},
	{
		"/misc/info",
		"<Branch>",
		'I',
		"",
		N_MSG_MENU_INFO, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/misc/info/hint",
		"<Item>",
		'H',
		"?",
		N_MSG_MENU_MAP_HINT, "",
		cb_menu_show_map_hint, NULL,
		FLG_NULL,
	},
	{
		"/misc/info/char data",
		"<OpenWinItem>",
		'C',
		"C",
		N_MSG_MENU_CHR_DATA, "",
		cb_menu_chr_data, NULL,
		FLG_NULL,
	},
	{
		"/misc/info/list message",
		"<OpenWinItem>",
		'L',
		"g",
		N_MSG_MENU_LS_MSG, "",
		cb_menu_ls_msg, NULL,
		FLG_NULL,
	},
	{
		"/misc/info/list key item",
		"<Item>",
		'K',
		"",
		N_MSG_MENU_LS_KEY_ITEM, "",
		cb_menu_ls_key_item, NULL,
		FLG_NULL,
	},
	{
		"/misc/info/list monster",
		"<Item>",
		'M',
		"",
		N_MSG_MENU_LS_MNSTR, "",
		cb_menu_ls_mnstr, NULL,
		FLG_NULL,
	},
	{
		"/misc/info/list request",
		"<Branch>",
		'R',
		"r",
		N_MSG_MENU_LS_REQUEST, "",
		cb_menu_request_mbr, NULL,
		FLG_NULL,
	},
	{
		"/misc/continue exec",
		"<Item>",
		'X',
		",",
		N_MSG_MENU_CONTINUE_EXEC, "",
		cb_menu_continue_exec, NULL,
		FLG_NULL,
	},
	{
		"/misc/stairs",
		"<Branch>",
		'T',
		"",
		N_MSG_MENU_STAIRS, "",
		cb_menu_stairs, NULL,
		FLG_NULL,
	},
	{
		"/misc/stairs/up",
		"<Item>",
		'U',
		"<",
		N_MSG_MENU_STAIRS_UP, "",
		cb_menu_stairs_up, NULL,
		FLG_NULL,
	},
	{
		"/misc/stairs/down",
		"<Item>",
		'D',
		">",
		N_MSG_MENU_STAIRS_DOWN, "",
		cb_menu_stairs_down, NULL,
		FLG_NULL,
	},
	{
		"/misc/stairs/last boss",
		"<Item>",
		'X',
		"",
		N_MSG_MENU_STAIRS_LAST_BOSS, "",
		cb_menu_stairs_last_boss, NULL,
		FLG_NULL,
	},
	{
		"/misc/search",
		"<Branch>",
		'S',
		"# ^S S",
		N_MSG_MENU_SRCH, "",
		cb_menu_srch, NULL,
		FLG_NULL,
	},
	{
		"/misc/gold",
		"<Branch>",
		'G',
		"",
		N_MSG_MENU_GOLD, "",
		cb_menu_gold, NULL,
		FLG_NULL,
	},
	{
		"/misc/gold/collect",
		"<Item>",
		'C',
		"",
		N_MSG_MENU_COLLECT_GOLD, "",
		cb_menu_collect_gold, NULL,
		FLG_NULL,
	},
	{
		"/misc/gold/divide",
		"<Item>",
		'D',
		"",
		N_MSG_MENU_DIVIDE_GOLD, "",
		cb_menu_divide_gold, NULL,
		FLG_NULL,
	},
	{
		"/misc/gold/give",
		"<Item>",
		'G',
		"",
		N_MSG_MENU_GIVE_GOLD, "",
		cb_menu_give_gold, NULL,
		FLG_NULL,
	},
	{
		"/misc/formation",
		"<Branch>",
		'F',
		"",
		N_MSG_MENU_FORMATION, "",
		cb_menu_formation, NULL,
		FLG_NULL,
	},
	{
		"/misc/position",
		"<Branch>",
		'P',
		"",
		N_MSG_MENU_POSITION, "",
		cb_menu_position, NULL,
		FLG_NULL,
	},
	{
		"/misc/cursor",
		"<Branch>",
		'V',
		"",
		N_MSG_MENU_CRSR, "",
		cb_menu_crsr, NULL,
		FLG_NULL,
	},
/* config begin */
	{
		"/misc/config",
		"<Branch>",
		'C',
		"",
		N_MSG_MENU_CNF, "",
		cb_menu_cnf, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/auto fight",
		"<Branch>",
		'F',
		"",
		N_MSG_MENU_AUTO_FIGHT, "",
		cb_menu_mbr_flg, (void *)FLG_CHR_AUTO_FIGHT,
		FLG_NULL,
	},
	{
		"/misc/config/auto open door",
		"<Branch>",
		'D',
		"",
		N_MSG_MENU_AUTO_DOOR, "",
		cb_menu_mbr_flg, (void *)FLG_CHR_AUTO_DOOR,
		FLG_NULL,
	},
	{
		"/misc/config/avoid trap",
		"<Branch>",
		'T',
		"",
		N_MSG_MENU_AVOID_TRAP, "",
		cb_menu_mbr_flg, (void *)FLG_CHR_AVOID_TRAP,
		FLG_NULL,
	},
	{
		"/misc/config/reload arrow",
		"<Branch>",
		'A',
		"",
		N_MSG_MENU_AUTO_RELOAD, "",
		cb_menu_mbr_flg, (void *)FLG_CHR_AUTO_RELOAD,
		FLG_NULL,
	},
	{
		"/misc/config/actual fighting",
		"<CheckItem>",
		'I',
		"",
		N_MSG_MENU_ACTUAL_FIGHTING, "",
		cb_menu_actual_fighting, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/space select",
		"<CheckItem>",
		'S',
		"",
		N_MSG_MENU_SPACE_SELECT, "",
		cb_menu_space_select, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/reset file",
		"<Branch>",
		'R',
		"",
		N_MSG_MENU_RESET_FILE, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/reset file/config",
		"<Item>",
		'C',
		"",
		N_MSG_MENU_RESET_FILE_CONFIG, "",
		cb_menu_reset_file_config, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/reset file/town ptn",
		"<Item>",
		'T',
		"",
		N_MSG_MENU_RESET_FILE_TOWN_PTN, "",
		cb_menu_reset_file_town_ptn, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/lang",
		"<Branch>",
		'L',
		"",
		N_MSG_MENU_LANG, "",
		cb_menu_lang, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/lang/title",
		"<Title>",
		'\0',
		"",
		N_MSG_MENU_LANG, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/lang/list",
		"<Branch>",
		'L',
		"",
		N_MSG_MENU_LANG_LS, "",
		cb_menu_lang_ls, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/lang/list priority",
		"<CheckItem>",
		'P',
		"",
		N_MSG_MENU_LANG_LS_PRIORITY, "",
		cb_menu_lang_ls_priority, NULL,
		FLG_NULL,
	},
/*  begin */
	{
		"/misc/config/screen",
		"<Branch>",
		'V',
		"",
		N_MSG_MENU_SCREEN, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/screen/window",
		"<Branch>",
		'W',
		"",
		N_MSG_MENU_WINDOW, "",
		cb_menu_window, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/screen/window/title",
		"<Title>",
		'\0',
		"",
		N_MSG_MENU_WINDOW, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/screen/window/scroll",
		"<Branch>",
		'S',
		"",
		N_MSG_MENU_SCROLL_MODE, "",
		cb_menu_scroll_init, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/screen/window/scroll/page",
		"<RadioItem>",
		'P',
		"",
		N_MSG_MENU_SCROLL_PAGE, "",
		cb_menu_scroll_page, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/screen/window/scroll/smooth",
		"<RadioItem>",
		'S',
		"",
		N_MSG_MENU_SCROLL_SMOOTH, "",
		cb_menu_scroll_smooth, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/screen/window/scroll/center",
		"<RadioItem>",
		'C',
		"",
		N_MSG_MENU_SCROLL_CENTER, "",
		cb_menu_scroll_center, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/screen/window/redraw every turn",
		"<CheckItem>",
		'D',
		"",
		N_MSG_MENU_REDRAW_EVERY_TURN, "",
		cb_menu_redraw_every_turn, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/screen/window/multi message",
		"<CheckItem>",
		'M',
		"",
		N_MSG_MENU_MUL_MSG_LINE, "",
		cb_menu_mul_msg_line, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/screen/window/size",
		"<Branch>",
		'Z',
		"",
		N_MSG_MENU_SCREEN_SIZE, "",
		cb_menu_screen_size_init, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/screen/window/size/auto",
		"<CheckItem>",
		'A',
		"",
		N_MSG_MENU_SCREEN_SIZE_AUTO, "",
		cb_menu_screen_size_auto, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/screen/window/size/column",
		"<OpenWinItem>",
		'C',
		"",
		N_MSG_MENU_SCREEN_SIZE_COL, "",
		cb_menu_screen_size_col, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/screen/window/size/row",
		"<OpenWinItem>",
		'R',
		"",
		N_MSG_MENU_SCREEN_SIZE_ROW, "",
		cb_menu_screen_size_row, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/screen/window/size/message",
		"<OpenWinItem>",
		'S',
		"",
		N_MSG_MENU_SCREEN_SIZE_MESSAGE, "",
		cb_menu_screen_size_message, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/screen/window/size/map",
		"<CheckItem>",
		'M',
		"",
		N_MSG_MENU_SCREEN_SIZE_MAP, "",
		cb_menu_screen_size_map, NULL,
		FLG_NULL,
	},
/* VFX begin */
	{
		"/misc/config/screen/vfx",
		"<Branch>",
		'X',
		"",
		N_MSG_MENU_VFX, "",
		cb_menu_vfx, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/screen/vfx/title",
		"<Title>",
		'\0',
		"",
		N_MSG_MENU_VFX, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/screen/vfx/member cure",
		"<CheckItem>",
		'A',
		"",
		N_MSG_MENU_VFX_MBR_CURE, "",
		cb_menu_vfx_mbr, (void *)FLG_VFX_MBR_CURE,
		FLG_NULL,
	},
	{
		"/misc/config/screen/vfx/member dam",
		"<CheckItem>",
		'B',
		"",
		N_MSG_MENU_VFX_MBR_DAM, "",
		cb_menu_vfx_mbr, (void *)FLG_VFX_MBR_DAM,
		FLG_NULL,
	},
	{
		"/misc/config/screen/vfx/member critical",
		"<CheckItem>",
		'C',
		"",
		N_MSG_MENU_VFX_MBR_CRTCL, "",
		cb_menu_vfx_mbr, (void *)FLG_VFX_MBR_CRTCL,
		FLG_NULL,
	},
	{
		"/misc/config/screen/vfx/member arrow",
		"<CheckItem>",
		'D',
		"",
		N_MSG_MENU_VFX_MBR_ARW, "",
		cb_menu_vfx_mbr, (void *)FLG_VFX_MBR_ARW,
		FLG_NULL,
	},
	{
		"/misc/config/screen/vfx/monster cure",
		"<CheckItem>",
		'E',
		"",
		N_MSG_MENU_VFX_MNSTR_CURE, "",
		cb_menu_vfx_mnstr, (void *)FLG_VFX_MNSTR_CURE,
		FLG_NULL,
	},
	{
		"/misc/config/screen/vfx/monster dam",
		"<CheckItem>",
		'F',
		"",
		N_MSG_MENU_VFX_MNSTR_DAM, "",
		cb_menu_vfx_mnstr, (void *)FLG_VFX_MNSTR_DAM,
		FLG_NULL,
	},
	{
		"/misc/config/screen/vfx/monster critical",
		"<CheckItem>",
		'G',
		"",
		N_MSG_MENU_VFX_MNSTR_CRTCL, "",
		cb_menu_vfx_mnstr, (void *)FLG_VFX_MNSTR_CRTCL,
		FLG_NULL,
	},
	{
		"/misc/config/screen/vfx/monster arrow",
		"<CheckItem>",
		'H',
		"",
		N_MSG_MENU_VFX_MNSTR_ARW, "",
		cb_menu_vfx_mnstr, (void *)FLG_VFX_MNSTR_ARW,
		FLG_NULL,
	},
	{
		"/misc/config/screen/vfx/wait",
		"<OpenWinItem>",
		'W',
		"",
		N_MSG_MENU_VFX_WAIT, "",
		cb_menu_vfx_wait, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/screen/vfx/measure clock",
		"<Item>",
		'X',
		"",
		N_MSG_MENU_VFX_MEASURE_CLK_TCK, "",
		cb_menu_vfx_measure_clk_tck, NULL,
		FLG_NULL,
	},
/* VFX end */
	{
		"/misc/config/screen/color",
		"<Branch>",
		'C',
		"",
		N_MSG_MENU_COLOR, "",
		cb_menu_color, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/screen/cursor pattern",
		"<Branch>",
		'V',
		"",
		N_MSG_MENU_CRSR_PTN, "",
		cb_menu_crsr_ptn, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/screen/demo",
		"<Branch>",
		'D',
		"",
		N_MSG_MENU_DEMO, "",
		cb_menu_demo, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/screen/demo/cut in",
		"<CheckItem>",
		'C',
		"",
		N_MSG_MENU_SKIP_CUT_IN, "",
		cb_menu_skip_cut_in, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/screen/demo/star",
		"<Branch>",
		'S',
		"",
		N_MSG_MENU_STAR, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/screen/demo/star/cui",
		"<OpenWinItem>",
		'C',
		"",
		N_MSG_MENU_STAR_CUI, "",
		cb_menu_star_cui, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/screen/demo/star/gui",
		"<OpenWinItem>",
		'G',
		"",
		N_MSG_MENU_STAR_GUI, "",
		cb_menu_star_gui, NULL,
		FLG_NULL,
	},
/*  end */
	{
		"/misc/config/key",
		"<Branch>",
		'K',
		"",
		N_MSG_MENU_KEY, "",
		cb_menu_key_init, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/key/title",
		"<Title>",
		'\0',
		"",
		N_MSG_MENU_KEY, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/key/clear key buffer",
		"<Branch>",
		'C',
		"",
		N_MSG_MENU_CLR_KEY_BUF, "",
		cb_menu_clr_key_buf_init, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/key/clear key buffer/title",
		"<Title>",
		'\0',
		"",
		N_MSG_MENU_CLR_KEY_BUF, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/key/clear key buffer/every",
		"<CheckItem>",
		'E',
		"",
		N_MSG_MENU_CLR_KEY_BUF_EVERY, "",
		cb_menu_clr_key_buf_every, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/key/clear key buffer/menu",
		"<CheckItem>",
		'M',
		"",
		N_MSG_MENU_CLR_KEY_BUF_MENU, "",
		cb_menu_clr_key_buf_menu, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/key/echo key",
		"<CheckItem>",
		'E',
		"",
		N_MSG_MENU_ECHO_KEY, "",
		cb_menu_echo_key, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/key/key bind",
		"<Branch>",
		'B',
		"",
		N_MSG_MENU_KEY_BIND, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/key/key bind/title",
		"<Title>",
		'\0',
		"",
		N_MSG_MENU_KEY_BIND, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/key/key bind/set key",
		"<OpenWinItem>",
		'B',
		"",
		N_MSG_MENU_SET_KEY, "",
		cb_menu_set_key, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/key/key bind/set key reg macro",
		"<OpenWinItem>",
		'M',
		"",
		N_MSG_MENU_SET_KEY_REG_MACRO, "",
		cb_menu_set_key_reg_macro, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/key/key bind/unset key",
		"<OpenWinItem>",
		'F',
		"",
		N_MSG_MENU_UNSET_KEY, "",
		cb_menu_unset_key, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/key/func",
		"<Branch>",
		'F',
		"",
		N_MSG_MENU_FUNC, "",
		cb_menu_func, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/gui",
		"<Branch>",
		'G',
		"",
		N_MSG_MENU_GUI, "",
		cb_menu_gui, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/gui/move cursor to default",
		"<CheckItem>",
		'C',
		"",
		N_MSG_MENU_MOVE_CRSR_DFLT, "",
		cb_menu_move_crsr_dflt, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/gui/audio",
		"<Branch>",
		'A',
		"",
		N_MSG_MENU_AUDIO, "",
		cb_menu_audio, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/gui/audio/sound volume",
		"<OpenWinItem>",
		'S',
		"",
		N_MSG_MENU_SOUND_VOLUME, "",
		cb_menu_sound_volume, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/gui/audio/music volume",
		"<OpenWinItem>",
		'M',
		"",
		N_MSG_MENU_MUSIC_VOLUME, "",
		cb_menu_music_volume, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/gui/audio/mute",
		"<CheckItem>",
		'U',
		"",
		N_MSG_MENU_MUTE_AUDIO, "",
		cb_menu_mute_audio, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/gui/audio/replay music",
		"<Item>",
		'R',
		"p",
		N_MSG_MENU_REPLAY_MUSIC, "",
		cb_menu_replay_music, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/gui/audio/set buffer size",
		"<OpenWinItem>",
		'B',
		"",
		N_MSG_MENU_SET_AUDIO_BUF_SIZ, "",
		cb_menu_set_audio_buf_siz, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/gui/mouse",
		"<Branch>",
		'M',
		"",
		N_MSG_MENU_MOUSE, "",
		cb_menu_mouse, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/gui/joystick",
		"<Branch>",
		'J',
		"",
		N_MSG_MENU_JOYSTICK, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/gui/joystick/select joystick",
		"<Branch>",
		'D',
		"",
		N_MSG_MENU_JOYSTICK_SEL_N, "",
		cb_menu_joystick_sel_n_init, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/gui/joystick/select kind",
		"<Branch>",
		'T',
		"",
		N_MSG_MENU_JOYSTICK_SEL_KIND, "",
		cb_menu_joystick_sel_kind_init, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/gui/joystick/select kind/ps",
		"<RadioItem>",
		'P',
		"",
		N_MSG_MENU_JOYSTICK_PS, "",
		cb_menu_joystick_sel_kind, (void *)JOY_KIND_PS,
		FLG_NULL,
	},
	{
		"/misc/config/gui/joystick/select kind/saturn",
		"<RadioItem>",
		'S',
		"",
		N_MSG_MENU_JOYSTICK_SATURN, "",
		cb_menu_joystick_sel_kind, (void *)JOY_KIND_SATURN,
		FLG_NULL,
	},
	{
		"/misc/config/gui/joystick/select kind/rap3",
		"<RadioItem>",
		'R',
		"",
		N_MSG_MENU_JOYSTICK_RAP3, "",
		cb_menu_joystick_sel_kind, (void *)JOY_KIND_RAP3,
		FLG_NULL,
	},
	{
		"/misc/config/gui/joystick/macro",
		"<Branch>",
		'M',
		"",
		N_MSG_MENU_JOYSTICK_MACRO, "",
		cb_menu_joystick_macro_init, NULL,
		FLG_NULL,
	},
	{
		"/misc/config/user menu select",
		"<Branch>",
		'U',
		"* x",
		N_MSG_MENU_USER, "",
		cb_menu_user, NULL,
		FLG_NULL,
	},
/* config end */
/* system begin */
	{
		"/misc/system",
		"<Branch>",
		'Y',
		"",
		N_MSG_MENU_SYS, "",
		cb_menu_system, NULL,
		FLG_NULL,
	},
/* replay begin */
	{
		"/misc/system/replay",
		"<Branch>",
		'R',
		"",
		N_MSG_MENU_REPLAY, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/misc/system/replay/load",
		"<OpenWinItem>",
		'L',
		"",
		N_MSG_MENU_REPLAY_LOAD, "",
		cb_menu_replay_load, NULL,
		FLG_NULL,
	},
	{
		"/misc/system/replay/save",
		"<Item>",
		'S',
		"^R",
		N_MSG_MENU_REPLAY_SAVE, "",
		cb_menu_replay_save, NULL,
		FLG_NULL,
	},
	{
		"/misc/system/replay/debug",
		"<Item>",
		'D',
		"",
		N_MSG_MENU_REPLAY_DEBUG, "",
		cb_menu_replay_debug, NULL,
		FLG_NULL,
	},
	{
		"/misc/system/replay/bug repo",
		"<Item>",
		'B',
		"^D",
		N_MSG_MENU_REPLAY_BUG_REPO, "",
		cb_menu_replay_bug_repo, NULL,
		FLG_NULL,
	},
/* replay end */
	{
		"/misc/system/command",
		"<Item>",
		'C',
		MENU_COMMAND_KEY_STR,
		N_MSG_MENU_COMMAND, "",
		cb_menu_command, NULL,
		FLG_NULL,
	},
/* wizard begin */
	{
		"/misc/system/wizard",
		"<Branch>",
		'W',
		"^W",
		N_MSG_MENU_WIZARD, "",
		cb_menu_wizard, NULL,
		FLG_NULL,
	},
	{
		"/misc/system/wizard/title",
		"<Title>",
		'\0',
		"",
		N_MSG_TTL_MENU_WIZARD, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/misc/system/wizard/teleport party",
		"<Item>",
		'P',
		"",
		N_MSG_MENU_WIZARD_TELEPORT_PARTY, "",
		cb_menu_wizard_teleport_party, NULL,
		FLG_NULL,
	},
	{
		"/misc/system/wizard/recall",
		"<OpenWinItem>",
		'R',
		"",
		N_MSG_MENU_WIZARD_RECALL, "",
		cb_menu_wizard_recall, NULL,
		FLG_NULL,
	},
	{
		"/misc/system/wizard/on light",
		"<Item>",
		'O',
		"",
		N_MSG_MENU_WIZARD_ON_LIGHT, "",
		cb_menu_wizard_on_light, NULL,
		FLG_NULL,
	},
	{
		"/misc/system/wizard/off light",
		"<Item>",
		'F',
		"",
		N_MSG_MENU_WIZARD_OFF_LIGHT, "",
		cb_menu_wizard_off_light, NULL,
		FLG_NULL,
	},
	{
		"/misc/system/wizard/add turn",
		"<Branch>",
		'T',
		"",
		N_MSG_MENU_WIZARD_ADD_TURN, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/misc/system/wizard/add turn/title",
		"<Title>",
		'\0',
		"",
		N_MSG_TTL_MENU_WIZARD_ADD_TURN, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/misc/system/wizard/add turn/hour",
		"<OpenWinItem>",
		'H',
		"",
		N_MSG_MENU_WIZARD_ADD_TURN_HOUR, "",
		cb_menu_wizard_add_turn_hour, NULL,
		FLG_NULL,
	},
	{
		"/misc/system/wizard/add turn/minute",
		"<OpenWinItem>",
		'M',
		"",
		N_MSG_MENU_WIZARD_ADD_TURN_MINUTE, "",
		cb_menu_wizard_add_turn_minute, NULL,
		FLG_NULL,
	},
	{
		"/misc/system/wizard/add turn/turn",
		"<OpenWinItem>",
		'T',
		"",
		N_MSG_MENU_WIZARD_ADD_TURN_TURN, "",
		cb_menu_wizard_add_turn_turn, NULL,
		FLG_NULL,
	},
	{
		"/misc/system/wizard/up exp",
		"<OpenWinItem>",
		'X',
		"",
		N_MSG_MENU_WIZARD_UP_EXP, "",
		cb_menu_wizard_up_exp, NULL,
		FLG_NULL,
	},
	{
		"/misc/system/wizard/up level",
		"<Branch>",
		'V',
		"",
		N_MSG_MENU_WIZARD_UP_LEV, "",
		cb_menu_wizard_up_lev, NULL,
		FLG_NULL,
	},
	{
		"/misc/system/wizard/scene",
		"<Branch>",
		'C',
		"",
		N_MSG_MENU_WIZARD_SCENE, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/misc/system/wizard/scene/last boss",
		"<Branch>",
		'L',
		"",
		N_MSG_MENU_WIZARD_SCENE_LAST_BOSS, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/misc/system/wizard/scene/last boss/enter",
		"<Item>",
		'A',
		"",
		N_MSG_MENU_WIZARD_LAST_SCENE_ENTER, "",
		cb_menu_wizard_last_scene, (void *)LAST_SCENE_N_ENTER,
		FLG_NULL,
	},
	{
		"/misc/system/wizard/scene/last boss/encounter",
		"<Item>",
		'B',
		"",
		N_MSG_MENU_WIZARD_LAST_SCENE_ENCOUNTER, "",
		cb_menu_wizard_last_scene, (void *)LAST_SCENE_N_ENCOUNTER,
		FLG_NULL,
	},
	{
		"/misc/system/wizard/scene/last boss/exel",
		"<Item>",
		'C',
		"",
		N_MSG_MENU_WIZARD_LAST_SCENE_EXEL, "",
		cb_menu_wizard_last_scene, (void *)LAST_SCENE_N_EXEL,
		FLG_NULL,
	},
	{
		"/misc/system/wizard/scene/last boss/exeler",
		"<Item>",
		'D',
		"",
		N_MSG_MENU_WIZARD_LAST_SCENE_EXELER, "",
		cb_menu_wizard_last_scene, (void *)LAST_SCENE_N_EXELER,
		FLG_NULL,
	},
	{
		"/misc/system/wizard/scene/last boss/xex",
		"<Item>",
		'E',
		"",
		N_MSG_MENU_WIZARD_LAST_SCENE_XEX, "",
		cb_menu_wizard_last_scene, (void *)LAST_SCENE_N_XEX,
		FLG_NULL,
	},
	{
		"/misc/system/wizard/scene/last boss/xx",
		"<Item>",
		'F',
		"",
		N_MSG_MENU_WIZARD_LAST_SCENE_XX, "",
		cb_menu_wizard_last_scene, (void *)LAST_SCENE_N_XX_WORDS,
		FLG_NULL,
	},
	{
		"/misc/system/wizard/scene/game over",
		"<Item>",
		'O',
		"",
		N_MSG_MENU_WIZARD_SCENE_GAME_OVER, "",
		cb_menu_wizard_scene, (void *)SCENE_N_GAME_OVER,
		FLG_NULL,
	},
	{
		"/misc/system/wizard/scene/ending",
		"<Item>",
		'E',
		"",
		N_MSG_MENU_WIZARD_SCENE_ENDING, "",
		cb_menu_wizard_scene, (void *)SCENE_N_ENDING,
		FLG_NULL,
	},
	{
		"/misc/system/wizard/text load",
		"<Branch>",
		'L',
		"",
		N_MSG_MENU_WIZARD_TEXT_LOAD, "",
		cb_menu_load_wiz, (void *)TRUE,
		FLG_NULL,
	},
	{
		"/misc/system/wizard/text save",
		"<Branch>",
		'S',
		"",
		N_MSG_MENU_WIZARD_TEXT_SAVE, "",
		cb_menu_save_wiz, (void *)TRUE,
		FLG_NULL,
	},
/* wizard end */
	{
		"/misc/system/output map file",
		"<OpenWinItem>",
		'M',
		"",
		N_MSG_MENU_OUT_MAP_FILE, "",
		cb_menu_out_map_file, NULL,
		FLG_NULL,
	},
	{
		"/misc/system/shell",
		"<OpenWinItem>",
		'S',
		"!",
		N_MSG_MENU_SHELL, "",
		cb_menu_shell, NULL,
		FLG_NULL,
	},
	{
		"/misc/system/about",
		"<OpenWinItem>",
		'A',
		"",
		N_MSG_MENU_ABOUT_GAME, "",
		cb_menu_about_game, NULL,
		FLG_NULL,
	},
	{
		"/misc/system/exit",
		"<Branch>",
		'Q',
		"^C ^Q Q",
		N_MSG_MENU_EXIT, "",
		cb_menu_exit, NULL,
		FLG_NULL,
	},
/* system end */
/* misc end */
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_sel_obj[] = {
	{
		"/sel obj",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		cb_menu_sel_obj_init, NULL,
		FLG_NULL,
	},
	{
		"/sel obj/member",
		"<OpenWinItem>",
		'P',
		"",
		N_MSG_MENU_SEL_OBJ_MBR, "",
		cb_menu_sel_obj, (void *)TRGT_KIND_MBR,
		FLG_NULL,
	},
	{
		"/sel obj/monster",
		"<OpenWinItem>",
		'X',
		"",
		N_MSG_MENU_SEL_OBJ_MNSTR, "",
		cb_menu_sel_obj, (void *)TRGT_KIND_MNSTR,
		FLG_NULL,
	},
	{
		"/sel obj/item",
		"<OpenWinItem>",
		'I',
		"",
		N_MSG_MENU_SEL_OBJ_ITEM, "",
		cb_menu_sel_obj, (void *)TRGT_KIND_ITEM,
		FLG_NULL,
	},
	{
		"/sel obj/door",
		"<OpenWinItem>",
		'D',
		"",
		N_MSG_MENU_SEL_OBJ_DOOR, "",
		cb_menu_sel_obj, (void *)TRGT_KIND_DOOR,
		FLG_NULL,
	},
	{
		"/sel obj/trap",
		"<OpenWinItem>",
		'T',
		"",
		N_MSG_MENU_SEL_OBJ_TRAP, "",
		cb_menu_sel_obj, (void *)TRGT_KIND_TRAP,
		FLG_NULL,
	},
	{
		"/sel obj/square",
		"<OpenWinItem>",
		'V',
		"",
		N_MSG_MENU_SEL_OBJ_SQUARE, "",
		cb_menu_sel_obj, (void *)TRGT_KIND_SQUARE,
		FLG_NULL,
	},
	{
		"/sel obj/position",
		"<OpenWinItem>",
		'N',
		"",
		N_MSG_MENU_SEL_OBJ_POS, "",
		cb_menu_sel_obj, (void *)TRGT_KIND_POS,
		FLG_NULL,
	},
	{
		"/sel obj/auto",
		"<Branch>",
		'A',
		"",
		N_MSG_MENU_SEL_OBJ_AUTO, "",
		cb_menu_sel_obj_auto, (void *)TRGT_KIND_AUTO,
		FLG_NULL,
	},
	{
		"/sel obj/clear",
		"<Item>",
		'C',
		"",
		N_MSG_MENU_SEL_OBJ_CLEAR, "",
		cb_menu_sel_obj, (void *)TRGT_KIND_NULL,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_mbr[1 + MBR_MAX_N + PET_MAX_N + 1];
menu_t	ls_menu_abl[1 + ABL_KIND_MAX_N * 2 + 1];

menu_t	ls_menu_dist[] = {
	{
		"/dist",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		cb_menu_dist_init, NULL,
		FLG_NULL,
	},
/* Near */
	{
		"/dist/near",
		"<Branch>",
		'N',
		"",
		N_MSG_MENU_DIST_NEAR, "",
		cb_menu_dist, (void *)"near",
		FLG_NULL,
	},
	{
		"/dist/near/fight",
		"<Item>",
		'F',
		"",
		N_MSG_MENU_MARK_FIGHT, "",
		cb_menu_dist_act, (void *)"fight",
		FLG_NULL,
	},
	{
		"/dist/near/throw",
		"<Item>",
		'T',
		"",
		N_MSG_MENU_MARK_THROW, "",
		cb_menu_dist_act, (void *)"throw",
		FLG_NULL,
	},
	{
		"/dist/near/steal",
		"<Item>",
		'S',
		"",
		N_MSG_MENU_MARK_STEAL, "",
		cb_menu_dist_act, (void *)"steal",
		FLG_NULL,
	},
	{
		"/dist/near/tail",
		"<Item>",
		'L',
		"",
		N_MSG_MENU_MARK_TAIL, "",
		cb_menu_dist_act, (void *)"tail",
		FLG_NULL,
	},
/* Medium */
	{
		"/dist/medium",
		"<Branch>",
		'M',
		"",
		N_MSG_MENU_DIST_MEDIUM, "",
		cb_menu_dist, (void *)"medium",
		FLG_NULL,
	},
	{
		"/dist/medium/fight",
		"<Item>",
		'F',
		"",
		N_MSG_MENU_MARK_FIGHT, "",
		cb_menu_dist_act, (void *)"fight",
		FLG_NULL,
	},
	{
		"/dist/medium/throw",
		"<Item>",
		'T',
		"",
		N_MSG_MENU_MARK_THROW, "",
		cb_menu_dist_act, (void *)"throw",
		FLG_NULL,
	},
	{
		"/dist/medium/steal",
		"<Item>",
		'S',
		"",
		N_MSG_MENU_MARK_STEAL, "",
		cb_menu_dist_act, (void *)"steal",
		FLG_NULL,
	},
	{
		"/dist/medium/tail",
		"<Item>",
		'L',
		"",
		N_MSG_MENU_MARK_TAIL, "",
		cb_menu_dist_act, (void *)"tail",
		FLG_NULL,
	},
/* Far */
	{
		"/dist/far",
		"<Branch>",
		'F',
		"",
		N_MSG_MENU_DIST_FAR, "",
		cb_menu_dist, (void *)"far",
		FLG_NULL,
	},
	{
		"/dist/far/fight",
		"<Item>",
		'F',
		"",
		N_MSG_MENU_MARK_FIGHT, "",
		cb_menu_dist_act, (void *)"fight",
		FLG_NULL,
	},
	{
		"/dist/far/throw",
		"<Item>",
		'T',
		"",
		N_MSG_MENU_MARK_THROW, "",
		cb_menu_dist_act, (void *)"throw",
		FLG_NULL,
	},
	{
		"/dist/far/steal",
		"<Item>",
		'S',
		"",
		N_MSG_MENU_MARK_STEAL, "",
		cb_menu_dist_act, (void *)"steal",
		FLG_NULL,
	},
	{
		"/dist/far/tail",
		"<Item>",
		'L',
		"",
		N_MSG_MENU_MARK_TAIL, "",
		cb_menu_dist_act, (void *)"tail",
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_mark_item[] = {
	{
		"/mark item",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/mark item/pick up",
		"<Item>",
		'P',
		"",
		N_MSG_MENU_MARK_ITEM_PICK_UP, "",
		cb_menu_mark_item, (void *)ACT_KIND_ITEM_PICK_UP,
		FLG_NULL,
	},
	{
		"/mark item/open",
		"<Item>",
		'O',
		"",
		N_MSG_MENU_MARK_ITEM_OPEN, "",
		cb_menu_mark_item, (void *)ACT_KIND_ITEM_OPEN,
		FLG_NULL,
	},
	{
		"/mark item/disarm",
		"<Item>",
		'D',
		"",
		N_MSG_MENU_MARK_ITEM_DISARM, "",
		cb_menu_mark_item, (void *)ACT_KIND_ITEM_DISARM,
		FLG_NULL,
	},
	{
		"/mark item/break",
		"<Item>",
		'B',
		"",
		N_MSG_MENU_MARK_ITEM_BREAK, "",
		cb_menu_mark_item, (void *)ACT_KIND_ITEM_BREAK,
		FLG_NULL,
	},
	{
		"/mark item/search",
		"<Item>",
		'S',
		"",
		N_MSG_MENU_MARK_ITEM_CHK, "",
		cb_menu_mark_item, (void *)ACT_KIND_ITEM_CHK,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_mark_door[] = {
	{
		"/mark door",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/mark door/open",
		"<Item>",
		'O',
		"",
		N_MSG_MENU_MARK_DOOR_OPEN, "",
		cb_menu_mark_door, (void *)ACT_KIND_DOOR_OPEN,
		FLG_NULL,
	},
	{
		"/mark door/close",
		"<Item>",
		'C',
		"",
		N_MSG_MENU_MARK_DOOR_CLOSE, "",
		cb_menu_mark_door, (void *)ACT_KIND_DOOR_CLOSE,
		FLG_NULL,
	},
	{
		"/mark door/jamming",
		"<Item>",
		'J',
		"",
		N_MSG_MENU_MARK_DOOR_JAM, "",
		cb_menu_mark_door, (void *)ACT_KIND_DOOR_JAM,
		FLG_NULL,
	},
	{
		"/mark door/disarm",
		"<Item>",
		'D',
		"",
		N_MSG_MENU_MARK_DOOR_DISARM, "",
		cb_menu_mark_door, (void *)ACT_KIND_DOOR_DISARM,
		FLG_NULL,
	},
	{
		"/mark door/break",
		"<Item>",
		'B',
		"",
		N_MSG_MENU_MARK_DOOR_BREAK, "",
		cb_menu_mark_door, (void *)ACT_KIND_DOOR_BREAK,
		FLG_NULL,
	},
	{
		"/mark door/peep",
		"<Item>",
		'P',
		"",
		N_MSG_MENU_MARK_DOOR_PEEP, "",
		cb_menu_mark_door, (void *)ACT_KIND_DOOR_PEEP,
		FLG_NULL,
	},
	{
		"/mark door/search",
		"<Item>",
		'S',
		"",
		N_MSG_MENU_MARK_DOOR_CHK, "",
		cb_menu_mark_door, (void *)ACT_KIND_DOOR_CHK,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_mark_trap[] = {
	{
		"/mark trap",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/mark trap/disarm",
		"<Item>",
		'D',
		"",
		N_MSG_MENU_MARK_TRAP_DISARM, "",
		cb_menu_mark_trap, (void *)ACT_KIND_TRAP_DISARM,
		FLG_NULL,
	},
	{
		"/mark trap/break",
		"<Item>",
		'B',
		"",
		N_MSG_MENU_MARK_TRAP_BREAK, "",
		cb_menu_mark_trap, (void *)ACT_KIND_TRAP_BREAK,
		FLG_NULL,
	},
	{
		"/mark trap/search",
		"<Item>",
		'S',
		"",
		N_MSG_MENU_MARK_TRAP_CHK, "",
		cb_menu_mark_trap, (void *)ACT_KIND_TRAP_CHK,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_item[MBR_ITEM_MAX_N * 2 * MBR_MAX_N];
menu_t	ls_menu_chest[1 + 1 + CHEST_HOLD_MAX_N + 1];

menu_t	ls_menu_item_sel[] = {
	{
		"/item sel",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		cb_menu_item_sel_init, NULL,
		FLG_NULL,
	},
	{
		"/item sel/quaff",
		"<Item>",
		'Q',
		"",
		N_MSG_MENU_ITEM_QUAFF, "",
		cb_menu_item_use, (void *)ACT_KIND_POTION_QUAFF,
		FLG_NULL,
	},
	{
		"/item sel/read",
		"<Item>",
		'R',
		"",
		N_MSG_MENU_ITEM_READ, "",
		cb_menu_item_use, (void *)ACT_KIND_SCROLL_READ,
		FLG_NULL,
	},
	{
		"/item sel/zap",
		"<Item>",
		'Z',
		"",
		N_MSG_MENU_ITEM_ZAP, "",
		cb_menu_item_zap, (void *)ACT_KIND_STICK_ZAP,
		FLG_NULL,
	},
	{
		"/item sel/eat",
		"<Item>",
		'A',
		"",
		N_MSG_MENU_ITEM_EAT, "",
		cb_menu_item_use, (void *)ACT_KIND_FOOD_EAT,
		FLG_NULL,
	},
	{
		"/item sel/smoke",
		"<Item>",
		'K',
		"",
		N_MSG_MENU_ITEM_SMOKE, "",
		cb_menu_item_smoke, (void *)ACT_KIND_EQUIP,
		FLG_NULL,
	},
	{
		"/item sel/dispose",
		"<Item>",
		'P',
		"",
		N_MSG_MENU_ITEM_DISPOSE, "",
		cb_menu_item_use, (void *)ACT_KIND_TOBACCO_DISPOSE,
		FLG_NULL,
	},
	{
		"/item sel/fill lamp",
		"<Item>",
		'F',
		"",
		N_MSG_MENU_ITEM_FILL_LAMP, "",
		cb_menu_item_fill_lamp, (void *)ACT_KIND_POTION_FILL,
		FLG_NULL,
	},
	{
		"/item sel/rub",
		"<Item>",
		'F',
		"",
		N_MSG_MENU_ITEM_RUB, "",
		cb_menu_item_use, (void *)ACT_KIND_LAMP_RUB,
		FLG_NULL,
	},
	{
		"/item sel/equip",
		"<Item>",
		'E',
		"",
		N_MSG_MENU_ITEM_EQUIP, "",
		cb_menu_item_use, (void *)ACT_KIND_EQUIP_SEL,
		FLG_NULL,
	},
	{
		"/item sel/ready throw",
		"<Item>",
		'T',
		"",
		N_MSG_MENU_ITEM_READY_THROW, "",
		cb_menu_item_ready_throw, (void *)ACT_KIND_EQUIP,
		FLG_NULL,
	},
	{
		"/item sel/send",
		"<OpenWinItem>",
		'S',
		"",
		N_MSG_MENU_ITEM_SEND, "",
		cb_menu_item_send, (void *)ACT_KIND_ITEM_SEND,
		FLG_NULL,
	},
	{
		"/item sel/receive",
		"<OpenWinItem>",
		'I',
		"",
		N_MSG_MENU_ITEM_RECEIVE, "",
		cb_menu_item_receive, NULL,
		FLG_NULL,
	},
	{
		"/item sel/put in chest",
		"<OpenWinItem>",
		'U',
		"",
		N_MSG_MENU_ITEM_PUT_IN_CHEST, "",
		cb_menu_item_put_in_chest, NULL,
		FLG_NULL,
	},
	{
		"/item sel/list chest",
		"<OpenWinItem>",
		'L',
		"",
		N_MSG_MENU_ITEM_LS_CHEST, "",
		cb_menu_item_ls_chest, NULL,
		FLG_NULL,
	},
	{
		"/item sel/drop",
		"<OpenWinItem>",
		'D',
		"",
		N_MSG_MENU_ITEM_DROP, "",
		cb_menu_item_drop, (void *)ACT_KIND_ITEM_DROP,
		FLG_NULL,
	},
	{
		"/item sel/alias",
		"<OpenWinItem>",
		'N',
		"",
		N_MSG_MENU_ITEM_ALIAS, "",
		cb_menu_item_alias, (void *)ACT_KIND_NULL,
		FLG_NULL,
	},
	{
		"/item sel/check",
		"<Item>",
		'C',
		"",
		N_MSG_MENU_ITEM_CHK, "",
		cb_menu_item_chk, (void *)ACT_KIND_NULL,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_equip[EQUIP_KIND_MAX_N * 2 * MBR_MAX_N];

menu_t	ls_menu_equip_sel[] = {
	{
		"/equip sel",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		cb_menu_equip_sel_init, NULL,
		FLG_NULL,
	},
	{
		"/equip sel/wear self",
		"<Branch>",
		'W',
		"",
		N_MSG_MENU_EQUIP_WEAR_SELF, "",
		cb_menu_equip_wear_sel_self, NULL,
		FLG_NULL,
	},
	{
		"/equip sel/wear other",
		"<Branch>",
		'E',
		"",
		N_MSG_MENU_EQUIP_WEAR_OTHER, "",
		cb_menu_equip_wear_sel_other, NULL,
		FLG_NULL,
	},
	{
		"/equip sel/take off self",
		"<Item>",
		'T',
		"",
		N_MSG_MENU_EQUIP_TAKE_OFF_SELF, "",
		cb_menu_equip_take_off_self, NULL,
		FLG_NULL,
	},
	{
		"/equip sel/take off other",
		"<Branch>",
		'A',
		"",
		N_MSG_MENU_EQUIP_TAKE_OFF_OTHER, "",
		cb_menu_equip_take_off_other, NULL,
		FLG_NULL,
	},
	{
		"/equip sel/check",
		"<Item>",
		'C',
		"",
		N_MSG_MENU_ITEM_CHK, "",
		cb_menu_item_chk, NULL,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_equip_wear_sel[MBR_ITEM_MAX_N * 2];
menu_t	ls_menu_identify_item[MBR_ITEM_MAX_N * 2 * MBR_MAX_N];
menu_t	ls_menu_resurrection[MBR_ITEM_MAX_N * 2];
menu_t	ls_menu_save_load[MENU_SAVE_LOAD_MAX_N * 2];

#endif	/* MMENU_TAB_H */
