/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2010 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: DemoLastBoss.cpp,v 1.12 2010/01/07 07:22:37 bowkenken Exp $
***************************************************************/

////////////////////////////////////////////////////////////////
// 饹ܥΥǥ
////////////////////////////////////////////////////////////////

#define DEMO_LAST_BOSS_CPP
#include "inc.h"

////////////////////////////////////////////////////////////////

// åȥΥǥ쥯ȥ
#define STR_CUT_IN_DIR_NAME_EXEL	"exel/"
#define STR_CUT_IN_DIR_NAME_EXELER	"exeler/"
#define STR_CUT_IN_DIR_NAME_XEX	"xex/"

static const long nCutInMaxFrame = TIMER_FRAME * 60 / 60;
static const long nCutOutMaxFrame = TIMER_FRAME * 60 / 60;

#ifdef	D_MFC
static const long skipFrameLastBoss = 1;
#else
static const long skipFrameLastBoss = 6;
#endif

////////////////////////////////////////////////////////////////
// 󥹥ȥ饯
////////////////////////////////////////////////////////////////

DemoLastBoss::DemoLastBoss()
{
	frame = 0;
	flagDone = false;
}

////////////////////////////////////////////////////////////////
// ǥȥ饯
////////////////////////////////////////////////////////////////

DemoLastBoss::~DemoLastBoss()
{
}

////////////////////////////////////////////////////////////////
// 
////////////////////////////////////////////////////////////////

void DemoLastBoss::init()
{
	// åȥɤ߹

	CutInExel.init( STR_CUT_IN_DIR_NAME_EXEL );
	CutInExeler.init( STR_CUT_IN_DIR_NAME_EXELER );
	CutInXex.init( STR_CUT_IN_DIR_NAME_XEX );

	CutInExel.setPos( -125, 0, -50, 0 );
	CutInExeler.setPos( +125, 0, +50, 0 );
	CutInXex.setPos( 0, -125, 0, -50 );

	reset();
}

////////////////////////////////////////////////////////////////
// ǥΥꥻå
////////////////////////////////////////////////////////////////

void DemoLastBoss::reset()
{
	switch( get_last_scene() ){
	case LAST_SCENE_N_NULL:
	case LAST_SCENE_N_ENTER:
	case LAST_SCENE_N_ENCOUNTER:
	case LAST_SCENE_N_ENCOUNTER_CUT_IN:
	//case LAST_SCENE_N_ENCOUNTER_WORDS:
	case LAST_SCENE_N_ENCOUNTER_CUT_OUT:
	case LAST_SCENE_N_ENCOUNTER_CUT_END:
	case LAST_SCENE_N_EXEL:
	case LAST_SCENE_N_EXEL_ENTER:
	case LAST_SCENE_N_EXEL_CUT_IN:
	//case LAST_SCENE_N_EXEL_WORDS:
	case LAST_SCENE_N_EXEL_CUT_OUT:
	case LAST_SCENE_N_EXEL_CUT_END:
	case LAST_SCENE_N_EXEL_HYPER:
	case LAST_SCENE_N_EXEL_BATTLE:
	//case LAST_SCENE_N_EXEL_DIE:
	case LAST_SCENE_N_EXELER:
	case LAST_SCENE_N_EXELER_CUT_IN:
	//case LAST_SCENE_N_EXELER_WORDS:
	case LAST_SCENE_N_EXELER_CUT_OUT:
	case LAST_SCENE_N_EXELER_CUT_END:
	case LAST_SCENE_N_EXELER_ENTER:
	case LAST_SCENE_N_EXELER_HYPER:
	case LAST_SCENE_N_EXELER_BATTLE:
	//case LAST_SCENE_N_EXELER_DIE:
	case LAST_SCENE_N_XEX:
	case LAST_SCENE_N_XEX_CUT_IN:
	//case LAST_SCENE_N_XEX_WORDS:
	case LAST_SCENE_N_XEX_CUT_OUT:
	case LAST_SCENE_N_XEX_CUT_END:
	case LAST_SCENE_N_XX_ENTER:
	case LAST_SCENE_N_XX_WORDS:
	case LAST_SCENE_N_XX_BATTLE:
	case LAST_SCENE_N_XX_DIE:
	case LAST_SCENE_N_END:
	case LAST_SCENE_N_MAX_N:
		frame = 0;
		break;
	case LAST_SCENE_N_ENCOUNTER_WORDS:
	case LAST_SCENE_N_EXEL_WORDS:
	case LAST_SCENE_N_EXEL_DIE:
	case LAST_SCENE_N_EXELER_WORDS:
	case LAST_SCENE_N_EXELER_DIE:
	case LAST_SCENE_N_XEX_WORDS:
		frame = nCutInMaxFrame;
		break;
	}

	flagDone = false;
}

////////////////////////////////////////////////////////////////
// ǥ
// return : 褬λ?
////////////////////////////////////////////////////////////////

bool DemoLastBoss::draw()
{
	// 1 ٤¹Ԥʤɬ true ֤
	bool flag = true;

	switch( get_last_scene() ){
	case LAST_SCENE_N_NULL:
	case LAST_SCENE_N_ENTER:
	case LAST_SCENE_N_ENCOUNTER:
		break;
	case LAST_SCENE_N_ENCOUNTER_CUT_IN:
		flag = drawCutIn( true, true, true );
		break;
	case LAST_SCENE_N_ENCOUNTER_WORDS:
		drawCutIn( true, true, true );
		break;
	case LAST_SCENE_N_ENCOUNTER_CUT_OUT:
		flag = drawCutOut( true, true, true );
		break;
	case LAST_SCENE_N_ENCOUNTER_CUT_END:
	case LAST_SCENE_N_EXEL:
	case LAST_SCENE_N_EXEL_ENTER:
		break;
	case LAST_SCENE_N_EXEL_CUT_IN:
		flag = drawCutIn( true, false, false );
		break;
	case LAST_SCENE_N_EXEL_WORDS:
		drawCutIn( true, false, false );
		break;
	case LAST_SCENE_N_EXEL_CUT_OUT:
		flag = drawCutOut( true, false, false );
		break;
	case LAST_SCENE_N_EXEL_CUT_END:
	case LAST_SCENE_N_EXEL_HYPER:
	case LAST_SCENE_N_EXEL_BATTLE:
	case LAST_SCENE_N_EXEL_DIE:
	case LAST_SCENE_N_EXELER:
		break;
	case LAST_SCENE_N_EXELER_CUT_IN:
		flag = drawCutIn( false, true, false );
		break;
	case LAST_SCENE_N_EXELER_WORDS:
		drawCutIn( false, true, false );
		break;
	case LAST_SCENE_N_EXELER_CUT_OUT:
		flag = drawCutOut( false, true, false );
		break;
	case LAST_SCENE_N_EXELER_CUT_END:
	case LAST_SCENE_N_EXELER_ENTER:
	case LAST_SCENE_N_EXELER_HYPER:
	case LAST_SCENE_N_EXELER_BATTLE:
	case LAST_SCENE_N_EXELER_DIE:
	case LAST_SCENE_N_XEX:
		break;
	case LAST_SCENE_N_XEX_CUT_IN:
		flag = drawCutIn( false, false, true );
		break;
	case LAST_SCENE_N_XEX_WORDS:
		drawCutIn( false, false, true );
		break;
	case LAST_SCENE_N_XEX_CUT_OUT:
		flag = drawCutOut( false, false, true );
		break;
	case LAST_SCENE_N_XEX_CUT_END:
	case LAST_SCENE_N_XX_ENTER:
	case LAST_SCENE_N_XX_WORDS:
	case LAST_SCENE_N_XX_BATTLE:
	case LAST_SCENE_N_XX_DIE:
		break;
	case LAST_SCENE_N_END:
	case LAST_SCENE_N_MAX_N:
		break;
	}

	flagDone = flag;
	return flagDone;
}

////////////////////////////////////////////////////////////////
// åȥ
// return : 褬λ?
////////////////////////////////////////////////////////////////

bool DemoLastBoss::drawCutIn(
	bool flagExel, bool flagExeler, bool flagXex
)
{
	if( flagExel )
		CutInExel.drawCutIn( frame, nCutInMaxFrame );
	if( flagExeler )
		CutInExeler.drawCutIn( frame, nCutInMaxFrame );
	if( flagXex )
		CutInXex.drawCutIn( frame, nCutInMaxFrame );

	return incFrame( nCutInMaxFrame );
}

////////////////////////////////////////////////////////////////
// åȥȤ
// return : 褬λ?
////////////////////////////////////////////////////////////////

bool DemoLastBoss::drawCutOut(
	bool flagExel, bool flagExeler, bool flagXex
)
{
	if( flagExel )
		CutInExel.drawCutOut( frame, nCutOutMaxFrame );
	if( flagExeler )
		CutInExeler.drawCutOut( frame, nCutOutMaxFrame );
	if( flagXex )
		CutInXex.drawCutOut( frame, nCutOutMaxFrame );

	return incFrame( nCutOutMaxFrame );
}

////////////////////////////////////////////////////////////////
// ե졼ʤ
// long maxFrame : ǸΥե졼
// return : ǸΥե졼ã?
////////////////////////////////////////////////////////////////

bool DemoLastBoss::incFrame( long maxFrame )
{
	frame++;

	if( frame > maxFrame ){
		frame = maxFrame;
		return true;
	} else {
		return false;
	}
}

////////////////////////////////////////////////////////////////
// ե졼ְĴ٤
// return : ְ?
////////////////////////////////////////////////////////////////

bool DemoLastBoss::checkSkipFrame()
{
	switch( get_last_scene() ){
	case LAST_SCENE_N_NULL:
	case LAST_SCENE_N_ENTER:
	case LAST_SCENE_N_ENCOUNTER:
	case LAST_SCENE_N_ENCOUNTER_CUT_IN:
	//case LAST_SCENE_N_ENCOUNTER_WORDS:
	case LAST_SCENE_N_ENCOUNTER_CUT_OUT:
	case LAST_SCENE_N_ENCOUNTER_CUT_END:
	case LAST_SCENE_N_EXEL:
	case LAST_SCENE_N_EXEL_ENTER:
	case LAST_SCENE_N_EXEL_CUT_IN:
	//case LAST_SCENE_N_EXEL_WORDS:
	case LAST_SCENE_N_EXEL_CUT_OUT:
	case LAST_SCENE_N_EXEL_CUT_END:
	case LAST_SCENE_N_EXEL_HYPER:
	case LAST_SCENE_N_EXEL_BATTLE:
	//case LAST_SCENE_N_EXEL_DIE:
	case LAST_SCENE_N_EXELER:
	case LAST_SCENE_N_EXELER_CUT_IN:
	//case LAST_SCENE_N_EXELER_WORDS:
	case LAST_SCENE_N_EXELER_CUT_OUT:
	case LAST_SCENE_N_EXELER_CUT_END:
	case LAST_SCENE_N_EXELER_ENTER:
	case LAST_SCENE_N_EXELER_HYPER:
	case LAST_SCENE_N_EXELER_BATTLE:
	//case LAST_SCENE_N_EXELER_DIE:
	case LAST_SCENE_N_XEX:
	case LAST_SCENE_N_XEX_CUT_IN:
	//case LAST_SCENE_N_XEX_WORDS:
	case LAST_SCENE_N_XEX_CUT_OUT:
	case LAST_SCENE_N_XEX_CUT_END:
	case LAST_SCENE_N_XX_ENTER:
	case LAST_SCENE_N_XX_WORDS:
	case LAST_SCENE_N_XX_BATTLE:
	case LAST_SCENE_N_XX_DIE:
	case LAST_SCENE_N_END:
	case LAST_SCENE_N_MAX_N:
		break;
	case LAST_SCENE_N_ENCOUNTER_WORDS:
	case LAST_SCENE_N_EXEL_WORDS:
	case LAST_SCENE_N_EXEL_DIE:
	case LAST_SCENE_N_EXELER_WORDS:
	case LAST_SCENE_N_EXELER_DIE:
	case LAST_SCENE_N_XEX_WORDS:
		if( (frame % skipFrameLastBoss) != 0 )
			return true;
		else
			return false;
		break;
	}
	return false;
}

////////////////////////////////////////////////////////////////
// ǥ褬λĴ٤
// return : ǥ褬λ?
////////////////////////////////////////////////////////////////

bool DemoLastBoss::checkDone()
{
	switch( get_last_scene() ){
	case LAST_SCENE_N_NULL:
	case LAST_SCENE_N_ENTER:
	case LAST_SCENE_N_ENCOUNTER:
	//case LAST_SCENE_N_ENCOUNTER_CUT_IN:
	case LAST_SCENE_N_ENCOUNTER_WORDS:
	//case LAST_SCENE_N_ENCOUNTER_CUT_OUT:
	case LAST_SCENE_N_ENCOUNTER_CUT_END:
	case LAST_SCENE_N_EXEL:
	case LAST_SCENE_N_EXEL_ENTER:
	//case LAST_SCENE_N_EXEL_CUT_IN:
	case LAST_SCENE_N_EXEL_WORDS:
	//case LAST_SCENE_N_EXEL_CUT_OUT:
	case LAST_SCENE_N_EXEL_CUT_END:
	case LAST_SCENE_N_EXEL_HYPER:
	case LAST_SCENE_N_EXEL_BATTLE:
	case LAST_SCENE_N_EXEL_DIE:
	case LAST_SCENE_N_EXELER:
	//case LAST_SCENE_N_EXELER_CUT_IN:
	case LAST_SCENE_N_EXELER_WORDS:
	//case LAST_SCENE_N_EXELER_CUT_OUT:
	case LAST_SCENE_N_EXELER_CUT_END:
	case LAST_SCENE_N_EXELER_ENTER:
	case LAST_SCENE_N_EXELER_HYPER:
	case LAST_SCENE_N_EXELER_BATTLE:
	case LAST_SCENE_N_EXELER_DIE:
	case LAST_SCENE_N_XEX:
	//case LAST_SCENE_N_XEX_CUT_IN:
	case LAST_SCENE_N_XEX_WORDS:
	//case LAST_SCENE_N_XEX_CUT_OUT:
	case LAST_SCENE_N_XEX_CUT_END:
	case LAST_SCENE_N_XX_ENTER:
	case LAST_SCENE_N_XX_WORDS:
	case LAST_SCENE_N_XX_BATTLE:
	case LAST_SCENE_N_XX_DIE:
	case LAST_SCENE_N_END:
	case LAST_SCENE_N_MAX_N:
		flagDone = true;
		break;
	case LAST_SCENE_N_ENCOUNTER_CUT_IN:
	case LAST_SCENE_N_ENCOUNTER_CUT_OUT:
	case LAST_SCENE_N_EXEL_CUT_IN:
	case LAST_SCENE_N_EXEL_CUT_OUT:
	case LAST_SCENE_N_EXELER_CUT_IN:
	case LAST_SCENE_N_EXELER_CUT_OUT:
	case LAST_SCENE_N_XEX_CUT_IN:
	case LAST_SCENE_N_XEX_CUT_OUT:
		break;
	}

	return flagDone;
}
