/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2010 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: GameJoystick.h,v 1.7 2010/01/07 07:22:37 bowkenken Exp $
***************************************************************/

#ifndef GAME_JOYSTICK_H
#define GAME_JOYSTICK_H

////////////////////////////////////////////////////////////////
// 祤ƥåδ
////////////////////////////////////////////////////////////////

#ifdef	HAVE_SDL_SDL_H
# include <SDL/SDL.h>
#endif

#include "joy-kind.h"

////////////////////////////////////////////////////////////////

class GameJoystick {
private:
#ifdef	HAVE_SDL_SDL_H
	SDL_Joystick *joystick;
#endif

	long nCurrentJoystick;
	joy_kind_t joyKind;

	long nMoveX, nMoveY;
	long nMoveCountX, nMoveCountY;
	long nScrollX, nScrollY;
	long nScrollCountX, nScrollCountY;

	bool flagContExecA, flagContExecB;

public:

public:
	GameJoystick();
	~GameJoystick();
	void init();

	void openJoy();
	void closeJoy();

	long getJoy();
	void selJoy( long n );

	const char *getName( long n );

	joy_kind_t getKind();
	void setKind( joy_kind_t kind );

	void checkEvent();

private:
	void joyAxis( long axis, long n );
	void joyMoveX( long n );
	void joyMoveY( long n );
	void joyScrollX( long n );
	void joyScrollY( long n );

	void joyHat( long n );

	void joyButtonOn( long n );
	void joyButtonOff( long n );

	void joyRepeat();
	void joyMoveRepeat();
	void joyScrollRepeat();
	void joyButtonRepeat();
};

#endif // GAME_JOYSTICK_H
